<?php
/**
 * @copyright	Copyright (C) 2025. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - http://www.template-creator.com - http://www.joomlack.fr
 */
 
defined('_JEXEC') or die('Restricted access');

use Joomla\CMS\Factory;
use Joomla\CMS\Installer\Installer;
use Joomla\CMS\Installer\InstallerAdapter;
use Joomla\CMS\Installer\InstallerScriptInterface;
use Joomla\CMS\Language\Text;

/*
preflight which is executed before install and update
install
update
uninstall
postflight which is executed after install and update
*/

if (version_compare(JVERSION, 6, '>=')) {
	return new class () implements InstallerScriptInterface {

		public function install(InstallerAdapter $adapter): bool
		{
			// not used
			return true;
		}

		public function update(InstallerAdapter $adapter): bool
		{
			// not used
			return true;
		}

		public function uninstall(InstallerAdapter $adapter): bool
		{
			// not used
			return true;
		}

		public function preflight(string $type, InstallerAdapter $adapter): bool
		{
			return CK_installer_preflight($type, $adapter);
		}

		public function postflight(string $type, InstallerAdapter $adapter): bool
		{
			// not used
			return true;
		}
	};

} else {
	class plgSystemScrolltockInstallerScript {

		function install($parent) {
			// not used
			return true;
		}
		
		function update($parent) {
			// not used
			return true;
		}

		function uninstall($parent) {
			// not used
			return true;
		}

		function preflight($type, $parent) {
			return CK_installer_preflight($type, $parent);
		}

		// run on install and update
		function postflight($type, $parent) {
			// not used
			return true;
		}
	}
}

function CK_installer_preflight($type, $adapter) {
	// disable the install on Joomla 3
	if (version_compare(JVERSION, '4', '<')) {
		throw new RuntimeException('This version of Scroll to CK can not be installed on Joomla 3. Please use the version 1.4.2.');
		// Factory::getApplication()->enqueueMessage('This version of Scroll to CK can not be installed on Joomla 3. Please use the version 1.4.2.', 'error');
		return false;
	}

	return true;
}

