/**ABDB**/CREATE TABLE `#__action_log_config` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `id_holder` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `title_holder` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `table_name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `text_prefix` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=24 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__action_log_config`  VALUES 
('1', 'article', 'com_content.article', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
('2', 'article', 'com_content.form', 'id', 'title', '#__content', 'PLG_ACTIONLOG_JOOMLA'),
('3', 'banner', 'com_banners.banner', 'id', 'name', '#__banners', 'PLG_ACTIONLOG_JOOMLA'),
('4', 'user_note', 'com_users.note', 'id', 'subject', '#__user_notes', 'PLG_ACTIONLOG_JOOMLA'),
('5', 'media', 'com_media.file', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
('6', 'category', 'com_categories.category', 'id', 'title', '#__categories', 'PLG_ACTIONLOG_JOOMLA'),
('7', 'menu', 'com_menus.menu', 'id', 'title', '#__menu_types', 'PLG_ACTIONLOG_JOOMLA'),
('8', 'menu_item', 'com_menus.item', 'id', 'title', '#__menu', 'PLG_ACTIONLOG_JOOMLA'),
('9', 'newsfeed', 'com_newsfeeds.newsfeed', 'id', 'name', '#__newsfeeds', 'PLG_ACTIONLOG_JOOMLA'),
('10', 'link', 'com_redirect.link', 'id', 'old_url', '#__redirect_links', 'PLG_ACTIONLOG_JOOMLA'),
('11', 'tag', 'com_tags.tag', 'id', 'title', '#__tags', 'PLG_ACTIONLOG_JOOMLA'),
('12', 'style', 'com_templates.style', 'id', 'title', '#__template_styles', 'PLG_ACTIONLOG_JOOMLA'),
('13', 'plugin', 'com_plugins.plugin', 'extension_id', 'name', '#__extensions', 'PLG_ACTIONLOG_JOOMLA'),
('14', 'component_config', 'com_config.component', 'extension_id', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
('15', 'contact', 'com_contact.contact', 'id', 'name', '#__contact_details', 'PLG_ACTIONLOG_JOOMLA'),
('16', 'module', 'com_modules.module', 'id', 'title', '#__modules', 'PLG_ACTIONLOG_JOOMLA'),
('17', 'access_level', 'com_users.level', 'id', 'title', '#__viewlevels', 'PLG_ACTIONLOG_JOOMLA'),
('18', 'banner_client', 'com_banners.client', 'id', 'name', '#__banner_clients', 'PLG_ACTIONLOG_JOOMLA'),
('19', 'application_config', 'com_config.application', '', 'name', '', 'PLG_ACTIONLOG_JOOMLA'),
('20', 'task', 'com_scheduler.task', 'id', 'title', '#__scheduler_tasks', 'PLG_ACTIONLOG_JOOMLA'),
('21', 'field', 'com_fields.field', 'id', 'title', '#__fields', 'PLG_ACTIONLOG_JOOMLA'),
('22', 'guidedtour', 'com_guidedtours.state', 'id', 'title', '#__guidedtours', 'PLG_ACTIONLOG_JOOMLA'),
('23', 'contact', 'com_contact.form', 'id', 'name', '#__contact_details', 'PLG_ACTIONLOG_JOOMLA');
/**ABDB**/CREATE TABLE `#__action_logs` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `message_language_key` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `message` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `log_date` datetime NOT NULL,
  `extension` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `user_id` int NOT NULL DEFAULT '0',
  `item_id` int NOT NULL DEFAULT '0',
  `ip_address` varchar(40) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '0.0.0.0',
  PRIMARY KEY (`id`),
  KEY `idx_user_id` (`user_id`),
  KEY `idx_user_id_logdate` (`user_id`,`log_date`),
  KEY `idx_user_id_extension` (`user_id`,`extension`),
  KEY `idx_extension_item_id` (`extension`,`item_id`)
) ENGINE=InnoDB AUTO_INCREMENT=996 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__action_logs_extensions` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `extension` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=23 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__action_logs_extensions`  VALUES 
('1', 'com_banners'),
('2', 'com_cache'),
('3', 'com_categories'),
('4', 'com_config'),
('5', 'com_contact'),
('6', 'com_content'),
('7', 'com_installer'),
('8', 'com_media'),
('9', 'com_menus'),
('10', 'com_messages'),
('11', 'com_modules'),
('12', 'com_newsfeeds'),
('13', 'com_plugins'),
('14', 'com_redirect'),
('15', 'com_tags'),
('16', 'com_templates'),
('17', 'com_users'),
('18', 'com_checkin'),
('19', 'com_scheduler'),
('20', 'com_fields'),
('21', 'com_guidedtours'),
('22', 'com_rsform');
/**ABDB**/CREATE TABLE `#__action_logs_users` (
  `user_id` int unsigned NOT NULL,
  `notify` tinyint unsigned NOT NULL,
  `extensions` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`user_id`),
  KEY `idx_notify` (`notify`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__akeeba_common` (
  `key` varchar(190) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `value` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  PRIMARY KEY (`key`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__akeeba_common`  VALUES 
('stats_lastrun', '1755349234'),
('stats_siteid', 'aa62193692f9ef256132d53eb94bf536a4dc9790'),
('stats_siteurl', '07d09f5473bdeba90537cd08863006d6');
/**ABDB**/CREATE TABLE `#__akeebabackup_backups` (
  `id` bigint unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `comment` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `backupstart` timestamp NULL DEFAULT NULL,
  `backupend` timestamp NULL DEFAULT NULL,
  `status` enum('run','fail','complete') COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'run',
  `origin` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'backend',
  `type` varchar(30) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT 'full',
  `profile_id` bigint NOT NULL DEFAULT '1',
  `archivename` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `absolute_path` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `multipart` int NOT NULL DEFAULT '0',
  `tag` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `backupid` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `filesexist` tinyint NOT NULL DEFAULT '1',
  `remote_filename` varchar(1000) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `total_size` bigint NOT NULL DEFAULT '0',
  `frozen` tinyint(1) NOT NULL DEFAULT '0',
  `instep` tinyint(1) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_fullstatus` (`filesexist`,`status`),
  KEY `idx_stale` (`status`,`origin`)
) ENGINE=InnoDB AUTO_INCREMENT=20 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__akeebabackup_backups`  VALUES 
('1', 'Backup taken on Saturday, 16 August 2025 15:00 SAST', 'Before starting dev', '2025-08-16 13:00:43', '2025-08-16 13:01:06', 'complete', 'backend', 'full', '1', 'musoya-20250816-150043.zip', '/var/www/html/webbackups/musoya-20250816-150043.zip', '0', 'backend', 'id-20250816-130043-424003', '0', NULL, '52537289', '0', '1'),
('2', 'Backup taken on Friday, 22 August 2025 19:01 SAST', 'Before updates and more dev', '2025-08-22 17:01:25', '2025-08-22 17:01:49', 'complete', 'backend', 'full', '1', 'musoya-20250822-190125.zip', '/var/www/html/webbackups/musoya-20250822-190125.zip', '0', 'backend', 'id-20250822-170125-495347', '0', NULL, '59081318', '0', '1'),
('3', 'Backup taken on Sunday, 24 August 2025 11:12 SAST', 'Before more dev', '2025-08-24 09:13:06', '2025-08-24 09:13:39', 'complete', 'backend', 'full', '1', 'musoya-20250824-111306.zip', '/var/www/html/webbackups/musoya-20250824-111306.zip', '0', 'backend', 'id-20250824-091306-375926', '0', NULL, '60483534', '0', '1'),
('4', 'Backup taken on Tuesday, 26 August 2025 14:05 SAST', 'Before more dev', '2025-08-26 12:05:34', '2025-08-26 12:06:03', 'complete', 'backend', 'full', '1', 'musoya-20250826-140534.zip', '/var/www/html/webbackups/musoya-20250826-140534.zip', '0', 'backend', 'id-20250826-120534-765111', '0', NULL, '63662508', '0', '1'),
('5', 'Backup taken on Saturday, 06 September 2025 09:56 SAST', 'Before more dev', '2025-09-06 07:57:01', '2025-09-06 07:57:37', 'complete', 'backend', 'full', '1', 'musoya-20250906-095701.zip', '/var/www/html/webbackups/musoya-20250906-095701.zip', '0', 'backend', 'id-20250906-075701-545159', '0', NULL, '63663250', '0', '1'),
('6', 'Backup taken on Saturday, 13 September 2025 14:04 SAST', 'Before updates', '2025-09-13 12:04:27', '2025-09-13 12:05:05', 'complete', 'backend', 'full', '1', 'musoya-20250913-140427.zip', '/var/www/html/webbackups/musoya-20250913-140427.zip', '0', 'backend', 'id-20250913-120427-459907', '0', NULL, '63848750', '0', '1'),
('7', 'Backup taken on Saturday, 20 September 2025 10:16 SAST', 'Before more dev', '2025-09-20 08:16:25', '2025-09-20 08:17:04', 'complete', 'backend', 'full', '1', 'musoya-20250920-101625.zip', '/var/www/html/webbackups/musoya-20250920-101625.zip', '0', 'backend', 'id-20250920-081625-164', '0', NULL, '64014113', '0', '1'),
('8', 'Backup taken on Sunday, 21 September 2025 11:05 SAST', 'After some dev', '2025-09-21 09:06:01', '2025-09-21 09:06:30', 'complete', 'backend', 'full', '1', 'musoya-20250921-110601.zip', '/var/www/html/webbackups/musoya-20250921-110601.zip', '0', 'backend', 'id-20250921-090601-178363', '0', NULL, '70309072', '0', '1'),
('9', 'Backup taken on Sunday, 21 September 2025 11:10 SAST', 'After dev', '2025-09-21 09:10:24', '2025-09-21 09:10:56', 'complete', 'backend', 'full', '1', 'musoya-20250921-111024.zip', '/var/www/html/webbackups/musoya-20250921-111024.zip', '0', 'backend', 'id-20250921-091024-772197', '0', NULL, '70392974', '0', '1'),
('10', 'Backup taken on Monday, 22 September 2025 09:16 SAST', 'Before presso ', '2025-09-22 07:17:03', '2025-09-22 07:17:33', 'complete', 'backend', 'full', '1', 'musoya-20250922-091703.zip', '/var/www/html/webbackups/musoya-20250922-091703.zip', '0', 'backend', 'id-20250922-071703-332286', '0', NULL, '70393059', '0', '1'),
('11', 'Backup taken on Monday, 29 September 2025 11:11 SAST', 'Before more dev', '2025-09-29 09:11:53', '2025-09-29 09:12:23', 'complete', 'backend', 'full', '1', 'musoya-20250929-111153.zip', '/var/www/html/webbackups/musoya-20250929-111153.zip', '0', 'backend', 'id-20250929-091153-463372', '0', NULL, '70394045', '0', '1'),
('12', 'Backup taken on Tuesday, 30 September 2025 09:10 SAST', 'Before more dev', '2025-09-30 07:10:39', '2025-09-30 07:11:08', 'complete', 'backend', 'full', '1', 'musoya-20250930-091039.zip', '/var/www/html/webbackups/musoya-20250930-091039.zip', '0', 'backend', 'id-20250930-071039-306797', '0', NULL, '70563839', '0', '1'),
('13', 'Backup taken on Tuesday, 30 September 2025 10:16 SAST', 'Before more dev', '2025-09-30 08:16:10', '2025-09-30 08:16:40', 'complete', 'backend', 'full', '1', 'musoya-20250930-101610.zip', '/var/www/html/webbackups/musoya-20250930-101610.zip', '0', 'backend', 'id-20250930-081610-152643', '0', NULL, '70579888', '0', '1'),
('14', 'Backup taken on Friday, 03 October 2025 11:23 SAST', 'Before updates and taking shop off', '2025-10-03 09:23:54', '2025-10-03 09:24:31', 'complete', 'backend', 'full', '1', 'musoya-20251003-112354.zip', '/var/www/html/webbackups/musoya-20251003-112354.zip', '0', 'backend', 'id-20251003-092354-372914', '1', NULL, '70437341', '0', '1'),
('15', 'Backup taken on Friday, 10 October 2025 19:02 SAST', 'Before updates', '2025-10-10 17:02:57', '2025-10-10 17:03:35', 'complete', 'backend', 'full', '1', 'musoya-20251010-190257.zip', '/var/www/html/webbackups/musoya-20251010-190257.zip', '0', 'backend', 'id-20251010-170257-833584', '1', NULL, '71040256', '0', '1'),
('16', 'Backup taken on Wednesday, 15 October 2025 13:13 SAST', 'Before more dev', '2025-10-15 11:13:16', '2025-10-15 11:13:49', 'complete', 'backend', 'full', '1', 'musoya-20251015-131316.zip', '/var/www/html/webbackups/musoya-20251015-131316.zip', '0', 'backend', 'id-20251015-111316-320639', '1', NULL, '71198336', '0', '1'),
('17', 'Backup taken on Sunday, 02 November 2025 13:07 SAST', 'Before updates and more dev', '2025-11-02 11:07:32', '2025-11-02 11:08:01', 'complete', 'backend', 'full', '1', 'musoya-20251102-130732.zip', '/var/www/html/webbackups/musoya-20251102-130732.zip', '0', 'backend', 'id-20251102-110731-998750', '1', NULL, '71198717', '0', '1'),
('18', 'Backup taken on Sunday, 02 November 2025 13:12 SAST', 'Before dev changes', '2025-11-02 11:12:17', '2025-11-02 11:12:52', 'complete', 'backend', 'full', '1', 'musoya-20251102-131217.zip', '/var/www/html/webbackups/musoya-20251102-131217.zip', '0', 'backend', 'id-20251102-111217-938129', '1', NULL, '72070807', '0', '1'),
('19', 'Backup taken on Thursday, 20 November 2025 09:58 SAST', 'Before updates', '2025-11-20 07:58:25', '2025-11-20 07:58:26', 'complete', 'backend', 'full', '1', 'musoya-20251120-095825.zip', '/var/www/html/webbackups/musoya-20251120-095825.zip', '0', 'backend', 'id-20251120-075825-224467', '1', NULL, '0', '0', '1');
/**ABDB**/CREATE TABLE `#__akeebabackup_profiles` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `description` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `configuration` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `filters` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `quickicon` tinyint NOT NULL DEFAULT '1',
  `access` int DEFAULT '1',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=2 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__akeebabackup_profiles`  VALUES 
('1', 'Musoya Backup', '###AES128###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', '', '1', '1');
/**ABDB**/CREATE TABLE `#__akeebabackup_storage` (
  `tag` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `lastupdate` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
  `data` longtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  PRIMARY KEY (`tag`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__assets` (
  `id` int unsigned NOT NULL AUTO_INCREMENT COMMENT 'Primary Key',
  `parent_id` int NOT NULL DEFAULT '0' COMMENT 'Nested set parent.',
  `lft` int NOT NULL DEFAULT '0' COMMENT 'Nested set lft.',
  `rgt` int NOT NULL DEFAULT '0' COMMENT 'Nested set rgt.',
  `level` int unsigned NOT NULL COMMENT 'The cached level in the nested tree.',
  `name` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The unique name for the asset.',
  `title` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The descriptive title for the asset.',
  `rules` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'JSON encoded access control.',
  PRIMARY KEY (`id`),
  UNIQUE KEY `idx_asset_name` (`name`),
  KEY `idx_lft_rgt` (`lft`,`rgt`),
  KEY `idx_parent_id` (`parent_id`)
) ENGINE=InnoDB AUTO_INCREMENT=142 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__assets`  VALUES 
('1', '0', '0', '265', '0', 'root.1', 'Root Asset', '{\"core.login.site\":{\"6\":1,\"2\":1},\"core.login.admin\":{\"6\":1},\"core.login.api\":{\"8\":1},\"core.login.offline\":{\"6\":1},\"core.admin\":{\"8\":1},\"core.manage\":{\"7\":1},\"core.create\":{\"6\":1,\"3\":1},\"core.delete\":{\"6\":1},\"core.edit\":{\"6\":1,\"4\":1},\"core.edit.state\":{\"6\":1,\"5\":1},\"core.edit.own\":{\"6\":1,\"3\":1}}'),
('2', '1', '1', '2', '1', 'com_admin', 'com_admin', '{}'),
('3', '1', '3', '6', '1', 'com_banners', 'com_banners', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('4', '1', '7', '8', '1', 'com_cache', 'com_cache', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
('5', '1', '9', '10', '1', 'com_checkin', 'com_checkin', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
('6', '1', '11', '12', '1', 'com_config', 'com_config', '{}'),
('7', '1', '13', '16', '1', 'com_contact', 'com_contact', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('8', '1', '17', '60', '1', 'com_content', 'com_content', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.edit\":{\"4\":1},\"core.edit.state\":{\"5\":1},\"core.execute.transition\":{\"6\":1,\"5\":1}}'),
('9', '1', '61', '62', '1', 'com_cpanel', 'com_cpanel', '{}'),
('10', '1', '63', '64', '1', 'com_installer', 'com_installer', '{\"core.manage\":{\"7\":0},\"core.delete\":{\"7\":0},\"core.edit.state\":{\"7\":0}}'),
('11', '1', '65', '68', '1', 'com_languages', 'com_languages', '{\"core.admin\":{\"7\":1}}'),
('12', '11', '66', '67', '2', 'com_languages.language.1', 'English (en-GB)', '{}'),
('13', '1', '69', '70', '1', 'com_login', 'com_login', '{}'),
('14', '1', '71', '72', '1', 'com_mails', 'com_mails', '{}'),
('15', '1', '73', '74', '1', 'com_media', 'com_media', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1},\"core.create\":{\"3\":1},\"core.delete\":{\"5\":1}}'),
('16', '1', '75', '80', '1', 'com_menus', 'com_menus', '{\"core.admin\":{\"7\":1}}'),
('17', '1', '81', '82', '1', 'com_messages', 'com_messages', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"7\":1}}'),
('18', '1', '83', '200', '1', 'com_modules', 'com_modules', '{\"core.admin\":{\"7\":1}}'),
('19', '1', '201', '204', '1', 'com_newsfeeds', 'com_newsfeeds', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('20', '1', '205', '206', '1', 'com_plugins', 'com_plugins', '{\"core.admin\":{\"7\":1}}'),
('21', '1', '207', '208', '1', 'com_redirect', 'com_redirect', '{\"core.admin\":{\"7\":1}}'),
('23', '1', '209', '210', '1', 'com_templates', 'com_templates', '{\"core.admin\":{\"7\":1}}'),
('24', '1', '215', '218', '1', 'com_users', 'com_users', '{\"core.admin\":{\"7\":1}}'),
('26', '1', '219', '220', '1', 'com_wrapper', 'com_wrapper', '{}'),
('27', '8', '18', '35', '2', 'com_content.category.2', 'General', '{}'),
('28', '3', '4', '5', '2', 'com_banners.category.3', 'Uncategorised', '{}'),
('29', '7', '14', '15', '2', 'com_contact.category.4', 'Uncategorised', '{}'),
('30', '19', '202', '203', '2', 'com_newsfeeds.category.5', 'Uncategorised', '{}'),
('32', '24', '216', '217', '2', 'com_users.category.7', 'Uncategorised', '{}'),
('33', '1', '221', '222', '1', 'com_finder', 'com_finder', '{\"core.admin\":{\"7\":1},\"core.manage\":{\"6\":1}}'),
('34', '1', '223', '224', '1', 'com_joomlaupdate', 'com_joomlaupdate', '{}'),
('35', '1', '225', '226', '1', 'com_tags', 'com_tags', '{}'),
('36', '1', '227', '228', '1', 'com_contenthistory', 'com_contenthistory', '{}'),
('37', '1', '229', '230', '1', 'com_ajax', 'com_ajax', '{}'),
('38', '1', '231', '232', '1', 'com_postinstall', 'com_postinstall', '{}'),
('39', '18', '84', '85', '2', 'com_modules.module.1', 'Main Menu', '{}'),
('40', '18', '86', '87', '2', 'com_modules.module.2', 'Login', '{}'),
('41', '18', '88', '89', '2', 'com_modules.module.3', 'Popular Articles', '{}'),
('42', '18', '90', '91', '2', 'com_modules.module.4', 'Recently Added Articles', '{}'),
('43', '18', '92', '93', '2', 'com_modules.module.8', 'Toolbar', '{}'),
('44', '18', '94', '95', '2', 'com_modules.module.9', 'Notifications', '{}'),
('45', '18', '96', '97', '2', 'com_modules.module.10', 'Logged-in Users', '{}'),
('46', '18', '98', '99', '2', 'com_modules.module.12', 'Admin Menu', '{}'),
('49', '18', '104', '105', '2', 'com_modules.module.15', 'Title', '{}'),
('50', '18', '106', '107', '2', 'com_modules.module.16', 'Login Form', '{}'),
('51', '18', '108', '109', '2', 'com_modules.module.17', 'Breadcrumbs', '{}'),
('52', '18', '110', '111', '2', 'com_modules.module.79', 'Multilanguage status', '{}'),
('53', '18', '114', '115', '2', 'com_modules.module.86', 'Joomla Version', '{}'),
('54', '16', '76', '77', '2', 'com_menus.menu.1', 'Main Menu', '{}'),
('55', '18', '118', '119', '2', 'com_modules.module.87', 'Sample Data', '{}'),
('56', '8', '36', '53', '2', 'com_content.workflow.1', 'COM_WORKFLOW_BASIC_WORKFLOW', '{}'),
('57', '56', '37', '38', '3', 'com_content.stage.1', 'COM_WORKFLOW_BASIC_STAGE', '{}'),
('58', '56', '39', '40', '3', 'com_content.transition.1', 'UNPUBLISH', '{}'),
('59', '56', '41', '42', '3', 'com_content.transition.2', 'PUBLISH', '{}'),
('60', '56', '43', '44', '3', 'com_content.transition.3', 'TRASH', '{}'),
('61', '56', '45', '46', '3', 'com_content.transition.4', 'ARCHIVE', '{}'),
('62', '56', '47', '48', '3', 'com_content.transition.5', 'FEATURE', '{}'),
('63', '56', '49', '50', '3', 'com_content.transition.6', 'UNFEATURE', '{}'),
('64', '56', '51', '52', '3', 'com_content.transition.7', 'PUBLISH_AND_FEATURE', '{}'),
('65', '1', '211', '212', '1', 'com_privacy', 'com_privacy', '{}'),
('66', '1', '213', '214', '1', 'com_actionlogs', 'com_actionlogs', '{}'),
('67', '18', '100', '101', '2', 'com_modules.module.88', 'Latest Actions', '{}'),
('68', '18', '102', '103', '2', 'com_modules.module.89', 'Privacy Dashboard', '{}'),
('70', '18', '112', '113', '2', 'com_modules.module.103', 'Site', '{}'),
('71', '18', '116', '117', '2', 'com_modules.module.104', 'System', '{}'),
('72', '18', '120', '121', '2', 'com_modules.module.91', 'System Dashboard', '{}'),
('73', '18', '122', '123', '2', 'com_modules.module.92', 'Content Dashboard', '{}'),
('74', '18', '124', '125', '2', 'com_modules.module.93', 'Menus Dashboard', '{}'),
('75', '18', '126', '127', '2', 'com_modules.module.94', 'Components Dashboard', '{}'),
('76', '18', '128', '129', '2', 'com_modules.module.95', 'Users Dashboard', '{}'),
('77', '18', '130', '131', '2', 'com_modules.module.99', 'Frontend Link', '{}'),
('78', '18', '132', '133', '2', 'com_modules.module.100', 'Messages', '{}'),
('79', '18', '134', '135', '2', 'com_modules.module.101', 'Post Install Messages', '{}'),
('80', '18', '136', '137', '2', 'com_modules.module.102', 'User Status', '{}'),
('82', '18', '138', '139', '2', 'com_modules.module.105', '3rd Party', '{}'),
('83', '18', '140', '141', '2', 'com_modules.module.106', 'Help Dashboard', '{}'),
('84', '18', '142', '143', '2', 'com_modules.module.107', 'Privacy Requests', '{}'),
('85', '18', '144', '145', '2', 'com_modules.module.108', 'Privacy Status', '{}'),
('86', '18', '146', '147', '2', 'com_modules.module.96', 'Popular Articles', '{}'),
('87', '18', '148', '149', '2', 'com_modules.module.97', 'Recently Added Articles', '{}'),
('88', '18', '150', '151', '2', 'com_modules.module.98', 'Logged-in Users', '{}'),
('89', '18', '152', '153', '2', 'com_modules.module.90', 'Login Support', '{}'),
('90', '1', '233', '234', '1', 'com_scheduler', 'com_scheduler', '{}'),
('91', '1', '235', '236', '1', 'com_associations', 'com_associations', '{}'),
('92', '1', '237', '238', '1', 'com_categories', 'com_categories', '{}'),
('93', '1', '239', '240', '1', 'com_fields', 'com_fields', '{}'),
('94', '1', '241', '242', '1', 'com_workflow', 'com_workflow', '{}'),
('95', '1', '243', '244', '1', 'com_guidedtours', 'com_guidedtours', '{}'),
('96', '18', '154', '155', '2', 'com_modules.module.109', 'Guided Tours', '{}'),
('97', '1', '245', '246', '1', 'com_scheduler.task.1', 'com_scheduler.task.1', '{}'),
('98', '1', '247', '248', '1', 'com_scheduler.task.2', 'com_scheduler.task.2', '{}'),
('99', '1', '249', '250', '1', 'com_scheduler.task.3', 'com_scheduler.task.3', '{}'),
('100', '1', '251', '252', '1', 'com_templateck', 'com_templateck', '{}'),
('102', '1', '253', '254', '1', 'com_jce', 'COM_JCE', '{}'),
('103', '1', '255', '256', '1', 'com_rsform', 'com_rsform', '{}'),
('104', '18', '156', '157', '2', 'com_modules.module.110', 'Copyright', '{}'),
('105', '27', '19', '20', '3', 'com_content.article.1', 'Home', '{}'),
('106', '1', '257', '258', '1', 'com_osmap', 'COM_OSMAP', '{}'),
('107', '16', '78', '79', '2', 'com_menus.menu.2', 'Hidden Menu', '{}'),
('108', '27', '21', '22', '3', 'com_content.article.2', 'Page Not Found', '{}'),
('109', '1', '259', '260', '1', 'com_akeebabackup', 'com_akeebabackup', '{}'),
('110', '27', '23', '24', '3', 'com_content.article.3', 'Doula Support', '{}'),
('111', '27', '25', '26', '3', 'com_content.article.4', 'Order Pills', '{}'),
('112', '27', '27', '28', '3', 'com_content.article.5', 'FAQ', '{}'),
('113', '27', '29', '30', '3', 'com_content.article.6', 'Contact Us', '{}'),
('114', '18', '158', '159', '2', 'com_modules.module.111', 'Banner - Home', '{}'),
('115', '1', '261', '262', '1', 'com_smartslider3', 'Smart Slider 3', '{}'),
('116', '18', '160', '161', '2', 'com_modules.module.112', 'Check Eligibility', '{}'),
('117', '18', '162', '163', '2', 'com_modules.module.113', 'Why Choose Musoya Health', '{}'),
('118', '18', '164', '165', '2', 'com_modules.module.114', 'Order', '{}'),
('119', '18', '166', '167', '2', 'com_modules.module.115', 'Footer', '{}'),
('120', '18', '168', '169', '2', 'com_modules.module.116', 'Language Switcher', '{}'),
('121', '18', '170', '171', '2', 'com_modules.module.117', 'Tagline', '{}'),
('122', '1', '263', '264', '1', 'com_j2store', 'J2Store', '{}'),
('123', '18', '172', '173', '2', 'com_modules.module.118', 'J2 Store Chart', '{}'),
('124', '18', '174', '175', '2', 'com_modules.module.119', 'J2 Store Stats Mini', '{}'),
('125', '18', '176', '177', '2', 'com_modules.module.120', 'J2 Store Orders', '{}'),
('126', '18', '178', '179', '2', 'com_modules.module.121', 'J2 Store Stats', '{}'),
('127', '18', '180', '181', '2', 'com_modules.module.122', 'J2Store Administrator Menu', '{}'),
('128', '18', '182', '183', '2', 'com_modules.module.123', 'Currency', '{}'),
('129', '18', '184', '185', '2', 'com_modules.module.124', 'Your Cart', '{}'),
('130', '18', '186', '187', '2', 'com_modules.module.125', 'Banner - Pills', '{}'),
('131', '18', '188', '189', '2', 'com_modules.module.126', 'Open 1', '{}'),
('132', '18', '190', '191', '2', 'com_modules.module.127', 'Open 3', '{}'),
('133', '18', '192', '193', '2', 'com_modules.module.128', 'Open 2', '{}'),
('134', '18', '194', '195', '2', 'com_modules.module.129', 'Banner - Pills', '{}'),
('135', '18', '196', '197', '2', 'com_modules.module.130', 'Banner - Doulas', '{}'),
('136', '18', '198', '199', '2', 'com_modules.module.131', 'Banner - Contact', '{}'),
('137', '8', '54', '59', '2', 'com_content.category.8', 'Blog', '{}'),
('138', '137', '57', '58', '3', 'com_content.article.7', 'Blog 1', '{}'),
('139', '137', '55', '56', '3', 'com_content.article.8', 'Blog 2', '{}'),
('140', '27', '31', '32', '3', 'com_content.article.9', 'About The Pills', '{}'),
('141', '27', '33', '34', '3', 'com_content.article.10', 'Form', '{}');
/**ABDB**/CREATE TABLE `#__associations` (
  `id` int NOT NULL COMMENT 'A reference to the associated item.',
  `context` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The context of the associated item.',
  `key` char(32) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The key for the association computed from an md5 on associated ids.',
  PRIMARY KEY (`context`,`id`),
  KEY `idx_key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__banner_clients` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `contact` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `email` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extrainfo` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `metakey` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `own_prefix` tinyint NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint NOT NULL DEFAULT '-1',
  `track_clicks` tinyint NOT NULL DEFAULT '-1',
  `track_impressions` tinyint NOT NULL DEFAULT '-1',
  PRIMARY KEY (`id`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100))
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__banner_tracks` (
  `track_date` datetime NOT NULL,
  `track_type` int unsigned NOT NULL,
  `banner_id` int unsigned NOT NULL,
  `count` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`track_date`,`track_type`,`banner_id`),
  KEY `idx_track_date` (`track_date`),
  KEY `idx_track_type` (`track_type`),
  KEY `idx_banner_id` (`banner_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__banners` (
  `id` int NOT NULL AUTO_INCREMENT,
  `cid` int NOT NULL DEFAULT '0',
  `type` int NOT NULL DEFAULT '0',
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `imptotal` int NOT NULL DEFAULT '0',
  `impmade` int NOT NULL DEFAULT '0',
  `clicks` int NOT NULL DEFAULT '0',
  `clickurl` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `state` tinyint NOT NULL DEFAULT '0',
  `catid` int unsigned NOT NULL DEFAULT '0',
  `description` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `custombannercode` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `sticky` tinyint unsigned NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `metakey` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `own_prefix` tinyint NOT NULL DEFAULT '0',
  `metakey_prefix` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `purchase_type` tinyint NOT NULL DEFAULT '-1',
  `track_clicks` tinyint NOT NULL DEFAULT '-1',
  `track_impressions` tinyint NOT NULL DEFAULT '-1',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `reset` datetime DEFAULT NULL,
  `created` datetime NOT NULL,
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `version` int unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `idx_state` (`state`),
  KEY `idx_own_prefix` (`own_prefix`),
  KEY `idx_metakey_prefix` (`metakey_prefix`(100)),
  KEY `idx_banner_catid` (`catid`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__categories` (
  `id` int NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `parent_id` int unsigned NOT NULL DEFAULT '0',
  `lft` int NOT NULL DEFAULT '0',
  `rgt` int NOT NULL DEFAULT '0',
  `level` int unsigned NOT NULL DEFAULT '0',
  `path` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `extension` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `description` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `published` tinyint NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `access` int unsigned NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `metadesc` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The meta description for the page.',
  `metakey` varchar(1024) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'The keywords for the page.',
  `metadata` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '' COMMENT 'JSON encoded metadata properties.',
  `created_user_id` int unsigned NOT NULL DEFAULT '0',
  `created_time` datetime NOT NULL,
  `modified_user_id` int unsigned NOT NULL DEFAULT '0',
  `modified_time` datetime NOT NULL,
  `hits` int unsigned NOT NULL DEFAULT '0',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `version` int unsigned NOT NULL DEFAULT '1',
  PRIMARY KEY (`id`),
  KEY `cat_idx` (`extension`,`published`,`access`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_path` (`path`(100)),
  KEY `idx_left_right` (`lft`,`rgt`),
  KEY `idx_alias` (`alias`(100)),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB AUTO_INCREMENT=9 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__categories`  VALUES 
('1', '0', '0', '0', '13', '0', '', 'system', 'ROOT', 'root', '', '', '1', NULL, NULL, '1', '{}', '', '', '{}', '15', '2024-10-22 11:45:17', '15', '2024-10-22 11:45:17', '0', '*', '1'),
('2', '27', '1', '1', '2', '1', 'general-category', 'com_content', 'General', 'general-category', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '15', '2024-10-22 11:45:17', '15', '2025-01-29 07:27:22', '0', '*', '1'),
('3', '28', '1', '3', '4', '1', 'uncategorised', 'com_banners', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '15', '2024-10-22 11:45:17', '15', '2024-10-22 11:45:17', '0', '*', '1'),
('4', '29', '1', '5', '6', '1', 'uncategorised', 'com_contact', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '15', '2024-10-22 11:45:17', '15', '2024-10-22 11:45:17', '0', '*', '1'),
('5', '30', '1', '7', '8', '1', 'uncategorised', 'com_newsfeeds', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '15', '2024-10-22 11:45:17', '15', '2024-10-22 11:45:17', '0', '*', '1'),
('7', '32', '1', '9', '10', '1', 'uncategorised', 'com_users', 'Uncategorised', 'uncategorised', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '15', '2024-10-22 11:45:17', '15', '2024-10-22 11:45:17', '0', '*', '1'),
('8', '137', '1', '11', '12', '1', 'blog', 'com_content', 'Blog', 'blog', '', '', '1', NULL, NULL, '1', '{\"category_layout\":\"\",\"image\":\"\",\"image_alt\":\"\"}', '', '', '{\"author\":\"\",\"robots\":\"\"}', '15', '2025-09-21 08:20:38', '15', '2025-09-21 08:20:38', '0', '*', '1');
/**ABDB**/CREATE TABLE `#__contact_details` (
  `id` int NOT NULL AUTO_INCREMENT,
  `name` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL,
  `con_position` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `address` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `suburb` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `state` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `country` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `postcode` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `telephone` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `fax` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `misc` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `image` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `email_to` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  `default_con` tinyint unsigned NOT NULL DEFAULT '0',
  `published` tinyint NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int NOT NULL DEFAULT '0',
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `user_id` int NOT NULL DEFAULT '0',
  `catid` int NOT NULL DEFAULT '0',
  `access` int unsigned NOT NULL DEFAULT '0',
  `mobile` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `webpage` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname1` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname2` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `sortname3` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `language` varchar(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `metakey` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `metadesc` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `metadata` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint unsigned NOT NULL DEFAULT '0' COMMENT 'Set if contact is featured.',
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `version` int unsigned NOT NULL DEFAULT '1',
  `hits` int unsigned NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`published`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__content` (
  `id` int unsigned NOT NULL AUTO_INCREMENT,
  `asset_id` int unsigned NOT NULL DEFAULT '0' COMMENT 'FK to the #__assets table.',
  `title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_bin NOT NULL DEFAULT '',
  `introtext` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `fulltext` mediumtext CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `state` tinyint NOT NULL DEFAULT '0',
  `catid` int unsigned NOT NULL DEFAULT '0',
  `created` datetime NOT NULL,
  `created_by` int unsigned NOT NULL DEFAULT '0',
  `created_by_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `modified` datetime NOT NULL,
  `modified_by` int unsigned NOT NULL DEFAULT '0',
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `publish_up` datetime DEFAULT NULL,
  `publish_down` datetime DEFAULT NULL,
  `images` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `urls` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `attribs` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `version` int unsigned NOT NULL DEFAULT '1',
  `ordering` int NOT NULL DEFAULT '0',
  `metakey` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `metadesc` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `access` int unsigned NOT NULL DEFAULT '0',
  `hits` int unsigned NOT NULL DEFAULT '0',
  `metadata` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `featured` tinyint unsigned NOT NULL DEFAULT '0' COMMENT 'Set if article is featured.',
  `language` char(7) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL COMMENT 'The language code for the article.',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`id`),
  KEY `idx_access` (`access`),
  KEY `idx_checkout` (`checked_out`),
  KEY `idx_state` (`state`),
  KEY `idx_catid` (`catid`),
  KEY `idx_createdby` (`created_by`),
  KEY `idx_featured_catid` (`featured`,`catid`),
  KEY `idx_language` (`language`),
  KEY `idx_alias` (`alias`(191))
) ENGINE=InnoDB AUTO_INCREMENT=11 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__content`  VALUES 
('1', '105', 'Home', 'home-info', '<div class=\"wf-columns wf-columns-stack-medium\" style=\"text-align: center;\" data-wf-columns=\"1\">\r\n<div class=\"wf-column boxedborder\">\r\n<p><img src=\"images/icons/trust-safe-a.png\" alt=\"Safe &amp; Trusted\" width=\"150\" height=\"150\" class=\"image-circle\" onmouseover=\"this.src=\'images/icons/trust-safe-h.png\';\" onmouseout=\"this.src=\'images/icons/trust-safe-a.png\';\" /></p>\r\n<p>&nbsp;</p>\r\n<h2>Safe &amp; Trusted</h2>\r\n<p>&nbsp;</p>\r\n<p>We provide quality mifepristone and misoprostol pills. The international gold standard for at home abortion care.</p>\r\n</div>\r\n<div class=\"wf-column boxedborder\">\r\n<p><img src=\"images/icons/trust-discreet-a.png\" alt=\"Discreet &amp; Secure\" width=\"150\" height=\"150\" class=\"image-circle\" onmouseover=\"this.src=\'images/icons/trust-discreet-h.png\';\" onmouseout=\"this.src=\'images/icons/trust-discreet-a.png\';\" /></p>\r\n<p>&nbsp;</p>\r\n<h2>Discreet &amp; Secure</h2>\r\n<p>&nbsp;</p>\r\n<p>Your privacy is protected at every stage, from consultation to delivery.&nbsp; Packages arrive discreetly to destinations all over the world.</p>\r\n</div>\r\n<div class=\"wf-column boxedborder\">\r\n<p><img src=\"images/icons/trust-support-a.png\" alt=\"Supported &amp; Empowered\" width=\"150\" height=\"150\" class=\"image-circle\" onmouseover=\"this.src=\'images/icons/trust-support-h.png\';\" onmouseout=\"this.src=\'images/icons/trust-support-a.png\';\" /></p>\r\n<p>&nbsp;</p>\r\n<h2>Supported &amp; Empowered</h2>\r\n<p>&nbsp;</p>\r\n<p>Musoya is with you every step of the way. We will match you with a doula who provides personalised, non-judgemental support before, during, and after your abortion process.</p>\r\n</div>\r\n</div>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<h2>How It Works</h2>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<div class=\"wf-columns wf-columns-stack-medium\" style=\"text-align: center;\" data-wf-columns=\"1\">\r\n<div class=\"wf-column boxedborder\">\r\n<p class=\"image-circle\"><span style=\"font-size: 18pt;\">Step 1</span></p>\r\n<p>&nbsp;</p>\r\n<h3>Consultation</h3>\r\n<p>&nbsp;</p>\r\n<p>Complete a quick intake form to confirm eligibility.</p>\r\n</div>\r\n<div class=\"wf-column boxedborder\">\r\n<p class=\"image-circle\"><span style=\"font-size: 18pt;\">Step 2</span></p>\r\n<p>&nbsp;</p>\r\n<h3>Doula Match</h3>\r\n<p>&nbsp;</p>\r\n<p>We connect you with a trained abortion doula.</p>\r\n</div>\r\n<div class=\"wf-column boxedborder\">\r\n<p class=\"image-circle\"><span style=\"font-size: 18pt;\">Step 3</span></p>\r\n<p>&nbsp;</p>\r\n<h4>Pill Delivery</h4>\r\n<p>&nbsp;</p>\r\n<p>Safe, high-quality pills are discreetly delivered to you.</p>\r\n</div>\r\n<div class=\"wf-column boxedborder\">\r\n<p class=\"image-circle\"><span style=\"font-size: 18pt;\">Step 4</span></p>\r\n<p>&nbsp;</p>\r\n<h5>Support Anytime</h5>\r\n<p>&nbsp;</p>\r\n<p>Your doula is available throughout the entire process and beyond.</p>\r\n</div>\r\n</div>\r\n<p>&nbsp;</p>\r\n<hr />\r\n<p>&nbsp;</p>\r\n<h3 style=\"text-align: center;\">Ready to Begin?</h3>\r\n<p>&nbsp;</p>\r\n<p style=\"text-align: center;\"><a href=\"index.php?Itemid=348\" target=\"_self\" class=\"btn\">Start the Process</a></p>\r\n<p>&nbsp;</p>', '', '1', '2', '2024-10-22 12:35:13', '15', '', '2025-10-03 09:43:21', '15', NULL, NULL, '2024-10-22 12:35:13', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '24', '7', '', '', '1', '6202', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('2', '108', 'Page Not Found', '404', '<p>Oh no, this page missed its pill schedule. Don’t worry, you can get back on track with the menu above or head <a href=\"index.php?Itemid=101\" target=\"_self\" title=\"Home\">home</a>&nbsp;for safe guidance.</p>', '', '1', '2', '2025-02-02 09:19:12', '15', '', '2025-08-16 13:04:38', '15', NULL, NULL, '2025-02-02 09:19:12', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '2', '6', '', '', '1', '2235', '{\"robots\":\"noindex, nofollow\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('3', '110', 'Doula Support', 'doula-support-info', '<p>Abortion is a journey no one should face alone. Our trained doulas provide compassionate support before, during, and after your abortion or miscarriage.</p>\r\n<p>&nbsp;</p>\r\n<p>Musoya Health is proud to partner with Rouge Doulas to provide personalised abortion support. Rouge Doulas are real counsellors who you can contact at any stage of your abortion process. Support from a Rouge Doula is included in the cost of every Musoya service.</p>\r\n<p>&nbsp;</p>\r\n<div class=\"wf-columns wf-columns-stack-medium wf-columns-layout-auto\" data-wf-columns=\"1\">\r\n<div class=\"wf-column boxedborder\">\r\n<h2>What Is a Doula?</h2>\r\n<p>&nbsp;</p>\r\n<p>An abortion doula is a supportive guide. They are medical staff, but they are trained to walk beside you emotionally and practically throughout your experience. They help you understand what to expect with abortion pills, answer your questions with honesty and care, provide ongoing emotional support, and stay with you through every step of your journey.</p>\r\n</div>\r\n<div class=\"wf-column boxedborder\">\r\n<h2>Worldwide Support</h2>\r\n<p>&nbsp;</p>\r\n<p>Your doula is available wherever you are. They stay connected by text, voice, or email, offering reassurance and practical help whenever you need it.</p>\r\n</div>\r\n<div class=\"wf-column boxedborder\">\r\n<h2>Support at Every Stage</h2>\r\n<p>&nbsp;</p>\r\n<p>Your support does not end once you take the pills. Doulas check in throughout the process, remember your story, and adapt their care as your journey unfolds, making sure you feel safe and supported through your whole journey.</p>\r\n</div>\r\n<div class=\"wf-column boxedborder\">\r\n<h2>Why It Matters</h2>\r\n<p>&nbsp;</p>\r\n<p>Abortion can bring up many emotions, relief, uncertainty, sadness, and empowerment among many others. All of these are normal. A doula is there to validate your experience, hold space for you, and ensure you feel supported, respected, and heard throughout your journey.</p>\r\n<p>&nbsp;</p>\r\n</div>\r\n</div>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<h2>We\'ll Connect You to a Doula</h2>\r\n<p>&nbsp;</p>\r\n<p>Our doulas make sure you are never alone. They provide comfort, care, and guidance throughout your journey with the help of our <a href=\"https://www.rougepills.com/\" target=\"_blank\" rel=\"noopener\" title=\"Rouge Doulas\">Rouge Doulas</a>, helping you feel safe, informed, and confident.</p>\r\n<p>&nbsp;</p>\r\n<p>We offer support before, during, and after a medication (pill-based) abortion.</p>', '', '1', '2', '2025-08-16 13:51:46', '15', '', '2025-09-30 08:14:22', '15', NULL, NULL, '2025-08-16 13:51:46', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '7', '5', 'abortion doula, abortion doula support, abortion care, miscarriage doula, abortion counselling, abortion guidance, online doula abortion, personalised abortion care, abortion aftercare support, abortion doula worldwide', 'Abortion doulas guide you with emotional and practical support at every step. Safe, personalised, and always confidential.', '1', '163', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('4', '111', 'Order Pills', 'order-pills-info', '<p>Price includes free shipping.</p>\r\n<p>&nbsp;</p>\r\n<p><a href=\"index.php?Itemid=347\" target=\"_self\" class=\"btn\" title=\"About The Pills\">More Info</a></p>\r\n<p>&nbsp;</p>', '', '1', '2', '2025-08-16 14:04:24', '15', '', '2025-09-29 09:54:29', '15', NULL, NULL, '2025-08-16 14:04:24', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"images\\/products\\/order-pills.webp#joomlaImage:\\/\\/local-images\\/products\\/order-pills.webp?width=1000&height=1000\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '30', '4', '', '', '1', '184', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('5', '112', 'FAQ', 'faq-info', '<p>&nbsp;</p>\r\n<p>{accordion title=\"How to Use Mifepristone and Misoprostol for an Abortion\" open=\"false\"}</p>\r\n<p>Mifepristone and misoprostol are medicines used together to have an abortion. You need to take one mifepristone pill (200 mg) and at least four misoprostol pills (200 mcg each). These dosages are the most common in mifepristone and misoprostol pills, but if the pills you are getting have different dosages of mg and/or mcg, you will need to recalculate the total number of pills so you can use the correct amount of medicine.</p>\r\n<p><br />It’s better to have eight misoprostol pills in total because you might need all of them to make sure the abortion is complete, especially if you are 9-13 weeks pregnant. If you only have four misoprostol pills, you can still use them.<br />There are other important medicines that can help you during the abortion, such as pain medicine and anti-nausea medicine. You can learn more about them here.</p>\r\n<p>&nbsp;</p>\r\n<h3>Procedure<br /><br /></h3>\r\n<h4>Step 1: Take Mifepristone</h4>\r\n<p>&nbsp;</p>\r\n<p>Swallow one mifepristone pill (200 mg) with water. Most people don’t feel side effects from this medicine.<br /><br /><strong>Wait</strong> at least 24 hours but no more than 48 hours to move on to the next step. Choose a time when you will have easy access to a bathroom and won’t be disturbed much. Once you start taking the misoprostol, it\'s best if you can stay somewhere you feel safe and comfortable for at least 12 hours, but ideally 24 hours.</p>\r\n<p>&nbsp;</p>\r\n<h4>Step 2: Take Pain Medication</h4>\r\n<p><br />Take a pain reliever like ibuprofen (800 mg) about 30 minutes before using the misoprostol, as cramping will start soon after. Acetaminophen or paracetamol (1000 mg) can also be used, though they may not work as well as ibuprofen.</p>\r\n<p>&nbsp;</p>\r\n<p><strong>Wait</strong> 30 min.</p>\r\n<p>&nbsp;</p>\r\n<h4>Step 3: Take Misoprostol</h4>\r\n<p>&nbsp;</p>\r\n<p>Misoprostol is used differently than other medicines, and there are different ways it can be used for abortion. You can learn more about the different ways here. Our team recommends using misoprostol under your tongue because the written instructions are clear and easy to follow, but you might prefer a different option based on your situation.</p>\r\n<p><br />Put 4 misoprostol pills (200 mcg each) under your tongue and hold them there for 30 minutes. You can swallow your saliva, but don’t eat or drink during these 30 minutes. It’s good to be somewhere quiet where you won’t be disturbed. After 30 minutes, drink some water and swallow what’s left of the pills. Some brands of misoprostol pills dissolve easily and others do not. Whether they dissolve is not important. You can learn more about misoprostol brands here. <br /><br /><strong>Important:</strong> If you vomit within 30 minutes, or while the misoprostol is still in your mouth, repeat Step 3. If you vomit after 30 minutes, you don’t need to repeat because the medicine has already worked.</p>\r\n<p><br />Cramping and bleeding can start as soon as 30 minutes after taking misoprostol, but it might take up to 24 hours to begin. Most people see bleeding within about 4-6 hours after taking misoprostol. You can continue to take pain medicine throughout the abortion process. Follow the pain medicine instructions. Do not exceed the recommended dosage per day, and do not use regular aspirin, as it increases your bleeding risk.</p>\r\n<p>&nbsp;</p>\r\n<h4>Step 4: Take a Second Dose (if needed)</h4>\r\n<p><br />If you are less than 9 weeks pregnant, you probably won’t need a second dose. But if you haven’t bled as much as a menstrual period within 24 hours, or if you’re worried your bleeding is too light, you can use 4 more misoprostol pills the same way as before.</p>\r\n<p><br />If you are 9-13 weeks pregnant, it’s a good idea to use 4 more misoprostol pills the same way you used the first dose, 4 hours later. This makes the pills work better and is more likely to result in a successful abortion.</p>\r\n<p>{accordion title=\"What to Expect After Taking Mifepristone and Misoprostol\"}</p>\r\n<p><strong>Mifepristone:</strong> Most people don’t feel any symptoms after taking mifepristone, though some may see light bleeding. Even if you bleed, it’s very important to take the misoprostol pills to complete the abortion.</p>\r\n<p><br /><strong>Misoprostol:</strong> After taking misoprostol, you will have cramping and bleeding. This is normal and means the medicine is working. You can expect to pass blood clots, which can be different sizes depending on how far along the pregnancy was. In an early pregnancy, even small blood clots can show the abortion worked. After 10 weeks, you might see or feel a recognizable embryo or foetus when it passes.</p>\r\n<p><br />Very strong cramping can be normal as your uterus contracts to remove the pregnancy. Pain relief like ibuprofen, a hot water bottle, or massaging the area between your navel and pubic bone can help with cramping. Sitting on the toilet might also help. For nausea, try drinking clear fluids or eating lightly.</p>\r\n<p><br />Bleeding may be heavier than a normal period. It’s common for the bleeding to last for several days. It’s okay if the bleeding stops and starts and it can continue until your next period, which often happens within 4-6 weeks. This is all normal and nothing to worry about.</p>\r\n<p>&nbsp;</p>\r\n<h3>Other Possible Side Effects</h3>\r\n<p><br />The following side effects should go away within 24 hours of using misoprostol:&nbsp;</p>\r\n<ul>\r\n<li>Fever</li>\r\n<li>Diarrhoea</li>\r\n<li>Nausea or vomiting</li>\r\n<li>Headache</li>\r\n<li>Dizziness</li>\r\n<li>Chills</li>\r\n</ul>\r\n<p>Most people will stop having pregnancy symptoms like nausea or frequent urination within a few days. Breast tenderness is often the last symptom to go away and can take up to 10 days after using misoprostol.</p>\r\n<p>{accordion title=\"Warning Signs: When to Seek Help\"}</p>\r\n<p>Get medical help right away if you:</p>\r\n<ul>\r\n<li>Soak through 2 or more pads per hour for 2 or more hours in a row.</li>\r\n<li>Have a fever of 100.4°F (38°C) that starts at least 24 hours after taking misoprostol and does not go down after taking ibuprofen.</li>\r\n<li>Have severe pain that doesn’t get better after using pain medication like ibuprofen.</li>\r\n<li>Feel very sick or have a bad-smelling vaginal discharge. Blood can smell unpleasant and be brown, dark almost black, or bright red, but if you have a discharge of another colour that smells rotten, it may be an infection.</li>\r\n<li>Have an allergic reaction (like redness or swelling of the face or neck, or difficulty breathing).</li>\r\n</ul>\r\n<p>{accordion title=\"After the Abortion\"}</p>\r\n<p>In the weeks after your abortion:</p>\r\n<ul>\r\n<li>Use pads at first to see how much you are bleeding. You can switch to a tampon or cup when you feel comforaccordionle.&nbsp; You can return to your normal activities as soon as you feel ready.</li>\r\n<li>It’s also safe to have sex when you feel ready to but remember that you can get pregnant again as soon as 2 weeks after an abortion, even if you are still bleeding.</li>\r\n<li>Take a pregnancy test 4-5 weeks after the abortion to make sure it was successful. Taking a test sooner may give a false positive result. If the test is still positive at 5 weeks or if you still have pregnancy symptoms, see a healthcare provider to check if the abortion worked.</li>\r\n</ul>\r\n<p>It’s normal to feel different emotions after a pregnancy ends. Some people feel better right away, and others need more time. Talking about your feelings with someone you trust can help if you need support.</p>\r\n<p>{/accordions}</p>', '', '1', '2', '2025-08-16 14:06:25', '15', '', '2025-10-15 11:27:22', '15', NULL, NULL, '2025-08-16 14:06:25', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '10', '3', '', '', '1', '136', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('6', '113', 'Contact Us', 'contact-info', '<p>We’re ready to answer your questions, guide you through the process, and connect you with safe, supportive care.</p>\r\n<p>&nbsp;</p>\r\n<div class=\"wf-columns wf-columns-stack-medium wf-columns-layout-2-3\" data-wf-columns=\"1\">\r\n<div class=\"wf-column\">\r\n<h2>Confidential and Compassionate</h2>\r\n<p>&nbsp;</p>\r\n<p>Whether you’re seeking abortion pills, doula support, or simply have questions, you can reach us directly and privately. Every message is treated with care and complete confidentiality.</p>\r\n<p>&nbsp;</p>\r\n<h2>Global Support</h2>\r\n<p>&nbsp;</p>\r\n<p>No matter where you are, we’re here for you. Our support spans countries and languages, so you’re never without help or guidance.</p>\r\n</div>\r\n<div class=\"wf-column\">\r\n<p>To connect with us, please complete the secure form below. Our team will respond with care and guidance, helping you access support, answer your questions, or connect you with safe abortion care. Your information is private and confidential and will not be shared outside of Musoya Health.</p>\r\n<p>&nbsp;</p>\r\n<p>{rsform 3}</p>\r\n</div>\r\n</div>\r\n<p>&nbsp;</p>', '', '1', '2', '2025-08-16 14:07:26', '15', '', '2025-09-20 15:46:24', '15', NULL, NULL, '2025-08-16 14:07:26', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '5', '2', 'contact abortion support, contact Musoya Health, abortion contact help, abortion pills email, abortion questions support, abortion doula contact, abortion helpline online, safe abortion contact, abortion info email, abortion care connect', 'Reach out to Musoya Health for confidential abortion support, pill orders, or doula guidance. We are here for you.', '1', '200', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('7', '138', 'Blog 1', 'blog-1', '<p>Lorem ipsum</p>\r\n', '\r\n<p>&nbsp;</p>\r\n<p>More content</p>\r\n<p>&nbsp;</p>', '1', '8', '2025-09-21 08:21:36', '15', '', '2025-09-21 08:24:09', '15', NULL, NULL, '2025-09-21 08:21:36', NULL, '{\"image_intro\":\"images\\/brand\\/musoya-logo-offline.webp#joomlaImage:\\/\\/local-images\\/brand\\/musoya-logo-offline.webp?width=400&height=400\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '3', '0', '', '', '1', '76', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('8', '139', 'Blog 2', 'blog-2', '<p>Lorem ipsum</p>\r\n', '\r\n<p>&nbsp;</p>\r\n<p>More content</p>\r\n<p>&nbsp;</p>', '1', '8', '2025-09-21 08:21:49', '15', '', '2025-09-21 08:21:49', '15', NULL, NULL, '2025-09-21 08:21:49', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '1', '0', '', '', '1', '86', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('9', '140', 'About The Pills', 'about-the-pills-info', '<p>Learn how to safely access and use medical abortion pills at home. With expert guidance and discreet support, your journey can be safe, informed, and supported every step of the way.</p>\r\n<p>&nbsp;</p>\r\n<h2>Safe, Proven, Effective</h2>\r\n<p>&nbsp;</p>\r\n<p>Medical abortion pills are listed as essential medicines by the WHO and are highly effective when used correctly.</p>\r\n<p>&nbsp;</p>\r\n<p>Musoya Health provides:</p>\r\n<ul>\r\n<li><strong>Mifepristone (200mg) + Misoprostol (200mcg each)</strong> - the standard, most effective combination.</li>\r\n<li><strong>Misoprostol (200mcg each) alone</strong> - safe and effective when used properly.</li>\r\n</ul>\r\n<p>&nbsp;</p>\r\n<h2>How It Works</h2>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<div class=\"wf-columns wf-columns-stack-medium\" style=\"text-align: center;\" data-wf-columns=\"1\">\r\n<div class=\"wf-column boxedborder\">\r\n<p><img src=\"images/icons/about-1-trimester-a.png\" alt=\"First Trimester\" width=\"150\" height=\"150\" class=\"image-circle\" onmouseover=\"this.src=\'images/icons/about-1-trimester-h.png\';\" onmouseout=\"this.src=\'images/icons/about-1-trimester-a.png\';\" /></p>\r\n<p>&nbsp;</p>\r\n<p><strong>First Trimester</strong></p>\r\n<p>4-12 weeks</p>\r\n<ul>\r\n<li style=\"text-align: left;\">Take mifepristone (200 mg).</li>\r\n<li style=\"text-align: left;\">Follow with misoprostol in 3-4 doses.</li>\r\n</ul>\r\n</div>\r\n<div class=\"wf-column boxedborder\">\r\n<p><img src=\"images/icons/about-2-trimester-a.png\" alt=\"Second Trimester\" width=\"150\" height=\"150\" class=\"image-circle\" onmouseover=\"this.src=\'images/icons/about-2-trimester-h.png\';\" onmouseout=\"this.src=\'images/icons/about-2-trimester-a.png\';\" /></p>\r\n<p>&nbsp;</p>\r\n<p><strong>Second Trimester</strong></p>\r\n<p>12+ weeks</p>\r\n<ul>\r\n<li style=\"text-align: left;\">Start with mifepristone.</li>\r\n<li style=\"text-align: left;\">Additional misoprostol doses as advised.</li>\r\n</ul>\r\n</div>\r\n<div class=\"wf-column boxedborder\">\r\n<p><img src=\"images/icons/about-method-a.png\" alt=\"Administration Methods\" width=\"150\" height=\"150\" class=\"image-circle\" onmouseover=\"this.src=\'images/icons/about-method-h.png\';\" onmouseout=\"this.src=\'images/icons/about-method-a.png\';\" /></p>\r\n<p>&nbsp;</p>\r\n<p><strong>Administration Methods</strong></p>\r\n<ul>\r\n<li style=\"text-align: left;\">Sublingual (under the tongue).</li>\r\n<li style=\"text-align: left;\">Buccal (between gum and cheek).</li>\r\n<li style=\"text-align: left;\">Vaginal (deep insertion).</li>\r\n</ul>\r\n</div>\r\n</div>\r\n<p>&nbsp;</p>\r\n<p>&nbsp;</p>\r\n<h2>What to Expect</h2>\r\n<p>&nbsp;</p>\r\n<p>Cramping and bleeding are normal. Some people pass pregnancy tissue within hours; others may take a few days. Our trained doulas guide you gently on what’s normal and what do if extra care is needed.</p>\r\n<p>&nbsp;</p>\r\n<p>A few things to keep in mind:</p>\r\n<ul>\r\n<li>If you vomit within 20 minutes of taking Mifepristone and Misoprostol, you can redose once nausea eases.</li>\r\n<li>Keep sanitary pads handy for comfort and monitoring.</li>\r\n<li>Stay hydrated and rest as much as possible.</li>\r\n</ul>\r\n<p>&nbsp;</p>\r\n<h2>Doula Support</h2>\r\n<p>&nbsp;</p>\r\n<p>You’re never alone. Our trained doulas are available via text, voice, or email to support you throughout your experience. They answer questions, offer reassurance, and guide you step by step, helping you feel safe, informed, and confident.</p>\r\n<p>&nbsp;</p>\r\n<p>With Musoya Health, you’ll always have discreet, expert guidance and everything you need to feel supported in every stage of the process.</p>\r\n<p>&nbsp;</p>\r\n<p><a href=\"index.php?Itemid=298\" target=\"_self\" class=\"btn\" title=\"Doula Support\">More About Doula Support</a></p>\r\n<p>&nbsp;</p>', '', '1', '2', '2025-09-29 09:15:30', '15', '', '2025-09-30 08:11:41', '15', NULL, NULL, '2025-09-29 09:15:30', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '3', '1', '', '', '1', '159', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', ''),
('10', '141', 'Form', 'form', '<p>Please complete the form so that we can verify you before buying the pills.</p>\r\n<p>&nbsp;</p>\r\n<p>{rsform 4}</p>', '', '1', '2', '2025-10-03 09:38:26', '15', '', '2025-10-03 09:38:26', '15', NULL, NULL, '2025-10-03 09:38:26', NULL, '{\"image_intro\":\"\",\"image_intro_alt\":\"\",\"float_intro\":\"\",\"image_intro_caption\":\"\",\"image_fulltext\":\"\",\"image_fulltext_alt\":\"\",\"float_fulltext\":\"\",\"image_fulltext_caption\":\"\"}', '{\"urla\":\"\",\"urlatext\":\"\",\"targeta\":\"\",\"urlb\":\"\",\"urlbtext\":\"\",\"targetb\":\"\",\"urlc\":\"\",\"urlctext\":\"\",\"targetc\":\"\"}', '{\"article_layout\":\"\",\"show_title\":\"\",\"link_titles\":\"\",\"show_tags\":\"\",\"show_intro\":\"\",\"info_block_position\":\"\",\"info_block_show_title\":\"\",\"show_category\":\"\",\"link_category\":\"\",\"show_parent_category\":\"\",\"link_parent_category\":\"\",\"show_author\":\"\",\"link_author\":\"\",\"show_create_date\":\"\",\"show_modify_date\":\"\",\"show_publish_date\":\"\",\"show_item_navigation\":\"\",\"show_hits\":\"\",\"show_noauth\":\"\",\"urls_position\":\"\",\"alternative_readmore\":\"\",\"article_page_title\":\"\",\"show_publishing_options\":\"\",\"show_article_options\":\"\",\"show_urls_images_backend\":\"\",\"show_urls_images_frontend\":\"\"}', '1', '0', '', '', '1', '166', '{\"robots\":\"\",\"author\":\"\",\"rights\":\"\"}', '0', '*', '');
/**ABDB**/CREATE TABLE `#__content_frontpage` (
  `content_id` int NOT NULL DEFAULT '0',
  `ordering` int NOT NULL DEFAULT '0',
  `featured_up` datetime DEFAULT NULL,
  `featured_down` datetime DEFAULT NULL,
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__content_rating` (
  `content_id` int NOT NULL DEFAULT '0',
  `rating_sum` int unsigned NOT NULL DEFAULT '0',
  `rating_count` int unsigned NOT NULL DEFAULT '0',
  `lastip` varchar(50) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  PRIMARY KEY (`content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/CREATE TABLE `#__content_types` (
  `type_id` int unsigned NOT NULL AUTO_INCREMENT,
  `type_title` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `type_alias` varchar(400) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `table` varchar(2048) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `rules` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `field_mappings` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `router` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `content_history_options` varchar(5120) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL COMMENT 'JSON string for com_contenthistory options',
  PRIMARY KEY (`type_id`),
  KEY `idx_alias` (`type_alias`(100))
) ENGINE=InnoDB AUTO_INCREMENT=10000 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__content_types`  VALUES 
('1', 'Article', 'com_content.article', '{\"special\":{\"dbtable\":\"#__content\",\"key\":\"id\",\"type\":\"ArticleTable\",\"prefix\":\"Joomla\\\\Component\\\\Content\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\": {\"note\": \"note\", \"asset_id\": \"asset_id\", \"core_body\": \"introtext\", \"core_hits\": \"hits\", \"core_urls\": \"urls\", \"core_alias\": \"alias\", \"core_catid\": \"catid\", \"core_state\": \"state\", \"core_title\": \"title\", \"core_access\": \"access\", \"core_images\": \"images\", \"core_params\": \"attribs\", \"core_metakey\": \"metakey\", \"core_version\": \"version\", \"core_featured\": \"featured\", \"core_language\": \"language\", \"core_metadata\": \"metadata\", \"core_metadesc\": \"metadesc\", \"core_ordering\": \"ordering\", \"core_publish_up\": \"publish_up\", \"core_created_time\": \"created\", \"core_publish_down\": \"publish_down\", \"core_modified_time\": \"modified\", \"core_content_item_id\": \"id\", \"core_created_user_id\": \"created_by\", \"core_created_by_alias\": \"created_by_alias\"}, \"special\": {\"fulltext\": \"fulltext\"}}', 'ContentHelperRoute::getArticleRoute', '{\"formFile\":\"administrator\\/components\\/com_content\\/forms\\/article.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"ordering\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
('2', 'Contact', 'com_contact.contact', '{\"special\":{\"dbtable\":\"#__contact_details\",\"key\":\"id\",\"type\":\"ContactTable\",\"prefix\":\"Joomla\\\\Component\\\\Contact\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"address\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"image\", \"core_urls\":\"webpage\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"asset_id\":\"null\"}, \"special\":{\"con_position\":\"con_position\",\"suburb\":\"suburb\",\"state\":\"state\",\"country\":\"country\",\"postcode\":\"postcode\",\"telephone\":\"telephone\",\"fax\":\"fax\",\"misc\":\"misc\",\"email_to\":\"email_to\",\"default_con\":\"default_con\",\"user_id\":\"user_id\",\"mobile\":\"mobile\",\"sortname1\":\"sortname1\",\"sortname2\":\"sortname2\",\"sortname3\":\"sortname3\"}}', 'ContactHelperRoute::getContactRoute', '{\"formFile\":\"administrator\\/components\\/com_contact\\/forms\\/contact.xml\",\"hideFields\":[\"default_con\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"], \"displayLookup\":[ {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ] }'),
('3', 'Newsfeed', 'com_newsfeeds.newsfeed', '{\"special\":{\"dbtable\":\"#__newsfeeds\",\"key\":\"id\",\"type\":\"NewsfeedTable\",\"prefix\":\"Joomla\\\\Component\\\\Newsfeeds\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"asset_id\":\"null\"}, \"special\":{\"numarticles\":\"numarticles\",\"cache_time\":\"cache_time\",\"rtl\":\"rtl\"}}', 'NewsfeedsHelperRoute::getNewsfeedRoute', '{\"formFile\":\"administrator\\/components\\/com_newsfeeds\\/forms\\/newsfeed.xml\",\"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\"],\"convertToInt\":[\"publish_up\", \"publish_down\", \"featured\", \"ordering\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
('4', 'User', 'com_users.user', '{\"special\":{\"dbtable\":\"#__users\",\"key\":\"id\",\"type\":\"User\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"null\",\"core_alias\":\"username\",\"core_created_time\":\"registerDate\",\"core_modified_time\":\"lastvisitDate\",\"core_body\":\"null\", \"core_hits\":\"null\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"access\":\"null\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"null\", \"core_language\":\"null\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"null\", \"core_ordering\":\"null\", \"core_metakey\":\"null\", \"core_metadesc\":\"null\", \"core_catid\":\"null\", \"asset_id\":\"null\"}, \"special\":{}}', '', ''),
('5', 'Article Category', 'com_content.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"CategoryTable\",\"prefix\":\"Joomla\\\\Component\\\\Categories\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContentHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
('6', 'Contact Category', 'com_contact.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"CategoryTable\",\"prefix\":\"Joomla\\\\Component\\\\Categories\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'ContactHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
('7', 'Newsfeeds Category', 'com_newsfeeds.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"CategoryTable\",\"prefix\":\"Joomla\\\\Component\\\\Categories\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', 'NewsfeedsHelperRoute::getCategoryRoute', '{\"formFile\":\"administrator\\/components\\/com_categories\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
('8', 'Tag', 'com_tags.tag', '{\"special\":{\"dbtable\":\"#__tags\",\"key\":\"tag_id\",\"type\":\"TagTable\",\"prefix\":\"Joomla\\\\Component\\\\Tags\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"featured\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"urls\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"null\", \"asset_id\":\"null\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\"}}', 'TagsHelperRoute::getTagRoute', '{\"formFile\":\"administrator\\/components\\/com_tags\\/forms\\/tag.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"lft\", \"rgt\", \"level\", \"path\", \"urls\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"],\"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
('9', 'Banner', 'com_banners.banner', '{\"special\":{\"dbtable\":\"#__banners\",\"key\":\"id\",\"type\":\"BannerTable\",\"prefix\":\"Joomla\\\\Component\\\\Banners\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"name\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created\",\"core_modified_time\":\"modified\",\"core_body\":\"description\", \"core_hits\":\"null\",\"core_publish_up\":\"publish_up\",\"core_publish_down\":\"publish_down\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"images\", \"core_urls\":\"link\", \"core_version\":\"version\", \"core_ordering\":\"ordering\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"catid\", \"asset_id\":\"null\"}, \"special\":{\"imptotal\":\"imptotal\", \"impmade\":\"impmade\", \"clicks\":\"clicks\", \"clickurl\":\"clickurl\", \"custombannercode\":\"custombannercode\", \"cid\":\"cid\", \"purchase_type\":\"purchase_type\", \"track_impressions\":\"track_impressions\", \"track_clicks\":\"track_clicks\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/forms\\/banner.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\", \"reset\"],\"ignoreChanges\":[\"modified_by\", \"modified\", \"checked_out\", \"checked_out_time\", \"version\", \"imptotal\", \"impmade\", \"reset\"], \"convertToInt\":[\"publish_up\", \"publish_down\", \"ordering\"], \"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"cid\",\"targetTable\":\"#__banner_clients\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"created_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"modified_by\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"} ]}'),
('10', 'Banners Category', 'com_banners.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"CategoryTable\",\"prefix\":\"Joomla\\\\Component\\\\Categories\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"asset_id\":\"asset_id\"}, \"special\": {\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/forms\\/category.xml\", \"hideFields\":[\"asset_id\",\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}'),
('11', 'Banner Client', 'com_banners.client', '{\"special\":{\"dbtable\":\"#__banner_clients\",\"key\":\"id\",\"type\":\"ClientTable\",\"prefix\":\"Joomla\\\\Component\\\\Banners\\\\Administrator\\\\Table\\\\\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_banners\\/forms\\/client.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\"], \"ignoreChanges\":[\"checked_out\", \"checked_out_time\"], \"convertToInt\":[], \"displayLookup\":[]}'),
('12', 'User Notes', 'com_users.note', '{\"special\":{\"dbtable\":\"#__user_notes\",\"key\":\"id\",\"type\":\"NoteTable\",\"prefix\":\"Joomla\\\\Component\\\\Users\\\\Administrator\\\\Table\\\\\"}}', '', '', '', '{\"formFile\":\"administrator\\/components\\/com_users\\/forms\\/note.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\", \"publish_up\", \"publish_down\"],\"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\"], \"convertToInt\":[\"publish_up\", \"publish_down\"],\"displayLookup\":[{\"sourceColumn\":\"catid\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}, {\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}]}'),
('13', 'User Notes Category', 'com_users.category', '{\"special\":{\"dbtable\":\"#__categories\",\"key\":\"id\",\"type\":\"CategoryTable\",\"prefix\":\"Joomla\\\\Component\\\\Categories\\\\Administrator\\\\Table\\\\\",\"config\":\"array()\"},\"common\":{\"dbtable\":\"#__ucm_content\",\"key\":\"ucm_id\",\"type\":\"Corecontent\",\"prefix\":\"Joomla\\\\CMS\\\\Table\\\\\",\"config\":\"array()\"}}', '', '{\"common\":{\"core_content_item_id\":\"id\",\"core_title\":\"title\",\"core_state\":\"published\",\"core_alias\":\"alias\",\"core_created_time\":\"created_time\",\"core_modified_time\":\"modified_time\",\"core_body\":\"description\", \"core_hits\":\"hits\",\"core_publish_up\":\"null\",\"core_publish_down\":\"null\",\"core_access\":\"access\", \"core_params\":\"params\", \"core_featured\":\"null\", \"core_metadata\":\"metadata\", \"core_language\":\"language\", \"core_images\":\"null\", \"core_urls\":\"null\", \"core_version\":\"version\", \"core_ordering\":\"null\", \"core_metakey\":\"metakey\", \"core_metadesc\":\"metadesc\", \"core_catid\":\"parent_id\", \"asset_id\":\"asset_id\"}, \"special\":{\"parent_id\":\"parent_id\",\"lft\":\"lft\",\"rgt\":\"rgt\",\"level\":\"level\",\"path\":\"path\",\"extension\":\"extension\",\"note\":\"note\"}}', '', '{\"formFile\":\"administrator\\/components\\/com_categories\\/forms\\/category.xml\", \"hideFields\":[\"checked_out\",\"checked_out_time\",\"version\",\"lft\",\"rgt\",\"level\",\"path\",\"extension\"], \"ignoreChanges\":[\"modified_user_id\", \"modified_time\", \"checked_out\", \"checked_out_time\", \"version\", \"hits\", \"path\"], \"convertToInt\":[\"publish_up\", \"publish_down\"], \"displayLookup\":[{\"sourceColumn\":\"created_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"}, {\"sourceColumn\":\"access\",\"targetTable\":\"#__viewlevels\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"},{\"sourceColumn\":\"modified_user_id\",\"targetTable\":\"#__users\",\"targetColumn\":\"id\",\"displayColumn\":\"name\"},{\"sourceColumn\":\"parent_id\",\"targetTable\":\"#__categories\",\"targetColumn\":\"id\",\"displayColumn\":\"title\"}]}');
/**ABDB**/CREATE TABLE `#__contentitem_tag_map` (
  `type_alias` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL DEFAULT '',
  `core_content_id` int unsigned NOT NULL COMMENT 'PK from the core content table',
  `content_item_id` int NOT NULL COMMENT 'PK from the content type table',
  `tag_id` int unsigned NOT NULL COMMENT 'PK from the tag table',
  `tag_date` timestamp NOT NULL DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP COMMENT 'Date of most recent save for this tag-item',
  `type_id` mediumint NOT NULL COMMENT 'PK from the content_type table',
  UNIQUE KEY `uc_ItemnameTagid` (`type_id`,`content_item_id`,`tag_id`),
  KEY `idx_tag_type` (`tag_id`,`type_id`),
  KEY `idx_date_id` (`tag_date`,`tag_id`),
  KEY `idx_core_content_id` (`core_content_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci COMMENT='Maps items from content tables to tags';
/**ABDB**/CREATE TABLE `#__extensions` (
  `extension_id` int NOT NULL AUTO_INCREMENT,
  `package_id` int NOT NULL DEFAULT '0' COMMENT 'Parent package ID for extensions installed as a package.',
  `name` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `type` varchar(20) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `element` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `changelogurl` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci,
  `folder` varchar(100) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `client_id` tinyint NOT NULL,
  `enabled` tinyint NOT NULL DEFAULT '0',
  `access` int unsigned NOT NULL DEFAULT '1',
  `protected` tinyint NOT NULL DEFAULT '0' COMMENT 'Flag to indicate if the extension is protected. Protected extensions cannot be disabled.',
  `locked` tinyint NOT NULL DEFAULT '0' COMMENT 'Flag to indicate if the extension is locked. Locked extensions cannot be uninstalled.',
  `manifest_cache` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `params` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `custom_data` text CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci NOT NULL,
  `checked_out` int unsigned DEFAULT NULL,
  `checked_out_time` datetime DEFAULT NULL,
  `ordering` int DEFAULT '0',
  `state` int DEFAULT '0',
  `note` varchar(255) CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci DEFAULT NULL,
  PRIMARY KEY (`extension_id`),
  KEY `element_clientid` (`element`,`client_id`),
  KEY `element_folder_clientid` (`element`,`folder`,`client_id`),
  KEY `extension` (`type`,`element`,`folder`,`client_id`)
) ENGINE=InnoDB AUTO_INCREMENT=355 DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_unicode_ci;
/**ABDB**/INSERT INTO `#__extensions`  VALUES 
('1', '0', 'com_wrapper', 'component', 'com_wrapper', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_wrapper\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\\n\\t\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Wrapper\",\"filename\":\"wrapper\"}', '', '', NULL, NULL, '0', '0', NULL),
('2', '0', 'com_admin', 'component', 'com_admin', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_admin\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_ADMIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Admin\"}', '', '', NULL, NULL, '0', '0', NULL),
('3', '0', 'com_banners', 'component', 'com_banners', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_banners\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Banners\",\"filename\":\"banners\"}', '{\"purchase_type\":\"3\",\"track_impressions\":\"0\",\"track_clicks\":\"0\",\"metakey_prefix\":\"\",\"save_history\":\"1\",\"history_limit\":10}', '', NULL, NULL, '0', '0', NULL),
('4', '0', 'com_cache', 'component', 'com_cache', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_cache\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Cache\"}', '', '', NULL, NULL, '0', '0', NULL),
('5', '0', 'com_categories', 'component', 'com_categories', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_categories\",\"type\":\"component\",\"creationDate\":\"2007-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Categories\"}', '', '', NULL, NULL, '0', '0', NULL),
('6', '0', 'com_checkin', 'component', 'com_checkin', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_checkin\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CHECKIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Checkin\"}', '', '', NULL, NULL, '0', '0', NULL),
('7', '0', 'com_contact', 'component', 'com_contact', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_contact\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Contact\",\"filename\":\"contact\"}', '{\"contact_layout\":\"_:default\",\"show_contact_category\":\"hide\",\"save_history\":\"1\",\"history_limit\":10,\"show_contact_list\":\"0\",\"presentation_style\":\"sliders\",\"show_tags\":\"1\",\"show_info\":\"1\",\"show_name\":\"1\",\"show_position\":\"1\",\"show_email\":\"0\",\"show_street_address\":\"1\",\"show_suburb\":\"1\",\"show_state\":\"1\",\"show_postcode\":\"1\",\"show_country\":\"1\",\"show_telephone\":\"1\",\"show_mobile\":\"1\",\"show_fax\":\"1\",\"show_webpage\":\"1\",\"show_image\":\"1\",\"show_misc\":\"1\",\"image\":\"\",\"allow_vcard\":\"0\",\"show_articles\":\"0\",\"articles_display_num\":\"10\",\"show_profile\":\"0\",\"show_user_custom_fields\":[\"-1\"],\"show_links\":\"0\",\"linka_name\":\"\",\"linkb_name\":\"\",\"linkc_name\":\"\",\"linkd_name\":\"\",\"linke_name\":\"\",\"contact_icons\":\"0\",\"icon_address\":\"\",\"icon_email\":\"\",\"icon_telephone\":\"\",\"icon_mobile\":\"\",\"icon_fax\":\"\",\"icon_misc\":\"\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"0\",\"maxLevel\":\"-1\",\"show_subcat_desc\":\"1\",\"show_empty_categories\":\"0\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_subcat_desc_cat\":\"1\",\"show_empty_categories_cat\":\"0\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"0\",\"show_pagination_limit\":\"0\",\"show_headings\":\"1\",\"show_image_heading\":\"0\",\"show_position_headings\":\"1\",\"show_email_headings\":\"0\",\"show_telephone_headings\":\"1\",\"show_mobile_headings\":\"0\",\"show_fax_headings\":\"0\",\"show_suburb_headings\":\"1\",\"show_state_headings\":\"1\",\"show_country_headings\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"initial_sort\":\"ordering\",\"captcha\":\"\",\"show_email_form\":\"1\",\"show_email_copy\":\"0\",\"banned_email\":\"\",\"banned_subject\":\"\",\"banned_text\":\"\",\"validate_session\":\"1\",\"custom_reply\":\"0\",\"redirect\":\"\",\"show_feed_link\":\"1\",\"sef_ids\":1,\"custom_fields_enable\":\"1\"}', '', NULL, NULL, '0', '0', NULL),
('8', '0', 'com_cpanel', 'component', 'com_cpanel', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_cpanel\",\"type\":\"component\",\"creationDate\":\"2007-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CPANEL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Cpanel\"}', '', '', NULL, NULL, '0', '0', NULL),
('9', '0', 'com_installer', 'component', 'com_installer', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_installer\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_INSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Installer\"}', '{\"cachetimeout\":\"6\",\"minimum_stability\":\"4\"}', '', NULL, NULL, '0', '0', NULL),
('10', '0', 'com_languages', 'component', 'com_languages', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_languages\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Languages\"}', '{\"administrator\":\"en-GB\",\"site\":\"en-GB\"}', '', NULL, NULL, '0', '0', NULL),
('11', '0', 'com_login', 'component', 'com_login', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_login\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Login\"}', '', '', NULL, NULL, '0', '0', NULL),
('12', '0', 'com_media', 'component', 'com_media', '', '', '1', '1', '0', '1', '1', '{\"name\":\"com_media\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"COM_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Media\",\"filename\":\"media\"}', '{\"upload_maxsize\":\"10\",\"file_path\":\"images\",\"image_path\":\"images\",\"restrict_uploads\":\"1\",\"restrict_uploads_extensions\":\"bmp,gif,jpg,jpeg,png,webp,avif,ico,mp3,m4a,mp4a,ogg,mp4,mp4v,mpeg,mov,odg,odp,ods,odt,pdf,ppt,txt,xcf,xls,csv,svg\",\"check_mime\":\"1\",\"image_extensions\":\"bmp,gif,jpg,png,jpeg,webp,avif\",\"audio_extensions\":\"mp3,m4a,mp4a,ogg\",\"video_extensions\":\"mp4,mp4v,mpeg,mov,webm\",\"doc_extensions\":\"odg,odp,ods,odt,pdf,ppt,txt,xcf,xls,csv\",\"ignore_extensions\":\"\",\"upload_mime\":\"image\\/jpeg,image\\/gif,image\\/png,image\\/bmp,image\\/webp,image\\/avif,audio\\/ogg,audio\\/mpeg,audio\\/mp4,video\\/mp4,video\\/webm,video\\/mpeg,video\\/quicktime,application\\/msword,application\\/excel,application\\/pdf,application\\/powerpoint,text\\/plain,application\\/x-zip\"}', '', NULL, NULL, '0', '0', NULL),
('13', '0', 'com_menus', 'component', 'com_menus', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_menus\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MENUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Menus\",\"filename\":\"menus\"}', '{\"page_title\":\"\",\"show_page_heading\":1,\"page_heading\":\"\",\"pageclass_sfx\":\"\"}', '', NULL, NULL, '0', '0', NULL),
('14', '0', 'com_messages', 'component', 'com_messages', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_messages\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Messages\"}', '', '', NULL, NULL, '0', '0', NULL),
('15', '0', 'com_modules', 'component', 'com_modules', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_modules\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MODULES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Modules\",\"filename\":\"modules\"}', '', '', NULL, NULL, '0', '0', NULL),
('16', '0', 'com_newsfeeds', 'component', 'com_newsfeeds', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_newsfeeds\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Newsfeeds\",\"filename\":\"newsfeeds\"}', '{\"newsfeed_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_feed_image\":\"1\",\"show_feed_description\":\"1\",\"show_item_description\":\"1\",\"feed_character_count\":\"0\",\"feed_display_order\":\"des\",\"float_first\":\"right\",\"float_second\":\"right\",\"show_tags\":\"1\",\"category_layout\":\"_:default\",\"show_category_title\":\"1\",\"show_description\":\"1\",\"show_description_image\":\"1\",\"maxLevel\":\"-1\",\"show_empty_categories\":\"0\",\"show_subcat_desc\":\"1\",\"show_cat_items\":\"1\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_items_cat\":\"1\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_headings\":\"1\",\"show_articles\":\"0\",\"show_link\":\"1\",\"show_pagination\":\"1\",\"show_pagination_results\":\"1\",\"sef_ids\":1}', '', NULL, NULL, '0', '0', NULL),
('17', '0', 'com_plugins', 'component', 'com_plugins', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_plugins\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_PLUGINS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Plugins\"}', '', '', NULL, NULL, '0', '0', NULL),
('18', '0', 'com_templates', 'component', 'com_templates', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_templates\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Templates\"}', '{\"template_positions_display\":\"0\",\"upload_limit\":\"10\",\"image_formats\":\"gif,bmp,jpg,jpeg,png,webp\",\"source_formats\":\"txt,less,ini,xml,js,php,css,scss,sass,json\",\"font_formats\":\"woff,woff2,ttf,otf\",\"compressed_formats\":\"zip\",\"difference\":\"SideBySide\"}', '', NULL, NULL, '0', '0', NULL),
('19', '0', 'com_content', 'component', 'com_content', '', '', '1', '1', '0', '1', '1', '{\"name\":\"com_content\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Content\",\"filename\":\"content\"}', '{\"article_layout\":\"_:default\",\"show_title\":\"0\",\"link_titles\":\"1\",\"show_intro\":\"1\",\"info_block_position\":\"0\",\"info_block_show_title\":\"1\",\"show_category\":\"0\",\"link_category\":\"1\",\"show_parent_category\":\"0\",\"link_parent_category\":\"0\",\"show_associations\":\"0\",\"flags\":\"1\",\"show_author\":\"0\",\"link_author\":\"0\",\"show_create_date\":\"0\",\"show_modify_date\":\"0\",\"show_publish_date\":\"0\",\"show_item_navigation\":\"0\",\"show_readmore\":\"1\",\"show_readmore_title\":\"0\",\"readmore_limit\":100,\"show_tags\":\"1\",\"record_hits\":\"1\",\"show_hits\":\"0\",\"show_noauth\":\"0\",\"urls_position\":0,\"captcha\":\"\",\"show_publishing_options\":\"1\",\"show_article_options\":\"1\",\"show_configure_edit_options\":\"1\",\"show_permissions\":\"1\",\"show_associations_edit\":\"1\",\"save_history\":\"1\",\"history_limit\":10,\"show_urls_images_frontend\":\"0\",\"show_urls_images_backend\":\"1\",\"targeta\":0,\"targetb\":0,\"targetc\":0,\"float_intro\":\"left\",\"float_fulltext\":\"left\",\"category_layout\":\"_:blog\",\"show_category_title\":\"0\",\"show_description\":\"0\",\"show_description_image\":\"0\",\"maxLevel\":\"1\",\"show_empty_categories\":\"0\",\"show_no_articles\":\"1\",\"show_category_heading_title_text\":\"1\",\"show_subcat_desc\":\"1\",\"show_cat_num_articles\":\"0\",\"show_cat_tags\":\"1\",\"show_base_description\":\"1\",\"maxLevelcat\":\"-1\",\"show_empty_categories_cat\":\"0\",\"show_subcat_desc_cat\":\"1\",\"show_cat_num_articles_cat\":\"1\",\"num_leading_articles\":0,\"blog_class_leading\":\"\",\"num_intro_articles\":20,\"blog_class\":\"\",\"num_columns\":4,\"multi_column_order\":\"0\",\"num_links\":0,\"show_subcategory_content\":\"0\",\"link_intro_image\":\"1\",\"show_pagination_limit\":\"1\",\"filter_field\":\"hide\",\"show_headings\":\"1\",\"list_show_date\":\"0\",\"date_format\":\"\",\"list_show_hits\":\"1\",\"list_show_author\":\"1\",\"display_num\":\"10\",\"orderby_pri\":\"order\",\"orderby_sec\":\"rdate\",\"order_date\":\"published\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"show_featured\":\"show\",\"show_feed_link\":\"1\",\"feed_summary\":\"0\",\"feed_show_readmore\":\"0\",\"sef_ids\":1,\"custom_fields_enable\":\"1\",\"workflow_enabled\":\"0\"}', '', NULL, NULL, '0', '0', NULL),
('20', '0', 'com_config', 'component', 'com_config', '', '', '1', '1', '0', '1', '1', '{\"name\":\"com_config\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONFIG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Config\",\"filename\":\"config\"}', '{\"filters\":{\"1\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"9\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"6\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"7\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"2\":{\"filter_type\":\"NH\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"3\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"4\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"5\":{\"filter_type\":\"BL\",\"filter_tags\":\"\",\"filter_attributes\":\"\"},\"8\":{\"filter_type\":\"NONE\",\"filter_tags\":\"\",\"filter_attributes\":\"\"}}}', '', NULL, NULL, '0', '0', NULL),
('21', '0', 'com_redirect', 'component', 'com_redirect', '', '', '1', '1', '0', '0', '1', '{\"name\":\"com_redirect\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Redirect\"}', '', '', NULL, NULL, '0', '0', NULL),
('22', '0', 'com_users', 'component', 'com_users', '', '', '1', '1', '0', '1', '1', '{\"name\":\"com_users\",\"type\":\"component\",\"creationDate\":\"2006-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_USERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Users\",\"filename\":\"users\"}', '{\"allowUserRegistration\":\"0\",\"new_usertype\":\"2\",\"guest_usergroup\":\"9\",\"sendpassword\":\"0\",\"useractivation\":\"2\",\"mail_to_admin\":\"1\",\"captcha\":\"\",\"frontend_userparams\":\"1\",\"site_language\":\"0\",\"change_login_name\":\"0\",\"domains\":[],\"reset_count\":10,\"reset_time\":1,\"minimum_length\":12,\"minimum_integers\":1,\"minimum_symbols\":1,\"minimum_uppercase\":1,\"minimum_lowercase\":1,\"frontend_show_title\":\"1\",\"captive_template\":\"\",\"mfaonsilent\":\"0\",\"silentresponses\":\"cookie, passwordless\",\"mfaredirectonlogin\":\"0\",\"mfaredirecturl\":\"\",\"mfatrycount\":10,\"mfatrytime\":1,\"save_history\":\"1\",\"history_limit\":5,\"mailSubjectPrefix\":\"\",\"mailBodySuffix\":\"\",\"custom_fields_enable\":\"1\"}', '', NULL, NULL, '0', '0', NULL),
('23', '0', 'com_finder', 'component', 'com_finder', '', '', '1', '1', '0', '0', '1', '{\"name\":\"com_finder\",\"type\":\"component\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Finder\",\"filename\":\"finder\"}', '{\"enabled\":\"0\",\"show_description\":\"1\",\"description_length\":255,\"allow_empty_query\":\"0\",\"show_url\":\"1\",\"show_autosuggest\":\"1\",\"show_suggested_query\":\"1\",\"show_explained_query\":\"1\",\"show_advanced\":\"1\",\"show_advanced_tips\":\"1\",\"expand_advanced\":\"0\",\"show_date_filters\":\"0\",\"sort_order\":\"relevance\",\"sort_direction\":\"desc\",\"highlight_terms\":\"1\",\"opensearch_name\":\"\",\"opensearch_description\":\"\",\"batch_size\":\"50\",\"title_multiplier\":\"1.7\",\"text_multiplier\":\"0.7\",\"meta_multiplier\":\"1.2\",\"path_multiplier\":\"2.0\",\"misc_multiplier\":\"0.3\",\"stem\":\"1\",\"stemmer\":\"snowball\",\"enable_logging\":\"0\"}', '', NULL, NULL, '0', '0', NULL),
('24', '0', 'com_joomlaupdate', 'component', 'com_joomlaupdate', '', '', '1', '1', '0', '1', '1', '{\"name\":\"com_joomlaupdate\",\"type\":\"component\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2012 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.3\",\"description\":\"COM_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Joomlaupdate\"}', '{\"updatesource\":\"default\",\"customurl\":\"\"}', '', NULL, NULL, '0', '0', NULL),
('25', '0', 'com_tags', 'component', 'com_tags', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_tags\",\"type\":\"component\",\"creationDate\":\"2013-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Tags\",\"filename\":\"tags\"}', '{\"tag_layout\":\"_:default\",\"save_history\":\"1\",\"history_limit\":5,\"show_tag_title\":\"0\",\"tag_list_show_tag_image\":\"0\",\"tag_list_show_tag_description\":\"0\",\"tag_list_image\":\"\",\"tag_list_orderby\":\"title\",\"tag_list_orderby_direction\":\"ASC\",\"show_headings\":\"0\",\"tag_list_show_date\":\"0\",\"tag_list_show_item_image\":\"0\",\"tag_list_show_item_description\":\"0\",\"tag_list_item_maximum_characters\":0,\"return_any_or_all\":\"1\",\"include_children\":\"0\",\"maximum\":200,\"tag_list_language_filter\":\"all\",\"tags_layout\":\"_:default\",\"all_tags_orderby\":\"title\",\"all_tags_orderby_direction\":\"ASC\",\"all_tags_show_tag_image\":\"0\",\"all_tags_show_tag_description\":\"0\",\"all_tags_tag_maximum_characters\":20,\"all_tags_show_tag_hits\":\"0\",\"filter_field\":\"1\",\"show_pagination_limit\":\"1\",\"show_pagination\":\"2\",\"show_pagination_results\":\"1\",\"tag_field_ajax_mode\":\"1\",\"show_feed_link\":\"1\"}', '', NULL, NULL, '0', '0', NULL),
('26', '0', 'com_contenthistory', 'component', 'com_contenthistory', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_contenthistory\",\"type\":\"component\",\"creationDate\":\"2013-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_CONTENTHISTORY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Contenthistory\",\"filename\":\"contenthistory\"}', '', '', NULL, NULL, '0', '0', NULL),
('27', '0', 'com_ajax', 'component', 'com_ajax', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_ajax\",\"type\":\"component\",\"creationDate\":\"2013-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_AJAX_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"ajax\"}', '', '', NULL, NULL, '0', '0', NULL),
('28', '0', 'com_postinstall', 'component', 'com_postinstall', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_postinstall\",\"type\":\"component\",\"creationDate\":\"2013-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_POSTINSTALL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Postinstall\"}', '', '', NULL, NULL, '0', '0', NULL),
('29', '0', 'com_fields', 'component', 'com_fields', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_fields\",\"type\":\"component\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, '0', '0', NULL),
('30', '0', 'com_associations', 'component', 'com_associations', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_associations\",\"type\":\"component\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_ASSOCIATIONS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Associations\"}', '', '', NULL, NULL, '0', '0', NULL),
('31', '0', 'com_privacy', 'component', 'com_privacy', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_privacy\",\"type\":\"component\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Privacy\",\"filename\":\"privacy\"}', '', '', NULL, NULL, '0', '0', NULL),
('32', '0', 'com_actionlogs', 'component', 'com_actionlogs', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_actionlogs\",\"type\":\"component\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"COM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Actionlogs\"}', '{\"ip_logging\":0,\"csv_delimiter\":\",\",\"loggable_extensions\":[\"com_banners\",\"com_cache\",\"com_categories\",\"com_checkin\",\"com_config\",\"com_contact\",\"com_content\",\"com_fields\",\"com_guidedtours\",\"com_installer\",\"com_media\",\"com_menus\",\"com_messages\",\"com_modules\",\"com_newsfeeds\",\"com_plugins\",\"com_redirect\",\"com_scheduler\",\"com_tags\",\"com_templates\",\"com_users\"]}', '', NULL, NULL, '0', '0', NULL),
('33', '0', 'com_workflow', 'component', 'com_workflow', '', '', '1', '1', '0', '1', '1', '{\"name\":\"com_workflow\",\"type\":\"component\",\"creationDate\":\"2017-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_WORKFLOW_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Workflow\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('34', '0', 'com_mails', 'component', 'com_mails', '', '', '1', '1', '1', '1', '1', '{\"name\":\"com_mails\",\"type\":\"component\",\"creationDate\":\"2019-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"COM_MAILS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Mails\"}', '', '', NULL, NULL, '0', '0', NULL),
('35', '0', 'com_scheduler', 'component', 'com_scheduler', '', '', '1', '1', '1', '0', '1', '{\"name\":\"com_scheduler\",\"type\":\"component\",\"creationDate\":\"2021-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1.0\",\"description\":\"COM_SCHEDULER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Scheduler\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('36', '0', 'com_guidedtours', 'component', 'com_guidedtours', '', '', '1', '0', '0', '0', '1', '{\"name\":\"com_guidedtours\",\"type\":\"component\",\"creationDate\":\"2023-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"COM_GUIDEDTOURS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Component\\\\Guidedtours\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('37', '0', 'lib_joomla', 'library', 'joomla', '', '', '0', '1', '1', '1', '1', '{\"name\":\"lib_joomla\",\"type\":\"library\",\"creationDate\":\"2008-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2008 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"https:\\/\\/www.joomla.org\",\"version\":\"13.1\",\"description\":\"LIB_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"joomla\"}', '', '', NULL, NULL, '0', '0', NULL),
('38', '0', 'lib_phpass', 'library', 'phpass', '', '', '0', '1', '1', '1', '1', '{\"name\":\"lib_phpass\",\"type\":\"library\",\"creationDate\":\"2004-01\",\"author\":\"Solar Designer\",\"copyright\":\"\",\"authorEmail\":\"solar@openwall.com\",\"authorUrl\":\"https:\\/\\/www.openwall.com\\/phpass\\/\",\"version\":\"0.5.1\",\"description\":\"LIB_PHPASS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"phpass\"}', '', '', NULL, NULL, '0', '0', NULL),
('39', '0', 'mod_articles_archive', 'module', 'mod_articles_archive', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_articles_archive\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_ARCHIVE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesArchive\",\"filename\":\"mod_articles_archive\"}', '', '', NULL, NULL, '0', '0', NULL),
('40', '0', 'mod_articles_latest', 'module', 'mod_articles_latest', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_articles_latest\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesLatest\",\"filename\":\"mod_articles_latest\"}', '', '', NULL, NULL, '0', '0', NULL),
('41', '0', 'mod_articles_popular', 'module', 'mod_articles_popular', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_articles_popular\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesPopular\",\"filename\":\"mod_articles_popular\"}', '', '', NULL, NULL, '0', '0', NULL),
('42', '0', 'mod_banners', 'module', 'mod_banners', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_banners\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Banners\",\"filename\":\"mod_banners\"}', '', '', NULL, NULL, '0', '0', NULL),
('43', '0', 'mod_breadcrumbs', 'module', 'mod_breadcrumbs', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_breadcrumbs\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_BREADCRUMBS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Breadcrumbs\",\"filename\":\"mod_breadcrumbs\"}', '', '', NULL, NULL, '0', '0', NULL),
('44', '0', 'mod_custom', 'module', 'mod_custom', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Custom\",\"filename\":\"mod_custom\"}', '', '', NULL, NULL, '0', '0', NULL),
('45', '0', 'mod_feed', 'module', 'mod_feed', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"2005-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Feed\",\"filename\":\"mod_feed\"}', '', '', NULL, NULL, '0', '0', NULL),
('46', '0', 'mod_footer', 'module', 'mod_footer', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_footer\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FOOTER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Footer\",\"filename\":\"mod_footer\"}', '', '', NULL, NULL, '0', '0', NULL),
('47', '0', 'mod_login', 'module', 'mod_login', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Login\",\"filename\":\"mod_login\"}', '', '', NULL, NULL, '0', '0', NULL),
('48', '0', 'mod_menu', 'module', 'mod_menu', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Menu\",\"filename\":\"mod_menu\"}', '', '', NULL, NULL, '0', '0', NULL),
('49', '0', 'mod_articles_news', 'module', 'mod_articles_news', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_articles_news\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_NEWS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesNews\",\"filename\":\"mod_articles_news\"}', '', '', NULL, NULL, '0', '0', NULL),
('50', '0', 'mod_random_image', 'module', 'mod_random_image', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_random_image\",\"type\":\"module\",\"creationDate\":\"2006-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RANDOM_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\RandomImage\",\"filename\":\"mod_random_image\"}', '', '', NULL, NULL, '0', '0', NULL),
('51', '0', 'mod_related_items', 'module', 'mod_related_items', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_related_items\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_RELATED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\RelatedItems\",\"filename\":\"mod_related_items\"}', '', '', NULL, NULL, '0', '0', NULL),
('52', '0', 'mod_stats', 'module', 'mod_stats', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_stats\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Stats\",\"filename\":\"mod_stats\"}', '', '', NULL, NULL, '0', '0', NULL),
('53', '0', 'mod_syndicate', 'module', 'mod_syndicate', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_syndicate\",\"type\":\"module\",\"creationDate\":\"2006-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SYNDICATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Syndicate\",\"filename\":\"mod_syndicate\"}', '', '', NULL, NULL, '0', '0', NULL),
('54', '0', 'mod_users_latest', 'module', 'mod_users_latest', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_users_latest\",\"type\":\"module\",\"creationDate\":\"2009-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_USERS_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\UsersLatest\",\"filename\":\"mod_users_latest\"}', '', '', NULL, NULL, '0', '0', NULL),
('55', '0', 'mod_whosonline', 'module', 'mod_whosonline', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_whosonline\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WHOSONLINE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Whosonline\",\"filename\":\"mod_whosonline\"}', '', '', NULL, NULL, '0', '0', NULL),
('56', '0', 'mod_wrapper', 'module', 'mod_wrapper', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_wrapper\",\"type\":\"module\",\"creationDate\":\"2004-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_WRAPPER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Wrapper\",\"filename\":\"mod_wrapper\"}', '', '', NULL, NULL, '0', '0', NULL),
('57', '0', 'mod_articles_category', 'module', 'mod_articles_category', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_articles_category\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesCategory\",\"filename\":\"mod_articles_category\"}', '', '', NULL, NULL, '0', '0', NULL),
('58', '0', 'mod_articles_categories', 'module', 'mod_articles_categories', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_articles_categories\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_ARTICLES_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\ArticlesCategories\",\"filename\":\"mod_articles_categories\"}', '', '', NULL, NULL, '0', '0', NULL),
('59', '0', 'mod_languages', 'module', 'mod_languages', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_languages\",\"type\":\"module\",\"creationDate\":\"2010-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"MOD_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Languages\",\"filename\":\"mod_languages\"}', '', '', NULL, NULL, '0', '0', NULL),
('60', '0', 'mod_finder', 'module', 'mod_finder', '', '', '0', '1', '0', '0', '1', '{\"name\":\"mod_finder\",\"type\":\"module\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Finder\",\"filename\":\"mod_finder\"}', '', '', NULL, NULL, '0', '0', NULL),
('61', '0', 'MOD_ARTICLES', 'module', 'mod_articles', '', '', '0', '1', '0', '0', '1', '{\"name\":\"MOD_ARTICLES\",\"type\":\"module\",\"creationDate\":\"2024-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2024 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.2.0\",\"description\":\"MOD_ARTICLES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Articles\",\"filename\":\"mod_articles\"}', '', '', NULL, NULL, '0', '0', NULL),
('62', '0', 'mod_custom', 'module', 'mod_custom', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_custom\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Custom\",\"filename\":\"mod_custom\"}', '', '', NULL, NULL, '0', '0', NULL),
('63', '0', 'mod_feed', 'module', 'mod_feed', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_feed\",\"type\":\"module\",\"creationDate\":\"2005-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_FEED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Feed\",\"filename\":\"mod_feed\"}', '', '', NULL, NULL, '0', '0', NULL),
('64', '0', 'mod_latest', 'module', 'mod_latest', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_latest\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LATEST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Latest\",\"filename\":\"mod_latest\"}', '', '', NULL, NULL, '0', '0', NULL),
('65', '0', 'mod_logged', 'module', 'mod_logged', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_logged\",\"type\":\"module\",\"creationDate\":\"2005-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGGED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Logged\",\"filename\":\"mod_logged\"}', '', '', NULL, NULL, '0', '0', NULL),
('66', '0', 'mod_login', 'module', 'mod_login', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_login\",\"type\":\"module\",\"creationDate\":\"2005-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_LOGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Login\",\"filename\":\"mod_login\"}', '', '', NULL, NULL, '0', '0', NULL),
('67', '0', 'mod_loginsupport', 'module', 'mod_loginsupport', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_loginsupport\",\"type\":\"module\",\"creationDate\":\"2019-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_LOGINSUPPORT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Loginsupport\",\"filename\":\"mod_loginsupport\"}', '', '', NULL, NULL, '0', '0', NULL),
('68', '0', 'mod_menu', 'module', 'mod_menu', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_menu\",\"type\":\"module\",\"creationDate\":\"2006-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Menu\",\"filename\":\"mod_menu\"}', '', '', NULL, NULL, '0', '0', NULL),
('69', '0', 'mod_popular', 'module', 'mod_popular', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_popular\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Popular\",\"filename\":\"mod_popular\"}', '', '', NULL, NULL, '0', '0', NULL),
('70', '0', 'mod_quickicon', 'module', 'mod_quickicon', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_quickicon\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_QUICKICON_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Quickicon\",\"filename\":\"mod_quickicon\"}', '', '', NULL, NULL, '0', '0', NULL),
('71', '0', 'mod_frontend', 'module', 'mod_frontend', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_frontend\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_FRONTEND_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Frontend\",\"filename\":\"mod_frontend\"}', '', '', NULL, NULL, '0', '0', NULL),
('72', '0', 'mod_messages', 'module', 'mod_messages', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_messages\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Messages\",\"filename\":\"mod_messages\"}', '', '', NULL, NULL, '0', '0', NULL),
('73', '0', 'mod_post_installation_messages', 'module', 'mod_post_installation_messages', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_post_installation_messages\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_POST_INSTALLATION_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\PostInstallationMessages\",\"filename\":\"mod_post_installation_messages\"}', '', '', NULL, NULL, '0', '0', NULL),
('74', '0', 'mod_user', 'module', 'mod_user', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_user\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_USER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\User\",\"filename\":\"mod_user\"}', '', '', NULL, NULL, '0', '0', NULL),
('75', '0', 'mod_title', 'module', 'mod_title', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_title\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TITLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Title\",\"filename\":\"mod_title\"}', '', '', NULL, NULL, '0', '0', NULL),
('76', '0', 'mod_toolbar', 'module', 'mod_toolbar', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_toolbar\",\"type\":\"module\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_TOOLBAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Toolbar\",\"filename\":\"mod_toolbar\"}', '', '', NULL, NULL, '0', '0', NULL),
('77', '0', 'mod_multilangstatus', 'module', 'mod_multilangstatus', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_multilangstatus\",\"type\":\"module\",\"creationDate\":\"2011-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_MULTILANGSTATUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\MultilangStatus\",\"filename\":\"mod_multilangstatus\"}', '{\"cache\":\"0\"}', '', NULL, NULL, '0', '0', NULL),
('78', '0', 'mod_version', 'module', 'mod_version', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_version\",\"type\":\"module\",\"creationDate\":\"2012-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2012 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_VERSION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Version\",\"filename\":\"mod_version\"}', '{\"cache\":\"0\"}', '', NULL, NULL, '0', '0', NULL),
('79', '0', 'mod_stats_admin', 'module', 'mod_stats_admin', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_stats_admin\",\"type\":\"module\",\"creationDate\":\"2004-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_STATS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\StatsAdmin\",\"filename\":\"mod_stats_admin\"}', '{\"serverinfo\":\"0\",\"siteinfo\":\"0\",\"counter\":\"0\",\"increase\":\"0\",\"cache\":\"1\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', NULL, NULL, '0', '0', NULL),
('80', '0', 'mod_tags_popular', 'module', 'mod_tags_popular', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_tags_popular\",\"type\":\"module\",\"creationDate\":\"2013-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_POPULAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\TagsPopular\",\"filename\":\"mod_tags_popular\"}', '{\"maximum\":\"5\",\"timeframe\":\"alltime\",\"owncache\":\"1\"}', '', NULL, NULL, '0', '0', NULL),
('81', '0', 'mod_tags_similar', 'module', 'mod_tags_similar', '', '', '0', '1', '1', '0', '1', '{\"name\":\"mod_tags_similar\",\"type\":\"module\",\"creationDate\":\"2013-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.1.0\",\"description\":\"MOD_TAGS_SIMILAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\TagsSimilar\",\"filename\":\"mod_tags_similar\"}', '{\"maximum\":\"5\",\"matchtype\":\"any\",\"owncache\":\"1\"}', '', NULL, NULL, '0', '0', NULL),
('82', '0', 'mod_sampledata', 'module', 'mod_sampledata', '', '', '1', '0', '1', '0', '1', '{\"name\":\"mod_sampledata\",\"type\":\"module\",\"creationDate\":\"2017-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"MOD_SAMPLEDATA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Sampledata\",\"filename\":\"mod_sampledata\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('83', '0', 'mod_latestactions', 'module', 'mod_latestactions', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_latestactions\",\"type\":\"module\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_LATESTACTIONS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\LatestActions\",\"filename\":\"mod_latestactions\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('84', '0', 'mod_privacy_dashboard', 'module', 'mod_privacy_dashboard', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_privacy_dashboard\",\"type\":\"module\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"MOD_PRIVACY_DASHBOARD_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\PrivacyDashboard\",\"filename\":\"mod_privacy_dashboard\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('85', '0', 'mod_submenu', 'module', 'mod_submenu', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_submenu\",\"type\":\"module\",\"creationDate\":\"2006-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"MOD_SUBMENU_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\Submenu\",\"filename\":\"mod_submenu\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('86', '0', 'mod_privacy_status', 'module', 'mod_privacy_status', '', '', '1', '1', '1', '0', '1', '{\"name\":\"mod_privacy_status\",\"type\":\"module\",\"creationDate\":\"2019-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"MOD_PRIVACY_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\PrivacyStatus\",\"filename\":\"mod_privacy_status\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('87', '0', 'mod_guidedtours', 'module', 'mod_guidedtours', '', '', '1', '0', '1', '0', '1', '{\"name\":\"mod_guidedtours\",\"type\":\"module\",\"creationDate\":\"2023-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"MOD_GUIDEDTOURS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Module\\\\GuidedTours\",\"filename\":\"mod_guidedtours\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('88', '0', 'plg_actionlog_joomla', 'plugin', 'joomla', '', 'actionlog', '0', '1', '1', '0', '1', '{\"name\":\"plg_actionlog_joomla\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_ACTIONLOG_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Actionlog\\\\Joomla\",\"filename\":\"joomla\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('89', '0', 'plg_api-authentication_basic', 'plugin', 'basic', '', 'api-authentication', '0', '0', '1', '0', '1', '{\"name\":\"plg_api-authentication_basic\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_API-AUTHENTICATION_BASIC_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\ApiAuthentication\\\\Basic\",\"filename\":\"basic\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('90', '0', 'plg_api-authentication_token', 'plugin', 'token', '', 'api-authentication', '0', '1', '1', '0', '1', '{\"name\":\"plg_api-authentication_token\",\"type\":\"plugin\",\"creationDate\":\"2019-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_API-AUTHENTICATION_TOKEN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\ApiAuthentication\\\\Token\",\"filename\":\"token\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('91', '0', 'plg_authentication_cookie', 'plugin', 'cookie', '', 'authentication', '0', '1', '1', '0', '1', '{\"name\":\"plg_authentication_cookie\",\"type\":\"plugin\",\"creationDate\":\"2013-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTHENTICATION_COOKIE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Authentication\\\\Cookie\",\"filename\":\"cookie\"}', '', '', NULL, NULL, '1', '0', NULL),
('92', '0', 'plg_authentication_joomla', 'plugin', 'joomla', '', 'authentication', '0', '1', '1', '1', '1', '{\"name\":\"plg_authentication_joomla\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_AUTHENTICATION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Authentication\\\\Joomla\",\"filename\":\"joomla\"}', '', '', NULL, NULL, '2', '0', NULL),
('93', '0', 'plg_authentication_ldap', 'plugin', 'ldap', '', 'authentication', '0', '0', '1', '0', '1', '{\"name\":\"plg_authentication_ldap\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LDAP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Authentication\\\\Ldap\",\"filename\":\"ldap\"}', '{\"host\":\"\",\"port\":\"389\",\"use_ldapV3\":\"0\",\"negotiate_tls\":\"0\",\"no_referrals\":\"0\",\"auth_method\":\"bind\",\"base_dn\":\"\",\"search_string\":\"\",\"users_dn\":\"\",\"username\":\"admin\",\"password\":\"bobby7\",\"ldap_fullname\":\"fullName\",\"ldap_email\":\"mail\",\"ldap_uid\":\"uid\"}', '', NULL, NULL, '3', '0', NULL),
('94', '0', 'plg_behaviour_compat', 'plugin', 'compat', '', 'behaviour', '0', '1', '1', '0', '1', '{\"name\":\"plg_behaviour_compat\",\"type\":\"plugin\",\"creationDate\":\"2023-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_COMPAT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Behaviour\\\\Compat\",\"filename\":\"compat\"}', '{\"classes_aliases\":\"1\",\"es5_assets\":\"1\"}', '', NULL, NULL, '1', '0', NULL),
('95', '0', 'plg_behaviour_taggable', 'plugin', 'taggable', '', 'behaviour', '0', '1', '1', '0', '1', '{\"name\":\"plg_behaviour_taggable\",\"type\":\"plugin\",\"creationDate\":\"2015-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_BEHAVIOUR_TAGGABLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Behaviour\\\\Taggable\",\"filename\":\"taggable\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('96', '0', 'plg_behaviour_versionable', 'plugin', 'versionable', '', 'behaviour', '0', '1', '1', '0', '1', '{\"name\":\"plg_behaviour_versionable\",\"type\":\"plugin\",\"creationDate\":\"2015-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_BEHAVIOUR_VERSIONABLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Behaviour\\\\Versionable\",\"filename\":\"versionable\"}', '{}', '', NULL, NULL, '3', '0', NULL),
('97', '0', 'plg_content_confirmconsent', 'plugin', 'confirmconsent', '', 'content', '0', '0', '1', '0', '1', '{\"name\":\"plg_content_confirmconsent\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_CONTENT_CONFIRMCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\ConfirmConsent\",\"filename\":\"confirmconsent\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('98', '0', 'plg_content_contact', 'plugin', 'contact', '', 'content', '0', '1', '1', '0', '1', '{\"name\":\"plg_content_contact\",\"type\":\"plugin\",\"creationDate\":\"2014-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2014 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.2\",\"description\":\"PLG_CONTENT_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Contact\",\"filename\":\"contact\"}', '', '', NULL, NULL, '2', '0', NULL),
('99', '0', 'plg_content_emailcloak', 'plugin', 'emailcloak', '', 'content', '0', '1', '1', '0', '1', '{\"name\":\"plg_content_emailcloak\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_EMAILCLOAK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\EmailCloak\",\"filename\":\"emailcloak\"}', '{\"mode\":\"1\"}', '', NULL, NULL, '3', '0', NULL),
('100', '0', 'plg_content_fields', 'plugin', 'fields', '', 'content', '0', '1', '1', '0', '1', '{\"name\":\"plg_content_fields\",\"type\":\"plugin\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_CONTENT_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, '4', '0', NULL),
('101', '0', 'plg_content_finder', 'plugin', 'finder', '', 'content', '0', '1', '1', '0', '1', '{\"name\":\"plg_content_finder\",\"type\":\"plugin\",\"creationDate\":\"2011-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Finder\",\"filename\":\"finder\"}', '', '', NULL, NULL, '5', '0', NULL),
('102', '0', 'plg_content_joomla', 'plugin', 'joomla', '', 'content', '0', '1', '1', '0', '1', '{\"name\":\"plg_content_joomla\",\"type\":\"plugin\",\"creationDate\":\"2010-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Joomla\",\"filename\":\"joomla\"}', '', '', NULL, NULL, '6', '0', NULL),
('103', '0', 'plg_content_loadmodule', 'plugin', 'loadmodule', '', 'content', '0', '1', '1', '0', '1', '{\"name\":\"plg_content_loadmodule\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOADMODULE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\LoadModule\",\"filename\":\"loadmodule\"}', '{\"style\":\"xhtml\"}', '', NULL, NULL, '7', '0', NULL),
('104', '0', 'plg_content_pagebreak', 'plugin', 'pagebreak', '', 'content', '0', '1', '1', '0', '1', '{\"name\":\"plg_content_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTENT_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\PageBreak\",\"filename\":\"pagebreak\"}', '{\"title\":\"1\",\"multipage_toc\":\"1\",\"showall\":\"1\"}', '', NULL, NULL, '8', '0', NULL),
('105', '0', 'plg_content_pagenavigation', 'plugin', 'pagenavigation', '', 'content', '0', '1', '1', '0', '1', '{\"name\":\"plg_content_pagenavigation\",\"type\":\"plugin\",\"creationDate\":\"2006-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_PAGENAVIGATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\PageNavigation\",\"filename\":\"pagenavigation\"}', '{\"position\":\"1\"}', '', NULL, NULL, '9', '0', NULL),
('106', '0', 'plg_content_vote', 'plugin', 'vote', '', 'content', '0', '0', '1', '0', '1', '{\"name\":\"plg_content_vote\",\"type\":\"plugin\",\"creationDate\":\"2005-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_VOTE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Content\\\\Vote\",\"filename\":\"vote\"}', '', '', NULL, NULL, '10', '0', NULL),
('107', '0', 'plg_editors-xtd_article', 'plugin', 'article', '', 'editors-xtd', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors-xtd_article\",\"type\":\"plugin\",\"creationDate\":\"2009-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Article\",\"filename\":\"article\"}', '', '', NULL, NULL, '1', '0', NULL),
('108', '0', 'plg_editors-xtd_contact', 'plugin', 'contact', '', 'editors-xtd', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors-xtd_contact\",\"type\":\"plugin\",\"creationDate\":\"2016-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Contact\",\"filename\":\"contact\"}', '', '', NULL, NULL, '2', '0', NULL),
('109', '0', 'plg_editors-xtd_fields', 'plugin', 'fields', '', 'editors-xtd', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors-xtd_fields\",\"type\":\"plugin\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, '3', '0', NULL),
('110', '0', 'plg_editors-xtd_image', 'plugin', 'image', '', 'editors-xtd', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors-xtd_image\",\"type\":\"plugin\",\"creationDate\":\"2004-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_IMAGE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Image\",\"filename\":\"image\"}', '', '', NULL, NULL, '4', '0', NULL),
('111', '0', 'plg_editors-xtd_menu', 'plugin', 'menu', '', 'editors-xtd', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors-xtd_menu\",\"type\":\"plugin\",\"creationDate\":\"2016-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_EDITORS-XTD_MENU_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Menu\",\"filename\":\"menu\"}', '', '', NULL, NULL, '5', '0', NULL),
('112', '0', 'plg_editors-xtd_module', 'plugin', 'module', '', 'editors-xtd', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors-xtd_module\",\"type\":\"plugin\",\"creationDate\":\"2015-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2015 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_MODULE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\Module\",\"filename\":\"module\"}', '', '', NULL, NULL, '6', '0', NULL),
('113', '0', 'plg_editors-xtd_pagebreak', 'plugin', 'pagebreak', '', 'editors-xtd', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors-xtd_pagebreak\",\"type\":\"plugin\",\"creationDate\":\"2004-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EDITORSXTD_PAGEBREAK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\PageBreak\",\"filename\":\"pagebreak\"}', '', '', NULL, NULL, '7', '0', NULL),
('114', '0', 'plg_editors-xtd_readmore', 'plugin', 'readmore', '', 'editors-xtd', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors-xtd_readmore\",\"type\":\"plugin\",\"creationDate\":\"2006-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_READMORE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\EditorsXtd\\\\ReadMore\",\"filename\":\"readmore\"}', '', '', NULL, NULL, '8', '0', NULL),
('115', '0', 'plg_editors_codemirror', 'plugin', 'codemirror', '', 'editors', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors_codemirror\",\"type\":\"plugin\",\"creationDate\":\"28 March 2011\",\"author\":\"Marijn Haverbeke\",\"copyright\":\"Copyright (C) 2014 - 2021 by Marijn Haverbeke <marijnh@gmail.com> and others\",\"authorEmail\":\"marijnh@gmail.com\",\"authorUrl\":\"https:\\/\\/codemirror.net\\/\",\"version\":\"6.0.0\",\"description\":\"PLG_CODEMIRROR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Editors\\\\CodeMirror\",\"filename\":\"codemirror\"}', '{\"lineNumbers\":\"1\",\"lineWrapping\":\"1\",\"matchTags\":\"1\",\"matchBrackets\":\"1\",\"marker-gutter\":\"1\",\"autoCloseTags\":\"1\",\"autoCloseBrackets\":\"1\",\"autoFocus\":\"1\",\"theme\":\"default\",\"tabmode\":\"indent\"}', '', NULL, NULL, '1', '0', NULL),
('116', '0', 'plg_editors_none', 'plugin', 'none', '', 'editors', '0', '1', '1', '1', '1', '{\"name\":\"plg_editors_none\",\"type\":\"plugin\",\"creationDate\":\"2005-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_NONE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Editors\\\\None\",\"filename\":\"none\"}', '', '', NULL, NULL, '2', '0', NULL),
('117', '0', 'plg_editors_tinymce', 'plugin', 'tinymce', '', 'editors', '0', '1', '1', '0', '1', '{\"name\":\"plg_editors_tinymce\",\"type\":\"plugin\",\"creationDate\":\"2005-08\",\"author\":\"Tiny Technologies, Inc\",\"copyright\":\"Tiny Technologies, Inc\",\"authorEmail\":\"N\\/A\",\"authorUrl\":\"https:\\/\\/www.tiny.cloud\",\"version\":\"6.8.6\",\"description\":\"PLG_TINY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Editors\\\\TinyMCE\",\"filename\":\"tinymce\"}', '{\"configuration\":{\"toolbars\":{\"2\":{\"toolbar1\":[\"bold\",\"underline\",\"strikethrough\",\"|\",\"undo\",\"redo\",\"|\",\"bullist\",\"numlist\",\"|\",\"pastetext\"]},\"1\":{\"menu\":[\"edit\",\"insert\",\"view\",\"format\",\"table\",\"tools\"],\"toolbar1\":[\"bold\",\"italic\",\"underline\",\"strikethrough\",\"|\",\"alignleft\",\"aligncenter\",\"alignright\",\"alignjustify\",\"|\",\"blocks\",\"|\",\"bullist\",\"numlist\",\"|\",\"outdent\",\"indent\",\"|\",\"undo\",\"redo\",\"|\",\"link\",\"unlink\",\"anchor\",\"code\",\"|\",\"hr\",\"table\",\"|\",\"subscript\",\"superscript\",\"|\",\"charmap\",\"pastetext\",\"preview\"]},\"0\":{\"menu\":[\"edit\",\"insert\",\"view\",\"format\",\"table\",\"tools\"],\"toolbar1\":[\"bold\",\"italic\",\"underline\",\"strikethrough\",\"|\",\"alignleft\",\"aligncenter\",\"alignright\",\"alignjustify\",\"|\",\"styles\",\"|\",\"blocks\",\"fontfamily\",\"fontsize\",\"|\",\"searchreplace\",\"|\",\"bullist\",\"numlist\",\"|\",\"outdent\",\"indent\",\"|\",\"undo\",\"redo\",\"|\",\"link\",\"unlink\",\"anchor\",\"image\",\"|\",\"code\",\"|\",\"forecolor\",\"backcolor\",\"|\",\"fullscreen\",\"|\",\"table\",\"|\",\"subscript\",\"superscript\",\"|\",\"charmap\",\"emoticons\",\"media\",\"hr\",\"ltr\",\"rtl\",\"|\",\"cut\",\"copy\",\"paste\",\"pastetext\",\"|\",\"visualchars\",\"visualblocks\",\"nonbreaking\",\"blockquote\",\"jtemplate\",\"|\",\"print\",\"preview\",\"codesample\",\"insertdatetime\",\"removeformat\"]}},\"setoptions\":{\"2\":{\"access\":[\"1\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"0\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"},\"1\":{\"access\":[\"6\",\"2\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"0\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"},\"0\":{\"access\":[\"7\",\"4\",\"8\"],\"skin\":\"0\",\"skin_admin\":\"0\",\"mobile\":\"0\",\"drag_drop\":\"1\",\"path\":\"\",\"entity_encoding\":\"raw\",\"lang_mode\":\"1\",\"text_direction\":\"ltr\",\"content_css\":\"1\",\"content_css_custom\":\"\",\"relative_urls\":\"1\",\"newlines\":\"0\",\"use_config_textfilters\":\"0\",\"invalid_elements\":\"script,applet,iframe\",\"valid_elements\":\"\",\"extended_elements\":\"\",\"resizing\":\"1\",\"resize_horizontal\":\"1\",\"element_path\":\"1\",\"wordcount\":\"1\",\"image_advtab\":\"1\",\"advlist\":\"1\",\"autosave\":\"1\",\"contextmenu\":\"1\",\"custom_plugin\":\"\",\"custom_button\":\"\"}}},\"sets_amount\":3,\"html_height\":\"550\",\"html_width\":\"750\"}', '', NULL, NULL, '3', '0', NULL),
('118', '0', 'plg_extension_finder', 'plugin', 'finder', '', 'extension', '0', '1', '1', '0', '1', '{\"name\":\"plg_extension_finder\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_EXTENSION_FINDER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\Finder\",\"filename\":\"finder\"}', '', '', NULL, NULL, '1', '0', NULL),
('119', '0', 'plg_extension_joomla', 'plugin', 'joomla', '', 'extension', '0', '1', '1', '0', '1', '{\"name\":\"plg_extension_joomla\",\"type\":\"plugin\",\"creationDate\":\"2010-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_EXTENSION_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\Joomla\",\"filename\":\"joomla\"}', '', '', NULL, NULL, '2', '0', NULL),
('120', '0', 'plg_extension_namespacemap', 'plugin', 'namespacemap', '', 'extension', '0', '1', '1', '1', '1', '{\"name\":\"plg_extension_namespacemap\",\"type\":\"plugin\",\"creationDate\":\"2017-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_EXTENSION_NAMESPACEMAP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\NamespaceMap\",\"filename\":\"namespacemap\"}', '{}', '', NULL, NULL, '3', '0', NULL),
('121', '0', 'plg_fields_calendar', 'plugin', 'calendar', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_calendar\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CALENDAR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Calendar\",\"filename\":\"calendar\"}', '', '', NULL, NULL, '1', '0', NULL),
('122', '0', 'plg_fields_checkboxes', 'plugin', 'checkboxes', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_checkboxes\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_CHECKBOXES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Checkboxes\",\"filename\":\"checkboxes\"}', '', '', NULL, NULL, '2', '0', NULL),
('123', '0', 'plg_fields_color', 'plugin', 'color', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_color\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_COLOR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Color\",\"filename\":\"color\"}', '', '', NULL, NULL, '3', '0', NULL),
('124', '0', 'plg_fields_editor', 'plugin', 'editor', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_editor\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_EDITOR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Editor\",\"filename\":\"editor\"}', '{\"buttons\":0,\"width\":\"100%\",\"height\":\"250px\",\"filter\":\"\\\\Joomla\\\\CMS\\\\Component\\\\ComponentHelper::filterText\"}', '', NULL, NULL, '4', '0', NULL),
('125', '0', 'plg_fields_imagelist', 'plugin', 'imagelist', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_imagelist\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_IMAGELIST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Imagelist\",\"filename\":\"imagelist\"}', '', '', NULL, NULL, '5', '0', NULL),
('126', '0', 'plg_fields_integer', 'plugin', 'integer', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_integer\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_INTEGER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Integer\",\"filename\":\"integer\"}', '{\"multiple\":\"0\",\"first\":\"1\",\"last\":\"100\",\"step\":\"1\"}', '', NULL, NULL, '6', '0', NULL),
('127', '0', 'plg_fields_list', 'plugin', 'list', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_list\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_LIST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\ListField\",\"filename\":\"list\"}', '', '', NULL, NULL, '7', '0', NULL),
('128', '0', 'plg_fields_media', 'plugin', 'media', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_media\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Media\",\"filename\":\"media\"}', '', '', NULL, NULL, '8', '0', NULL),
('129', '0', 'plg_fields_radio', 'plugin', 'radio', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_radio\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_RADIO_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Radio\",\"filename\":\"radio\"}', '', '', NULL, NULL, '9', '0', NULL),
('130', '0', 'plg_fields_sql', 'plugin', 'sql', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_sql\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_SQL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\SQL\",\"filename\":\"sql\"}', '', '', NULL, NULL, '10', '0', NULL),
('131', '0', 'plg_fields_subform', 'plugin', 'subform', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_subform\",\"type\":\"plugin\",\"creationDate\":\"2017-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_FIELDS_SUBFORM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Subform\",\"filename\":\"subform\"}', '', '', NULL, NULL, '11', '0', NULL),
('132', '0', 'plg_fields_text', 'plugin', 'text', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_text\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Text\",\"filename\":\"text\"}', '', '', NULL, NULL, '12', '0', NULL),
('133', '0', 'plg_fields_textarea', 'plugin', 'textarea', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_textarea\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_TEXTAREA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Textarea\",\"filename\":\"textarea\"}', '{\"rows\":10,\"cols\":10,\"maxlength\":\"\",\"filter\":\"\\\\Joomla\\\\CMS\\\\Component\\\\ComponentHelper::filterText\"}', '', NULL, NULL, '13', '0', NULL),
('134', '0', 'plg_fields_url', 'plugin', 'url', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_url\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_URL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\Url\",\"filename\":\"url\"}', '', '', NULL, NULL, '14', '0', NULL),
('135', '0', 'plg_fields_user', 'plugin', 'user', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_user\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\User\",\"filename\":\"user\"}', '', '', NULL, NULL, '15', '0', NULL),
('136', '0', 'plg_fields_usergrouplist', 'plugin', 'usergrouplist', '', 'fields', '0', '1', '1', '0', '1', '{\"name\":\"plg_fields_usergrouplist\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_FIELDS_USERGROUPLIST_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\UsergroupList\",\"filename\":\"usergrouplist\"}', '', '', NULL, NULL, '16', '0', NULL),
('137', '0', 'plg_filesystem_local', 'plugin', 'local', '', 'filesystem', '0', '1', '1', '0', '1', '{\"name\":\"plg_filesystem_local\",\"type\":\"plugin\",\"creationDate\":\"2017-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_FILESYSTEM_LOCAL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Filesystem\\\\Local\",\"filename\":\"local\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('138', '0', 'plg_finder_categories', 'plugin', 'categories', '', 'finder', '0', '1', '1', '0', '1', '{\"name\":\"plg_finder_categories\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CATEGORIES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Categories\",\"filename\":\"categories\"}', '', '', NULL, NULL, '1', '0', NULL),
('139', '0', 'plg_finder_contacts', 'plugin', 'contacts', '', 'finder', '0', '1', '1', '0', '1', '{\"name\":\"plg_finder_contacts\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTACTS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Contacts\",\"filename\":\"contacts\"}', '', '', NULL, NULL, '2', '0', NULL),
('140', '0', 'plg_finder_content', 'plugin', 'content', '', 'finder', '0', '1', '1', '0', '1', '{\"name\":\"plg_finder_content\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Content\",\"filename\":\"content\"}', '', '', NULL, NULL, '3', '0', NULL),
('141', '0', 'plg_finder_newsfeeds', 'plugin', 'newsfeeds', '', 'finder', '0', '1', '1', '0', '1', '{\"name\":\"plg_finder_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Newsfeeds\",\"filename\":\"newsfeeds\"}', '', '', NULL, NULL, '4', '0', NULL),
('142', '0', 'plg_finder_tags', 'plugin', 'tags', '', 'finder', '0', '1', '1', '0', '1', '{\"name\":\"plg_finder_tags\",\"type\":\"plugin\",\"creationDate\":\"2013-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_FINDER_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Finder\\\\Tags\",\"filename\":\"tags\"}', '', '', NULL, NULL, '5', '0', NULL),
('143', '0', 'plg_installer_folderinstaller', 'plugin', 'folderinstaller', '', 'installer', '0', '1', '1', '0', '1', '{\"name\":\"plg_installer_folderinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_FOLDERINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Folder\",\"filename\":\"folderinstaller\"}', '', '', NULL, NULL, '2', '0', NULL),
('144', '0', 'plg_installer_override', 'plugin', 'override', '', 'installer', '0', '1', '1', '0', '1', '{\"name\":\"plg_installer_override\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_INSTALLER_OVERRIDE_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Override\",\"filename\":\"override\"}', '', '', NULL, NULL, '4', '0', NULL),
('145', '0', 'plg_installer_packageinstaller', 'plugin', 'packageinstaller', '', 'installer', '0', '1', '1', '0', '1', '{\"name\":\"plg_installer_packageinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_PACKAGEINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Package\",\"filename\":\"packageinstaller\"}', '', '', NULL, NULL, '1', '0', NULL),
('146', '0', 'plg_installer_urlinstaller', 'plugin', 'urlinstaller', '', 'installer', '0', '1', '1', '0', '1', '{\"name\":\"plg_installer_urlinstaller\",\"type\":\"plugin\",\"creationDate\":\"2016-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.6.0\",\"description\":\"PLG_INSTALLER_URLINSTALLER_PLUGIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Url\",\"filename\":\"urlinstaller\"}', '', '', NULL, NULL, '3', '0', NULL),
('147', '0', 'plg_installer_webinstaller', 'plugin', 'webinstaller', '', 'installer', '0', '0', '1', '0', '1', '{\"name\":\"plg_installer_webinstaller\",\"type\":\"plugin\",\"creationDate\":\"2017-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_INSTALLER_WEBINSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Web\",\"filename\":\"webinstaller\"}', '{\"tab_position\":\"1\"}', '', NULL, NULL, '5', '0', NULL),
('148', '0', 'plg_media-action_crop', 'plugin', 'crop', '', 'media-action', '0', '1', '1', '0', '1', '{\"name\":\"plg_media-action_crop\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_CROP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\MediaAction\\\\Crop\",\"filename\":\"crop\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('149', '0', 'plg_media-action_resize', 'plugin', 'resize', '', 'media-action', '0', '1', '1', '0', '1', '{\"name\":\"plg_media-action_resize\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_RESIZE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\MediaAction\\\\Resize\",\"filename\":\"resize\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('150', '0', 'plg_media-action_rotate', 'plugin', 'rotate', '', 'media-action', '0', '1', '1', '0', '1', '{\"name\":\"plg_media-action_rotate\",\"type\":\"plugin\",\"creationDate\":\"2017-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_MEDIA-ACTION_ROTATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\MediaAction\\\\Rotate\",\"filename\":\"rotate\"}', '{}', '', NULL, NULL, '3', '0', NULL),
('151', '0', 'plg_privacy_actionlogs', 'plugin', 'actionlogs', '', 'privacy', '0', '1', '1', '0', '1', '{\"name\":\"plg_privacy_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Actionlogs\",\"filename\":\"actionlogs\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('152', '0', 'plg_privacy_consents', 'plugin', 'consents', '', 'privacy', '0', '1', '1', '0', '1', '{\"name\":\"plg_privacy_consents\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONSENTS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Consents\",\"filename\":\"consents\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('153', '0', 'plg_privacy_contact', 'plugin', 'contact', '', 'privacy', '0', '1', '1', '0', '1', '{\"name\":\"plg_privacy_contact\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Contact\",\"filename\":\"contact\"}', '{}', '', NULL, NULL, '3', '0', NULL),
('154', '0', 'plg_privacy_content', 'plugin', 'content', '', 'privacy', '0', '1', '1', '0', '1', '{\"name\":\"plg_privacy_content\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Content\",\"filename\":\"content\"}', '{}', '', NULL, NULL, '4', '0', NULL),
('155', '0', 'plg_privacy_message', 'plugin', 'message', '', 'privacy', '0', '1', '1', '0', '1', '{\"name\":\"plg_privacy_message\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_MESSAGE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\Message\",\"filename\":\"message\"}', '{}', '', NULL, NULL, '5', '0', NULL),
('156', '0', 'plg_privacy_user', 'plugin', 'user', '', 'privacy', '0', '1', '1', '0', '1', '{\"name\":\"plg_privacy_user\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_PRIVACY_USER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Privacy\\\\User\",\"filename\":\"user\"}', '{}', '', NULL, NULL, '6', '0', NULL),
('157', '0', 'plg_quickicon_joomlaupdate', 'plugin', 'joomlaupdate', '', 'quickicon', '0', '1', '1', '0', '1', '{\"name\":\"plg_quickicon_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Joomlaupdate\",\"filename\":\"joomlaupdate\"}', '', '', NULL, NULL, '1', '0', NULL),
('158', '0', 'plg_quickicon_extensionupdate', 'plugin', 'extensionupdate', '', 'quickicon', '0', '1', '1', '0', '1', '{\"name\":\"plg_quickicon_extensionupdate\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_QUICKICON_EXTENSIONUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Extensionupdate\",\"filename\":\"extensionupdate\"}', '', '', NULL, NULL, '2', '0', NULL),
('159', '0', 'plg_quickicon_overridecheck', 'plugin', 'overridecheck', '', 'quickicon', '0', '1', '1', '0', '1', '{\"name\":\"plg_quickicon_overridecheck\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_QUICKICON_OVERRIDECHECK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\OverrideCheck\",\"filename\":\"overridecheck\"}', '', '', NULL, NULL, '3', '0', NULL),
('160', '0', 'plg_quickicon_downloadkey', 'plugin', 'downloadkey', '', 'quickicon', '0', '1', '1', '0', '1', '{\"name\":\"plg_quickicon_downloadkey\",\"type\":\"plugin\",\"creationDate\":\"2019-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_QUICKICON_DOWNLOADKEY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Downloadkey\",\"filename\":\"downloadkey\"}', '', '', NULL, NULL, '4', '0', NULL),
('161', '0', 'plg_quickicon_privacycheck', 'plugin', 'privacycheck', '', 'quickicon', '0', '1', '1', '0', '1', '{\"name\":\"plg_quickicon_privacycheck\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_QUICKICON_PRIVACYCHECK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\PrivacyCheck\",\"filename\":\"privacycheck\"}', '{}', '', NULL, NULL, '5', '0', NULL),
('162', '0', 'plg_quickicon_phpversioncheck', 'plugin', 'phpversioncheck', '', 'quickicon', '0', '1', '1', '0', '1', '{\"name\":\"plg_quickicon_phpversioncheck\",\"type\":\"plugin\",\"creationDate\":\"2016-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_QUICKICON_PHPVERSIONCHECK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\PhpVersionCheck\",\"filename\":\"phpversioncheck\"}', '', '', NULL, NULL, '6', '0', NULL),
('163', '0', 'plg_quickicon_eos', 'plugin', 'eos', '', 'quickicon', '0', '1', '1', '0', '1', '{\"name\":\"plg_quickicon_eos\",\"type\":\"plugin\",\"creationDate\":\"2023-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.4.0\",\"description\":\"PLG_QUICKICON_EOS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Quickicon\\\\Eos\",\"filename\":\"eos\"}', '', '', NULL, NULL, '7', '0', NULL),
('164', '0', 'plg_sampledata_blog', 'plugin', 'blog', '', 'sampledata', '0', '0', '1', '0', '1', '{\"name\":\"plg_sampledata_blog\",\"type\":\"plugin\",\"creationDate\":\"2017-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.8.0\",\"description\":\"PLG_SAMPLEDATA_BLOG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\SampleData\\\\Blog\",\"filename\":\"blog\"}', '', '', NULL, NULL, '1', '0', NULL),
('165', '0', 'plg_sampledata_multilang', 'plugin', 'multilang', '', 'sampledata', '0', '0', '1', '0', '1', '{\"name\":\"plg_sampledata_multilang\",\"type\":\"plugin\",\"creationDate\":\"2018-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SAMPLEDATA_MULTILANG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\SampleData\\\\MultiLanguage\",\"filename\":\"multilang\"}', '', '', NULL, NULL, '2', '0', NULL),
('166', '0', 'plg_schemaorg_article', 'plugin', 'article', '', 'schemaorg', '0', '1', '1', '0', '1', '{\"name\":\"plg_schemaorg_article\",\"type\":\"plugin\",\"creationDate\":\"2024-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2024 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.1.0\",\"description\":\"PLG_SCHEMAORG_ARTICLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Article\",\"filename\":\"article\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('167', '0', 'plg_schemaorg_blogposting', 'plugin', 'blogposting', '', 'schemaorg', '0', '1', '1', '0', '1', '{\"name\":\"plg_schemaorg_blogposting\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_BLOGPOSTING_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\BlogPosting\",\"filename\":\"blogposting\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('168', '0', 'plg_schemaorg_book', 'plugin', 'book', '', 'schemaorg', '0', '1', '1', '0', '1', '{\"name\":\"plg_schemaorg_book\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_BOOK_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Book\",\"filename\":\"book\"}', '{}', '', NULL, NULL, '3', '0', NULL),
('169', '0', 'plg_schemaorg_event', 'plugin', 'event', '', 'schemaorg', '0', '1', '1', '0', '1', '{\"name\":\"plg_schemaorg_event\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_EVENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Event\",\"filename\":\"event\"}', '{}', '', NULL, NULL, '4', '0', NULL),
('170', '0', 'plg_schemaorg_jobposting', 'plugin', 'jobposting', '', 'schemaorg', '0', '1', '1', '0', '1', '{\"name\":\"plg_schemaorg_jobposting\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_JOBPOSTING_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\JobPosting\",\"filename\":\"jobposting\"}', '{}', '', NULL, NULL, '5', '0', NULL),
('171', '0', 'plg_schemaorg_organization', 'plugin', 'organization', '', 'schemaorg', '0', '1', '1', '0', '1', '{\"name\":\"plg_schemaorg_organization\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_ORGANIZATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Organization\",\"filename\":\"organization\"}', '{}', '', NULL, NULL, '6', '0', NULL),
('172', '0', 'plg_schemaorg_person', 'plugin', 'person', '', 'schemaorg', '0', '1', '1', '0', '1', '{\"name\":\"plg_schemaorg_person\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_PERSON_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Person\",\"filename\":\"person\"}', '{}', '', NULL, NULL, '7', '0', NULL),
('173', '0', 'plg_schemaorg_recipe', 'plugin', 'recipe', '', 'schemaorg', '0', '1', '1', '0', '1', '{\"name\":\"plg_schemaorg_recipe\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SCHEMAORG_RECIPE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Recipe\",\"filename\":\"recipe\"}', '{}', '', NULL, NULL, '8', '0', NULL),
('174', '0', 'plg_schemaorg_custom', 'plugin', 'custom', '', 'schemaorg', '0', '1', '1', '0', '1', '{\"name\":\"plg_schemaorg_custom\",\"type\":\"plugin\",\"creationDate\":\"2024-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2024 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.1.0\",\"description\":\"PLG_SCHEMAORG_CUSTOM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Schemaorg\\\\Custom\",\"filename\":\"custom\"}', '{}', '', NULL, NULL, '9', '0', NULL),
('175', '0', 'plg_system_accessibility', 'plugin', 'accessibility', '', 'system', '0', '0', '1', '0', '1', '{\"name\":\"plg_system_accessibility\",\"type\":\"plugin\",\"creationDate\":\"2020-02-15\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_ACCESSIBILITY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Accessibility\",\"filename\":\"accessibility\"}', '{}', '', NULL, NULL, '10', '0', NULL),
('176', '0', 'plg_system_actionlogs', 'plugin', 'actionlogs', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_actionlogs\",\"type\":\"plugin\",\"creationDate\":\"2018-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_ACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\ActionLogs\",\"filename\":\"actionlogs\"}', '{}', '', NULL, NULL, '11', '0', NULL),
('177', '0', 'plg_system_cache', 'plugin', 'cache', '', 'system', '0', '0', '1', '0', '1', '{\"name\":\"plg_system_cache\",\"type\":\"plugin\",\"creationDate\":\"2007-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CACHE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Cache\",\"filename\":\"cache\"}', '{\"browsercache\":\"0\",\"cachetime\":\"15\"}', '', NULL, NULL, '12', '0', NULL),
('178', '0', 'plg_system_debug', 'plugin', 'debug', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_debug\",\"type\":\"plugin\",\"creationDate\":\"2006-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_DEBUG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Debug\",\"filename\":\"debug\"}', '{\"profile\":\"1\",\"queries\":\"1\",\"memory\":\"1\",\"language_files\":\"1\",\"language_strings\":\"1\",\"strip-first\":\"1\",\"strip-prefix\":\"\",\"strip-suffix\":\"\"}', '', NULL, NULL, '13', '0', NULL),
('179', '0', 'plg_system_fields', 'plugin', 'fields', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_fields\",\"type\":\"plugin\",\"creationDate\":\"2016-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.7.0\",\"description\":\"PLG_SYSTEM_FIELDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Fields\",\"filename\":\"fields\"}', '', '', NULL, NULL, '14', '0', NULL),
('180', '0', 'plg_system_highlight', 'plugin', 'highlight', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_highlight\",\"type\":\"plugin\",\"creationDate\":\"2011-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_HIGHLIGHT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Highlight\",\"filename\":\"highlight\"}', '', '', NULL, NULL, '15', '0', NULL),
('181', '0', 'plg_system_httpheaders', 'plugin', 'httpheaders', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_httpheaders\",\"type\":\"plugin\",\"creationDate\":\"2017-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_HTTPHEADERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Httpheaders\",\"filename\":\"httpheaders\"}', '{}', '', NULL, NULL, '16', '0', NULL),
('182', '0', 'plg_system_jooa11y', 'plugin', 'jooa11y', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_jooa11y\",\"type\":\"plugin\",\"creationDate\":\"2022-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_SYSTEM_JOOA11Y_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Jooa11y\",\"filename\":\"jooa11y\"}', '', '', NULL, NULL, '17', '0', NULL),
('183', '0', 'plg_system_languagecode', 'plugin', 'languagecode', '', 'system', '0', '0', '1', '0', '1', '{\"name\":\"plg_system_languagecode\",\"type\":\"plugin\",\"creationDate\":\"2011-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2011 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGECODE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\LanguageCode\",\"filename\":\"languagecode\"}', '', '', NULL, NULL, '18', '0', NULL),
('184', '0', 'plg_system_languagefilter', 'plugin', 'languagefilter', '', 'system', '0', '0', '1', '0', '1', '{\"name\":\"plg_system_languagefilter\",\"type\":\"plugin\",\"creationDate\":\"2010-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2010 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LANGUAGEFILTER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\LanguageFilter\",\"filename\":\"languagefilter\"}', '', '', NULL, NULL, '19', '0', NULL),
('185', '0', 'plg_system_log', 'plugin', 'log', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_log\",\"type\":\"plugin\",\"creationDate\":\"2007-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_LOG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Log\",\"filename\":\"log\"}', '', '', NULL, NULL, '20', '0', NULL),
('186', '0', 'plg_system_logout', 'plugin', 'logout', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_logout\",\"type\":\"plugin\",\"creationDate\":\"2009-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_LOGOUT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Logout\",\"filename\":\"logout\"}', '', '', NULL, NULL, '21', '0', NULL),
('187', '0', 'plg_system_privacyconsent', 'plugin', 'privacyconsent', '', 'system', '0', '0', '1', '0', '1', '{\"name\":\"plg_system_privacyconsent\",\"type\":\"plugin\",\"creationDate\":\"2018-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_SYSTEM_PRIVACYCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\PrivacyConsent\",\"filename\":\"privacyconsent\"}', '{}', '', NULL, NULL, '22', '0', NULL),
('188', '0', 'plg_system_redirect', 'plugin', 'redirect', '', 'system', '0', '0', '1', '0', '1', '{\"name\":\"plg_system_redirect\",\"type\":\"plugin\",\"creationDate\":\"2009-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SYSTEM_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Redirect\",\"filename\":\"redirect\"}', '', '', NULL, NULL, '23', '0', NULL),
('189', '0', 'plg_system_remember', 'plugin', 'remember', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_remember\",\"type\":\"plugin\",\"creationDate\":\"2007-04\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_REMEMBER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Remember\",\"filename\":\"remember\"}', '', '', NULL, NULL, '25', '0', NULL),
('190', '0', 'plg_system_schedulerunner', 'plugin', 'schedulerunner', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_schedulerunner\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_SYSTEM_SCHEDULERUNNER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\ScheduleRunner\",\"filename\":\"schedulerunner\"}', '{}', '', NULL, NULL, '26', '0', NULL),
('191', '0', 'plg_system_schemaorg', 'plugin', 'schemaorg', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_schemaorg\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_SYSTEM_SCHEMAORG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Schemaorg\",\"filename\":\"schemaorg\"}', '{}', '', NULL, NULL, '27', '0', NULL),
('192', '0', 'plg_system_sef', 'plugin', 'sef', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_sef\",\"type\":\"plugin\",\"creationDate\":\"2007-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2007 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_SEF_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Sef\",\"filename\":\"sef\"}', '{\"domain\":\"\",\"indexphp\":\"1\",\"trailingslash\":\"0\",\"enforcesuffix\":\"1\",\"strictrouting\":\"1\"}', '', NULL, NULL, '28', '0', NULL),
('193', '0', 'plg_system_shortcut', 'plugin', 'shortcut', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_shortcut\",\"type\":\"plugin\",\"creationDate\":\"2022-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_SYSTEM_SHORTCUT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Shortcut\",\"filename\":\"shortcut\"}', '{}', '', NULL, NULL, '29', '0', NULL),
('194', '0', 'plg_system_skipto', 'plugin', 'skipto', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_skipto\",\"type\":\"plugin\",\"creationDate\":\"2020-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_SKIPTO_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Skipto\",\"filename\":\"skipto\"}', '{}', '', NULL, NULL, '30', '0', NULL),
('195', '0', 'plg_system_stats', 'plugin', 'stats', '', 'system', '0', '0', '1', '0', '1', '{\"name\":\"plg_system_stats\",\"type\":\"plugin\",\"creationDate\":\"2013-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.5.0\",\"description\":\"PLG_SYSTEM_STATS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Stats\",\"filename\":\"stats\"}', '{\"mode\":3,\"lastrun\":\"\",\"unique_id\":\"06761a0f517f1080322f8f49555373f04c0c1501\",\"interval\":12}', '', NULL, NULL, '31', '0', NULL),
('196', '0', 'plg_system_task_notification', 'plugin', 'tasknotification', '', 'system', '0', '1', '1', '0', '1', '{\"name\":\"plg_system_task_notification\",\"type\":\"plugin\",\"creationDate\":\"2021-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_SYSTEM_TASK_NOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\TaskNotification\",\"filename\":\"tasknotification\"}', '', '', NULL, NULL, '32', '0', NULL),
('197', '0', 'plg_system_webauthn', 'plugin', 'webauthn', '', 'system', '0', '0', '1', '0', '1', '{\"name\":\"plg_system_webauthn\",\"type\":\"plugin\",\"creationDate\":\"2019-07-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_SYSTEM_WEBAUTHN_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Webauthn\",\"filename\":\"webauthn\"}', '{}', '', NULL, NULL, '33', '0', NULL),
('198', '0', 'plg_task_check_files', 'plugin', 'checkfiles', '', 'task', '0', '1', '1', '0', '1', '{\"name\":\"plg_task_check_files\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_CHECK_FILES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\Checkfiles\",\"filename\":\"checkfiles\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('199', '0', 'plg_task_deleteactionlogs', 'plugin', 'deleteactionlogs', '', 'task', '0', '1', '1', '0', '1', '{\"name\":\"plg_task_deleteactionlogs\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_DELETEACTIONLOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\DeleteActionLogs\",\"filename\":\"deleteactionlogs\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('200', '0', 'plg_task_globalcheckin', 'plugin', 'globalcheckin', '', 'task', '0', '1', '1', '0', '1', '{\"name\":\"plg_task_globalcheckin\",\"type\":\"plugin\",\"creationDate\":\"2023-06-22\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_GLOBALCHECKIN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\Globalcheckin\",\"filename\":\"globalcheckin\"}', '{}', '', NULL, NULL, '3', '0', NULL),
('201', '0', 'plg_task_requests', 'plugin', 'requests', '', 'task', '0', '1', '1', '0', '1', '{\"name\":\"plg_task_requests\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_REQUESTS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\Requests\",\"filename\":\"requests\"}', '{}', '', NULL, NULL, '4', '0', NULL),
('202', '0', 'plg_task_privacyconsent', 'plugin', 'privacyconsent', '', 'task', '0', '1', '1', '0', '1', '{\"name\":\"plg_task_privacyconsent\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_PRIVACYCONSENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\PrivacyConsent\",\"filename\":\"privacyconsent\"}', '{}', '', NULL, NULL, '5', '0', NULL),
('203', '0', 'plg_task_rotatelogs', 'plugin', 'rotatelogs', '', 'task', '0', '1', '1', '0', '1', '{\"name\":\"plg_task_rotatelogs\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_ROTATELOGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\RotateLogs\",\"filename\":\"rotatelogs\"}', '{}', '', NULL, NULL, '6', '0', NULL),
('204', '0', 'plg_task_sessiongc', 'plugin', 'sessiongc', '', 'task', '0', '1', '1', '0', '1', '{\"name\":\"plg_task_sessiongc\",\"type\":\"plugin\",\"creationDate\":\"2023-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_SESSIONGC_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\SessionGC\",\"filename\":\"sessiongc\"}', '{}', '', NULL, NULL, '7', '0', NULL),
('205', '0', 'plg_task_site_status', 'plugin', 'sitestatus', '', 'task', '0', '1', '1', '0', '1', '{\"name\":\"plg_task_site_status\",\"type\":\"plugin\",\"creationDate\":\"2021-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1\",\"description\":\"PLG_TASK_SITE_STATUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\SiteStatus\",\"filename\":\"sitestatus\"}', '{}', '', NULL, NULL, '8', '0', NULL),
('206', '0', 'plg_task_updatenotification', 'plugin', 'updatenotification', '', 'task', '0', '0', '1', '0', '1', '{\"name\":\"plg_task_updatenotification\",\"type\":\"plugin\",\"creationDate\":\"2023-07\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.0.0\",\"description\":\"PLG_TASK_UPDATENOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Task\\\\UpdateNotification\",\"filename\":\"updatenotification\"}', '{}', '', NULL, NULL, '9', '0', NULL),
('207', '0', 'plg_multifactorauth_totp', 'plugin', 'totp', '', 'multifactorauth', '0', '1', '1', '0', '1', '{\"name\":\"plg_multifactorauth_totp\",\"type\":\"plugin\",\"creationDate\":\"2013-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_TOTP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Totp\",\"filename\":\"totp\"}', '', '', NULL, NULL, '1', '0', NULL),
('208', '0', 'plg_multifactorauth_yubikey', 'plugin', 'yubikey', '', 'multifactorauth', '0', '0', '1', '0', '1', '{\"name\":\"plg_multifactorauth_yubikey\",\"type\":\"plugin\",\"creationDate\":\"2013-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2013 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_YUBIKEY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Yubikey\",\"filename\":\"yubikey\"}', '', '', NULL, NULL, '2', '0', NULL),
('209', '0', 'plg_multifactorauth_webauthn', 'plugin', 'webauthn', '', 'multifactorauth', '0', '0', '1', '0', '1', '{\"name\":\"plg_multifactorauth_webauthn\",\"type\":\"plugin\",\"creationDate\":\"2022-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_WEBAUTHN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Webauthn\",\"filename\":\"webauthn\"}', '', '', NULL, NULL, '3', '0', NULL),
('210', '0', 'plg_multifactorauth_email', 'plugin', 'email', '', 'multifactorauth', '0', '1', '1', '0', '1', '{\"name\":\"plg_multifactorauth_email\",\"type\":\"plugin\",\"creationDate\":\"2022-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_EMAIL_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Email\",\"filename\":\"email\"}', '', '', NULL, NULL, '4', '0', NULL),
('211', '0', 'plg_multifactorauth_fixed', 'plugin', 'fixed', '', 'multifactorauth', '0', '0', '1', '0', '1', '{\"name\":\"plg_multifactorauth_fixed\",\"type\":\"plugin\",\"creationDate\":\"2022-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2022 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.2.0\",\"description\":\"PLG_MULTIFACTORAUTH_FIXED_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Multifactorauth\\\\Fixed\",\"filename\":\"fixed\"}', '', '', NULL, NULL, '5', '0', NULL),
('212', '0', 'plg_user_contactcreator', 'plugin', 'contactcreator', '', 'user', '0', '0', '1', '0', '1', '{\"name\":\"plg_user_contactcreator\",\"type\":\"plugin\",\"creationDate\":\"2009-08\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2009 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_CONTACTCREATOR_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\ContactCreator\",\"filename\":\"contactcreator\"}', '{\"autowebpage\":\"\",\"category\":\"4\",\"autopublish\":\"0\"}', '', NULL, NULL, '1', '0', NULL),
('213', '0', 'plg_user_joomla', 'plugin', 'joomla', '', 'user', '0', '1', '1', '0', '1', '{\"name\":\"plg_user_joomla\",\"type\":\"plugin\",\"creationDate\":\"2006-12\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Joomla\",\"filename\":\"joomla\"}', '{\"autoregister\":\"1\",\"mail_to_user\":\"1\",\"forceLogout\":\"1\"}', '', NULL, NULL, '2', '0', NULL),
('214', '0', 'plg_user_profile', 'plugin', 'profile', '', 'user', '0', '0', '1', '0', '1', '{\"name\":\"plg_user_profile\",\"type\":\"plugin\",\"creationDate\":\"2008-01\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2008 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.0.0\",\"description\":\"PLG_USER_PROFILE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Profile\",\"filename\":\"profile\"}', '{\"register-require_address1\":\"1\",\"register-require_address2\":\"1\",\"register-require_city\":\"1\",\"register-require_region\":\"1\",\"register-require_country\":\"1\",\"register-require_postal_code\":\"1\",\"register-require_phone\":\"1\",\"register-require_website\":\"1\",\"register-require_favoritebook\":\"1\",\"register-require_aboutme\":\"1\",\"register-require_tos\":\"1\",\"register-require_dob\":\"1\",\"profile-require_address1\":\"1\",\"profile-require_address2\":\"1\",\"profile-require_city\":\"1\",\"profile-require_region\":\"1\",\"profile-require_country\":\"1\",\"profile-require_postal_code\":\"1\",\"profile-require_phone\":\"1\",\"profile-require_website\":\"1\",\"profile-require_favoritebook\":\"1\",\"profile-require_aboutme\":\"1\",\"profile-require_tos\":\"1\",\"profile-require_dob\":\"1\"}', '', NULL, NULL, '3', '0', NULL),
('215', '0', 'plg_user_terms', 'plugin', 'terms', '', 'user', '0', '0', '1', '0', '1', '{\"name\":\"plg_user_terms\",\"type\":\"plugin\",\"creationDate\":\"2018-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2018 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TERMS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Terms\",\"filename\":\"terms\"}', '{}', '', NULL, NULL, '4', '0', NULL),
('216', '0', 'plg_user_token', 'plugin', 'token', '', 'user', '0', '1', '1', '0', '1', '{\"name\":\"plg_user_token\",\"type\":\"plugin\",\"creationDate\":\"2019-11\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"3.9.0\",\"description\":\"PLG_USER_TOKEN_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\User\\\\Token\",\"filename\":\"token\"}', '{}', '', NULL, NULL, '5', '0', NULL),
('217', '0', 'plg_webservices_banners', 'plugin', 'banners', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_banners\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_BANNERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Banners\",\"filename\":\"banners\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('218', '0', 'plg_webservices_config', 'plugin', 'config', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_config\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONFIG_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Config\",\"filename\":\"config\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('219', '0', 'plg_webservices_contact', 'plugin', 'contact', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_contact\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONTACT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Contact\",\"filename\":\"contact\"}', '{}', '', NULL, NULL, '3', '0', NULL),
('220', '0', 'plg_webservices_content', 'plugin', 'content', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_content\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_CONTENT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Content\",\"filename\":\"content\"}', '{}', '', NULL, NULL, '4', '0', NULL),
('221', '0', 'plg_webservices_installer', 'plugin', 'installer', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_installer\",\"type\":\"plugin\",\"creationDate\":\"2020-06\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_INSTALLER_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Installer\",\"filename\":\"installer\"}', '{}', '', NULL, NULL, '5', '0', NULL),
('222', '0', 'plg_webservices_languages', 'plugin', 'languages', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_languages\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_LANGUAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Languages\",\"filename\":\"languages\"}', '{}', '', NULL, NULL, '6', '0', NULL),
('223', '0', 'plg_webservices_media', 'plugin', 'media', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_media\",\"type\":\"plugin\",\"creationDate\":\"2021-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2021 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.1.0\",\"description\":\"PLG_WEBSERVICES_MEDIA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Media\",\"filename\":\"media\"}', '{}', '', NULL, NULL, '7', '0', NULL),
('224', '0', 'plg_webservices_menus', 'plugin', 'menus', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_menus\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MENUS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Menus\",\"filename\":\"menus\"}', '{}', '', NULL, NULL, '7', '0', NULL),
('225', '0', 'plg_webservices_messages', 'plugin', 'messages', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_messages\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MESSAGES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Messages\",\"filename\":\"messages\"}', '{}', '', NULL, NULL, '8', '0', NULL),
('226', '0', 'plg_webservices_modules', 'plugin', 'modules', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_modules\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_MODULES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Modules\",\"filename\":\"modules\"}', '{}', '', NULL, NULL, '9', '0', NULL),
('227', '0', 'plg_webservices_newsfeeds', 'plugin', 'newsfeeds', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_newsfeeds\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_NEWSFEEDS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Newsfeeds\",\"filename\":\"newsfeeds\"}', '{}', '', NULL, NULL, '10', '0', NULL),
('228', '0', 'plg_webservices_plugins', 'plugin', 'plugins', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_plugins\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_PLUGINS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Plugins\",\"filename\":\"plugins\"}', '{}', '', NULL, NULL, '11', '0', NULL),
('229', '0', 'plg_webservices_privacy', 'plugin', 'privacy', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_privacy\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_PRIVACY_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Privacy\",\"filename\":\"privacy\"}', '{}', '', NULL, NULL, '12', '0', NULL),
('230', '0', 'plg_webservices_redirect', 'plugin', 'redirect', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_redirect\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_REDIRECT_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Redirect\",\"filename\":\"redirect\"}', '{}', '', NULL, NULL, '13', '0', NULL),
('231', '0', 'plg_webservices_tags', 'plugin', 'tags', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_tags\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_TAGS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Tags\",\"filename\":\"tags\"}', '{}', '', NULL, NULL, '14', '0', NULL),
('232', '0', 'plg_webservices_templates', 'plugin', 'templates', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_templates\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_TEMPLATES_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Templates\",\"filename\":\"templates\"}', '{}', '', NULL, NULL, '15', '0', NULL),
('233', '0', 'plg_webservices_users', 'plugin', 'users', '', 'webservices', '0', '1', '1', '0', '1', '{\"name\":\"plg_webservices_users\",\"type\":\"plugin\",\"creationDate\":\"2019-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WEBSERVICES_USERS_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\WebServices\\\\Users\",\"filename\":\"users\"}', '{}', '', NULL, NULL, '16', '0', NULL),
('234', '0', 'plg_workflow_featuring', 'plugin', 'featuring', '', 'workflow', '0', '1', '1', '0', '1', '{\"name\":\"plg_workflow_featuring\",\"type\":\"plugin\",\"creationDate\":\"2020-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_FEATURING_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Workflow\\\\Featuring\",\"filename\":\"featuring\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('235', '0', 'plg_workflow_notification', 'plugin', 'notification', '', 'workflow', '0', '1', '1', '0', '1', '{\"name\":\"plg_workflow_notification\",\"type\":\"plugin\",\"creationDate\":\"2020-05\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_NOTIFICATION_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Workflow\\\\Notification\",\"filename\":\"notification\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('236', '0', 'plg_workflow_publishing', 'plugin', 'publishing', '', 'workflow', '0', '1', '1', '0', '1', '{\"name\":\"plg_workflow_publishing\",\"type\":\"plugin\",\"creationDate\":\"2020-03\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.0.0\",\"description\":\"PLG_WORKFLOW_PUBLISHING_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Workflow\\\\Publishing\",\"filename\":\"publishing\"}', '{}', '', NULL, NULL, '3', '0', NULL),
('237', '0', 'plg_system_guidedtours', 'plugin', 'guidedtours', '', 'system', '0', '0', '1', '0', '1', '{\"name\":\"plg_system_guidedtours\",\"type\":\"plugin\",\"creationDate\":\"2023-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2023 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"4.3.0\",\"description\":\"PLG_SYSTEM_GUIDEDTOURS_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\GuidedTours\",\"filename\":\"guidedtours\"}', '{}', '', NULL, NULL, '24', '0', NULL),
('238', '0', 'atum', 'template', 'atum', '', '', '1', '1', '1', '0', '1', '{\"name\":\"atum\",\"type\":\"template\",\"creationDate\":\"2016-09\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2016 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_ATUM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"inheritable\":true,\"filename\":\"templateDetails\"}', '', '', NULL, NULL, '0', '0', NULL),
('239', '0', 'cassiopeia', 'template', 'cassiopeia', '', '', '0', '0', '1', '0', '1', '{\"name\":\"cassiopeia\",\"type\":\"template\",\"creationDate\":\"2017-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2017 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"\",\"version\":\"1.0\",\"description\":\"TPL_CASSIOPEIA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"inheritable\":true,\"filename\":\"templateDetails\"}', '{\"brand\":\"1\",\"logoFile\":\"\",\"siteTitle\":\"\",\"siteDescription\":\"\",\"useFontScheme\":\"0\",\"colorName\":\"colors_standard\",\"fluidContainer\":\"0\",\"stickyHeader\":0,\"backTop\":0}', '', NULL, NULL, '0', '0', NULL),
('240', '0', 'files_joomla', 'file', 'joomla', '', '', '0', '1', '1', '1', '1', '{\"name\":\"files_joomla\",\"type\":\"file\",\"creationDate\":\"2025-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.4.0\",\"description\":\"FILES_JOOMLA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\"}', '', '', NULL, NULL, '0', '0', NULL),
('241', '0', 'English (en-GB) Language Pack', 'package', 'pkg_en-GB', '', '', '0', '1', '1', '1', '1', '{\"name\":\"English (en-GB) Language Pack\",\"type\":\"package\",\"creationDate\":\"2025-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2019 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.4.0.1\",\"description\":\"en-GB language pack\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"pkg_en-GB\"}', '', '', NULL, NULL, '0', '0', NULL),
('242', '241', 'English (en-GB)', 'language', 'en-GB', '', '', '0', '1', '1', '1', '1', '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2025-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2006 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.4.0\",\"description\":\"en-GB site language\",\"group\":\"\",\"changelogurl\":\"\"}', '', '', NULL, NULL, '0', '0', NULL),
('243', '241', 'English (en-GB)', 'language', 'en-GB', '', '', '1', '1', '1', '1', '1', '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2025-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2005 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.4.0\",\"description\":\"en-GB administrator language\",\"group\":\"\",\"changelogurl\":\"\"}', '', '', NULL, NULL, '0', '0', NULL),
('244', '241', 'English (en-GB)', 'language', 'en-GB', '', '', '3', '1', '1', '1', '1', '{\"name\":\"English (en-GB)\",\"type\":\"language\",\"creationDate\":\"2025-10\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2020 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"5.4.0\",\"description\":\"en-GB api language\",\"group\":\"\",\"changelogurl\":\"\"}', '', '', NULL, NULL, '0', '0', NULL),
('246', '0', 'com_templateck', 'component', 'com_templateck', '', '', '1', '1', '0', '0', '0', '{\"name\":\"com_templateck\",\"type\":\"component\",\"creationDate\":\"April 2013\",\"author\":\"Cedric Keiflin\",\"copyright\":\"Copyright (C) 2013. All rights reserved.\",\"authorEmail\":\"ced1870@gmail.com\",\"authorUrl\":\"https:\\/\\/www.template-creator.com\",\"version\":\"5.6.0\",\"description\":\"CK_TEMPLATECK\",\"group\":\"\",\"changelogurl\":\"\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('247', '0', 'Scroll To CK', 'plugin', 'scrolltock', '', 'system', '0', '1', '1', '0', '0', '{\"name\":\"Scroll To CK\",\"type\":\"plugin\",\"creationDate\":\"D\\u00e9cembre 2014\",\"author\":\"C\\u00e9dric KEIFLIN\",\"copyright\":\"C\\u00e9dric KEIFLIN\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/www.joomlack.fr\",\"version\":\"1.5.1\",\"description\":\"PLG_SCROLLTOCK_XML_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"scrolltock\"}', '{\"fxduration\":\"1000\",\"offsety\":\"0\",\"keephash\":\"0\",\"mobile_resolution\":\"\",\"mobile_offsety\":\"\",\"activatetotop\":\"1\",\"totop_startoffset\":\"100\",\"totop_showtext\":\"0\",\"totop_hideresolution\":\"\",\"totop_width\":\"50\",\"totop_height\":\"50\",\"totop_backgroundcolor\":\"rgba(255, 255, 255, 1)\",\"totop_backgroundimage\":\"\",\"totop_opacity\":\"1\",\"totop_bordercolor\":\"rgba(169, 169, 169, 1)\",\"totop_borderwidth\":\"2px\",\"totop_borderradius\":\"0\",\"totop_shadowcolor\":\"\",\"totop_shadowwidth\":\"\",\"totop_color\":\"\",\"totop_hovercolor\":\"\",\"totop_fontsize\":\"\",\"totop_fontfamily\":\"\",\"totop_padding\":\"\",\"totop_margin\":\"auto 5px 90px auto\"}', '', NULL, NULL, '6', '0', ''),
('251', '260', 'COM_JCE', 'component', 'com_jce', '', '', '1', '1', '0', '0', '0', '{\"name\":\"COM_JCE\",\"type\":\"component\",\"creationDate\":\"14-10-2025\",\"author\":\"Ryan Demmer\",\"copyright\":\"Copyright (C) 2006 - 2025 Ryan Demmer. All rights reserved\",\"authorEmail\":\"info@joomlacontenteditor.net\",\"authorUrl\":\"www.joomlacontenteditor.net\",\"version\":\"2.9.95\",\"description\":\"COM_JCE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"jce\"}', '{\"custom_help\":\"0\",\"help_url\":\"\",\"help_method\":\"reference\",\"help_pattern\":\"tanya\",\"feed\":\"0\",\"feed_limit\":\"2\",\"inline_help\":\"1\",\"updates_key\":\"WF414F058A82C7E9F089AFF63D3879E5A2\",\"replace_media_manager\":\"1\"}', '', NULL, NULL, '0', '0', NULL),
('253', '260', 'plg_editors_jce', 'plugin', 'jce', '', 'editors', '0', '1', '1', '0', '0', '{\"name\":\"plg_editors_jce\",\"type\":\"plugin\",\"creationDate\":\"14-10-2025\",\"author\":\"Ryan Demmer\",\"copyright\":\"Copyright (C) 2006 - 2025 Ryan Demmer. All rights reserved\",\"authorEmail\":\"info@joomlacontenteditor.net\",\"authorUrl\":\"http:\\/\\/www.joomlacontenteditor.net\",\"version\":\"2.9.95\",\"description\":\"WF_EDITOR_PLUGIN_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Editors\\\\Jce\",\"filename\":\"jce\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('254', '260', 'plg_extension_jce', 'plugin', 'jce', '', 'extension', '0', '1', '1', '0', '0', '{\"name\":\"plg_extension_jce\",\"type\":\"plugin\",\"creationDate\":\"14-10-2025\",\"author\":\"Ryan Demmer\",\"copyright\":\"Copyright (C) 2006 - 2025 Ryan Demmer. All rights reserved\",\"authorEmail\":\"info@joomlacontenteditor.net\",\"authorUrl\":\"http:\\/\\/www.joomlacontenteditor.net\",\"version\":\"2.9.95\",\"description\":\"PLG_EXTENSION_JCE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"jce\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('255', '260', 'plg_installer_jce', 'plugin', 'jce', '', 'installer', '0', '1', '1', '0', '0', '{\"name\":\"plg_installer_jce\",\"type\":\"plugin\",\"creationDate\":\"14-10-2025\",\"author\":\"Ryan Demmer\",\"copyright\":\"Copyright (C) 2006 - 2025 Ryan Demmer. All rights reserved\",\"authorEmail\":\"info@joomlacontenteditor.net\",\"authorUrl\":\"http:\\/\\/www.joomlacontenteditor.net\",\"version\":\"2.9.95\",\"description\":\"PLG_INSTALLER_JCE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Installer\\\\Jce\",\"filename\":\"jce\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('256', '260', 'plg_quickicon_jce', 'plugin', 'jce', '', 'quickicon', '0', '1', '1', '0', '0', '{\"name\":\"plg_quickicon_jce\",\"type\":\"plugin\",\"creationDate\":\"14-10-2025\",\"author\":\"Ryan Demmer\",\"copyright\":\"Copyright (C) 2006 - 2025 Ryan Demmer. All rights reserved\",\"authorEmail\":\"info@joomlacontenteditor.net\",\"authorUrl\":\"http:\\/\\/www.joomlacontenteditor.net\",\"version\":\"2.9.95\",\"description\":\"PLG_QUICKICON_JCE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"jce\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('257', '260', 'plg_system_jce', 'plugin', 'jce', '', 'system', '0', '1', '1', '0', '0', '{\"name\":\"plg_system_jce\",\"type\":\"plugin\",\"creationDate\":\"14-10-2025\",\"author\":\"Ryan Demmer\",\"copyright\":\"Copyright (C) 2006 - 2025 Ryan Demmer. All rights reserved\",\"authorEmail\":\"info@joomlacontenteditor.net\",\"authorUrl\":\"http:\\/\\/www.joomlacontenteditor.net\",\"version\":\"2.9.95\",\"description\":\"PLG_SYSTEM_JCE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\Jce\",\"filename\":\"jce\"}', '{\"column_styles\":\"1\"}', '', NULL, NULL, '7', '0', NULL),
('258', '260', 'plg_fields_mediajce', 'plugin', 'mediajce', '', 'fields', '0', '1', '1', '0', '0', '{\"name\":\"plg_fields_mediajce\",\"type\":\"plugin\",\"creationDate\":\"14-10-2025\",\"author\":\"Ryan Demmer\",\"copyright\":\"Copyright (C) 2006 - 2025 Ryan Demmer. All rights reserved\",\"authorEmail\":\"info@joomlacontenteditor.net\",\"authorUrl\":\"https:\\/\\/www.joomlacontenteditor.net\",\"version\":\"2.9.95\",\"description\":\"PLG_FIELDS_MEDIAJCE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Fields\\\\MediaJce\",\"filename\":\"mediajce\"}', '{\"legacymedia\":\"0\"}', '', NULL, NULL, '0', '0', NULL),
('259', '260', 'plg_system_jcepro', 'plugin', 'jcepro', '', 'system', '0', '1', '1', '0', '0', '{\"name\":\"plg_system_jcepro\",\"type\":\"plugin\",\"creationDate\":\"14-10-2025\",\"author\":\"Ryan Demmer\",\"copyright\":\"Copyright (C) 2006 - 2025 Ryan Demmer. All rights reserved\",\"authorEmail\":\"info@joomlacontenteditor.net\",\"authorUrl\":\"https:\\/\\/www.joomlacontenteditor.net\",\"version\":\"2.9.95\",\"description\":\"PLG_SYSTEM_JCEPRO_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\System\\\\JcePro\",\"filename\":\"jcepro\"}', '{}', '', NULL, NULL, '9', '0', NULL),
('260', '0', 'PKG_JCE', 'package', 'pkg_jce', '', '', '0', '1', '1', '0', '0', '{\"name\":\"PKG_JCE\",\"type\":\"package\",\"creationDate\":\"14-10-2025\",\"author\":\"Ryan Demmer\",\"copyright\":\"\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"2.9.95\",\"description\":\"PKG_JCE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"pkg_jce\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('261', '0', 'plg_system_jcemediabox', 'plugin', 'jcemediabox', '', 'system', '0', '1', '1', '0', '0', '{\"name\":\"plg_system_jcemediabox\",\"type\":\"plugin\",\"creationDate\":\"09-10-2025\",\"author\":\"Ryan Demmer\",\"copyright\":\"Copyright (C) 2006 - 2025 Ryan Demmer. All rights reserved\",\"authorEmail\":\"info@joomlacontenteditor.net\",\"authorUrl\":\"www.joomlacontenteditor.net\",\"version\":\"2.2.3\",\"description\":\"PLG_SYSTEM_JCEMEDIABOX_XML_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"jcemediabox\"}', '{\"theme\":\"standard\",\"transitionspeed\":\"500\",\"overlay\":\"1\",\"overlayopacity\":\"\",\"overlaycolor\":\"\",\"width\":\"\",\"height\":\"\",\"close\":\"2\",\"swipe\":\"1\",\"icons\":\"0\",\"dynamic_themes\":\"0\",\"expand_on_click\":\"1\",\"lightbox\":\"0\",\"shadowbox\":\"0\"}', '', NULL, NULL, '8', '0', ''),
('263', '264', 'PLG_SYSTEM_REGULARLABS', 'plugin', 'regularlabs', '', 'system', '0', '1', '1', '0', '0', '{\"name\":\"PLG_SYSTEM_REGULARLABS\",\"type\":\"plugin\",\"creationDate\":\"September 2025\",\"author\":\"Regular Labs (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2025 Regular Labs - All Rights Reserved\",\"authorEmail\":\"info@regularlabs.com\",\"authorUrl\":\"https:\\/\\/regularlabs.com\",\"version\":\"25.9.25453\",\"description\":\"PLG_SYSTEM_REGULARLABS_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"RegularLabs\\\\Plugin\\\\System\\\\RegularLabs\",\"filename\":\"regularlabs\"}', '{\"combine_admin_menu\":\"0\",\"max_list_count\":\"10000\"}', '', NULL, NULL, '4', '0', NULL),
('264', '0', 'PKG_REGULARLABS', 'package', 'pkg_regularlabs', '', '', '0', '1', '1', '0', '0', '{\"name\":\"PKG_REGULARLABS\",\"type\":\"package\",\"creationDate\":\"September 2025\",\"author\":\"Regular Labs (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2025 Regular Labs - All Rights Reserved\",\"authorEmail\":\"info@regularlabs.com\",\"authorUrl\":\"https:\\/\\/regularlabs.com\",\"version\":\"25.9.25453\",\"description\":\"\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"pkg_regularlabs\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('265', '267', 'PLG_SYSTEM_SOURCERER', 'plugin', 'sourcerer', '', 'system', '0', '1', '1', '0', '0', '{\"name\":\"PLG_SYSTEM_SOURCERER\",\"type\":\"plugin\",\"creationDate\":\"September 2025\",\"author\":\"Regular Labs (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2025 Regular Labs - All Rights Reserved\",\"authorEmail\":\"info@regularlabs.com\",\"authorUrl\":\"https:\\/\\/regularlabs.com\",\"version\":\"12.2.6\",\"description\":\"PLG_SYSTEM_SOURCERER_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"RegularLabs\\\\Plugin\\\\System\\\\Sourcerer\",\"filename\":\"sourcerer\"}', '{\"enable_css\":\"1\",\"enable_js\":\"1\",\"enable_php\":\"1\",\"forbidden_php\":\"dl, escapeshellarg, escapeshellcmd, exec, passthru, popen, proc_close, proc_open, shell_exec, symlink, system\",\"forbidden_tags\":\"\",\"@wizard\":\"0\",\"button_text\":\"Code\",\"enable_frontend\":\"1\",\"color_code\":\"1\",\"syntax_word\":\"source\",\"tag_characters\":\"{.}\",\"trim\":\"0\",\"enable_in_head\":\"0\",\"remove_from_search\":\"0\",\"include_path\":\"\\/\",\"tmp_path\":\"\",\"place_comments\":\"1\"}', '', NULL, NULL, '5', '0', NULL),
('266', '267', 'PLG_EDITORS-XTD_SOURCERER', 'plugin', 'sourcerer', '', 'editors-xtd', '0', '1', '1', '0', '0', '{\"name\":\"PLG_EDITORS-XTD_SOURCERER\",\"type\":\"plugin\",\"creationDate\":\"September 2025\",\"author\":\"Regular Labs (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2025 Regular Labs - All Rights Reserved\",\"authorEmail\":\"info@regularlabs.com\",\"authorUrl\":\"https:\\/\\/regularlabs.com\",\"version\":\"12.2.6\",\"description\":\"PLG_EDITORS-XTD_SOURCERER_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"RegularLabs\\\\Plugin\\\\EditorButton\\\\Sourcerer\",\"filename\":\"sourcerer\"}', '[]', '', NULL, NULL, '0', '0', NULL),
('267', '0', 'PKG_SOURCERER', 'package', 'pkg_sourcerer', '', '', '0', '1', '1', '0', '0', '{\"name\":\"PKG_SOURCERER\",\"type\":\"package\",\"creationDate\":\"September 2025\",\"author\":\"Regular Labs (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2025 Regular Labs - All Rights Reserved\",\"authorEmail\":\"info@regularlabs.com\",\"authorUrl\":\"https:\\/\\/regularlabs.com\",\"version\":\"12.2.6\",\"description\":\"\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"pkg_sourcerer\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('268', '0', 'com_rsform', 'component', 'com_rsform', '', '', '1', '1', '0', '0', '0', '{\"name\":\"com_rsform\",\"type\":\"component\",\"creationDate\":\"February 2025\",\"author\":\"RSJoomla!\",\"copyright\":\"(C) 2007-2025 www.rsjoomla.com\",\"authorEmail\":\"support@rsjoomla.com\",\"authorUrl\":\"www.rsjoomla.com\",\"version\":\"3.4.4\",\"description\":\"COM_RSFORM_INSTALL_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"rsform\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('269', '0', 'plg_installer_rsform', 'plugin', 'rsform', '', 'installer', '0', '1', '1', '0', '0', '{\"name\":\"plg_installer_rsform\",\"type\":\"plugin\",\"creationDate\":\"July 2015\",\"author\":\"RSJoomla!\",\"copyright\":\"(c) 2015 www.rsjoomla.com\",\"authorEmail\":\"support@rsjoomla.com\",\"authorUrl\":\"https:\\/\\/www.rsjoomla.com\",\"version\":\"1.0.0\",\"description\":\"PLG_INSTALLER_RSFORM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"rsform\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('270', '0', 'System - RSForm! Pro Delete Submissions', 'plugin', 'rsformdeletesubmissions', '', 'system', '0', '1', '1', '0', '0', '{\"name\":\"System - RSForm! Pro Delete Submissions\",\"type\":\"plugin\",\"creationDate\":\"April 2018\",\"author\":\"RSJoomla!\",\"copyright\":\"(C) 2007-2019 www.rsjoomla.com\",\"authorEmail\":\"support@rsjoomla.com\",\"authorUrl\":\"www.rsjoomla.com\",\"version\":\"1.0.0\",\"description\":\"PLG_SYSTEM_RSFORMDELETESUBMISSIONS_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"rsformdeletesubmissions\"}', '{}', '', NULL, NULL, '1', '0', NULL),
('271', '0', 'Page Cache - RSForm! Pro', 'plugin', 'rsform', '', 'pagecache', '0', '1', '1', '0', '0', '{\"name\":\"Page Cache - RSForm! Pro\",\"type\":\"plugin\",\"creationDate\":\"September 2023\",\"author\":\"RSJoomla!\",\"copyright\":\"(C) 2007-2023 www.rsjoomla.com\",\"authorEmail\":\"support@rsjoomla.com\",\"authorUrl\":\"www.rsjoomla.com\",\"version\":\"1.0.0\",\"description\":\"PLG_PAGECACHE_RSFORM_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"rsform\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('272', '0', 'PLG_SYSTEM_RSFORMCONSOLE', 'plugin', 'rsformconsole', '', 'system', '0', '0', '1', '0', '0', '{\"name\":\"PLG_SYSTEM_RSFORMCONSOLE\",\"type\":\"plugin\",\"creationDate\":\"Unknown\",\"author\":\"RSJoomla!\",\"copyright\":\"(c) 2015 www.rsjoomla.com\",\"authorEmail\":\"support@rsjoomla.com\",\"authorUrl\":\"https:\\/\\/www.rsjoomla.com\",\"version\":\"1.0.0\",\"description\":\"PLG_SYSTEM_RSFORMCONSOLE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Rsjoomla\\\\Plugin\\\\System\\\\Rsformconsole\",\"filename\":\"rsformconsole\"}', '{}', '', NULL, NULL, '2', '0', NULL),
('273', '0', 'Content - RSForm! Pro', 'plugin', 'rsform', '', 'content', '0', '1', '1', '0', '0', '{\"name\":\"Content - RSForm! Pro\",\"type\":\"plugin\",\"creationDate\":\"June 2015\",\"author\":\"RSJoomla!\",\"copyright\":\"(C) 2007-2017 www.rsjoomla.com\",\"authorEmail\":\"support@rsjoomla.com\",\"authorUrl\":\"www.rsjoomla.com\",\"version\":\"3.0.1\",\"description\":\"PLG_CONTENT_RSFORM_DESC\",\"group\":\"\",\"filename\":\"rsform\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('275', '0', 'COM_OSMAP', 'component', 'com_osmap', '', '', '1', '1', '0', '0', '0', '{\"name\":\"COM_OSMAP\",\"type\":\"component\",\"creationDate\":\"October 28 2025\",\"author\":\"Joomlashack\",\"copyright\":\"2016-2025 Joomlashack. All rights reserved.\",\"authorEmail\":\"help@joomlashack.com\",\"authorUrl\":\"https:\\/\\/www.joomlashack.com\\/\",\"version\":\"5.1.0\",\"description\":\"COM_OSMAP_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"osmap\"}', '{}', '{\"author\":\"Joomlashack\"}', NULL, NULL, '0', '0', NULL),
('277', '0', 'plg_system_osmylicensesmanager', 'plugin', 'osmylicensesmanager', '', 'system', '0', '1', '1', '0', '0', '{\"name\":\"plg_system_osmylicensesmanager\",\"type\":\"plugin\",\"creationDate\":\"March 18 2024\",\"author\":\"Joomlashack\",\"copyright\":\"Copyright 2016-2024 Joomlashack. All rights reserved\",\"authorEmail\":\"help@joomlashack.com\",\"authorUrl\":\"https:\\/\\/www.joomlashack.com\",\"version\":\"2.0.17\",\"description\":\"PLG_SYSTEM_OSMYLICENSESMANAGER_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"osmylicensesmanager\"}', '[]', '{\"author\":\"Joomlashack\"}', NULL, NULL, '34', '0', NULL),
('278', '0', 'PLG_OSMAP_JOOMLA', 'plugin', 'joomla', '', 'osmap', '0', '1', '1', '0', '0', '{\"name\":\"PLG_OSMAP_JOOMLA\",\"type\":\"plugin\",\"creationDate\":\"October 28 2025\",\"author\":\"Joomlashack\",\"copyright\":\"2016-2025 Joomlashack. All rights reserved.\",\"authorEmail\":\"help@joomlashack.com\",\"authorUrl\":\"https:\\/\\/www.joomlashack.com\\/\",\"version\":\"5.1.0\",\"description\":\"PLG_OSMAP_JOOMLA_PLUGIN_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"joomla\"}', '{\"expand_categories\":\"1\",\"expand_featured\":\"1\",\"max_category_level\":\"all\",\"include_archived\":\"2\",\"show_unauth\":\"0\",\"add_pagebreaks\":\"1\",\"max_art\":\"0\",\"article_order\":\"0\",\"article_orderdir\":\"0\",\"prepare_content\":\"1\",\"add_images\":\"1\",\"cat_priority\":\"-1\",\"cat_changefreq\":\"-1\",\"art_priority\":\"-1\",\"art_changefreq\":\"-1\",\"keywords\":\"metakey\"}', '', NULL, NULL, '0', '0', NULL),
('285', '0', 'plg_extension_joomlaupdate', 'plugin', 'joomlaupdate', '', 'extension', '0', '1', '1', '0', '1', '{\"name\":\"plg_extension_joomlaupdate\",\"type\":\"plugin\",\"creationDate\":\"2025-02\",\"author\":\"Joomla! Project\",\"copyright\":\"(C) 2025 Open Source Matters, Inc.\",\"authorEmail\":\"admin@joomla.org\",\"authorUrl\":\"www.joomla.org\",\"version\":\"1.0.0\",\"description\":\"PLG_EXTENSION_JOOMLAUPDATE_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Joomla\\\\Plugin\\\\Extension\\\\Joomlaupdate\",\"filename\":\"joomlaupdate\"}', '', '', NULL, NULL, '0', '0', NULL),
('291', '0', 'plg_captcha_hcaptcha', 'plugin', 'hcaptcha', '', 'captcha', '0', '1', '1', '0', '0', '{\"name\":\"plg_captcha_hcaptcha\",\"type\":\"plugin\",\"creationDate\":\"January 2024\",\"author\":\"data2site\",\"copyright\":\"Copyright (C) 2021-2024 by data2site.com. All rights reserved.\",\"authorEmail\":\"support@data2site.com\",\"authorUrl\":\"https:\\/\\/data2site.com\",\"version\":\"1.4.3\",\"description\":\"PLG_CAPTCHA_HCAPTCHA_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"hcaptcha\"}', '{\"publicKey\":\"b5f60c1a-849a-46f8-86d4-3f1e23641696\",\"privateKey\":\"ES_dba68a47630e4a31a3164ff681bd6324\",\"theme\":\"light\",\"size\":\"normal\"}', '', NULL, NULL, '0', '0', ''),
('292', '0', 'System - RSForm! Pro hCaptcha', 'plugin', 'rsfphcaptcha', '', 'system', '0', '1', '1', '0', '0', '{\"name\":\"System - RSForm! Pro hCaptcha\",\"type\":\"plugin\",\"creationDate\":\"April 2020\",\"author\":\"RSJoomla!\",\"copyright\":\"(C) 2020-2022 www.rsjoomla.com\",\"authorEmail\":\"support@rsjoomla.com\",\"authorUrl\":\"www.rsjoomla.com\",\"version\":\"3.1.3\",\"description\":\"PLG_SYSTEM_RSFPHCAPTCHA_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"rsfphcaptcha\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('294', '296', 'com_akeebabackup', 'component', 'com_akeebabackup', '', '', '1', '1', '0', '0', '0', '{\"name\":\"com_akeebabackup\",\"type\":\"component\",\"creationDate\":\"2025-10-13\",\"author\":\"Akeeba Ltd\",\"copyright\":\"Copyright (c)2006-2025 Akeeba Ltd \\/ Nicholas K. Dionysopoulos\",\"authorEmail\":\"no-reply@akeeba.com\",\"authorUrl\":\"www.akeeba.com\",\"version\":\"10.1.0\",\"description\":\"COM_AKEEBABACKUP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Akeeba\\\\Component\\\\AkeebaBackup\",\"filename\":\"akeebabackup\"}', '{\"frontend_secret_word\":\"###AES128###o224NOgMR40P2FlSLSgCLUpQU1QX8adpYwl5i2xlP99sfxtAY\\/RVmc2xP4iLg8oc36i\\/MVwSar9XuQPx3G1Pq1enrX9XZxRSNZDKOKKpe2FiT\\/szSlBJVoLS06SNSYN5+\\/bv95oDzEAAAAAA\",\"no_flush\":0,\"confwiz_upgrade\":1,\"siteurl\":\"https:\\/\\/musoyahealth.com\\/\",\"jlibrariesdir\":\"\\/var\\/www\\/html\\/musoya\\/libraries\",\"show_howtorestoremodal\":0}', '', NULL, NULL, '0', '0', NULL),
('295', '296', 'PLG_QUICKICON_AKEEBABACKUP', 'plugin', 'akeebabackup', '', 'quickicon', '0', '1', '1', '0', '0', '{\"name\":\"PLG_QUICKICON_AKEEBABACKUP\",\"type\":\"plugin\",\"creationDate\":\"2025-10-13\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2006-2025 Akeeba Ltd \\/ Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@dionysopoulos.me\",\"authorUrl\":\"https:\\/\\/www.akeeba.com\",\"version\":\"10.1.0\",\"description\":\"PLG_QUICKICON_AKEEBABACKUP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Akeeba\\\\Plugin\\\\QuickIcon\\\\AkeebaBackup\",\"filename\":\"akeebabackup\"}', '{\"enablewarning\":\"1\",\"warnfailed\":\"1\",\"maxbackupperiod\":\"720\",\"profileid\":\"1\"}', '', NULL, NULL, '0', '0', ''),
('296', '0', 'pkg_akeebabackup', 'package', 'pkg_akeebabackup', '', '', '0', '1', '1', '0', '0', '{\"name\":\"pkg_akeebabackup\",\"type\":\"package\",\"creationDate\":\"2025-10-13\",\"author\":\"Nicholas K. Dionysopoulos\",\"copyright\":\"Copyright (c)2006-2025 Nicholas K. Dionysopoulos \\/ Akeeba Ltd\",\"authorEmail\":\"\",\"authorUrl\":\"\",\"version\":\"10.1.0\",\"description\":\"PKG_AKEEBABACKUP_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"pkg_akeebabackup\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('297', '0', 'musoya', 'template', 'musoya', '', '', '0', '1', '1', '0', '0', '{\"name\":\"musoya\",\"type\":\"template\",\"creationDate\":\"16\\/08\\/2025\",\"author\":\"TSC Media\",\"copyright\":\"TSC Media\",\"authorEmail\":\"\",\"authorUrl\":\"https:\\/\\/tscmedia.co.za\\/\",\"version\":\"1.0.0\",\"description\":\"\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"templateDetails\"}', '{\"Logo_logoimgsrc\":\"\",\"Logo_logoheight\":\"auto\",\"Logo_logowidth\":\"auto\",\"Logo_logolink\":\"\",\"Logo_logotitle\":\"\",\"Logo_logodescription\":\"\",\"useresponsive\":\"1\",\"errorredirect\":\"\",\"googleanalyticscode\":\"\"}', '', NULL, NULL, '0', '0', NULL),
('298', '0', 'Smart Slider 3', 'component', 'com_smartslider3', '', '', '1', '1', '0', '0', '0', '{\"name\":\"Smart Slider 3\",\"type\":\"component\",\"creationDate\":\"2025-10-16\",\"author\":\"Nextendweb\",\"copyright\":\"Copyright (C) 2020 Nextendweb.com. All rights reserved.\",\"authorEmail\":\"roland@nextendweb.com\",\"authorUrl\":\"https:\\/\\/smartslider3.com\",\"version\":\"3.5.1.30\",\"description\":\"\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"smartslider3\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('300', '0', 'Smart Slider 3 Module', 'module', 'mod_smartslider3', '', '', '0', '1', '0', '0', '0', '{\"name\":\"Smart Slider 3 Module\",\"type\":\"module\",\"creationDate\":\"2025-10-16\",\"author\":\"Nextendweb\",\"copyright\":\"Copyright (C) 2020 Nextendweb.com. All rights reserved.\",\"authorEmail\":\"roland@nextendweb.com\",\"authorUrl\":\"https:\\/\\/smartslider3.com\",\"version\":\"3.5.1.30\",\"description\":\"This module displays sliders from Smart Slider 3. You can create the sliders in the Smart Slider 3\\n        component!\\n    \",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"mod_smartslider3\"}', '{\"slider\":\"1\",\"editslider\":\"\"}', '', NULL, NULL, '0', '0', NULL),
('301', '0', 'Smart Slider 3 Updater Plugin', 'plugin', 'smartslider3', '', 'installer', '0', '1', '1', '0', '0', '{\"name\":\"Smart Slider 3 Updater Plugin\",\"type\":\"plugin\",\"creationDate\":\"2025-10-16\",\"author\":\"Nextendweb\",\"copyright\":\"Copyright (C) 2020 Nextendweb.com. All rights reserved.\",\"authorEmail\":\"roland@nextendweb.com\",\"authorUrl\":\"https:\\/\\/smartslider3.com\",\"version\":\"3.5.1.30\",\"description\":\"\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"smartslider3\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('302', '0', 'Smart Slider 3 System Plugin', 'plugin', 'smartslider3', '', 'system', '0', '1', '1', '0', '0', '{\"name\":\"Smart Slider 3 System Plugin\",\"type\":\"plugin\",\"creationDate\":\"2025-10-16\",\"author\":\"Nextendweb\",\"copyright\":\"Copyright (C) 2020 Nextendweb.com. All rights reserved.\",\"authorEmail\":\"roland@nextendweb.com\",\"authorUrl\":\"https:\\/\\/smartslider3.com\",\"version\":\"3.5.1.30\",\"description\":\"\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"smartslider3\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('303', '0', 'PLG_ACTIONLOG_RSFORM', 'plugin', 'rsform', '', 'actionlog', '0', '0', '1', '0', '0', '{\"name\":\"PLG_ACTIONLOG_RSFORM\",\"type\":\"plugin\",\"creationDate\":\"2025-08\",\"author\":\"RSForm! Pro\",\"copyright\":\"(C) 2025 RSJoomla!\",\"authorEmail\":\"support@rsjoomla.com\",\"authorUrl\":\"www.rsjoomla.com\",\"version\":\"1.0.0\",\"description\":\"PLG_ACTIONLOG_RSFORM_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"Rsjoomla\\\\Plugin\\\\Actionlog\\\\Rsform\",\"filename\":\"rsform\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('304', '0', 'GTranslate', 'module', 'mod_gtranslate', '', '', '0', '1', '0', '0', '0', '{\"name\":\"GTranslate\",\"type\":\"module\",\"creationDate\":\"September 2010\",\"author\":\"Edvard Ananyan\",\"copyright\":\"Copyright (C) 2008 - 2025 GTranslate Inc. All rights reserved.\",\"authorEmail\":\"edo888@gmail.com\",\"authorUrl\":\"https:\\/\\/gtranslate.io\",\"version\":\"5.0.3\",\"description\":\"GTranslate - Makes your website multilingual and available to the world.\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"mod_gtranslate\"}', '{\"look\":\"float\",\"language\":\"en\",\"url_structure\":\"none\",\"custom_domains\":\"0\",\"custom_domains_config\":\"\",\"native_language_names\":\"1\",\"detect_browser_language\":\"0\",\"enable_cdn\":\"1\",\"add_new_line\":\"1\",\"select_language_label\":\"Select Language\",\"globe_size\":\"60\",\"color_scheme\":\"light\",\"flag_size\":\"32\",\"flag_style\":\"2d\",\"float_position\":\"bottom-left\",\"float_switcher_open_direction\":\"top\",\"switcher_open_direction\":\"top\",\"position\":\"inline\",\"wrapper_selector\":\".gtranslate_wrapper\",\"custom_css\":\"\",\"languages\":\"en,es,de,it,fr\",\"cache\":\"0\",\"cache_time\":\"900\",\"cachemode\":\"static\"}', '', NULL, NULL, '0', '0', NULL),
('305', '0', 'J2Store', 'component', 'com_j2store', '', '', '1', '1', '0', '0', '0', '{\"name\":\"J2Store\",\"type\":\"component\",\"creationDate\":\"Apr 2025\",\"author\":\"Adam Melcher, Olivier Buisard, Ramesh Elamathi\",\"copyright\":\"Copyright (c) 2024 J2Commerce. All rights reserved.\",\"authorEmail\":\"support@j2commerce.com\",\"authorUrl\":\"https:\\/\\/j2commerce.com\",\"version\":\"4.0.19\",\"description\":\"<h3>J2Commerce V4 Professional<\\/h3>\\n      \\t\\tFlexible and native Joomla shopping cart solution. <br>\\n      \\t\\tUse Joomla articles as products and get your shop online in less than 10 minutes. <br>\\n      \\t\\tStart setting up your store now. <br>\\n      \\t\\t<a target=\\\"_blank\\\" href=\\\"https:\\/\\/j2commerce.com\\\">Learn more<\\/a>\\n\\t\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"j2store\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('306', '0', 'J2 Store Chart', 'module', 'mod_j2store_chart', '', '', '1', '1', '2', '0', '0', '{\"name\":\"J2 Store Chart\",\"type\":\"module\",\"creationDate\":\"Jan 2015\",\"author\":\"Gokila PriyaBose\",\"copyright\":\"Copyright (c) 2014 - 2019 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"\\n\\t <p>J2 Store Chart\\n\\t <p> Please contact to us for more info <a href=\\\"mailto:support@j2store.org\\\">support@j2store.org<\\/a><\\/p>\\n\\t\\n\\n\\t\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"mod_j2store_chart\"}', '{\"chart_type\":\"1\"}', '', NULL, NULL, '0', '0', NULL),
('307', '0', 'J2 Store Stats Mini', 'module', 'mod_j2store_stats_mini', '', '', '1', '1', '2', '0', '0', '{\"name\":\"J2 Store Stats Mini\",\"type\":\"module\",\"creationDate\":\"Jan 2015\",\"author\":\"Gokila PriyaBose\",\"copyright\":\"Copyright (c) 2014 - 2019 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"\\n\\t <p>J2 Store Stats\\n\\t <p> Please contact to us for more info <a href=\\\"mailto:support@j2store.org\\\">support@j2store.org<\\/a><\\/p>\\n\\t\\n\\n\\t\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"mod_j2store_stats_mini\"}', '[]', '', NULL, NULL, '0', '0', NULL),
('308', '0', 'J2 Store Orders', 'module', 'mod_j2store_orders', '', '', '1', '1', '2', '0', '0', '{\"name\":\"J2 Store Orders\",\"type\":\"module\",\"creationDate\":\"Jan 2015\",\"author\":\"Gokila PriyaBose\",\"copyright\":\"Copyright (c) 2014 - 2019 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"\\n\\t <p>J2 Store Orders\\n\\t <p> Please contact to us for more info <a href=\\\"mailto:support@j2store.org\\\">support@j2store.org<\\/a><\\/p>\\n    \\n\\n\\t\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"mod_j2store_orders\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('309', '0', 'J2 Store Stats', 'module', 'mod_j2store_stats', '', '', '1', '1', '2', '0', '0', '{\"name\":\"J2 Store Stats\",\"type\":\"module\",\"creationDate\":\"Jan 2015\",\"author\":\"Gokila PriyaBose\",\"copyright\":\"Copyright (c) 2014 - 2019 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"\\n\\t <p>J2 Store Stats\\n\\t <p> Please contact to us for more info <a href=\\\"mailto:support@j2store.org\\\">support@j2store.org<\\/a><\\/p>\\n    \\n\\n\\t\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"mod_j2store_stats\"}', '[]', '', NULL, NULL, '0', '0', NULL),
('310', '0', 'J2Store Administrator Menu', 'module', 'mod_j2store_menu', '', '', '1', '1', '2', '0', '0', '{\"name\":\"J2Store Administrator Menu\",\"type\":\"module\",\"creationDate\":\"June 2015\",\"author\":\"Unknown\",\"copyright\":\"Copyright (c) 2011 - 2016 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2commerce.com\",\"authorUrl\":\"https:\\/\\/www.j2commerce.com\",\"version\":\"4.0\",\"description\":\"J2STORE_MODULE_MENU_XML_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"mod_j2store_menu\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('311', '0', 'J2Store Currency', 'module', 'mod_j2store_currency', '', '', '0', '1', '0', '0', '0', '{\"name\":\"J2Store Currency\",\"type\":\"module\",\"creationDate\":\"December 2014\",\"author\":\"Ramesh Elamathi\",\"copyright\":\"Copyright (c) 2013 - 2018 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"\\n\\t <p>J2Store shopping cart currency switcher module\\n\\t <p> Please contact to us for more info <a href=\\\"mailto:support@j2store.org\\\">support@j2store.org<\\/a><\\/p>\\n    \\n\\n\\t\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"mod_j2store_currency\"}', '{\"moduleclass_sfx\":\"\",\"background_color\":\"#FFFFFF\",\"text_color\":\"#000000\",\"link_color\":\"#CCCCCC\",\"link_hover_color\":\"#000000\",\"active_link_color\":\"#000000\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', NULL, NULL, '0', '0', NULL),
('312', '0', 'J2 Store Cart', 'module', 'mod_j2store_cart', '', '', '0', '1', '0', '0', '0', '{\"name\":\"J2 Store Cart\",\"type\":\"module\",\"creationDate\":\"Jan 2015\",\"author\":\"Sasi varna kumar\",\"copyright\":\"Copyright (c) 2011 - 2016 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"\\n\\t <p>J2 Store Cart\\n\\t <p> Please contact to us for more info <a href=\\\"mailto:support@j2store.org\\\">support@j2store.org<\\/a><\\/p>\\n\\t\\n\\t\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"mod_j2store_cart\"}', '{\"moduleclass_sfx\":\"\",\"link_type\":\"link\",\"check_empty\":\"0\",\"quantity_count\":\"0\",\"show_thumbimage\":\"0\",\"show_product_qty\":\"0\",\"show_cart_remove\":\"0\",\"enable_checkout\":\"0\",\"enable_view_cart\":\"0\",\"minicart_cart_icon_class\":\"fa fa-shopping-cart\",\"cache\":\"1\",\"cache_time\":\"900\"}', '', NULL, NULL, '0', '0', NULL),
('313', '0', 'Content - J2Store', 'plugin', 'j2store', '', 'content', '0', '1', '1', '0', '0', '{\"name\":\"Content - J2Store\",\"type\":\"plugin\",\"creationDate\":\"October 2014\",\"author\":\"J2Store Team\",\"copyright\":\"Copyright (c) 2014 - 2019 J2Store.org All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"https:\\/\\/www.j2store.org\",\"version\":\"1.0\",\"description\":\"Content plugin for J2Store.\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"j2store\"}', '{\"allow_frontend_product_edit\":\"0\",\"check_publish_date\":\"0\",\"cache_control\":\"1\",\"category_product_options\":\"1\",\"category_product_block_position\":\"bottom\",\"category_display_j2store_images\":\"1\",\"category_image_type\":\"thumbnail\",\"category_link_image_to_product\":\"1\",\"category_enable_image_zoom\":\"1\",\"list_image_thumbnail_width\":\"120\",\"list_product_additional_image_width\":\"80\",\"item_product_block_position\":\"bottom\",\"item_display_j2store_images\":\"1\",\"item_image_placement\":\"default\",\"item_image_type\":\"main\",\"item_enable_image_zoom\":\"1\",\"item_product_main_image_width\":\"\",\"item_product_additional_image_width\":\"100\"}', '', NULL, NULL, '0', '0', ''),
('314', '0', 'System - J2Store', 'plugin', 'j2store', '', 'system', '0', '1', '1', '0', '0', '{\"name\":\"System - J2Store\",\"type\":\"plugin\",\"creationDate\":\"Jan 2012\",\"author\":\"J2Commerce\",\"copyright\":\"2025 J2Commerce, LLC\",\"authorEmail\":\"support@j2commerce.org\",\"authorUrl\":\"https:\\/\\/www.j2commerce.org\",\"version\":\"4.0.11\",\"description\":\"System plugin that loads the required Javascript and other files required for J2Store.\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"j2store\"}', '{\"is_change_filter_input\":\"1\"}', '', NULL, NULL, '0', '0', NULL),
('315', '0', 'System - J2Page Cache', 'plugin', 'j2pagecache', '', 'system', '0', '0', '1', '0', '0', '{\"name\":\"System - J2Page Cache\",\"type\":\"plugin\",\"creationDate\":\"JUN 2016\",\"author\":\"Alagesan\",\"copyright\":\"(C) 2016 Weblogicx India Private Limited\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"www.j2store.org\",\"version\":\"1.0\",\"description\":\"System plugin that used to clear page cache.\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"j2pagecache\"}', '{\"conservative_cache\":\"0\"}', '', NULL, NULL, '0', '0', NULL),
('316', '0', 'System - J2Store Canonical', 'plugin', 'j2canonical', '', 'system', '0', '0', '1', '0', '0', '{\"name\":\"System - J2Store Canonical\",\"type\":\"plugin\",\"creationDate\":\"March 2017\",\"author\":\"Sasi varna kumar\",\"copyright\":\"Copyright (C) 2016 - 2020 http:\\/\\/j2store.org. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"https:\\/\\/www.j2store.org\",\"version\":\"1.3\",\"description\":\" This plugin solves the duplicate URL problem in search engines by adding appropriate Canonical tags for J2Store products and Articles. \",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"j2canonical\"}', '{\"current_url_canonical\":\"0\"}', '', NULL, NULL, '0', '0', NULL),
('317', '0', 'Search - J2Store ', 'plugin', 'j2store', '', 'search', '0', '0', '1', '0', '0', '{\"name\":\"Search - J2Store \",\"type\":\"plugin\",\"creationDate\":\"September 2015\",\"author\":\"Gokila Priya\",\"copyright\":\"Copyright (c) 2011 - 2016 Weblogicx India Private Ltd. All rights reserved.\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"PLG_SEARCH_J2STORE_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"j2store\"}', '{\"redirect_to\":\"j2store\",\"search_limit\":\"50\"}', '', NULL, NULL, '0', '0', NULL),
('318', '0', 'Finder - J2Store', 'plugin', 'j2store', '', 'finder', '0', '0', '1', '0', '0', '{\"name\":\"Finder - J2Store\",\"type\":\"plugin\",\"creationDate\":\"September 2015\",\"author\":\"Gokila Priya\",\"copyright\":\"2010 Weblogicx India Private Limited\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"PLG_FINDER_J2STORE_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"j2store\"}', '{\"redirect_to\":\"j2store\"}', '', NULL, NULL, '0', '0', NULL),
('319', '0', 'J2Store User Register', 'plugin', 'j2userregister', '', 'user', '0', '0', '1', '0', '0', '{\"name\":\"J2Store User Register\",\"type\":\"plugin\",\"creationDate\":\"MARCH 2017\",\"author\":\"Alagesan\",\"copyright\":\"Copyright 2017 Flycart Technologies LLP\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"https:\\/\\/www.j2store.org\",\"version\":\"1.2\",\"description\":\"J2Store Profile on Joomla user registration\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"j2userregister\"}', '{\"show_address_fields\":\"1\",\"show_myprofile\":\"0\",\"disable_name\":\"0\"}', '', NULL, NULL, '0', '0', NULL),
('320', '0', 'J2Store Installer', 'plugin', 'j2store', '', 'installer', '0', '1', '1', '0', '0', '{\"name\":\"J2Store Installer\",\"type\":\"plugin\",\"creationDate\":\"AUG 2023\",\"author\":\"Alagesan\",\"copyright\":\"(C) 2023 J2Store\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"www.j2store.org\",\"version\":\"1.0.0\",\"description\":\"J2Store Installer\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"j2store\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('321', '0', 'Free Shipping', 'plugin', 'shipping_free', '', 'j2store', '0', '1', '1', '0', '0', '{\"name\":\"Free Shipping\",\"type\":\"plugin\",\"creationDate\":\"September 2015\",\"author\":\"Gokila Priya\",\"copyright\":\"2015 WeblogicxIndia\",\"authorEmail\":\"supports@j2store.org\",\"authorUrl\":\"http:\\/\\/www.j2store.org\",\"version\":\"1.1\",\"description\":\"PLG_J2STORE_SHIPPING_FREE_DESCRIPTION\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"shipping_free\"}', '{\"display_name\":\"Free shipping\",\"min_subtotal\":\"0\",\"max_subtotal\":\"-1\",\"requires_coupon\":\"0\",\"check_shipping_product\":\"0\"}', '', NULL, NULL, '0', '0', NULL),
('322', '0', 'Standard Shipping methods', 'plugin', 'shipping_standard', '', 'j2store', '0', '0', '1', '0', '0', '{\"name\":\"Standard Shipping methods\",\"type\":\"plugin\",\"creationDate\":\"December 2014\",\"author\":\"J2Store\",\"copyright\":\"2010 Weblogicx India Private Limited\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"https:\\/\\/www.j2store.org\",\"version\":\"1.0\",\"description\":\"J2STORE_PLUGINDESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"shipping_standard\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('323', '0', 'Cash on Delivery', 'plugin', 'payment_cash', '', 'j2store', '0', '0', '1', '0', '0', '{\"name\":\"Cash on Delivery\",\"type\":\"plugin\",\"creationDate\":\"November 2013\",\"author\":\"Weblogicx India\",\"copyright\":\"2013 Weblogicx India Private Limited\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"J2STORE_CASH_PLUGINDESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"payment_cash\"}', '{\"display_name\":\"\",\"surcharge_percent\":\"\",\"surcharge_fixed\":\"\",\"surcharge_name\":\"\",\"surcharge_tax_class_id\":\"\",\"min_subtotal\":\"0.000\",\"max_subtotal\":\"-1.00\",\"payment_status\":\"4\",\"geozone_id\":\"\",\"onselection\":\"\",\"onbeforepayment\":\"\",\"onafterpayment\":\"\",\"button_text\":\"J2STORE_PLACE_ORDER\",\"articleid\":\"\"}', '', NULL, NULL, '0', '0', NULL),
('324', '0', 'Money Order', 'plugin', 'payment_moneyorder', '', 'j2store', '0', '0', '1', '0', '0', '{\"name\":\"Money Order\",\"type\":\"plugin\",\"creationDate\":\"November 2013\",\"author\":\"Weblogicx India\",\"copyright\":\"2013 Weblogicx India Private Limited\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"J2STORE_MONEYORDER_PLUGINDESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"payment_moneyorder\"}', '{\"display_name\":\"\",\"moneyorder_information\":\"\",\"enable_strip_tags\":\"0\",\"payment_status\":\"4\",\"surcharge_percent\":\"\",\"surcharge_fixed\":\"\",\"surcharge_name\":\"\",\"surcharge_tax_class_id\":\"\",\"geozone_id\":\"\",\"onselection\":\"\",\"onbeforepayment\":\"\",\"onafterpayment\":\"\",\"button_text\":\"J2STORE_PLACE_ORDER\",\"articleid\":\"\"}', '', NULL, NULL, '0', '0', NULL),
('325', '0', 'Bank transfer', 'plugin', 'payment_banktransfer', '', 'j2store', '0', '0', '1', '0', '0', '{\"name\":\"Bank transfer\",\"type\":\"plugin\",\"creationDate\":\"November 2013\",\"author\":\"Weblogicx India\",\"copyright\":\"2013 Weblogicx India Private Limited\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"http:\\/\\/j2store.org\",\"version\":\"1.0\",\"description\":\"J2STORE_BANKTRANSFER_PLUGINDESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"payment_banktransfer\"}', '{\"display_name\":\"\",\"bank_information\":\"\",\"enable_bank_transfer_strip_tags\":\"0\",\"payment_status\":\"4\",\"surcharge_percent\":\"\",\"surcharge_fixed\":\"\",\"surcharge_name\":\"\",\"surcharge_tax_class_id\":\"\",\"geozone_id\":\"\",\"support_subscription\":\"1\",\"onselection\":\"\",\"onbeforepayment\":\"\",\"onafterpayment\":\"\",\"button_text\":\"J2STORE_PLACE_ORDER\",\"articleid\":\"\"}', '', NULL, NULL, '0', '0', NULL),
('326', '0', 'Paypal Standard for J2Store', 'plugin', 'payment_paypal', '', 'j2store', '0', '0', '1', '0', '0', '{\"name\":\"Paypal Standard for J2Store\",\"type\":\"plugin\",\"creationDate\":\"DEC 2021\",\"author\":\"J2Store\",\"copyright\":\"2021 J2Store\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"https:\\/\\/www.j2store.org\",\"version\":\"4.0.1\",\"description\":\"J2STORE_PAYPAL_PLUGINDESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"payment_paypal\"}', '{\"display_name\":\"\",\"merchant_email\":\"\",\"api_username\":\"\",\"api_password\":\"\",\"api_signature\":\"\",\"notify_url_type\":\"default\",\"validate_ipn\":\"1\",\"sandbox\":\"0\",\"sandbox_merchant_email\":\"\",\"sandbox_api_username\":\"\",\"sandbox_api_password\":\"\",\"sandbox_api_signature\":\"\",\"show_billing_aggrement_text\":\"0\",\"billing_aggrement_text\":\"Automatic payments for subscription product\",\"surcharge_percent\":\"\",\"surcharge_fixed\":\"\",\"geozone_id\":\"\",\"cbt\":\"\",\"image_url\":\"\",\"cpp_header_image\":\"\",\"cpp_headerback_color\":\"\",\"cpp_headerborder_color\":\"\",\"onselection\":\"\",\"onbeforepayment\":\"\",\"onafterpayment\":\"\",\"onerrorpayment\":\"\",\"oncancelpayment\":\"\",\"button_text\":\"J2STORE_PLACE_ORDER\",\"card_update_button_text\":\"J2STORE_PLACE_ORDER\",\"debug\":\"0\"}', '', NULL, NULL, '0', '0', NULL),
('327', '0', 'J2STORE_REPORT_PRODUCTS', 'plugin', 'report_products', '', 'j2store', '0', '1', '1', '0', '0', '{\"name\":\"J2STORE_REPORT_PRODUCTS\",\"type\":\"plugin\",\"creationDate\":\"AUG 2016\",\"author\":\"Alagesan\",\"copyright\":\"2016 Weblogicx India Limited\",\"authorEmail\":\"supports@j2store.org\",\"authorUrl\":\"http:\\/\\/www.j2store.org\",\"version\":\"1.2\",\"description\":\"J2STORE_REPORT_PRODUCTS_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"report_products\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('328', '0', 'SagePay Form', 'plugin', 'payment_sagepayform', '', 'j2store', '0', '0', '1', '0', '0', '{\"name\":\"SagePay Form\",\"type\":\"plugin\",\"creationDate\":\"MARCH 2022\",\"author\":\"J2Store\",\"copyright\":\"2022 Weblogicx India Private Limited\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"https:\\/\\/www.j2store.org\",\"version\":\"3.13\",\"description\":\"J2STORE_SAGEPAYFORM_PLUGINDESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"payment_sagepayform\"}', '{\"display_name\":\"\",\"vendor_name\":\"\",\"encryption_key\":\"\",\"vendor_email\":\"\",\"sandbox\":\"0\",\"articleid\":\"\",\"onselection\":\"\",\"onbeforepayment\":\"\",\"onafterpayment\":\"\",\"onerrorpayment\":\"\",\"oncancelpayment\":\"\",\"button_text\":\"J2STORE_PLACE_ORDER\",\"debug\":\"0\"}', '', NULL, NULL, '0', '0', NULL),
('329', '0', 'J2STORE_REPORT_ITEMISED', 'plugin', 'report_itemised', '', 'j2store', '0', '1', '1', '0', '0', '{\"name\":\"J2STORE_REPORT_ITEMISED\",\"type\":\"plugin\",\"creationDate\":\"DEC 2021\",\"author\":\"Alagesan\",\"copyright\":\"2021 J2Store\",\"authorEmail\":\"supports@j2store.org\",\"authorUrl\":\"https:\\/\\/www.j2store.org\",\"version\":\"1.0.0\",\"description\":\"PLG_J2STORE_PLUGIN_REPORT_ITEMISED_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"report_itemised\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('330', '0', 'Localization Data for J2Store', 'plugin', 'app_localization_data', '', 'j2store', '0', '1', '1', '0', '0', '{\"name\":\"Localization Data for J2Store\",\"type\":\"plugin\",\"creationDate\":\"Jan 2015\",\"author\":\"Gokila Priya\",\"copyright\":\"2014-19 WeblogicxIndia\",\"authorEmail\":\"supports@j2store.org\",\"authorUrl\":\"http:\\/\\/www.j2store.org\",\"version\":\"1.0\",\"description\":\"J2STORE_APP_LOCALIZATION_DATA_HELP_TEXT\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"app_localization_data\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('331', '0', 'Diagnostics Tool', 'plugin', 'app_diagnostics', '', 'j2store', '0', '1', '1', '0', '0', '{\"name\":\"Diagnostics Tool\",\"type\":\"plugin\",\"creationDate\":\"February 2015\",\"author\":\"Gokila Priya\",\"copyright\":\"2015 Weblogicx India\",\"authorEmail\":\"supports@j2store.org\",\"authorUrl\":\"http:\\/\\/www.j2store.org\",\"version\":\"1.0\",\"description\":\"J2STORE_DIAGNOSTICS_HELP_TEXT\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"app_diagnostics\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('332', '0', 'Currency Exchange Rates - Google Finance API', 'plugin', 'app_currencyupdater', '', 'j2store', '0', '1', '1', '0', '0', '{\"name\":\"Currency Exchange Rates - Google Finance API\",\"type\":\"plugin\",\"creationDate\":\"NOV 2017\",\"author\":\"Alagesan\",\"copyright\":\"2017 CartRabbit International Pte Ltd\",\"authorEmail\":\"supports@j2store.org\",\"authorUrl\":\"http:\\/\\/www.j2store.org\",\"version\":\"1.0.1\",\"description\":\"This app used to update currency value\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"app_currencyupdater\"}', '{\"CURRENCY_CONVERTER_API_TYPE\":\"exchangerate_host\"}', '', NULL, NULL, '0', '0', NULL),
('333', '0', 'Flexible Variable', 'plugin', 'app_flexivariable', '', 'j2store', '0', '1', '1', '0', '0', '{\"name\":\"Flexible Variable\",\"type\":\"plugin\",\"creationDate\":\"JAN 2018\",\"author\":\"Alagesan\",\"copyright\":\"(C) 2018 Cartrabbit International Pte Ltd\",\"authorEmail\":\"support@j2store.org\",\"authorUrl\":\"www.j2store.org\",\"version\":\"1.0.0\",\"description\":\"This app used to setup flexible variable product for J2Store\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"app_flexivariable\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('334', '0', 'J2STORE_APP_SCHEMAPRODUCTS', 'plugin', 'app_schemaproducts', '', 'j2store', '0', '1', '1', '0', '0', '{\"name\":\"J2STORE_APP_SCHEMAPRODUCTS\",\"type\":\"plugin\",\"creationDate\":\"MAR 2021\",\"author\":\"Alagesan\",\"copyright\":\"2021 J2Store\",\"authorEmail\":\"supports@j2store.org\",\"authorUrl\":\"http:\\/\\/www.j2store.org\",\"version\":\"1.0.0\",\"description\":\"J2STORE_APP_SCHEMAPRODUCTS_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"app_schemaproducts\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('335', '0', 'Product View - Bootstrap 3', 'plugin', 'app_bootstrap3', '', 'j2store', '0', '0', '1', '0', '0', '{\"name\":\"Product View - Bootstrap 3\",\"type\":\"plugin\",\"creationDate\":\"JAN 2025\",\"author\":\"J2Commerce\",\"copyright\":\"(C) 2021 J2Store\",\"authorEmail\":\"support@j2commerce.com\",\"authorUrl\":\"https:\\/\\/www.j2commerce.com\",\"version\":\"4.0.0\",\"description\":\"Bootstrap 3 sub-layout view for J2Commerce.\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"app_bootstrap3\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('336', '0', 'Product View - Bootstrap 4', 'plugin', 'app_bootstrap4', '', 'j2store', '0', '0', '1', '0', '0', '{\"name\":\"Product View - Bootstrap 4\",\"type\":\"plugin\",\"creationDate\":\"JAN 2025\",\"author\":\"J2Commerce\",\"copyright\":\"(C) 2021 J2Store\",\"authorEmail\":\"support@j2commerce.com\",\"authorUrl\":\"https:\\/\\/www.j2commerce.com\",\"version\":\"4.0.0\",\"description\":\"Bootstrap 4 sub-layout view for J2Commerce.\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"app_bootstrap4\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('337', '0', 'Product View - Bootstrap 5', 'plugin', 'app_bootstrap5', '', 'j2store', '0', '1', '1', '0', '0', '{\"name\":\"Product View - Bootstrap 5\",\"type\":\"plugin\",\"creationDate\":\"JAN 2025\",\"author\":\"J2Commerce\",\"copyright\":\"(C) 2021 J2Store\",\"authorEmail\":\"support@j2commerce.com\",\"authorUrl\":\"https:\\/\\/www.j2commerce.com\",\"version\":\"4.0.0\",\"description\":\"Bootstrap 5 sub-layout view for J2Commerce.\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"app_bootstrap5\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('338', '0', 'F0F (NEW) DO NOT REMOVE', 'library', 'f0f', '', '', '0', '1', '1', '0', '0', '{\"name\":\"F0F (NEW) DO NOT REMOVE\",\"type\":\"library\",\"creationDate\":\"2024-04-12\",\"author\":\"Nicholas K. Dionysopoulos \\/ Akeeba Ltd\",\"copyright\":\"(C)2011-2014 Nicholas K. Dionysopoulos\",\"authorEmail\":\"nicholas@akeebabackup.com\",\"authorUrl\":\"https:\\/\\/www.akeebabackup.com\",\"version\":\"revAC17961\",\"description\":\"Framework-on-Framework (FOF) newer version - DO NOT REMOVE - The rapid component development framework for Joomla!. This package is the newer version of FOF, not the one shipped with Joomla! as the official Joomla! RAD Layer. The Joomla! RAD Layer has ceased development in March 2014. DO NOT UNINSTALL THIS PACKAGE, IT IS *** N O T *** A DUPLICATE OF THE \'FOF\' PACKAGE. REMOVING EITHER FOF PACKAGE WILL BREAK YOUR SITE.\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"lib_f0f\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('339', '0', 'Payfast for J2Commerce', 'plugin', 'payment_payfast', '', 'j2store', '0', '1', '1', '0', '0', '{\"name\":\"Payfast for J2Commerce\",\"type\":\"plugin\",\"creationDate\":\"DEC 2024\",\"author\":\"J2Commerce\",\"copyright\":\"2023 Weblogicx India Private Limited\",\"authorEmail\":\"support@j2commerce.com\",\"authorUrl\":\"http:\\/\\/www.j2commerce.com\",\"version\":\"4.0.1\",\"description\":\"PLG_J2STORE_PAYMENT_PAYFAST_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"payment_payfast\"}', '{\"license_key\":{\"license\":\"\",\"status\":\"in_active\",\"expire\":\"\"},\"display_name\":\"Payfast\",\"display_image\":\"images\\/brand\\/payfast_logo.png#joomlaImage:\\/\\/local-images\\/brand\\/payfast_logo.png?width=337&height=120\",\"merchant_id\":\"\",\"merchant_key\":\"\",\"passPhrase\":\"\",\"order_description\":\"\",\"surcharge_percent\":\"\",\"surcharge_fixed\":\"\",\"sandbox\":\"0\",\"sandbox_id\":\"\",\"sandbox_key\":\"\",\"geozone_id\":\"\",\"articleid\":\"\",\"onselection\":\"\",\"onbeforepayment\":\"\",\"onafterpayment\":\"\",\"onerrorpayment\":\"\",\"oncancelpayment\":\"\",\"button_text\":\"J2STORE_PLACE_ORDER\",\"debug\":\"0\"}', '', NULL, NULL, '0', '0', ''),
('344', '264', 'Regular Labs Library', 'library', 'regularlabs', '', '', '0', '1', '1', '0', '0', '{\"name\":\"Regular Labs Library\",\"type\":\"library\",\"creationDate\":\"September 2025\",\"author\":\"Regular Labs (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2025 Regular Labs - All Rights Reserved\",\"authorEmail\":\"info@regularlabs.com\",\"authorUrl\":\"https:\\/\\/regularlabs.com\",\"version\":\"25.9.25453\",\"description\":\"Regular Labs Library - used by Regular Labs extensions\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"RegularLabs\\\\Library\",\"filename\":\"regularlabs\"}', '{}', '', NULL, NULL, '0', '0', NULL),
('345', '347', 'PLG_SYSTEM_TABSACCORDIONS', 'plugin', 'tabsaccordions', '', 'system', '0', '1', '1', '0', '0', '{\"name\":\"PLG_SYSTEM_TABSACCORDIONS\",\"type\":\"plugin\",\"creationDate\":\"September 2025\",\"author\":\"Regular Labs (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2025 Regular Labs - All Rights Reserved\",\"authorEmail\":\"info@regularlabs.com\",\"authorUrl\":\"https:\\/\\/regularlabs.com\",\"version\":\"2.5.6\",\"description\":\"PLG_SYSTEM_TABSACCORDIONS_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"RegularLabs\\\\Plugin\\\\System\\\\TabsAccordions\",\"filename\":\"tabsaccordions\"}', '{\"theme\":\"neutral\",\"color_panels\":\"0\",\"load_stylesheet\":\"1\",\"@note__positioning\":\"top\",\"alignment\":\"justify\",\"switch_to_accordions\":\"1\",\"@note__switch_based_on\":\"top\",\"switch_break_point\":\"576\",\"fit_buttons\":\"scroll\",\"button_scroll_speed\":\"5\",\"button_text\":\"Tabs & Accordions\",\"enable_frontend\":\"1\",\"tag_tabs_open\":\"tab\",\"tag_tabs_close\":\"tabs\",\"tag_accordions_open\":\"accordion\",\"tag_accordions_close\":\"accordions\",\"tag_characters\":\"{.}\",\"title_tag\":\"h3\",\"use_url_hash\":\"1\",\"hide_inactive_content\":\"1\",\"enable_admin\":\"0\",\"place_comments\":\"1\"}', '', NULL, NULL, '0', '0', NULL),
('346', '347', 'PLG_EDITORS-XTD_TABSACCORDIONS', 'plugin', 'tabsaccordions', '', 'editors-xtd', '0', '1', '1', '0', '0', '{\"name\":\"PLG_EDITORS-XTD_TABSACCORDIONS\",\"type\":\"plugin\",\"creationDate\":\"September 2025\",\"author\":\"Regular Labs (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2025 Regular Labs - All Rights Reserved\",\"authorEmail\":\"info@regularlabs.com\",\"authorUrl\":\"https:\\/\\/regularlabs.com\",\"version\":\"2.5.6\",\"description\":\"PLG_EDITORS-XTD_TABSACCORDIONS_DESC\",\"group\":\"\",\"changelogurl\":\"\",\"namespace\":\"RegularLabs\\\\Plugin\\\\EditorButton\\\\TabsAccordions\",\"filename\":\"tabsaccordions\"}', '[]', '', NULL, NULL, '0', '0', NULL),
('347', '0', 'PKG_TABSACCORDIONS', 'package', 'pkg_tabsaccordions', '', '', '0', '1', '1', '0', '0', '{\"name\":\"PKG_TABSACCORDIONS\",\"type\":\"package\",\"creationDate\":\"September 2025\",\"author\":\"Regular Labs (Peter van Westen)\",\"copyright\":\"Copyright \\u00a9 2025 Regular Labs - All Rights Reserved\",\"authorEmail\":\"info@regularlabs.com\",\"authorUrl\":\"https:\\/\\/regularlabs.com\",\"version\":\"2.5.6\",\"description\":\"\",\"group\":\"\",\"changelogurl\":\"\",\"filename\":\"pkg_tabsaccordions\"}', '{}', '', NULL, NULL, '0', '0', NULL);/**ABDB**/
