<?php
/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
 
// No direct access
defined('TCK_LOADED') or die;

use Templatecreatorck\CKView;
use Templatecreatorck\CKFof;

class TemplateckViewFontselect extends CKView {

	protected $fontsSquirrel;

	/**
	 * view display method
	 * @return void
	 * */
	function display($tpl = null) {

		$this->fontsSquirrel = $this->getFontsSquirrel();

		parent::display($tpl);
	}

	private function getFontsSquirrel() {
		// constructs the query
		$query = ' SELECT * '
				. ' FROM #__templateck_fonts';

		// retrieves the data
		$data = CKFof::dbLoadObjectList($query);

		return $data;
	}

	/**
	 * Load the fonts from the db and inject the css in the page
	 * @return void
	 */
	function _callfonts() {
		$fontstyles = '';
		$fontsheets = '';
		$db = \Joomla\CMS\Factory::getDBO();
		$query = "SELECT * FROM #__templateck_fonts";
		$db->setQuery($query);
		$rows = $db->loadObjectList();
		if (!$rows)
			return false;
		foreach ($rows as $row) {
			if (stristr($row->styles, '@import')) 
			{
				$fontsheets .= str_replace(");", "' rel='stylesheet' type='text/css'>", str_replace("@import url(", "<link href='", $row->styles));
			} else {
				$fontstyles .= str_replace("url('", "url('" . \Templatecreatorck\CKUri::base(true) . "/components/com_templateck/fonts/" . $row->name . "/", $row->styles);
			}
		}
		if ($fontstyles)
			echo "<style type=\"text/css\">" . $fontstyles . "</style>";
		if ($fontsheets)
			echo $fontsheets;
	}
}
