<?php

/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
defined('TCK_LOADED') or die;

use Templatecreatorck\CKModel;
use Templatecreatorck\CKFof;

/**
 * Methods supporting a list of Templateck records.
 */
class TemplateckModelTemplates extends CKModel {

	protected $context = 'templateck.templates';

	public function __construct($config = array()) {

		parent::__construct($config);
	}

	/**
	 * Build an SQL query to get the items.
	 *
	 */
	public function getItems() {
		// Create a new query object.
		$db = CKFof::getDbo();
		$query = $db->getQuery(true);

		// Select the required fields from the table.
		$query->select('a.*');
		$query->from('`#__templateck_templates` AS a');

		// Filter by search in title
		$search = $this->getState('filter_search');
		if (!empty($search)) {
			if (stripos($search, 'id:') === 0) {
				$query->where('a.id = ' . (int) substr($search, 3));
			} else {
				$search = $db->Quote('%' .$search . '%');
				$query->where('(' . 'a.name LIKE ' . $search . ' )');
			}
		}

		// Add the list ordering clause.
		$listOrder = $this->state->get('filter_order', 'a.id');
		$listDirn = $this->state->get('filter_order_Dir', 'ASC');
		if ($listOrder && $listDirn) {
			$query->order($listOrder . ' ' . $listDirn);
		}

		$limitstart = $this->state->get('limitstart');
		$limit = $this->state->get('limit');
		$db->setQuery($query, $limitstart, $limit);

		$items = $db->loadObjectList();

		// automatically get the total number of items from the query
		$total = $this->getTotal($query);
		$this->state->set('limit_total', (empty($total) ? 0 : (int)$total));

		return $items;
	}

	// public function getTable($type = 'Template', $prefix = 'TemplateckTable', $config = array()) {
		// return \Joomla\CMS\Table\Table::getInstance($type, $prefix, $config);
	// }

	function copy($id) {

		$row = $this->getTable();
		$input = new TCK_Input();
		$ids = $input->get('id', $id, 'array');
		$id = isset($ids[0]) ? (int) $ids[0] : null;

		$row->load($id);
		$row->id = 0;
		
		// copy the whole template folder with html and custom css
		if (!$this->copyFolder($row, '-copy')) {
			\Templatecreatorck\CKFof::getApplication()->enqueueMessage(\Templatecreatorck\CKText::_('CK_ERROR_COPY_TEMPLATE_FOLDER'), 'warning');
			return false;
		}
		
		// give the new name
		$row->name .= '-copy';

		// Store the table to the database
		if (!$row->store()) {
			$this->setError($row->getErrorMsg());
			return false;
		}

		// $this->setId($row->id);

		return true;
	}

	private function copyFolder($data, $suffix) {
		$path = TEMPLATECREATORCK_TEMPLATES_PATH;
		if (file_exists($path . '/' . $data->name)) {
			if (!\Templatecreatorck\CKFolder::copy($path . '/' . $data->name, $path . '/' . $data->name . $suffix)) {
				return false;
			}
		}
		return true;
	}

	/*function delete() {
		$row = $this->getTable();
		$input = new TCK_Input();
		$ids = $input->get('cid', '', 'array');
//		$id = isset($ids[0]) ? (int) $ids[0] : null;
		foreach ($ids as $id) {
			$row->load((int)$id);

			// Store the table to the database
			if (!$row->delete()) {
				$this->setError($row->getErrorMsg());
				return false;
			}
		}
		// $this->setId($row->id);

		return true;
	}*/
}
