<?php
/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) 2022. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');

$url = $this->input->get('url', '', 'string');
$url = str_replace('http:', 'https:', $url);
if (! $url) {
	echo '{"status" : "0", "msg" : "No url given"}';
	exit;
}

$fontname = $this->input->get('fontname', '', 'string');
if (! $fontname) {
	echo '{"status" : "0", "msg" : "No font name given"}';
	exit;
}

$gfontFolderPath = TEMPLATECREATORCK_PATH . '/gfonts/';
// create fonts folder
if (!TCK_Folder::exists($gfontFolderPath)) {
	if (!TCK_Folder::create($gfontFolderPath)) {
		// $msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FOLDER') . ' /fonts</p>';
	} else {
		// $msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FOLDER') . ' /fonts</p>';
	}
	// $messages[] = $msg;
}

// check if file exists
$filePath = $gfontFolderPath . $fontname . '.css';

// get the file from url
set_time_limit(0);

if (extension_loaded('curl')) {
	try {
		$ch = curl_init();  
		$timeout = 30;  
		curl_setopt($ch, CURLOPT_URL, $url);  
		curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
		curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
		curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
		curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
		curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);

		$file = curl_exec($ch);  
		if($file === false)
		{
			echo '{"status" : "0", "msg" : "Curl error: ' . curl_error($ch) . '"}';
			// echo 'Curl error: ' . curl_error($ch);
		}
		else
		{
			// echo 'Operation completed without any errors';
		}
		curl_close($ch);  
	} catch (Exception $e) {
	// echo 'Exception : ',  $e->getMessage(), "\n";
	echo '{"status" : "0", "msg" : "' . $e->getMessage() . '"}';
	exit;
	}
} else {
	try {
		var_dump($url);
		$file = file_get_contents(urldecode($url));
	} catch (Exception $e) {
		// echo 'Exception : ',  $e->getMessage(), "\n";
		echo '{"status" : "0", "msg" : "' . $e->getMessage() . '"}';
		exit;
	}
}

// store the file locally
$result = file_put_contents($filePath, $file);
if (! $result) {
	echo '{"status" : "0", "file" : "", "msg" : "Error on file creation"}';
	exit();
}

// download the ttf files
$filesize = 0;
preg_match_all('/url\((.*?)\)/', $file, $matches);
if (isset($matches[0]) && ! empty($matches[1])) {
	if (is_array($matches[1])) {
		foreach($matches[1] as $url) {
			try {
				$ch = curl_init();  
				$timeout = 30;  
				curl_setopt($ch, CURLOPT_URL, $url);  
				curl_setopt($ch, CURLOPT_RETURNTRANSFER, 1); 
				curl_setopt($ch, CURLOPT_FOLLOWLOCATION, 1);
				curl_setopt($ch, CURLOPT_SSL_VERIFYPEER, 0);
				curl_setopt($ch, CURLOPT_SSL_VERIFYHOST, 0);
				curl_setopt($ch, CURLOPT_CONNECTTIMEOUT, $timeout);

				$ttffile = curl_exec($ch);  
				if($ttffile === false)
				{
					echo '{"status" : "0", "msg" : "Curl error: ' . curl_error($ch) . '"}';
				}
				else
				{
					// echo 'Operation completed without any errors';
				}
				curl_close($ch);  
			} catch (Exception $e) {
				echo '{"status" : "0", "msg" : "' . $e->getMessage() . '"}';
				exit;
			}
			$filename = explode('/', $url);
			$filename = end($filename);
			$filePath = $gfontFolderPath . $filename;
			$result = file_put_contents($filePath, $ttffile);
			if (! $result) {
				echo '{"status" : "0", "file" : "", "msg" : "Error on file creation"}';
				exit();
			}
			$filesize += filesize($filePath);
		}
	}
}


echo '{"status" : "1", "file" : "' . $fontname . '.css' . '", "filesize" : "' . $filesize . '"}';
exit;