<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');
$input = new TCK_Input();
$colorsList = $input->get('colorsList', '', 'string');
$colorsArray = json_decode($colorsList);
?>
<div id="ckgfontsmanager">
	<h3><?php echo TCK_Text::_('CK_VARIATIONS_MANAGER') ?></h3>
	<p><?php echo TCK_Text::_('CK_VARIATIONS_MANAGER_DESC') ?></p>
	<p>Mettre options générales, pour body bg, color, links color</p>
	#[0-9a-fA-F]{6,6} >> cherche hex values
	<table style="width: 100%;vertical-align: middle;" class="ckedition cktable cktable-striped cktable-bordered cktable-hover">
	<?php
	// for ($i=1;$i<=5;$i++) {
	if (empty($colorsArray)) {
		?>
		<p class="ckalert"><?php echo TCK_Text::_('CK_NO_GOOGLE_FONT_FOUND_IN_PAGE') ?></p>
		<?php
	} else {
		foreach ($colorsArray as $color => $name) {
			// var_dump($name);
			$names = explode(',', $name);
			
			// var_dump($names);
			?>
			<tr data-color="<?php echo $color ?>">
				<td>
					<span class="ckColorPreview" style="background-color:<?php echo $color ?>;"></span>
					<span><?php echo $color ?></span>
					<?php foreach ($names as $n) { 
					$texts = explode(':', $n);
					?>
					<p><span><?php echo'<span class="ckbadge">' . $texts[0] . '</span> <span>' . $texts[1] . '</span>' ?></span></p>
					<?php }?>
				</td>
				<td>
					<span class="ckbutton ckbutton-danger" onclick="test('<?php echo $color ?>')"><?php echo TCK_Text::_('CK_DELETE') ?></span>
				</td>
			</tr>
		<?php
		}
	}
	?>
	</table>
</div>
<script>
	ckInitColorPickers();
</script>
<style>
.ckColorPreview {
	display: inline-block;
	width: 40px;
	height: 40px;
	border-radius: 3px;
	margin: 5px;
	vertical-align: middle;
}

.ckColorPreview + span {
	display: inline-block;
}
</style>
