<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');
?>
<div class="cktitle"><?php echo TCK_Text::_('CK_ROW_MANAGER'); ?></div>
<table>
	<tr>
		<td style="vertical-align:top;">
			<div class="ckpopupinfos">
				<div class="ckpopupinfostitle"><?php echo TCK_Text::_('CK_ROW_MANAGER_INFOS'); ?></div>
				<div class="ckpopupinfosdesc"><?php echo TCK_Text::_('CK_ROW_MANAGER_DESC'); ?></div>
			</div>
		</td>
		<td style="vertical-align:top;">
			<div id="ckelementscontainer" style="margin-top: 8px;">

				<div id="modulesnumberselect">
					<div class="modulemanagerheader"><?php echo TCK_Text::_('CK_NUMBEROFMODULES'); ?></div>
					<div class="blocnumberselect" onclick="selectnumberofmodules(1);">
						<?php echo TCK_Text::_('1'); ?>
					</div>
					<div class="blocnumberselect" onclick="selectnumberofmodules(2);">
						<?php echo TCK_Text::_('2'); ?>
					</div>
					<div class="blocnumberselect" onclick="selectnumberofmodules(3);">
						<?php echo TCK_Text::_('3'); ?>
					</div>
					<div class="blocnumberselect" onclick="selectnumberofmodules(4);">
						<?php echo TCK_Text::_('4'); ?>
					</div>
					<div class="blocnumberselect" onclick="selectnumberofmodules(5);">
						<?php echo TCK_Text::_('5'); ?>
					</div>
					<div class="blocnumberselect" onclick="selectnumberofmodules(6);">
						<?php echo TCK_Text::_('6'); ?>
					</div>
					<div class="blocnumberselect" onclick="selectnumberofmodules(7);">
						<?php echo TCK_Text::_('7'); ?>
					</div>
					<div class="blocnumberselect" onclick="selectnumberofmodules(8);">
						<?php echo TCK_Text::_('8'); ?>
					</div>
					<input type="hidden" name="blocnumberselect" id="blocnumberselect" value="" />
					<div class="clr"></div>
				</div>
				<div id="modulesmanagertitle"><?php echo TCK_Text::_('CK_ROW_MANAGER'); ?></div>
				<div id="modulesmanager">
					<div class="modulemanagercontainer clearfix">
						<?php for($i=0; $i<8; $i++) { ?>
						<div class="modulemanager">
							<div class="inner" onclick="togglemodulewidthstate(this);">
							</div>
							<div class="modulewidthselectcont">
								<input type="text" class="inputbox modulewidthselect" id="rowmanagerbloc<?php echo $i ?>" value="" onchange="calculateblocswidth(this);"/>
								<?php echo TCK_Text::_('%'); ?>
							</div>
							<div class="modulewidth">
								<div class="modulewidth_barleft"></div>
								<div class="modulewidth_barright"></div>
								<div class="clr"></div>
							</div>
						</div>
						<?php } ?>
					</div>
				</div>
			</div>
		</td>
	</tr>
</table>
<script language="javascript" type="text/javascript">
			function calculateblocswidth(field) {
				var container = $ck(field).parents('.modulemanagercontainer');
				var enabledfields = $ck('.modulemanager:not(.disabled) .modulewidthselect:not(.disabled,.locked,#' + $ck(field).attr('id') + ')', container);
				var amount = enabledfields.length;
				var lockedvalue = 0;
				$ck('.modulewidthselect.locked', container).each(function(i, modulefield) {
					modulefield = $ck(modulefield);
					if (modulefield.attr('value') == '') {
						modulefield.removeClass('locked').next('input').attr('checked', false);
						calculateblocswidth(field);
					}
					if (modulefield.attr('id') != $ck(field).attr('id')) {
						lockedvalue = parseFloat(modulefield.attr('value')) + parseFloat(lockedvalue);
					}
				});
				var mw = parseFloat($ck(field).attr('value'));
				// $ck(field).attr('value',mw+'%');
				var percent = (100 - mw - lockedvalue) / amount;
				enabledfields.each(function(i, modulefield) {
					if ($ck(modulefield).attr('id') != $ck(field).attr('id')
							&& !$ck(modulefield).hasClass('locked')) {
						$ck(modulefield).attr('value', parseFloat(percent));
					}
				});
				changemoduledisplay();
			}

			function togglemodulewidthstate(locker) {
				var input = $ck(locker).parent().find('input.modulewidthselect');
				var enableamount = $ck('.modulemanager:not(.disabled)', $ck(locker).parents('.modulemanagercontainer')).length;
				var loackedamount = $ck('.modulewidthselect.locked', $ck(locker).parents('.modulemanagercontainer')).length;
				if (loackedamount >= (enableamount - 1) && !input.hasClass('locked')) {
					alert('Not possible ! You can not lock all the width');
					return;
				}

				if (!input.hasClass('locked')) {
					input.addClass('locked');
					$ck(locker).addClass('locked');
				} else {
					input.removeClass('locked');
					$ck(locker).removeClass('locked');
				}
			}

			function selectnumberofmodules(number) {
				$ck('.modulemanager:gt(' + (number - 1) + ')').css('display', 'none').addClass('disabled');
				$ck('.modulemanager:lt(' + (number) + ')').css('display', 'block').removeClass('disabled');
				$ck('.blocnumberselect').removeClass('selected');
				$ck('.blocnumberselect:eq(' + (number - 1) + ')').addClass('selected');
				$ck('#blocnumberselect').attr('value', number);
				setmoduleswidth(true);
				changemoduledisplay();
			}

			function changemoduledisplay() {
				$ck('.modulemanager').each(function(i, module) {
					$ck(module).css('width', parseFloat($ck(module).find('.modulewidthselect').attr('value')) + '%');
				});
			}

			function initmodules() {
				var focus = $ck('.ckfocus');
				if (!focus.attr('numberofmodules')) {
					selectnumberofmodules(4);
				} else {
					selectnumberofmodules(focus.attr('numberofmodules'));

				}

				setmoduleswidth();
				changemoduledisplay();
			}

			function setmoduleswidth(isnew) {
				nbmodules = $ck('#blocnumberselect').val();
				moduleswidthfromfocus = $ck('.ckfocus > .inner > .ckrowcontainer').map(function() { return $ck(this).attr('data-width'); });
				moduleswidth = moduleswidthfromfocus.length && !isnew ? moduleswidthfromfocus : ckGetdefaultwidth(nbmodules)
				// moduleswidth = $ck('.ckfocus').attr('blocswidth') && !isnew ? $ck('.ckfocus').attr('blocswidth').split(',') : ckGetdefaultwidth(nbmodules);
				$ck('.modulewidthselect').each(function(j, module) {
					module = $ck(module);
					module.attr('value', moduleswidth[j]);
				});
			}
			initmodules();
</script>