<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');
?>
<?php TemplateckHelper::renderInterfaceSliderTitle(TCK_Text::_('CK_COLUMNS'), '', 'ckRemoveColumnEdition') ?>
<div class="inner">
<div id="ckcolumnsoptions" class="ckinterface">
	<div id="ckgutteroptions" class="ckoption">
		<div class="menuckinfos"><?php echo TCK_Text::_('CK_GUTTER') ?></div>
		<input class="ckguttervalue" type="text" onchange="ckUpdateGutter($ck('.ckrow.ckfocus'), this.value);" />
	</div>
	<div id="modulesnumberselect" class="ckoption">
		<div class="modulemanagerheader"><?php echo TCK_Text::_('CK_NUMBER_OF_COLUMNS'); ?></div>
		<div class="ckoption-field ckbutton-group">
			<label class="ckbutton ckbutton-small" onclick="ckSelectNumberOfColumns(1);" style="width:25px;min-width:25px;"><?php echo TCK_Text::_('1'); ?></label>
			<label class="ckbutton ckbutton-small" onclick="ckSelectNumberOfColumns(2);" style="width:25px;min-width:25px;"><?php echo TCK_Text::_('2'); ?></label>
			<label class="ckbutton ckbutton-small" onclick="ckSelectNumberOfColumns(3);" style="width:25px;min-width:25px;"><?php echo TCK_Text::_('3'); ?></label>
			<label class="ckbutton ckbutton-small" onclick="ckSelectNumberOfColumns(4);" style="width:25px;min-width:25px;"><?php echo TCK_Text::_('4'); ?></label>
			<label class="ckbutton ckbutton-small" onclick="ckSelectNumberOfColumns(5);" style="width:25px;min-width:25px;"><?php echo TCK_Text::_('5'); ?></label>
			<label class="ckbutton ckbutton-small" onclick="ckSelectNumberOfColumns(6);" style="width:25px;min-width:25px;"><?php echo TCK_Text::_('6'); ?></label>
			<label class="ckbutton ckbutton-small" onclick="ckSelectNumberOfColumns(7);" style="width:25px;min-width:25px;"><?php echo TCK_Text::_('7'); ?></label>
			<label class="ckbutton ckbutton-small" onclick="ckSelectNumberOfColumns(8);" style="width:25px;min-width:25px;"><?php echo TCK_Text::_('8'); ?></label>
		</div>
		<input type="hidden" name="blocnumberselect" id="blocnumberselect" value="" />
		<div class="clr"></div>
	</div>
	<div id="ckcolumnsuggestions">

	</div>
</div>
</div>
<script language="javascript" type="text/javascript">
	function ckEditColumns(row, force, forcehide) {
		if (! force) force = false;
		if (row.find('.ckcolwidthedition').length && ! force || forcehide) {
			row.find('.ckcolwidthedition').remove();
			row.find('.ckcolwidthediting').removeClass('ckcolwidthediting');
		} else {
			var nbcols = row.find('.ckrowcontainer').length;
			$ck('#modulesnumberselect label').removeClass('active');
			$ck('#modulesnumberselect label').eq(nbcols - 1).addClass('active');
			var default_data_width = 100 / nbcols;
			row.find('.ckrowcontainer').each(function(i, column) {
				var column = $ck(column);
				column.addClass('ckcolwidthediting');
				var col_data_width = column.attr('data-width') ? column.attr('data-width') : default_data_width;
				if (! column.find('.ckcolwidthedition').length) column.append('<div class="ckcolwidthedition"><div class="ckcolwidthlocker ckhastip" title="<?php echo TCK_Text::_('CK_LOCK') ?>" onclick="ckToggleColWidthState(this);"></div><input id="' + row.attr('id') + '_w' + i + '" class="ckcolwidthselect inputbox" value="' + col_data_width + '" onchange="ckCalculateBlocsWidth(this);" type="text" /> <span class="ckcolwidthselectunit">%</span></div>')
			});
			ckInitTooltip();
		}
		ckInitFixedColumns();
	}

	function ckToggleColWidthState(locker) {
		var input = $ck(locker).parent().find('input.ckcolwidthselect');
		var enableamount = $ck('.ckcolwidthselect:not(.disabled)', $ck(locker).parents('.ckrow')).length;
		var loackedamount = $ck('.ckcolwidthedition.locked', $ck(locker).parents('.ckrow')).length;

		if (loackedamount >= (enableamount - 1) && !input.hasClass('locked')) {
			alert('<?php echo TCK_Text::_('CK_CAN_NOT_LOCK_ALL_WIDTH') ?>');
			return;
		}

		if (!input.hasClass('locked')) {
			input.addClass('locked');
			$ck(locker).addClass('locked');
			$ck(locker).parent().addClass('locked');
		} else {
			input.removeClass('locked');
			$ck(locker).removeClass('locked');
			$ck(locker).parent().removeClass('locked');
		}
	}

	function ckInitFixedColumns() {
		// look for "px" because they are unchangeable fields
		$ck('.ckcolwidthselect').each(function() {
			var w = $ck(this).val();
			if (w.indexOf('px') > -1) {
				if (! $ck(this).hasClass('locked')) ckToggleColWidthState($ck(this).parent().find('.ckcolwidthlocker'));
				$ck(this).parent().find('.ckcolwidthselectunit').hide();
			} else {
				$ck(this).parent().find('.ckcolwidthselectunit').show();
			}
		});
	}
	function ckCalculateBlocsWidth(field) {
		var w = $ck(field).val();
		var row = $ck($ck(field).parents('.ckrow')[0]);

		if (w.indexOf('px') > -1 && $ck(field).hasClass('locked')) {
			ckSetColumnsWidth(row);
			return;
		}

		var fixedvalue = ckGetFixedColumnsValue();
		var enabledfields = $ck('.ckcolwidthedition:not(.disabled) .ckcolwidthselect:not(.disabled,.locked,#' + $ck(field).attr('id') + ')', row);
		var amount = enabledfields.length;

		ckInitFixedColumns();

		// look for locked fields
		var lockedvalue = 0;
		$ck('.ckcolwidthselect.locked', row).each(function(i, modulefield) {
			var w = $ck(this).val();
			modulefield = $ck(modulefield);
			if (w == '') {
				modulefield.removeClass('locked').next('input').attr('checked', false);
				ckCalculateBlocsWidth(field);
			}
			if (modulefield.attr('id') != $ck(field).attr('id')) {
				if (w.indexOf('px') == -1) lockedvalue = parseFloat(w) + parseFloat(lockedvalue);
			}
		});

		var mw = 0;
		if (w.indexOf('px') == -1) {
			mw = parseFloat(w);
		}
		var percent = (100 - mw - lockedvalue) / amount;

		enabledfields.each(function(i, modulefield) {
			if ($ck(modulefield).attr('id') != $ck(field).attr('id')
					&& !$ck(modulefield).hasClass('locked')) {
					
				$ck(modulefield).val(parseFloat(percent));
			}
		});
		ckSetColumnsWidth(row);
	}

	function ckGetFixedColumnsValue() {
		var fixedvalue = 0;
		$ck('.ckcolwidthselect').each(function() {
			var w = $ck(this).val();
			if (w.indexOf('px') > -1) {
				fixedvalue += parseInt(w);
			}
		});

		return fixedvalue;
	}

	function ckSetColumnsWidth(row) {
		var fixedvalue = ckGetFixedColumnsValue();
		var gutter = ckGetRowGutterValue(row);
		var nbcols = row.find('.ckrowcontainer').length;
		row.attr('numberofmodules', nbcols);
		row.find('.ckrowcontainer').each(function(i, col) {
			col = $ck(col);
			var w = col.find('.ckcolwidthselect').val();

			if (w.indexOf('px') == -1) {
				if (col.find('.ckcolwidthselect').length) $ck(col).attr('data-width', col.find('.ckcolwidthselect').attr('value'));
				w = col.attr('data-width');
				ckSetColumnWidth(col, w, gutter, nbcols);
			} else {
				ckSetColumnWidth(col, w, gutter, nbcols);
			}
		});
	}

	function ckSetColumnWidth(col, w, gutter, nbcols, ignoreFixed) {
		var fixedvalue = 0;
		if (! ignoreFixed) fixedvalue= ckGetFixedColumnsValue();
		if (w.toString().indexOf('px') == -1) {
//			var realwidth = 'calc(' + parseFloat(w) + ' / 100 * (100% - (' + (nbcols - 1) + ' * ' + gutter + ')))'; 
			var realwidth = 'calc(' + parseFloat(w) + ' / 100 * (100% - ' + fixedvalue + 'px - (' + (nbcols - 1) + ' * ' + gutter + ')))'; 
			col.attr('data-real-width', realwidth).attr('data-width', w).css('width', realwidth);
		} else {
			$ck(col).attr('data-width', w);
			col.attr('data-real-width', w).attr('data-width', w).css('width', w);
		}
	}

	function ckGetRowGutterValue(row) {
		var gutter = row.attr('data-gutter') ? row.attr('data-gutter') : '0';
		gutter = ckTestUnit(gutter);
		row.attr('data-gutter', gutter);
		return gutter;
	}

	function ckUpdateGutter(row, gutter) {
		row.attr('data-gutter', ckTestUnit(gutter));
		ckSetColumnsWidth(row);
	}

	function ckSelectNumberOfColumns(number) {
		$ck('#blocnumberselect').attr('value', number);
		$ck('.ckcolwidthselectunit').show();
		$ck('.locked').removeClass('locked');
		ckUpdateColumns();
		ckEditColumns($ck('.ckfocus'), true);
	}

	function ckUpdateColumns() {
		var row = $ck('.ckfocus');
		nbcols = $ck('#blocnumberselect').attr('value');
		row.attr('numberofmodules', nbcols);
		// check if we need to add a column
		nbexistingcols = $ck('> .inner > .ckrowcontainer', row).length;
		if (nbexistingcols < nbcols) {
			for (var i=0; i < (nbcols - nbexistingcols); i++) {
				ckCreateRowContainer(row);
			}
		}
		// check if we need to remove a column
		$ck('> .inner > .ckrowcontainer', row).each(function(i, bloc) {
			bloc = $ck(bloc);
			if (i >= nbcols) {
				if (bloc.find('.ckbloc').length) {
					bloc.prev().append(bloc.find('.ckbloc'));
					bloc.remove();
				} else {
					bloc.remove();
				}
			}
		});
		var moduleswidth = ckGetdefaultwidth(nbcols);
		$ck('> .inner > .ckrowcontainer', row).each(function(j, bloc) {
			bloc = $ck(bloc);
			var gutter = ckGetRowGutterValue(row);
			ckSetColumnWidth(bloc, moduleswidth[j], gutter, nbcols, 1);
			// bloc.attr('data-width', moduleswidth[j]).css('width', moduleswidth[j] + '%');
			bloc.find('.ckcolwidthselect').val(moduleswidth[j]);
		});
	}

	function ckGetdefaultwidth(nbmodules) {
		var defaultwidths = new Array();
		defaultwidth = 100 / parseInt(nbmodules);
		for (i = 0; i < nbmodules; i++) {
			defaultwidths.push(defaultwidth);
		}
		return defaultwidths;
	}

	function ckBeforeCloseEditionPopup() {
		ckRemoveColumnEdition()
	}

	// init the options
	$ck('#ckedition .ckguttervalue').val(ckGetRowGutterValue($ck('.ckfocus')));
	ckEditColumns($ck('.ckfocus'), true);
	ckInitOptionsSliders($ck('#ckelementscontainer .ckinterfacesliderparent'));
</script>