
<?php
/**
 * @package     Joomla.Plugin
 * @subpackage  J2Store.payment_payfast
 *
 * @copyright Copyright (C) 2018 J2Store. All rights reserved.
 * @copyright Copyright (C) 2024 J2Commerce, LLC. All rights reserved.
 * @license https://www.gnu.org/licenses/gpl-3.0.html GNU/GPLv3 or later
 * @website https://www.j2commerce.com
 */

defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Factory;
use Joomla\CMS\Component\ComponentHelper;
use Joomla\CMS\Language\Text;

class plgJ2StorePayment_payfastInstallerScript {

    function preflight( $type, $parent ) {
        if (!ComponentHelper::isEnabled ( 'com_j2store' )) {
            Factory::getApplication()->enqueueMessage(Text::_('J2Commerce not found. Please install J2Commerce before installing this plugin.'), 'warning');
            return false;
        }

        $version_file = JPATH_ADMINISTRATOR . '/components/com_j2store/version.php';
        if (file_exists( $version_file )) {
            require_once ($version_file);
            if (version_compare ( J2STORE_VERSION, '4.0.9', 'lt' )) {
                Factory::getApplication()->enqueueMessage(Text::_('You are using an older version of J2Commerce. Please upgrade to the latest version.'), 'warning');
                return false;
            }
        } else {
            Factory::getApplication()->enqueueMessage(Text::_('J2Store not found or the version file is not found. Make sure that you have installed J2Commerce before installing this plugin.'), 'warning');
            return false;
        }
        return true;
    }
}
