<?php
/**
 * @package     Joomla.Plugin
 * @subpackage  J2Store.payment_payfast
 *
 * @copyright Copyright (C) 2018 J2Store. All rights reserved.
 * @copyright Copyright (C) 2024 J2Commerce, LLC. All rights reserved.
 * @license https://www.gnu.org/licenses/gpl-3.0.html GNU/GPLv3 or later
 * @website https://www.j2commerce.com
 */

defined('_JEXEC') or die('Restricted access');
use Joomla\CMS\Language\Text;
use Joomla\CMS\Uri\Uri;
use Joomla\Filesystem\Path;
?>
<div class="note">
  	<?php $image = $this->params->get('display_image', ''); ?>
        <?php if(!empty($image)): ?>
         	<span class="j2store-payment-image">
				<img class="payment-plugin-image payment_payfast" src="<?php echo Uri::root().Path::clean($image); ?>" />
			</span>
			<br />
		<?php endif; ?>

     <?php echo Text::_($vars->display_name); ?>
	<br />
	<?php echo Text::_($vars->onbeforepayment_text); ?>
</div>
<form action='<?php echo $vars->post_url.'/eng/process'; ?>' method='post'>
	<!-- Merchand info  -->

	<input type='hidden' name='merchant_id' value='<?php echo $vars->merchant_id; ?>' />
    <input type='hidden' name='merchant_key' value='<?php echo $vars->merchant_key; ?>' />

	<!-- Redirect -->
    <input type='hidden' name='return_url' value='<?php echo $vars->return_url; ?>' />
	<input type='hidden' name='cancel_url' value='<?php echo $vars->cancel_url; ?>' />
	<input type="hidden" name="notify_url" value="<?php echo $vars->notify_url; ?>" />

	<!--USER INFO-->
    <input type='hidden' name='name_first' value='<?php echo $vars->name_first; ?>' />
    <input type='hidden' name='name_last' value='<?php echo $vars->name_last; ?>' />
	 <input type='hidden' name='email_address' value='<?php echo $vars->email_address; ?>' />


    <!-- IPN-PDT  ONLY -->
    <input type='hidden' name='m_payment_id' value='<?php echo $vars->m_payment_id; ?>'>
  	<input type='hidden' name='amount' value='<?php echo $vars->amount ?>' />
  	<input type="hidden" name="item_name" value="<?php echo $vars->item_name;?>" />
  	<input type="hidden" name="item_description" value="<?php echo $vars->item_description;?>" />
    <input type="submit" class="btn btn-primary button" value="<?php echo Text::_($vars->button_text); ?>" />
</form>
