(function () {
    'use strict';

    /* eslint-disable */

    /* eslint-disable dot-notation */
    /* global codemirror, jQuery */

    (function ($) {
        $.fn.codemirror = function (options) {
            return this.each(function () {
                if (typeof CodeMirror === 'undefined') {
                    throw 'CodeMirror is not loaded!';
                }

                var themeMap = {
                    'codemirror' : 'oneLight',
                    'codemirror-dark' : 'oneDark'
                };

                var theme = themeMap[options.theme] || options.theme;

                var settings = {
                    theme: theme,
                    tag_closing: !!options.tag_closing,
                    selection_match: !!options.selection_match,
                    element: $(this).get(0)
                };

                codemirror.init(settings);

                if (options.font_size) {                
                    $('<style>.cm-editor { font-size: ' + options.font_size + 'px; }</style>').prependTo('head');
                }

                // set active line
                codemirror.activeLine = 0;

                // line wrapping
                $(this).on('codemirror:wrap', function (evt, state) {
                    codemirror.toggleWrap();

                    try {
                        codemirror.focus();
                    } catch (e) {
                        // error
                    }
                });

                // gutter
                $(this).on('codemirror:linenumbers', function (evt, state) {
                    codemirror.toggleNumbers();

                    try {
                        codemirror.focus();
                    } catch (e) {
                        // error
                    }
                });

                // highlight only available for codemirror themes
                if (!theme.startsWith('codemirror')) {
                    $('button[data-action="highlight"]').hide();
                }

                $(this).on('codemirror:highlight', function (evt, state) {
                    var c = codemirror.getCursor();

                    codemirror.toggleHighlight();

                    codemirror.setCursor(c);

                    try {
                        codemirror.focus();
                    } catch (e) {
                        // error
                    }
                });

                $(this).on('codemirror:setcontent', function (evt, value) {
                    if (value === '') {
                        value = '\u00a0';
                    }

                    codemirror.setContent(value);

                    try {
                        codemirror.focus();
                    } catch (e) {
                        // error
                    }
                });

                $(this).on('codemirror:insertcontent', function (value) {
                    return codemirror.insertContent(value);
                });

                $(this).on('codemirror:getcontent', function () {
                    return codemirror.getContent();
                });

                $(this).on('codemirror:undo', function () {
                    return codemirror.undo();
                });

                $(this).on('codemirror:redo', function () {
                    return codemirror.redo();
                });

                $(this).on('codemirror:clearsearch', function () {
                    codemirror.search('');
                });

                $(this).on('codemirror:search', function (evt, query, replace, re) {
                    // init search
                    if (query) {
                        codemirror.search(query, replace, re);
                    } else {
                        codemirror.searchNext();
                    }
                }).on('codemirror:searchprev', function () {
                    codemirror.searchPrevious();
                });

                $(this).on('codemirror:replace', function (evt, all) {
                    if (!all) {
                        codemirror.replaceNext();
                    } else {
                        codemirror.replaceAll();
                    }
                });
            });
        };
    })(jQuery);

    /* global Wf, jQuery, tinyMCEPopup, html_beautify, js_beautify, css_beautify, FileBrowser */
    (function ($) {
        var getExtension = function (filename) {
            
            if (filename.indexOf('.') !== -1) {
                var parts = filename.split('.');
                var extension = parts[parts.length - 1];

                extension = extension.toLowerCase();

                return extension;
            }
            
            return '';
        };

        var mimeMap = {
            'html': 'html',
            'htm': 'html',
            'js': 'javascript',
            'css': 'css',
            'scss': 'css',
            'less': 'css',
            'json': 'javascript',
            'xml': 'xml',
            'txt': 'plain',
            'md': 'plain'
        };
        
        var CodeEditor = {
            options: {
                format: true,
                width: '100%',
                height: '100%',
                theme: 'codemirror',
                font_size: '',
                fullscreen: false,
                editor: {},
                format_options: {},
                linenumbers: true,
                wrap: true,
                onsave: function () { }
            },
            init: function (options) {
                var self = this;

                $.extend(this.options, options);

                // get file src from window arguments
                this.src = tinyMCEPopup.getWindowArg('url', '');

                // get content from window arguments
                var content = tinyMCEPopup.getWindowArg('content') || '\u00a0';

                function loadContent(content) {
                    // format content if required
                    if (self.options.format && content) {
                        content = self.formatHTML(content);
                    }

                    self._load(content);
                }

                $(document).ready(function () {

                    self._createToolbar();

                    self.options.mode = 'text/html';

                    if (self.src) {
                        var extension = getExtension(self.src);

                        if (extension) {
                            self.options.mode = 'text/' + (mimeMap[extension] || 'html');
                        }
                    }

                    // create codemirror
                    $('.source-editor-container').codemirror(self.options);

                    // load any passed in content
                    loadContent(content);

                    if (self.src) {
                        $.ajax({
                            "url": self.src + '?' + $.now(),
                            "dataType": "text"
                        }).done(function (content) {
                            loadContent(content);
                        }).fail(function (e, status, txt) {
                            // don't show alert for jQuery abort
                            if (status !== "abort") {
                                Wf.Modal.alert(status);
                            }
                        });
                    }

                    $('button.save').on('click', function (e) {
                        self.save();
                        e.preventDefault();
                    });
                });
            },

            formatHTML: function (html, options) {
                // format JSON using native functions
                if (this.src && /\.json$/i.test(this.src)) {
                    try {
                        html = JSON.stringify(JSON.parse(html), null, '\t');
                    } catch (e) {
                        // error
                    }

                    return html;
                }

                options = $.extend({
                    'max_char': 0,
                    'wrap_line_length': 0,
                    'inline': [
                        'a', 'abbr', 'b', 'bdi', 'bdo', 'br', 'cite',
                        'code', 'data', 'del', 'dfn', 'em', 'i', 'img',
                        'ins', 'kbd', 'keygen', 'map', 'mark', 'math', 'meter', 'noscript',
                        'output', 'progress', 'q', 'ruby', 's', 'samp', 'small',
                        'span', 'strong', 'sub', 'sup', 'time', 'u', 'var',
                        'wbr', 'text', 'acronym', 'big', 'strike', 'tt'
                    ]
                }, this.options.format_options);

                if (typeof html_beautify !== 'undefined') {
                    var mode = 'html';

                    if (this.src) {
                        var extension = getExtension(this.src);

                        if (extension) {
                            mode = mimeMap[extension] || 'html';
                        }
                    }

                    if (mode === 'javascript') {
                        html = js_beautify(html);
                    } else if (mode === 'css') {
                        html = css_beautify(html);
                    } else {
                        html = html_beautify(html, options);
                    }
                }

                return html;
            },

            _createToolbar: function () {
                var opt = this.options;

                var $elm = $('.source-editor-container');

                function triggerSearch() {
                    var value = $('#source_search_value').val();
                    var replace = $('#source_replace_value').val();
                    
                    var regex = $('button[data-action="regex"]').hasClass('uk-active');
                    var wholeword = $('button[data-action="wholeword"]').hasClass('uk-active');
                    var matchcase = $('button[data-action="matchcase"]').hasClass('uk-active');

                    var options = {
                        regex: !!regex,
                        wholeWord: !!wholeword,
                        caseSensitive: !!matchcase
                    };

                    if (!replace) {
                        replace = false;
                    }

                    $elm.trigger('codemirror:search', [value, replace, options]);
                }

                // search
                $('#source_search_value').on('input', function () {
                    triggerSearch();
                }).on('keydown', function (e) {
                    if (e.keyCode === 13) {
                        e.preventDefault();
                        triggerSearch();
                    }
                });

                $('#source_replace_value').on('keydown', function (e) {
                    if (e.keyCode === 13) {
                        e.preventDefault();
                        triggerSearch();
                    }
                });

                $('.source-editor .uk-navbar button').click(function (e) {
                    e.preventDefault();

                    var action = $(this).data('action');

                    // search
                    if (action == 'search' || action == 'search-previous') {
                        triggerSearch();
                        
                        if (action == 'search-previous') {
                            return $elm.trigger('codemirror:searchprev');
                        }

                        return $elm.trigger('codemirror:search');
                    }

                    // replace
                    if (action == 'replace' || action == 'replace-all') {
                        triggerSearch();
                        
                        var all = !!(action == 'replace-all');
                        return $elm.trigger('codemirror:replace', [all]);
                    }

                    if ($(this).hasClass('uk-button-checkbox')) {
                        $(this).toggleClass('uk-active');

                        if (action == 'regex' || action == 'wholeword' || action == 'matchcase') {
                            triggerSearch();
                        }
                    }

                    $elm.trigger('codemirror:' + action, $(this).hasClass('uk-active'));


                }).filter('.uk-button-checkbox').each(function () {
                    var action = $(this).data('action');

                    if (opt[action]) {
                        $(this).addClass('uk-active');
                    }
                });

                // clear search if search input emptied
                $('#source_search_value').change(function () {
                    if (this.value === "") {
                        $elm.trigger('codemirror:clearsearch');
                    }
                });
            },

            setButtonState: function (button, state) {
                $('.source-editor .uk-navbar button[data-action="' + button + '"]').toggleClass('uk-active', state);
            },

            _load: function (content) {
                var self = this;

                // create format event
                $('.source-editor-container').on('codemirror:format', function () {
                    // get content
                    var html = $(this).triggerHandler('codemirror:getcontent');

                    // set content with formatting
                    self.setContent(html, true);
                });

                this._loaded(content);
            },

            _loaded: function (content) {
                this.setContent(content);

                // set word wrap
                $('.source-editor-container').trigger('codemirror:wrap', !!this.options.wrap);

                // set line numbers / gutter
                $('.source-editor-container').trigger('codemirror:linenumbers', !!this.options.linenumbers);

                // focus
                $('.source-editor-container').trigger('codemirror:focus');
            },

            setContent: function (value, format) {
                if (format) {
                    value = this.formatHTML(value);
                }

                $('.source-editor-container').trigger('codemirror:setcontent', value);
            },

            getContent: function () {
                return $('.source-editor-container').triggerHandler('codemirror:getcontent');
            },

            resize: function (w, h, init) {
                // adjust height to remove toolbar height
                h = h - $('.uk-navbar').outerHeight();

                $('.source-editor-container').css({
                    "width": w,
                    "height": h
                });
            },
            undo: function () {
                $('.source-editor-container').trigger('codemirror:undo');
                this.focus();
            },
            redo: function () {
                $('.source-editor-container').trigger('codemirror:redo');
                this.focus();
            },
            indent: function () { },
            getContainer: function () {
                return this.container || null;
            },
            format: function () {
                // get content
                var html = this.getContent();
                // format with cleanup
                html = this._format(html);
                // set content
                this.setContent(html);
            },

            setActive: function (state) {
                this.editor.isActive = !!state;
            },

            _setLoader: function () {
                $('<div class="loading"></div>').appendTo('body');
            },

            _removeLoader: function () {
                // remove loader
                $('div.loading', 'body').remove();
            },

            /**
             * Create save stack
             */
            save: function () {
                var self = this;

                var src = tinyMCEPopup.getWindowArg('src'), content = this.getContent(), name = '', ext = tinyMCEPopup.getWindowArg('extension', 'txt');

                // get name and extension from passed in file src
                if (src) {
                    name = Wf.String.basename(src), name = Wf.String.stripExt(name), ext = Wf.String.getExt(src);
                }

                self._setLoader();

                // get filebrowser options
                var options = FileBrowser.options;

                Wf.Modal.prompt(tinyMCEPopup.getLang('dlg.save_file', 'Save File'), function (name) {
                    // clean up name
                    name = Wf.String.safe(name, options.websafe_mode, options.websafe_spaces, options.websafe_textcase);

                    var saveResolve = tinyMCEPopup.getWindowArg('save');

                    ext = $('#dialog-prompt-select').val();

                    // override save function
                    if (typeof saveResolve === 'function') {

                        // eslint-disable-next-line dot-notation
                        saveResolve(name, content, ext).finally(function () {
                            self._removeLoader();
                        });

                        return;
                    }

                    // create file
                    var file = (name + '.' + ext) || Wf.String.basename(src);

                    Wf.JSON.request('saveTextFile', {
                        'json': [src, file],
                        'data': content
                    }, function (o) {
                        self.options.onsave.apply(self.options.scope || self, [src]);
                        self._removeLoader();
                    });

                }, {
                    text: tinyMCEPopup.getLang('dlg.name', 'Name'),
                    value: name,
                    options: 'extension',
                    open: function (e) {                    
                        $('.uk-modal-footer .uk-text', e.target).text(tinyMCEPopup.getLang('dlg.save', 'Save'));

                        $('#dialog-prompt-input').parent().append(function () {
                            // select list of extensions
                            if (Array.isArray(ext)) {
                                var select = $('<select class="uk-form-select uk-margin-small-left" id="dialog-prompt-select"></select>');

                                ext.forEach(function (val) {
                                    select.append('<option value="' + val + '">.' + val + '</option>');
                                });

                                return select;
                            } else if (typeof ext === 'string') {
                                return '<span class="uk-text-muted uk-margin-small-left">.' + ext + '</span>';
                            }
                        });
                    },
                    validate: function (value) {
                        if (!value) {
                            return false;
                        }

                        return Wf.String.safe(value, options.websafe_mode, options.websafe_spaces, options.websafe_textcase);
                    }
                });
            }
        };

        window.CodeEditor = CodeEditor;
    })(jQuery);

})();
