/**
 * @name		Top Fixed Wrapper Widget for Template Creator CK
 * @copyright	Copyright (C) 2016. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

(function($) {
	var TCK_TopFixedWrapper = function(container, options) {
		var defaults = {
			zIndex: '1000',				// position the fixed element
			offset: '',			// distance or element after what to make it float
			effect: '0',				// fade effect to apply when it becomes fixed
			resolution: '0'			// value in px to restrict the behavior for low resolution
		};

		var opts = $.extend(defaults, options);
		var els = $(container);
		var $window = $(window);
		// check the resolution to disable the floating
		var doFloating = true;

		els.each(function(options) {
			var el = $(this);
			el.inner = el.find('> .inner');
			floatElement(el);
			el.data('top', el.offset().top);
			el.data('istopfixed', false);
			el.data('isanimating', false);
			$window.bind('scroll load resize', function() { floatElement(el); });
		});

		function floatElement(el) {
			checkDofloating();
			var winY = $window.scrollTop();
			var offset = el.data('top');
			if (opts.offset) {
				if (isNumeric(opts.offset)) {
					offset = offset + parseInt(opts.offset);
				} else {
					offset = parseInt($(opts.offset).offset().top);
				}
			}

			if (winY > offset && !el.data('istopfixed') && !el.data('isanimating') && doFloating) {
				var modtmp = $('#'+el.attr('id')+'tmp');
				modtmp.remove();
				el.after('<div id="' + el.attr('id') + 'tmp"></div>');
				$('#'+el.attr('id')+'tmp').css('visibility', 'hidden').height(el.height());
				if (opts.effect == '1') el.css({opacity: '0'});
				el.css({position: 'fixed', zIndex: opts.zIndex, marginTop: '0px', top: '0px',  left: '0', right: '0'})
					.data('istopfixed', true)
					.addClass('istopfixed');
				addContainerClass(el);
				if (opts.effect == '1') el.animate({opacity: '1'}, 400);
			} else if (offset >= winY && el.data('istopfixed') || (!doFloating && $('#'+el.attr('id')+'tmp').length)) {
				var modtmp = $('#'+el.attr('id')+'tmp');
				if (opts.effect == '1' && opts.offset)  {
					el.data('istopfixed', false);
					el.data('isanimating', true);
					el.animate({opacity: '0'}, 400, function() { el.css({position: '', marginTop: '', opacity: '1'}).data('istopfixed', false).data('isanimating', false).removeClass('istopfixed');modtmp.remove();removeContainerClass(el); });
				} else {
					removeContainerClass(el)
					el.css({position: '', marginTop: ''}).data('istopfixed', false).removeClass('istopfixed');
					modtmp.remove();
				}
			}
		}

		function addContainerClass(el) {
			var parentWrapper = $(el.parents('.tck-wrapper')[0]);
			if ( (parentWrapper.find('> .inner').hasClass('tck-container-fluid')
					|| parentWrapper.find('> .inner').hasClass('tck-container'))
				&& el.inner.length && el[0].tagName.toLowerCase() == 'section' && !el.inner.hasClass('tck-container-fluid') && !el.inner.hasClass('tck-container')) {
				el.inner.addClass('tck-container-fluid').attr('data-topfixedinfos','row');
				el.inner.attr('data-topfixedinfos','row');
			} else {
				el.inner.attr('data-topfixedinfos','wrapper');
			}
		}

		function removeContainerClass(el) {
			if (el.inner.length && el.inner.attr('data-topfixedinfos') == 'row') el.inner.removeClass('tck-container-fluid');
		}

		function checkDofloating() {
			if ($window.width() <= opts.resolution) {
				doFloating = false;
			} else {
				doFloating = true;
			}
		}

		function isNumeric(n) {
			return !isNaN(parseFloat(n)) && isFinite(n);
		}
	};
	window.TCK_TopFixedWrapper = TCK_TopFixedWrapper;
})(jQuery);