/**
 * @name		Template Creator CK 3
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

function TCK_WidgetTopfixedwrapperEnable() {
	$ck('.widgetrow[data-name="topfixedwrapper"]').attr('data-enabled', '1');
	$ck('#widgetsElements .widget[data-name="topfixedwrapper"]').attr('data-enabled', '1');
	$ck('.widgetrow[data-name="topfixedwrapper"] .widgetedit').trigger('click');
}

function TCK_WidgetTopfixedwrapperDisable() {
	$ck('.widgetrow[data-name="topfixedwrapper"]').attr('data-enabled', '0');
	$ck('#widgetsElements .widget[data-name="topfixedwrapper"]').attr('data-enabled', '0');
}

function TCK_WidgetTopfixedwrapperEdit(btn) {
	$ck('#widgetedition').empty();
	ckAfterWidgetEditionDisplay(); // needed for system actions, to add the back button

	var blocsList = new Array();
	$ck('#body > .wrapper, #body .ckrow').each(function() {
		var bloc = new Object();
		bloc['id'] = this.id;
		bloc['enabled'] = $ck(this).attr('data-class') && $ck(this).attr('data-class').indexOf('topfixedwrapper') !== -1 ? '1' : '0';
		var dataTarget = $ck('#widgetsElements').find('[data-name="topfixedwrapper"] [data-id="' + this.id + '"]');
		bloc['offset'] = dataTarget.attr('data-offset') ? dataTarget.attr('data-offset') : '';
		bloc['effect'] = dataTarget.attr('data-effect') ? dataTarget.attr('data-effect') : 'none';
		bloc['resolution'] = dataTarget.attr('data-resolution') ? dataTarget.attr('data-resolution') : '';
		blocsList.push(bloc);
	});

	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=ajaxCallWidgetAction&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			name: 'topfixedwrapper',
			func: 'listWrapperOptions',
			blocsList: JSON.stringify(blocsList)
		}
	}).done(function(code) {
		$ck('#widgetedition').append(code);
		ckInitModalPopup();
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
	});
}

function TCK_WidgetTopfixedwrapperToggle(btn) {
	var rowData = TCK_GetRowDataFromBtn(btn);
	var id = rowData.attr('data-id');
	$ck(btn).toggleClass('active ckbutton-info');
	$ck('#widgetedition .ckselecttopfixedwrapper').not(btn).removeClass('active ckbutton-info');
	// unset the top fixed wrapper on all wrapper
	$ck('#body > .wrapper, #body .ckrow').each(function() {
		if ($ck(this).attr('data-class')) {
			dataClass = $ck(this).attr('data-class').replace('topfixedwrapper', '').trim();
		} else {
			dataClass = '';
		}
		$ck(this).attr('data-class', dataClass).removeAttr('data-topfixedwrapper');
	});

	// set the top fixed wrapper on the selected wrapper only
	if ($ck(btn).hasClass('active')) {
		if ($ck('#' + id).attr('data-class')) {
			dataClass = $ck('#' + id).attr('data-class') + ' topfixedwrapper';
		} else {
			dataClass = 'topfixedwrapper';
		}
		$ck('#' + id).attr('data-class', dataClass).attr('data-topfixedwrapper', '1');
		$ck('#widgetsElements').find('[data-name="topfixedwrapper"] .widgetdata').empty();
		TCK_WidgetTopfixedwrapperSetOptions(btn);
	} else {
		$ck('#widgetsElements').find('[data-name="topfixedwrapper"] [data-id="' + rowData.attr('data-id') + '"]').remove();
	}
}

function TCK_GetRowDataFromBtn(btn) {
	var rowData = $ck($ck(btn).parents('.datarow')[0]);
	return rowData;
}

function TCK_WidgetTopfixedwrapperSetOptions(btn) {
	var rowData = TCK_GetRowDataFromBtn(btn);
	if (! rowData.find('.ckselecttopfixedwrapper.active').length) return;
	var blocid = rowData.attr('data-id');
	var bloc = $ck('#' + blocid);
	var dataTarget = $ck('#widgetsElements').find('[data-name="topfixedwrapper"] .widgetdata [data-id="' + rowData.attr('data-id') + '"]');
	if (! dataTarget.length) {
		$ck('#widgetsElements').find('[data-name="topfixedwrapper"] .widgetdata').append('<div data-id="' + rowData.attr('data-id') + '"></div>');
		dataTarget = $ck('#widgetsElements').find('[data-name="topfixedwrapper"] [data-id="' + rowData.attr('data-id') + '"]');
	}
	dataTarget.attr('data-offset', rowData.find('.offset').val());
//	if(! rowData.find('.offset').val()) rowData.find('.offset').val('5');
	dataTarget.attr('data-effect', rowData.find('.effect').val());
	dataTarget.attr('data-resolution', rowData.find('.resolution').val());

	ckSaveEdition(blocid);
}
