<?php
/**
 * @name		Template Creator CK 3
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined('_JEXEC') or die;

class TCK_WidgetScrollto {

	private $name = 'scrollto';

	private $pluginName = 'scrolltock';

	public $pluginUrl = 'https://www.joomlack.fr/index.php?option=com_dms&task=doc_download&id=138&updater=true';

	public $pluginPage = 'https://www.joomlack.fr/en/joomla-extensions/scroll-to-ck';

	public function loadWidget() {
		?>
		<script src="<?php echo \Templatecreatorck\CKUri::root(true) ?>/administrator/components/com_templateck/widgets/<?php echo $this->name ?>/interface.js" type="text/javascript"></script>
		<?php
	}
	

	public function renderFrontendWidget($templatepath, $templatename) {
		return;
	}

	public function onAfterInstall() {
		if (TEMPLATECREATORCK_PLATFORM == 'joomla') {
			require_once(JPATH_ROOT . '/administrator/components/com_templateck/helpers/ckinstaller.php');
			$installer = new CKInstaller();
			$result = $installer->install($this->pluginUrl, $this->pluginName, 'plugin');

			return $result;
		}
	}

	public function enablePlugin() {
		if (TEMPLATECREATORCK_PLATFORM == 'joomla') {
			if (! $installed = $this->isInstalled()) {
				$installed = $this->onAfterInstall();
			}
			if ($installed) {
				return $this->updatePluginState('1');
			} else {
				return false;
			}
		} else {
			return '1';
		}
	}

	public function disablePlugin() {
		return $this->updatePluginState('0');
	}

	public function isInstalled() {
		if (TEMPLATECREATORCK_PLATFORM == 'joomla') {
			// auto enable the plugin
			$db = \Templatecreatorck\CKFof::getDbo();
			$db->setQuery("SELECT extension_id FROM #__extensions WHERE `element` = 'scrolltock' AND `type` = 'plugin'");
			return $db->loadResult();
		}
	}

	public function updatePluginState($state) {
		// auto enable the plugin
		$db = \Templatecreatorck\CKFof::getDbo();
		$db->setQuery("UPDATE #__extensions SET enabled = '" . $state . "' WHERE `element` = 'scrolltock' AND `type` = 'plugin'");
		return $db->execute();
	}
}
