<?php
/**
 * @name		Template Creator CK 3
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined('TCK_LOADED') or die;

class TCK_WidgetParallaxbackground {

	private $name = 'topfiwedwrapper';

	public function loadWidget() {
		?>
		<script src="<?php echo TEMPLATECREATORCK_MEDIA_URL ?>/widgets/parallaxbackground/interface.js" type="text/javascript"></script>
		<?php
	}
	

	public function renderFrontendWidget($templatepath, $templatename, $data) {
		require_once(TEMPLATECREATORCK_PATH . '/helpers/ckwidgets.php');
		TCK_Folder::create(TEMPLATECREATORCK_TEMPLATES_PATH . '/' . $templatename . '/js');
		TCK_File::copy(TEMPLATECREATORCK_PATH . '/widgets/parallaxbackground/parallaxbackground.js', TEMPLATECREATORCK_TEMPLATES_PATH . '/' . $templatename . '/js/parallaxbackground.js');
		$blocs = CKWidgets::parseWidgetData($data);
		if (empty($blocs)) return;

		$jsCalls = array();
		foreach ($blocs as $bloc) {
			$jsCalls[] = "new TCK_ParallaxBackground('#" . $bloc->{'data-id'} . "', {"
					. "speed : '" . $bloc->{'data-speed'} . "'"
					. "});";
		}
		$jsCalls = implode(' ', $jsCalls);
		$widget = array();
		$widget['php'] = '';
		$widget['script'] = '<script src="' . $templatepath . '/js/parallaxbackground.js" type="text/javascript" ></script>';
		$widget['scriptDeclaration'] = 'jQuery(document).ready(function(){ ' . $jsCalls . ' });';
		$widget['stylesheet'] = '';
		$widget['styleDeclaration'] = '.parallaxchild {'
	. 'bottom: 0;'
	. 'left: 0;'
	. 'position: absolute;'
	. 'right: 0;'
	. 'top: 0;'
	. 'z-index: -1;'
	. 'background-size: cover;'
	. 'background-position: 50% 0;'
	. 'background-repeat: no-repeat;'
	. 'box-sizing: border-box;'
	. '}';
		$widget['jquery'] = true;

		return $widget;
	}

	/*
	 * Needed function
	 */
	public function onAfterInstall() {
		
	}

	public function listBackgroundOptions() {
		$input = new TCK_Input();;
		$blocsList = $input->get('blocsList', '', 'string');
		$blocsList = json_decode(stripslashes($blocsList));

		$this->showInfos();
		$this->renderTopBar();
		foreach ($blocsList as $bloc) {
			$this->renderBlocOptions($bloc);
		}

		$this->renderCss();
//		echo $html;
		exit();
	}

	private function showInfos() {
		?>
		<p><?php echo TCK_Text::_('CK_WIDGET_PARALLAX_BACKGROUND_INFOS') ?></p>
		<?php
	}

	private function renderTopBar() {
		?>
		<div class="widgettopbar">
			<div class="widgettopbarfilter"><?php echo TCK_Text::_('CK_FILTER_BY') ?> : </div>
			<div class="ckbutton" data-type="wrapper" onclick="TCK_WidgetParallaxbackgroundFilterByType(this)"><?php echo TCK_Text::_('CK_WRAPPER') ?></div>
			<div class="ckbutton" data-type="row" onclick="TCK_WidgetParallaxbackgroundFilterByType(this)"><?php echo TCK_Text::_('CK_ROW') ?></div>
			<div class="ckbutton" data-type="flexiblemodules" onclick="TCK_WidgetParallaxbackgroundFilterByType(this)"><?php echo TCK_Text::_('CK_FLEXIBLES_MODULES') ?></div>
			<div class="ckbutton" data-type="singlemodule" onclick="TCK_WidgetParallaxbackgroundFilterByType(this)"><?php echo TCK_Text::_('CK_SINGLE_MODULE') ?></div>
			<div class="ckbutton" data-type="horiznav" onclick="TCK_WidgetParallaxbackgroundFilterByType(this)"><?php echo TCK_Text::_('CK_HORIZ_MENU') ?></div>
			<div class="ckbutton" data-type="all" onclick="TCK_WidgetParallaxbackgroundFilterByType(this)"><?php echo TCK_Text::_('CK_ALL') ?></div>
			<input id="widgettopbarfilter" class="inputbox" type="text" style="width: 150px;height:22px;" />
			<span class="fack fack-search ckbutton" style="height:18px;line-height:18px;" onclick="TCK_WidgetParallaxbackgroundFilterByType('search')">&nbsp;</span>
			<hr />
			<div>
				<span style="display:inline-block;width: 165px;font-weight: bold;"><?php echo TCK_Text::_('CK_BLOCK') ?></span>
				<span style="display:inline-block;width: 65px;font-weight: bold;"><?php echo TCK_Text::_('CK_STATE') ?></span>
				<span style="display:inline-block;width: 510px;font-weight: bold;"><?php echo TCK_Text::_('CK_BACKGROUND_IMAGE') ?></span>
				<span style="display:inline-block;width: 150px;font-weight: bold;"><?php echo TCK_Text::_('CK_EFFECTS') ?></span>
			</div>
			<p></p>
		</div>
		<?php
	}
	
	private function renderBlocOptions($bloc) {
		$prefix = $bloc->id;
		$stateClass = $bloc->enabled ? 'success' : 'danger';
		$stateText = $bloc->enabled ? 'ON' : 'OFF';
	?>
		<div class="datarow widgetrow" style="text-align:left;" data-type="<?php echo $bloc->class ?>" data-id="<?php echo $bloc->id ?>">
			<span style="display:inline-block;width: 150px;" class=""><?php echo $bloc->id ?></span>
			<span style="display:inline-block;width: 50px;" class="parallaxbackgroundtoggler ckbutton ckbutton-small ckbutton-<?php echo $stateClass ?>" onclick="TCK_WidgetParallaxbackgroundToggle(this)" data-state="<?php echo $bloc->enabled ?>"><?php echo $stateText ?></span>
			<span>
				<img src="<?php echo TEMPLATECREATORCK_MEDIA_URL ?>/images/image.png" style="margin: 4px 2px;" />
				<input style="width:300px;" class="inputbox" type="text" value="<?php echo $bloc->bgimageurl ?>" name="<?php echo $prefix; ?>backgroundimageurl" id="<?php echo $prefix; ?>backgroundimageurl" onchange="TCK_WidgetParallaxbackgroundSetOptions(this)"/>
				<a style="display:inline-block;padding:0 5px;width:85px;" class="ckbuttonstyle" href="javascript:void(0)" onclick="ckShowMediaManager('<?php echo $prefix; ?>backgroundimageurl')" ><?php echo TCK_Text::_('CK_SELECT'); ?></a>
				<a style="display:inline-block;padding:0 5px;width:45px;" class="ckbuttonstyle" href="javascript:void(0)" onclick="$ck('#<?php echo $prefix; ?>backgroundimageurl').attr('value', '');"><?php echo TCK_Text::_('CK_CLEAN'); ?></a>
				<?php /*<span><?php echo TCK_Text::_('CK_DIRECTION') ?></span>
				<select class="inputbox parallaxdirection" style="width:110px;" value="<?php echo $bloc->direction ?>" onchange="TCK_WidgetParallaxbackgroundSetOptions(this)">
					<option value="totop" <?php echo $this->isSelected($bloc->direction, 'totop') ?>><?php echo TCK_Text::_('CK_TO_TOP') ?></option>
					<option value="tobottom" <?php echo $this->isSelected($bloc->direction, 'tobottom') ?>><?php echo TCK_Text::_('CK_TO_BOTTOM') ?></option>
					<option value="toleft" <?php echo $this->isSelected($bloc->direction, 'toleft') ?>><?php echo TCK_Text::_('CK_TO_LEFT') ?></option>
					<option value="toright" <?php echo $this->isSelected($bloc->direction, 'toright') ?>><?php echo TCK_Text::_('CK_TO_RIGHT') ?></option>
				</select>
				 */ ?>
				<span><?php echo TCK_Text::_('CK_SPEED') ?></span>
				<input type="text" class="inputbox parallaxspeed" value="<?php echo $bloc->speed ?>" onchange="TCK_WidgetParallaxbackgroundSetOptions(this)" style="width: 20px;" />
			</span>
			<div class="clr"></div>
		</div>
	<?php
	}
	
	private function renderCss() {
		?>
		<style>
			.parallaxbackgroundtoggler + span {
				display: none;
			}

			.parallaxbackgroundtoggler.ckbutton-success + * {
				display: inline;
			}
		</style>
		<?php
	}

	private function isSelected($ref, $option) {
		if ($ref == $option) return ' selected="selected"';
		return '';
	}
}
