/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) 2018. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr - https://www.wp-pluginsck.com
 */

function TCK_WidgetMobilemenuEnable() {
//	if (! confirm('This will enable the plugin Mobile Menu CK, continue ?')) return;

	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=ajaxCallWidgetAction";
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			name: 'mobilemenu',
			func: 'enablePlugin'
		}
	}).done(function(code) {
		if (code == '1') {
			$ck('.widgetrow[data-name="mobilemenu"]').attr('data-enabled', '1');
			$ck('#widgetsElements .widget[data-name="mobilemenu"]').attr('data-enabled', '1');
			$ck('#body').find('.isControlResponsive[data-class="ckmobilemenu"]').show();
		} else {
			alert('A problem occured, the plugin can not be enabled.')
		}
	}).fail(function() {
		alert('Failed');
	});
}

function TCK_WidgetMobilemenuDisable() {
	// don't disable the plugin as it can be used somewhere else
	$ck('.widgetrow[data-name="mobilemenu"]').attr('data-enabled', '0');
	$ck('#widgetsElements .widget[data-name="mobilemenu"]').attr('data-enabled', '0');
	$ck('#body').find('.isControlResponsive[data-class="ckmobilemenu"]').hide();
}

function ckAfterWidgetDatamobilemenu(widget) {
	
}

function TCK_WidgetMobilemenuEdit(bloc) {
	var blocsList = new Array();
	$ck('#body .horiznav').each(function() {
		var dataTarget = $ck('#widgetsElements').find('[data-name="mobilemenu"] [data-id="' + this.id + '"]');
		var bloc = new Object();
		bloc['id'] = this.id;
		bloc['enabled'] = dataTarget.length ? '1' : '0';
		blocsList.push(bloc);
	});

	$ck('#widgetedition').empty();
	ckAfterWidgetEditionDisplay(); // needed for system actions, to add the back button

	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=ajaxCallWidgetAction&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			name: 'mobilemenu',
			func: 'listOptions',
			blocsList: JSON.stringify(blocsList)
		}
	}).done(function(code) {
		$ck('#widgetedition').append(code);
	}).fail(function() {
		alert('Failed');
	});
}

function TCK_WidgetMobilemenuToggle(btn, state) {
	var rowData = TCK_WidgetMobilemenugetRowDataFromBtn(btn);
	var blocid = rowData.attr('data-id');;
	$ck(btn).toggleClass('active ckbutton-info');

	if (state == '1') {
		$ck('#body #' + blocid).find('.isControlResponsive[data-class="ckmobilemenu"]').attr('data-enabled', '1');
		TCK_WidgetMobilemenuSetOptions(blocid);
	} else {
		$ck('#body #' + blocid).find('.isControlResponsive[data-class="ckmobilemenu"]').attr('data-enabled', '0');
//		$ck('#widgetsElements').find('[data-name="mobilemenu"] [data-id="' + rowData.attr('data-id') + '"]').remove();
	}
}

function TCK_WidgetMobilemenuSetOptions(blocid) {
	var dataTarget = $ck('#widgetsElements').find('[data-name="mobilemenu"] .widgetdata [data-id="' + blocid + '"]');
	if (! dataTarget.length) {
		$ck('#widgetsElements').find('[data-name="mobilemenu"] .widgetdata').append('<div data-id="' + blocid + '"></div>');
		dataTarget = $ck('#widgetsElements').find('[data-name="mobilemenu"] [data-id="' + blocid + '"]');
	}
	TCK_WidgetMobilemenuSavePopup();

	ckSaveEdition(blocid);
}

function TCK_WidgetMobilemenugetRowDataFromBtn(btn) {
	var rowData = $ck($ck(btn).parents('.datarow')[0]);
	return rowData;
}

function TCK_WidgetMobilemenuEditPluginOptions(bloc) {
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=ajaxCallWidgetAction&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			name: 'mobilemenu',
			func: 'listPluginOptions',
			blocid: bloc.attr('id')
		}
	}).done(function(code) {
		$ck('#ckedition').empty().append(code).fadeIn();
		TCK_WidgetMobilemenuSetPluginOptions();
	}).fail(function() {
		alert('Failed');
	});
}

function TCK_WidgetMobilemenuSavePopup() {
	if ($ck('.mobilemenufield').length) {
		var blocid = $ck('#mobilemenuck_id').val();
		var dataTarget = $ck('#widgetsElements').find('[data-name="mobilemenu"] .widgetdata [data-id="' + blocid + '"]');
		if (! dataTarget.length) {
			$ck('#widgetsElements').find('[data-name="mobilemenu"] .widgetdata').append('<div data-id="' + blocid + '"></div>');
			dataTarget = $ck('#widgetsElements').find('[data-name="mobilemenu"] [data-id="' + blocid + '"]');
		}
		$ck('.mobilemenufield').each(function() {
			dataTarget.attr('data-' + this.id, this.value);
		});
	}
}

function TCK_WidgetMobilemenuSetPluginOptions() {
		var blocid = $ck('#mobilemenuck_id').val();
		var dataTarget = $ck('#widgetsElements').find('[data-name="mobilemenu"] .widgetdata [data-id="' + blocid + '"]');
		// if no data set on the bloc, then nothing to apply
		if (! dataTarget.length) {
			return;
		}
		$ck('.mobilemenufield').each(function() {
			this.value = dataTarget.attr('data-' + this.id);
		});
		$ck('#mobilemenuck_stylename').val($ck('.mobilemenuck_style[data-id="' + $ck('#mobilemenuck_style').val() + '"]').attr('data-name'));
}

function TCK_WidgetMobilemenuToggleShowon(value, correct, fieldid) {
	var row = $ck($ck('#' + fieldid).parents('.ckoption')[0]);
	if (correct == value) {
		row.show();
	} else {
		row.hide();
	}
}

function ckMobilemenuSelectStyle(id, name, close) {
	if (!close && close != false) close = true;
	jQuery("#mobilemenuck_style").val(id);
	jQuery("#mobilemenuck_stylename").val(name);
	if (close) CKBox.close();
}

function ckMobilemenuUpdateStyle(nothing, id, name) {
	ckMobilemenuSelectStyle(id, name, false);
}