<?php
/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// no direct access
defined('TCK_LOADED') or die;

use Templatecreatorck\CKFof;
use Templatecreatorck\Helper;

// check the joomla! version
if (version_compare(JVERSION, '3.0.0') > 0) {
	$jversion = '3';
} else {
	$jversion = '2';
}

// Import CSS
CKFof::addStyleSheet('components/com_templateck/assets/admin.css');

$user = CKFof::getUser();
$userId = $user->get('id');

// for ordering
$listOrder = $this->state->get('filter_order', 'a.id');
$listDirn = $this->state->get('filter_order_Dir', 'ASC');
$filter_search = $this->state->get('filter_search', '');
$limitstart = $this->state->get('limitstart', 0);
$limit = $this->state->get('limit', 20);
?>
<form action="<?php echo \Joomla\CMS\Router\Route::_('index.php?option=com_templateck&view=templates'); ?>" method="post" name="adminForm" id="adminForm" class="<?php echo TEMPLATECREATORCK_ISJ3 ? 'ckadminarea' : '' ?>">
	<div id="filter-bar" class="btn-toolbar input-group">
		<div class="filter-search btn-group pull-left">
			<label for="filter_search" class="element-invisible"><?php echo TCK_Text::_('JSEARCH_FILTER_LABEL'); ?></label>
			<input type="text" name="filter_search" id="filter_search" placeholder="<?php echo TCK_Text::_('JSEARCH_FILTER'); ?>" value="<?php echo addslashes((string)$this->state->get('filter.search')); ?>" class="ckhastip form-control" title="" />
		</div>
		<div class="btn-group pull-left hidden-phone">
			<button type="submit" class="btn btn-primary ckhastip" title="<?php echo TCK_Text::_('JSEARCH_FILTER_SUBMIT'); ?>"><i class="icon-search"></i><?php echo ($jversion === '2' ? TCK_Text::_('JSEARCH_FILTER_SUBMIT') : ''); ?></button>
			<button type="button" class="btn btn-secondary ckhastip" title="<?php echo TCK_Text::_('JSEARCH_FILTER_CLEAR'); ?>" onclick="document.getElementById('filter_search').value = '';
					this.form.submit();"><i class="icon-remove"></i><?php echo ($jversion === '2' ? TCK_Text::_('JSEARCH_FILTER_CLEAR') : ''); ?></button>
		</div>
		&nbsp;
		<?php if ($jversion === '3') { ?>
			<div class="btn-group pull-right hidden-phone">
				<label for="limit" class="element-invisible"><?php echo TCK_Text::_('JFIELD_PLG_SEARCH_SEARCHLIMIT_DESC'); ?></label>
				<?php echo $this->pagination->getLimitBox(); ?>
			</div>
		<?php } ?>
	</div>
	&nbsp;
	<div class="clearfix"> </div>
	<table class="table table-striped" id="templateckList">
		<thead>
			<tr>
				<th width="1%">
					<input type="checkbox" name="checkall-toggle" title="<?php echo TCK_Text::_('JGLOBAL_CHECK_ALL'); ?>" value="" onclick="Joomla.checkAll(this)" />
				</th>

				<th class='left'>
					<?php //echo TCK_Text::_('COM_TEMPLATECK_TEMPLATES_NAME'); ?>
					<?php echo \Joomla\CMS\HTML\HTMLHelper::_('grid.sort', 'COM_TEMPLATECK_TEMPLATES_NAME', 'a.name', $listDirn, $listOrder); ?>
				</th>
				<?php if (isset($this->items[0]->state)) { ?>
				<?php } ?>
				<?php if (isset($this->items[0]->id)) {
					?>
					<th width="1%" class="nowrap">
						<?php //echo TCK_Text::_('JGRID_HEADING_ID'); ?>
						<?php echo \Joomla\CMS\HTML\HTMLHelper::_('grid.sort', 'JGRID_HEADING_ID', 'a.id', $listDirn, $listOrder); ?>
					</th>
				<?php } ?>
			</tr>
		</thead>
		<tfoot>
			<tr>
				<td colspan="10">
					<?php echo $this->pagination->getListFooter(); ?>
				</td>
			</tr>
		</tfoot>
		<tbody>
			<?php
			foreach ($this->items as $i => $item) :
				$canCreate = $user->authorise('core.create', 'com_templateck');
				$canEdit = $user->authorise('core.edit', 'com_templateck');
				$canCheckin = $user->authorise('core.manage', 'com_templateck');
				$canChange = $user->authorise('core.edit.state', 'com_templateck');
//				$link = 'index.php?option=com_templateck&view=template&task=template.edit&format=raw&id=' . $item->id; // old method with raw
				$link = 'index.php?option=com_templateck&view=template&task=template.edit&id=' . $item->id;
				?>
				<tr class="row<?php echo $i % 2; ?>">
					<td class="center" data-name="<?php echo $item->name; ?>">
						<?php echo \Joomla\CMS\HTML\HTMLHelper::_('grid.id', $i, $item->id); ?>
					</td>

					<td>
						<a href="<?php echo $link; ?>"><?php echo $item->name; ?></a>
					</td>

					<?php if (isset($this->items[0]->id)) {
						?>
						<td class="center">
							<?php echo (int) $item->id; ?>
						</td>
					<?php } ?>
				</tr>
			<?php endforeach; ?>
		</tbody>
	</table>

	<div>
		<input type="hidden" name="task" value="" />
		<input type="hidden" name="boxchecked" value="0" />
		<input type="hidden" name="filter_order" value="<?php echo $listOrder; ?>" />
		<input type="hidden" name="filter_order_Dir" value="<?php echo $listDirn; ?>" />
		<?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
	</div>
</form>
<div style="text-align:center;"><a href="https://extensions.joomla.org/extensions/extension/style-a-design/template-creator-ck" target="_blank" class="btn"><?php echo TCK_Text::_('COM_TEMPLATECK_VOTE_JED_BUTTON'); ?></a></div>
<div style="text-align:center;"><a href="https://www.joomlack.fr" target="_blank"><?php echo TCK_Text::_('COM_TEMPLATECK_OTHER_EXTENSIONS_LINK');  ?></a></div>

<?php // modal popup for import ?>
<div id="ckimportmodal" class="" style="position:relative;display:none;">
	<div style="padding: 10px;">
		<div class="ckimportmodalcontent">
			<h1><?php echo TCK_Text::_('CK_INSTALL_GABARIT'); ?></h1>
			<form id="importpage" method="post" enctype="multipart/form-data">
				<div>
					<fieldset>
						<table class="table table-striped">
							<tr>
								<td width="110" class="key">
									<label for="title">
										<?php echo TCK_Text::_('CK_CHOOSE_FILE_TCK'); ?>:
									</label>
								</td>
								<td>
									<input class="inputbox" type="file" name="file" id="file" size="60" />
									<input type="submit" name="submitfile" class="inputbox ckbutton" value="<?php echo TCK_Text::_('CK_INSTALL'); ?>" />
								</td>
							</tr>
						</table>
					</fieldset>
				</div>
				<?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
				<input type="hidden" name="task" value="template.import" />
			</form>
		</div>
	</div>
</div>
<?php // modal popup for export ?>
<div id="ckExportModal" class="" style="position:relative;display:none;">
	<div style="padding: 10px;">
		<div class="ckExportModalContent">
			<div class="" id="">
				<div class=""><h1><?php echo TCK_Text::_('CK_EXPORT'); ?></h1></div>
					<div id="ckExportPageDownload" style="border-top: 1px solid #ddd;padding: 0.75em;">

					</div>
			</div>
		</div>
	</div>
</div>
<form id="downloadexportpage" method="post" enctype="multipart/form-data" style="display: none;">
	<input type="text" name="filepath" id="filepath" />
	<input type="submit" name="submitfile" />
	<?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
	<input type="hidden" name="task" value="template.download" />
</form>
<script>
/* get the file and submit it for download */
function ckExportPage(form) {
	var cid = jQuery(form).find('input[name="cid[]"]:checked');
	if (cid.length) {
		var id = cid[0].value;
		ckDoExport(id);
	} else {
		alert('<?php echo TCK_Text::_('CK_PLEASE_SELECT_ITEM', true) ?>');
	}
}

/* export the file and load it in the page */
function ckDoExport(id) {
	jQuery('#ckExportPageDownload').addClass('ckwait');
	var name = jQuery(jQuery('input[name="cid[]"]:checked')[0]).parent().attr('data-name');
	CKBox.open({handler: 'inline', content: 'ckExportModal', fullscreen: false, size: {x: '600px', y: '150px'}})
	var myurl = "<?php echo TEMPLATECREATORCK_ADMIN_URL ?>&task=template.export";
	jQuery.ajax({
		type: "POST",
		url: myurl,
		data: {
			id: id,
			name: jQuery(jQuery('input[name="cid[]"]:checked')[0]).parent().attr('data-name')
		}
	}).done(function(code) {
		jQuery('#ckExportPageDownload').removeClass('ckwait').html(code);
		var form = document.getElementById('downloadexportpage');
		form.filepath.value = '/export/' + name + '_gabarit.tck3z';
		form.submit();
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
	});
}
</script>
<?php
