<?php

/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access
defined('TCK_LOADED') or die;

use Templatecreatorck\CKView;
use Templatecreatorck\CKFof;
use Templatecreatorck\Helper;

/**
 * View to edit
 */
class TemplateckViewTemplate extends CKView {

	protected $items;

	protected $pagination;

	protected $state;

	protected $item;

	protected $isTemplateInstalled;

	protected $imagespath;

	protected $interface ;

	/**
	 * Display the view
	 */
	public function display($tpl = 'edit') {

		$authorised = CKFof::userCan('core.edit.own');

		if ($authorised !== true)
		{
			throw new Exception(TCK_Text::_('JERROR_ALERTNOAUTHOR'), 403);
			return false;
		}

		$this->item = $this->get('Item');
		$this->isTemplateInstalled = $this->_checkIfTemplateInstalled($this->item->name);
		$this->imagespath = TEMPLATECREATORCK_MEDIA_URI . '/images/menustyles/';
		$this->interface = new CKInterface();

		parent::display($tpl);
		exit();
	}

	/**
	 * private function to load the fonts in the page
	 */
	function _callfonts() {
		$fontstyles = '';
		$fontsheets = '';
		$query = "SELECT *
		FROM #__templateck_fonts
		  ";
		$rows = CKFof::dbLoadObjectList($query);
		if (!$rows)
			return false;
		foreach ($rows as $row) {
			if (stristr($row->styles, '@import')) 
			{
				$fontsheets .= str_replace(");", "' rel='stylesheet' type='text/css'>", str_replace("@import url(", "<link href='", $row->styles));
			} else {
				$fontstyles .= str_replace("url('", "url('" . \Templatecreatorck\CKUri::base(true) . "/components/com_templateck/fonts/" . $row->name . "/", $row->styles);
			}
		}
		if ($fontstyles)
			echo "<style type=\"text/css\">" . $fontstyles . "</style>";
		if ($fontsheets)
			echo $fontsheets;
	}

	/**
	 * private function to check if the current template is installed
	 */
	function _checkIfTemplateInstalled($name) {
		$query = "SELECT * FROM #__extensions 
			WHERE type = 'template'
			AND element = '" . $name . "'
			AND enabled = '1'
		";
		$result = CKFof::dbLoadResult($query);

		if (! $result) {
			return false;
		} else {
			return true;
		}

		return false;
	}
}