<?php
/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
defined('TCK_LOADED') or die;
?>
<nav id="context-menu-ck" class="context-menu-ck">
	<ul class="context-menu-ck__items">
		<li class="context-menu-ck__item context-menu-ck_wrapper parent" data-target="wrapper">
			<a href="#" class="context-menu-ck__link" data-action="parentItem"><i class="fack fack-ellipsis-h"></i> <?php echo TCK_Text::_('CK_WRAPPER') ?></a>
			<ul class="context-menu-ck__items">
				<li class="context-menu-ck__item">
					<a href="#" class="context-menu-ck__link" data-action="wrapper.edit"><i class="fack fack-pencil-square-o"></i> <?php echo TCK_Text::_('CK_EDIT_STYLES') ?></a>
					<a href="#" class="context-menu-ck__link context-menu-ck__item-styles-copy" data-action="wrapper.stylecopy"><i class="fack fack-copy"></i> </a>
					<a href="#" class="context-menu-ck__link context-menu-ck__item-styles-paste" data-action="wrapper.stylepaste"><i class="fack fack-paste"></i> </a>
				</li>
				<li class="context-menu-ck__item">
					<a href="#" class="context-menu-ck__link" data-action="wrapper.duplicate"><i class="fack fack-clone"></i> <?php echo TCK_Text::_('CK_DUPLICATE') ?></a>
				</li>
				<li class="context-menu-ck__item">
					<a href="#" class="context-menu-ck__link" data-action="wrapper.favorite"><i class="fack fack-magic"></i> <?php echo TCK_Text::_('CK_DESIGN_SUGGESTIONS') ?></a>
				</li>
				<li class="context-menu-ck__item">
					<a href="#" class="context-menu-ck__link" data-action="wrapper.fullwidth"><i class="fack fack-expand"></i> <?php echo TCK_Text::_('CK_FULLWIDTH') ?></a>
				</li>
				<li class="context-menu-ck__item">
					<a href="#" class="context-menu-ck__link" data-action="wrapper.remove"><i class="fack fack-times"></i> <?php echo TCK_Text::_('CK_REMOVE') ?></a>
				</li>
			</ul>
		</li>
		<li class="context-menu-ck__item context-menu-ck_row parent" data-target="row">
			<a href="#" class="context-menu-ck__link" data-action="parentItem"><i class="fack fack-ellipsis-h"></i> <?php echo TCK_Text::_('CK_ROW') ?></a>
			<ul class="context-menu-ck__items">
				<li class="context-menu-ck__item">
					<a href="#" class="context-menu-ck__link" data-action="row.edit"><i class="fack fack-pencil-square-o"></i> <?php echo TCK_Text::_('CK_EDIT_STYLES') ?></a>
					<a href="#" class="context-menu-ck__link context-menu-ck__item-styles-copy" data-action="row.stylecopy"><i class="fack fack-copy"></i> </a>
					<a href="#" class="context-menu-ck__link context-menu-ck__item-styles-paste" data-action="row.stylepaste"><i class="fack fack-paste"></i> </a>
				</li>
				<li class="context-menu-ck__item">
					<a href="#" class="context-menu-ck__link" data-action="row.columns"><i class="fack fack-align-justify"></i> <?php echo TCK_Text::_('CK_EDIT_COLUMNS') ?></a>
				</li>
				<li class="context-menu-ck__item">
					<a href="#" class="context-menu-ck__link" data-action="row.duplicate"><i class="fack fack-clone"></i> <?php echo TCK_Text::_('CK_DUPLICATE') ?></a>
				</li>
				<li class="context-menu-ck__item">
					<a href="#" class="context-menu-ck__link" data-action="row.favorite"><i class="fack fack-magic"></i> <?php echo TCK_Text::_('CK_DESIGN_SUGGESTIONS') ?></a>
				</li>
				<?php  /*<li class="context-menu-ck__item">
					<a href="#" class="context-menu-ck__link" data-action="row.save"><i class="fack fack-floppy-o"></i> <?php echo TCK_Text::_('CK_SAVE') ?></a>
				</li> */ ?>
				<li class="context-menu-ck__item">
					<a href="#" class="context-menu-ck__link" data-action="row.remove"><i class="fack fack-times"></i> <?php echo TCK_Text::_('CK_REMOVE') ?></a>
				</li>
			</ul>
		</li>
		<li class="context-menu-ck__item context-menu-ck_column parent" data-target="column">
			<a href="#" class="context-menu-ck__link" data-action="parentItem"><i class="fack fack-columns"></i> <?php echo TCK_Text::_('CK_COLUMN') ?></a>
			<ul class="context-menu-ck__items">
				<li class="context-menu-ck__item">
					<a href="#" class="context-menu-ck__link" data-action="column.edit"><i class="fack fack-pencil-square-o"></i> <?php echo TCK_Text::_('CK_EDIT_STYLES') ?></a>
					<a href="#" class="context-menu-ck__link context-menu-ck__item-styles-copy" data-action="column.stylecopy"><i class="fack fack-copy"></i> </a>
					<a href="#" class="context-menu-ck__link context-menu-ck__item-styles-paste" data-action="column.stylepaste"><i class="fack fack-paste"></i> </a>
				</li>
			</ul>
		</li>
		<li class="context-menu-ck__item context-menu-ck_item parent" data-target="item">
			<a href="#" class="context-menu-ck__link" data-action="parentItem"><i class="fack fack-window-maximize"></i> <?php echo TCK_Text::_('CK_ITEM') ?></a>
			<ul class="context-menu-ck__items">
				<li class="context-menu-ck__item">
					<a href="#" class="context-menu-ck__link" data-action="item.edit"><i class="fack fack-pencil-square-o"></i> <?php echo TCK_Text::_('CK_EDIT_STYLES') ?></a>
					<a href="#" class="context-menu-ck__link context-menu-ck__item-styles-copy" data-action="item.stylecopy"><i class="fack fack-copy"></i> </a>
					<a href="#" class="context-menu-ck__link context-menu-ck__item-styles-paste" data-action="item.stylepaste"><i class="fack fack-paste"></i> </a>
				</li>
				<li class="context-menu-ck__item">
					<a href="#" class="context-menu-ck__link" data-action="item.duplicate"><i class="fack fack-clone"></i> <?php echo TCK_Text::_('CK_DUPLICATE') ?></a>
				</li>
				<li class="context-menu-ck__item">
					<a href="#" class="context-menu-ck__link" data-action="item.favorite"><i class="fack fack-magic"></i> <?php echo TCK_Text::_('CK_DESIGN_SUGGESTIONS') ?></a>
				</li>
				<?php /*<li class="context-menu-ck__item">
					<a href="#" class="context-menu-ck__link" data-action="item.save"><i class="fack fack-floppy-o"></i> <?php echo TCK_Text::_('CK_SAVE') ?></a>
				</li>*/ ?>
				<li class="context-menu-ck__item">
					<a href="#" class="context-menu-ck__link" data-action="item.modules"><i class="fack fack-cogs"></i> <?php echo TCK_Text::_('CK_MODULES') ?></a>
				</li>
				<li class="context-menu-ck__item">
					<a href="#" class="context-menu-ck__link" data-action="item.remove"><i class="fack fack-times"></i> <?php echo TCK_Text::_('CK_REMOVE') ?></a>
				</li>
				<li class="context-menu-ck__item context-menu-ck_item parent" data-target="item">
					<a href="#" class="context-menu-ck__link" data-action="parentItem"><i class="fack fack-align-left"></i> <?php echo TCK_Text::_('CK_ALIGN') ?></a>
					<ul class="context-menu-ck__items">
						<li class="context-menu-ck__item">
							<a href="#" class="context-menu-ck__link" data-action="item.alignleft"><i class="fack fack-align-left"></i> <?php echo TCK_Text::_('CK_LEFT') ?></a>
						</li>
						<li class="context-menu-ck__item">
							<a href="#" class="context-menu-ck__link" data-action="item.aligncenter"><i class="fack fack-align-center"></i> <?php echo TCK_Text::_('CK_CENTER') ?></a>
						</li>
						<li class="context-menu-ck__item">
							<a href="#" class="context-menu-ck__link" data-action="item.alignright"><i class="fack fack-align-right"></i> <?php echo TCK_Text::_('CK_RIGHT') ?></a>
						</li>
						<li class="context-menu-ck__item">
							<a href="#" class="context-menu-ck__link" data-action="item.aligndefault"><i class="fack fack-align-justify"></i> <?php echo TCK_Text::_('CK_DEFAULT') ?></a>
						</li>
					</ul>
				</li>
			</ul>
		</li>
	</ul>
</nav>
<link rel="stylesheet" href="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/ckcontextmenu.css?ver=<?php echo TEMPLATECREATORCK_VERSION ?>" type="text/css" />
<script src="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/ckcontextmenu.js?ver=<?php echo TEMPLATECREATORCK_VERSION ?>" type="text/javascript"></script>