<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined('TCK_LOADED') or die;
include TEMPLATECREATORCK_PATH . '/views/icons/tmpl/fa5-icons-solid.php';
include TEMPLATECREATORCK_PATH . '/views/icons/tmpl/fa5-icons-regular.php';
include TEMPLATECREATORCK_PATH . '/views/icons/tmpl/fa5-icons-brands.php';
?>
<div class="ckinterface">
	<div id="search" class="filter-parent">
		<label for="filter-by"></label>
		<div style="position: relative; height: 46px; display: block;">
			<input type="text" tabindex="1" class="" id="filter-by" placeholder="<?php echo TCK_Text::_('CK_SEARCH_ICONS') ?>" style="height:auto;margin:0;background-color: transparent; position: relative;">
			<span class="ckbutton-group">
				<button class="ckbutton fa fa-search" id="filter-submit" onclick="searchiconsck()"></button>
				<button class="ckbutton fa fa-times" id="filter-clear" onclick="clearsearchiconsck()"></button>
			</span>
		</div>
	</div>
	<div>
		<h3><?php echo TCK_Text::_('CK_FILTER_BY_GROUP') ?></h3>
		<button class="ckbutton filter-category" id="filter-submit" onclick="filtericonsbycatck('solid')">Solid Icons</button>
		<button class="ckbutton filter-category" id="filter-submit" onclick="filtericonsbycatck('regular')">Regular Icons</button>
		<button class="ckbutton filter-category" id="filter-submit" onclick="filtericonsbycatck('brands')">Brands Icons</button>
	</div>

<script>
function searchiconsck() {
	jQuery('section').show();
	jQuery('i').parent().parent().hide();
	jQuery('i[class*=' + jQuery('#filter-by').val() + ']').parent().parent().show();
}

function clearsearchiconsck() {
	jQuery('section').show();
	jQuery('i').parent().parent().show();
	jQuery('#filter-by').val('');
}

function filtericonsbycatck (cat) {
	jQuery('i.fa').parent().parent().show();
	jQuery('section').hide();
	jQuery('section#' + cat).show();
	jQuery('#filter-by').val('');
}

jQuery(document).ready(function() {
	jQuery('.fa-hover a').click(function(e) {
		e.preventDefault();
		window.parent.ckSelectFaIcon(jQuery(this).find('i').attr('class'));
		window.parent.CKBox.close();
	});
});
</script>

<section id="solid">
	<h2 class="page-header">Solid Icons</h2>
	<div class="row fontawesome-icon-list">
	<?php 
	foreach ($fa5IconsSolid as $icon) {
		$name = str_replace('fas fa-', '', $icon);
		?>
		<div class="fa-hover col-md-3 col-sm-4"><a href="#"><i class="<?php echo $icon ?>" aria-hidden="true"></i> <span><?php echo $name ?></span></a></div>
		<?php
	}
	
	?>
	</div>
</section>

<section id="regular">
	<h2 class="page-header">Regular Icons</h2>
	<div class="row fontawesome-icon-list">
	<?php 
	foreach ($fa5IconsRegular as $icon) {
		$name = str_replace('far fa-', '', $icon);
		?>
		<div class="fa-hover col-md-3 col-sm-4"><a href="#"><i class="<?php echo $icon ?>" aria-hidden="true"></i> <span><?php echo $name ?></span></a></div>
		<?php
	}
	
	?>
	</div>
</section>

<section id="brands">
	<h2 class="page-header">Brands Icons</h2>
	<div class="row fontawesome-icon-list">
	<?php 
	foreach ($fa5IconsBrands as $icon) {
		$name = str_replace('fab fa-', '', $icon);
		?>
		<div class="fa-hover col-md-3 col-sm-4"><a href="#"><i class="<?php echo $icon ?>" aria-hidden="true"></i> <span><?php echo $name ?></span></a></div>
		<?php
	}
	
	?>
	</div>
</section>

</div>