<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined('TCK_LOADED') or die;

include_once TEMPLATECREATORCK_PATH . '/helpers/ckframework.php';
?>
<style>
body {
	color: #333;
	font-family: Helvetica;
	background: #fff;
}

.fontawesome-icon-list {
	display: flex;
	flex-wrap: wrap;
}

.fontawesome-icon-list a {
	color: #000;
}

div.fack-hover {
	float: left;
	height: 30px;
	margin: 10px;
	padding: 10px;
	width: 14%;
	text-align: center;
	font-size: 20px;
}

.fack-hover span {
	font-size: 12px;
}

div.fack-hover:hover a {
	transform: scale(2);
	background: #eee;
	z-index: 1;
	display: block;
	border-radius: 2px;
}

div.fack-hover a {
	text-decoration: none;
}

.sr-only {
	display: none;
}

.col-md-3.col-sm-4 {
	display: inline-block;
	padding: 20px;
	margin: 10px;
}
</style>
<script src="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/jquery.min.js" type="text/javascript"></script>
<script src="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/jquery-noconflict.js" type="text/javascript"></script>
<?php Templatecreatorck\CKFramework::loadFaIconsInline() ?>
<link rel="stylesheet" href="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/ckframework.css" type="text/css" />
<link rel="stylesheet" href="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/assets/templateck_template.css" type="text/css" />
<div id="maincktabcontent" class="ckinterface">
	<div class="mainmenulink menulink current" tab="tab_fontawesome"><h3><?php echo TCK_Text::_('CK_FONTAWESOME');if (TEMPLATECREATORCK_ISJ4 || TEMPLATECREATORCK_ISJ5) { echo ' v5'; } ?></h3></div>
	<div class="mainmenulink menulink" tab="tab_svgicons"><h3><?php echo TCK_Text::_('CK_SVG_ICONS'); ?></h3></div>

	<div class="clr"></div>

	<div class="maintab current" id="tab_fontawesome">
		<?php if (TEMPLATECREATORCK_ISJ4 || TEMPLATECREATORCK_ISJ5) {
			include TEMPLATECREATORCK_PATH . '/views/icons/tmpl/fontawesome5.php';
		} else {
			include TEMPLATECREATORCK_PATH . '/views/icons/tmpl/fontawesome4.php';
		}?>
	</div>
	<div class="maintab" id="tab_svgicons">
		<div id="svgicon-search">
			<label for="svgicon-filter-by"></label>
			<div style="position: relative; height: 46px; display: block;">
				<input type="text" tabindex="1" class="" id="svgicon-filter-by" placeholder="<?php echo TCK_Text::_('CK_SEARCH_ICONS') ?>" style="height:auto;margin:0;background-color: transparent; position: relative;">
				<span class="ckbutton-group">
					<button class="ckbutton fa fack-search" id="svgicon-filter-submit" onclick="ckSearchSvgIcon()"></button>
					<button class="ckbutton fa fack-times" id="svgicon-filter-clear" onclick="ckClearSearchSvgIcon()"></button>
				</span>
			</div>
		</div>

		<button class="ckbutton ckbuttonlink" data-target="ckheroiconsoutline" data-set="heroicons/outline"><?php echo TCK_Text::_('Heroicons - Outline'); ?></button>
		<button class="ckbutton ckbuttonlink" data-target="ckherosolidiconslist" data-set="heroicons/solid"><?php echo TCK_Text::_('Heroicons - Solid'); ?></button>
		<button class="ckbutton ckbuttonlink" data-target="cktablericonslist" data-set="tabler"><?php echo TCK_Text::_('Tabler icons'); ?></button>
		<button class="ckbutton ckbuttonlink" data-target="ckioniconsnormaliconslist" data-set="ionicons/normal"><?php echo TCK_Text::_('Ionicons icons - Normal'); ?></button>
		<button class="ckbutton ckbuttonlink" data-target="ckioniconsoutlineiconslist" data-set="ionicons/outline"><?php echo TCK_Text::_('Ionicons icons - Outline'); ?></button>
		<button class="ckbutton ckbuttonlink" data-target="ckioniconssharpiconslist" data-set="ionicons/sharp"><?php echo TCK_Text::_('Ionicons icons - Sharp'); ?></button>
		<button class="ckbutton ckbuttonlink" data-target="ckfontawesomebrandsiconslist" data-set="fontawesome/brands"><?php echo TCK_Text::_('Fontawesome icons - Brands'); ?></button>
		<button class="ckbutton ckbuttonlink" data-target="ckfontawesomeregulariconslist" data-set="fontawesome/regular"><?php echo TCK_Text::_('Fontawesome icons - Regular'); ?></button>
		<button class="ckbutton ckbuttonlink" data-target="ckfontawesomesolidiconslist" data-set="fontawesome/solid"><?php echo TCK_Text::_('Fontawesome icons - Solid'); ?></button>

		<div class="ckuttontab" data-tab="ckheroiconsoutline">
			<a href="https://heroicons.com" target="_blank">Heroicons website</a>
		</div>
		<div class="ckuttontab" data-tab="ckherosolidiconslist">
			<a href="https://heroicons.com" target="_blank">Heroicons website</a>
		</div>
		<div class="ckuttontab" data-tab="cktablericonslist">
			<a href="https://tablericons.com" target="_blank">Tabler icons website</a>
		</div>
		<div class="ckuttontab" data-tab="ckioniconsnormaliconslist">
			<a href="https://ionicons.com/" target="_blank">Ionicons website</a>
		</div>
		<div class="ckuttontab" data-tab="ckioniconsoutlineiconslist">
			<a href="https://ionicons.com/" target="_blank">Ionicons website</a>
		</div>
		<div class="ckuttontab" data-tab="ckioniconssharpiconslist">
			<a href="https://ionicons.com/" target="_blank">Ionicons website</a>
		</div>
		<div class="ckuttontab" data-tab="ckfontawesomebrandsiconslist">
			<a href="https://fontawesome.com/" target="_blank">Fontawesome website</a>
		</div>
		<div class="ckuttontab" data-tab="ckfontawesomeregulariconslist">
			<a href="https://fontawesome.com/" target="_blank">Fontawesome website</a>
		</div>
		<div class="ckuttontab" data-tab="ckfontawesomesolidiconslist">
			<a href="https://fontawesome.com/" target="_blank">Fontawesome website</a>
		</div>
	</div>
</div>
<script>
var $ck = window.$ck || jQuery.noConflict();

$ck('#maincktabcontent div.maintab:not(.current)').hide();
$ck('.mainmenulink', $ck('#maincktabcontent')).each(function(i, tab) {
	$ck(tab).click(function() {
		if ($ck('#popup_favoriteck').length) {
			ckCloseFavoritePopup(true);
		}
		$ck('#maincktabcontent div.maintab').hide();
		$ck('.mainmenulink', $ck('#maincktabcontent')).removeClass('current');
		if ($ck('#' + $ck(tab).attr('tab')).length)
			$ck('#' + $ck(tab).attr('tab')).show();
		$ck(this).addClass('current');
	});
});

$ck('.ckbuttonlink').on('click', function() {
	var target = $ck(this).attr('data-target');
	$ck('.ckuttontab').hide();
	$ck('.ckbuttonlink').removeClass('active');
	var $tab = $ck('.ckuttontab[data-tab="' + target + '"]');
	$tab.show();
	$ck(this).addClass('active');
	if (! $ck('#' + target).length) {
		$tab.append('<div id="' + target + '" class="ckiconslist"></div>')
		ckgetIconsLibrary(target, $ck(this).attr('data-set'));
	}
});

function ckgetIconsLibrary(targetId, set) {
	var setVar = set.replace('/', '_');
	$ck('#' + targetId).addClass('ckwait');
	var debug = false;
	sessionStorage.setItem('icons_library_' + setVar,'');
	if (!debug && window.sessionStorage && sessionStorage.getItem('icons_library_' + setVar)) {
		var html = sessionStorage.getItem('icons_library_' + setVar);
		$ck('#' + targetId).empty().append(html);
		$ck('#' + targetId).removeClass('ckwait');
		ckAddEventOnIcons();
	} else {
		var url = 'https://media.joomlack.fr/api/icons/set/' + set;
		jQuery.ajax({
			url: url,
			dataType: 'jsonp',
			cache: true,
			jsonpCallback: "joomlack_jsonpcallback",
			timeout: 20000,
			success: function (response) {
				$ck('#' + targetId).removeClass('ckwait');
				var html = '';

				for (var i=0;i<response.length;i++) {
					var name = response[i];
					html += '<img class="ckiconfile" loading="lazy" title="' + name + '" data-set="' + set  + '" data-name="' + name + '" src="https://media.joomlack.fr/icons/' + set + '/' + name + '" />';
				}
				html = '<p class="ckiconslistnumber">' + i + ' icons found</p>' + html;
				$ck('#' + targetId).empty().append(html);
				ckAddEventOnIcons();
				sessionStorage.setItem('icons_library_' + setVar, html);
			},
			fail: function() {
				alert('Error : Unable to connect to the library. Please contact an administrator');
			},
			complete: function() {

			},
			error: function(request, status, error) {

			}
		});
	}
}

$ck('#svgicon-filter-by').keydown(function (e) {
	if (e.which == 13) {
		$ck("#svgicon-filter-submit").click();
	}
});

function ckSearchSvgIcon() {
	$ck('.ckiconfile').hide();
	$ck('.ckiconfile[data-name*=' + $ck('#svgicon-filter-by').val() + ']').show();
}

function ckClearSearchSvgIcon() {
	jQuery('.ckiconfile').show();
	jQuery('#svgicon-filter-by').val('');
}

function ckAddEventOnIcons() {
	$ck('.ckiconfile').on('click', function() {
		ckGetIconSvgCode($ck(this).attr('data-set') + '/' + $ck(this).attr('data-name'));
	});
}

function ckGetIconSvgCode(path) {
	var regEx = new RegExp('/', "ig");
	var setVar = path.replace(regEx, '_');
	var debug = true;
	if (debug === true) sessionStorage.setItem('icons_library_' + setVar,'');
	if (!debug && window.sessionStorage && sessionStorage.getItem('icons_library_' + setVar)) {
		var code = sessionStorage.getItem('icons_library_' + setVar);
		window.parent.ckSelectSvgIcon(response, setVar);
	} else {
		var url = 'https://media.joomlack.fr/api/icons/get/' + path;
		jQuery.ajax({
			url: url,
			dataType: 'jsonp',
			cache: true,
			jsonpCallback: "joomlack_jsonpcallback",
			timeout: 20000,
			success: function (response) {
				window.parent.ckSelectSvgIcon(response, setVar);

				sessionStorage.setItem('icons_library_' + setVar, response);
			},
			fail: function() {
				alert('Error : Unable to connect to the library. Please contact an administrator');
			},
			complete: function() {

			},
			error: function(request, status, error) {

			}
		});
	}
}
</script>
<style>
.ckiconslistnumber {
	flex: 1 1 100%;
}

.ckuttontab {
	display: none;
}

.ckiconslist {
	display: flex;
	flex-wrap: wrap;
}
.ckiconslist img {
	width: 30px;
	height: 30px;
	margin: 10px;
	padding: 10px;
	cursor: pointer;
}
.ckiconslist img:hover {
	transform: scale(1.5);
	background: #eee;
}
</style>
