<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');

\Joomla\CMS\HTML\HTMLHelper::_('behavior.formvalidation');
$document = \Templatecreatorck\CKFof::getDocument();
$document->addStyleSheet('components/com_templateck/assets/css/templateck.css');
$db = \Joomla\CMS\Factory::getDBO();
$q = "SHOW COLUMNS FROM #__templateck_fonts LIKE 'additional_fonts'";
$db->setQuery($q);
if ($db->execute()) {
	if ( $db->loadResult()) {
		$additional_fonts_exists = true;
	} else {
		$additional_fonts_exists = false;
	}
}
$additional_fonts_exists = false; // forcing to disable the option for now
?>
<script type="text/javascript">
	Joomla.submitbutton = function(task)
	{
		if (document.getElementById('fonturl').value == '' && task != 'font.cancel') {
			alert('<?php echo $this->escape(TCK_Text::_('CK_ENTER_FONT_VALUE')); ?>');
		} else {
			if (task == 'font.cancel' || document.formvalidator.isValid(document.id('adminForm'))) {
				Joomla.submitform(task, document.getElementById('adminForm'));
			}
			else {
				alert('<?php echo $this->escape(TCK_Text::_('JGLOBAL_VALIDATION_FORM_FAILED')); ?>');
			}
		}
	}
</script>
<form action="<?php echo \Joomla\CMS\Router\Route::_('index.php'); ?>" method="post" enctype="multipart/form-data" name="adminForm" id="adminForm" class="form-validate">
    <div>
        <fieldset class="adminform">
            <legend><?php echo TCK_Text::_('CK_INSTALL_FONT_GOOGLE'); ?></legend>
			
            <table class="admintable">
                <tr>
                    <td width="110" class="key">
                        <label for="title">
							<?php echo TCK_Text::_('CK_GOOGLEFONT_URL'); ?>:
                        </label>
                    </td>
                    <td>
                        <input class="inputbox" type="text" name="fonturl" id="fonturl" size="60" />
                        <span class="alert alert-info"><?php echo TCK_Text::_('CK_INSTALL_FONT_GOOGLE_INSTRUCTIONS'); ?></span>
                    </td>
                </tr>
				<?php if ($additional_fonts_exists) { ?>
				<tr>
                    <td width="110" class="key">
                        <label for="title">
							<?php echo TCK_Text::_('CK_ADDITONAL_FONTS'); ?>:
                        </label>
                    </td>
                    <td>
                        <input class="inputbox" type="text" name="additional_fonts" id="additional_fonts" size="60" />
						<span class="alert alert-info"><?php echo TCK_Text::_('CK_ADDITONAL_FONTS_INSTRUCTIONS'); ?></span>
                    </td>
                </tr>
				<?php } ?>
				<tr>
                    <td width="110" class="key">
                        <label for="title">

                        </label>
                    </td>
                    <td>
                        <input type="button" name="submitbutton" value="<?php echo TCK_Text::_('CK_INSTALL_FONT'); ?>" class="btn" style="margin-bottom:9px;" onclick="Joomla.submitbutton('font.importstylesfromgoogle')"/>
                    </td>
                </tr>
            </table>
        </fieldset>
    </div>

    <input type="hidden" name="option" value="com_templateck" />
    <input type="hidden" name="view" value="fonts" />
    <input type="hidden" name="task" value="font.importstylesfromgoogle" />
	<?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
</form>