<?php

/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access
defined('TCK_LOADED') or die;

use Templatecreatorck\CKView;
use Templatecreatorck\CKFof;
use Templatecreatorck\Helper;

/**
 * View to edit
 */
class TemplateckViewFont extends CKView {

	protected $items;

	protected $pagination;

	protected $state;

	/**
	 * Display the view
	 */
	public function display($tpl = null) {
		$authorised = CKFof::userCan('core.edit');

		if ($authorised !== true)
		{
			throw new Exception(TCK_Text::_('JERROR_ALERTNOAUTHOR'), 403);
			return false;
		}

		$this->item = $this->get('Item');

		$this->addToolbar();
		parent::display($tpl);
	}

	/**
	 * Add the page title and toolbar.
	 */
	protected function addToolbar() {
		$this->input->set('hidemainmenu', true);

		$user = \Joomla\CMS\Factory::getUser();
		$isNew = ($this->item->id == 0);
		if (isset($this->item->checked_out)) {
			$checkedOut = !($this->item->checked_out == 0 || $this->item->checked_out == $user->get('id'));
		} else {
			$checkedOut = false;
		}
		$canDo = TemplateckHelper::getActions();

		\Joomla\CMS\Toolbar\ToolbarHelper::title(TCK_Text::_('COM_TEMPLATECK_TITLE_TEMPLATE'), 'template.png');
		if ($this->input->get('layout') == 'edit') {
			// If not checked out, can save the item.
			if (!$checkedOut && ($canDo->get('core.edit') || ($canDo->get('core.create')))) {

				\Joomla\CMS\Toolbar\ToolbarHelper::apply('font.apply', 'JTOOLBAR_APPLY');
				\Joomla\CMS\Toolbar\ToolbarHelper::save('font.save', 'JTOOLBAR_SAVE');
			}
		}
		if (empty($this->item->id)) {
			\Joomla\CMS\Toolbar\ToolbarHelper::cancel('font.cancel', 'JTOOLBAR_CANCEL');
		} else {
			\Joomla\CMS\Toolbar\ToolbarHelper::cancel('font.cancel', 'JTOOLBAR_CLOSE');
		}
	}

}
