<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined('TCK_LOADED') or die;
$imagespath = TEMPLATECREATORCK_MEDIA_URI . '/images/';
\Joomla\CMS\HTML\HTMLHelper::_('jquery.framework');
$doc = \Templatecreatorck\CKFof::getDocument();
$doc->addStylesheet(TEMPLATECREATORCK_MEDIA_URI . '/assets/ckbrowse.css');
$doc->addScript(TEMPLATECREATORCK_MEDIA_URI . '/assets/ckbrowse.js');
$input = \Templatecreatorck\CKFof::getApplication()->input;

$returnFunc = $input->get('func', 'ckSelectFile', 'cmd');
$returnField = $input->get('field', '', 'string');
$type = $input->get('type', 'image', 'string');
$folderPath = $this->input->get('folder', '', 'string') ? trim($this->input->get('folder', '', 'string'), '/') : 'images';

switch ($type) {
	case 'video' :
		$fileicon = 'file_video.png';
		break;
	case 'audio' :
		$fileicon = 'file_audio.png';
		break;
	case 'folder' :
	case 'image' :
	default :
		$fileicon = 'file_image.png';
		break;
}
?>

<div id="maincktabcontent">
	<div class="mainmenulink menulink current" tab="tab_files"><h3><?php echo \Templatecreatorck\CKText::_('CK_FILES'); ?></h3></div>
	<div class="mainmenulink menulink" tab="tab_pixabay"><h3><?php echo \Templatecreatorck\CKText::_('Pixabay'); ?></h3></div>
	<div class="clr"></div>

	<div class="maintab current" id="tab_files">

<?php /* --- Start image browser ---*/ ?>

<div id="ckbrowse" class="clearfix">
<div id="ckfolderupload">
	<div class="inner">
		<div class="upload">
			<h2 class="uploadinstructions"><?php echo TCK_Text::_('CK_DROP_FILES_TO_UPLOAD'); ?></h2>
				<p><?php echo TCK_Text::_('CK_OR_SELECT_FILES'); ?></p><input id="tck_file_upload" type="file" name="Filedata[]" multiple class="" />
		</div>
	</div>
</div>
<div id="ckfoldertreelist">
<p><?php echo TCK_Text::_('CK_BROWSE_INFOS') ?></p>
<?php
$lastitem = 0;
foreach ($this->items as $i => $folder) {
	$submenustyle = '';
	$folderclass = '';
	if ($folder->level == 1) {
		$submenustyle = 'display: block;';
		$folderclass = 'ckcurrent';
	}
			$pathway = str_replace('/', '</span><span class="ckfoldertreepath">', ($folder->basepath));
	?>
			<div class="ckfoldertree <?php echo $folderclass ?> <?php echo ($folder->deeper ? 'parent' : '') ?> <?php //echo (count($folder->files) ? 'hasfiles' : '') ?>" data-level="<?php echo $folder->level ?>" data-path="<?php echo TemplateckHelper::utf8_encode($folder->basepath) ?>">
			<?php if ($folder->level > 1) { ?><div class="ckfoldertreetoggler" onclick="ckBrowseToggleTreeSub(this)"></div><?php } ?>
				<div class="ckfoldertreename" onclick="ckLoadFiles(this, '<?php echo $type ?>', '<?php echo ($folder->basepath) ?>', '<?php echo $folder->name ?>')"><span class="icon-folder"></span><?php echo TemplateckHelper::utf8_encode($folder->name); ?>
					<?php /*<div class="ckfoldertreecount"><?php echo count($folder->files); ?></div> */ ?>
		</div>


	<?php
				if ($folder->deeper) {
			echo '<div class="cksubfolder" style="' . $submenustyle . '">';
				} elseif ($folder->shallower) {
			// The next item is shallower.
			echo '</div>'; // close ckfoldertree
			echo str_repeat('</div></div>', $folder->level_diff); // close cksubfolder + ckfoldertree
				} else {
			// The next item is on the same level.
			echo '</div>'; // close ckfoldertree
		}
}
?>
		</div>
		<div id="ckfoldertreelistfiles" class="ckfoldertreelist">
			<?php // place where the images will be loaded ?>
		</div>
	</div>
<?php /*--- End of images browser ---*/ ?>
</div>

	<div class="maintab" id="tab_pixabay">
		<?php
		include TEMPLATECREATORCK_PATH . '/views/pixabay/tmpl/default.php';
		?>
	</div>
</div>
<script>
var $ck = window.$ck || jQuery.noConflict();
var URIROOT = window.URIROOT || '<?php echo \Templatecreatorck\CKUri::root(true) ?>';
var cktoken = '<?php echo \Joomla\CMS\Session\Session::getFormToken() ?>';

function ckBrowseToggleTreeSub(btn) {
	var item = $ck(btn).parent();
	if (item.hasClass('ckopened')) {
		item.removeClass('ckopened');
	} else {
		item.addClass('ckopened')
		// item.find('> .cksubfolder, > .ckfoldertreefiles').css('opacity','0').animate({'opacity': '1'}, 300);
	}
}

function ckBrowseShowFiles(btn) {
	// show the image in place of divs
	var fakeImages = $ck(btn).find('~ .ckfoldertreefiles .ckfakeimage');
	if (fakeImages.length) {
		fakeImages.each(function() {
			$fakeImage = $ck(this);
			var source = $fakeImage.parent().attr('data-type') == 'image' ? $fakeImage.attr('data-src') : '<?php echo $imagespath . 'file_' ?>' + $fakeImage.parent().attr('data-type') + '.png';
			$fakeImage.after('<img src="' + source + '" title="' + $fakeImage.attr('title') + '" />');
			$fakeImage.parent().removeClass('ckwait');
			$fakeImage.remove();
		});
	}
	// set the current state on the folder
	var item = $ck(btn).parent();
	$ck('.ckcurrent').not(btn).removeClass('ckcurrent');
	if (item.hasClass('ckcurrent')) {
		item.removeClass('ckcurrent');
	} else {
		item.addClass('ckcurrent')
	}
}

function ckBrowseSelectFile(btn) {
	try {
		if (typeof(window.parent.<?php echo $returnFunc ?>) != 'undefined') {
			window.parent.<?php echo $returnFunc ?>($ck(btn).attr('data-path') + '/' + $ck(btn).attr('data-filename'), '<?php echo $returnField ?>');
			if (typeof(window.parent.CKBox) != 'undefined') window.parent.ckCloseMediaManager();
		} else {
			alert('ERROR : The function <?php echo $returnFunc ?> is missing in the parent window. Please contact the developer');
		}
	}
	catch(err) {
		alert('ERROR : ' + err.message + '. Please contact the developper.');
	}
}

function ckBrowseSelectFolder(path) {
	try {
		if (typeof(window.parent.<?php echo $returnFunc ?>) != 'undefined') {
			window.parent.<?php echo $returnFunc ?>(path, '<?php echo $returnField ?>');
			if (typeof(window.parent.CKBox) != 'undefined') window.parent.CKBox.close();
		} else {
			alert('ERROR : The function <?php echo $returnFunc ?> is missing in the parent window. Please contact the developer');
		}
	}
	catch(err) {
		alert('ERROR : ' + err.message + '. Please contact the developper.');
	}
}

// display the images in the root folder
//ckShowFiles($ck('.ckfoldertreename').first()[0]);
let folderPath = (window.sessionStorage && sessionStorage.getItem('templatecreatorck_browse_folder.' + TEMPLATECK.USERID)) ? sessionStorage.getItem('templatecreatorck_browse_folder.' + TEMPLATECK.USERID) : '<?php echo $folderPath ?>';
ckLoadFiles($ck('.ckfoldertreename').first()[0], '<?php echo $type ?>', folderPath, folderPath)

$ck('#maincktabcontent div.maintab:not(.current)').hide();
$ck('.mainmenulink', $ck('#maincktabcontent')).each(function(i, tab) {
	$ck(tab).click(function() {
		if ($ck('#popup_favoriteck').length) {
			ckCloseFavoritePopup(true);
		}
		$ck('#maincktabcontent div.maintab').hide();
		$ck('.mainmenulink', $ck('#maincktabcontent')).removeClass('current');
		if ($ck('#' + $ck(tab).attr('tab')).length)
			$ck('#' + $ck(tab).attr('tab')).show();
		$ck(this).addClass('current');
	});
});
</script>
