<?php

/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');

use Templatecreatorck\CKModel;
use Templatecreatorck\CKFof;

class TemplateckModelFont extends CKModel {

	protected $table = '#__templateck_fonts';

	/**
	 * path to the fonts foler
	 *
	 * @var string
	 */
	var $_path;

	/**
	 * Constructor that retrieves the name from the request
	 *
	 * @access	public
	 * @return	void
	 */
	function __construct() {
		parent::__construct();

		$this->_path = TEMPLATECREATORCK_PATH . '/fonts';
	}

	/**
	 * Method to get a single record.
	 *
	 * @param	integer	The id of the primary key.
	 *
	 * @return	mixed	Object on success, false on failure.
	 * @since	1.6
	 */
	public function getItem($id = null) {

		$id = $this->input->get('id', $id, 'int');
		$this->item = CKFof::dbLoad($this->table, $id);

		return $this->item;
	}

	/**
	 * Method to store a record
	 *
	 * @access	public
	 * @return	boolean	True on success
	 */
	function store($name, $styles, $fontfamilies) {

		$data['name'] = $name;
		$data['styles'] = $styles;
		$data['fontfamilies'] = $fontfamilies;
		$additional_fonts = \Templatecreatorck\CKFof::getApplication()->input->get('additional_fonts', '', 'string');
		$data['published'] = 1;

		// save the data in the table
		$id = CKFof::dbStore($this->table, $data);
		if (! $id) return false;

		return true;
	}

	/**
	 * Method to delete record(s)
	 *
	 * @access	public
	 * @return	boolean	True on success
	 */
	function delete($cids) {
		$destpath = $this->_path;

		if (count($cids)) {
			foreach ($cids as $cid) {
				$query = ' SELECT name '
						. ' FROM #__templateck_fonts WHERE id=' . $cid;

				// retrieves the data
				$fontname = CKFof::dbLoadResult($query);

				// delete the folder
				if ($fontname && TCK_Folder::exists($destpath . '/' . $fontname)) {
					if (!TCK_Folder::delete($destpath . '/' . $fontname)) {
						CKFof::enqueueMessage('CK_ERROR_DELETING_FONT_FOLDER', 'warning');
						return false;
					}
				}

				return parent::delete($cid);
			}
		}
		return true;
	}

	/**
	 * Method to install a font squirrel
	 *
	 * @access	public
	 * @return	true on success
	 */
	function installFontsquirrel() {
		$app = \Templatecreatorck\CKFof::getApplication();
		$fileInput = new TCK_Input($_FILES);
		$file = $fileInput->get('file', null, 'array');

		if (is_array($file)) {

			// include file and zip archive libraries
			jimport('joomla.filesystem.file');
			// require_once JPATH_LIBRARIES . '/' . 'joomla' . '/' . 'archive' . '/' . 'zip.php';
			require_once TEMPLATECREATORCK_PATH . '/helpers/zip.php';

			//Clean up filename to get rid of strange characters like spaces etc
//			$file = $this->input->files->get('file', '', 'array');
			$filename = TCK_File::makeSafe($file['name']);

			// declare some variables
			$destpath = $this->_path . '/' . TCK_File::stripExt($filename);

			// check if the theme already exists
			if (TCK_Folder::exists($destpath)) {
				$msg = TCK_Text::_('CK_INSTALL_FONT_ALREADY_EXISTS');
				CKFof::redirect("index.php?option=com_templateck&view=fonts&layout=install", $msg, 'error');
				return false;
			}

			//Set up the source and destination of the file
			$src = $file['tmp_name'];

			//First check if the file has the right extension, we need jpg only
			if (strtolower(TCK_File::getExt($filename)) != 'zip') {
				$msg = TCK_Text::_('CK_INSTALL_FONT_MUST_BE_ZIP');
				CKFof::redirect("index.php?option=com_templateck&view=fonts&layout=install", $msg, 'error');
				return false;
			}

			// extract the files
			$archiver = new CKArchiveZip();
			if (!$isSuccess = $archiver->extract($src, $destpath)) {
				$msg = TCK_Text::_('CK_INSTALL_FONT_EXTRACT_ERROR');
				CKFof::redirect("index.php?option=com_templateck&view=fonts&layout=install", $msg, 'error');
				return false;
			}

			// get the content of the file styles.css
			if (!$stylescontent = file_get_contents($destpath . '/stylesheet.css')) {
				// delete the folder
				if (!TCK_Folder::delete($destpath)) {
					$this->setError('CK_ERROR_DELETING_FONT');
					return false;
				}

				$msg = TCK_Text::_('CK_GET_STYLESCONTENT_FAILED');
				CKFof::redirect("index.php?option=com_templateck&view=fonts&layout=install", $msg, 'error');
				return false;
			}

			$regex = "#font-family: '(.*?)';#s"; // masque de recherche
			preg_match_all($regex, $stylescontent, $fontfamilies);
			foreach ($fontfamilies[1] as $fontfamily) {
				$stylescontent = str_replace($fontfamily, strtolower($fontfamily), $stylescontent);
			}

			// store in db
			$this->store(TCK_File::stripExt($filename), $stylescontent, strtolower(implode(",", $fontfamilies[1])));
		}
		return true;
	}

	/**
	 * Method to install a font google
	 *
	 * @access	public
	 * @return	true on success
	 */
	function installFontgoogle() {
		return; // Not used anymore
		/*$fonturl = \Templatecreatorck\CKFof::getApplication()->input->get('fonturl', '', 'string');

		$fontfamily = str_replace('https://fonts.googleapis.com/css?family=', '', $fonturl);
		$fontfamily = str_replace('https://fonts.googleapis.com/css?family=', '', $fontfamily);
		$fontfamily = str_replace('//fonts.googleapis.com/css?family=', '', $fontfamily);
		$fontname = str_replace('+', ' ', $fontfamily);
		$fontname = preg_replace('#(.*?):(.*)#s', '$1', $fontname);
//		$fontfamilies = $fontname;
		$stylescontent = "@import url(" . $fonturl . ");\n";

		return $this->store($fontname, $stylescontent, $fontname);*/
	}

}
