<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');

$templateid = $this->input->get('templateid', '', 'int'); 
$templatename = $this->input->get('templatename', '', 'string');
$layout = $this->input->get('customlayout', '', 'string');
$path = TEMPLATECREATORCK_TEMPLATES_PATH . '/' . $templatename;

if (! $templatename) {
	TemplateckHelper::renderNoNameMessage();
	return;
}

$customcss = '';
// test if a custom css exists
if (file_exists($path . '/css/' . $layout . '_custom.css')) {
	$customcss = file_get_contents($path . '/css/' . $layout . '_custom.css');
} else {
	// echo TCK_Text::_('CK_NO_CUSTOMCSS_FILE_FOUND');
}

?>
<script>
var editor_customcss = CodeMirror.fromTextArea(document.getElementById("customcss"), {
	mode: "css",
//	styleActiveLine: true,
	lineNumbers: true,
//	lineWrapping: true
});
setTimeout(function() {
	editor_customcss.refresh();
}, 100);

</script>
<div class="cktitle"><?php echo TCK_Text::_('CK_PAGECUSTOMCSS_INFOS'); ?></div>
<textarea id="customcss" cols="50" rows="20" style="color: #777;"><?php echo $customcss; ?></textarea>
