<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');

$position = $this->input->get('position', '', 'string');
$type = $this->input->get('type', '', 'string');
$blockid = $this->input->get('blockid', '', 'string');
// $module = str_replace('module-', '', $type);
// $module = 'mod_' . $module;

$db = \Templatecreatorck\CKFof::getDbo();
if ($type == 'mod_menu') {
	$and = $type ? " AND (module='" . $type . "' OR module='mod_maximenuck')" : "";
} else {
	$and = $type ? " AND module='" . $type . "'" : "";
}
switch ($type) {
	default;
		$title = '';
		break;
	case 'mod_menu';
		$title = TCK_Text::_('CK_MENU');
		break;
	case 'mod_slideshowck';
		$title = 'Slideshow CK';
		break;
}
$specialModules = '';
if ($and) {
	$q = "SELECT id, title, published FROM #__modules WHERE published IN (0, 1)" . $and . " AND position='" . $position . "' AND client_id=0 ORDER BY id DESC;";
	// request for specific modules
	try {
		$query = $db->getQuery(true);
		$db->setQuery($q);
		$specialModules = $db->loadObjectList();
	}	catch (Exception $e) {
		echo '<div class=alert><b>SQL ERROR FROM TEMPLATE CREATOR CK - LIST OF MODULES : </b>'. $e->getMessage().'</div>';
		exit;
	}
}

// request for all other modules
if ($and) {
	$and = str_replace('module=', 'module!=', $and);
}
$q = "SELECT id, title, published FROM #__modules WHERE published IN (0, 1)" . $and . " AND position='" . $position . "' AND client_id=0 ORDER BY id DESC;";
try {
	$query = $db->getQuery(true);
	$db->setQuery($q);
	$modules = $db->loadObjectList();
}	catch (Exception $e) {
	echo '<div class=alert><b>SQL ERROR FROM TEMPLATE CREATOR CK - LIST OF MODULES : </b>'. $e->getMessage().'</div>';
	exit;
}
?>
<div id="ckmoduleslist">
	<div class="cktitle"><?php echo TCK_Text::_('CK_MODULES_LIST') ?></div>
	<p><?php echo TCK_Text::sprintf('CK_MODULES_LIST_DESC', '<b>' . $position . '</b>') ?></p>
	<?php if ($specialModules) {
		?>
	<h3><?php echo $title ?></h3>
	<p><span class="ckbutton ckbutton-success" onclick="ckAddModule('<?php echo $type ?>', '<?php echo $position ?>', '<?php echo $blockid ?>')"><span class="fack fack-plus">&nbsp;</span> <?php echo TCK_Text::_('CK_CREATE_NEW') ?></span></p>
	<?php
		ckRenderTableModules($specialModules);
		?>
		<h3><?php echo TCK_Text::_('CK_OTHER_MODULES') ?></h3>
		<?php
	}
	?>
	
	<p><span class="ckbutton ckbutton-success" onclick="ckAddModule('', '<?php echo $position ?>', '<?php echo $blockid ?>')"><span class="fack fack-plus">&nbsp;</span> <?php echo TCK_Text::_('CK_CREATE_NEW') ?></span></p>
	<?php ckRenderTableModules($modules); ?>
</div>
<script>
	ckInitTooltip();
</script>
<?php
function ckRenderTableModules($modules) {
	?>
	<table style="width: 100%;vertical-align: middle;" class="cktable cktable-striped cktable-bordered cktable-hover">
		<tr>
			<td colspan="1" style="width: 50px;"><b><?php echo TCK_Text::_('ID') ?></b></td>
			<td colspan="1"><b><?php echo TCK_Text::_('CK_TITLE') ?></b></td>
			<td colspan="1" style="width: 100px;"><b><?php echo TCK_Text::_('CK_ACTION') ?></b></td>
			<td colspan="1" style="width: 50px;"><b><?php echo TCK_Text::_('CK_STATE') ?></b></td>
		</tr>
	<?php
	foreach ($modules as $module) {
		$publishCss = $module->published == '1' ? 'success' : 'danger';
		$publishIcon = $module->published == '1' ? 'check' : 'times';
		?>
		<tr>
			<td><span class="label"><?php echo $module->id ?></span></td>
			<td><?php echo $module->title ?></td>
			<td><div class="ckbutton" onclick="ckShowModuleOptions('<?php echo $module->id ?>', 0)"><span class="fack fack-cog">&nbsp;</span><?php echo TCK_Text::_('CK_EDIT') ?></div></td>
			<td><div class="ckhastip ckbutton ckbutton-small ckbutton-<?php echo $publishCss ?>" title="<?php echo TCK_Text::_('CK_TOGGLE_STATE') ?>" onclick="ckToggleModuleState(this, '<?php echo $module->id ?>')" data-state="<?php echo $module->published ?>" style="width:14px;height: 18px;"><span class="fack fack-<?php echo $publishIcon ?>"></span>&nbsp;</div></td>
		</tr>
	<?php
	}
	?>
	</table>
<?php
}
