<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');

use Joomla\Utilities\ArrayHelper;

$position= $this->input->get('blockposition', '', 'string');
$blockid = $this->input->get('blockid', '', 'string');

$query = "SELECT *,element AS module
		FROM #__extensions
		WHERE type='module'
		AND client_id = 0
		AND enabled= 1
		ORDER BY name";
try {
	$items = Templatecreatorck\CKFof::dbLoadObjectList($query);
} catch (Exception $e) {
	echo '<div class=alert><b>SQL ERROR FROM TEMPLATE CREATOR CK - SELECTION OF MODULES : </b>'. $e->getMessage().'</div>';
	exit;
}

$client = \Joomla\CMS\Application\ApplicationHelper::getClientInfo(0);
$lang	= \Templatecreatorck\CKFof::getLanguage();

// Loop through the results to add the XML metadata,
// and load language support.
foreach ($items as &$item) {
	$path = \Templatecreatorck\CKPath::clean($client->path.'/modules/'.$item->module.'/'.$item->module.'.xml');
	if (file_exists($path)) {
		$item->xml = simplexml_load_file($path);
	} else {
		$item->xml = null;
	}

		$lang->load($item->module.'.sys', $client->path, null, false, false)
	||	$lang->load($item->module.'.sys', $client->path.'/modules/'.$item->module, null, false, false)
	||	$lang->load($item->module.'.sys', $client->path, $lang->getDefault(), false, false)
	||	$lang->load($item->module.'.sys', $client->path.'/modules/'.$item->module, $lang->getDefault(), false, false);
	$item->name	= TCK_Text::_($item->name);

	if (isset($item->xml) && $text = trim($item->xml->description)) {
		$item->desc = TCK_Text::_($text);
	}
	else {
		$item->desc = TCK_Text::_('COM_MODULES_NODESCRIPTION');
	}
}
$items = ArrayHelper::sortObjects($items, 'name', 1, true, $lang->getLocale());
?>
<div id="ckmodulesselectlist">
<div class="cktitle"><?php echo TCK_Text::_('CK_MODULES_SELECT') ?></div>
<p><?php echo TCK_Text::sprintf('CK_MODULES_SELECT_DESC', '<b>' . $position . '</b>') ?></p>
<table style="width: 100%;vertical-align: middle;" class="cktable cktable-striped cktable-bordered cktable-hover">
	<tr>
		<td colspan="1"><b><?php echo TCK_Text::_('CK_TYPE') ?></b></td>
		<td colspan="1"><b><?php echo TCK_Text::_('CK_DESCRIPTION') ?></b></td>
		<td colspan="1"><b><?php echo TCK_Text::_('CK_ACTION') ?></b></td>
	</tr>
<?php
foreach ($items as $item) {
	// Prepare variables for the link.
	$link = 'javascript:void(0)';
	// $link	= 'index.php?option=com_modules&task=module.add&eid='. $item->extension_id;
	$name	= htmlspecialchars($item->name);
	$desc	= \Joomla\CMS\HTML\HTMLHelper::_('string.truncate', (htmlspecialchars($item->desc)), 200);
	$short_desc	= \Joomla\CMS\HTML\HTMLHelper::_('string.truncate', (htmlspecialchars($item->desc)), 90);
	?>
	<tr>
		<td><b><?php echo $name ?></b></td>
		<td><?php echo $desc ?></td>
		<td><div class="ckbutton ckbutton-success" onclick="ckAddModule('<?php echo $item->element ?>', '<?php echo $position ?>', '<?php echo $blockid ?>')"><span class="fack fack-plus">&nbsp;</span><?php echo TCK_Text::_('CK_CREATE') ?></div></td>
	</tr>
<?php
}
?>
</div>
<script>
	ckInitTooltip();
</script>
