<?php

/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');
//jimport('joomla.filesystem.file');
error_reporting(0); // to avoid problems with the ajax method

$templatename = $this->input->get('templatename', '', 'string');
$path = TEMPLATECREATORCK_PROJECTS_PATH . '/' . $templatename;

if (file_exists($path)) TCK_Folder::delete($path);

// Did you give us a valid directory?
if (!TCK_Folder::move(TEMPLATECREATORCK_TEMPLATES_PATH . '/' . $templatename, $path))
{
	$result = "false";
	$msg = TCK_Text::_('CK_UNABLE_COPY_TEMPLATE_FOLDER');
	$msgType = 'error';
}


$package = null;
$installType = 'folder';

// Remember the 'Install from Directory' path.
//$package = $this->_getPackageFromFolder();

// Get the path to the package to install.
$p_dir = $path;
$p_dir = \Templatecreatorck\CKPath::clean($p_dir);

// Did you give us a valid directory?
if (!is_dir($p_dir))
{
	$result = "false";
	$msg = TCK_Text::_('COM_INSTALLER_MSG_INSTALL_PLEASE_ENTER_A_PACKAGE_DIRECTORY');
	$msgType = 'error';
}

// Detect the package type
$type = \Joomla\CMS\Installer\InstallerHelper::detectType($p_dir);

// Did you give us a valid package?
if (!$type)
{	
	$result = "false";
	$msg = TCK_Text::_('COM_INSTALLER_MSG_INSTALL_PATH_DOES_NOT_HAVE_A_VALID_PACKAGE');
	$msgType = 'error';
}

$package['packagefile'] = null;
$package['extractdir'] = null;
$package['dir'] = $p_dir;
$package['type'] = $type;


// Was the package unpacked?
if (!$package || !$package['type'])
{
	$result = "false";
	$msg = TCK_Text::_('COM_INSTALLER_UNABLE_TO_FIND_INSTALL_PACKAGE');
	$msgType = 'error';
}

// Get an installer instance.
$installer = \Joomla\CMS\Installer\Installer::getInstance();

// Install the package.
if (!$installer->install($package['dir']))
{
	// There was an error installing the package.
	$msg = TCK_Text::_('CK_INSTALL_TEMPLATE_ERROR');
	$result = "false";
	$msgType = 'error';
}
else
{
	// Package installed sucessfully.
	$msg = TCK_Text::_('CK_INSTALL_TEMPLATE_SUCCESS');
	$result = "true";
	$msgType = 'message';
}

// Set some model state values.
//$app->enqueueMessage($msg, $msgType);
//echo $msg;

// Cleanup the install files.
if (!is_file($package['packagefile']))
{
	$config = \Joomla\CMS\Factory::getConfig();
	$package['packagefile'] = $config->get('tmp_path') . '/' . $package['packagefile'];
}

//\Joomla\CMS\Installer\InstallerHelper::cleanupInstall($package['packagefile'], $package['extractdir']);

echo '{"result": "' . $result . '", "message": "' . $msg . '", "type": "' . $msgType . '"}';