<?php
/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined('TCK_LOADED') or die;

class CKWidgets {

	private static $widgets;

	/*
	 * List the available widgets
	 */
	public static function getWidgets() {
		if (! empty(self::$widgets)) return self::$widgets;

		self::$widgets = Array();

		// Top fixed wrapper
		$widget = new stdClass();
		$widget->name = 'topfixedwrapper';
		self::loadWidgetLanguage($widget->name);
		$widget->title = TCK_Text::_('CK_WIDGET_TOP_FIXED_WRAPPER');
		$widget->description = TCK_Text::_('CK_WIDGET_TOP_FIXED_WRAPPER_DESC');
		$widget->url = 'https://www.template-creator.com/widgetsck/topfixedwrapper.zip';
		$widget->edition = true;
//		$widget->isUptodate = true;
		$widget->type = 'widget';
		self::$widgets[$widget->name] = $widget;

		// Scroll To
		if (TEMPLATECREATORCK_PLATFORM == 'joomla') {
			$widget = new stdClass();
			$widget->name = 'scrollto';
			self::loadWidgetLanguage($widget->name);
			$widget->title = TCK_Text::_('CK_WIDGET_SCROLL_TO');
			$widget->description = TCK_Text::_('CK_WIDGET_SCROLL_TO_DESC');
	//		$widget->url = 'https://www.joomlack.fr/index.php?option=com_dms&task=doc_download&id=138&updater=true';
			$widget->url = 'https://www.template-creator.com/widgetsck/scrollto.zip';
			$widget->edition = false;
	//		$widget->isUptodate = true;
			$widget->type = 'plugin';
			self::$widgets[$widget->name] = $widget;
		}

		// Parallax background
		$widget = new stdClass();
		$widget->name = 'parallaxbackground';
		self::loadWidgetLanguage($widget->name);
		$widget->title = TCK_Text::_('CK_WIDGET_PARALLAX_BACKGROUND');
		$widget->description = TCK_Text::_('CK_WIDGET_PARALLAX_BACKGROUND_DESC');
		$widget->url = 'https://www.template-creator.com/widgetsck/parallaxbackground.zip';
		$widget->edition = true;
//		$widget->isUptodate = true;
		$widget->type = 'widget';
		self::$widgets[$widget->name] = $widget;
		
		// Animations
		$widget = new stdClass();
		$widget->name = 'animations';
		self::loadWidgetLanguage($widget->name);
		$widget->title = TCK_Text::_('CK_WIDGET_ANIMATIONS');
		$widget->description = TCK_Text::_('CK_WIDGET_ANIMATIONS_DESC');
		$widget->url = 'https://www.template-creator.com/widgetsck/animations.zip';
		$widget->edition = true;
//		$widget->isUptodate = true;
		$widget->type = 'widget';
		self::$widgets[$widget->name] = $widget;

		// Mobile menu
//		$widget = new stdClass();
//		$widget->name = 'mobilemenu';
//		self::loadWidgetLanguage($widget->name);
//		$widget->title = TCK_Text::_('CK_WIDGET_MOBILEMENU');
//		$widget->description = TCK_Text::_('CK_WIDGET_MOBILEMENU_DESC');
//		$widget->url = 'https://www.template-creator.com/widgetsck/mobilemenu.zip';
//		$widget->edition = true;
//		$widget->type = 'plugin';
//		self::$widgets[$widget->name] = $widget;

		return self::$widgets;
	}

	public static function loadWidgetLanguage($name) {
		if (TEMPLATECREATORCK_PLATFORM == 'joomla') {
			// loads the language files from the frontend
			$lang	= \Templatecreatorck\CKFof::getLanguage();
			$lang->load('com_templateck_' . $name, JPATH_SITE . '/administrator/components/com_templateck/widgets/' . $name, $lang->getTag(), false);
		} else {
			// loads the language files from the frontend
			$lang = TCK_LoadLanguage::getInstance('template-creator-ck');
			$test = $lang->load($name, TEMPLATECREATORCK_PATH . '/widgets/' . $name . '/language/');
		}
	}

	/*
	 * Update some changing informations
	 */
	public static function loadWidgets() {
		self::getWidgets();
		foreach (self::$widgets as &$widget) {
			
			$widget->installed = CKWidgets::checkInstalled($widget->name);
			if ($widget->installed) {
				if (self::getInstance($widget->name) && !empty($widget->phpClass)) {
					$widget->phpClass->loadWidget();
				}
//				$widget->isUptodate = self::isUptodate($widget->name);
			} else {
				$widget->phpClass = null;
			}
		}
		return self::$widgets;
	}

	private static function getInstance($name) {
		if (empty(self::$widgets)) self::getWidgets();
		if (!empty(self::$widgets[$name]->phpClass)) {
			return self::$widgets[$name]->phpClass;
		}

		if (self::checkInstalled($name)) {
			include_once(TEMPLATECREATORCK_PATH . '/widgets/' . $name . '/' . $name . '.php');
			$widgetClassName = 'TCK_Widget' . ucfirst($name);
//			self::$widgets[$name]->phpClass = 'toto';
			self::$widgets[$name]->phpClass = new $widgetClassName();

			return self::$widgets[$name]->phpClass;
		} else {
			return false;
		}
	}

	public static function updateAvailable($name) {
		if (! $onlineTxt = @file_get_contents('https://www.template-creator.com/widgetsck/' . $name . '_readme.txt')) {
			return false;
		}
		$currentTxt = @file_get_contents(TEMPLATECREATORCK_PATH . '/widgets/' . $name . '/' . $name . '_readme.txt');
		$currentVersion = self::extractVersion($currentTxt);
		$latestVersion = self::extractVersion($onlineTxt);

		return version_compare($currentVersion, $latestVersion) < 0;
	}

	private static function extractVersion($file) {
		$lines = explode("\n", $file);
		foreach ($lines as $line) {
			if (stristr($line, 'version=')) {
				return trim(str_replace('version=', '', $line));
			}
		}
	}

	/*
	 * Check if the widget is installed
	 */
	/*public static function checkInstalled($widget) {
		$type = explode(',', $widget->type);
		switch ($type[0]) {
			case 'widget';
			default;
				return self::checkInstalledWidget($widget);
				break;
//			case 'plugin';
//				return self::checkInstalledPlugin($widget);
//				break;
		}
	}*/

	/*
	 * Check if the widget is installed
	 */
	public static function checkInstalled($name) {
		return (int) (
				file_exists(TEMPLATECREATORCK_PATH . '/widgets/' . $name . '/' . $name . '.php')
				&& file_exists(TEMPLATECREATORCK_PATH . '/widgets/' . $name . '/interface.js')
			);
	}
	
	/*
	 * Check if the plugin is installed
	 */
	public static function checkInstalledPlugin($widget) {
		// auto enable the plugin
		$db = \Templatecreatorck\CKFof::getDbo();
		$db->setQuery("SELECT enabled FROM #__extensions WHERE `element` = '" . $widget->name . "' AND `type` = 'plugin'");
		return (int) $db->loadResult();
	}

	public static function loadEdition($name) {
		$widgetClass = self::getInstance($name);
		$widgetClass->loadEdition();
	}

	public static function triggerOnAfterInstall($name) {
		$widgetClass = self::getInstance($name);
		return $widgetClass->onAfterInstall();
	}

	public static function parseWidgetData($data) {
		preg_match_all("#<div(.*)>(.*)<\/div>#U", $data, $matches);
		if (! count($matches[1])) return;
		$datas = array();
		foreach ($matches[1] as $e) {
			$data = new stdClass();
			$vars = explode(' data-', trim($e));
			foreach ($vars as $var) {
				$setting = explode('=', trim($var));
				$setting = str_replace('data-', '', $setting);
				
				$data->{'data-' . $setting[0]} = trim($setting[1], '"');
			}
			$datas[$data->{'data-id'}] = $data;
		}

		return $datas;
	}
}
