/**
 * @copyright	Copyright (C) 2019. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */


var $ck = jQuery.noConflict();
var iframe;

function ckInitFrontendInterface() {
	ckListBlocks();
}

function ckListBlocks() {
	var blocs = new Array();
	var level = 1;
	iframe.find('.tck-wrapper').each(function() {
		var bloc = new Object();
		bloc['id'] = this.id;
		bloc['level'] = level;
		bloc['children'] = ckFindBlocks($ck(this), level);
		blocs.push(bloc);
	});

	for (var i=0; i < blocs.length; i++) {
		ckAppendBlocksToInterface(blocs[i]);
	}
}

function ckAppendBlocksToInterface(bloc) {
	$ck('#ckleftpanel').append('<div data-id="' + bloc.id + '" class="ckblocitem" data-level="' + bloc.level + '" onclick="ckBeforeShowEdition(\'' + bloc.id + '\')">' + bloc.id + '</div>');
	for (var i=0; i < bloc.children.length; i++) {
		ckAppendBlocksToInterface(bloc.children[i]);
	}
	$ck('#ckleftpanel .ckblocitem').on('mouseover', function() {
		iframe.find('.ckfocusfront').removeClass('ckfocusfront');
		iframe.find('#' + $ck(this).attr('data-id')).addClass('ckfocus').addClass('ckfocusfront');
	});
}

function ckFindBlocks(parent, level) {
	var blocs = new Array();
	var selectors = '> .tck-row, > .tck-modules, > .flexiblecolumn,  > .flexiblemdule, > .tck-module, > .tck-logo, > .maincontent';
	var items = parent.hasClass('flexiblecolumn') ? parent.find(selectors) : parent.find('> .inner').find(selectors);
	items.each(function() {
		if (this.id) {
			var bloc = new Object();
			bloc['id'] = this.id;
			bloc['level'] = level;
			bloc['children'] = ckFindBlocks($ck(this), level + 1);
			blocs.push(bloc);
		}
	});

	return blocs;
}

function ckBeforeShowEdition(blocid) {
	$ck('.ckfocus').removeClass('ckfocus');
	iframe.find('.ckfocusfront').removeClass('ckfocusfront');
	iframe.find('#' + blocid).addClass('ckfocus').addClass('ckfocusfront');
	ckShowEdition(blocid);
}

function ckRenderCss(blocid, editionarea, focus, forpreviewarea, returnFunc) {
	ckAddSpinnerIcon($ck('.ckleftpanelheadericon.cksave'));
	editionarea = editionarea ? editionarea : $ck('#ckedition');
	focus = focus ? $ck(focus) : $ck('.ckfocus');
	forpreviewarea = forpreviewarea ? forpreviewarea : false; // TODO check if needed
	returnFunc = returnFunc ? returnFunc : '';
	blocid = blocid ? blocid : focus.attr('id');
	if (forpreviewarea) {
		blocid = focus.attr('id');
	}
	
	var fieldslist = new Array();
	fields = new Object();
	$ck('.inputbox', editionarea).each(function(i, el) {
		el = $ck(el);
		fields[el.attr('name')] = el.attr('value');
		if (el.attr('type') == 'radio') {
			if (el.attr('checked')) {
				fields[el.attr('id')] = 'checked';
			} else {
				fields[el.attr('id')] = '';
			}
		}
	});

	var styleswrapper = ckGetStylesWrapperForBlock(blocid);
	$ck('> .ckprops', styleswrapper).each(function(i, ckprops) {
		ckprops = $ck(ckprops);
		fieldslist = ckprops.attr('fieldslist') ? ckprops.attr('fieldslist').split(',') : Array();
		for (j=0;j<fieldslist.length;j++) {
			fieldname = fieldslist[j];
			if (typeof(fields[fieldname]) == 'null' || typeof(fields[fieldname]) == 'undefined') 
				fields[fieldname] = ckprops.attr(fieldname);
		}
	});
	fields = JSON.stringify(fields);
	customstyles = new Object();
	$ck('.menustylescustom').each(function() {
		$this = $ck(this);
		customstyles[$this.attr('data-prefix')] = $this.attr('data-rule');
	});
	customstyles = JSON.stringify(customstyles);
	ckSaveEdition(blocid, '', '', false, false, editionarea);
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxrendercss&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			templatename: $ck('#name').attr('value'),
			objclass: focus.attr('class'),
			ckobjid: blocid,
			action: 'preview',
			fields: fields,
			customstyles: customstyles
		}
	}).done(function(code) {
		if (! iframe.find('#ckstylescontainer').length) {
			iframe.find('body').append('<div id="ckstylescontainer" />')
		}
		if (forpreviewarea) $ck('> .ckstyle', $ck('#' + blocid)).empty().append(code);
//		var csscode = code.replace(/\|ID\|/g, '#'+blocid);
//		$ck('> .ckstyle', $ck('#' + blocid)).empty().append(csscode);
		ckSetStyleForBloc(blocid, code);
		iframe.find('#ckstylescontainer').empty().html($ck('#ckstylescontainer').html());
		if (CKBLOCCKSTYLESBACKUP != 'undefined') {
			CKBLOCCKSTYLESBACKUP = code;
		}
//		$ck('.ckstyle[data-id="' + blocid + '"]', $ck('#ckstylescontainer, #ckelementscontentfavorites #' + blocid)).empty().append(code);
		ckRemoveSpinnerIcon($ck('.ckleftpanelheadericon.cksave'));
		$ck('#ckparamsfake').empty();
		if (typeof(window[returnFunc]) == 'function') window[returnFunc]();
	}).fail(function() {
		alert(TCK.Text._('CK_FAILED', 'Failed'));
	});
}


/*-------------------------------------------------------------------*/

// function ckModuleEditFullScreen() {
	// $ck('.pagebuilderckfrontend').toggleClass('ckfrontendfullwidth');
// }

function ckInitTemplateFrontEdition() {
	$ck('.tck-edition').each(function() {
		var nbpbckmodules = $ck(this).find('.tck-module-container[data-type="mod_pagebuilderck"]').length;
		if (nbpbckmodules === 0) {
			$ck(this).addClass('tck-edition-empty');
			ckAddNewModuleButton($ck(this));
		}
	});
}

function ckAddNewModuleButton(bloc) {
	bloc.append('<div class="tck-more" onclick="ckAddNewPagebuilderModule(this)" title="' + Joomla.JText._('CK_ADD_NEW_MODULE', 'Add a new Page Builder CK module') + '">+</div>');
}

function ckAddNewPagebuilderModule(btn) {
	var container = $ck($ck(btn).parents('.tck-edition')[0]);
	var position = container.attr('data-position');
	var myurl = 'index.php?option=com_pagebuilderck&task=templateedition.createmodule&' + PAGEBUILDERCK_TOKEN + '=1';
	$ck.ajax({
	type: "POST",
	url: myurl,
	dataType: 'json',
	data: {
		position: position
		}
	}).done(function(result) {
		container.append('<div class="workspaceck pbck-module-edition" data-id="' + result.id + '"></div>');
		var module = container.find('[data-id="' + result.id + '"]');
		ckAddRow(false, module);
		initWorkspace(module);
		btn.remove();
		container.removeClass('tck-edition-empty');
	}).fail(function() {
		alert('A problem occured when trying to create the module. Please retry.');
	});
}

function ckTemplateEditionSave() {
	$ck('.pbck-module-edition').each(function() {
		var module = $ck(this);
		var moduleid = module.attr('data-id');
		var tmp = module.html();
		// var tmp = module.clone();
		ckCleanInterfaceBeforeSave(module);
		var modulehtml = module.html();
		initWorkspace(module);
		// module.html(tmp);

		var myurl = 'index.php?option=com_pagebuilderck&task=templateedition.savemodule&' + PAGEBUILDERCK_TOKEN + '=1';
		$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			html: modulehtml,
			id: moduleid
			}
		}).done(function(result) {
			
		}).fail(function() {
			alert('A problem occured when trying to save the module ID ' + moduleid + '. Please retry.');
			// $ck(currentbloc).remove();
		});
	});
}