-- MySQL Script generated by MySQL Workbench
-- Wed Oct  6 07:52:47 2021
-- Model: New Model    Version: 1.0
-- MySQL Workbench Forward Engineering

SET @OLD_UNIQUE_CHECKS=@@UNIQUE_CHECKS, UNIQUE_CHECKS=0;
SET @OLD_FOREIGN_KEY_CHECKS=@@FOREIGN_KEY_CHECKS, FOREIGN_KEY_CHECKS=0;
SET @OLD_SQL_MODE=@@SQL_MODE, SQL_MODE='';

-- -----------------------------------------------------
-- Schema osmap
-- -----------------------------------------------------

-- -----------------------------------------------------
-- Table `#__osmap_sitemaps`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `#__osmap_sitemaps` (
  `id` INT(11) UNSIGNED NOT NULL AUTO_INCREMENT,
  `name` VARCHAR(100) NULL DEFAULT NULL,
  `params` TEXT NULL DEFAULT NULL,
  `is_default` TINYINT(1) NOT NULL DEFAULT '0',
  `published` TINYINT(1) NOT NULL DEFAULT '1',
  `created_on` DATETIME NULL DEFAULT NULL,
  `links_count` INT(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`id`),
  INDEX `idx_default` (`is_default` ASC, `id` ASC))
ENGINE = INNODB
DEFAULT CHARACTER SET = utf8;


-- -----------------------------------------------------
-- Table `#__osmap_sitemap_menus`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `#__osmap_sitemap_menus` (
  `sitemap_id` INT(11) UNSIGNED NOT NULL,
  `menutype_id` INT(11) NOT NULL,
  `changefreq` ENUM('always', 'hourly', 'daily', 'weekly', 'monthly', 'yearly', 'never') NOT NULL DEFAULT 'weekly',
  `priority` FLOAT NOT NULL DEFAULT '0.5',
  `ordering` INT(11) NOT NULL DEFAULT '0',
  PRIMARY KEY (`sitemap_id`, `menutype_id`),
  INDEX `idx_menutype_id` (`menutype_id` ASC),
  INDEX `idx_sitemaps_id` (`sitemap_id` ASC))
ENGINE = INNODB
DEFAULT CHARACTER SET = utf8;


-- -----------------------------------------------------
-- Table `#__osmap_items_settings`
-- -----------------------------------------------------
CREATE TABLE IF NOT EXISTS `#__osmap_items_settings` (
  `sitemap_id` INT(11) UNSIGNED NOT NULL,
  `uid` VARCHAR(100) NOT NULL DEFAULT '',
  `settings_hash` CHAR(32) NOT NULL DEFAULT '',
  `published` TINYINT(1) UNSIGNED NOT NULL DEFAULT '1',
  `changefreq` ENUM('always', 'hourly', 'daily', 'weekly', 'monthly', 'yearly', 'never') NOT NULL DEFAULT 'weekly',
  `priority` FLOAT NOT NULL DEFAULT '0.5',
  `format` TINYINT(1) UNSIGNED NULL DEFAULT '2' COMMENT 'Format of the setting: 1) Legacy Mode - UID Only; 2) Based on menu ID and UID',
  PRIMARY KEY (`sitemap_id`, `uid`, `settings_hash`),
  INDEX `idx_sitemap_id` (`sitemap_id` ASC))
ENGINE = INNODB
DEFAULT CHARACTER SET = utf8;


SET SQL_MODE=@OLD_SQL_MODE;
SET FOREIGN_KEY_CHECKS=@OLD_FOREIGN_KEY_CHECKS;
SET UNIQUE_CHECKS=@OLD_UNIQUE_CHECKS;
