/**
 * @name		Template Creator CK 3
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

function TCK_WidgetParallaxbackgroundEnable() {
	$ck('.widgetrow[data-name="parallaxbackground"]').attr('data-enabled', '1');
	$ck('#widgetsElements .widget[data-name="parallaxbackground"]').attr('data-enabled', '1');
	$ck('.widgetrow[data-name="parallaxbackground"] .widgetedit').trigger('click');
}

function TCK_WidgetParallaxbackgroundDisable() {
	$ck('.widgetrow[data-name="parallaxbackground"]').attr('data-enabled', '0');
	$ck('#widgetsElements .widget[data-name="parallaxbackground"]').attr('data-enabled', '0');
}

function TCK_WidgetParallaxbackgroundEdit(btn) {
	
	$ck('#widgetedition').empty();
	ckAfterWidgetEditionDisplay(); // needed for system actions, to add the back button

	var blocsList = new Array();
	$ck('#body, #body .ckbloc').not('.logobloc').each(function() {
		var bloc = new Object();
		bloc['id'] = this.id;
		var styleswrapper = ckGetStylesWrapperForBlock(this.id);
		var prefix = this.className.indexOf('wrapper') !== -1 ? 'body' : 'bloc';
		var dataTarget = $ck('#widgetsElements').find('[data-name="parallaxbackground"] [data-id="' + this.id + '"]');
		var bgimageurl = styleswrapper.find('> .tab_' + prefix + 'styles').attr(prefix + 'backgroundimageurl');
		bloc['bgimageurl'] = bgimageurl ? bgimageurl : '';
		bloc['class'] = this.className;
		bloc['enabled'] = $ck(this).attr('data-class') && $ck(this).attr('data-class').indexOf('parallaxbackground') !== -1 ? '1' : '0';
		bloc['direction'] = dataTarget.attr('data-direction') ? dataTarget.attr('data-direction') : '';
		bloc['speed'] = dataTarget.attr('data-speed') ? dataTarget.attr('data-speed') : '';
		blocsList.push(bloc);
	});
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=ajaxCallWidgetAction&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			name: 'parallaxbackground',
			func: 'listBackgroundOptions',
			blocsList: JSON.stringify(blocsList)
		}
	}).done(function(code) {
		$ck('#widgetedition').append(code);
		ckInitModalPopup();
	}).fail(function() {
		alert(Joomla.JText._('CK_FAILED', 'Failed'));
	});
}

function TCK_WidgetParallaxbackgroundToggle(btn) {
	// set the parallax background option on the selected block
	var rowData = getRowDataFromBtn(btn);
	var bloc = $ck('#' + rowData.attr('data-id'));
	if ($ck(btn).hasClass('ckbutton-danger')) {
		$ck(btn).removeClass('ckbutton-danger').addClass('ckbutton-success').text('ON');
		dataClass = 'parallaxbackground';
		if (bloc.attr('data-class') && bloc.attr('data-class').indexOf('parallaxbackground') === -1) {
			if (bloc.attr('data-class')) {
				dataClass = bloc.attr('data-class') + ' parallaxbackground';
			} else {
				dataClass = 'parallaxbackground';
			}
		}
		bloc.attr('data-class', dataClass);
//		bloc.attr('data-class', dataClass).attr('data-parallaxbackground', '1');
		TCK_WidgetParallaxbackgroundSetOptions(btn);
	} else {
		$ck(btn).removeClass('ckbutton-success').addClass('ckbutton-danger').text('OFF');
		if (bloc.attr('data-class')) {
			dataClass = bloc.attr('data-class').replace('parallaxbackground', '').trim();
		} else {
			dataClass = '';
		}
		bloc.attr('data-class', dataClass).removeAttr('data-parallaxbackground');
		$ck('#widgetsElements').find('[data-name="parallaxbackground"] [data-id="' + rowData.attr('data-id') + '"]').remove();
	}
}

function TCK_WidgetParallaxbackgroundSetOptions(btn) {
	var rowData = getRowDataFromBtn(btn);
	var blocid = rowData.attr('data-id');
//	var bloc = $ck('#' + blocid);
	var styleswrapper = ckGetStylesWrapperForBlock(blocid);
	var dataTarget = $ck('#widgetsElements').find('[data-name="parallaxbackground"] .widgetdata [data-id="' + rowData.attr('data-id') + '"]');
	if (! dataTarget.length) {
		$ck('#widgetsElements').find('[data-name="parallaxbackground"] .widgetdata').append('<div data-id="' + rowData.attr('data-id') + '"></div>');
		dataTarget = $ck('#widgetsElements').find('[data-name="parallaxbackground"] [data-id="' + rowData.attr('data-id') + '"]');
	}
	dataTarget.attr('data-direction', rowData.find('.parallaxdirection').val());
	if(! rowData.find('.parallaxspeed').val()) rowData.find('.parallaxspeed').val('5');
	dataTarget.attr('data-speed', rowData.find('.parallaxspeed').val());
	var bgimageurl = rowData.find('#' + blocid + 'backgroundimageurl').val();
	var prefix = rowData.attr('data-type').indexOf('wrapper') !== -1 ? 'body' : 'bloc';
	if (! styleswrapper.find('> .tab_' + prefix + 'styles').length) styleswrapper.prepend('<div class="tab_' + prefix + 'styles ckprops"></div>');
	styleswrapper.find('> .tab_' + prefix + 'styles').attr(prefix + 'backgroundimageurl', bgimageurl);
	styleswrapper.find('> .tab_' + prefix + 'styles').attr(prefix + 'backgroundimagesize', 'cover');
	var blocfieldslist = styleswrapper.find('> .tab_' + prefix + 'styles').attr('fieldslist');
	if (!blocfieldslist || (blocfieldslist && blocfieldslist.indexOf(prefix + 'backgroundimageurl') === -1)) {
		blocfieldslist += ',' + prefix + 'backgroundimageurl';
		if (blocfieldslist.indexOf(prefix + 'backgroundimagesize') === -1) blocfieldslist += ',' + prefix + 'backgroundimagesize';
		styleswrapper.find('> .tab_' + prefix + 'styles').attr('fieldslist', blocfieldslist);
	}
	ckRenderCss(blocid, '', $ck('#' + blocid), false);
}

function getRowDataFromBtn(btn) {
	var rowData = $ck($ck(btn).parents('.datarow')[0]);
	return rowData;
}

function TCK_WidgetParallaxbackgroundFilterByType(btn) {
	if (btn == 'search') return TCK_WidgetParallaxbackgroundFilterBySearch();

	var type = $ck(btn).attr('data-type');
	var classfilter;
	switch (type) {
		case 'wrapper' :
			classfilter = 'wrapper';
			break;
		case 'row' :
			classfilter = 'ckrow';
			break;
		case 'flexiblemodules' :
			classfilter = 'flexiblemodules';
			break;
		case 'singlemodule' :
			classfilter = 'singlemodule';
			break;
		case 'horiznav' :
			classfilter = 'horiznav';
			break;
		case 'all' :
		default :
			classfilter = '';
			break;
	}
	$ck('#widgetedition .datarow').hide();
	if (classfilter) {
		$ck('#widgetedition .datarow[data-type~="' + classfilter + '"]').show();
	} else {
		$ck('#widgetedition .datarow').show();
		$ck('#widgettopbarfilter').val('');
	}
}

function TCK_WidgetParallaxbackgroundFilterBySearch() {
	var filter = $ck('#widgettopbarfilter').val();
	$ck('#widgetedition .datarow').hide();
	if (filter) {
		$ck('#widgetedition .datarow[data-id*="' + filter + '"]').show();
	} else {
		$ck('#widgetedition .datarow').show();
	}
}