<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');

$document = \Joomla\CMS\Factory::getDocument();
$document->addStyleSheet('components/com_templateck/assets/css/templateck.css');
?>
<script type="text/javascript">
	Joomla.submitbutton = function(task)
	{
		if (task == 'font.cancel') {
			var form = document.getElementById('adminForm');
			form.task.value = task;
			form.submit();
		}
		else {
			alert('<?php echo addslashes(TCK_Text::_('JGLOBAL_VALIDATION_FORM_FAILED')); ?>');
		}
	}
</script>
<p class="alert alert-info"><?php echo TCK_Text::_('CK_HOW_TO_DL_FONTKIT'); ?> <a href="https://www.fontsquirrel.com" target="_blank">Fontsquirrel</a></p>
<form action="<?php echo \Joomla\CMS\Router\Route::_('index.php'); ?>" method="post" enctype="multipart/form-data" name="adminForm" id="adminForm" class="form-validate">
	<div>
		<fieldset class="adminform">
			<legend><?php echo TCK_Text::_('CK_INSTALL_FONT'); ?></legend>
			<table class="admintable">
				<tr>
					<td width="110" class="key">
						<label for="title">
							<?php echo TCK_Text::_('CK_ZIP_FILE'); ?>:
						</label>
					</td>
					<td>
						<input class="inputbox" type="file" name="file" id="file" size="60" />
						<input type="submit" name="submitbutton" value="<?php echo TCK_Text::_('CK_INSTALL_FONT'); ?>" />
					</td>
				</tr>
			</table>
		</fieldset>
	</div>

	<input type="hidden" name="option" value="com_templateck" />
	<input type="hidden" name="view" value="fonts" />
	<input type="hidden" name="task" value="font.importzipfromsquirrel" />
	<?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
</form>
<div class="ckgrid">
	<h4 class="ckgridtitle"><?php echo TCK_Text::_('CK_HELP_VIDEO_ADDINGFONT') ?></h4>
	<iframe width="340" height="180" src="https://www.youtube.com/embed/RXNlVevvKHY" frameborder="0" allowfullscreen></iframe>
</div>