<?php
/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');

$error404_options = $blocsbyname['layout_error404_html'];
$error404error404use = isset($error404_options->error404use) ? $error404_options->error404use : '0';
$error404_css = '<?php if (file_exists(JPATH_ROOT . \'/templates/\' . $this->template . \'/css/error.css\')) { ?>
		<link rel="stylesheet" href="<?php echo $this->baseurl ?>/templates/<?php echo $this->template ?>/css/error.css" type="text/css" />
	<?php } ?>';

// check if we need to create the 404 page
if ($error404error404use == '1') {
	$layouterror404custommessage = $this->input->get('layouterror404custommessage', '', 'html');
	$layouterror404custommessage = str_replace('&lt;', '<', $layouterror404custommessage);
	$layouterror404custommessage = str_replace('&gt;', '>', $layouterror404custommessage);

	// Make replacements for the strings
	$layouterror404custommessage = str_replace('{ERROR_REQUEST}', '<?php echo \Joomla\CMS\Language\Text::_( \'TPL_' . strtoupper($templatename) . '_ERROR_REQUEST\'); ?>', $layouterror404custommessage);
	// use mod_finder for joomla 4
	if (version_compare(JVERSION, "4")) {
		$layouterror404custommessage = str_replace('{SEARCH_FIELD}', '<?php if (\Joomla\CMS\Helper\ModuleHelper::getModule(\'finder\')) : ?><?php echo \Joomla\CMS\Language\Text::_( \'TPL_' . strtoupper($templatename) . '_SEARCH_FIELD\'); ?><br /><?php echo $doc->getBuffer(\'module\', \'finder\'); ?><?php endif; ?>', $layouterror404custommessage);
	} else {
		$layouterror404custommessage = str_replace('{SEARCH_FIELD}', '<?php if (\Joomla\CMS\Helper\ModuleHelper::getModule(\'search\')) : ?><?php echo \Joomla\CMS\Language\Text::_( \'TPL_' . strtoupper($templatename) . '_SEARCH_FIELD\'); ?><br /><?php echo $doc->getBuffer(\'module\', \'search\'); ?><?php endif; ?>', $layouterror404custommessage);
	}
	$layouterror404custommessage = str_replace('{GO_HOME}', '<a class="button" href="<?php echo \Joomla\CMS\Uri\Uri::base(true) ?>/"><span class="fack fack-home"></span> <?php echo \Joomla\CMS\Language\Text::_(\'JERROR_LAYOUT_GO_TO_THE_HOME_PAGE\'); ?></a>', $layouterror404custommessage);
	$layouterror404custommessage = str_replace('{CONTACT_ADMINISTRATOR}', '<?php echo \Joomla\CMS\Language\Text::_( \'TPL_' . strtoupper($templatename) . '_CONTACT_ADMINISTRATOR\'); ?>', $layouterror404custommessage);
	$layouterror404custommessage = str_replace('{ERROR_CODE}', '404', $layouterror404custommessage);
	$layouterror404custommessage = str_replace('{ERROR_MESSAGE}', '<?php echo \Joomla\CMS\Language\Text::_(\'TPL_' . strtoupper($templatename) . '_ERROR_MESSAGE\'); ?>', $layouterror404custommessage);

	if (version_compare(JVERSION,'4') < 1) {
		$jqueryPath = '<?php echo \Joomla\CMS\Uri\Uri::base(true) ?>/media/jui/js/jquery.min.js';
	} else {
		$jqueryPath = '<?php echo \Joomla\CMS\Uri\Uri::base(true) ?>/media/vendor/jquery/js/jquery.min.js';
	}

	$error404codeincontent = isset($error404_options->error404codeincontent) ? $error404_options->error404codeincontent : '1';
	if ($error404codeincontent == '1') {
		$indexphp = @file_get_contents($path . '/index.php');
		$error404_php = str_replace('<jdoc:include type="component" />', $layouterror404custommessage, $indexphp);
		$error404_php = str_replace('<jdoc:include type="message" />', '', $error404_php);
		$error404_php = str_replace("defined('_JEXEC') or die('Restricted access');", "defined('_JEXEC') or die('Restricted access');\n\$app = \Joomla\CMS\Factory::getApplication();\n\$doc = \Joomla\CMS\Factory::getDocument();\$this->params = \$app->getTemplate(true)->params;", $error404_php);
		$error404_php = str_replace("\$this->countModules", "\Joomla\CMS\Factory::getDocument()->countModules", $error404_php);
		$error404_php = str_replace("<?php \Joomla\CMS\HTML\HTMLHelper::_('jquery.framework'); ?>", "", $error404_php);
		$error404_php = str_replace("<?php \Joomla\CMS\HTML\HTMLHelper::_('bootstrap.framework'); ?>", "", $error404_php);
		$error404_php = str_replace("<?php \Joomla\CMS\HTML\Helpers\Bootstrap::loadCss(\$includeMaincss = false, \$this->direction); ?>", "", $error404_php);
		$error404_php = str_replace('$siteHome = 1;', '$siteHome = 0;', $error404_php); // force to never hide the maincontent in the error page
		if ($joomlaversion == 'j3') {
			$error404_php = str_replace('<jdoc:include type="head" />', '<meta charset="utf-8" />
	<title><?php echo $this->title; ?> <?php echo htmlspecialchars($this->error->getMessage(), ENT_QUOTES, \'UTF-8\'); ?></title>
	<meta name="viewport" content="width=device-width, initial-scale=1.0">
	<script src="' . $jqueryPath . '" type="text/javascript"></script>
	' . $error404_css, $error404_php);
		}
		
		$error404_php = preg_replace('/<jdoc:include type="modules" name="(.[^=]*)" \/>/', "<?php echo \$doc->getBuffer('modules', '$1'); ?>", $error404_php);
		if (version_compare(JVERSION,'4') < 1) {
			$error404_php = preg_replace('/<jdoc:include type="modules" name="(.*)" style="(.*)" \/>/Uis', '<?php echo \$doc->getBuffer(\'modules\', \'$1\', array(\'style\' => \'$2\')); ?>', $error404_php);
		}
	} else {
		$error404_php = '<?php
/**
 * Created by Template Creator CK
 * https://www.template-creator.com
 */

 // load the header.php file
?>
' . $layouterror404custommessage . '

<?php
';
	}

	@file_put_contents($path . '/error.php', $error404_php);
} else if ($error404error404use == '2') {
	$error404_php = '<?php
 /**
 * @copyright
 * Template made with the joomla component Template Creator CK - https://www.template-creator.com
 * @license GNU/GPL
 * */

// No direct access to this file
defined(\'_JEXEC\') or die(\'Restricted access\');

$app = \Joomla\CMS\Factory::getApplication();
$params = $app->getTemplate(true)->params;

if ($this->error->getCode() == \'404\') {
	header(\'Location: /index.php?Itemid=\' . $params->get(\'errorredirect\',\'1\'));
	exit;
} else {
	echo \'Template error page message : Unknown error ...\';
}';

	@file_put_contents($path . '/error.php', $error404_php);
}
