<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');
?>
<div id="ckinterfacelayoutsearch" class="ckinterfacesliderparent">

<div id="ckelementscontainer" class="clearfix ckinterface">
	<div class="tab_fullscreen">
		<div class="cktitle"><?php echo TCK_Text::_('CK_LAYOUT_SEARCH'); ?></div>
		<div class="ckinterfacedesc"></div>

		<?php if (!TEMPLATECREATORCK_ISJ4 || TEMPLATECREATORCK_ISJ5) { ?>
		<div class="tck-search search mod_search">
				<label for="mod-search-searchword" class="tck-search-label">Search ...</label> <input name="searchword" id="mod-search-searchword" maxlength="200" class="search-query input-medium tck-search-field" size="20" placeholder="Search ..." type="search"><button class="button btn btn-primary tck-search-button"><span class="icon-search"></span> Search</button>
		</div>
		<?php } else { ?>
			<form class="mod-finder">
			<label for="mod-finder-searchword140" class="finder">Search</label>
			<div class="mod-finder__search input-group">
				<div class="awesomplete">
					<input type="text" name="q" id="mod-finder-searchword140" class="js-finder-search-query form-control" value="" placeholder="Search …" autocomplete="off" aria-expanded="false" aria-owns="awesomplete_list_1" role="combobox">
					<ul role="listbox" id="awesomplete_list_1" hidden=""></ul>
				</div>
				<button class="btn btn-primary" type="submit"><span class="icon-search icon-white" aria-hidden="true"></span> Search</button>
			</div>
			</form>
		<?php } ?>
	</div>
	<?php echo TemplateckHelper::renderInterfaceSliderTitle(TCK_Text::_('CK_EDIT'), '[ ' . TCK_Text::_('CK_SEARCH') . ' ]', 'ckClosePreviewEdition'); ?>
		<div class="ckleftpanel-tools">
			<span class="ckbutton cksave ckleftpanelheadericon-apply ckhastip" title="<?php echo TCK_Text::_('CK_APPLY'); ?>" onclick="ckRenderCss('ckcustomlayoutarticle');"><span class="fack fack-check"></span></span>
		</div>
	
		<div class="ckinterfacesliderlinks">
			<div class="ckinterfacesliderlink" tab="tab_searchlabel"><?php echo TCK_Text::_('CK_LABEL'); ?></div>
			<div class="ckinterfacesliderlink" tab="tab_searchfield"><?php echo TCK_Text::_('CK_FIELD'); ?></div>
			<div class="ckinterfacesliderlink" tab="tab_searchfieldfocus"><?php echo TCK_Text::_('CK_FIELD_FOCUS'); ?></div>
			<div class="ckinterfacesliderlink" tab="tab_searchbutton"><?php echo TCK_Text::_('CK_BUTTON'); ?></div>
			<div class="ckinterfacesliderlink" tab="tab_searchbuttonhover"><?php echo TCK_Text::_('CK_BUTTON_HOVER'); ?></div>
		</div>
		<div class="ckinterfaceslidercontent">
			<div class="ckinterfaceslider ckproperty" data-id="tab_searchlabel">
				<?php TemplateckHelper::renderInterfaceSliderTitle('CK_LABEL') ?>
				<div class="inner">
					<div class="ckoption">
						<?php $this->interface->createLabel('CK_SHOW_LABELS', 'tag_green.png') ?>
						<span class="ckoption-field">
							<select id="showlabels" name="showlabels" class="inputbox" style="width:155px;" type="list">
								<option value="1"><?php echo \Joomla\CMS\Language\Text::_('JYES'); ?></option>
								<option value="0"><?php echo \Joomla\CMS\Language\Text::_('JNO'); ?></option>
							</select>
						</span>
						<div class="clr"></div>
					</div>
					<div class="menustylescustom" data-prefix="label" data-rule="{VARIATION}.tck-search label.tck-search-label,{VARIATION} .mod-finder label.finder"><?php echo $this->interface->createNormalStyles('label'); ?></div>
				</div>
			</div>
			
			<div class="ckinterfaceslider ckproperty" data-id="tab_searchfield">
				<?php TemplateckHelper::renderInterfaceSliderTitle('CK_FIELD') ?>
				<div class="inner">
					<div class="ckoption">
						<?php $this->interface->createLabel('CK_SHOW_PLACEHOLDER', 'text_signature.png') ?>
						<span class="ckoption-field">
							<select id="showplaceholder" name="showplaceholder" class="inputbox" style="width:155px;" type="list">
								<option value="1"><?php echo \Joomla\CMS\Language\Text::_('JYES'); ?></option>
								<option value="0"><?php echo \Joomla\CMS\Language\Text::_('JNO'); ?></option>
							</select>
						</span>
						<div class="clr"></div>
					</div>
					<div class="menustylescustom" data-prefix="field" data-rule="{VARIATION}.tck-search input.tck-search-field,{VARIATION}.mod-finder input.js-finder-search-query"><?php echo $this->interface->createNormalStyles('field'); ?></div>
				</div>
			</div>
			
			<div class="ckinterfaceslider ckproperty" data-id="tab_searchfieldfocus">
				<?php TemplateckHelper::renderInterfaceSliderTitle('CK_FIELD_FOCUS') ?>
				<div class="inner">
					<div class="menustylescustom" data-prefix="fieldfocus" data-rule="{VARIATION}.tck-search input.tck-search-field:focus,{VARIATION}.mod-finder input.js-finder-search-query:focus"><?php echo $this->interface->createNormalStyles('fieldfocus'); ?></div>
				</div>
			</div>
			
			<div class="ckinterfaceslider ckproperty" data-id="tab_searchbutton">
				<?php TemplateckHelper::renderInterfaceSliderTitle('CK_BUTTON') ?>
				<div class="inner">
					<div class="ckoption">
						<?php $this->interface->createLabel('CK_SHOW_ICON', 'images.png') ?>
						<span class="ckoption-field">
							<select id="showicon" name="showicon" class="inputbox" style="width:155px;" type="list">
								<option value="1"><?php echo \Joomla\CMS\Language\Text::_('JYES'); ?></option>
								<option value="0"><?php echo \Joomla\CMS\Language\Text::_('JNO'); ?></option>
							</select>
						</span>
						<div class="clr"></div>
					</div>
					<div class="ckoption">
						<?php $this->interface->createLabel('CK_ICON_CLASS', 'magnifier.png') ?>
						<span class="ckoption-field">
							<input id="iconclass" name="iconclass" class="inputbox" value="" type="text" placeholder="icon-search" />
						</span>
						<div class="clr"></div>
					</div>
					<div class="ckoption">
						<?php $this->interface->createLabel('CK_BUTTON_CLASS', 'magnifier.png') ?>
						<span class="ckoption-field">
							<input id="buttonclass" name="buttonclass" class="inputbox" value="" type="text" placeholder="button btn btn-primary" />
						</span>
						<div class="clr"></div>
					</div>
					<div class="menustylescustom" data-prefix="button" data-rule="{VARIATION}.tck-search button.tck-search-button,{VARIATION}.mod-finder button.btn"><?php echo $this->interface->createNormalStyles('button'); ?></div>
				</div>
			</div>
			
			<div class="ckinterfaceslider ckproperty" data-id="tab_searchbuttonhover">
				<?php TemplateckHelper::renderInterfaceSliderTitle('CK_BUTTON_HOVER') ?>
				<div class="inner">
					<div class="menustylescustom" data-prefix="buttonhover" data-rule="{VARIATION}.tck-search button.tck-search-button:hover,{VARIATION}.mod-finder button.btn:hover"><?php echo $this->interface->createNormalStyles('buttonhover'); ?></div>
				</div>
			</div>
		</div>
	</div>
</div>
<script language="javascript" type="text/javascript">
	ckInitColorPickers();
	ckInitModalPopup();
	ckInitOptionsAccordions($ck('#ckelementscontainer'));
	ckInitOptionsSliders();
	ckInitOptionsTabs();
</script>
<style>
.input-group > :not(:first-child):not(.dropdown-menu):not(.valid-tooltip):not(.valid-feedback):not(.invalid-tooltip):not(.invalid-feedback) {
  margin-left: -1px;
  border-top-left-radius: 0;
  border-bottom-left-radius: 0;
}
.button:hover, button:hover, button.btn:hover, input.btn:hover, .btn:hover, .button:focus, button:focus, button.btn:focus, input.btn:focus, .btn:focus {
  background: #dedede;
  color: #000000;
}
.mod-finder__search.input-group button {
  display: flex;
  align-items: center;
}
.button, button, button.btn, input.btn, .btn {
  border: none;
    border-top-color: currentcolor;
    border-right-color: currentcolor;
    border-bottom-color: currentcolor;
    border-left-color: currentcolor;
  background: #e8e8e8;
    background-color: rgb(232, 232, 232);
  color: #333333;
  padding-top: 7px;
  padding-right: 10px;
  padding-bottom: 7px;
  padding-left: 10px;
}
.btn-primary, body.contentpane .btn-primary, div.ckboxmodal-body .btn-primary {
  color: white;
  background-color: #010156;
  border-color: #010156;
}
.btn, body.contentpane .btn, div.ckboxmodal-body .btn {
  display: inline-block;
  font-weight: 400;
  line-height: 1.5;
  color: #22262a;
  text-align: center;
  text-decoration: none;
  vertical-align: middle;
  cursor: pointer;
  -webkit-user-select: none;
  -moz-user-select: none;
  -ms-user-select: none;
  user-select: none;
  background-color: transparent;
  border: 1px solid transparent;
  padding: 0.6rem 1rem;
  font-size: 1rem;
  border-radius: 0.25rem;
  transition: color 0.15s ease-in-out, background-color 0.15s ease-in-out, border-color 0.15s ease-in-out, box-shadow 0.15s ease-in-out;
}
.mod-finder__search.input-group {
  flex-wrap: nowrap;
}
.input-group {
  position: relative;
  display: flex;
  flex-wrap: wrap;
  align-items: stretch;
  width: 100%;
}
.awesomplete {
  display: inline-block;
  position: relative;
}

.mod-finder input.js-finder-search-query {
	margin-bottom: 0;
	padding: 8px;
}
</style>