<?php
/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined('TCK_LOADED') or die;

jimport('joomla.filesystem.folder');
jimport('joomla.filesystem.file');

class CKModules {

	private static $modules = Array();

	/*
	 * Return the code to show in the left panel of the interface
	 */
	public static function displayBloc($name) {
		$module = self::getInstance($name);
		if(! $module) return;
		$isInstalled = self::checkInstalled($module);
		switch ($name) {
			case 'horizmenu': 
				$icon = '<i class="fack fack-ellipsis-h"></i>';
				break;
			case 'slideshowck': 
				$icon = '<i class="fack fack-film"></i>';
				break;
			case 'menu': 
				$icon = '<i class="fack fack-navicon"></i>';
				break;
			default:
				$icon = '';
				break;
		}
		$InstallButton = !$isInstalled ? '<div class="installbutton" onclick="ckInstallModule(\'' . $module->name . '\')"><span class="fack fack-download"></span> ' . TCK_Text::_('CK_INSTALL') . '</div>' : '';
		$input = \Joomla\CMS\Factory::getApplication()->input;

		$blocHtml = '<div class="blocselectcont">'
						. '<div class="blocselect blocselectnew ' . $module->name . ' ' . ($isInstalled ? 'dragtoadd' : 'notinstalled') . '" data-type="module-' . $module->name . '" data-element="' . $module->element . '">' 
							. $icon 
							. '<div class="blocselecttitle">' . ($module->title ? $module->title : TCK_Text::_('CK_' . strtoupper($module->name))) . '</div>'
							. '<div class="blocselectdesc">' . TCK_Text::_('CK_' . strtoupper($module->name) . '_SMALL_DESC') . '</div>'
							. $InstallButton 
					. '</div>'
				. '</div>';

		return $blocHtml;
	}

	/**
	 * Get the module object
	 */
	public static function getInstance($name) {
		if (isset(self::$modules[$name]) && !empty(self::$modules[$name])) 
			return self::$modules[$name];

		if (empty(self::$modules)) self::getModules();

		return isset(self::$modules[$name]) ? self::$modules[$name] : false;
//		if (file_exists(JPATH_SITE . '/administrator/components/com_templateck/modules/' . $name . '/module.php')) {
//			include_once(JPATH_SITE . '/administrator/components/com_templateck/modules/' . $name . '/module.php');
//			$moduleClassName = 'TCK_Module' . ucfirst($name);
//			self::$modules[$name] = new $moduleClassName();
//
//			return self::$modules[$name];
//		} else {
//			return false;
//		}
	}

	/*
	 * Check if the module is installed
	 */
	public static function checkInstalled($module) {
		$db = \Joomla\CMS\Factory::getDbo();
		$db->setQuery("SELECT enabled FROM #__extensions WHERE `element` = '" . $module->element . "' AND `type` = 'module'");
		return (int) $db->loadResult();
	}

	/*
	 * List the available modules
	 */
	public static function getModules() {
		if (! empty(self::$modules)) return self::$modules;

		self::$modules = Array();

		// Slideshow CK
		$module = new stdClass();
		$module->name = 'slideshowck';
		$module->element = 'mod_slideshowck';
		$module->title = TCK_Text::_('CK_SLIDESHOWCK');
		$module->url = 'https://www.joomlack.fr/index.php?option=com_dms&task=doc_download&id=59&updater=true';

		self::$modules[$module->name] = $module;

		// Vertical menu
		$module = new stdClass();
		$module->name = 'menu';
		$module->element = 'mod_menu';
		$module->title = TCK_Text::_('CK_MENU');
		$module->url = '';

		self::$modules[$module->name] = $module;

		// Horizontal menu
		$module = new stdClass();
		$module->name = 'horizmenu';
		$module->element = 'mod_menu';
		$module->title = TCK_Text::_('CK_HORIZ_MENU');
		$module->url = '';

		self::$modules[$module->name] = $module;

		return self::$modules;
	}

	/*public static function loadWidgetLanguage($name) {
		// loads the language files from the frontend
		$lang	= \Joomla\CMS\Factory::getLanguage();
		$lang->load('com_templateck_' . $name, JPATH_SITE . '/administrator/components/com_templateck/modules/' . $name, $lang->getTag(), false);
	}*/

	/*
	 * Update some changing informations
	 */
	/*public static function loadWidgets() {
		self::getModules();
		foreach (self::$modules as &$module) {
			
			$module->installed = CKWidgets::checkInstalled($module->name);
			if ($module->installed) {
				if (self::getInstance($module->name) && !empty($module->phpClass)) {
					$module->phpClass->loadWidget();
				}
//				$module->isUptodate = self::isUptodate($module->name);
			} else {
				$module->phpClass = null;
			}
		}
		return self::$modules;
	}*/

	

	/*public static function updateAvailable($name) {
		if (! $onlineTxt = @file_get_contents('https://www.template-creator.com/modules/' . $name . '_readme.txt')) {
			return false;
		}
		$currentTxt = @file_get_contents(JPATH_SITE . '/administrator/components/com_templateck/modules/' . $name . '/' . $name . '_readme.txt');
		$currentVersion = self::extractVersion($currentTxt);
		$latestVersion = self::extractVersion($onlineTxt);

		return version_compare($currentVersion, $latestVersion) < 0;
	}*/

	/*private static function extractVersion($file) {
		$lines = explode("\n", $file);
		foreach ($lines as $line) {
			if (stristr($line, 'version=')) {
				return trim(str_replace('version=', '', $line));
			}
		}
	}*/

	/*
	 * Check if the widget is installed
	 */
	/*public static function checkInstalled($module) {
		$type = explode(',', $module->type);
		switch ($type[0]) {
			case 'widget';
			default;
				return self::checkInstalledWidget($module);
				break;
//			case 'plugin';
//				return self::checkInstalledPlugin($module);
//				break;
		}
	}*/

	/*
	 * Check if the widget is installed
	 */
	public static function checkInstalled_($name) {
		return (int) (
				file_exists(JPATH_SITE . '/administrator/components/com_templateck/modules/' . $name . '/' . $name . '.php')
				&& file_exists(JPATH_SITE . '/administrator/components/com_templateck/modules/' . $name . '/interface.js')
			);
	}
	
	/*
	 * Check if the plugin is installed
	 */
	/*public static function checkInstalledPlugin($module) {
		// auto enable the plugin
		$db = \Joomla\CMS\Factory::getDbo();
		$db->setQuery("SELECT enabled FROM #__extensions WHERE `element` = '" . $module->name . "' AND `type` = 'plugin'");
		return (int) $db->loadResult();
	}

	public static function loadEdition($name) {
		$moduleClass = self::getInstance($name);
		$moduleClass->loadEdition();
	}

	public static function triggerOnAfterInstall($name) {
		$moduleClass = self::getInstance($name);
		return $moduleClass->onAfterInstall();
	}
	
	public static function parseWidgetData($data) {
		preg_match_all("#<div(.*)>(.*)<\/div>#U", $data, $matches);
		if (! count($matches[1])) return;
		$datas = array();
		foreach ($matches[1] as $e) {
			$data = new stdClass();
			$vars = explode(' ', trim($e));
			foreach ($vars as $var) {
				$setting = explode('=', trim($var));
				$data->$setting[0] = trim($setting[1], '"');
			}
			$datas[$data->{'data-id'}] = $data;
		}

		return $datas;
	}*/
}
