<?php
/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined('TCK_LOADED') or die;

jimport('joomla.filesystem.folder');
jimport('joomla.filesystem.file');

class CKInstaller {

	/*
	 * Download the package from the url and extract it
	 */
	public static function install($url, $name, $type = 'widget') {
		require_once JPATH_COMPONENT . '/helpers/zip.php';
		$config = \Joomla\CMS\Factory::getConfig();
//		set_time_limit(0);

		$target = $config->get('tmp_path');
		$targetZip = $target . '/templatecreatorck_widget_' . $name . '.zip';

		// check if the package can be downloaded
		if (! self::downloadPackage($url, $targetZip)) {
			echo TCK_Text::_('CK_ERROR_DOWNLOAD_PACKAGE_FROM_URL');
			return false;
		}

		// instanciate ZIP archiver
		$archiver = new CKArchiveZip();

		if ($type == 'widget') {
			return self::extractWidgetPackage($targetZip, $name);
		}
		else {
			// extract archive
			$extractdir = $target . '/' . $name;
			$isSuccess = $archiver->extract($targetZip, $extractdir);

			$dirList = array_merge(TCK_Folder::files($extractdir, ''), TCK_Folder::folders($extractdir, ''));

			if (count($dirList) == 1)
			{
				if (TCK_Folder::exists($extractdir . '/' . $dirList[0]))
				{
					$extractdir = \Joomla\CMS\Filesystem\Path::clean($extractdir . '/' . $dirList[0]);
				}
			}

//			$retval['dir'] = $extractdir;

			// Get an installer instance.
			$installer = \Joomla\CMS\Installer\Installer::getInstance();
			// Install the package.
			if (!$installer->install($extractdir))
			{
				// There was an error installing the package.
				echo TCK_Text::sprintf('COM_INSTALLER_INSTALL_ERROR', TCK_Text::_('COM_INSTALLER_TYPE_TYPE_' . strtoupper($type)));
				return false;
			}

			if ($type == 'plugin') {
				// auto enable the plugin
				$db = \Joomla\CMS\Factory::getDbo();
				$db->setQuery("UPDATE #__extensions SET enabled = '1' WHERE `element` = '" . $name . "' AND `type` = 'plugin'");
				$db->execute();
			}

			self::cleanDownload($targetZip, $extractdir);
		}

		return true;
	}

	/*
	 * Download the package from the url
	 */
	public static function extractWidgetPackage($targetZip, $name) {
		require_once JPATH_COMPONENT . '/helpers/zip.php';
		// instanciate ZIP archiver
		$archiver = new CKArchiveZip();

		if (! TCK_Folder::exists(JPATH_SITE . '/administrator/components/com_templateck/widgets/')) {
			TCK_Folder::create(JPATH_SITE . '/administrator/components/com_templateck/widgets/');
		}
		// extract archive
		$extractdir = JPATH_SITE . '/administrator/components/com_templateck/widgets/';
		$isSuccess = $archiver->extract($targetZip, $extractdir);

		if ($isSuccess === false) {
			echo TCK_Text::_('CK_ERROR_EXTRACT_PACKAGE');
			self::cleanDownload($targetZip);
			return false;
		}

		if (! file_exists($extractdir . $name)) {
			echo TCK_Text::_('CK_ERROR_WIDGET_NOT_FOUND');
			self::cleanDownload($targetZip);
			return false;
		}

		require_once(JPATH_SITE . '/administrator/components/com_templateck/helpers/ckwidgets.php');
		CKWidgets::triggerOnAfterInstall($name);

		self::cleanDownload($targetZip);

		return true;
	}

	/*
	 * Download the package from the url
	 */
	public static function downloadPackage($url, $dest) {
		set_time_limit(0);
		try {
			$file = file_get_contents(urldecode($url));
		} catch (Exception $e) {
			echo 'Exception : ',  $e->getMessage(), "\n";
			exit;
		}

		return file_put_contents($dest, $file);
	}

	/*
	 * Download the package from the url
	 */
	public static function cleanDownload($file, $folder = '') {
		return TCK_File::delete($file) && ($folder  ? TCK_Folder::delete($folder) : 1);
	}
	
	public static function loadEdition($name) {
		include_once(JPATH_SITE . '/administrator/components/com_templateck/widgets/' . $name . '/' . $name . '.php');
		$widgetClassName = 'TCK_Widget' . ucfirst($name);
		$widgetClass = new $widgetClassName();
		$widgetClass->loadEdition();
	}
}
