<?php

/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access
defined('TCK_LOADED') or die;

use Templatecreatorck\CKController;
use Templatecreatorck\CKFof;

/**
 * Template controller class.
 */
class TemplateckControllerTemplate extends CKController {

	/**
	 * Method to save a template.
	 *
	 */
	public function save() {
		// Check for request forgeries.
		CKFof::checkToken();

		$model = $this->getModel();

		// Get the user data.
		$data = $this->input->getArray($_POST);
		$id = $this->input->get('id', 0 , 'int');

		// Check for errors.
		if ($data === false) {
			CKFof::enqueueMessage('ERROR : NO DATA SAVED', 'warning');
			// Redirect back to the edit screen.
			CKFof::redirect(TEMPLATECREATORCK_ADMIN_URL + '&view=template&layout=edit&id=' . $id, false);
			return false;
		}

		// Attempt to save the data.
		$return = $model->save($data);

		// Check for errors.
		if ($return === false) {
			// Redirect back to the edit screen.
			$id = (int) $app->getUserState('com_templateck.edit.template.id');
			CKFof::enqueueMessage(TCK_Text::_('Save failed'), 'warning');
			CKFof::redirect(TEMPLATECREATORCK_ADMIN_URL + '&view=template&task=template.edit&layout=edit&id=' . $i);
			return false;
		}

		// Redirect to the list screen.
		CKFof::enqueueMessage(TCK_Text::_('CK_ITEM_SAVED_SUCCESS'));
		CKFof::redirect('index.php?option=com_templateck&view=template&task=template.edit&layout=edit&id=' . $return, false);
	}

	function cancel() {
		//Redirect back to list
		CKFof::redirect('index.php?option=com_templateck&view=templates', false);
	}

	/**
	* Write the export file
	*/
	public function export() {
		$model = $this->getModel();
		$model->export();
	}

	function download() {
		$filepath = $this->input->get('filepath', '', 'string');
		TemplateckHelper::pushFileForDownload($filepath, 'tck3z');
	}
	/**
	 * import a theme from a zip file
	 * @return void
	 */
	function import() {
		$model = $this->getModel();
		if (!$model->import()) {
			$msg = TCK_Text::_('CK_INSTALL_GABARIT_ERROR');
			$link = TEMPLATECREATORCK_ADMIN_GENERAL_URL;
			$type = 'error';
		} else {
			$msg = TCK_Text::_('CK_GABARIT_INSTALLED');
			$link = TEMPLATECREATORCK_ADMIN_GENERAL_URL;
			$type = 'message';
		}

		CKFof::redirect($link, $msg, $type);
	}

	/**
	 * import a theme from a zip file
	 * @return void
	 */
	function ajaxImport() {
		TemplateckHelper::checkAjaxToken();
		$model = $this->getModel();
		$file = $this->input->get('gabariturl', null, 'url');

		$id = $model->ajaxInstallGabarit($file);

		echo '{"status" : "' . ($id ? '1' : '0') . '", "id" : "' . $id . '"}';
		exit;
	}

	/**
	 * import a theme from a zip file
	 * @return void
	 */
	function importData() {
		$model = $this->getModel();
		$this->modules = $model->importData();
		if (! $this->modules) {
			die ('erreur du model');
		} else {
			\Joomla\CMS\Toolbar\ToolbarHelper::title('Template Creator CK - ' . TCK_Text::_('CK_IMPORT_DATA'));
			require TEMPLATECREATORCK_PATH . '/views/quickdata/tmpl/default.php';
		}
	}

	/**
	 * import a theme from a zip file
	 * @return void
	 */
	function importQuickData() {
		$modules= $this->input->get('modules', '', 'array');
		foreach ($modules as $module) {
			if (isset($module['selectedimport']) && $module['selectedimport'] == 'on') {
				$result = $this->importModule($module['settings']);
			}
			CKFof::enqueueMessage($result['msg'], $result['type']);
		}

		CKFof::redirect(TEMPLATECREATORCK_ADMIN_GENERAL_URL . '&task=quickdata.message&tmpl=component');
	}

	function importModule($module) {
		$module = unserialize($module);
		$model = $this->getModel('Quickdata');
		$moduleid = $model->importModule($module);
		if (! $moduleid) {
			$msg = TCK_Text::_('CK_INSTALL_MODULE_ERROR') . ' : ' . $module->module . ' - ' . $module->position;
			$link = TEMPLATECREATORCK_ADMIN_GENERAL_URL;
			$type = 'error';
		} else {
			$msg = TCK_Text::_('CK_MODULE_INSTALLED') . ' - ID : ' . $moduleid;
			$link = TEMPLATECREATORCK_ADMIN_GENERAL_URL;
			$type = 'message';
		}
		return array('msg' => $msg, 'link' => $link, 'type' => $type);
	}
}