<?php
/**
 * Akeeba Backup Restoration Script
 *
 * @package   brs
 * @copyright Copyright (c)2024 Nicholas K. Dionysopoulos / Akeeba Ltd
 * @license   GNU General Public License version 3, or later
 */

namespace Akeeba\BRS\Framework\RestorationCheck;

defined('_AKEEBA') or die();

use Psr\Container\ContainerInterface;

/**
 * Pre-restoration check: Safe Mode must be disabled.
 *
 * @since      10.0
 * @deprecated 11.0 This is no longer supported by any PHP version we can restore to.
 */
class SafeMode extends AbstractRestorationCheck
{
	/** @inheritdoc */
	public function __construct(ContainerInterface $container)
	{
		parent::__construct($container, 'MAIN_LBL_CHECK_SAFE_MODE', false, false);
	}

	/** @inheritdoc */
	public function isApplicable(): bool
	{
		/**
		 * Only applies to Joomla!, on PHP up to and including 5.3.x.
		 */
		return $this->isJoomla()
		       && version_compare(PHP_VERSION, '5.4.0', 'lt');
	}

	/** @inheritdoc */
	protected function returnCurrentValue()
	{
		if (function_exists('ini_get'))
		{
			return (bool) ini_get('safe_mode');
		}

		return false;
	}
}