<?php
/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');

$layout_blog_options = isset($blocsbyname['ckcustomlayoutblog']) ? $blocsbyname['ckcustomlayoutblog'] : new stdClass();
$layout_blog_options = new \Joomla\Registry\Registry($layout_blog_options);

$layout_blog_options_showdetails = (int)$layout_blog_options->get('showdetails', '1');
$layout_blog_options_alignicons = (int)$layout_blog_options->get('alignicons', '0');
$layout_blog_options_showtitle = (int)$layout_blog_options->get('showtitle', '1');
$layout_blog_options_showicons = (int)$layout_blog_options->get('showicons', '1');
$layout_blog_options_showlabels = (int)$layout_blog_options->get('showlabels', '1');
$layout_blog_options_detailsiconhits = $layout_blog_options->get('detailsiconhits', 'icon-eye-open');
$layout_blog_options_detailsicondate = $layout_blog_options->get('detailsicondate', 'icon-calendar');
$layout_blog_options_detailsiconauthor = $layout_blog_options->get('detailsiconauthor', 'icon-user');
$layout_blog_options_detailsiconcategory = $layout_blog_options->get('detailsiconcategory', 'icon-folder-open');
$layout_blog_options_showtools = (int)$layout_blog_options->get('showtools', '1');
$layout_blog_options_dropdown = (int)$layout_blog_options->get('dropdown', '1');
$layout_blog_options_floatright = (int)$layout_blog_options->get('floatright', '1');
$layout_blog_options_showtoolsicons = (int)$layout_blog_options->get('showtoolsicons', '1');
$layout_blog_options_iconprint = $layout_blog_options->get('iconprint', 'icon-print');
$layout_blog_options_iconcreate = $layout_blog_options->get('iconcreate', 'icon-plus');
$layout_blog_options_iconemail = $layout_blog_options->get('iconemail', 'icon-envelope');
$layout_blog_options_iconshowtext = $layout_blog_options->get('iconshowtext', '1');
$layout_blog_options_imageposition = $layout_blog_options->get('imageposition', 'above');
$layout_blog_options_iconreadmore = $layout_blog_options->get('blogiconreadmore', 'icon-chevron-right');

$layout_blog_options_settingstext = "<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2018. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined('_JEXEC') or die;
if (! defined('TCK_ARTICLE_SHOW_DETAILS')) define('TCK_ARTICLE_SHOW_DETAILS', " . $layout_blog_options_showdetails . ");
if (! defined('TCK_ARTICLE_DETAILS_ALIGN')) define('TCK_ARTICLE_DETAILS_ALIGN', " . $layout_blog_options_alignicons . ");
if (! defined('TCK_ARTICLE_DETAILS_SHOW_TITLE')) define('TCK_ARTICLE_DETAILS_SHOW_TITLE', " . $layout_blog_options_showtitle . ");
if (! defined('TCK_ARTICLE_DETAILS_SHOW_ICONS')) define('TCK_ARTICLE_DETAILS_SHOW_ICONS', " . $layout_blog_options_showicons . ");
if (! defined('TCK_ARTICLE_DETAILS_SHOW_LABELS')) define('TCK_ARTICLE_DETAILS_SHOW_LABELS', " . $layout_blog_options_showlabels . ");
if (! defined('TCK_ARTICLE_DETAILS_ICON_HITS')) define('TCK_ARTICLE_DETAILS_ICON_HITS', '" . $layout_blog_options_detailsiconhits . "');
if (! defined('TCK_ARTICLE_DETAILS_ICON_DATE')) define('TCK_ARTICLE_DETAILS_ICON_DATE', '" . $layout_blog_options_detailsicondate . "');
if (! defined('TCK_ARTICLE_DETAILS_ICON_AUTHOR')) define('TCK_ARTICLE_DETAILS_ICON_AUTHOR', '" . $layout_blog_options_detailsiconauthor . "');
if (! defined('TCK_ARTICLE_DETAILS_ICON_CATEGORY')) define('TCK_ARTICLE_DETAILS_ICON_CATEGORY', '" . $layout_blog_options_detailsiconcategory . "');
if (! defined('TCK_ARTICLE_DETAILS_ICON_CATEGORY_PARENT')) define('TCK_ARTICLE_DETAILS_ICON_CATEGORY_PARENT', '" . $layout_blog_options_detailsiconcategory . "');
if (! defined('TCK_ARTICLE_TOOLS_DROPDOWN')) define('TCK_ARTICLE_TOOLS_DROPDOWN', " . $layout_blog_options_dropdown . ");
if (! defined('TCK_ARTICLE_TOOLS_FLOAT_RIGHT')) define('TCK_ARTICLE_TOOLS_FLOAT_RIGHT', " . $layout_blog_options_floatright . ");
if (! defined('TCK_ARTICLE_TOOLS_SHOW_ICONS')) define('TCK_ARTICLE_TOOLS_SHOW_ICONS', " . $layout_blog_options_showtoolsicons . ");
if (! defined('TCK_ARTICLE_TOOLS_ICON_PRINT')) define('TCK_ARTICLE_TOOLS_ICON_PRINT', '" . $layout_blog_options_iconprint . "');
if (! defined('TCK_ARTICLE_TOOLS_ICON_CREATE')) define('TCK_ARTICLE_TOOLS_ICON_CREATE', '" . $layout_blog_options_iconcreate . "');
if (! defined('TCK_ARTICLE_TOOLS_ICON_EMAIL')) define('TCK_ARTICLE_TOOLS_ICON_EMAIL', '" . $layout_blog_options_iconemail . "');
if (! defined('TCK_ARTICLE_TOOLS_ICON_SHOW_TEXT')) define('TCK_ARTICLE_TOOLS_ICON_SHOW_TEXT', " . $layout_blog_options_iconshowtext . ");
if (! defined('TCK_ARTICLE_IMAGEPOSITION')) define('TCK_ARTICLE_IMAGEPOSITION', '" . $layout_blog_options_imageposition . "');";


// copy the layouts files if not exists
$success = array();
$article_override_layouts_files = TCK_folder::files($additionalsPath . '/html/layouts', '.', true, true);
foreach ($article_override_layouts_files as $file) {
	$tfile = str_replace('\\', '/', $file);
	$tfile = str_replace(str_replace('\\', '/', $additionalsPath), '', $tfile);
	// check if the folder exists
	if (!file_exists(dirname($path . $tfile))) {
		$success['folder:' . $tfile] = TCK_Folder::create(dirname($path . $tfile));
	}

	// check if the file exists
//	if (! file_exists($path . $tfile)) {
		$success[$tfile] = TCK_File::copy($file, $path . $tfile);
//	}
}
// copy the article override if not exists
$article_override_content_blog_file = $path . '/html/com_content/category/blog.php';
// check if the folder exists
if (!file_exists(dirname($article_override_content_blog_file))) {
	$success['folder:category'] = TCK_Folder::create(dirname($article_override_content_blog_file));
}

if (!file_exists($path . '/html/com_content/featured')) {
	$success['folder:featured'] = TCK_Folder::create($path . '/html/com_content/featured');
}
// check if the file exists
//if (!file_exists($article_override_content_blog_file)) {
	$success['category/blog.php'] = TCK_file::copy($additionalsPath . '/html/com_content/category/blog.php', $article_override_content_blog_file);
//}
$article_override_content_blog_item_file = $path . '/html/com_content/category/blog_item.php';
//if (!file_exists($article_override_content_blog_item_file)) {
	$success['category/blog_item.php'] = TCK_file::copy($additionalsPath . '/html/com_content/category/blog_item.php', $article_override_content_blog_item_file);
//}
	
$article_override_content_list_default_file = $path . '/html/com_content/category/default.php';
//if (!file_exists($article_override_content_blog_item_file)) {
	$success['category/default.php'] = TCK_file::copy($additionalsPath . '/html/com_content/category/default.php', $article_override_content_list_default_file);
//}

// copy the featured override
$success['featured/default.php'] = TCK_file::copy($additionalsPath . '/html/com_content/featured/default.php', $path . '/html/com_content/featured/default.php');
$success['featured/default_item.php'] = TCK_file::copy($additionalsPath . '/html/com_content/featured/default_item.php', $path . '/html/com_content/featured/default_item.php');
$success['featured/default_links.php'] = TCK_file::copy($additionalsPath . '/html/com_content/featured/default_links.php', $path . '/html/com_content/featured/default_links.php');

// create the settings file
$layout_blog_options_settingsfile = $path . '/html/com_content/settings_blog.php';
$success['settings_article.php'] = TCK_File::write($layout_blog_options_settingsfile, $layout_blog_options_settingstext);

// create the settings file
$content_options_settingsfile = $path . '/html/layouts/joomla/settings_content.php';
$content_options_settingstext = '';
$content_options_settingstext .= '<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2018. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined(\'_JEXEC\') or die;

if (! defined(\'TCK_LAYOUT_CONTENT_READMORE_LINK_CLASS\')) define(\'TCK_LAYOUT_CONTENT_READMORE_LINK_CLASS\', \'btn\');
if (! defined(\'TCK_LAYOUT_CONTENT_READMORE_SHOW_ICON\')) define(\'TCK_LAYOUT_CONTENT_READMORE_SHOW_ICON\', 1);
if (! defined(\'TCK_LAYOUT_CONTENT_READMORE_ICON\')) define(\'TCK_LAYOUT_CONTENT_READMORE_ICON\', \'' . $layout_blog_options_iconreadmore . '\');
if (! defined(\'TCK_ARTICLE_SHOW_DETAILS\')) define(\'TCK_ARTICLE_SHOW_DETAILS\', 1);
if (! defined(\'TCK_ARTICLE_DETAILS_ALIGN\')) define(\'TCK_ARTICLE_DETAILS_ALIGN\', 0);
if (! defined(\'TCK_ARTICLE_DETAILS_SHOW_TITLE\')) define(\'TCK_ARTICLE_DETAILS_SHOW_TITLE\', 1);
if (! defined(\'TCK_ARTICLE_DETAILS_SHOW_ICONS\')) define(\'TCK_ARTICLE_DETAILS_SHOW_ICONS\', 1);
if (! defined(\'TCK_ARTICLE_DETAILS_SHOW_LABELS\')) define(\'TCK_ARTICLE_DETAILS_SHOW_LABELS\', 1);
if (! defined(\'TCK_ARTICLE_DETAILS_ICON_HITS\')) define(\'TCK_ARTICLE_DETAILS_ICON_HITS\', \'icon-eye-open\');
if (! defined(\'TCK_ARTICLE_DETAILS_ICON_DATE\')) define(\'TCK_ARTICLE_DETAILS_ICON_DATE\', \'icon-calendar\');
if (! defined(\'TCK_ARTICLE_DETAILS_ICON_AUTHOR\')) define(\'TCK_ARTICLE_DETAILS_ICON_AUTHOR\', \'icon-user\');
if (! defined(\'TCK_ARTICLE_DETAILS_ICON_CATEGORY\')) define(\'TCK_ARTICLE_DETAILS_ICON_CATEGORY\', \'icon-database\');
if (! defined(\'TCK_ARTICLE_DETAILS_ICON_CATEGORY_PARENT\')) define(\'TCK_ARTICLE_DETAILS_ICON_CATEGORY_PARENT\', \'icon-database\');
if (! defined(\'TCK_ARTICLE_TOOLS_DROPDOWN\')) define(\'TCK_ARTICLE_TOOLS_DROPDOWN\', 1);
if (! defined(\'TCK_ARTICLE_TOOLS_FLOAT_RIGHT\')) define(\'TCK_ARTICLE_TOOLS_FLOAT_RIGHT\', 1);
if (! defined(\'TCK_ARTICLE_TOOLS_SHOW_ICONS\')) define(\'TCK_ARTICLE_TOOLS_SHOW_ICONS\', 1);
if (! defined(\'TCK_ARTICLE_TOOLS_ICON_PRINT\')) define(\'TCK_ARTICLE_TOOLS_ICON_PRINT\', \'icon-print\');
if (! defined(\'TCK_ARTICLE_TOOLS_ICON_CREATE\')) define(\'TCK_ARTICLE_TOOLS_ICON_CREATE\', \'icon-plus\');
if (! defined(\'TCK_ARTICLE_TOOLS_ICON_EMAIL\')) define(\'TCK_ARTICLE_TOOLS_ICON_EMAIL\', \'icon-envelope\');
if (! defined(\'TCK_ARTICLE_TOOLS_ICON_SHOW_TEXT\')) define(\'TCK_ARTICLE_TOOLS_ICON_SHOW_TEXT\', 1);
if (! defined(\'TCK_ARTICLE_IMAGEPOSITION\')) define(\'TCK_ARTICLE_IMAGEPOSITION\', \'above\');';
$success['settings_content.php'] = TCK_File::write($content_options_settingsfile, $content_options_settingstext);

if (in_array(false, $success)) {
	$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FOLDER') . ' /html/com_content/category</p>';
} else {
	$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FOLDER') . ' /html/com_content/category</p>';
}
$messages[] = $msg;