<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');
$input = new TCK_Input();
$resolutions = array('1', '2', '3', '4', '5');
$blocs = $input->get('blocs', '', 'html');
$blocs = str_replace("|di|", "#", $blocs);
$blocs = json_decode($blocs);
$templateid = $input->get('templateid', ''); 
$htmlcode_responsive = $input->get('htmlcode_responsive', '', 'html');
$isFluid = (isset($blocs[0]->blocwrapperfluid) && $blocs[0]->blocwrapperfluid !== 'fluid') ? false : true;

// split the data and store into customcss
preg_match_all('/\[resolution(.*?)\]=\[(.*?)\]/mis', $htmlcode_responsive, $customcss);
?>
<?php TemplateckHelper::renderInterfaceMainTitle(TCK_Text::_('CK_RESPONSIVE'), 'fack-mobile') ?>
<div class="ckinfosdescription"><?php echo TCK_Text::_('CK_RESPONSIVE_DESC2'); ?></div>
<div class="clearfix ckinterface ckelementscontainer">
	<div id="cktoolbarResponsive">
		<div><span class="ckbutton-group">
			<span id="ckresponsive1button" class="ckbutton ckresponsivebutton" onclick="ckSwitchResponsive(1)" data-range="1"><span class="fack fack-mobile" ></span> <?php echo TCK_Text::_('CK_PHONE') ?> / <small><?php echo TCK_Text::_('CK_PORTRAIT') ?></small></span>
			<input type="text" class="inputbox" name="responsivevalue0" id="responsivevalue0" onchange="checkreponsivevalues(this)">
		</span></div>
		<div><span class="ckbutton-group">
			<span id="ckresponsive2button" class="ckbutton ckresponsivebutton" onclick="ckSwitchResponsive(2)" data-range="2"><span class="fack fack-mobile" style="font-size: 1.4em;vertical-align: bottom;transform:rotate(90deg);"></span> <?php echo TCK_Text::_('CK_PHONE') ?> / <small><?php echo TCK_Text::_('CK_LANDSCAPE') ?></small></span>
			<input type="text" class="inputbox" name="responsivevalue1" id="responsivevalue1" onchange="checkreponsivevalues(this)">
		</span></div>
		<div><span class="ckbutton-group">
			<span id="ckresponsive3button" class="ckbutton ckresponsivebutton" onclick="ckSwitchResponsive(3)" data-range="3"><span class="fack fack-tablet" ></span> <?php echo TCK_Text::_('CK_TABLET') ?> / <small><?php echo TCK_Text::_('CK_PORTRAIT') ?></small></span>
			<input type="text" class="inputbox" name="responsivevalue2" id="responsivevalue2" onchange="checkreponsivevalues(this)">
		</span></div>
		<div><span class="ckbutton-group">
			<span id="ckresponsive4button" class="ckbutton ckresponsivebutton" onclick="ckSwitchResponsive(4)" data-range="4"><span class="fack fack-tablet" style="font-size: 1.4em;vertical-align: bottom;transform:rotate(90deg);"></span> <?php echo TCK_Text::_('CK_TABLET') ?> / <small><?php echo TCK_Text::_('CK_LANDSCAPE') ?></small></span>
			<input type="text" class="inputbox" name="responsivevalue3" id="responsivevalue3" onchange="checkreponsivevalues(this)">
		</span></div>
		<div><span class="ckbutton-group">
			<span id="ckresponsive5button" class="ckbutton ckresponsivebutton" onclick="ckSwitchResponsive(5)" data-range="5"><span class="fack fack-desktop" ></span> <?php echo TCK_Text::_('CK_COMPUTER') ?></span>
		</span></div>
	</div>
	<div class="ckproperty" data-id="tab_responsive">
		<div class="ckoption">
			<?php $this->interface->createLabel('CK_RESPONSIVE_RANGE', 'ipod.png') ?>
			<span class="ckoption-field">
				<select class="inputbox" type="list" name="responsiverange" id="responsiverange" value="" style="width:105px;" onchange="" >
					<option value="between"><?php echo TCK_Text::_('CK_RESPONSIVE_BETWEEN'); ?></option>
					<option value="reducing"><?php echo TCK_Text::_('CK_RESPONSIVE_REDUCING'); ?></option>
				</select>
			</span>
			<span class="ckoption-desc ckoption-desc-under"><?php echo TCK_Text::_('CK_RESPONSIVE_RANGE_DESC'); ?></span>
		</div>
		<?php if (! $isFluid) { ?>
		<div class="ckoption">
			<?php $this->interface->createLabel('CK_RESPONSIVE_MINI_VALUE', 'width.png') ?>
			<span class="ckoption-field">
				<input type="text" placeholder="292" class="inputbox" name="responsiveminivalue" id="responsiveminivalue" value="" style="width:100px;" />
			</span>
			<span class="ckoption-desc ckoption-desc-under"><?php echo TCK_Text::_('CK_RESPONSIVE_MINI_VALUE_DESC'); ?></span>
		</div>
		<?php } ?>
	</div>
	<div id="ckresponsivecustomcsscont">
		<div class="ckinterfacesliderlinks">
			<div id="ckresponsivecustomcsssliderlink" class="ckinterfacesliderlink" onclick="ckToggleResponsiveCustomCss();"><?php echo TCK_Text::_('CK_CUSTOMCSS_RESPONSIVE'); ?></div>
		</div>
		<div id="ckresponsivecustomcss">
			<div class="ckinterfacesliderback" onclick="ckSaveResponsivePopup();ckToggleResponsiveCustomCss();">
				<button class="ckinterfaceslider-back-button" tabindex="0" >
				</button>
				<div class="ckinterfaceslidertitle"><?php echo TCK_Text::_('CK_CLOSE') ?></div>
			</div>
			<div class="" style="padding:10px;font-style:italic;"><?php echo TCK_Text::_('CK_CUSTOM_CSS_RESPONSIVE_DESC'); ?></div>
			<div class="ckblocresolutions">
		<?php
		$i = 0;
		foreach ($resolutions as $resolution) {
			?>
			
				<div id="ckresponsive<?php echo $resolution; ?>" class="ckblocresolution">
					<div class="resolution-title"><?php echo TCK_Text::_('CK_RESPONSIVE' . $resolution); ?></div>
					<?php
					$code = '';
					if (isset($customcss[2][$i])) {
						$code = $customcss[2][$i];
						$code = str_replace('|bbe|', ']', $code);
						$code = str_replace('|qq|', '"', $code);
					}
					?>
					<div>
						<div class="responsiveCustomcodelabel" title="<?php echo TCK_Text::_('CK_CUSTOMCSS_RESPONSIVE_DESC'); ?>"><?php echo TCK_Text::_('CK_CUSTOMCSS'); ?></div>
						<textarea class="responsiveCustomcode" id="responsiveCustomCss<?php echo $resolution ?>" data-resolution="<?php echo $resolution ?>"><?php echo $code; ?></textarea>
					</div>
				</div>
			
				<?php
				$i++;
		}
		?>
			</div>
		</div>
	</div>
</div>
<script>
function changeResponsive(el, type) {
	el = $ck(el);
	var ckmobile = el.attr('ckmobile');
	switch (type)
	{
		case 'mainbanner':
			responsivechoice = new Array("mobile_default", "mobile_notaligned", "mobile_hide", "mobile_hamburger");
			break;
		case 'flexiblemodules':
			responsivechoice = new Array("mobile_default", "mobile_hide", "mobile_alignhalf", "mobile_notaligned");
			break;
		case 'maincontent':
			responsivechoice = new Array("mobile_default", "mobile_lefttop", "mobile_lefthidden", "mobile_rightbottom", "mobile_righthidden", "mobile_notaligned");
			break;
		case 'singlemodule':
			responsivechoice = new Array("mobile_default", "mobile_hide");
			break;
		case 'custombloc':
			responsivechoice = new Array("mobile_default", "mobile_hide");
			break;
		case 'horiznav':
			responsivechoice = new Array("mobile_default", "mobile_hide", "mobile_alignhalf", "mobile_notaligned", "mobile_hamburger");
			break;
		case 'row':
			responsivechoice = new Array("mobile_default", "mobile_hide", "mobile_notaligned");
			break;
		case 'logo':
			responsivechoice = new Array("mobile_default", "mobile_hide");
			break;
		default:
			break;
	}
	var index = ($ck.inArray(ckmobile, responsivechoice) + 1 < responsivechoice.length) ? $ck.inArray(ckmobile, responsivechoice) + 1 : 0;
	el.attr('ckmobile', responsivechoice[index]);
}

function highlightchild(tag) {
	$ck('.blocresolution .responsive[ckid="' + tag + '"]').css('background-color', '#999');
}

function unhighlightchild(tag) {
	$ck('.blocresolution .responsive[ckid="' + tag + '"]').css('background-color', '');
}

function checkreponsivevalues(field) {
	var defaultvalues = '524,758,950,1024';
	defaultvalues = defaultvalues.split(',');
	var values = new Array();
	$ck('.blocresolution .resolution-value input').each(function() {
		values.push(this.value);
	});
	var i = $ck('.blocresolution .resolution-value input').index($ck(field));


		$valCur = parseInt(field.value);

		$valPrev = values[i-1] ? parseInt(values[i-1]) : 0;
		$valNext = parseInt(values[i+1]);

		// check if not under the previous value
		if ( ($valPrev && $valPrev >= $valCur) 
			|| ($valNext && $valNext <= $valCur) ) {
			alert('<?php echo TCK_Text::_('CK_RESPONSIVE_VALUE_SHALL_BE_BETWEEN') ?> ' + $valPrev + ' & ' + ($valNext ? $valNext : ' Infinity') );
			field.value = $ck(field).attr('data-value');
		}
}

</script>