<?php

/**
 * Modified for Template Creator CK by Cédric KEIFLIN
 * @copyright	Copyright (C) 2011 Cédric KEIFLIN alias ced1870
 * https://www.template-creator.com
 * Component Template Creator CK
 * @license		GNU/GPL
 * */
// No direct access
defined('TCK_LOADED') or die('Restricted access');

include_once TEMPLATECREATORCK_PATH . '/helpers/zip.php';

class ZipArchiver extends stdClass {
	/* creates a compressed zip file */

	function create($files = array(), $destination = '', $path = '', $overwrite = true) {
		$ds = DIRECTORY_SEPARATOR;
		$files = TCK_Folder::files($path, false, true, true);

		if (file_exists($path . $destination) && !$overwrite) {
			return false;
		}

		//  Check to see if directory for archive exists
		if (!TCK_Folder::exists($path)) {
			//  Try to create the directory if it does not exists
			if (!TCK_Folder::create($path)) {
				//  Raise error, unable to create dir
				$this->setError('Unable to create directory for archive');
				return false;
			}
		}

		//  Check if archive exists
//		$archiveFilePath = $path . $destination;
		if (file_exists($destination)) {
			//  If overwrite flag is set
			if ($overwrite) {
				//  Delete archive
				TCK_File::delete($destination);
			} else {
				//  Set error and return
				$this->setError('Archive exists');
				return false;
			}
		}

		//  Prepare files for the zip archiver
		$filesToZip = array();
		$path = $this->cleanPath($path);
		foreach ($files as $file) {
			if (file_exists($file)) {
				$file = $this->cleanPath($file);
				$filename = str_replace($path . '/', '', $file);
				$filesToZip[] = array(
					'data' => file_get_contents($file),
					'name' => $filename
				);
			}
		}

		//  Create ZIP archiver
		$archiver = new CKArchiveZip();

		//  Create Archive
		$isSuccess = $archiver->create($destination, $filesToZip);

		//  Check of operation was successful
		if (!$isSuccess) {
			//  Set Error
			$this->setError('Unable to create archive');
		}

		//
		return $isSuccess;
	}

	protected function cleanPath($path) {
//		$ds = DIRECTORY_SEPARATOR;
//		$path = str_replace("/", $ds, $path);
		$path = str_replace("\\", '/', $path);

		return $path;
	}

}