/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

function ckAutoCreateThumbs() {
	// auto generate thumbnail
	if (!$ck('#body .tab_systemimagesstyles').attr('template_thumbnailsystemimageurl')) {
		html2canvas($ck('#body'), {
			onrendered: function(canvas) {
				var dataImage = canvas.toDataURL("image/png");
				var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxAutoCreateThumbs&" + CKTOKEN;
				$ck.ajax({
					type: "POST",
					url: myurl,
					async: true,
					data: {
						data: dataImage,
						templatename: $ck('#name').attr('value'),
					}
				});
			}
		});
	}
}

function ckInstallTemplate() {
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=interface.load&layout=ajaxinstalltemplate&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		dataType: "json",
		data: {
			templatename: $ck('#name').val()
		}
	}).done(function(response) {
		if (response.type == 'error') {
			msg = '<p class="badgeck errorck">' + response.message + '</p>';
		} else {
			msg = '<p class="badgeck successck">' + response.message + '</p>';
		}
		$ck('#ckpopup').prepend(msg); // mettre le message dans la fenetre avec toues les autres messages
		if (response.result == 'true') {
			// change the install button to copy
			$ck('#ckmenuinstalltemplate').hide();
			$ck('#ckmenucopytemplate').show();
			$ck('#ckquickapply').show();
			$ck('#ckquickinstall').hide();
		}
	}).fail(function() {
		alert('Failed : Template installation');
	});
}

function ckGetBlockHtml(bloc, j, nbtabs) {
	if (! nbtabs) nbtabs = 0;
	var retrievecode = new Array('head', 'body', 'css');
	retrievecode['head'] = '';
	retrievecode['body'] = '';
	retrievecode['css'] = '';

	// construct single module code
	if (bloc.hasClass('singlemodule') || bloc.hasClass('module')) {
		retrievecode = ckMakeHtmlSingleModule(bloc, nbtabs);
	}

	// construct row code
	if (bloc.hasClass('ckrow')) {
		retrievecode = ckMakeHtmlRow(bloc, j, nbtabs);
	}

	// construct logo code
	if (bloc.hasClass('logobloc')) {
		retrievecode = ckMakeHtmlLogo(bloc, nbtabs);
	}

	// construct flexible module code
	if (bloc.hasClass('flexiblemodules')) {
		retrievecode = ckMakeHtmlFlexibleModules(bloc, j, nbtabs);
	}

	// construct banner and logo block code
	if (bloc.hasClass('mainbanner') && !$ck('.bannermenu', bloc).length) {
		retrievecode = ckMakeHtmlOldBanner(bloc, nbtabs);
	} else if (bloc.hasClass('mainbanner') && $ck('.bannermenu', bloc).length) {
		retrievecode = ckMakeHtmlBanner(bloc, nbtabs);
	}

	// construct horizontal menu code
	if (bloc.hasClass('horiznav')) {
		retrievecode = ckMakeHtmlHorizNav(bloc, nbtabs);
	}

	// construct custom block code
	if (bloc.hasClass('custombloc')) {
		var customcode = $ck('div.customcont', bloc).text().replace(/#/g, "|di|");
		retrievecode['body'] += '|tab|<div id="' + bloc.attr('id') + '" class="' + bloc.attr('ckclass') + '">|rr|'
					+ '|tab||tab|<div class="inner">' + customcode + '</div>|rr|'
					+ '|tab|</div>|rr|';
	}

	if (bloc.hasClass('emptybloc')) {
		retrievecode['body'] += '|tab|<div id="' + bloc.attr('id') + '" class="' + bloc.attr('ckclass') + '">|rr|'
					+ '|tab|</div>|rr|';
	}
	// construct complex component layout code
	var hidemaincontent = ckGetPropsForBloc('body', 'tab_page_settings');
	hidemaincontent = hidemaincontent.attr('blochidefrontpage') ? hidemaincontent.attr('blochidefrontpage') : '0';
	if (bloc.hasClass('maincontent')) {
		retrievecode = ckMakeHtmlMaincontent(bloc, j, nbtabs);
		if (hidemaincontent == '1') {
			retrievecode['body'] = '|tab|<?php if(! $siteHome) { ?>|rr|' + retrievecode['body'] + '|tab|<?php } ?>|rr|';
		}
	}

	if (! retrievecode['css']) retrievecode['css'] = '';

	return retrievecode;
}