/* jce - 2.9.89 | 2025-07-16 | https://www.joomlacontenteditor.net | Source: https://github.com/widgetfactory/jce | Copyright (C) 2006 - 2025 Ryan Demmer. All rights reserved | GNU/GPL Version 2 or later - http://www.gnu.org/licenses/gpl-2.0.html */
!function() {
    "use strict";
    var isArray = Array.isArray || function(obj) {
        return "[object Array]" === Object.prototype.toString.call(obj);
    };
    function each$3(o, cb, s) {
        var n, l;
        if (!o) return 0;
        if (s = s || o, void 0 !== o.length) {
            for (n = 0, l = o.length; n < l; n++) if (!1 === cb.call(s, o[n], n, o)) return 0;
        } else for (n in o) if (o.hasOwnProperty(n) && !1 === cb.call(s, o[n], n, o)) return 0;
        return 1;
    }
    function map(array, callback) {
        var out = [];
        return each$3(array, function(item, index) {
            out.push(callback(item, index, array));
        }), out;
    }
    function indexOf$1(a, v) {
        var i, l;
        if (a) for (i = 0, l = a.length; i < l; i++) if (a[i] === v) return i;
        return -1;
    }
    function findIndex(array, predicate, thisArg) {
        for (var i = 0, l = array.length; i < l; i++) if (predicate.call(thisArg, array[i], i, array)) return i;
        return -1;
    }
    function flat(arr) {
        for (var out = [], i = 0, l = arr.length; i < l; i++) isArray(arr[i]) && Array.prototype.push.apply(out, arr[i]);
        return out;
    }
    function flatMap(array, callback) {
        return flat(map(array, callback));
    }
    var Arr = {
        isArray: isArray,
        toArray: function(obj) {
            var i, l, array = obj;
            if (!isArray(obj)) for (array = [], i = 0, l = obj.length; i < l; i++) array[i] = obj[i];
            return array;
        },
        each: each$3,
        map: map,
        filter: function(a, f) {
            var o = [];
            return each$3(a, function(v, index) {
                f && !f(v, index, a) || o.push(v);
            }), o;
        },
        indexOf: indexOf$1,
        reduce: function(collection, iteratee, accumulator, thisArg) {
            var i = 0;
            for (arguments.length < 3 && (accumulator = collection[0]); i < collection.length; i++) accumulator = iteratee.call(thisArg, accumulator, collection[i], i);
            return accumulator;
        },
        findIndex: findIndex,
        find: function(array, predicate, thisArg) {
            if (-1 !== (predicate = findIndex(array, predicate, thisArg))) return array[predicate];
        },
        last: function(collection) {
            return collection[collection.length - 1];
        },
        toObject: function(array, callback) {
            for (var object = {}, i = 0, l = array.length; i < l; i++) {
                var x = array[i];
                object[x] = callback(x, i);
            }
            return object;
        },
        flat: flat,
        flatMap: flatMap,
        bind: flatMap,
        contains: function(a, v) {
            return -1 < indexOf$1(a, v);
        },
        forall: function(xs, pred) {
            for (var i = 0, len = xs.length; i < len; ++i) if (!0 !== pred(xs[i], i)) return !1;
            return !0;
        }
    }, whiteSpaceRegExp$1 = /^\s*|\s*$/g;
    function trim$3(str) {
        return null == str ? "" : ("" + str).replace(whiteSpaceRegExp$1, "");
    }
    function is(obj, type) {
        return type ? !("array" != type || !Arr.isArray(obj)) || typeof obj == type : void 0 !== obj;
    }
    var extendClass, initializing, Tools$6 = {
        trim: trim$3,
        isArray: Arr.isArray,
        is: is,
        toArray: Arr.toArray,
        makeMap: function(items, delim, map) {
            var i;
            for (delim = delim || ",", map = map || {}, i = (items = "string" == typeof (items = items || []) ? items.split(delim) : items).length; i--; ) map[items[i]] = {};
            return map;
        },
        each: Arr.each,
        map: Arr.map,
        grep: Arr.filter,
        inArray: Arr.indexOf,
        hasOwn: function(obj, prop) {
            return Object.prototype.hasOwnProperty.call(obj, prop);
        },
        extend: function(obj, ext) {
            for (var name, value, args = arguments, i = 1, l = args.length; i < l; i++) for (name in ext = args[i]) ext.hasOwnProperty(name) && void 0 !== (value = ext[name]) && (obj[name] = value);
            return obj;
        },
        create: function(s, p, root) {
            var sp, ns, cn, scn, c, de = 0;
            s = /^((static) )?([\w.]+)(:([\w.]+))?/.exec(s), cn = s[3].match(/(^|\.)(\w+)$/i)[2], 
            (ns = this.createNS(s[3].replace(/\.\w+$/, ""), root))[cn] || ("static" == s[2] ? (ns[cn] = p, 
            this.onCreate && this.onCreate(s[2], s[3], ns[cn])) : (p[cn] || (p[cn] = function() {}, 
            de = 1), ns[cn] = p[cn], this.extend(ns[cn].prototype, p), s[5] && (sp = this.resolve(s[5]).prototype, 
            scn = s[5].match(/\.(\w+)$/i)[1], c = ns[cn], ns[cn] = de ? function() {
                return sp[scn].apply(this, arguments);
            } : function() {
                return this.parent = sp[scn], c.apply(this, arguments);
            }, ns[cn].prototype[cn] = ns[cn], this.each(sp, function(f, n) {
                ns[cn].prototype[n] = sp[n];
            }), this.each(p, function(f, n) {
                sp[n] ? ns[cn].prototype[n] = function() {
                    return this.parent = sp[n], f.apply(this, arguments);
                } : n != cn && (ns[cn].prototype[n] = f);
            })), this.each(p.static, function(f, n) {
                ns[cn][n] = f;
            })));
        },
        walk: function walk(o, f, n, s) {
            s = s || this, o && (n && (o = o[n]), Arr.each(o, function(o, i) {
                if (!1 === f.call(s, o, i, n)) return !1;
                walk(o, f, n, s);
            }));
        },
        createNS: function(n, o) {
            var i, v;
            for (o = o || window, n = n.split("."), i = 0; i < n.length; i++) o[v = n[i]] || (o[v] = {}), 
            o = o[v];
            return o;
        },
        resolve: function(n, o) {
            var i, l;
            for (o = o || window, i = 0, l = (n = n.split(".")).length; i < l && (o = o[n[i]]); i++);
            return o;
        },
        explode: function(s, d) {
            return !s || is(s, "array") ? s : Arr.map(s.split(d || ","), trim$3);
        },
        ucfirst: function(str) {
            return str[0].toUpperCase() + str.slice(1);
        }
    }, each$2 = Tools$6.each, extend = Tools$6.extend;
    function Class() {}
    Class.extend = extendClass = function(prop) {
        var prototype, name, member, _super = this.prototype;
        function Class() {
            var i, mixins, mixin;
            if (!initializing && (this.init && this.init.apply(this, arguments), 
            mixins = this.Mixins)) for (i = mixins.length; i--; ) (mixin = mixins[i]).init && mixin.init.apply(this, arguments);
        }
        function dummy() {
            return this;
        }
        for (name in initializing = !0, prototype = new this(), initializing = !1, 
        prop.Mixins && (each$2(prop.Mixins, function(mixin) {
            for (var name in mixin) "init" !== name && (prop[name] = mixin[name]);
        }), _super.Mixins) && (prop.Mixins = _super.Mixins.concat(prop.Mixins)), 
        prop.Methods && each$2(prop.Methods.split(","), function(name) {
            prop[name] = dummy;
        }), prop.Properties && each$2(prop.Properties.split(","), function(name) {
            var fieldName = "_" + name;
            prop[name] = function(value) {
                return void 0 !== value ? (this[fieldName] = value, this) : this[fieldName];
            };
        }), prop.Statics && each$2(prop.Statics, function(func, name) {
            Class[name] = func;
        }), prop.Defaults && _super.Defaults && (prop.Defaults = extend({}, _super.Defaults, prop.Defaults)), 
        prop) "function" == typeof (member = prop[name]) && _super[name] ? prototype[name] = function(name, fn) {
            return function() {
                var ret, tmp = this._super;
                return this._super = _super[name], ret = fn.apply(this, arguments), 
                this._super = tmp, ret;
            };
        }(name, member) : prototype[name] = member;
        return Class.prototype = prototype, (Class.constructor = Class).extend = extendClass, 
        Class;
    };
    var Layout = Class.extend({
        init: function(settings) {
            this.settings = Tools$6.extend({}, this.Defaults, settings);
        },
        preRender: function(container) {
            container.bodyClasses.add(this.settings.containerClass), this.settings.align && container.bodyClasses.add(this.settings.containerClass + "-" + this.settings.align);
        },
        renderHtml: function(container) {
            var self = this, html = "";
            return container.items().each(function(item) {
                item.classes.add(self.settings.controlClass || ""), html += item.renderHtml();
            }), html;
        },
        postRender: function() {},
        isNative: function() {
            return !1;
        }
    }), AbsoluteLayout = Layout.extend({
        Defaults: {
            containerClass: "abs-layout",
            controlClass: "abs-layout-item"
        },
        renderHtml: function(container) {
            return '<div id="' + container._id + '-absend" class="' + container.classPrefix + 'abs-end"></div>' + this._super(container);
        }
    });
    function noop$3() {}
    function ClassList(onchange) {
        this.cls = [], this.cls._map = {}, this.onchange = onchange || noop$3, this.prefix = "";
    }
    Tools$6.extend(ClassList.prototype, {
        add: function(cls) {
            return cls && !this.contains(cls) && (this.cls._map[cls] = !0, this.cls.push(cls), 
            this._change()), this;
        },
        remove: function(cls) {
            if (this.contains(cls)) {
                for (var i = 0; i < this.cls.length && this.cls[i] !== cls; i++);
                this.cls.splice(i, 1), delete this.cls._map[cls], this._change();
            }
            return this;
        },
        toggle: function(cls, state) {
            var curState = this.contains(cls);
            return curState !== state && (curState ? this.remove(cls) : this.add(cls), 
            this._change()), this;
        },
        contains: function(cls) {
            return !!this.cls._map[cls];
        },
        _change: function() {
            delete this.clsValue, this.onchange.call(this);
        }
    }), ClassList.prototype.toString = function() {
        if (this.clsValue) return this.clsValue;
        for (var value = "", i = 0; i < this.cls.length; i++) 0 < i && (value += " "), 
        value += this.prefix + this.cls[i];
        return value;
    };
    function Binding(settings) {
        this.create = settings.create;
    }
    var Collection$2, Collection, expression = /^([\w\\*]+)?(?:#([\w\-\\]+))?(?:\.([\w\\\.]+))?(?:\[\@?([\w\\]+)([\^\$\*!~]?=)([\w\\]+)\])?(?:\:(.+))?/i, chunker = /((?:\((?:\([^()]+\)|[^()]+)+\)|\[(?:\[[^\[\]]*\]|['"][^'"]*['"]|[^\[\]'"]+)+\]|\\.|[^ >+~,(\[\\]+)+|[>+~])(\s*,\s*)?((?:.|\r|\n)*)/g, whiteSpace = /^\s*|\s*$/g, Selector = Class.extend({
        init: function(selector) {
            var match = this.match;
            function compile(selector, filters, direct) {
                function add(filter) {
                    filter && filters.push(filter);
                }
                return add(function(name) {
                    if (name) return name = name.toLowerCase(), function(item) {
                        return "*" === name || item.type === name;
                    };
                }((selector = expression.exec(selector.replace(whiteSpace, "")))[1])), 
                add(function(id) {
                    if (id) return function(item) {
                        return item._name === id;
                    };
                }(selector[2])), add(function(classes) {
                    if (classes) return classes = classes.split("."), function(item) {
                        for (var i = classes.length; i--; ) if (!item.classes.contains(classes[i])) return !1;
                        return !0;
                    };
                }(selector[3])), add(function(name, cmp, check) {
                    if (name) return function(item) {
                        item = item[name] ? item[name]() : "";
                        return cmp ? "=" === cmp ? item === check : "*=" === cmp ? 0 <= item.indexOf(check) : "~=" === cmp ? 0 <= (" " + item + " ").indexOf(" " + check + " ") : "!=" === cmp ? item != check : "^=" === cmp ? 0 === item.indexOf(check) : "$=" === cmp && item.substr(item.length - check.length) === check : !!check;
                    };
                }(selector[4], selector[5], selector[6])), add(function(name) {
                    var notSelectors;
                    if (name) return (name = /(?:not\((.+)\))|(.+)/i.exec(name))[1] ? (notSelectors = parseChunks(name[1], []), 
                    function(item) {
                        return !match(item, notSelectors);
                    }) : (name = name[2], function(item, index, length) {
                        return "first" === name ? 0 === index : "last" === name ? index === length - 1 : "even" === name ? index % 2 == 0 : "odd" === name ? index % 2 == 1 : !!item[name] && item[name]();
                    });
                }(selector[7])), filters.pseudo = !!selector[7], filters.direct = direct, 
                filters;
            }
            function parseChunks(selector, selectors) {
                var extra, matches, i, parts = [];
                do {
                    if (chunker.exec(""), (matches = chunker.exec(selector)) && (selector = matches[3], 
                    parts.push(matches[1]), matches[2])) {
                        extra = matches[3];
                        break;
                    }
                } while (matches);
                for (extra && parseChunks(extra, selectors), selector = [], i = 0; i < parts.length; i++) ">" != parts[i] && selector.push(compile(parts[i], [], ">" === parts[i - 1]));
                return selectors.push(selector), selectors;
            }
            this._selectors = parseChunks(selector, []);
        },
        match: function(control, selectors) {
            for (var si, sl, selector, fi, fl, filters, index, length, siblings, count, item, i = 0, l = (selectors = selectors || this._selectors).length; i < l; i++) {
                for (item = control, count = 0, si = (sl = (selector = selectors[i]).length) - 1; 0 <= si; si--) for (filters = selector[si]; item; ) {
                    if (filters.pseudo) for (index = length = (siblings = item.parent().items()).length; index-- && siblings[index] !== item; );
                    for (fi = 0, fl = filters.length; fi < fl; fi++) if (!filters[fi](item, index, length)) {
                        fi = fl + 1;
                        break;
                    }
                    if (fi === fl) {
                        count++;
                        break;
                    }
                    if (si === sl - 1) break;
                    item = item.parent();
                }
                if (count === sl) return !0;
            }
            return !1;
        },
        find: function(container) {
            var i, l, matches = [], selectors = this._selectors;
            if (container.items) {
                for (i = 0, l = selectors.length; i < l; i++) !function collect(items, selector, index) {
                    for (var fi, fl, item, filters = selector[index], i = 0, l = items.length; i < l; i++) {
                        for (item = items[i], fi = 0, fl = filters.length; fi < fl; fi++) if (!filters[fi](item, i, l)) {
                            fi = fl + 1;
                            break;
                        }
                        if (fi === fl) index == selector.length - 1 ? matches.push(item) : item.items && collect(item.items(), selector, index + 1); else if (filters.direct) return;
                        item.items && collect(item.items(), selector, index);
                    }
                }(container.items(), selectors[i], 0);
                1 < l && (matches = function(array) {
                    for (var item, uniqueItems = [], i = array.length; i--; ) (item = array[i]).__checked || (uniqueItems.push(item), 
                    item.__checked = 1);
                    for (i = uniqueItems.length; i--; ) delete uniqueItems[i].__checked;
                    return uniqueItems;
                }(matches));
            }
            return new (Collection$2 = Collection$2 || Selector.Collection)(matches);
        }
    }), push$2 = Array.prototype.push, slice$2 = Array.prototype.slice, proto$1 = {
        length: 0,
        init: function(items) {
            items && this.add(items);
        },
        add: function(items) {
            return Tools$6.isArray(items) ? push$2.apply(this, items) : items instanceof Collection ? this.add(items.toArray()) : push$2.call(this, items), 
            this;
        },
        set: function(items) {
            var i, len = this.length;
            for (this.length = 0, this.add(items), i = this.length; i < len; i++) delete this[i];
            return this;
        },
        filter: function(selector) {
            for (var item, matches = [], match = "string" == typeof selector ? (selector = new Selector(selector), 
            function(item) {
                return selector.match(item);
            }) : selector, i = 0, l = this.length; i < l; i++) match(item = this[i]) && matches.push(item);
            return new Collection(matches);
        },
        slice: function() {
            return new Collection(slice$2.apply(this, arguments));
        },
        eq: function(index) {
            return -1 === index ? this.slice(index) : this.slice(index, +index + 1);
        },
        each: function(callback) {
            return Tools$6.each(this, callback), this;
        },
        toArray: function() {
            return Tools$6.toArray(this);
        },
        indexOf: function(ctrl) {
            for (var i = this.length; i-- && this[i] !== ctrl; );
            return i;
        },
        reverse: function() {
            return new Collection(Tools$6.toArray(this).reverse());
        },
        hasClass: function(cls) {
            return !!this[0] && this[0].classes.contains(cls);
        },
        prop: function(name, value) {
            var item;
            return void 0 !== value ? (this.each(function(item) {
                item[name] && item[name](value);
            }), this) : (item = this[0]) && item[name] ? item[name]() : void 0;
        },
        exec: function(name) {
            var args = Tools$6.toArray(arguments).slice(1);
            return this.each(function(item) {
                item[name] && item[name].apply(item, args);
            }), this;
        },
        remove: function() {
            for (var i = this.length; i--; ) this[i].remove();
            return this;
        },
        addClass: function(cls) {
            return this.each(function(item) {
                item.classes.add(cls);
            });
        },
        removeClass: function(cls) {
            return this.each(function(item) {
                item.classes.remove(cls);
            });
        }
    }, Collection$1 = (Tools$6.each("dispatch on off show hide append prepend before after".split(" "), function(name) {
        proto$1[name] = function() {
            var args = Tools$6.toArray(arguments);
            return this.each(function(ctrl) {
                name in ctrl && ctrl[name].apply(ctrl, args);
            }), this;
        };
    }), Tools$6.each("text name disabled active selected checked visible parent value data".split(" "), function(name) {
        proto$1[name] = function(value) {
            return this.prop(name, value);
        };
    }), Collection = Class.extend(proto$1), Selector.Collection = Collection), nativeEvents = (Binding.create = function(model, name) {
        return new Binding({
            create: function(otherModel, otherName) {
                function fromSelfToOther(e) {
                    otherModel.set(otherName, e.value);
                }
                var bindings;
                return otherModel.on("change:" + otherName, function(e) {
                    model.set(name, e.value);
                }), model.on("change:" + name, fromSelfToOther), (bindings = otherModel._bindings) || (bindings = otherModel._bindings = [], 
                otherModel.on("destroy", function() {
                    for (var i = bindings.length; i--; ) bindings[i]();
                })), bindings.push(function() {
                    model.off("change:" + name, fromSelfToOther);
                }), model.get(name);
            }
        });
    }, Tools$6.makeMap("focus blur focusin focusout click dblclick mousedown mouseup mousemove mouseover beforepaste paste cut copy selectionchange mouseout mouseenter mouseleave wheel keydown keypress keyup input contextmenu dragstart dragend dragover draggesture dragdrop drop drag submit compositionstart compositionend compositionupdate touchstart touchmove touchend", " "));
    function Dispatcher(settings) {
        var scope, toggleEvent, self = this, bindings = {};
        function returnFalse() {
            return !1;
        }
        function returnTrue() {
            return !0;
        }
        function on(name, callback, prepend, extra) {
            var handlers, names, i;
            if (callback = !1 === callback ? returnFalse : callback) for (callback = {
                func: callback
            }, extra && Tools$6.extend(callback, extra), i = (names = name.toLowerCase().split(" ")).length; i--; ) name = names[i], 
            (handlers = bindings[name]) || (handlers = bindings[name] = [], toggleEvent(name, !0)), 
            prepend ? handlers.unshift(callback) : handlers.push(callback);
            return self;
        }
        function off(name, callback) {
            var i, handlers, bindingName, names, hi;
            if (name) for (i = (names = name.toLowerCase().split(" ")).length; i--; ) {
                if (name = names[i], handlers = bindings[name], !name) {
                    for (bindingName in bindings) toggleEvent(bindingName, !1), 
                    delete bindings[bindingName];
                    return self;
                }
                if (handlers) {
                    if (callback) for (hi = handlers.length; hi--; ) handlers[hi].func === callback && (handlers = handlers.slice(0, hi).concat(handlers.slice(hi + 1)), 
                    bindings[name] = handlers); else handlers.length = 0;
                    handlers.length || (toggleEvent(name, !1), delete bindings[name]);
                }
            } else {
                for (name in bindings) toggleEvent(name, !1);
                bindings = {};
            }
            return self;
        }
        scope = (settings = settings || {}).scope || self, toggleEvent = settings.toggleEvent || returnFalse, 
        self.dispatch = function(name, args) {
            var handlers, i, l, callback;
            if (name = name.toLowerCase(), (args = args || {}).type = name, args.target || (args.target = scope), 
            args.preventDefault || (args.preventDefault = function() {
                args.isDefaultPrevented = returnTrue;
            }, args.stopPropagation = function() {
                args.isPropagationStopped = returnTrue;
            }, args.stopImmediatePropagation = function() {
                args.isImmediatePropagationStopped = returnTrue;
            }, args.isDefaultPrevented = returnFalse, args.isPropagationStopped = returnFalse, 
            args.isImmediatePropagationStopped = returnFalse), settings.beforeFire && settings.beforeFire(args), 
            handlers = bindings[name]) for (i = 0, l = handlers.length; i < l; i++) {
                if ((callback = handlers[i]).once && off(name, callback.func), args.isImmediatePropagationStopped()) return args.stopPropagation(), 
                args;
                if (!1 === callback.func.call(scope, args)) return args.preventDefault(), 
                args;
            }
            return args;
        }, self.on = on, self.off = off, self.once = function(name, callback, prepend) {
            return on(name, callback, prepend, {
                once: !0
            });
        }, self.has = function(name) {
            return name = name.toLowerCase(), !(!bindings[name] || 0 === bindings[name].length);
        };
    }
    function getEventDispatcher$1(obj) {
        return obj._eventDispatcher || (obj._eventDispatcher = new Dispatcher({
            scope: obj,
            toggleEvent: function(name, state) {
                Dispatcher.isNative(name) && obj.toggleNativeEvent && obj.toggleNativeEvent(name, state);
            }
        })), obj._eventDispatcher;
    }
    function isNode(node) {
        return 0 < node.nodeType;
    }
    Dispatcher.isNative = function(name) {
        return !!nativeEvents[name.toLowerCase()];
    };
    var ObservableObject = Class.extend({
        Mixins: [ {
            dispatch: function(name, args, bubble) {
                if ((!this.removed || "remove" === name) && (args = getEventDispatcher$1(this).dispatch(name, args, bubble), 
                !1 !== bubble) && this.parent) for (var parent = this.parent(); parent && !args.isPropagationStopped(); ) parent.dispatch(name, args, !1), 
                parent = parent.parent();
                return args;
            },
            on: function(name, callback, prepend) {
                return getEventDispatcher$1(this).on(name, callback, prepend);
            },
            off: function(name, callback) {
                return getEventDispatcher$1(this).off(name, callback);
            },
            once: function(name, callback) {
                return getEventDispatcher$1(this).once(name, callback);
            },
            hasEventListeners: function(name) {
                return getEventDispatcher$1(this).has(name);
            }
        } ],
        init: function(data) {
            var name, value;
            for (name in data = data || {}) (value = data[name]) instanceof Binding && (data[name] = value.create(this, name));
            this.data = data;
        },
        set: function(name, value) {
            var key, oldValue = this.data[name];
            if (value instanceof Binding && (value = value.create(this, name)), 
            "object" == typeof name) for (key in name) this.set(key, name[key]); else !function isEqual(a, b) {
                var k, checked;
                if (a !== b) {
                    if (null === a || null === b) return a === b;
                    if ("object" != typeof a || "object" != typeof b) return a === b;
                    if (Tools$6.isArray(b)) {
                        if (a.length !== b.length) return;
                        for (k = a.length; k--; ) if (!isEqual(a[k], b[k])) return;
                    }
                    if (isNode(a) || isNode(b)) return a === b;
                    for (k in checked = {}, b) {
                        if (!isEqual(a[k], b[k])) return;
                        checked[k] = !0;
                    }
                    for (k in a) if (!checked[k] && !isEqual(a[k], b[k])) return;
                }
                return 1;
            }(oldValue, value) && (this.data[name] = value, this.dispatch("change:" + name, value = {
                target: this,
                name: name,
                value: value,
                oldValue: oldValue
            }), this.dispatch("change", value));
            return this;
        },
        get: function(name) {
            return this.data[name];
        },
        has: function(name) {
            return name in this.data;
        },
        bind: function(name) {
            return Binding.create(this, name);
        },
        destroy: function() {
            this.dispatch("destroy");
        }
    }), nav = navigator, userAgent = nav.userAgent;
    function matchMediaQuery(query) {
        return "matchMedia" in window && matchMedia(query).matches;
    }
    var opera = window.opera && window.opera.buildNumber, android = /Android/.test(userAgent), nav = !(webkit = /WebKit/.test(userAgent)) && !opera && /MSIE/gi.test(userAgent) && /Explorer/gi.test(nav.appName) && /MSIE (\w+)\./.exec(userAgent)[1] && !webkit, gecko = !webkit && !nav && /Gecko/.test(userAgent), mac = -1 != userAgent.indexOf("Mac"), iDevice = /(iPad|iPhone)/.test(userAgent), fileApi = "FormData" in window && "FileReader" in window && "URL" in window && !!URL.createObjectURL, phone = matchMediaQuery("only screen and (max-device-width: 480px)") && (android || iDevice), tablet = matchMediaQuery("only screen and (min-width: 800px)") && (android || iDevice), windowsPhone = -1 != userAgent.indexOf("Windows Phone"), Env$1 = {
        opera: opera,
        webkit: webkit,
        ie: nav,
        gecko: gecko,
        mac: mac,
        iOS: iDevice,
        android: android,
        contentEditable: !iDevice || fileApi || 534 <= userAgent.match(/AppleWebKit\/(\d*)/)[1],
        transparentSrc: "data:image/gif;base64,R0lGODlhAQABAIAAAAAAAP///yH5BAEAAAAALAAAAAABAAEAAAIBRAA7",
        caretAfter: !0,
        range: window.getSelection && "Range" in window,
        fileApi: fileApi,
        ceFalse: !0,
        canHaveCSP: !0,
        desktop: !phone && !tablet,
        windowsPhone: windowsPhone
    }, mouseEventRe = /^(?:mouse|contextmenu)|click/, deprecated = {
        keyLocation: 1,
        layerX: 1,
        layerY: 1,
        returnValue: 1,
        webkitMovementX: 1,
        webkitMovementY: 1,
        keyIdentifier: 1,
        mozPressure: 1
    }, hasIsDefaultPrevented = function(event) {
        return event.isDefaultPrevented === returnTrue || event.isDefaultPrevented === returnFalse;
    }, returnFalse = function() {
        return !1;
    }, returnTrue = function() {
        return !0;
    };
    function addEvent(target, name, callback, capture) {
        target.addEventListener ? target.addEventListener(name, callback, capture || !1) : target.attachEvent && target.attachEvent("on" + name, callback);
    }
    function removeEvent(target, name, callback, capture) {
        target.removeEventListener ? target.removeEventListener(name, callback, capture || !1) : target.detachEvent && target.detachEvent("on" + name, callback);
    }
    function fix(originalEvent, data) {
        var name, doc, event = data || {};
        for (name in originalEvent) deprecated[name] || (event[name] = originalEvent[name]);
        return event.target || (event.target = event.srcElement || document), Env$1.experimentalShadowDom && (event.target = function(event, defaultTarget) {
            var path = event.path;
            return path && 0 < path.length && (defaultTarget = path[0]), defaultTarget = event.deepPath && (path = event.deepPath()) && 0 < path.length ? path[0] : defaultTarget;
        }(originalEvent, event.target)), originalEvent && mouseEventRe.test(originalEvent.type) && void 0 === originalEvent.pageX && void 0 !== originalEvent.clientX && (doc = (data = event.target.ownerDocument || document).documentElement, 
        data = data.body, event.pageX = originalEvent.clientX + (doc && doc.scrollLeft || data && data.scrollLeft || 0) - (doc && doc.clientLeft || data && data.clientLeft || 0), 
        event.pageY = originalEvent.clientY + (doc && doc.scrollTop || data && data.scrollTop || 0) - (doc && doc.clientTop || data && data.clientTop || 0)), 
        event.preventDefault = function() {
            event.isDefaultPrevented = returnTrue, originalEvent && (originalEvent.preventDefault ? originalEvent.preventDefault() : originalEvent.returnValue = !1);
        }, event.stopPropagation = function() {
            event.isPropagationStopped = returnTrue, originalEvent && (originalEvent.stopPropagation ? originalEvent.stopPropagation() : originalEvent.cancelBubble = !0);
        }, !(event.stopImmediatePropagation = function() {
            event.isImmediatePropagationStopped = returnTrue, event.stopPropagation();
        }) === hasIsDefaultPrevented(event) && (event.isDefaultPrevented = returnFalse, 
        event.isPropagationStopped = returnFalse, event.isImmediatePropagationStopped = returnFalse), 
        void 0 === event.metaKey && (event.metaKey = !1), event;
    }
    function bindOnReady(win, callback, eventUtils) {
        var doc = win.document, event = {
            type: "ready"
        };
        function readyHandler() {
            eventUtils.domLoaded || (eventUtils.domLoaded = !0, callback(event));
        }
        eventUtils.domLoaded ? callback(event) : ("complete" === doc.readyState || "interactive" === doc.readyState && doc.body ? readyHandler() : addEvent(win, "DOMContentLoaded", readyHandler), 
        addEvent(win, "load", readyHandler));
    }
    function EventUtils() {
        var count, expando, hasFocusIn, hasMouseEnterLeave, mouseEnterLeave, self = this, events = {};
        function executeHandlers(evt, id) {
            var i, l, callback, id = events[id], callbackList = id && id[evt.type];
            if (callbackList) for (i = 0, l = callbackList.length; i < l; i++) if ((callback = callbackList[i]) && !1 === callback.func.call(callback.scope, evt) && evt.preventDefault(), 
            evt.isImmediatePropagationStopped()) return;
        }
        expando = "mce-data-" + (+new Date()).toString(32), hasMouseEnterLeave = "onmouseenter" in document.documentElement, 
        hasFocusIn = "onfocusin" in document.documentElement, count = 1, self.domLoaded = !(mouseEnterLeave = {
            mouseenter: "mouseover",
            mouseleave: "mouseout"
        }), self.events = events, self.bind = function(target, names, callback, scope) {
            var id, callbackList, i, name, fakeName, nativeHandler, capture, win = window;
            function defaultNativeHandler(evt) {
                executeHandlers(fix(evt || win.event), id);
            }
            if (target && 3 !== target.nodeType && 8 !== target.nodeType) {
                for (target[expando] ? id = target[expando] : (id = count++, target[expando] = id, 
                events[id] = {}), scope = scope || target, i = (names = names.split(" ")).length; i--; ) nativeHandler = defaultNativeHandler, 
                fakeName = capture = !1, "DOMContentLoaded" === (name = names[i]) && (name = "ready"), 
                self.domLoaded && "ready" === name && "complete" == target.readyState ? callback.call(scope, fix({
                    type: name
                })) : (hasMouseEnterLeave || (fakeName = mouseEnterLeave[name]) && (nativeHandler = function(evt) {
                    var current = evt.currentTarget, related = evt.relatedTarget;
                    if (related && current.contains) related = current.contains(related); else for (;related && related !== current; ) related = related.parentNode;
                    related || ((evt = fix(evt || win.event)).type = "mouseout" === evt.type ? "mouseleave" : "mouseenter", 
                    evt.target = current, executeHandlers(evt, id));
                }), hasFocusIn || "focusin" !== name && "focusout" !== name || (capture = !0, 
                fakeName = "focusin" === name ? "focus" : "blur", nativeHandler = function(evt) {
                    (evt = fix(evt || win.event)).type = "focus" === evt.type ? "focusin" : "focusout", 
                    executeHandlers(evt, id);
                }), (callbackList = events[id][name]) ? "ready" === name && self.domLoaded ? callback({
                    type: name
                }) : callbackList.push({
                    func: callback,
                    scope: scope
                }) : (events[id][name] = callbackList = [ {
                    func: callback,
                    scope: scope
                } ], callbackList.fakeName = fakeName, callbackList.capture = capture, 
                callbackList.nativeHandler = nativeHandler, "ready" === name ? bindOnReady(target, nativeHandler, self) : addEvent(target, fakeName || name, nativeHandler, capture)));
                return target = callbackList = 0, callback;
            }
        }, self.unbind = function(target, names, callback) {
            var id, i, ci, name, eventMap, nativeHandler, fakeName, capture, callbackList;
            if (target && 3 !== target.nodeType && 8 !== target.nodeType && (id = target[expando])) {
                if (eventMap = events[id], names) {
                    for (i = (names = names.split(" ")).length; i--; ) if (callbackList = eventMap[name = names[i]]) {
                        if (callback) for (ci = callbackList.length; ci--; ) callbackList[ci].func === callback && (nativeHandler = callbackList.nativeHandler, 
                        fakeName = callbackList.fakeName, capture = callbackList.capture, 
                        (callbackList = callbackList.slice(0, ci).concat(callbackList.slice(ci + 1))).nativeHandler = nativeHandler, 
                        callbackList.fakeName = fakeName, callbackList.capture = capture, 
                        eventMap[name] = callbackList);
                        callback && 0 !== callbackList.length || (delete eventMap[name], 
                        removeEvent(target, callbackList.fakeName || name, callbackList.nativeHandler, callbackList.capture));
                    }
                } else {
                    for (name in eventMap) removeEvent(target, (callbackList = eventMap[name]).fakeName || name, callbackList.nativeHandler, callbackList.capture);
                    eventMap = {};
                }
                for (name in eventMap) return self;
                delete events[id];
                try {
                    delete target[expando];
                } catch (ex) {
                    target[expando] = null;
                }
            }
            return self;
        }, self.fire = function(target, name, args) {
            var id;
            if (target && 3 !== target.nodeType && 8 !== target.nodeType) for ((args = fix(null, args)).type = name, 
            args.target = target; (id = target[expando]) && executeHandlers(args, id), 
            (target = target.parentNode || target.ownerDocument || target.defaultView || target.parentWindow) && !args.isPropagationStopped(); );
            return self;
        }, self.clean = function(target) {
            var i, children, unbind = self.unbind;
            if (target && 3 !== target.nodeType && 8 !== target.nodeType && (target[expando] && unbind(target), 
            target = target.getElementsByTagName ? target : target.document) && target.getElementsByTagName) for (unbind(target), 
            i = (children = target.getElementsByTagName("*")).length; i--; ) (target = children[i])[expando] && unbind(target);
            return self;
        }, self.destroy = function() {
            events = {};
        }, self.cancel = function(e) {
            return e && (e.preventDefault(), e.stopImmediatePropagation()), !1;
        };
    }
    (EventUtils.Event = new EventUtils()).bind(window, "ready", function() {});
    function funescape(escape, nonHex) {
        return escape = "0x" + escape.slice(1) - 65536, nonHex || (escape < 0 ? String.fromCharCode(65536 + escape) : String.fromCharCode(escape >> 10 | 55296, 1023 & escape | 56320));
    }
    function fcssescape(ch, asCodePoint) {
        return asCodePoint ? "\0" === ch ? "\ufffd" : ch.slice(0, -1) + "\\" + ch.charCodeAt(ch.length - 1).toString(16) + " " : "\\" + ch;
    }
    function unloadHandler() {
        setDocument();
    }
    var i, support, Expr, getText$1, isXML, tokenize, compile, select$1, outermostContext, sortInput, hasDuplicate, setDocument, document$1, docElem, documentIsHTML, rbuggyQSA, rbuggyMatches, matches, contains, expando = "sizzle" + +new Date(), preferredDoc = window.document, dirruns = 0, done = 0, classCache = createCache(), tokenCache = createCache(), compilerCache = createCache(), nonnativeSelectorCache = createCache(), sortOrder = function(a, b) {
        return a === b && (hasDuplicate = !0), 0;
    }, hasOwn = {}.hasOwnProperty, opera = [], pop = opera.pop, pushNative = opera.push, push$1 = opera.push, slice$1 = opera.slice, indexOf = function(list, elem) {
        for (var i = 0, len = list.length; i < len; i++) if (list[i] === elem) return i;
        return -1;
    }, booleans = "checked|selected|async|autofocus|autoplay|controls|defer|disabled|hidden|ismap|loop|multiple|open|readonly|required|scoped", whitespace = "[\\x20\\t\\r\\n\\f]", webkit = "(?:\\\\[\\da-fA-F]{1,6}" + whitespace + "?|\\\\[^\\r\\n\\f]|[\\w-]|[^\0-\\x7f])+", nav = "\\[" + whitespace + "*(" + webkit + ")(?:" + whitespace + "*([*^$|!~]?=)" + whitespace + "*(?:'((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\"|(" + webkit + "))|)" + whitespace + "*\\]", pseudos = ":(" + webkit + ")(?:\\((('((?:\\\\.|[^\\\\'])*)'|\"((?:\\\\.|[^\\\\\"])*)\")|((?:\\\\.|[^\\\\()[\\]]|" + nav + ")*)|.*)\\)|)", rwhitespace = new RegExp(whitespace + "+", "g"), rtrim = new RegExp("^" + whitespace + "+|((?:^|[^\\\\])(?:\\\\.)*)" + whitespace + "+$", "g"), rcomma = new RegExp("^" + whitespace + "*," + whitespace + "*"), rcombinators = new RegExp("^" + whitespace + "*([>+~]|" + whitespace + ")" + whitespace + "*"), rdescend = new RegExp(whitespace + "|>"), rpseudo = new RegExp(pseudos), ridentifier = new RegExp("^" + webkit + "$"), matchExpr = {
        ID: new RegExp("^#(" + webkit + ")"),
        CLASS: new RegExp("^\\.(" + webkit + ")"),
        TAG: new RegExp("^(" + webkit + "|[*])"),
        ATTR: new RegExp("^" + nav),
        PSEUDO: new RegExp("^" + pseudos),
        CHILD: new RegExp("^:(only|first|last|nth|nth-last)-(child|of-type)(?:\\(" + whitespace + "*(even|odd|(([+-]|)(\\d*)n|)" + whitespace + "*(?:([+-]|)" + whitespace + "*(\\d+)|))" + whitespace + "*\\)|)", "i"),
        bool: new RegExp("^(?:" + booleans + ")$", "i"),
        needsContext: new RegExp("^" + whitespace + "*[>+~]|:(even|odd|eq|gt|lt|nth|first|last)(?:\\(" + whitespace + "*((?:-\\d)?\\d*)" + whitespace + "*\\)|)(?=[^-]|$)", "i")
    }, rhtml = /HTML$/i, rinputs = /^(?:input|select|textarea|button)$/i, rheader = /^h\d$/i, rnative = /^[^{]+\{\s*\[native \w/, rquickExpr$1 = /^(?:#([\w-]+)|(\w+)|\.([\w-]+))$/, rsibling = /[+~]/, runescape = new RegExp("\\\\[\\da-fA-F]{1,6}" + whitespace + "?|\\\\([^\\r\\n\\f])", "g"), rcssescape = /([\0-\x1f\x7f]|^-?\d)|^-$|[^\0-\x1f\x7f-\uFFFF\w-]/g, inDisabledFieldset = addCombinator(function(elem) {
        return !0 === elem.disabled && "fieldset" === elem.nodeName.toLowerCase();
    }, {
        dir: "parentNode",
        next: "legend"
    });
    try {
        push$1.apply(opera = slice$1.call(preferredDoc.childNodes), preferredDoc.childNodes), 
        opera[preferredDoc.childNodes.length].nodeType;
    } catch (e) {
        push$1 = {
            apply: opera.length ? function(target, els) {
                pushNative.apply(target, slice$1.call(els));
            } : function(target, els) {
                for (var j = target.length, i = 0; target[j++] = els[i++]; );
                target.length = j - 1;
            }
        };
    }
    function Sizzle(selector, context, results, seed) {
        var m, i, nid, match, groups, elem, newContext = context && context.ownerDocument, nodeType = context ? context.nodeType : 9;
        if (results = results || [], "string" != typeof selector || !selector || 1 !== nodeType && 9 !== nodeType && 11 !== nodeType) return results;
        if (!seed && (setDocument(context), context = context || document$1, documentIsHTML)) {
            if (11 !== nodeType && (match = rquickExpr$1.exec(selector))) if (m = match[1]) {
                if (9 === nodeType) {
                    if (!(elem = context.getElementById(m))) return results;
                    if (elem.id === m) return results.push(elem), results;
                } else if (newContext && (elem = newContext.getElementById(m)) && contains(context, elem) && elem.id === m) return results.push(elem), 
                results;
            } else {
                if (match[2]) return push$1.apply(results, context.getElementsByTagName(selector)), 
                results;
                if ((m = match[3]) && support.getElementsByClassName && context.getElementsByClassName) return push$1.apply(results, context.getElementsByClassName(m)), 
                results;
            }
            if (support.qsa && !nonnativeSelectorCache[selector + " "] && (!rbuggyQSA || !rbuggyQSA.test(selector)) && (1 !== nodeType || "object" !== context.nodeName.toLowerCase())) {
                if (elem = selector, newContext = context, 1 === nodeType && (rdescend.test(selector) || rcombinators.test(selector))) {
                    for ((newContext = rsibling.test(selector) && testContext(context.parentNode) || context) === context && support.scope || ((nid = context.getAttribute("id")) ? nid = nid.replace(rcssescape, fcssescape) : context.setAttribute("id", nid = expando)), 
                    i = (groups = tokenize(selector)).length; i--; ) groups[i] = (nid ? "#" + nid : ":scope") + " " + toSelector(groups[i]);
                    elem = groups.join(",");
                }
                try {
                    return push$1.apply(results, newContext.querySelectorAll(elem)), 
                    results;
                } catch (qsaError) {
                    nonnativeSelectorCache(selector, !0);
                } finally {
                    nid === expando && context.removeAttribute("id");
                }
            }
        }
        return select$1(selector.replace(rtrim, "$1"), context, results, seed);
    }
    function createCache() {
        var keys = [];
        function cache(key, value) {
            return keys.push(key + " ") > Expr.cacheLength && delete cache[keys.shift()], 
            cache[key + " "] = value;
        }
        return cache;
    }
    function markFunction(fn) {
        return fn[expando] = !0, fn;
    }
    function assert(fn) {
        var el = document$1.createElement("fieldset");
        try {
            return !!fn(el);
        } catch (e) {
            return !1;
        } finally {
            el.parentNode && el.parentNode.removeChild(el);
        }
    }
    function addHandle(attrs, handler) {
        for (var arr = attrs.split("|"), i = arr.length; i--; ) Expr.attrHandle[arr[i]] = handler;
    }
    function siblingCheck(a, b) {
        var cur = b && a, diff = cur && 1 === a.nodeType && 1 === b.nodeType && a.sourceIndex - b.sourceIndex;
        if (diff) return diff;
        if (cur) for (;cur = cur.nextSibling; ) if (cur === b) return -1;
        return a ? 1 : -1;
    }
    function createDisabledPseudo(disabled) {
        return function(elem) {
            return "form" in elem ? elem.parentNode && !1 === elem.disabled ? "label" in elem ? "label" in elem.parentNode ? elem.parentNode.disabled === disabled : elem.disabled === disabled : elem.isDisabled === disabled || elem.isDisabled !== !disabled && inDisabledFieldset(elem) === disabled : elem.disabled === disabled : "label" in elem && elem.disabled === disabled;
        };
    }
    function createPositionalPseudo(fn) {
        return markFunction(function(argument) {
            return argument = +argument, markFunction(function(seed, matches) {
                for (var j, matchIndexes = fn([], seed.length, argument), i = matchIndexes.length; i--; ) seed[j = matchIndexes[i]] && (seed[j] = !(matches[j] = seed[j]));
            });
        });
    }
    function testContext(context) {
        return context && void 0 !== context.getElementsByTagName && context;
    }
    for (i in support = Sizzle.support = {}, isXML = Sizzle.isXML = function(elem) {
        var namespace = elem && elem.namespaceURI, elem = elem && (elem.ownerDocument || elem).documentElement;
        return !rhtml.test(namespace || elem && elem.nodeName || "HTML");
    }, setDocument = Sizzle.setDocument = function(node) {
        var node = node ? node.ownerDocument || node : preferredDoc;
        return node != document$1 && 9 === node.nodeType && node.documentElement && (docElem = (document$1 = node).documentElement, 
        documentIsHTML = !isXML(document$1), preferredDoc != document$1 && (node = document$1.defaultView) && node.top !== node && (node.addEventListener ? node.addEventListener("unload", unloadHandler, !1) : node.attachEvent && node.attachEvent("onunload", unloadHandler)), 
        support.scope = assert(function(el) {
            return docElem.appendChild(el).appendChild(document$1.createElement("div")), 
            void 0 !== el.querySelectorAll && !el.querySelectorAll(":scope fieldset div").length;
        }), support.attributes = assert(function(el) {
            return el.className = "i", !el.getAttribute("className");
        }), support.getElementsByTagName = assert(function(el) {
            return el.appendChild(document$1.createComment("")), !el.getElementsByTagName("*").length;
        }), support.getElementsByClassName = rnative.test(document$1.getElementsByClassName), 
        support.getById = assert(function(el) {
            return docElem.appendChild(el).id = expando, !document$1.getElementsByName || !document$1.getElementsByName(expando).length;
        }), support.getById ? (Expr.filter.ID = function(id) {
            var attrId = id.replace(runescape, funescape);
            return function(elem) {
                return elem.getAttribute("id") === attrId;
            };
        }, Expr.find.ID = function(id, context) {
            if (void 0 !== context.getElementById && documentIsHTML) return (context = context.getElementById(id)) ? [ context ] : [];
        }) : (Expr.filter.ID = function(id) {
            var attrId = id.replace(runescape, funescape);
            return function(elem) {
                elem = void 0 !== elem.getAttributeNode && elem.getAttributeNode("id");
                return elem && elem.value === attrId;
            };
        }, Expr.find.ID = function(id, context) {
            if (void 0 !== context.getElementById && documentIsHTML) {
                var node, i, elems, elem = context.getElementById(id);
                if (elem) {
                    if ((node = elem.getAttributeNode("id")) && node.value === id) return [ elem ];
                    for (elems = context.getElementsByName(id), i = 0; elem = elems[i++]; ) if ((node = elem.getAttributeNode("id")) && node.value === id) return [ elem ];
                }
                return [];
            }
        }), Expr.find.TAG = support.getElementsByTagName ? function(tag, context) {
            return void 0 !== context.getElementsByTagName ? context.getElementsByTagName(tag) : support.qsa ? context.querySelectorAll(tag) : void 0;
        } : function(tag, context) {
            var elem, tmp = [], i = 0, results = context.getElementsByTagName(tag);
            if ("*" !== tag) return results;
            for (;elem = results[i++]; ) 1 === elem.nodeType && tmp.push(elem);
            return tmp;
        }, Expr.find.CLASS = support.getElementsByClassName && function(className, context) {
            if (void 0 !== context.getElementsByClassName && documentIsHTML) return context.getElementsByClassName(className);
        }, rbuggyMatches = [], rbuggyQSA = [], (support.qsa = rnative.test(document$1.querySelectorAll)) && (assert(function(el) {
            var input;
            docElem.appendChild(el).innerHTML = "<a id='" + expando + "'></a><select id='" + expando + "-\r\\' msallowcapture=''><option selected=''></option></select>", 
            el.querySelectorAll("[msallowcapture^='']").length && rbuggyQSA.push("[*^$]=" + whitespace + "*(?:''|\"\")"), 
            el.querySelectorAll("[selected]").length || rbuggyQSA.push("\\[" + whitespace + "*(?:value|" + booleans + ")"), 
            el.querySelectorAll("[id~=" + expando + "-]").length || rbuggyQSA.push("~="), 
            (input = document$1.createElement("input")).setAttribute("name", ""), 
            el.appendChild(input), el.querySelectorAll("[name='']").length || rbuggyQSA.push("\\[" + whitespace + "*name" + whitespace + "*=" + whitespace + "*(?:''|\"\")"), 
            el.querySelectorAll(":checked").length || rbuggyQSA.push(":checked"), 
            el.querySelectorAll("a#" + expando + "+*").length || rbuggyQSA.push(".#.+[+~]"), 
            el.querySelectorAll("\\\f"), rbuggyQSA.push("[\\r\\n\\f]");
        }), assert(function(el) {
            el.innerHTML = "<a href='' disabled='disabled'></a><select disabled='disabled'><option/></select>";
            var input = document$1.createElement("input");
            input.setAttribute("type", "hidden"), el.appendChild(input).setAttribute("name", "D"), 
            el.querySelectorAll("[name=d]").length && rbuggyQSA.push("name" + whitespace + "*[*^$|!~]?="), 
            2 !== el.querySelectorAll(":enabled").length && rbuggyQSA.push(":enabled", ":disabled"), 
            docElem.appendChild(el).disabled = !0, 2 !== el.querySelectorAll(":disabled").length && rbuggyQSA.push(":enabled", ":disabled"), 
            el.querySelectorAll("*,:x"), rbuggyQSA.push(",.*:");
        })), (support.matchesSelector = rnative.test(matches = docElem.matches || docElem.webkitMatchesSelector || docElem.mozMatchesSelector || docElem.oMatchesSelector || docElem.msMatchesSelector)) && assert(function(el) {
            support.disconnectedMatch = matches.call(el, "*"), matches.call(el, "[s!='']:x"), 
            rbuggyMatches.push("!=", pseudos);
        }), rbuggyQSA = rbuggyQSA.length && new RegExp(rbuggyQSA.join("|")), rbuggyMatches = rbuggyMatches.length && new RegExp(rbuggyMatches.join("|")), 
        node = rnative.test(docElem.compareDocumentPosition), contains = node || rnative.test(docElem.contains) ? function(a, b) {
            var adown = 9 === a.nodeType ? a.documentElement : a, b = b && b.parentNode;
            return a === b || !(!b || 1 !== b.nodeType || !(adown.contains ? adown.contains(b) : a.compareDocumentPosition && 16 & a.compareDocumentPosition(b)));
        } : function(a, b) {
            if (b) for (;b = b.parentNode; ) if (b === a) return !0;
            return !1;
        }, sortOrder = node ? function(a, b) {
            var compare;
            return a === b ? (hasDuplicate = !0, 0) : (compare = !a.compareDocumentPosition - !b.compareDocumentPosition) || (1 & (compare = (a.ownerDocument || a) == (b.ownerDocument || b) ? a.compareDocumentPosition(b) : 1) || !support.sortDetached && b.compareDocumentPosition(a) === compare ? a == document$1 || a.ownerDocument == preferredDoc && contains(preferredDoc, a) ? -1 : b == document$1 || b.ownerDocument == preferredDoc && contains(preferredDoc, b) ? 1 : sortInput ? indexOf(sortInput, a) - indexOf(sortInput, b) : 0 : 4 & compare ? -1 : 1);
        } : function(a, b) {
            if (a === b) return hasDuplicate = !0, 0;
            var cur, i = 0, aup = a.parentNode, bup = b.parentNode, ap = [ a ], bp = [ b ];
            if (!aup || !bup) return a == document$1 ? -1 : b == document$1 ? 1 : aup ? -1 : bup ? 1 : sortInput ? indexOf(sortInput, a) - indexOf(sortInput, b) : 0;
            if (aup === bup) return siblingCheck(a, b);
            for (cur = a; cur = cur.parentNode; ) ap.unshift(cur);
            for (cur = b; cur = cur.parentNode; ) bp.unshift(cur);
            for (;ap[i] === bp[i]; ) i++;
            return i ? siblingCheck(ap[i], bp[i]) : ap[i] == preferredDoc ? -1 : bp[i] == preferredDoc ? 1 : 0;
        }), document$1;
    }, Sizzle.matches = function(expr, elements) {
        return Sizzle(expr, null, null, elements);
    }, Sizzle.matchesSelector = function(elem, expr) {
        if (setDocument(elem), support.matchesSelector && documentIsHTML && !nonnativeSelectorCache[expr + " "] && (!rbuggyMatches || !rbuggyMatches.test(expr)) && (!rbuggyQSA || !rbuggyQSA.test(expr))) try {
            var ret = matches.call(elem, expr);
            if (ret || support.disconnectedMatch || elem.document && 11 !== elem.document.nodeType) return ret;
        } catch (e) {
            nonnativeSelectorCache(expr, !0);
        }
        return 0 < Sizzle(expr, document$1, null, [ elem ]).length;
    }, Sizzle.contains = function(context, elem) {
        return (context.ownerDocument || context) != document$1 && setDocument(context), 
        contains(context, elem);
    }, Sizzle.attr = function(elem, name) {
        (elem.ownerDocument || elem) != document$1 && setDocument(elem);
        var fn = Expr.attrHandle[name.toLowerCase()], fn = fn && hasOwn.call(Expr.attrHandle, name.toLowerCase()) ? fn(elem, name, !documentIsHTML) : void 0;
        return void 0 !== fn ? fn : support.attributes || !documentIsHTML ? elem.getAttribute(name) : (fn = elem.getAttributeNode(name)) && fn.specified ? fn.value : null;
    }, Sizzle.escape = function(sel) {
        return (sel + "").replace(rcssescape, fcssescape);
    }, Sizzle.error = function(msg) {
        throw new Error("Syntax error, unrecognized expression: " + msg);
    }, Sizzle.uniqueSort = function(results) {
        var elem, duplicates = [], j = 0, i = 0;
        if (hasDuplicate = !support.detectDuplicates, sortInput = !support.sortStable && results.slice(0), 
        results.sort(sortOrder), hasDuplicate) {
            for (;elem = results[i++]; ) elem === results[i] && (j = duplicates.push(i));
            for (;j--; ) results.splice(duplicates[j], 1);
        }
        return sortInput = null, results;
    }, getText$1 = Sizzle.getText = function(elem) {
        var node, ret = "", i = 0, nodeType = elem.nodeType;
        if (nodeType) {
            if (1 === nodeType || 9 === nodeType || 11 === nodeType) {
                if ("string" == typeof elem.textContent) return elem.textContent;
                for (elem = elem.firstChild; elem; elem = elem.nextSibling) ret += getText$1(elem);
            } else if (3 === nodeType || 4 === nodeType) return elem.nodeValue;
        } else for (;node = elem[i++]; ) ret += getText$1(node);
        return ret;
    }, (Expr = Sizzle.selectors = {
        cacheLength: 50,
        createPseudo: markFunction,
        match: matchExpr,
        attrHandle: {},
        find: {},
        relative: {
            ">": {
                dir: "parentNode",
                first: !0
            },
            " ": {
                dir: "parentNode"
            },
            "+": {
                dir: "previousSibling",
                first: !0
            },
            "~": {
                dir: "previousSibling"
            }
        },
        preFilter: {
            ATTR: function(match) {
                return match[1] = match[1].replace(runescape, funescape), match[3] = (match[3] || match[4] || match[5] || "").replace(runescape, funescape), 
                "~=" === match[2] && (match[3] = " " + match[3] + " "), match.slice(0, 4);
            },
            CHILD: function(match) {
                return match[1] = match[1].toLowerCase(), "nth" === match[1].slice(0, 3) ? (match[3] || Sizzle.error(match[0]), 
                match[4] = +(match[4] ? match[5] + (match[6] || 1) : 2 * ("even" === match[3] || "odd" === match[3])), 
                match[5] = +(match[7] + match[8] || "odd" === match[3])) : match[3] && Sizzle.error(match[0]), 
                match;
            },
            PSEUDO: function(match) {
                var excess, unquoted = !match[6] && match[2];
                return matchExpr.CHILD.test(match[0]) ? null : (match[3] ? match[2] = match[4] || match[5] || "" : unquoted && rpseudo.test(unquoted) && (excess = (excess = tokenize(unquoted, !0)) && unquoted.indexOf(")", unquoted.length - excess) - unquoted.length) && (match[0] = match[0].slice(0, excess), 
                match[2] = unquoted.slice(0, excess)), match.slice(0, 3));
            }
        },
        filter: {
            TAG: function(nodeNameSelector) {
                var nodeName = nodeNameSelector.replace(runescape, funescape).toLowerCase();
                return "*" === nodeNameSelector ? function() {
                    return !0;
                } : function(elem) {
                    return elem.nodeName && elem.nodeName.toLowerCase() === nodeName;
                };
            },
            CLASS: function(className) {
                var pattern = classCache[className + " "];
                return pattern || (pattern = new RegExp("(^|" + whitespace + ")" + className + "(" + whitespace + "|$)")) && classCache(className, function(elem) {
                    return pattern.test("string" == typeof elem.className && elem.className || void 0 !== elem.getAttribute && elem.getAttribute("class") || "");
                });
            },
            ATTR: function(name, operator, check) {
                return function(elem) {
                    elem = Sizzle.attr(elem, name);
                    return null == elem ? "!=" === operator : !operator || (elem += "", 
                    "=" === operator ? elem === check : "!=" === operator ? elem !== check : "^=" === operator ? check && 0 === elem.indexOf(check) : "*=" === operator ? check && -1 < elem.indexOf(check) : "$=" === operator ? check && elem.slice(-check.length) === check : "~=" === operator ? -1 < (" " + elem.replace(rwhitespace, " ") + " ").indexOf(check) : "|=" === operator && (elem === check || elem.slice(0, check.length + 1) === check + "-"));
                };
            },
            CHILD: function(type, what, _argument, first, last) {
                var simple = "nth" !== type.slice(0, 3), forward = "last" !== type.slice(-4), ofType = "of-type" === what;
                return 1 === first && 0 === last ? function(elem) {
                    return !!elem.parentNode;
                } : function(elem, _context, xml) {
                    var cache, uniqueCache, outerCache, node, nodeIndex, start, dir = simple != forward ? "nextSibling" : "previousSibling", parent = elem.parentNode, name = ofType && elem.nodeName.toLowerCase(), useCache = !xml && !ofType, diff = !1;
                    if (parent) {
                        if (simple) {
                            for (;dir; ) {
                                for (node = elem; node = node[dir]; ) if (ofType ? node.nodeName.toLowerCase() === name : 1 === node.nodeType) return !1;
                                start = dir = "only" === type && !start && "nextSibling";
                            }
                            return !0;
                        }
                        if (start = [ forward ? parent.firstChild : parent.lastChild ], 
                        forward && useCache) {
                            for (diff = (nodeIndex = (cache = (uniqueCache = (outerCache = (node = parent)[expando] || (node[expando] = {}))[node.uniqueID] || (outerCache[node.uniqueID] = {}))[type] || [])[0] === dirruns && cache[1]) && cache[2], 
                            node = nodeIndex && parent.childNodes[nodeIndex]; node = ++nodeIndex && node && node[dir] || (diff = nodeIndex = 0, 
                            start.pop()); ) if (1 === node.nodeType && ++diff && node === elem) {
                                uniqueCache[type] = [ dirruns, nodeIndex, diff ];
                                break;
                            }
                        } else if (!1 === (diff = useCache ? nodeIndex = (cache = (uniqueCache = (outerCache = (node = elem)[expando] || (node[expando] = {}))[node.uniqueID] || (outerCache[node.uniqueID] = {}))[type] || [])[0] === dirruns && cache[1] : diff)) for (;(node = ++nodeIndex && node && node[dir] || (diff = nodeIndex = 0, 
                        start.pop())) && ((ofType ? node.nodeName.toLowerCase() !== name : 1 !== node.nodeType) || !++diff || (useCache && ((uniqueCache = (outerCache = node[expando] || (node[expando] = {}))[node.uniqueID] || (outerCache[node.uniqueID] = {}))[type] = [ dirruns, diff ]), 
                        node !== elem)); );
                        return (diff -= last) === first || diff % first == 0 && 0 <= diff / first;
                    }
                };
            },
            PSEUDO: function(pseudo, argument) {
                var args, fn = Expr.pseudos[pseudo] || Expr.setFilters[pseudo.toLowerCase()] || Sizzle.error("unsupported pseudo: " + pseudo);
                return fn[expando] ? fn(argument) : 1 < fn.length ? (args = [ pseudo, pseudo, "", argument ], 
                Expr.setFilters.hasOwnProperty(pseudo.toLowerCase()) ? markFunction(function(seed, matches) {
                    for (var idx, matched = fn(seed, argument), i = matched.length; i--; ) seed[idx = indexOf(seed, matched[i])] = !(matches[idx] = matched[i]);
                }) : function(elem) {
                    return fn(elem, 0, args);
                }) : fn;
            }
        },
        pseudos: {
            not: markFunction(function(selector) {
                var input = [], results = [], matcher = compile(selector.replace(rtrim, "$1"));
                return matcher[expando] ? markFunction(function(seed, matches, _context, xml) {
                    for (var elem, unmatched = matcher(seed, null, xml, []), i = seed.length; i--; ) (elem = unmatched[i]) && (seed[i] = !(matches[i] = elem));
                }) : function(elem, _context, xml) {
                    return input[0] = elem, matcher(input, null, xml, results), 
                    input[0] = null, !results.pop();
                };
            }),
            has: markFunction(function(selector) {
                return function(elem) {
                    return 0 < Sizzle(selector, elem).length;
                };
            }),
            contains: markFunction(function(text) {
                return text = text.replace(runescape, funescape), function(elem) {
                    return -1 < (elem.textContent || getText$1(elem)).indexOf(text);
                };
            }),
            lang: markFunction(function(lang) {
                return ridentifier.test(lang || "") || Sizzle.error("unsupported lang: " + lang), 
                lang = lang.replace(runescape, funescape).toLowerCase(), function(elem) {
                    var elemLang;
                    do {
                        if (elemLang = documentIsHTML ? elem.lang : elem.getAttribute("xml:lang") || elem.getAttribute("lang")) return (elemLang = elemLang.toLowerCase()) === lang || 0 === elemLang.indexOf(lang + "-");
                    } while ((elem = elem.parentNode) && 1 === elem.nodeType);
                    return !1;
                };
            }),
            target: function(elem) {
                var hash = window.location && window.location.hash;
                return hash && hash.slice(1) === elem.id;
            },
            root: function(elem) {
                return elem === docElem;
            },
            focus: function(elem) {
                return elem === document$1.activeElement && (!document$1.hasFocus || document$1.hasFocus()) && !!(elem.type || elem.href || ~elem.tabIndex);
            },
            enabled: createDisabledPseudo(!1),
            disabled: createDisabledPseudo(!0),
            checked: function(elem) {
                var nodeName = elem.nodeName.toLowerCase();
                return "input" === nodeName && !!elem.checked || "option" === nodeName && !!elem.selected;
            },
            selected: function(elem) {
                return elem.parentNode && elem.parentNode.selectedIndex, !0 === elem.selected;
            },
            empty: function(elem) {
                for (elem = elem.firstChild; elem; elem = elem.nextSibling) if (elem.nodeType < 6) return !1;
                return !0;
            },
            parent: function(elem) {
                return !Expr.pseudos.empty(elem);
            },
            header: function(elem) {
                return rheader.test(elem.nodeName);
            },
            input: function(elem) {
                return rinputs.test(elem.nodeName);
            },
            button: function(elem) {
                var name = elem.nodeName.toLowerCase();
                return "input" === name && "button" === elem.type || "button" === name;
            },
            text: function(elem) {
                return "input" === elem.nodeName.toLowerCase() && "text" === elem.type && (null == (elem = elem.getAttribute("type")) || "text" === elem.toLowerCase());
            },
            first: createPositionalPseudo(function() {
                return [ 0 ];
            }),
            last: createPositionalPseudo(function(_matchIndexes, length) {
                return [ length - 1 ];
            }),
            eq: createPositionalPseudo(function(_matchIndexes, length, argument) {
                return [ argument < 0 ? argument + length : argument ];
            }),
            even: createPositionalPseudo(function(matchIndexes, length) {
                for (var i = 0; i < length; i += 2) matchIndexes.push(i);
                return matchIndexes;
            }),
            odd: createPositionalPseudo(function(matchIndexes, length) {
                for (var i = 1; i < length; i += 2) matchIndexes.push(i);
                return matchIndexes;
            }),
            lt: createPositionalPseudo(function(matchIndexes, length, argument) {
                for (var i = argument < 0 ? argument + length : length < argument ? length : argument; 0 <= --i; ) matchIndexes.push(i);
                return matchIndexes;
            }),
            gt: createPositionalPseudo(function(matchIndexes, length, argument) {
                for (var i = argument < 0 ? argument + length : argument; ++i < length; ) matchIndexes.push(i);
                return matchIndexes;
            })
        }
    }).pseudos.nth = Expr.pseudos.eq, {
        radio: !0,
        checkbox: !0,
        file: !0,
        password: !0,
        image: !0
    }) Expr.pseudos[i] = function(type) {
        return function(elem) {
            return "input" === elem.nodeName.toLowerCase() && elem.type === type;
        };
    }(i);
    for (i in {
        submit: !0,
        reset: !0
    }) Expr.pseudos[i] = function(type) {
        return function(elem) {
            var name = elem.nodeName.toLowerCase();
            return ("input" === name || "button" === name) && elem.type === type;
        };
    }(i);
    function setFilters() {}
    function toSelector(tokens) {
        for (var i = 0, len = tokens.length, selector = ""; i < len; i++) selector += tokens[i].value;
        return selector;
    }
    function addCombinator(matcher, combinator, base) {
        var dir = combinator.dir, skip = combinator.next, key = skip || dir, checkNonElements = base && "parentNode" === key, doneName = done++;
        return combinator.first ? function(elem, context, xml) {
            for (;elem = elem[dir]; ) if (1 === elem.nodeType || checkNonElements) return matcher(elem, context, xml);
            return !1;
        } : function(elem, context, xml) {
            var oldCache, outerCache, newCache = [ dirruns, doneName ];
            if (xml) {
                for (;elem = elem[dir]; ) if ((1 === elem.nodeType || checkNonElements) && matcher(elem, context, xml)) return !0;
            } else for (;elem = elem[dir]; ) if (1 === elem.nodeType || checkNonElements) if (outerCache = (outerCache = elem[expando] || (elem[expando] = {}))[elem.uniqueID] || (outerCache[elem.uniqueID] = {}), 
            skip && skip === elem.nodeName.toLowerCase()) elem = elem[dir] || elem; else {
                if ((oldCache = outerCache[key]) && oldCache[0] === dirruns && oldCache[1] === doneName) return newCache[2] = oldCache[2];
                if ((outerCache[key] = newCache)[2] = matcher(elem, context, xml)) return !0;
            }
            return !1;
        };
    }
    function elementMatcher(matchers) {
        return 1 < matchers.length ? function(elem, context, xml) {
            for (var i = matchers.length; i--; ) if (!matchers[i](elem, context, xml)) return !1;
            return !0;
        } : matchers[0];
    }
    function condense(unmatched, map, filter, context, xml) {
        for (var elem, newUnmatched = [], i = 0, len = unmatched.length, mapped = null != map; i < len; i++) !(elem = unmatched[i]) || filter && !filter(elem, context, xml) || (newUnmatched.push(elem), 
        mapped && map.push(i));
        return newUnmatched;
    }
    function setMatcher(preFilter, selector, matcher, postFilter, postFinder, postSelector) {
        return postFilter && !postFilter[expando] && (postFilter = setMatcher(postFilter)), 
        postFinder && !postFinder[expando] && (postFinder = setMatcher(postFinder, postSelector)), 
        markFunction(function(seed, results, context, xml) {
            var temp, i, elem, preMap = [], postMap = [], preexisting = results.length, elems = seed || function(selector, contexts, results) {
                for (var i = 0, len = contexts.length; i < len; i++) Sizzle(selector, contexts[i], results);
                return results;
            }(selector || "*", context.nodeType ? [ context ] : context, []), matcherIn = !preFilter || !seed && selector ? elems : condense(elems, preMap, preFilter, context, xml), matcherOut = matcher ? postFinder || (seed ? preFilter : preexisting || postFilter) ? [] : results : matcherIn;
            if (matcher && matcher(matcherIn, matcherOut, context, xml), postFilter) for (temp = condense(matcherOut, postMap), 
            postFilter(temp, [], context, xml), i = temp.length; i--; ) (elem = temp[i]) && (matcherOut[postMap[i]] = !(matcherIn[postMap[i]] = elem));
            if (seed) {
                if (postFinder || preFilter) {
                    if (postFinder) {
                        for (temp = [], i = matcherOut.length; i--; ) (elem = matcherOut[i]) && temp.push(matcherIn[i] = elem);
                        postFinder(null, matcherOut = [], temp, xml);
                    }
                    for (i = matcherOut.length; i--; ) (elem = matcherOut[i]) && -1 < (temp = postFinder ? indexOf(seed, elem) : preMap[i]) && (seed[temp] = !(results[temp] = elem));
                }
            } else matcherOut = condense(matcherOut === results ? matcherOut.splice(preexisting, matcherOut.length) : matcherOut), 
            postFinder ? postFinder(null, results, matcherOut, xml) : push$1.apply(results, matcherOut);
        });
    }
    function matcherFromGroupMatchers(elementMatchers, setMatchers) {
        function superMatcher(seed, context, xml, results, outermost) {
            var elem, j, matcher, matchedCount = 0, i = "0", unmatched = seed && [], setMatched = [], contextBackup = outermostContext, elems = seed || byElement && Expr.find.TAG("*", outermost), dirrunsUnique = dirruns += null == contextBackup ? 1 : Math.random() || .1, len = elems.length;
            for (outermost && (outermostContext = context == document$1 || context || outermost); i !== len && null != (elem = elems[i]); i++) {
                if (byElement && elem) {
                    for (j = 0, context || elem.ownerDocument == document$1 || (setDocument(elem), 
                    xml = !documentIsHTML); matcher = elementMatchers[j++]; ) if (matcher(elem, context || document$1, xml)) {
                        results.push(elem);
                        break;
                    }
                    outermost && (dirruns = dirrunsUnique);
                }
                bySet && ((elem = !matcher && elem) && matchedCount--, seed) && unmatched.push(elem);
            }
            if (matchedCount += i, bySet && i !== matchedCount) {
                for (j = 0; matcher = setMatchers[j++]; ) matcher(unmatched, setMatched, context, xml);
                if (seed) {
                    if (0 < matchedCount) for (;i--; ) unmatched[i] || setMatched[i] || (setMatched[i] = pop.call(results));
                    setMatched = condense(setMatched);
                }
                push$1.apply(results, setMatched), outermost && !seed && 0 < setMatched.length && 1 < matchedCount + setMatchers.length && Sizzle.uniqueSort(results);
            }
            return outermost && (dirruns = dirrunsUnique, outermostContext = contextBackup), 
            unmatched;
        }
        var bySet = 0 < setMatchers.length, byElement = 0 < elementMatchers.length;
        return bySet ? markFunction(superMatcher) : superMatcher;
    }
    setFilters.prototype = Expr.filters = Expr.pseudos, Expr.setFilters = new setFilters(), 
    tokenize = Sizzle.tokenize = function(selector, parseOnly) {
        var matched, match, tokens, type, soFar, groups, preFilters, cached = tokenCache[selector + " "];
        if (cached) return parseOnly ? 0 : cached.slice(0);
        for (soFar = selector, groups = [], preFilters = Expr.preFilter; soFar; ) {
            for (type in matched && !(match = rcomma.exec(soFar)) || (match && (soFar = soFar.slice(match[0].length) || soFar), 
            groups.push(tokens = [])), matched = !1, (match = rcombinators.exec(soFar)) && (matched = match.shift(), 
            tokens.push({
                value: matched,
                type: match[0].replace(rtrim, " ")
            }), soFar = soFar.slice(matched.length)), Expr.filter) !(match = matchExpr[type].exec(soFar)) || preFilters[type] && !(match = preFilters[type](match)) || (matched = match.shift(), 
            tokens.push({
                value: matched,
                type: type,
                matches: match
            }), soFar = soFar.slice(matched.length));
            if (!matched) break;
        }
        return parseOnly ? soFar.length : soFar ? Sizzle.error(selector) : tokenCache(selector, groups).slice(0);
    }, compile = Sizzle.compile = function(selector, match) {
        var i, setMatchers = [], elementMatchers = [], cached = compilerCache[selector + " "];
        if (!cached) {
            for (i = (match = match || tokenize(selector)).length; i--; ) ((cached = function matcherFromTokens(tokens) {
                for (var checkContext, matcher, j, len = tokens.length, leadingRelative = Expr.relative[tokens[0].type], implicitRelative = leadingRelative || Expr.relative[" "], i = leadingRelative ? 1 : 0, matchContext = addCombinator(function(elem) {
                    return elem === checkContext;
                }, implicitRelative, !0), matchAnyContext = addCombinator(function(elem) {
                    return -1 < indexOf(checkContext, elem);
                }, implicitRelative, !0), matchers = [ function(elem, context, xml) {
                    return elem = !leadingRelative && (xml || context !== outermostContext) || ((checkContext = context).nodeType ? matchContext : matchAnyContext)(elem, context, xml), 
                    checkContext = null, elem;
                } ]; i < len; i++) if (matcher = Expr.relative[tokens[i].type]) matchers = [ addCombinator(elementMatcher(matchers), matcher) ]; else {
                    if ((matcher = Expr.filter[tokens[i].type].apply(null, tokens[i].matches))[expando]) {
                        for (j = ++i; j < len && !Expr.relative[tokens[j].type]; j++);
                        return setMatcher(1 < i && elementMatcher(matchers), 1 < i && toSelector(tokens.slice(0, i - 1).concat({
                            value: " " === tokens[i - 2].type ? "*" : ""
                        })).replace(rtrim, "$1"), matcher, i < j && matcherFromTokens(tokens.slice(i, j)), j < len && matcherFromTokens(tokens = tokens.slice(j)), j < len && toSelector(tokens));
                    }
                    matchers.push(matcher);
                }
                return elementMatcher(matchers);
            }(match[i]))[expando] ? setMatchers : elementMatchers).push(cached);
            (cached = compilerCache(selector, matcherFromGroupMatchers(elementMatchers, setMatchers))).selector = selector;
        }
        return cached;
    }, select$1 = Sizzle.select = function(selector, context, results, seed) {
        var i, tokens, token, type, find, compiled = "function" == typeof selector && selector, match = !seed && tokenize(selector = compiled.selector || selector);
        if (results = results || [], 1 === match.length) {
            if (2 < (tokens = match[0] = match[0].slice(0)).length && "ID" === (token = tokens[0]).type && 9 === context.nodeType && documentIsHTML && Expr.relative[tokens[1].type]) {
                if (!(context = (Expr.find.ID(token.matches[0].replace(runescape, funescape), context) || [])[0])) return results;
                compiled && (context = context.parentNode), selector = selector.slice(tokens.shift().value.length);
            }
            for (i = matchExpr.needsContext.test(selector) ? 0 : tokens.length; i-- && (token = tokens[i], 
            !Expr.relative[type = token.type]); ) if ((find = Expr.find[type]) && (seed = find(token.matches[0].replace(runescape, funescape), rsibling.test(tokens[0].type) && testContext(context.parentNode) || context))) {
                if (tokens.splice(i, 1), selector = seed.length && toSelector(tokens)) break;
                return push$1.apply(results, seed), results;
            }
        }
        return (compiled || compile(selector, match))(seed, context, !documentIsHTML, results, !context || rsibling.test(selector) && testContext(context.parentNode) || context), 
        results;
    }, support.sortStable = expando.split("").sort(sortOrder).join("") === expando, 
    support.detectDuplicates = !!hasDuplicate, setDocument(), support.sortDetached = assert(function(el) {
        return 1 & el.compareDocumentPosition(document$1.createElement("fieldset"));
    }), assert(function(el) {
        return el.innerHTML = "<a href='#'></a>", "#" === el.firstChild.getAttribute("href");
    }) || addHandle("type|href|height|width", function(elem, name, isXML) {
        if (!isXML) return elem.getAttribute(name, "type" === name.toLowerCase() ? 1 : 2);
    }), support.attributes && assert(function(el) {
        return el.innerHTML = "<input/>", el.firstChild.setAttribute("value", ""), 
        "" === el.firstChild.getAttribute("value");
    }) || addHandle("value", function(elem, _name, isXML) {
        if (!isXML && "input" === elem.nodeName.toLowerCase()) return elem.defaultValue;
    }), assert(function(el) {
        return null == el.getAttribute("disabled");
    }) || addHandle(booleans, function(elem, name, isXML) {
        if (!isXML) return !0 === elem[name] ? name.toLowerCase() : (isXML = elem.getAttributeNode(name)) && isXML.specified ? isXML.value : null;
    });
    function isString(obj) {
        return "string" == typeof obj;
    }
    function createFragment(html, fragDoc) {
        var node, container = (fragDoc = fragDoc || doc).createElement("div"), frag = fragDoc.createDocumentFragment();
        for (container.innerHTML = html; node = container.firstChild; ) frag.appendChild(node);
        return frag;
    }
    function domManipulate(targetNodes, sourceItem, callback, reverse) {
        var i;
        if (isString(sourceItem)) sourceItem = createFragment(sourceItem, getElementDocument(targetNodes[0])); else if (sourceItem.length && !sourceItem.nodeType) {
            if (sourceItem = DomQuery.makeArray(sourceItem), reverse) for (i = sourceItem.length - 1; 0 <= i; i--) domManipulate(targetNodes, sourceItem[i], callback, reverse); else for (i = 0; i < sourceItem.length; i++) domManipulate(targetNodes, sourceItem[i], callback, reverse);
            return targetNodes;
        }
        if (sourceItem.nodeType) for (i = targetNodes.length; i--; ) callback.call(targetNodes[i], sourceItem);
        return targetNodes;
    }
    function hasClass(node, className) {
        return node && className && -1 !== (" " + node.className + " ").indexOf(" " + className + " ");
    }
    function wrap(elements, wrapper, all) {
        var lastParent, newWrapper;
        return wrapper = DomQuery(wrapper)[0], elements.each(function() {
            all && lastParent === this.parentNode || (lastParent = this.parentNode, 
            newWrapper = wrapper.cloneNode(!1), this.parentNode.insertBefore(newWrapper, this)), 
            newWrapper.appendChild(this);
        }), elements;
    }
    function trim$2(str) {
        return null == str ? "" : ("" + str).replace(whiteSpaceRegExp, "");
    }
    function each$1(obj, callback) {
        var length, key, i, value;
        if (obj) if (void 0 === (length = obj.length)) {
            for (key in obj) if (Tools$6.hasOwn(obj, key) && (value = obj[key], 
            !1 === callback.call(value, key, value))) break;
        } else for (i = 0; i < length && (value = obj[i], !1 !== callback.call(value, i, value)); i++);
        return obj;
    }
    function grep(array, callback) {
        var out = [];
        return each$1(array, function(i, item) {
            callback(item, i) && out.push(item);
        }), out;
    }
    function getElementDocument(element) {
        return element ? 9 === element.nodeType ? element : element.ownerDocument : doc;
    }
    function dir(el, prop, until) {
        var matched = [], cur = el[prop];
        for ("string" != typeof until && until instanceof DomQuery && (until = until[0]); cur && 9 !== cur.nodeType; ) {
            if (void 0 !== until) {
                if (cur === until) break;
                if ("string" == typeof until && DomQuery(cur).is(until)) break;
            }
            1 === cur.nodeType && matched.push(cur), cur = cur[prop];
        }
        return matched;
    }
    function sibling(node, siblingName, nodeType, until) {
        var result = [];
        for (until instanceof DomQuery && (until = until[0]); node; node = node[siblingName]) if (node.nodeType === nodeType) {
            if (void 0 !== until) {
                if (node === until) break;
                if ("string" == typeof until && DomQuery(node).is(until)) break;
            }
            result.push(node);
        }
        return result;
    }
    function firstSibling(node, siblingName, nodeType) {
        for (node = node[siblingName]; node; node = node[siblingName]) if (node.nodeType === nodeType) return node;
        return null;
    }
    var doc = document, push = Array.prototype.push, slice = Array.prototype.slice, rquickExpr = /^(?:[^#<]*(<[\w\W]+>)[^>]*$|#([\w\-]*)$)/, Event = EventUtils.Event, skipUniques = Tools$6.makeMap("children,contents,next,prev"), numericCssMap = Tools$6.makeMap("fillOpacity fontWeight lineHeight opacity orphans widows zIndex zoom", " "), booleanMap = Tools$6.makeMap("checked compact declare defer disabled ismap multiple nohref noshade nowrap readonly selected", " "), propFix = {
        for: "htmlFor",
        class: "className",
        readonly: "readOnly"
    }, cssFix = {
        float: "cssFloat"
    }, attrHooks = {}, cssHooks = {}, DomQuery = function(selector, context) {
        return new DomQuery.fn.init(selector, context);
    }, whiteSpaceRegExp = /^\s*|\s*$/g, count$2 = (DomQuery.fn = DomQuery.prototype = {
        constructor: DomQuery,
        selector: "",
        context: null,
        length: 0,
        init: function(selector, context) {
            var match, node;
            if (selector) if (selector.nodeType) this.context = this[0] = selector, 
            this.length = 1; else {
                if (context && context.nodeType) this.context = context; else {
                    if (context) return DomQuery(selector).attr(context);
                    this.context = context = document;
                }
                if (isString(selector)) {
                    if (!(match = "<" === (this.selector = selector).charAt(0) && ">" === selector.charAt(selector.length - 1) && 3 <= selector.length ? [ null, selector, null ] : rquickExpr.exec(selector))) return DomQuery(context).find(selector);
                    if (match[1]) for (node = createFragment(selector, getElementDocument(context)).firstChild; node; ) push.call(this, node), 
                    node = node.nextSibling; else {
                        if (!(node = getElementDocument(context).getElementById(match[2]))) return this;
                        if (node.id !== match[2]) return this.find(selector);
                        this.length = 1, this[0] = node;
                    }
                } else this.add(selector, !1);
            }
            return this;
        },
        toArray: function() {
            return Tools$6.toArray(this);
        },
        add: function(items, sort) {
            var nodes, i;
            if (isString(items)) return this.add(DomQuery(items));
            if (!1 !== sort) for (nodes = DomQuery.unique(this.toArray().concat(DomQuery.makeArray(items))), 
            this.length = nodes.length, i = 0; i < nodes.length; i++) this[i] = nodes[i]; else push.apply(this, DomQuery.makeArray(items));
            return this;
        },
        attr: function(name, value) {
            var hook, self = this;
            if ("object" == typeof name) each$1(name, function(name, value) {
                self.attr(name, value);
            }); else {
                if (void 0 === value) {
                    if (self[0] && 1 === self[0].nodeType) {
                        if ((hook = attrHooks[name]) && hook.get) return hook.get(self[0], name);
                        if (booleanMap[name]) return self.prop(name) ? name : void 0;
                        null === (value = self[0].getAttribute(name, 2)) && (value = void 0);
                    }
                    return value;
                }
                this.each(function() {
                    var hook;
                    1 === this.nodeType && ((hook = attrHooks[name]) && hook.set ? hook.set(this, value) : null === value ? this.removeAttribute(name, 2) : this.setAttribute(name, value, 2));
                });
            }
            return self;
        },
        removeAttr: function(name) {
            return this.attr(name, null);
        },
        prop: function(name, value) {
            var self = this;
            if ("object" == typeof (name = propFix[name] || name)) each$1(name, function(name, value) {
                self.prop(name, value);
            }); else {
                if (void 0 === value) return self[0] && self[0].nodeType && name in self[0] ? self[0][name] : value;
                this.each(function() {
                    1 === this.nodeType && (this[name] = value);
                });
            }
            return self;
        },
        css: function(name, value) {
            function camel(name) {
                return name.replace(/-(\D)/g, function(a, b) {
                    return b.toUpperCase();
                });
            }
            function dashed(name) {
                return name.replace(/[A-Z]/g, function(a) {
                    return "-" + a;
                });
            }
            var elm, hook, self = this;
            if ("object" == typeof name) each$1(name, function(name, value) {
                self.css(name, value);
            }); else if (void 0 !== value) name = camel(name), "number" != typeof value || numericCssMap[name] || (value = value.toString() + "px"), 
            self.each(function() {
                var style = this.style;
                if ((hook = cssHooks[name]) && hook.set) hook.set(this, value); else {
                    try {
                        this.style[cssFix[name] || name] = value;
                    } catch (ex) {}
                    null !== value && "" !== value || (style.removeProperty ? style.removeProperty(dashed(name)) : style.removeAttribute(name));
                }
            }); else {
                if (elm = self[0], (hook = cssHooks[name]) && hook.get) return hook.get(elm);
                if (!elm.ownerDocument.defaultView) return elm.currentStyle ? elm.currentStyle[camel(name)] : "";
                try {
                    return elm.ownerDocument.defaultView.getComputedStyle(elm, null).getPropertyValue(dashed(name));
                } catch (ex) {
                    return;
                }
            }
            return self;
        },
        remove: function() {
            for (var node, i = this.length; i--; ) node = this[i], Event.clean(node), 
            node.parentNode && node.parentNode.removeChild(node);
            return this;
        },
        empty: function() {
            for (var node, i = this.length; i--; ) for (node = this[i]; node.firstChild; ) node.removeChild(node.firstChild);
            return this;
        },
        html: function(value) {
            var i;
            if (void 0 === value) return this[0] ? this[0].innerHTML : "";
            i = this.length;
            try {
                for (;i--; ) this[i].innerHTML = value;
            } catch (ex) {
                DomQuery(this[i]).empty().append(value);
            }
            return this;
        },
        text: function(value) {
            var i;
            if (void 0 === value) return this[0] ? this[0].innerText || this[0].textContent : "";
            for (i = this.length; i--; ) "innerText" in this[i] ? this[i].innerText = value : this[0].textContent = value;
            return this;
        },
        append: function() {
            return domManipulate(this, arguments, function(node) {
                (1 === this.nodeType || this.host && 1 === this.host.nodeType) && this.appendChild(node);
            });
        },
        prepend: function() {
            return domManipulate(this, arguments, function(node) {
                (1 === this.nodeType || this.host && 1 === this.host.nodeType) && this.insertBefore(node, this.firstChild);
            }, !0);
        },
        before: function() {
            return this[0] && this[0].parentNode ? domManipulate(this, arguments, function(node) {
                this.parentNode.insertBefore(node, this);
            }) : this;
        },
        after: function() {
            return this[0] && this[0].parentNode ? domManipulate(this, arguments, function(node) {
                this.parentNode.insertBefore(node, this.nextSibling);
            }, !0) : this;
        },
        appendTo: function(val) {
            return DomQuery(val).append(this), this;
        },
        prependTo: function(val) {
            return DomQuery(val).prepend(this), this;
        },
        replaceWith: function(content) {
            return this.before(content).remove();
        },
        wrap: function(content) {
            return wrap(this, content);
        },
        wrapAll: function(content) {
            return wrap(this, content, !0);
        },
        wrapInner: function(content) {
            return this.each(function() {
                DomQuery(this).contents().wrapAll(content);
            }), this;
        },
        unwrap: function() {
            return this.parent().each(function() {
                DomQuery(this).replaceWith(this.childNodes);
            });
        },
        clone: function() {
            var result = [];
            return this.each(function() {
                result.push(this.cloneNode(!0));
            }), DomQuery(result);
        },
        addClass: function(className) {
            return this.toggleClass(className, !0);
        },
        removeClass: function(className) {
            return this.toggleClass(className, !1);
        },
        toggleClass: function(className, state) {
            var self = this;
            return "string" == typeof className && (-1 !== className.indexOf(" ") ? each$1(className.split(" "), function() {
                self.toggleClass(this, state);
            }) : self.each(function(index, node) {
                var existingClassName, classState = hasClass(node, className);
                classState !== state && (existingClassName = node.className, classState ? node.className = trim$2((" " + existingClassName + " ").replace(" " + className + " ", " ")) : node.className += existingClassName ? " " + className : className);
            })), self;
        },
        hasClass: function(className) {
            return hasClass(this[0], className);
        },
        each: function(callback) {
            return each$1(this, callback);
        },
        on: function(name, callback) {
            return this.each(function() {
                Event.bind(this, name, callback);
            });
        },
        off: function(name, callback) {
            return this.each(function() {
                Event.unbind(this, name, callback);
            });
        },
        trigger: function(name) {
            return this.each(function() {
                "object" == typeof name ? Event.dispatch(this, name.type, name) : Event.dispatch(this, name);
            });
        },
        show: function() {
            return this.css("display", "");
        },
        hide: function() {
            return this.css("display", "none");
        },
        slice: function() {
            return new DomQuery(slice.apply(this, arguments));
        },
        eq: function(index) {
            return -1 === index ? this.slice(index) : this.slice(index, +index + 1);
        },
        first: function() {
            return this.eq(0);
        },
        last: function() {
            return this.eq(-1);
        },
        find: function(selector) {
            for (var ret = [], i = 0, l = this.length; i < l; i++) DomQuery.find(selector, this[i], ret);
            return DomQuery(ret);
        },
        filter: function(selector) {
            return DomQuery("function" == typeof selector ? grep(this.toArray(), function(item, i) {
                return selector(i, item);
            }) : DomQuery.filter(selector, this.toArray()));
        },
        closest: function(selector) {
            var result = [];
            return selector instanceof DomQuery && (selector = selector[0]), this.each(function(i, node) {
                for (;node; ) {
                    if ("string" == typeof selector && DomQuery(node).is(selector)) {
                        result.push(node);
                        break;
                    }
                    if (node === selector) {
                        result.push(node);
                        break;
                    }
                    node = node.parentNode;
                }
            }), DomQuery(result);
        },
        offset: function(offset) {
            var doc, docElm, x = 0, y = 0;
            return offset ? this.css(offset) : ((offset = this[0]) && (docElm = (doc = offset.ownerDocument).documentElement, 
            offset.getBoundingClientRect) && (x = (offset = offset.getBoundingClientRect()).left + (docElm.scrollLeft || doc.body.scrollLeft) - docElm.clientLeft, 
            y = offset.top + (docElm.scrollTop || doc.body.scrollTop) - docElm.clientTop), 
            {
                left: x,
                top: y
            });
        },
        push: push,
        sort: [].sort,
        splice: [].splice
    }, Tools$6.extend(DomQuery, {
        extend: Tools$6.extend,
        makeArray: function(object) {
            var obj;
            return (obj = object) && obj === obj.window || object.nodeType ? [ object ] : Tools$6.toArray(object);
        },
        inArray: function(item, array) {
            var i;
            if (array.indexOf) return array.indexOf(item);
            for (i = array.length; i--; ) if (array[i] === item) return i;
            return -1;
        },
        isArray: Tools$6.isArray,
        each: each$1,
        trim: trim$2,
        grep: grep,
        find: Sizzle,
        expr: Sizzle.selectors,
        unique: Sizzle.uniqueSort,
        text: Sizzle.getText,
        contains: Sizzle.contains,
        filter: function(expr, elems, not) {
            var i = elems.length;
            for (not && (expr = ":not(" + expr + ")"); i--; ) 1 !== elems[i].nodeType && elems.splice(i, 1);
            return elems = 1 === elems.length ? DomQuery.find.matchesSelector(elems[0], expr) ? [ elems[0] ] : [] : DomQuery.find.matches(expr, elems);
        }
    }), each$1({
        parent: function(node) {
            node = node.parentNode;
            return node && 11 !== node.nodeType ? node : null;
        },
        parents: function(node) {
            return dir(node, "parentNode");
        },
        next: function(node) {
            return firstSibling(node, "nextSibling", 1);
        },
        prev: function(node) {
            return firstSibling(node, "previousSibling", 1);
        },
        children: function(node) {
            return sibling(node.firstChild, "nextSibling", 1);
        },
        contents: function(node) {
            return Tools$6.toArray(("iframe" === node.nodeName ? node.contentDocument || node.contentWindow.document : node).childNodes);
        }
    }, function(name, fn) {
        DomQuery.fn[name] = function(selector) {
            var result = [];
            return this.each(function() {
                var nodes = fn.call(result, this, selector, result);
                nodes && (DomQuery.isArray(nodes) ? result.push.apply(result, nodes) : result.push(nodes));
            }), 1 < this.length && (skipUniques[name] || (result = DomQuery.unique(result)), 
            0 === name.indexOf("parents")) && (result = result.reverse()), result = DomQuery(result), 
            selector ? result.filter(selector) : result;
        };
    }), each$1({
        parentsUntil: function(node, until) {
            return dir(node, "parentNode", until);
        },
        nextUntil: function(node, until) {
            return sibling(node, "nextSibling", 1, until).slice(1);
        },
        prevUntil: function(node, until) {
            return sibling(node, "previousSibling", 1, until).slice(1);
        }
    }, function(name, fn) {
        DomQuery.fn[name] = function(selector, filter) {
            var result = [];
            return this.each(function() {
                var nodes = fn.call(result, this, selector, result);
                nodes && (DomQuery.isArray(nodes) ? result.push.apply(result, nodes) : result.push(nodes));
            }), 1 < this.length && (result = DomQuery.unique(result), 0 !== name.indexOf("parents") && "prevUntil" !== name || (result = result.reverse())), 
            result = DomQuery(result), filter ? result.filter(filter) : result;
        };
    }), DomQuery.fn.is = function(selector) {
        return !!selector && 0 < this.filter(selector).length;
    }, DomQuery.fn.init.prototype = DomQuery.fn, DomQuery.overrideDefaults = function(callback) {
        function sub(selector, context) {
            return defaults = defaults || callback(), 0 === arguments.length && (selector = defaults.element), 
            context = context || defaults.context, new sub.fn.init(selector, context);
        }
        var defaults;
        return DomQuery.extend(sub, this), sub;
    }, DomQuery.attrHooks = attrHooks, DomQuery.cssHooks = cssHooks, 0);
    function get(elm) {
        return elm && "string" == typeof elm ? document.getElementById(elm) : elm;
    }
    function getRoot() {
        return document.body;
    }
    function getParents(elm, selector, root, collect) {
        var selectorVal, result = [], node = get(elm);
        for (collect = void 0 === collect, root = root || ("BODY" !== getRoot().nodeName ? getRoot().parentNode : null), 
        Tools$6.is(selector, "string") && (selector = "*" === (selectorVal = selector) ? function(node) {
            return 1 === node.nodeType;
        } : function(node) {
            return 0 < DomQuery(node).find(selectorVal).length;
        }); node && node !== root && node.nodeType && 9 !== node.nodeType; ) {
            if (!selector || "function" == typeof selector && selector(node)) {
                if (!collect) return [ node ];
                result.push(node);
            }
            node = node.parentNode;
        }
        return collect ? result : null;
    }
    var funcs = {
        id: function() {
            return "mceu_" + count$2++;
        },
        create: function(name, attrs, children) {
            var elm = document.createElement(name);
            return DomQuery(elm).attr(attrs), "string" == typeof children ? elm.innerHTML = children : Tools$6.each(children, function(child) {
                child.nodeType && elm.appendChild(child);
            }), elm;
        },
        createFragment: function(html) {
            return DomQuery(html);
        },
        getWindowSize: function() {
            return this.getViewPort();
        },
        getSize: function(elm) {
            var width, rect;
            return rect = elm.getBoundingClientRect ? (rect = elm.getBoundingClientRect(), 
            width = Math.max(rect.width || rect.right - rect.left, elm.offsetWidth), 
            Math.max(rect.height || rect.bottom - rect.bottom, elm.offsetHeight)) : (width = elm.offsetWidth, 
            elm.offsetHeight), {
                width: width,
                height: rect
            };
        },
        getPos: function(elm, root) {
            var offsetParent, pos, rootElm = root || funcs.getContainer(), x = 0, y = 0, root = document, body = root.body;
            if (elm) {
                if (rootElm === body && elm.getBoundingClientRect && "static" === DomQuery(body).css("position")) return pos = elm.getBoundingClientRect(), 
                rootElm = self.boxModel ? root.documentElement : body, {
                    x: x = pos.left + (root.documentElement.scrollLeft || body.scrollLeft) - rootElm.clientLeft,
                    y: y = pos.top + (root.documentElement.scrollTop || body.scrollTop) - rootElm.clientTop
                };
                for (offsetParent = elm; offsetParent && offsetParent != rootElm && offsetParent.nodeType; ) x += offsetParent.offsetLeft || 0, 
                y += offsetParent.offsetTop || 0, offsetParent = offsetParent.offsetParent;
                for (offsetParent = elm.parentNode; offsetParent && offsetParent != rootElm && offsetParent.nodeType; ) x -= offsetParent.scrollLeft || 0, 
                y -= offsetParent.scrollTop || 0, offsetParent = offsetParent.parentNode;
            }
            return {
                x: x,
                y: y
            };
        },
        getContainer: function() {
            return Env$1.container || document.body;
        },
        getViewPort: function(win) {
            var rootElm = (win = win || window).document.body;
            return {
                x: win.pageXOffset || rootElm.scrollLeft,
                y: win.pageYOffset || rootElm.scrollTop,
                w: win.innerWidth || rootElm.clientWidth,
                h: win.innerHeight || rootElm.clientHeight
            };
        },
        get: get,
        getParents: getParents,
        getParent: function(node, selector, root) {
            node = getParents(node, selector, root, !1);
            return node && 0 < node.length ? node[0] : null;
        },
        select: function(selector) {
            return DomQuery(getRoot()).find(selector);
        },
        addClass: function(elm, cls) {
            return DomQuery(elm).addClass(cls);
        },
        removeClass: function(elm, cls) {
            return DomQuery(elm).removeClass(cls);
        },
        hasClass: function(elm, cls) {
            return DomQuery(elm).hasClass(cls);
        },
        toggleClass: function(elm, cls, state) {
            return DomQuery(elm).toggleClass(cls);
        },
        css: function(elm, name, value) {
            return DomQuery(elm).css(name, value);
        },
        getRuntimeStyle: function(elm, name) {
            return DomQuery(elm).css(name);
        },
        on: function(target, name, callback) {
            return EventUtils.Event.bind(target, name, callback);
        },
        off: function(target, name, callback) {
            return EventUtils.Event.unbind(target, name, callback);
        },
        fire: function(target, name, args) {
            return EventUtils.Event.dispatch(target, name, args);
        },
        dispatch: function(target, name, args) {
            return EventUtils.Event.dispatch(target, name, args);
        },
        innerHtml: function(elm, html) {
            DomQuery(elm).html(html);
        }
    }, Rect$1 = {
        initLayoutRect: function() {
            var settings = this.settings, elm = this.getEl(), elm = funcs.getSize(elm), startMinWidth = settings.minWidth, startMinHeight = settings.minHeight, minWidth = startMinWidth || elm.width, elm = startMinHeight || elm.height, width = settings.width, height = settings.height, autoResize = settings.autoResize, maxW = (autoResize = void 0 !== autoResize ? autoResize : !width && !height, 
            settings.maxWidth || 65535), maxH = settings.maxHeight || 65535;
            return this._layoutRect = settings = {
                x: settings.x || 0,
                y: settings.y || 0,
                w: width = width || minWidth,
                h: height = height || elm,
                deltaW: 0,
                deltaH: 0,
                contentW: +width,
                contentH: +height,
                innerW: +width,
                innerH: +height,
                startMinWidth: startMinWidth || 0,
                startMinHeight: startMinHeight || 0,
                minW: Math.min(minWidth, maxW),
                minH: Math.min(elm, maxH),
                maxW: maxW,
                maxH: maxH,
                autoResize: autoResize,
                scrollW: 0
            }, this._lastLayoutRect = {}, settings;
        },
        layoutRect: function(newRect) {
            var deltaWidth, deltaHeight, size, curRect = (curRect = this._layoutRect) || this.initLayoutRect();
            return newRect ? (deltaWidth = curRect.deltaW, deltaHeight = curRect.deltaH, 
            void 0 !== newRect.x && (curRect.x = newRect.x), void 0 !== newRect.y && (curRect.y = newRect.y), 
            void 0 !== newRect.minW && (curRect.minW = newRect.minW), void 0 !== newRect.minH && (curRect.minH = newRect.minH), 
            void 0 !== (size = newRect.w) && (size = (size = size < curRect.minW ? curRect.minW : size) > curRect.maxW ? curRect.maxW : size, 
            curRect.w = size, curRect.innerW = size - deltaWidth), void 0 !== (size = newRect.h) && (size = (size = size < curRect.minH ? curRect.minH : size) > curRect.maxH ? curRect.maxH : size, 
            curRect.h = size, curRect.innerH = size - deltaHeight), void 0 !== (size = newRect.innerW) && (size = (size = size < curRect.minW - deltaWidth ? curRect.minW - deltaWidth : size) > curRect.maxW - deltaWidth ? curRect.maxW - deltaWidth : size, 
            curRect.innerW = size, curRect.w = size + deltaWidth), void 0 !== (size = newRect.innerH) && (size = (size = size < curRect.minH - deltaHeight ? curRect.minH - deltaHeight : size) > curRect.maxH - deltaHeight ? curRect.maxH - deltaHeight : size, 
            curRect.innerH = size, curRect.h = size + deltaHeight), void 0 !== newRect.contentW && (curRect.contentW = newRect.contentW), 
            void 0 !== newRect.contentH && (curRect.contentH = newRect.contentH), 
            (deltaWidth = this._lastLayoutRect).x === curRect.x && deltaWidth.y === curRect.y && deltaWidth.w === curRect.w && deltaWidth.h === curRect.h || ((size = this.repaintControls) && size.map && !size.map[this._id] && (size.push(this), 
            size.map[this._id] = !0), deltaWidth.x = curRect.x, deltaWidth.y = curRect.y, 
            deltaWidth.w = curRect.w, deltaWidth.h = curRect.h), this) : curRect;
        },
        repaint: function() {
            var value, round = Math.round, style = this.getEl().style, rect = this._layoutRect, lastRepaintRect = this._lastRepaintRect || {};
            rect.x !== lastRepaintRect.x && (style.left = round(rect.x) + "px", 
            lastRepaintRect.x = rect.x), rect.y !== lastRepaintRect.y && (style.top = round(rect.y) + "px", 
            lastRepaintRect.y = rect.y), rect.autoResize || (rect.w !== lastRepaintRect.w && (value = round(rect.w), 
            style.width = (0 <= value ? value : 0) + "px", lastRepaintRect.w = rect.w), 
            rect.h !== lastRepaintRect.h && (value = round(rect.h), style.height = (0 <= value ? value : 0) + "px", 
            lastRepaintRect.h = rect.h)), this._lastRepaintRect = lastRepaintRect, 
            this.dispatch("repaint", {}, !1);
        },
        updateLayoutRect: function() {
            this.parent()._lastRect = null, funcs.css(this.getEl(), {
                width: "",
                height: ""
            }), this._layoutRect = this._lastRepaintRect = this._lastLayoutRect = null, 
            this.initLayoutRect();
        }
    }, hasMouseWheelEventSupport = "onmousewheel" in document, hasWheelEventSupport = !1, idCounter = 0, proto = {
        Mixins: [ Rect$1 ],
        Statics: {
            classPrefix: "wfe-"
        },
        isRtl: function() {
            return Control.rtl;
        },
        classPrefix: "wfe-",
        init: function(settings) {
            var classes, defaultClasses, self = this;
            function applyClasses(classes) {
                var i;
                for (classes = classes.split(" "), i = 0; i < classes.length; i++) self.classes.add(classes[i]);
            }
            self.settings = settings = Tools$6.extend({}, self.Defaults, settings), 
            self._id = settings.id || "mceu_" + idCounter++, self._aria = {
                role: settings.role
            }, self._elmCache = {}, self.$ = DomQuery, self.state = new ObservableObject({
                visible: !0,
                active: !1,
                disabled: !1,
                value: ""
            }), self.data = new ObservableObject(settings.data), self.classes = new ClassList(function() {
                self.state.get("rendered") && (self.getEl().className = this.toString());
            }), self.classes.prefix = self.classPrefix, self.classes.add("tox-mce-ui"), 
            (classes = settings.classes) && (self.Defaults && (defaultClasses = self.Defaults.classes) && classes != defaultClasses && applyClasses(defaultClasses), 
            applyClasses(classes)), Tools$6.each("title text name visible disabled active value".split(" "), function(name) {
                name in settings && self[name](settings[name]);
            }), self.on("click", function() {
                if (self.disabled()) return !1;
            }), (self.settings = settings).hidden && self.hide();
        },
        Properties: "parent,name",
        getContainerElm: function() {
            return funcs.getContainer();
        },
        getParentCtrl: function(elm) {
            for (var ctrl, lookup = this.getRoot().controlIdLookup; elm && lookup && !(ctrl = lookup[elm.id]); ) elm = elm.parentNode;
            return ctrl;
        },
        on: function(name, callback) {
            var self = this;
            return getEventDispatcher(self).on(name, function(name) {
                var callback, scope;
                return "string" != typeof name ? name : function(e) {
                    if (callback || self.parentsAndSelf().each(function(ctrl) {
                        var callbacks = ctrl.settings.callbacks;
                        if (callbacks && (callback = callbacks[name])) return scope = ctrl, 
                        !1;
                    }), callback) return callback.call(scope, e);
                    e.action = name, this.dispatch("execute", e);
                };
            }(callback)), self;
        },
        off: function(name, callback) {
            return getEventDispatcher(this).off(name, callback), this;
        },
        dispatch: function(name, args, bubble) {
            if ((args = args || {}).control || (args.control = this), args = getEventDispatcher(this).dispatch(name, args), 
            !1 !== bubble && this.parent) for (var parent = this.parent(); parent && !args.isPropagationStopped(); ) parent.dispatch(name, args, !1), 
            parent = parent.parent();
            return args;
        },
        hasEventListeners: function(name) {
            return getEventDispatcher(this).has(name);
        },
        parents: function(selector) {
            for (var parents = new Collection$1(), ctrl = this.parent(); ctrl; ctrl = ctrl.parent()) parents.add(ctrl);
            return parents = selector ? parents.filter(selector) : parents;
        },
        parentsAndSelf: function(selector) {
            return new Collection$1(this).add(this.parents(selector));
        },
        next: function() {
            var parentControls = this.parent().items();
            return parentControls[parentControls.indexOf(this) + 1];
        },
        prev: function() {
            var parentControls = this.parent().items();
            return parentControls[parentControls.indexOf(this) - 1];
        },
        innerHtml: function(html) {
            return this.$el.html(html), this;
        },
        getEl: function(suffix) {
            suffix = suffix ? this._id + "-" + suffix : this._id;
            return this._elmCache[suffix] || (this._elmCache[suffix] = DomQuery("#" + suffix)[0]), 
            this._elmCache[suffix];
        },
        show: function() {
            return this.visible(!0);
        },
        hide: function() {
            return this.visible(!1);
        },
        focus: function(option) {
            try {
                this.getEl().focus(option);
            } catch (ex) {}
            return this;
        },
        blur: function() {
            return this.getEl().blur(), this;
        },
        aria: function(name, value) {
            var elm = this.getEl(this.ariaTarget);
            return void 0 === value ? this._aria[name] : (this._aria[name] = value, 
            this.state.get("rendered") && elm.setAttribute("role" == name ? name : "aria-" + name, value), 
            this);
        },
        encode: function(text, translate) {
            return ((text = !1 !== translate ? this.translate(text) : text) || "").replace(/[&<>"]/g, function(match) {
                return "&#" + match.charCodeAt(0) + ";";
            });
        },
        translate: function(text) {
            return Control.translate ? Control.translate(text) : text;
        },
        before: function(items) {
            var parent = this.parent();
            return parent && parent.insert(items, parent.items().indexOf(this), !0), 
            this;
        },
        after: function(items) {
            var parent = this.parent();
            return parent && parent.insert(items, parent.items().indexOf(this)), 
            this;
        },
        remove: function() {
            var newItems, self = this, elm = self.getEl(), parent = self.parent();
            if (self.items) for (var controls = self.items().toArray(), i = controls.length; i--; ) controls[i].remove();
            parent && parent.items && (newItems = [], parent.items().each(function(item) {
                item !== self && newItems.push(item);
            }), parent.items().set(newItems), parent._lastRect = null), self._eventsRoot && self._eventsRoot == self && DomQuery(elm).off();
            parent = self.getRoot().controlIdLookup;
            return parent && delete parent[self._id], elm && elm.parentNode && elm.parentNode.removeChild(elm), 
            self.state.set("rendered", !1), self.state.destroy(), self.dispatch("remove"), 
            self;
        },
        renderBefore: function(elm) {
            return DomQuery(elm).before(this.renderHtml()), this.postRender(), this;
        },
        renderTo: function(elm) {
            return DomQuery(elm || this.getContainerElm()).append(this.renderHtml()), 
            this.postRender(), this;
        },
        preRender: function() {
            var html = this.settings.html || "";
            html && "string" == typeof html && (this.settings.html = html.replaceAll("${prefix}-", this.classPrefix));
        },
        render: function() {},
        renderHtml: function() {
            return '<div id="' + this._id + '" class="' + this.classes + '"></div>';
        },
        postRender: function() {
            var parent, name, parentEventsRoot, self = this, settings = self.settings;
            for (name in self.$el = DomQuery(self.getEl()), self.state.set("rendered", !0), 
            settings) 0 === name.indexOf("on") && self.on(name.substr(2), settings[name]);
            if (self._eventsRoot) {
                for (parent = self.parent(); !parentEventsRoot && parent; parent = parent.parent()) parentEventsRoot = parent._eventsRoot;
                if (parentEventsRoot) for (name in parentEventsRoot._nativeEvents) self._nativeEvents[name] = !0;
            }
            bindPendingEvents(self), settings.style && (elm = self.getEl()) && (elm.setAttribute("style", settings.style), 
            elm.style.cssText = settings.style);
            var key, elm = self.getRoot();
            for (key in elm.controlIdLookup || (elm.controlIdLookup = {}), (elm.controlIdLookup[self._id] = self)._aria) self.aria(key, self._aria[key]);
            !1 === self.state.get("visible") && (self.getEl().style.display = "none"), 
            self.bindStates(), self.state.on("change:visible", function(e) {
                e = e.value;
                self.state.get("rendered") && (self.getEl().style.display = !1 === e ? "none" : ""), 
                self.dispatch(e ? "show" : "hide");
            }), self.dispatch("postrender", {}, !1);
        },
        bindStates: function() {},
        scrollIntoView: function(align) {
            var elm = this.getEl(), parentElm = elm.parentNode, pos = function(elm, rootElm) {
                for (var y, parent = elm, x = y = 0; parent && parent != rootElm && parent.nodeType; ) x += parent.offsetLeft || 0, 
                y += parent.offsetTop || 0, parent = parent.offsetParent;
                return {
                    x: x,
                    y: y
                };
            }(elm, parentElm), x = pos.x, pos = pos.y, width = elm.offsetWidth, elm = elm.offsetHeight, parentWidth = parentElm.clientWidth, parentHeight = parentElm.clientHeight;
            return "end" == align ? (x -= parentWidth - width, pos -= parentHeight - elm) : "center" == align && (x -= parentWidth / 2 - width / 2, 
            pos -= parentHeight / 2 - elm / 2), parentElm.scrollLeft = x, parentElm.scrollTop = pos, 
            this;
        },
        getRoot: function() {
            for (var ctrl = this, parents = []; ctrl; ) {
                if (ctrl.rootControl) {
                    rootControl = ctrl.rootControl;
                    break;
                }
                parents.push(ctrl), ctrl = (rootControl = ctrl).parent();
            }
            for (var rootControl = rootControl || this, i = parents.length; i--; ) parents[i].rootControl = rootControl;
            return rootControl;
        },
        reflow: function() {
            return this;
        }
    };
    function getEventDispatcher(obj) {
        return obj._eventDispatcher || (obj._eventDispatcher = new Dispatcher({
            scope: obj,
            toggleEvent: function(name, state) {
                state && Dispatcher.isNative(name) && (obj._nativeEvents || (obj._nativeEvents = {}), 
                obj._nativeEvents[name] = !0, obj.state.get("rendered")) && bindPendingEvents(obj);
            }
        })), obj._eventDispatcher;
    }
    function bindPendingEvents(eventCtrl) {
        var i, l, parents, eventRootCtrl, nativeEvents, name;
        function delegate(e) {
            var control = eventCtrl.getParentCtrl(e.target);
            control && control.dispatch(e.type, e);
        }
        function mouseLeaveHandler() {
            var ctrl = eventRootCtrl._lastHoverCtrl;
            ctrl && (ctrl.dispatch("mouseleave", {
                target: ctrl.getEl()
            }), ctrl.parents().each(function(ctrl) {
                ctrl.dispatch("mouseleave", {
                    target: ctrl.getEl()
                });
            }), eventRootCtrl._lastHoverCtrl = null);
        }
        function mouseEnterHandler(e) {
            var i, parents, lastParents, ctrl = eventCtrl.getParentCtrl(e.target), lastCtrl = eventRootCtrl._lastHoverCtrl, idx = 0;
            if (ctrl !== lastCtrl) {
                if ((parents = (eventRootCtrl._lastHoverCtrl = ctrl).parents().toArray().reverse()).push(ctrl), 
                lastCtrl) {
                    for ((lastParents = lastCtrl.parents().toArray().reverse()).push(lastCtrl), 
                    idx = 0; idx < lastParents.length && parents[idx] === lastParents[idx]; idx++);
                    for (i = lastParents.length - 1; idx <= i; i--) (lastCtrl = lastParents[i]).dispatch("mouseleave", {
                        target: lastCtrl.getEl()
                    });
                }
                for (i = idx; i < parents.length; i++) (ctrl = parents[i]).dispatch("mouseenter", {
                    target: ctrl.getEl()
                });
            }
        }
        function fixWheelEvent(e) {
            e.preventDefault(), "mousewheel" == e.type ? (e.deltaY = -.025 * e.wheelDelta, 
            e.wheelDeltaX && (e.deltaX = -.025 * e.wheelDeltaX)) : (e.deltaX = 0, 
            e.deltaY = e.detail), eventCtrl.dispatch("wheel", e);
        }
        if (nativeEvents = eventCtrl._nativeEvents) {
            for ((parents = eventCtrl.parents().toArray()).unshift(eventCtrl), i = 0, 
            l = parents.length; !eventRootCtrl && i < l; i++) eventRootCtrl = parents[i]._eventsRoot;
            for (eventRootCtrl = eventRootCtrl || parents[parents.length - 1] || eventCtrl, 
            eventCtrl._eventsRoot = eventRootCtrl, l = i, i = 0; i < l; i++) parents[i]._eventsRoot = eventRootCtrl;
            var eventRootDelegates = (eventRootDelegates = eventRootCtrl._delegates) || (eventRootCtrl._delegates = {});
            for (name in nativeEvents) {
                if (!nativeEvents) return;
                "wheel" !== name || hasWheelEventSupport ? ("mouseenter" === name || "mouseleave" === name ? eventRootCtrl._hasMouseEnter || (DomQuery(eventRootCtrl.getEl()).on("mouseleave", mouseLeaveHandler).on("mouseover", mouseEnterHandler), 
                eventRootCtrl._hasMouseEnter = 1) : eventRootDelegates[name] || (DomQuery(eventRootCtrl.getEl()).on(name, delegate), 
                eventRootDelegates[name] = !0), nativeEvents[name] = !1) : hasMouseWheelEventSupport ? DomQuery(eventCtrl.getEl()).on("mousewheel", fixWheelEvent) : DomQuery(eventCtrl.getEl()).on("DOMMouseScroll", fixWheelEvent);
            }
        }
    }
    Tools$6.each("text title visible disabled active value".split(" "), function(name) {
        proto[name] = function(value) {
            return 0 === arguments.length ? this.state.get(name) : (void 0 !== value && this.state.set(name, value), 
            this);
        };
    });
    var Control, Control$1 = Control = Class.extend(proto);
    function calculateRelativePosition(ctrl, targetElm, rel) {
        var selfH, viewport = funcs.getViewPort(), pos = funcs.getPos(targetElm), x = pos.x, pos = pos.y;
        return ctrl.state.get("fixed") && "static" == funcs.getRuntimeStyle(document.body, "position") && (x -= viewport.x, 
        pos -= viewport.y), viewport = ctrl.getEl(), viewport = (ctrl = funcs.getSize(viewport)).width, 
        selfH = ctrl.height, targetElm = (ctrl = funcs.getSize(targetElm)).width, 
        ctrl = ctrl.height, "b" === (rel = (rel || "").split(""))[0] && (pos += ctrl), 
        "r" === rel[1] && (x += targetElm), "c" === rel[0] && (pos += Math.round(ctrl / 2)), 
        "c" === rel[1] && (x += Math.round(targetElm / 2)), "b" === rel[3] && (pos -= selfH), 
        "r" === rel[4] && (x -= viewport), "c" === rel[3] && (pos -= Math.round(selfH / 2)), 
        "c" === rel[4] && (x -= Math.round(viewport / 2)), {
            x: x,
            y: pos,
            w: viewport,
            h: selfH
        };
    }
    function getUiContainer(ctrl) {
        return ctrl ? ctrl.getRoot().uiContainer : null;
    }
    function hasTabstopData(elm) {
        return !!elm.getAttribute("data-mce-tabstop");
    }
    function hasTextInputType(elm) {
        return !(elm = elm.getAttribute("type")) || -1 != Tools$6.inArray(textInputElementTypes, elm);
    }
    var Movable = {
        testMoveRel: function(elm, rels) {
            for (var viewPortRect = funcs.getViewPort(), i = 0; i < rels.length; i++) {
                var pos = calculateRelativePosition(this, elm, rels[i]);
                if (this.state.get("fixed")) {
                    if (0 < pos.x && pos.x + pos.w < viewPortRect.w && 0 < pos.y && pos.y + pos.h < viewPortRect.h) return rels[i];
                } else if (pos.x > viewPortRect.x && pos.x + pos.w < viewPortRect.w + viewPortRect.x && pos.y > viewPortRect.y && pos.y + pos.h < viewPortRect.h + viewPortRect.y) return rels[i];
            }
            return rels[0];
        },
        moveRel: function(elm, rel) {
            "string" != typeof rel && (rel = this.testMoveRel(elm, rel));
            elm = calculateRelativePosition(this, elm, rel);
            return this.moveTo(elm.x, elm.y);
        },
        moveBy: function(dx, dy) {
            var rect = this.layoutRect();
            return this.moveTo(rect.x + dx, rect.y + dy), this;
        },
        moveTo: function(x, y) {
            var viewPortRect, layoutRect;
            function constrain(value, max, size) {
                return value < 0 || max < value + size && (value = max - size) < 0 ? 0 : value;
            }
            return this.settings.constrainToViewport && (viewPortRect = funcs.getViewPort(window), 
            layoutRect = this.layoutRect(), x = constrain(x, viewPortRect.w + viewPortRect.x, layoutRect.w), 
            y = constrain(y, viewPortRect.h + viewPortRect.y, layoutRect.h)), this.state.get("rendered") ? this.layoutRect({
                x: x,
                y: y
            }).repaint() : (this.settings.x = x, this.settings.y = y), this.dispatch("move", {
                x: x,
                y: y
            }), this;
        }
    }, Tooltip = Control$1.extend({
        Mixins: [ Movable ],
        Defaults: {
            classes: "widget tooltip tooltip-n"
        },
        renderHtml: function() {
            var prefix = this.classPrefix;
            return '<div id="' + this._id + '" class="' + this.classes + '" role="presentation"><div class="' + prefix + 'tooltip-arrow"></div><div class="' + prefix + 'tooltip-inner">' + this.encode(this.state.get("text")) + "</div></div>";
        },
        bindStates: function() {
            var self = this;
            return self.state.on("change:text", function(e) {
                self.getEl().lastChild.innerHTML = self.encode(e.value);
            }), self._super();
        },
        repaint: function() {
            var style = this.getEl().style, rect = this._layoutRect;
            style.left = rect.x + "px", style.top = rect.y + "px", style.zIndex = 131070;
        }
    }), UiContainer_getUiContainerDelta = function(ctrl) {
        var containerPos, ctrl = getUiContainer(ctrl);
        return ctrl && "static" !== funcs.getStyle(ctrl, "position", !0) ? (containerPos = funcs.getPos(ctrl), 
        {
            x: ctrl.scrollLeft - containerPos.x,
            y: ctrl.scrollTop - containerPos.y
        }) : null;
    }, UiContainer_setUiContainer = function(editor, ctrl) {
        editor = funcs.select(editor.settings.ui_container)[0];
        ctrl.getRoot().uiContainer = editor;
    }, UiContainer_getUiContainer = getUiContainer, UiContainer_inheritUiContainer = function(fromCtrl, toCtrl) {
        return toCtrl.uiContainer = getUiContainer(fromCtrl);
    }, Widget = Control$1.extend({
        Mixins: [ Rect$1 ],
        init: function(settings) {
            var self = this;
            self._super(settings), settings = self.settings, self.canFocus = !0, 
            settings.tooltip && !1 !== Widget.tooltips && (self.on("mouseenter", function(e) {
                var tooltip = self.tooltip().moveTo(-65535);
                e.control === self ? (e = tooltip.text(settings.tooltip).show().testMoveRel(self.getEl(), [ "bc-tc", "bc-tl", "bc-tr" ]), 
                tooltip.classes.toggle("tooltip-n", "bc-tc" === e), tooltip.classes.toggle("tooltip-nw", "bc-tl" === e), 
                tooltip.classes.toggle("tooltip-ne", "bc-tr" === e), tooltip.moveRel(self.getEl(), e)) : tooltip.hide();
            }), self.on("mouseleave mousedown click", function() {
                self.tooltip().remove(), self._tooltip = null;
            })), self.aria("label", settings.ariaLabel || settings.tooltip);
        },
        tooltip: function() {
            return this._tooltip || (this._tooltip = new Tooltip({
                type: "tooltip"
            }), UiContainer_inheritUiContainer(this, this._tooltip), this._tooltip.renderTo()), 
            this._tooltip;
        },
        postRender: function() {
            var self = this, settings = self.settings;
            self._super(), settings.attributes && Tools$6.each(settings.attributes, function(val, name) {
                self.getEl().setAttribute(name, val);
            }), self.parent() || !settings.width && !settings.height || (self.initLayoutRect(), 
            self.repaint()), settings.autofocus && self.focus();
        },
        bindStates: function() {
            var self = this;
            function disable(state) {
                self.aria("disabled", state), self.classes.toggle("disabled", state);
            }
            function active(state) {
                self.aria("pressed", state), self.classes.toggle("active", state);
            }
            return self.state.on("change:disabled", function(e) {
                disable(e.value);
            }), self.state.on("change:active", function(e) {
                active(e.value);
            }), self.state.get("disabled") && disable(!0), self.state.get("active") && active(!0), 
            self._super();
        },
        remove: function() {
            this._super(), this._tooltip && (this._tooltip.remove(), this._tooltip = null);
        }
    }), Button = Widget.extend({
        Defaults: {
            classes: "widget btn",
            role: "button"
        },
        init: function(settings) {
            var size, self = this;
            self._super(settings), settings = self.settings, size = self.settings.size, 
            self.on("click mousedown", function(e) {
                e.target === self.getEl() && e.preventDefault();
            }), self.on("touchstart", function(e) {
                self.dispatch("click", e), e.target === self.getEl() && e.preventDefault();
            }), settings.subtype && self.classes.add(settings.subtype), size && self.classes.add("btn-" + size), 
            settings.icon && self.icon(settings.icon);
        },
        icon: function(icon) {
            return arguments.length ? (this.state.set("icon", icon), this) : this.state.get("icon");
        },
        renderHtml: function() {
            var svg, id = this._id, prefix = this.classPrefix, icon = this.state.get("icon"), text = this.state.get("text"), textHtml = "", settings = this.settings, image = settings.image;
            return image = image ? (icon = "none", " style=\"background-image: url('" + (image = "string" != typeof image ? window.getSelection ? image[0] : image[1] : image) + "')\"") : "", 
            svg = settings.svg || "", text && (this.classes.add("btn-has-text"), 
            textHtml = '<span class="' + prefix + 'txt">' + this.encode(text) + "</span>"), 
            text = "boolean" == typeof settings.active ? ' aria-pressed="' + settings.active + '"' : "", 
            '<button id="' + id + '" role="presentation" type="button" tabindex="-1" class="' + this.classes + '" tabindex="-1"' + text + ">" + ((icon = icon ? prefix + "ico " + prefix + "i-" + icon : "") ? '<span class="' + icon + '"' + image + "></span>" : "") + (svg || "") + textHtml + "</button>";
        },
        bindStates: function() {
            var self = this, $ = self.$, textCls = self.classPrefix + "txt";
            function setButtonText(text) {
                var $span = $("span." + textCls, self.getEl());
                text ? ($span[0] || ($("button:first", self.getEl()).append('<span class="' + textCls + '"></span>'), 
                $span = $("span." + textCls, self.getEl())), $span.html(self.encode(text))) : $span.remove(), 
                self.classes.toggle("btn-has-text", !!text);
            }
            return self.state.on("change:text", function(e) {
                setButtonText(e.value);
            }), self.state.on("change:icon", function(e) {
                var e = e.value, prefix = self.classPrefix, prefix = (e = (self.settings.icon = e) ? prefix + "ico " + prefix + "i-" + self.settings.icon : "", 
                self.getEl().firstChild), iconElm = prefix.getElementsByTagName("i")[0];
                e ? (iconElm && iconElm == prefix.firstChild || (iconElm = document.createElement("i"), 
                prefix.insertBefore(iconElm, prefix.firstChild)), iconElm.className = e) : iconElm && prefix.removeChild(iconElm), 
                setButtonText(self.state.get("text"));
            }), self._super();
        }
    }), $$8 = DomQuery, BrowseButton = Button.extend({
        init: function(settings) {
            settings = Tools$6.extend({
                text: "Browse...",
                multiple: !1,
                accept: null
            }, settings), this._super(settings), this.classes.add("browsebutton"), 
            settings.multiple && this.classes.add("multiple");
        },
        postRender: function() {
            var self = this, input = funcs.create("input", {
                type: "file",
                id: self._id + "-browse",
                accept: self.settings.accept
            });
            self._super(), $$8(input).on("change", function(e) {
                var files = e.target.files;
                self.value = function() {
                    return files.length ? self.settings.multiple ? files : files[0] : null;
                }, e.preventDefault(), files.length && self.dispatch("change", e);
            }), $$8(input).on("click", function(e) {
                e.stopPropagation();
            }), $$8(self.getEl("button")).on("click", function(e) {
                e.stopPropagation(), input.click();
            });
        },
        remove: function() {
            $$8(this.getEl("button")).off(), $$8(this.getEl("input")).off(), this._super();
        }
    }), types = {}, Factory = {
        add: function(type, typeClass) {
            types[type.toLowerCase()] = typeClass;
        },
        has: function(type) {
            return !!types[type.toLowerCase()];
        },
        get: function(type) {
            var lctype = type.toLowerCase(), lctype = Tools$6.hasOwn(types, lctype) ? types[lctype] : null;
            if (null === lctype) throw new Error("Could not find module for type: " + type);
            return lctype;
        },
        create: function(type, settings) {
            var ControlType;
            if ("string" == typeof type ? (settings = settings || {}).type = type : type = (settings = type).type, 
            type = type.toLowerCase(), ControlType = types[type]) return (ControlType = new ControlType(settings)).type = type, 
            ControlType;
            throw new Error("Could not find control by type: " + type);
        }
    }, textInputElementTypes = [ "date", "datetime-local", "email", "month", "number", "password", "search", "tel", "text", "time", "url", "week" ];
    function KeyboardNavigation(settings) {
        var focusedElement, focusedControl, root = settings.root;
        function isElement(node) {
            return node && 1 === node.nodeType;
        }
        try {
            focusedElement = document.activeElement;
        } catch (ex) {
            focusedElement = document.body;
        }
        function getRole(elm) {
            return isElement(elm = elm || focusedElement) ? elm.getAttribute("role") : null;
        }
        function getParentRole() {
            for (var role, parent = focusedElement; parent = parent.parentNode; ) if (role = getRole(parent)) return role;
        }
        function getAriaProp(name) {
            var elm = focusedElement;
            return isElement(elm) && elm.getAttribute("aria-" + name);
        }
        function isTextInputElement(elm) {
            elm = elm.tagName.toUpperCase();
            return "INPUT" == elm || "TEXTAREA" == elm || "SELECT" == elm;
        }
        function getFocusElements(elm) {
            var elements = [];
            return function collect(elm) {
                if (1 == elm.nodeType && "none" != elm.style.display && !elm.disabled) {
                    !function(elm) {
                        return isTextInputElement(elm) && !elm.hidden || hasTabstopData(elm) || /^(button|menuitem|checkbox|tab|menuitemcheckbox|option|gridcell|slider)$/.test(getRole(elm));
                    }(elm) || elements.push(elm);
                    for (var i = 0; i < elm.childNodes.length; i++) collect(elm.childNodes[i]);
                }
            }(elm || root.getEl()), elements;
        }
        function getNavigationRoot(targetControl) {
            var navigationRoot, controls;
            (controls = (targetControl = targetControl || focusedControl).parents().toArray()).unshift(targetControl);
            for (var i = 0; i < controls.length && !(navigationRoot = controls[i]).settings.ariaRoot; i++);
            return navigationRoot;
        }
        function moveFocusToIndex(idx, elements) {
            return idx < 0 ? idx = elements.length - 1 : idx >= elements.length && (idx = 0), 
            elements[idx] && elements[idx].focus(), idx;
        }
        function moveFocus(dir, elements) {
            var idx = -1, navigationRoot = getNavigationRoot();
            elements = elements || getFocusElements(navigationRoot.getEl());
            for (var i = 0; i < elements.length; i++) elements[i] === focusedElement && (idx = i);
            navigationRoot.lastAriaIndex = moveFocusToIndex(idx += dir, elements);
        }
        function left() {
            "tablist" == getParentRole() ? moveFocus(-1, getFocusElements(focusedElement.parentNode)) : focusedControl.parent().submenu ? cancel() : moveFocus(-1);
        }
        function right() {
            var role = getRole(), parentRole = getParentRole();
            "tablist" == parentRole ? moveFocus(1, getFocusElements(focusedElement.parentNode)) : "menuitem" == role && "menu" == parentRole && getAriaProp("haspopup") ? enter() : moveFocus(1);
        }
        function up() {
            moveFocus(-1);
        }
        function down() {
            var role = getRole(), parentRole = getParentRole();
            "menuitem" == role && "menubar" == parentRole ? enter() : "button" == role && getAriaProp("haspopup") ? enter({
                key: "down"
            }) : moveFocus(1);
        }
        function cancel() {
            focusedControl.dispatch("cancel");
        }
        function enter(aria) {
            focusedControl.dispatch("click", {
                target: focusedElement,
                aria: aria = aria || {}
            });
        }
        return focusedControl = root.getParentCtrl(focusedElement), root.on("keydown", function(e) {
            function handleNonTabOrEscEvent(e, handler) {
                isTextInputElement(focusedElement) && hasTextInputType(focusedElement) || hasTabstopData(focusedElement) || "slider" !== getRole(focusedElement) && !1 !== handler(e) && e.preventDefault();
            }
            if (!e.isDefaultPrevented()) switch (e.keyCode) {
              case 37:
                handleNonTabOrEscEvent(e, left);
                break;

              case 39:
                handleNonTabOrEscEvent(e, right);
                break;

              case 38:
                handleNonTabOrEscEvent(e, up);
                break;

              case 40:
                handleNonTabOrEscEvent(e, down);
                break;

              case 27:
                cancel();
                break;

              case 14:
              case 13:
              case 32:
                handleNonTabOrEscEvent(e, enter);
                break;

              case 9:
                (function(e) {
                    var elm;
                    "tablist" == getParentRole() ? (elm = getFocusElements(focusedControl.getEl("body"))[0]) && elm.focus() : moveFocus(e.shiftKey ? -1 : 1);
                })(e), e.preventDefault();
            }
        }), root.on("focusin", function(e) {
            focusedElement = e.target, focusedControl = e.control;
        }), {
            focusFirst: function(targetControl) {
                var focusElements = getFocusElements((targetControl = getNavigationRoot(targetControl)).getEl());
                targetControl.settings.ariaRemember && "lastAriaIndex" in targetControl ? moveFocusToIndex(targetControl.lastAriaIndex, focusElements) : moveFocusToIndex(0, focusElements);
            }
        };
    }
    var selectorCache = {}, Container = Control$1.extend({
        init: function(settings) {
            var self = this;
            self._super(settings), (settings = self.settings).fixed && self.state.set("fixed", !0), 
            self._items = new Collection$1(), self.isRtl() && self.classes.add("rtl"), 
            self.bodyClasses = new ClassList(function() {
                self.state.get("rendered") && (self.getEl("body").className = this.toString());
            }), self.bodyClasses.prefix = self.classPrefix, self.classes.add("container"), 
            self.bodyClasses.add("container-body"), settings.scrollable && self.bodyClasses.add("scrollable"), 
            settings.containerCls && self.classes.add(settings.containerCls), self._layout = Factory.create((settings.layout || "") + "layout", {
                align: settings.align || ""
            }), self.settings.items ? self.add(self.settings.items) : self.add(self.render()), 
            self._hasBody = !0;
        },
        items: function() {
            return this._items;
        },
        find: function(selector) {
            return (selector = selectorCache[selector] = selectorCache[selector] || new Selector(selector)).find(this);
        },
        add: function(items) {
            return this.items().add(this.create(items)).parent(this), this;
        },
        focus: function(keyboard) {
            var focusCtrl, keyboardNav;
            if (!keyboard || !(keyboardNav = this.keyboardNav || this.parents().eq(-1)[0].keyboardNav)) return keyboard = this.find("*"), 
            this.statusbar && keyboard.add(this.statusbar.items()), keyboard.each(function(ctrl) {
                if (ctrl.settings.autofocus) return focusCtrl = null, ctrl.focus({
                    preventScroll: !0
                }), !1;
                ctrl.canFocus && (focusCtrl = focusCtrl || ctrl);
            }), focusCtrl && focusCtrl.focus({
                preventScroll: !0
            }), this;
            keyboardNav.focusFirst(this);
        },
        replace: function(oldItem, newItem) {
            for (var ctrlElm, items = this.items(), i = items.length; i--; ) if (items[i] === oldItem) {
                items[i] = newItem;
                break;
            }
            0 <= i && ((ctrlElm = newItem.getEl()) && ctrlElm.parentNode.removeChild(ctrlElm), 
            ctrlElm = oldItem.getEl()) && ctrlElm.parentNode.removeChild(ctrlElm), 
            newItem.parent(this);
        },
        create: function(items) {
            var settings, self = this, ctrlItems = [];
            return Tools$6.isArray(items) || (items = [ items ]), Tools$6.each(items, function(item) {
                item && (item instanceof Control$1 || (settings = Tools$6.extend({}, self.settings.defaults, item = "string" == typeof item ? {
                    type: item
                } : item), item.type = settings.type = settings.type || item.type || self.settings.defaultType || (settings.defaults ? settings.defaults.type : null), 
                item = Factory.create(settings)), ctrlItems.push(item));
            }), ctrlItems;
        },
        renderNew: function() {
            var self = this;
            return self.items().each(function(ctrl, index) {
                var containerElm;
                ctrl.parent(self), ctrl.state.get("rendered") || ((containerElm = self.getEl("body")).hasChildNodes() && index <= containerElm.childNodes.length - 1 ? DomQuery(containerElm.childNodes[index]).before(ctrl.renderHtml()) : DomQuery(containerElm).append(ctrl.renderHtml()), 
                ctrl.postRender());
            }), self._lastRect = null, self;
        },
        append: function(items) {
            return this.add(items).renderNew();
        },
        prepend: function(items) {
            return this.items().set(this.create(items).concat(this.items().toArray())), 
            this.renderNew();
        },
        insert: function(items, index, before) {
            var curItems;
            return items = this.create(items), curItems = this.items(), !before && index < curItems.length - 1 && (index += 1), 
            0 <= index && index < curItems.length && (before = curItems.slice(0, index).toArray(), 
            index = curItems.slice(index).toArray(), curItems.set(before.concat(items, index))), 
            this.renderNew();
        },
        fromJSON: function(data) {
            for (var name in data) this.find("#" + name).value(data[name]);
            return this;
        },
        toJSON: function() {
            var data = {};
            return this.find("*").each(function(ctrl) {
                var name = ctrl.name(), ctrl = ctrl.value();
                name && void 0 !== ctrl && (data[name] = ctrl);
            }), data;
        },
        renderHtml: function() {
            var layout = this._layout, role = this.settings.role;
            return this.preRender(), layout.preRender(this), '<div id="' + this._id + '" class="' + this.classes + '"' + (role ? ' role="' + this.settings.role + '"' : "") + '><div id="' + this._id + '-body" class="' + this.bodyClasses + '">' + (this.settings.html || "") + layout.renderHtml(this) + "</div></div>";
        },
        postRender: function() {
            return this.items().exec("postRender"), this._super(), this._layout.postRender(this), 
            this.state.set("rendered", !0), this.settings.style && this.$el.css(this.settings.style), 
            this.parent() || (this.keyboardNav = new KeyboardNavigation({
                root: this
            })), this;
        },
        recalc: function() {
            var rect = this._layoutRect, lastRect = this._lastRect;
            if (!lastRect || lastRect.w != rect.w || lastRect.h != rect.h) return rect = this.layoutRect(), 
            this._lastRect = {
                x: rect.x,
                y: rect.y,
                w: rect.w,
                h: rect.h
            }, !0;
        }
    }), ButtonGroup = Container.extend({
        Defaults: {
            defaultType: "button",
            role: "group",
            layout: "flow"
        },
        renderHtml: function() {
            var layout = this._layout;
            return this.classes.add("btn-group"), this.classes.add("flow-layout"), 
            this.preRender(), layout.preRender(this), '<div id="' + this._id + '" class="' + this.classes + '">' + (this.settings.html || "") + layout.renderHtml(this) + "</div>";
        }
    }), Checkbox = Widget.extend({
        Defaults: {
            classes: "checkbox",
            role: "checkbox",
            checked: !1
        },
        init: function(settings) {
            var self = this;
            settings.ariaLabel = settings.label || settings.text, self._super(settings), 
            self.on("click mousedown", function(e) {
                e.preventDefault();
            }), self.on("click", function(e) {
                self.disabled() || self.checked(!self.checked());
            }), self.checked(self.settings.checked);
        },
        checked: function(state) {
            return arguments.length ? (this.state.set("checked", state), this) : this.state.get("checked");
        },
        value: function(state) {
            return arguments.length ? this.checked(state) : this.checked();
        },
        renderHtml: function() {
            var id = this._id, prefix = this.classPrefix, text = this.state.get("text"), textHtml = "";
            return this.classes.add("label"), text ? (this.classes.add("checkbox-has-text"), 
            textHtml = '<span class="' + prefix + 'txt">' + this.encode(text) + "</span>") : this.state.get("label"), 
            '<label id="' + id + '" class="' + this.classes + '" unselectable="on"><input type="checkbox" id="' + id + '-inp" aria-labelledby="' + id + '" tabindex="-1" />' + textHtml + "</label>";
        },
        bindStates: function() {
            var self = this;
            function checked(state) {
                self.classes.toggle("checked", state), self.aria("checked", state), 
                self.getEl("inp").checked = !!state;
            }
            return self.state.on("change:text", function(e) {
                self.getEl("txt").firstChild.data = self.translate(e.value);
            }), self.state.on("change:checked change:value", function(e) {
                self.dispatch("change"), checked(e.value);
            }), self.state.on("change:icon", function(e) {
                var e = e.value, prefix = self.classPrefix;
                if (void 0 === e) return self.settings.icon;
                var e = (self.settings.icon = e) ? prefix + "ico " + prefix + "i-" + self.settings.icon : "", prefix = self.getEl().firstChild, iconElm = prefix.getElementsByTagName("span")[0];
                e ? (iconElm && iconElm == prefix.firstChild || (iconElm = document.createElement("span"), 
                prefix.insertBefore(iconElm, prefix.firstChild)), iconElm.className = e) : iconElm && prefix.removeChild(iconElm);
            }), self.state.get("checked") && checked(!0), self._super();
        }
    }), VK = {
        BACKSPACE: 8,
        DELETE: 46,
        DOWN: 40,
        ENTER: 13,
        LEFT: 37,
        RIGHT: 39,
        SPACEBAR: 32,
        TAB: 9,
        UP: 38,
        modifierPressed: function(e) {
            return e.shiftKey || e.ctrlKey || e.altKey || this.metaKeyPressed(e);
        },
        metaKeyPressed: function(e) {
            return Env$1.mac ? e.metaKey : e.ctrlKey && !e.altKey;
        }
    }, $$7 = DomQuery, ComboBox = Widget.extend({
        init: function(settings) {
            var self = this;
            self._super(settings), settings = self.settings, self.classes.add("combobox"), 
            self.subinput = !0, self.ariaTarget = "inp", settings.menu = settings.menu || settings.values, 
            settings.menu && (settings.icon = "caret"), self.on("click", function(e) {
                var elm = e.target, root = self.getEl();
                if ($$7.contains(root, elm) || elm == root) for (;elm && elm != root; ) elm.id && -1 != elm.id.indexOf("-open") && (self.dispatch("action"), 
                settings.menu) && (self.showMenu(), self.menu.items()[0].focus()), 
                elm = elm.parentNode;
            }), self.on("keyup paste cut", function(e) {
                var oldValue, newValue;
                "INPUT" == e.target.nodeName && (oldValue = self.state.get("value"), 
                (newValue = e.target.value) !== oldValue) && (self.state.set("value", newValue), 
                self.dispatch("autocomplete", e));
            }), self.on("mouseover", function(e) {
                var statusMessage, tooltip = self.tooltip().moveTo(-65535);
                self.statusLevel() && -1 !== e.target.className.indexOf(self.classPrefix + "status") && (statusMessage = self.statusMessage() || "Ok", 
                statusMessage = tooltip.text(statusMessage).show().testMoveRel(e.target, [ "bc-tc", "bc-tl", "bc-tr" ]), 
                tooltip.classes.toggle("tooltip-n", "bc-tc" == statusMessage), tooltip.classes.toggle("tooltip-nw", "bc-tl" == statusMessage), 
                tooltip.classes.toggle("tooltip-ne", "bc-tr" == statusMessage), 
                tooltip.moveRel(e.target, statusMessage));
            });
        },
        statusLevel: function(value) {
            return 0 < arguments.length && this.state.set("statusLevel", value), 
            this.state.get("statusLevel");
        },
        statusMessage: function(value) {
            return 0 < arguments.length && this.state.set("statusMessage", value), 
            this.state.get("statusMessage");
        },
        showMenu: function() {
            var self = this, settings = self.settings;
            self.menu || ((settings = settings.menu || []).length ? settings = {
                type: "menu",
                items: settings
            } : settings.type = settings.type || "menu", self.menu = Factory.create(settings).parent(self).renderTo(self.getContainerElm()), 
            self.menu.keyboardNav || (self.menu.keyboardNav = new KeyboardNavigation({
                root: self.menu
            })), self.dispatch("createmenu"), self.menu.on("cancel", function(e) {
                e.control === self.menu && self.focus();
            }), self.menu.on("show hide", function(e) {
                e.control.items().each(function(ctrl) {
                    ctrl.active(ctrl.value() == self.value());
                });
            }).dispatch("show"), self.menu.on("select", function(e) {
                self.value(e.control.value());
            }), self.on("focusin", function(e) {
                "INPUT" == e.target.tagName.toUpperCase() && self.menu.hide();
            }), self.aria("expanded", !0)), self.menu.show(), self.menu.layoutRect({
                w: self.layoutRect().w
            }), self.menu.getEl().style.width = self.layoutRect().w + "px", self.menu.moveRel(self.getEl(), self.isRtl() ? [ "br-tr", "tr-br" ] : [ "bl-tl", "tl-bl" ]);
        },
        focus: function() {
            this.getEl("inp").focus({
                preventScroll: !0
            });
        },
        repaint: function() {
            return self._super(), self;
        },
        postRender: function() {
            var self = this;
            return $$7(this.getEl("inp")).on("change", function(e) {
                self.state.set("value", e.target.value), self.dispatch("change", e);
            }), $$7(this.getEl("inp")).on("focus", function(e) {
                self.classes.add("focus");
            }), $$7(this.getEl("inp")).on("blur", function(e) {
                self.classes.remove("focus");
            }), self._super();
        },
        renderHtml: function() {
            var icon, text, statusHtml, id = this._id, settings = this.settings, prefix = this.classPrefix, value = this.state.get("value") || "", openBtnHtml = "", extraAttrs = "";
            "spellcheck" in settings && (extraAttrs += ' spellcheck="' + settings.spellcheck + '"'), 
            settings.maxLength && (extraAttrs += ' maxlength="' + settings.maxLength + '"'), 
            settings.size && (extraAttrs += ' size="' + settings.size + '"'), settings.subtype && (extraAttrs += ' type="' + settings.subtype + '"'), 
            statusHtml = '<span id="' + id + '-status" class="' + prefix + "status " + prefix + 'ico" style="display: none"></span>', 
            this.disabled() && (extraAttrs += ' disabled="disabled"'), (icon = settings.icon) && "caret" !== icon && (icon = prefix + "ico " + prefix + "i-" + settings.icon), 
            text = this.state.get("text");
            return (icon || text) && (openBtnHtml = '<button id="' + id + '-open" type="button" class="' + prefix + "btn " + prefix + 'open" tabIndex="-1" role="button">' + ("caret" !== icon ? '<span class="' + icon + '"></span>' : ' <svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 512 512">   <path d="M256 64l-96 160h192z"></path>   <path d="M256 448l-96-160h192z"></path> </svg>') + "</button>", 
            this.classes.add("has-open")), '<div id="' + id + '" class="' + this.classes + '"><input type="text" id="' + id + '-inp" class="' + prefix + 'textbox" value="' + this.encode(value, !1) + '" hidefocus="1"' + extraAttrs + ' placeholder="' + this.encode(settings.placeholder) + '" />' + statusHtml + openBtnHtml + "</div>";
        },
        value: function(value) {
            return arguments.length ? (this.state.set("value", value), this) : (this.state.get("rendered") && this.state.set("value", this.getEl("inp").value), 
            this.state.get("value"));
        },
        showAutoComplete: function(items, term) {
            var self = this;
            0 === items.length ? self.hideMenu() : (self.menu ? self.menu.items().remove() : self.menu = Factory.create({
                type: "menu",
                classes: "combobox-menu",
                layout: "flow"
            }).parent(self).renderTo(), Tools$6.each(items, function(item) {
                var value, title;
                self.menu.add({
                    text: item.title,
                    url: item.previewUrl,
                    match: term,
                    classes: "menu-item-ellipsis",
                    onclick: (value = item.value, title = item.title, function() {
                        self.dispatch("selectitem", {
                            title: title,
                            value: value
                        });
                    })
                });
            }), self.menu.renderNew(), self.hideMenu(), self.menu.on("cancel", function(e) {
                e.control.parent() === self.menu && (e.stopPropagation(), self.focus(), 
                self.hideMenu());
            }), self.menu.on("select", function() {
                self.focus();
            }), items = self.layoutRect().w, self.menu.layoutRect({
                w: items,
                minW: 0,
                maxW: items
            }), self.menu.show(), self.menu.moveRel(self.getEl(), self.isRtl() ? [ "br-tr", "tr-br" ] : [ "bl-tl", "tl-bl" ]));
        },
        hideMenu: function() {
            this.menu && this.menu.hide();
        },
        bindStates: function() {
            function focusIdx(idx, menu) {
                menu && 0 < menu.items().length && menu.items().eq(idx)[0].focus();
            }
            var self = this;
            self.state.on("change:value", function(e) {
                self.getEl("inp").value != e.value && (self.getEl("inp").value = e.value);
            }), self.state.on("change:disabled", function(e) {
                self.getEl("inp").disabled = e.value;
            }), self.state.on("change:statusLevel", function(e) {
                var statusIconElm = self.getEl("status"), prefix = self.classPrefix, e = e.value;
                funcs.css(statusIconElm, "display", "none" === e ? "none" : ""), 
                funcs.toggleClass(statusIconElm, prefix + "i-checkmark", "ok" === e), 
                funcs.toggleClass(statusIconElm, prefix + "i-warning", "warn" === e), 
                funcs.toggleClass(statusIconElm, prefix + "i-error", "error" === e), 
                self.classes.toggle("has-status", "none" !== e), self.repaint();
            }), funcs.on(self.getEl("status"), "mouseleave", function() {
                self.tooltip().hide();
            }), self.on("cancel", function(e) {
                self.menu && self.menu.visible() && (e.stopPropagation(), self.hideMenu(), 
                self.getEl("inp").focus());
            });
            return self.on("keydown", function(e) {
                var keyCode = e.keyCode;
                "INPUT" === e.target.nodeName && (keyCode === VK.DOWN ? (e.preventDefault(), 
                self.dispatch("autocomplete"), focusIdx(0, self.menu)) : keyCode === VK.UP && (e.preventDefault(), 
                focusIdx(-1, self.menu)));
            }), self._super();
        },
        remove: function() {
            $$7(this.getEl("inp")).off(), this.menu && this.menu.remove(), this._super();
        }
    }), ColorBox = ComboBox.extend({
        init: function(settings) {
            var self = this;
            settings.spellcheck = !1, settings.onaction && (settings.icon = "none"), 
            self._super(settings), self.classes.add("colorbox"), self.on("change keyup postrender", function() {
                self.repaintColor(self.value());
            });
        },
        repaintColor: function(value) {
            var openElm = this.getEl("open");
            if (openElm) try {
                openElm.style.background = value;
            } catch (ex) {}
        },
        bindStates: function() {
            var self = this;
            return self.state.on("change:value", function(e) {
                self.state.get("rendered") && self.repaintColor(e.value);
            }), self._super();
        }
    }), $$6 = DomQuery;
    function updateWithTouchData(e) {
        var keys, i;
        if (e.changedTouches) for (keys = "screenX screenY pageX pageY clientX clientY".split(" "), 
        i = 0; i < keys.length; i++) e[keys[i]] = e.changedTouches[0][keys[i]];
    }
    function DragHelper(id, settings) {
        var $eventOverlay, downButton, start, stop, drag, startX, startY, doc = settings.document || document;
        function getHandleElm() {
            return doc.getElementById(settings.handle || id);
        }
        settings = settings || {}, start = function(e) {
            var handleElm, docSize = function(doc) {
                var max = Math.max, documentElement = doc.documentElement, doc = doc.body, scrollWidth = max(documentElement.scrollWidth, doc.scrollWidth), clientWidth = max(documentElement.clientWidth, doc.clientWidth), offsetWidth = max(documentElement.offsetWidth, doc.offsetWidth), scrollHeight = max(documentElement.scrollHeight, doc.scrollHeight), clientHeight = max(documentElement.clientHeight, doc.clientHeight);
                return {
                    width: scrollWidth < offsetWidth ? clientWidth : scrollWidth,
                    height: scrollHeight < max(documentElement.offsetHeight, doc.offsetHeight) ? clientHeight : scrollHeight
                };
            }(doc);
            updateWithTouchData(e), e.preventDefault(), downButton = e.button, handleElm = getHandleElm(), 
            startX = e.screenX, startY = e.screenY, handleElm = window.getComputedStyle ? window.getComputedStyle(handleElm, null).getPropertyValue("cursor") : handleElm.runtimeStyle.cursor, 
            $eventOverlay = $$6("<div></div>").css({
                position: "absolute",
                top: 0,
                left: 0,
                width: docSize.width,
                height: docSize.height,
                zIndex: 2147483647,
                opacity: 1e-4,
                cursor: handleElm
            }).appendTo(doc.body), $$6(doc).on("mousemove touchmove", drag).on("mouseup touchend", stop), 
            settings.start(e);
        }, drag = function(e) {
            if (updateWithTouchData(e), e.button !== downButton) return stop(e);
            e.deltaX = e.screenX - startX, e.deltaY = e.screenY - startY, e.changedTouches || e.preventDefault(), 
            settings.drag(e);
        }, stop = function(e) {
            updateWithTouchData(e), $$6(doc).off("mousemove touchmove", drag).off("mouseup touchend", stop), 
            $eventOverlay.remove(), settings.stop && settings.stop(e);
        }, this.destroy = function() {
            $$6(getHandleElm()).off();
        }, $$6(getHandleElm()).on("mousedown touchstart", start);
    }
    var requestAnimationFramePromise, $$5 = DomQuery, Scrollable = {
        init: function() {
            this.on("repaint", this.renderScroll);
        },
        renderScroll: function() {
            var self = this;
            function repaintScroll() {
                var hasScrollH, hasScrollV, bodyElm;
                function repaintAxis(axisName, posName, sizeName, contentSizeName, hasScroll, ax) {
                    var posNameLower, sizeNameLower, scrollBarElm = self.getEl("scroll" + axisName);
                    scrollBarElm && (posNameLower = posName.toLowerCase(), sizeNameLower = sizeName.toLowerCase(), 
                    $$5(self.getEl("absend")).css(posNameLower, self.layoutRect()[contentSizeName] - 1), 
                    hasScroll ? ($$5(scrollBarElm).css("display", "block"), contentSizeName = self.getEl("body"), 
                    hasScroll = self.getEl("scroll" + axisName + "t"), axisName = contentSizeName["client" + sizeName] - 4, 
                    ax = (axisName -= hasScrollH && hasScrollV ? scrollBarElm["client" + ax] : 0) / contentSizeName["scroll" + sizeName], 
                    (sizeName = {})[posNameLower] = contentSizeName["offset" + posName] + 2, 
                    sizeName[sizeNameLower] = axisName, $$5(scrollBarElm).css(sizeName), 
                    (sizeName = {})[posNameLower] = contentSizeName["scroll" + posName] * ax, 
                    sizeName[sizeNameLower] = axisName * ax, $$5(hasScroll).css(sizeName)) : $$5(scrollBarElm).css("display", "none"));
                }
                bodyElm = self.getEl("body"), hasScrollH = bodyElm.scrollWidth > bodyElm.clientWidth, 
                hasScrollV = bodyElm.scrollHeight > bodyElm.clientHeight, repaintAxis("h", "Left", "Width", "contentW", hasScrollH, "Height"), 
                repaintAxis("v", "Top", "Height", "contentH", hasScrollV, "Width");
            }
            function addScrollAxis(axisName, posName, sizeName, deltaPosName, ax) {
                var scrollStart, axisId = self._id + "-scroll" + axisName, prefix = self.classPrefix;
                $$5(self.getEl()).append('<div id="' + axisId + '" class="' + prefix + "scrollbar " + prefix + "scrollbar-" + axisName + '"><div id="' + axisId + 't" class="' + prefix + 'scrollbar-thumb"></div></div>'), 
                self.draghelper = new DragHelper(axisId + "t", {
                    start: function() {
                        scrollStart = self.getEl("body")["scroll" + posName], $$5("#" + axisId).addClass(prefix + "active");
                    },
                    drag: function(e) {
                        var layoutRect = self.layoutRect(), hasScrollH = layoutRect.contentW > layoutRect.innerW, layoutRect = layoutRect.contentH > layoutRect.innerH, containerSize = self.getEl("body")["client" + sizeName] - 4, hasScrollH = (containerSize -= hasScrollH && layoutRect ? self.getEl("scroll" + axisName)["client" + ax] : 0) / self.getEl("body")["scroll" + sizeName];
                        self.getEl("body")["scroll" + posName] = scrollStart + e["delta" + deltaPosName] / hasScrollH;
                    },
                    stop: function() {
                        $$5("#" + axisId).removeClass(prefix + "active");
                    }
                });
            }
            self.settings.autoScroll && (self._hasScroll || (self._hasScroll = !0, 
            self.classes.add("scroll"), addScrollAxis("v", "Top", "Height", "Y", "Width"), 
            addScrollAxis("h", "Left", "Width", "X", "Height"), self.on("wheel", function(e) {
                var bodyEl = self.getEl("body");
                bodyEl.scrollLeft += 10 * (e.deltaX || 0), bodyEl.scrollTop += 10 * e.deltaY, 
                repaintScroll();
            }), $$5(self.getEl("body")).on("scroll", repaintScroll)), repaintScroll());
        }
    }, Panel = Container.extend({
        Defaults: {
            layout: "fit",
            containerCls: "panel"
        },
        Mixins: [ Scrollable ],
        renderHtml: function() {
            var layout = this._layout, innerHtml = this.settings.html;
            return this.preRender(), layout.preRender(this), void 0 === innerHtml ? innerHtml = '<div id="' + this._id + '-body" class="' + this.bodyClasses + '">' + layout.renderHtml(this) + "</div>" : ("function" == typeof innerHtml && (innerHtml = innerHtml.call(this)), 
            this._hasBody = !1), '<div id="' + this._id + '" class="' + this.classes + '" hidefocus="1" tabindex="-1" role="group">' + (this._preBodyHtml || "") + innerHtml + "</div>";
        }
    }), Resizable = {
        resizeToContent: function() {
            this._layoutRect.autoResize = !0, this._lastRect = null;
        },
        resizeTo: function(w, h) {
            var rect;
            return (w <= 1 || h <= 1) && (rect = funcs.getWindowSize(), w = w <= 1 ? w * rect.w : w, 
            h = h <= 1 ? h * rect.h : h), this._layoutRect.autoResize = !1, this.layoutRect({
                minW: w,
                minH: h,
                w: w,
                h: h
            });
        },
        resizeBy: function(dw, dh) {
            var rect = this.layoutRect();
            return this.resizeTo(rect.w + dw, rect.h + dh);
        }
    };
    function requestAnimationFrame(callback, element) {
        var i, requestAnimationFrameFunc = window.requestAnimationFrame, vendors = [ "ms", "moz", "webkit" ];
        for (i = 0; i < vendors.length && !requestAnimationFrameFunc; i++) requestAnimationFrameFunc = window[vendors[i] + "RequestAnimationFrame"];
        (requestAnimationFrameFunc = requestAnimationFrameFunc || function(callback) {
            window.setTimeout(callback, 0);
        })(callback, element);
    }
    function wrappedSetTimeout(callback, time) {
        return "number" != typeof time && (time = 0), setTimeout(callback, time);
    }
    function wrappedSetInterval(callback, time) {
        return "number" != typeof time && (time = 1), setInterval(callback, time);
    }
    function debounce(callback, time) {
        var timer, func = function() {
            var args = arguments;
            clearTimeout(timer), timer = wrappedSetTimeout(function() {
                callback.apply(this, args);
            }, time);
        };
        return func.stop = function() {
            clearTimeout(timer);
        }, func;
    }
    var documentClickHandler, documentScrollHandler, windowResizeHandler, hasModal, Delay$1 = {
        requestAnimationFrame: function(callback, element) {
            requestAnimationFramePromise ? requestAnimationFramePromise.then(callback) : requestAnimationFramePromise = new Promise(function(resolve) {
                requestAnimationFrame(resolve, element = element || document.body);
            }).then(callback);
        },
        setTimeout: wrappedSetTimeout,
        setInterval: wrappedSetInterval,
        setEditorTimeout: function(editor, callback, time) {
            return wrappedSetTimeout(function() {
                editor.removed || callback();
            }, time);
        },
        setEditorInterval: function(editor, callback, time) {
            var timer = wrappedSetInterval(function() {
                editor.removed ? clearInterval(timer) : callback();
            }, time);
            return timer;
        },
        debounce: debounce,
        throttle: debounce,
        defer: function(fn) {
            setTimeout(fn, 0);
        },
        clearInterval: function(id) {
            return clearInterval(id);
        },
        clearTimeout: function(id) {
            return clearTimeout(id);
        }
    }, visiblePanels = [], zOrder = [];
    function skipOrHidePanels(e) {
        for (var i = visiblePanels.length; i--; ) {
            var panel = visiblePanels[i], clickCtrl = panel.getParentCtrl(e.target);
            !panel.settings.autohide || clickCtrl && (function(ctrl, parent) {
                for (;ctrl; ) {
                    if (ctrl == parent) return 1;
                    ctrl = ctrl.parent();
                }
            }(clickCtrl, panel) || panel.parent() === clickCtrl) || (e = panel.dispatch("autohide", {
                target: e.target
            })).isDefaultPrevented() || panel.hide();
        }
    }
    function repositionPanel(panel) {
        var scrollY = funcs.getViewPort().y;
        function toggleFixedChildPanels(fixed, deltaY) {
            for (var parent, i = 0; i < visiblePanels.length; i++) if (visiblePanels[i] != panel) for (parent = visiblePanels[i].parent(); parent = parent && parent.parent(); ) parent == panel && visiblePanels[i].fixed(fixed).moveBy(0, deltaY).repaint();
        }
        panel.settings.autofix && (panel.state.get("fixed") ? panel._autoFixY > scrollY && (panel.fixed(!1).layoutRect({
            y: panel._autoFixY
        }).repaint(), toggleFixedChildPanels(!1, panel._autoFixY - scrollY)) : (panel._autoFixY = panel.layoutRect().y, 
        panel._autoFixY < scrollY && (panel.fixed(!0).layoutRect({
            y: 0
        }).repaint(), toggleFixedChildPanels(!0, scrollY - panel._autoFixY))));
    }
    function addRemove(add, ctrl) {
        var i, topModal, zIndex = FloatPanel.zIndex || 65535;
        if (add) zOrder.push(ctrl); else for (i = zOrder.length; i--; ) zOrder[i] === ctrl && zOrder.splice(i, 1);
        if (zOrder.length) for (i = 0; i < zOrder.length; i++) zOrder[i].modal && (zIndex++, 
        topModal = zOrder[i]), zOrder[i].getEl().style.zIndex = zIndex, zOrder[i].zIndex = zIndex, 
        zIndex++;
        add = DomQuery("#" + ctrl.classPrefix + "modal-block", ctrl.getContainerElm())[0];
        topModal ? DomQuery(add).css("z-index", topModal.zIndex - 1) : add && (add.parentNode.removeChild(add), 
        hasModal = !1), FloatPanel.currentZIndex = zIndex;
    }
    var FloatPanel = Panel.extend({
        Mixins: [ Movable, Resizable ],
        init: function(settings) {
            var docElm, clientWidth, clientHeight, self = this;
            self._super(settings), (self._eventsRoot = self).classes.add("floatpanel"), 
            settings.autohide && (documentClickHandler || (documentClickHandler = function(e) {
                2 != e.button && skipOrHidePanels(e);
            }, DomQuery(document).on("click touchstart", documentClickHandler)), 
            windowResizeHandler || (docElm = document.documentElement, clientWidth = docElm.clientWidth, 
            clientHeight = docElm.clientHeight, windowResizeHandler = function() {
                document.all && clientWidth == docElm.clientWidth && clientHeight == docElm.clientHeight || (clientWidth = docElm.clientWidth, 
                clientHeight = docElm.clientHeight, FloatPanel.hideAll());
            }, DomQuery(window).on("resize", windowResizeHandler)), visiblePanels.push(self)), 
            settings.autofix && (documentScrollHandler || (documentScrollHandler = function() {
                for (var i = visiblePanels.length; i--; ) repositionPanel(visiblePanels[i]);
            }, DomQuery(window).on("scroll", documentScrollHandler)), self.on("move", function() {
                repositionPanel(this);
            })), self.on("postrender show", function(e) {
                var $modalBlockEl, prefix;
                e.control == self && (prefix = self.classPrefix, self.modal && !1 !== settings.blocker && !hasModal && (($modalBlockEl = DomQuery("#" + prefix + "modal-block", self.getContainerElm()))[0] || ($modalBlockEl = DomQuery('<div id="' + prefix + 'modal-block" class="' + prefix + "reset " + prefix + 'fade"></div>').appendTo(self.getContainerElm())), 
                Delay$1.setTimeout(function() {
                    $modalBlockEl.addClass(prefix + "in"), DomQuery(self.getEl()).addClass(prefix + "in");
                }), hasModal = !0), addRemove(!0, self));
            }), self.on("show", function() {
                self.parents().each(function(ctrl) {
                    if (ctrl.state.get("fixed")) return self.fixed(!0), !1;
                });
            }), settings.popover && self.classes.add("popover").add("bottom").add(self.isRtl() ? "end" : "start"), 
            self.aria("label", settings.ariaLabel), self.aria("labelledby", self._id), 
            self.aria("describedby", self.describedBy || self._id + "-none");
        },
        fixed: function(state) {
            var viewport;
            return this.state.get("fixed") != state && (this.state.get("rendered") && (viewport = funcs.getViewPort(), 
            state ? this.layoutRect().y -= viewport.y : this.layoutRect().y += viewport.y), 
            this.classes.toggle("fixed", state), this.state.set("fixed", state)), 
            this;
        },
        show: function() {
            for (var state = this._super(), i = visiblePanels.length; i-- && visiblePanels[i] !== this; );
            return -1 === i && visiblePanels.push(this), state;
        },
        hide: function() {
            return removeVisiblePanel(this), addRemove(!1, this), this._super();
        },
        hideAll: function() {
            FloatPanel.hideAll();
        },
        close: function() {
            return this.dispatch("close").isDefaultPrevented() || (this.remove(), 
            addRemove(!1, this)), this;
        },
        remove: function() {
            removeVisiblePanel(this), this._super();
        },
        postRender: function() {
            return this.settings.bodyRole && this.getEl("body").setAttribute("role", this.settings.bodyRole), 
            this._super();
        }
    });
    function removeVisiblePanel(panel) {
        for (var i = visiblePanels.length; i--; ) visiblePanels[i] === panel && visiblePanels.splice(i, 1);
        for (i = zOrder.length; i--; ) zOrder[i] === panel && zOrder.splice(i, 1);
    }
    FloatPanel.hideAll = function() {
        for (var i = visiblePanels.length; i--; ) {
            var panel = visiblePanels[i];
            panel && panel.settings.autohide && (panel.hide(), visiblePanels.splice(i, 1));
        }
    };
    var PanelButton = Button.extend({
        init: function(settings) {
            settings.popoverAlign = [ "bl-tl", "bc-tl", "bc-tr" ], this._super(settings);
        },
        showPanel: function() {
            var self = this, settings = self.settings, panelSettings = (self.active(!0), 
            self.panel ? self.panel.show() : ((panelSettings = (panelSettings = settings.panel).type ? {
                layout: "grid",
                items: panelSettings
            } : panelSettings).role = panelSettings.role || "dialog", panelSettings.popover = !0, 
            panelSettings.autohide = !0, panelSettings.ariaRoot = !0, self.panel = new FloatPanel(panelSettings).on("hide", function() {
                self.active(!1);
            }).on("cancel", function(e) {
                e.stopPropagation(), self.focus(), self.hidePanel();
            }).parent(self).renderTo(self.getContainerElm()), self.panel.dispatch("show")), 
            self.panel.testMoveRel(self.getEl(), settings.popoverAlign || (self.isRtl() ? [ "bc-tc", "bc-tl", "bc-tr" ] : [ "bc-tc", "bc-tr", "bc-tl" ])));
            self.panel.classes.toggle("start", "bc-tl" === panelSettings), self.panel.classes.toggle("end", "bc-tr" === panelSettings), 
            self.panel.moveRel(self.getEl(), panelSettings);
        },
        hidePanel: function() {
            this.panel && this.panel.hide();
        },
        postRender: function() {
            var self = this;
            return self.aria("haspopup", !0), self.on("click", function(e) {
                e.control === self && (self.panel && self.panel.visible() ? self.hidePanel() : (self.showPanel(), 
                self.panel.focus(!!e.aria)));
            }), self._super();
        },
        remove: function() {
            return this.panel && (this.panel.remove(), this.panel = null), this._super();
        }
    }), ColorButton = PanelButton.extend({
        init: function(settings) {
            settings.popoverAlign = [ "bl-tl", "bc-tl", "bc-tr" ], this._super(settings), 
            this.classes.add("colorbutton"), this.classes.add("splitbtn");
        },
        color: function(color) {
            return color ? (this._color = color, this.getEl("preview").style.backgroundColor = color, 
            this) : this._color;
        },
        resetColor: function() {
            return this._color = null, this.getEl("preview").style.backgroundColor = null, 
            this;
        },
        renderHtml: function() {
            var id = this._id, prefix = this.classPrefix, text = this.state.get("text"), icon = this.settings.icon ? prefix + "ico " + prefix + "i-" + this.settings.icon : "", image = this.settings.image ? " style=\"background-image: url('" + this.settings.image + "')\"" : "", textHtml = "";
            return text && (this.classes.add("btn-has-text"), textHtml = '<span class="' + prefix + 'txt">' + this.encode(text) + "</span>"), 
            '<div id="' + id + '" class="' + this.classes + '" role="button" tabindex="-1" aria-haspopup="true"><button role="presentation" hidefocus="1" type="button" tabindex="-1">' + (icon ? '<span class="' + icon + '"' + image + ' role="presentation"></span>' : "") + '<span id="' + id + '-preview" class="' + prefix + 'preview"></span>' + textHtml + '</button><button type="button" class="' + prefix + 'open" hidefocus="1" tabindex="-1"><svg width="16" height="16" viewBox="0 0 512 512" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M256,336L160,176L352,176L256,336Z" /></svg></button></div>';
        },
        postRender: function() {
            var self = this, onClickHandler = self.settings.onclick;
            return self.on("click", function(e) {
                e.aria && "down" == e.aria.key || e.control != self || funcs.getParent(e.target, "." + self.classPrefix + "open") || (e.stopImmediatePropagation(), 
                onClickHandler.call(self, e));
            }), delete self.settings.onclick, self._super();
        }
    }), min = Math.min, max = Math.max, round$1 = Math.round;
    function Color(value) {
        var self = this, r = 0, g = 0, b = 0;
        function parse(value) {
            if ("object" == typeof value) {
                if ("r" in value) r = value.r, g = value.g, b = value.b; else if ("v" in value) {
                    var chroma, x, hue = value.h, saturation = value.s, brightness = value.v;
                    if (hue = (parseInt(hue, 10) || 0) % 360, saturation = parseInt(saturation, 10) / 100, 
                    brightness = parseInt(brightness, 10) / 100, saturation = max(0, min(saturation, 1)), 
                    brightness = max(0, min(brightness, 1)), 0 === saturation) r = g = b = round$1(255 * brightness); else {
                        switch (hue = hue / 60, x = (chroma = brightness * saturation) * (1 - Math.abs(hue % 2 - 1)), 
                        saturation = brightness - chroma, Math.floor(hue)) {
                          case 0:
                            r = chroma, g = x, b = 0;
                            break;

                          case 1:
                            r = x, g = chroma, b = 0;
                            break;

                          case 2:
                            r = 0, g = chroma, b = x;
                            break;

                          case 3:
                            r = 0, g = x, b = chroma;
                            break;

                          case 4:
                            r = x, g = 0, b = chroma;
                            break;

                          case 5:
                            r = chroma, g = 0, b = x;
                            break;

                          default:
                            r = g = b = 0;
                        }
                        r = round$1(255 * (r + saturation)), g = round$1(255 * (g + saturation)), 
                        b = round$1(255 * (b + saturation));
                    }
                }
            } else (brightness = /rgb\s*\(\s*([0-9]+)\s*,\s*([0-9]+)\s*,\s*([0-9]+)[^\)]*\)/gi.exec(value)) ? (r = parseInt(brightness[1], 10), 
            g = parseInt(brightness[2], 10), b = parseInt(brightness[3], 10)) : (brightness = /#([0-F]{2})([0-F]{2})([0-F]{2})/gi.exec(value)) ? (r = parseInt(brightness[1], 16), 
            g = parseInt(brightness[2], 16), b = parseInt(brightness[3], 16)) : (brightness = /#([0-F])([0-F])([0-F])/gi.exec(value)) && (r = parseInt(brightness[1] + brightness[1], 16), 
            g = parseInt(brightness[2] + brightness[2], 16), b = parseInt(brightness[3] + brightness[3], 16));
            return r = r < 0 ? 0 : 255 < r ? 255 : r, g = g < 0 ? 0 : 255 < g ? 255 : g, 
            b = b < 0 ? 0 : 255 < b ? 255 : b, self;
        }
        value && parse(value), self.toRgb = function() {
            return {
                r: r,
                g: g,
                b: b
            };
        }, self.toHsv = function() {
            return function(r, g, b) {
                var minRGB, maxRGB, s, v = 0;
                return (minRGB = min(r /= 255, min(g /= 255, b /= 255))) == (maxRGB = max(r, max(g, b))) ? {
                    h: 0,
                    s: 0,
                    v: 100 * (v = minRGB)
                } : (s = (maxRGB - minRGB) / maxRGB, {
                    h: round$1(60 * ((r == minRGB ? 3 : b == minRGB ? 1 : 5) - (r == minRGB ? g - b : b == minRGB ? r - g : b - r) / ((v = maxRGB) - minRGB))),
                    s: round$1(100 * s),
                    v: round$1(100 * v)
                });
            }(r, g, b);
        }, self.toHex = function() {
            function hex(val) {
                return 1 < (val = parseInt(val, 10).toString(16)).length ? val : "0" + val;
            }
            return "#" + hex(r) + hex(g) + hex(b);
        }, self.parse = parse;
    }
    function noop$2() {}
    function hasContentEditableState(value) {
        return function(node) {
            if (node && 1 === node.nodeType) {
                if (node.contentEditable === value) return !0;
                if (node.getAttribute("data-mce-contenteditable") === value) return !0;
            }
            return !1;
        };
    }
    function create(type, title, url, level, attach) {
        return {
            type: type,
            title: title,
            url: url,
            level: level,
            attach: attach
        };
    }
    function getElementText(elm) {
        return elm.innerText || elm.textContent;
    }
    function isHeader(elm) {
        return elm && /^(H[1-6])$/.test(elm.nodeName);
    }
    function isEditable(elm) {
        return isChildOfContentEditableTrue(elm) && !isContentEditableFalse(elm);
    }
    function hasTitle(target) {
        return 0 < trim$1(target.title).length;
    }
    function toMenuItem(target) {
        return {
            title: target.title,
            value: {
                title: {
                    raw: target.title
                },
                url: target.url,
                attach: target.attach
            }
        };
    }
    function createMenuItems(term, targets, fileType, editorSettings) {
        function fromHistoryMenuItems(history) {
            return history = Tools$6.hasOwn(history, fileType) ? history[fileType] : [], 
            history = Tools$6.grep(history, function(url) {
                return isUniqueUrl(url, targets);
            }), Tools$6.map(history, function(url) {
                return {
                    title: url,
                    value: {
                        title: url,
                        url: url,
                        attach: noop$1
                    }
                };
            });
        }
        function fromMenuItems(type) {
            var filteredTargets = Tools$6.grep(targets, function(target) {
                return target.type === type;
            });
            return toMenuItems(filteredTargets);
        }
        var items, separator = {
            title: "-"
        };
        return !1 === editorSettings.typeahead_urls ? [] : "file" === fileType ? (items = [ filterByQuery(term, fromHistoryMenuItems(history)), filterByQuery(term, fromMenuItems("header")), filterByQuery(term, function() {
            var anchorMenuItems = fromMenuItems("anchor"), topAnchor = getSetting(editorSettings, "anchor_top", "#top"), bottomAchor = getSetting(editorSettings, "anchor_bottom", "#bottom");
            return null !== topAnchor && anchorMenuItems.unshift(staticMenuItem("<top>", topAnchor)), 
            null !== bottomAchor && anchorMenuItems.push(staticMenuItem("<bottom>", bottomAchor)), 
            anchorMenuItems;
        }()) ], Arr.reduce(items, function(a, b) {
            return 0 === a.length || 0 === b.length ? a.concat(b) : a.concat(separator, b);
        }, [])) : filterByQuery(term, fromHistoryMenuItems(history));
    }
    function setupAutoCompleteHandler(ctrl, editorSettings, bodyElm, fileType) {
        function autocomplete(term) {
            var linkTargets = LinkTargets_find(bodyElm), linkTargets = createMenuItems(term, linkTargets, fileType, editorSettings);
            ctrl.showAutoComplete(linkTargets, term);
        }
        ctrl.on("autocomplete", function() {
            autocomplete(ctrl.value());
        }), ctrl.on("selectitem", function(e) {
            var e = e.value, title = (ctrl.value(e.url), function(linkDetails) {
                linkDetails = linkDetails.title;
                return linkDetails.raw || linkDetails;
            }(e));
            "image" === fileType ? ctrl.dispatch("change", {
                meta: {
                    alt: title,
                    attach: e.attach
                }
            }) : ctrl.dispatch("change", {
                meta: {
                    text: title,
                    attach: e.attach
                }
            }), ctrl.focus();
        }), ctrl.on("click", function(e) {
            0 === ctrl.value().length && "INPUT" === e.target.nodeName && autocomplete("");
        }), ctrl.on("PostRender", function() {
            ctrl.getRoot().on("submit", function(e) {
                e.isDefaultPrevented() || !function(url, fileType) {
                    var items = history[fileType];
                    /^https?/.test(url) && (items ? -1 === Tools$6.inArray(items, url) && (history[fileType] = items.slice(0, HISTORY_LENGTH).concat(url)) : history[fileType] = [ url ]);
                }(ctrl.value(), fileType);
            });
        });
    }
    function setupLinkValidatorHandler(ctrl, editorSettings, fileType) {
        var validatorHandler = editorSettings.filepicker_validator_handler;
        validatorHandler && ctrl.state.on("change:value", function(e) {
            0 === (e = e.value).length ? ctrl.statusLevel("none") : validatorHandler({
                url: e,
                type: fileType
            }, function(result) {
                result = function(result) {
                    var status = result.status, result = result.message;
                    return "valid" === status ? {
                        status: "ok",
                        message: result
                    } : "unknown" === status || "invalid" === status ? {
                        status: "warn",
                        message: result
                    } : {
                        status: "none",
                        message: ""
                    };
                }(result);
                ctrl.statusMessage(result.message), ctrl.statusLevel(result.status);
            });
        });
    }
    function postRenderFormatToggle(editor, name) {
        return function(e) {
            addFormatChangedListener(editor, name, function(state) {
                e.control.active(state);
            });
        };
    }
    function getFirstFont(fontFamily) {
        return fontFamily ? fontFamily.split(",")[0] : "";
    }
    function toPt(fontSize, precision) {
        return /[0-9.]+px$/.test(fontSize) ? function(number, precision) {
            precision = Math.pow(10, precision);
            return Math.round(number * precision) / precision;
        }(72 * parseInt(fontSize, 10) / 96, precision || 0) + "pt" : fontSize;
    }
    function hideMenuObjects(editor, menu) {
        var count = menu.length;
        return Tools$6.each(menu, function(item) {
            item.menu && (item.hidden = 0 === hideMenuObjects(editor, item.menu));
            var formatName = item.format;
            formatName && (item.hidden = !editor.formatter.canApply(formatName)), 
            item.hidden && count--;
        }), count;
    }
    function createCustomMenuItems(editor, names) {
        var nameList;
        if ("string" == typeof names) nameList = names.split(" "); else if (Tools$6.isArray(names)) return Arr.flatten(Tools$6.map(names, function(names) {
            return createCustomMenuItems(editor, names);
        }));
        return names = Tools$6.grep(nameList, function(name) {
            return "|" === name || name in editor.menuItems;
        }), Tools$6.map(names, function(name) {
            return "|" === name ? {
                text: "-"
            } : editor.menuItems[name];
        });
    }
    function isSeparator(menuItem) {
        return menuItem && "-" === menuItem.text;
    }
    function trimMenuItems(menuItems) {
        var menuItems2 = Tools$6.grep(menuItems, function(menuItem, i) {
            return !isSeparator(menuItem) || !isSeparator(menuItems[i - 1]);
        });
        return Tools$6.grep(menuItems2, function(menuItem, i) {
            return !isSeparator(menuItem) || 0 < i && i < menuItems2.length - 1;
        });
    }
    var ColorPicker = Widget.extend({
        Defaults: {
            classes: "widget colorpicker"
        },
        init: function(settings) {
            this._super(settings);
        },
        postRender: function() {
            var hsv, hueRootElm, huePointElm, svRootElm, svPointElm, self = this, color = self.color();
            function getPos(elm, event) {
                var pos = funcs.getPos(elm), x = event.pageX - pos.x, event = event.pageY - pos.y;
                return {
                    x: Math.max(0, Math.min(x / elm.clientWidth, 1)),
                    y: Math.max(0, Math.min(event / elm.clientHeight, 1))
                };
            }
            function updateColor(hsv, hueUpdate) {
                var hue = (360 - hsv.h) / 360;
                funcs.css(huePointElm, {
                    top: 100 * hue + "%"
                }), hueUpdate || funcs.css(svPointElm, {
                    left: hsv.s + "%",
                    top: 100 - hsv.v + "%"
                }), svRootElm.style.background = new Color({
                    s: 100,
                    v: 100,
                    h: hsv.h
                }).toHex(), self.color().parse({
                    s: hsv.s,
                    v: hsv.v,
                    h: hsv.h
                });
            }
            function updateSaturationAndValue(e) {
                e = getPos(svRootElm, e);
                hsv.s = 100 * e.x, hsv.v = 100 * (1 - e.y), updateColor(hsv), self.dispatch("change");
            }
            function updateHue(e) {
                e = getPos(hueRootElm, e);
                (hsv = color.toHsv()).h = 360 * (1 - e.y), updateColor(hsv, !0), 
                self.dispatch("change");
            }
            hueRootElm = self.getEl("h"), huePointElm = self.getEl("hp"), svRootElm = self.getEl("sv"), 
            svPointElm = self.getEl("svp"), self._repaint = function() {
                updateColor(hsv = color.toHsv());
            }, self._super(), self._svdraghelper = new DragHelper(self._id + "-sv", {
                start: updateSaturationAndValue,
                drag: updateSaturationAndValue
            }), self._hdraghelper = new DragHelper(self._id + "-h", {
                start: updateHue,
                drag: updateHue
            }), self._repaint();
        },
        rgb: function() {
            return this.color().toRgb();
        },
        value: function(value) {
            if (!arguments.length) return this.color().toHex();
            this.color().parse(value), this._rendered && this._repaint();
        },
        color: function() {
            return this._color || (this._color = new Color()), this._color;
        },
        renderHtml: function() {
            var id = this._id, prefix = this.classPrefix;
            return '<div id="' + id + '" class="' + this.classes + '"><div id="' + id + '-sv" class="' + prefix + 'colorpicker-sv"><div class="' + prefix + 'colorpicker-overlay1"><div class="' + prefix + 'colorpicker-overlay2"><div id="' + id + '-svp" class="' + prefix + 'colorpicker-selector1"><div class="' + prefix + 'colorpicker-selector2"></div></div></div></div></div>' + ('<div id="' + id + '-h" class="' + prefix + 'colorpicker-h" style="background: -ms-linear-gradient(top,#ff0000,#ff0080,#ff00ff,#8000ff,#0000ff,#0080ff,#00ffff,#00ff80,#00ff00,#80ff00,#ffff00,#ff8000,#ff0000);background: linear-gradient(to bottom,#ff0000,#ff0080,#ff00ff,#8000ff,#0000ff,#0080ff,#00ffff,#00ff80,#00ff00,#80ff00,#ffff00,#ff8000,#ff0000);"><div id="' + id + '-hp" class="' + prefix + 'colorpicker-h-marker"></div></div>') + "</div>";
        }
    }), FormItem = Container.extend({
        Defaults: {
            layout: "flex"
        },
        renderHtml: function() {
            var layout = this._layout, prefix = this.classPrefix;
            return this.classes.add("formitem"), layout.preRender(this), '<div id="' + this._id + '" class="' + this.classes + '" hidefocus="1" tabindex="-1">' + (this.settings.title ? '<div id="' + this._id + '-title" class="' + prefix + 'title">' + this.settings.title + "</div>" : "") + '<div id="' + this._id + '-body" class="' + this.bodyClasses + '">' + (this.settings.html || "") + layout.renderHtml(this) + "</div></div>";
        }
    }), CustomValue = FormItem.extend({
        init: function(settings) {
            settings.values = settings.values || [], settings.layout = "grid";
            var name = {
                type: "textbox",
                placeholder: "Name"
            };
            settings.values.length && (name = {
                type: "datalist",
                placeholder: "Name",
                values: settings.values
            }), settings.items = [ name, {
                type: "textbox",
                placeholder: "Value"
            } ], this._super(settings), this.classes.add("customvalue");
        },
        name: function() {
            return (this.settings.prefix || "") + this._items[0].value();
        },
        value: function(value) {
            if (void 0 !== value) {
                if ("object" == typeof value && (this.state.set("value", value), 
                this.state.get("rendered"))) for (var key in value) this._items[0].value(key), 
                this._items[1].value(value[key]);
                return this;
            }
            return this.state.get("rendered") && (value = "", (key = this._items[0].value()) && (value = this._items[1].value()), 
            this.state.set("value", value)), this.state.get("value");
        }
    }), specialKeyCodeMap$3 = {
        9: "tab",
        17: "ctrl",
        18: "alt",
        27: "esc",
        13: "enter",
        91: "cmd"
    }, DataList = ComboBox.extend({
        init: function(settings) {
            settings.seperator = settings.seperator || "", settings.multiple = settings.multiple || !1, 
            this._super(settings);
        },
        getValueFromTags: function() {
            var settings = this.settings, values = [], prefix = this.classPrefix;
            return this.$("." + prefix + "datalist-tag", this.getEl()).each(function() {
                values.push(this.value);
            }), values.join(settings.seperator);
        },
        value: function(value) {
            var self = this, settings = this.settings, seperator = settings.seperator, settings = settings.multiple;
            return void 0 !== value ? (seperator && settings ? (value = Tools$6.trim(value), 
            Tools$6.each(value.split(seperator), function(val) {
                self.addTag(val);
            }), value = self.getValueFromTags(), this.state.set("value", Tools$6.trim(value)), 
            this.state.get("rendered") && (this.getEl("inp").value = "", this.focus())) : this.state.get("rendered") && (this.state.set("value", value), 
            this.getEl("inp").value = value, this.focus()), this) : this.state.get("value");
        },
        findTag: function(value) {
            var found, prefix = this.classPrefix;
            return this.$("." + prefix + "datalist-tag", this.getEl()).each(function() {
                this.value == value && (found = this);
            }), found;
        },
        removeTag: function(tag) {
            var self = this, settings = self.settings, values = [], prefix = this.classPrefix;
            tag && tag.value && (values = (values = "string" == typeof (values = this.state.get("value")) ? values.split(settings.seperator) : values).filter(function(value) {
                if (value !== tag.value) return !0;
            })), self.$("." + prefix + "datalist-tag", self.getEl()).each(function() {
                self.$(this).remove();
            }), values.length && (self.state.set("value", ""), Tools$6.each(values, function(val) {
                self.value(val);
            }));
        },
        addTag: function(value) {
            var prefix = this.classPrefix;
            value && !this.findTag(value) && this.$(this.getEl("inp")).parent().before('<button class="' + prefix + "btn " + prefix + 'datalist-tag" value="' + value + '"><label>' + value + "</label>");
        },
        renderHtml: function() {
            var id = this._id, settings = this.settings, html = this._super();
            return this.classes.add("datalist"), settings.multiple && this.classes.add("datalist-multiple"), 
            '<div id="' + id + '" class="' + this.classes + '" role="combobox" aria-autocomplete="list" aria-haspopup="true" aria-expanded="false">' + html + "</div>";
        },
        postRender: function() {
            var self = this, seperator = self.settings.seperator, multiple = self.settings.multiple, prefix = this.classPrefix;
            multiple && self.aria("multiselectable", "true"), self.on("click", function(e) {
                "INPUT" === e.target.nodeName && e.target.focus(), "LABEL" !== e.target.nodeName && (self.$(e.target).hasClass(prefix + "datalist-tag") ? (e.preventDefault(), 
                e.stopPropagation(), self.removeTag(e.target)) : self.menu && (self.menu.classes.add("datalist-menu"), 
                self.menu.items().removeClass("datalist-item-hidden"), self.settings.menu_class && self.menu.classes.add(self.settings.menu_class), 
                self.menu.on("show", function(e) {
                    var maxW = self.layoutRect().w;
                    self.menu.layoutRect({
                        w: maxW,
                        minW: 0,
                        maxW: maxW
                    });
                })));
            }), self.on("keydown", function(e) {
                if (36 == e.keyCode) self.getEl("inp").focus(), e.preventDefault(); else if ("INPUT" === e.target.nodeName) {
                    if (e.keyCode == VK.ENTER && (e.preventDefault(), self.value(self.getEl("inp").value)), 
                    e.keyCode == VK.BACKSPACE) {
                        if (self.getEl("inp").value) return;
                        var val, $tags = self.$("." + prefix + "datalist-tag", self.getEl());
                        $tags.length && (val = $tags.last().attr("value"), self.removeTag($tags.last()[0]), 
                        e.preventDefault(), self.getEl("inp").value = val, self.getEl("inp").focus());
                    }
                    e.keyCode == VK.DOWN && (self.showMenu(), self.menu.items()[0].focus());
                }
            }), self.on("action", function() {
                self.state.set("keyCode", null), window.setTimeout(function() {
                    self.menu && self.menu.items().each(function(ctrl) {
                        var values = self.value().split(seperator);
                        values.length && ctrl.active(0 <= values.indexOf(ctrl.value()));
                    });
                }, 10);
            });
            var keyup = Delay$1.debounce(function(e) {
                if (!(e.control !== self || e.target !== self.getEl("inp") || e.keyCode && specialKeyCodeMap$3[e.keyCode])) {
                    e.key === self.settings.seperator && self.value(self.getEl("inp").value), 
                    self.showMenu(), self.getEl("inp").focus(), self.menu.classes.add("datalist-menu");
                    var matches = self.menu.items().length, value = e.target.value;
                    if ("" === value) return self.menu.hide();
                    self.state.set("keyCode", e.keyCode), multiple && seperator && -1 !== (e = value.lastIndexOf(seperator)) && (value = Tools$6.trim(value.substring(e)));
                    var matcher = new RegExp("^" + value.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, "\\$&"), "i");
                    self.menu.items().each(function(item) {
                        var s = matcher.test(item.value()) || matcher.test(item.text());
                        s || matches--, item.classes.toggle("datalist-item-hidden", !s);
                    }), 0 === matches && self.menu.hide();
                }
            }, 100);
            return self.on("keyup paste cut", keyup), self._super();
        }
    }), DropZone = Widget.extend({
        init: function(settings) {
            settings = Tools$6.extend({
                height: 100,
                text: "Drop an image here",
                multiple: !1,
                accept: null
            }, settings), this._super(settings), this.classes.add("dropzone"), settings.multiple && this.classes.add("multiple");
        },
        renderHtml: function() {
            var cfg = this.settings, attrs = {
                id: this._id,
                hidefocus: "1"
            }, attrs = funcs.create("div", attrs, "<span>" + this.translate(cfg.text) + "</span>");
            return cfg.height && funcs.css(attrs, "height", cfg.height + "px"), 
            cfg.width && funcs.css(attrs, "width", cfg.width + "px"), attrs.className = this.classes, 
            attrs.outerHTML;
        },
        postRender: function() {
            function toggleDragClass(e) {
                e.preventDefault(), self.classes.toggle("dragenter"), self.getEl().className = self.classes;
            }
            var self = this;
            self._super(), self.$el.on("dragover", function(e) {
                e.preventDefault();
            }), self.$el.on("dragenter", toggleDragClass), self.$el.on("dragleave", toggleDragClass), 
            self.$el.on("drop", function(e) {
                var files;
                e.preventDefault(), self.state.get("disabled") || (files = function(files) {
                    var re, accept = self.settings.accept;
                    return "string" != typeof accept ? files : (re = new RegExp("(" + accept.split(/\s*,\s*/).join("|") + ")$", "i"), 
                    Tools$6.grep(files, function(file) {
                        return re.test(file.name);
                    }));
                }(e.dataTransfer.files), self.value = function() {
                    return files.length ? self.settings.multiple ? files : files[0] : null;
                }, files.length && self.dispatch("change", e));
            });
        },
        remove: function() {
            this.$el.off(), this._super();
        }
    }), Path = Widget.extend({
        init: function(settings) {
            var self = this;
            settings.delimiter || (settings.delimiter = "\xbb"), self._super(settings), 
            self.classes.add("path"), self.canFocus = !0, self.on("click", function(e) {
                (e = e.target.getAttribute("data-index")) && self.dispatch("select", {
                    value: self.row()[e],
                    index: e
                });
            }), self.row(self.settings.row);
        },
        focus: function() {
            return this.getEl().firstChild.focus(), this;
        },
        row: function(row) {
            return arguments.length ? (this.state.set("row", row), this) : this.state.get("row");
        },
        renderHtml: function() {
            return '<div id="' + this._id + '" class="' + this.classes + '">' + this._getDataPathHtml(this.state.get("row")) + "</div>";
        },
        bindStates: function() {
            var self = this;
            return self.state.on("change:row", function(e) {
                self.innerHtml(self._getDataPathHtml(e.value));
            }), self._super();
        },
        _getDataPathHtml: function(data) {
            for (var parts = data || [], html = "", prefix = this.classPrefix, i = 0, l = parts.length; i < l; i++) html += (0 < i ? '<div class="' + prefix + 'divider" aria-hidden="true"> ' + this.settings.delimiter + " </div>" : "") + '<div role="button" class="' + prefix + "path-item" + (i == l - 1 ? " " + prefix + "last" : "") + '" data-index="' + i + '" tabindex="-1" id="' + this._id + "-" + i + '" aria-level="' + (i + 1) + '">' + parts[i].name + "</div>";
            return html = html || '<div class="' + prefix + 'path-item">\xa0</div>';
        }
    }), ElementPath = Path.extend({
        postRender: function() {
            var self = this, editor = self.settings.editor;
            return !1 !== editor.settings.elementpath && (self.on("select", function(e) {
                editor.focus(), editor.selection.select(this.row()[e.index].element), 
                editor.nodeChanged();
            }), editor.on("nodeChange", function(e) {
                for (var outParents = [], parents = e.parents, i = parents.length; i--; ) if (1 == parents[i].nodeType && !function(elm) {
                    if (1 === elm.nodeType) {
                        if ("BR" == elm.nodeName || elm.getAttribute("data-mce-bogus")) return 1;
                        if ("bookmark" === elm.getAttribute("data-mce-type")) return 1;
                    }
                }(parents[i])) {
                    var args = editor.dispatch("ResolveName", {
                        name: parents[i].nodeName.toLowerCase(),
                        target: parents[i]
                    });
                    if (args.isDefaultPrevented() || outParents.push({
                        name: args.name,
                        element: parents[i]
                    }), args.isPropagationStopped()) break;
                }
                self.row(outParents);
            })), self._super();
        }
    }), Form = Container.extend({
        Defaults: {
            containerCls: "form",
            layout: "stack",
            callbacks: {
                submit: function() {
                    this.submit();
                }
            }
        },
        preRender: function() {
            var self = this, items = self.items();
            self.settings.formItemDefaults || (self.settings.formItemDefaults = {
                layout: "flex",
                autoResize: "overflow",
                defaults: {
                    flex: 1
                }
            }), items.each(function(ctrl) {
                var label = ctrl.settings.label;
                label && ((label = new FormItem(Tools$6.extend({
                    items: {
                        type: "label",
                        id: ctrl._id + "-l",
                        text: label,
                        flex: 0,
                        forId: ctrl._id,
                        disabled: ctrl.disabled()
                    }
                }, self.settings.formItemDefaults))).type = "formitem", ctrl.aria("labelledby", ctrl._id + "-l"), 
                void 0 === ctrl.settings.flex && (ctrl.settings.flex = 1), self.replace(ctrl, label), 
                label.add(ctrl));
            });
        },
        submit: function() {
            return this.dispatch("submit", {
                data: this.toJSON()
            });
        },
        postRender: function() {
            this._super(), this.fromJSON(this.settings.data);
        },
        bindStates: function() {
            this._super();
        }
    }), FieldSet = Form.extend({
        Defaults: {
            containerCls: "fieldset",
            layout: "flex",
            flex: 1
        },
        renderHtml: function() {
            var layout = this._layout, prefix = this.classPrefix;
            return this.preRender(), layout.preRender(this), '<fieldset id="' + this._id + '" class="' + this.classes + '" hidefocus="1" tabindex="-1">' + (this.settings.title ? '<legend id="' + this._id + '-title" class="' + prefix + 'fieldset-title">' + this.settings.title + "</legend>" : "") + '<div id="' + this._id + '-body" class="' + this.bodyClasses + '">' + (this.settings.html || "") + layout.renderHtml(this) + "</div></fieldset>";
        }
    }), trim$1 = Tools$6.trim, isContentEditableTrue = hasContentEditableState("true"), isContentEditableFalse = hasContentEditableState("false"), isChildOfContentEditableTrue = function(node) {
        for (;node = node.parentNode; ) {
            var value = node.contentEditable;
            if (value && "inherit" !== value) return isContentEditableTrue(node);
        }
        return !1;
    }, select = function(selector, root) {
        return Tools$6.map(funcs.select(selector), function(element) {
            return element;
        });
    }, isValidAnchor = function(elm) {
        return function(elm) {
            return elm && "A" === elm.nodeName && (elm.id || elm.name);
        }(elm) && isEditable(elm);
    }, isValidHeader = function(elm) {
        return isHeader(elm) && isEditable(elm);
    }, headerTarget = function(elm) {
        var headerId = function(elm) {
            return elm.id || funcs.uniqueId("h");
        }(elm);
        return create("header", getElementText(elm), "#" + headerId, function(elm) {
            return isHeader(elm) ? parseInt(elm.nodeName.substr(1), 10) : 0;
        }(elm), function() {
            elm.id = headerId;
        });
    }, anchorTarget = function(elm) {
        var anchorId = elm.id || elm.name, elm = getElementText(elm);
        return create("anchor", elm || "#" + anchorId, "#" + anchorId, 0, noop$2);
    }, LinkTargets_find = function(elm) {
        var elms = select("h1,h2,h3,h4,h5,h6,a:not([href])");
        return Tools$6.grep(function(elms) {
            return Tools$6.map(Tools$6.grep(elms, isValidHeader), headerTarget);
        }(elms).concat(function(elms) {
            return Tools$6.map(Tools$6.grep(elms, isValidAnchor), anchorTarget);
        }(elms)), hasTitle);
    }, EditorManager$2 = tinymce.EditorManager, noop$1 = function() {}, history = {}, HISTORY_LENGTH = 5, toMenuItems = function(targets) {
        return Tools$6.map(targets, toMenuItem);
    }, staticMenuItem = function(title, url) {
        return {
            title: title,
            value: {
                title: title,
                url: url,
                attach: noop$1
            }
        };
    }, isUniqueUrl = function(url, targets) {
        var arr;
        return arr = function(target) {
            return target.url === url;
        }, !(0 <= Tools$6.inArray(targets, arr));
    }, getSetting = function(editorSettings, name, defaultValue) {
        editorSettings = name in editorSettings ? editorSettings[name] : defaultValue;
        return !1 === editorSettings ? null : editorSettings;
    }, filterByQuery = function(term, menuItems) {
        var lowerCaseTerm = term.toLowerCase(), menuItems = Tools$6.grep(menuItems, function(item) {
            return -1 !== item.title.toLowerCase().indexOf(lowerCaseTerm);
        });
        return 1 === menuItems.length && menuItems[0].title === term ? [] : menuItems;
    }, FilePicker = ComboBox.extend({
        init: function(settings) {
            var actionCallback, fileBrowserCallback, fileBrowserCallbackTypes, self = this, editor = (window.tinymce || EditorManager$2).activeEditor, editorSettings = editor.settings, fileType = settings.filetype;
            settings.spellcheck = !1, (fileBrowserCallbackTypes = (fileBrowserCallbackTypes = editorSettings.file_picker_types || editorSettings.file_browser_callback_types) && Tools$6.makeMap(fileBrowserCallbackTypes, /[, ]/)) && !fileBrowserCallbackTypes[fileType] || (!(fileBrowserCallback = editorSettings.file_picker_callback) || fileBrowserCallbackTypes && !fileBrowserCallbackTypes[fileType] ? !(fileBrowserCallback = editorSettings.file_browser_callback) || fileBrowserCallbackTypes && !fileBrowserCallbackTypes[fileType] || (actionCallback = function() {
                fileBrowserCallback(self.getEl("inp").id, self.value(), fileType, window);
            }) : actionCallback = function() {
                var meta = self.dispatch("beforecall").meta, meta = Tools$6.extend({
                    filetype: fileType
                }, meta);
                fileBrowserCallback.call(editor, function(value, meta) {
                    self.value(value).dispatch("change", {
                        meta: meta
                    });
                }, self.value(), meta);
            }), actionCallback && (settings.icon = "browse", settings.onaction = actionCallback), 
            self._super(settings), self.classes.add("filepicker"), setupAutoCompleteHandler(self, editorSettings, editor.getBody(), fileType), 
            setupLinkValidatorHandler(self, editorSettings, fileType);
        }
    }), FitLayout = AbsoluteLayout.extend({}), specialKeyCodeMap$2 = {
        9: "tab",
        17: "ctrl",
        18: "alt",
        27: "esc",
        32: "space",
        13: "enter",
        91: "cmd"
    }, FilterMenu = FloatPanel.extend({
        Defaults: {
            defaultType: "menuitem",
            layout: "stack",
            role: "application",
            bodyRole: "menu",
            ariaRoot: !0
        },
        init: function(settings) {
            if (settings.autohide = !0, settings.constrainToViewport = !0, "function" == typeof settings.items && (settings.itemsFactory = settings.items, 
            settings.items = []), settings.itemDefaults) for (var items = settings.items, i = items.length; i--; ) items[i] = Tools$6.extend({}, settings.itemDefaults, items[i]);
            this._super(settings), this.classes.add("filtermenu");
        },
        repaint: function() {
            return this.classes.toggle("menu-align", !0), this._super(), this.getEl().style.height = "", 
            this.getEl("body").style.height = "", this;
        },
        cancel: function() {
            this.hideAll(), this.dispatch("select");
        },
        findItem: function(text) {
            var found;
            return this.items().each(function(item) {
                if (text === item.value() || text === item.text()) return found = item, 
                !0;
            }), found;
        },
        findTag: function(value) {
            var found, prefix = this.classPrefix;
            return this.$("." + prefix + "filtermenu-tag", this.getEl()).each(function() {
                if (this.value === value) return found = this, !0;
            }), found;
        },
        toggleTag: function(item) {
            var self = this, prefix = this.classPrefix;
            self.$("." + prefix + "filtermenu-tag", self.getEl()).each(function() {
                item.value() === this.value && self.$(this).remove();
            }), item.state.get("active") && this.addTag(item);
        },
        removeTag: function(tag) {
            var self = this, prefix = this.classPrefix;
            if (!tag) return self.$("." + prefix + "filtermenu-tag", self.getEl()).each(function() {
                self.$(this).remove();
            }), !0;
            self.$("." + prefix + "filtermenu-tag", self.getEl()).each(function() {
                var item;
                tag.value === this.value && ((item = self.findItem(tag.value)) && (item.active("false"), 
                item.dispatch("click")), self.$(this).remove());
            });
        },
        addTag: function(item) {
            var prefix = this.classPrefix;
            item && this.$(this.getEl("inp")).parent().before('<button class="' + prefix + "btn " + prefix + 'filtermenu-tag" value="' + item.value() + '"><label>' + item.text() + "</label>");
        },
        postRender: function() {
            var self = this;
            self._super(), self.getEl("inp").value = "", self.on("click", function(e) {
                "INPUT" === e.target.nodeName && e.target.focus(), "LABEL" !== e.target.nodeName && "BUTTON" === e.target.nodeName && (e.preventDefault(), 
                e.stopPropagation(), self.removeTag(e.target));
            }), self.on("show", function() {
                self.removeTag(), window.setTimeout(function() {
                    Tools$6.each(self.items(), function(item) {
                        item.state.get("active") && self.addTag(item);
                    });
                }, 10);
            }), Tools$6.each(self.items(), function(item) {
                item.on("change:active", function(e) {
                    self.toggleTag(item);
                });
            });
            self.on("keyup paste cut", function(e) {
                var matcher;
                if (e.control === self && e.target === self.getEl("inp") && (!e.keyCode || !specialKeyCodeMap$2[e.keyCode])) return "" === (e = e.target.value) ? self.items().removeClass("datalist-item-hidden") : (matcher = new RegExp("^" + e.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, "\\$&"), "i"), 
                void self.items().each(function(item) {
                    var s = matcher.test(item.value()) || matcher.test(item.text());
                    item.classes.toggle("datalist-item-hidden", !s);
                }));
            });
            var maxW = this.parent().layoutRect().w;
            this.layoutRect({
                w: maxW,
                minW: 0,
                maxW: maxW
            }), this.reflow(), this.moveRel(this.getEl(), this.isRtl() ? [ "br-tr", "tr-br" ] : [ "bl-tl", "tl-bl" ]);
        },
        renderHtml: function() {
            var id = this._id, prefix = this.classPrefix, layout = this._layout, id = (this.preRender(), 
            layout.preRender(this), '<div id="' + this._id + '-input-body" class="' + prefix + 'filtermenu-container">   <div class="' + prefix + 'filtermenu-input">       <input type="text" id="' + id + '-inp" class="' + prefix + 'textbox" value="" placeholder="..." />   </div></div><div id="' + this._id + '-filtermenu-menu" class="' + prefix + 'menu" hidefocus="1" tabindex="-1" role="group">   <div id="' + this._id + '-body" class="' + this.bodyClasses + '">' + layout.renderHtml(this) + "   </div></div>");
            return '<div class="mce"><div id="' + this._id + '" class="' + this.classes + '" hidefocus="1" tabindex="-1" role="group">' + (this._preBodyHtml || "") + id + "</div></div>";
        }
    }), FlexLayout = Layout.extend({
        Defaults: {
            containerClass: "flex-layout",
            controlClass: "flex-layout-item"
        }
    }), FlowLayout = Layout.extend({
        Defaults: {
            containerClass: "flow-layout",
            controlClass: "flow-layout-item"
        },
        isNative: function() {
            return !0;
        }
    }), toggleFormat = function(editor, fmt) {
        return function() {
            editor.execCommand("mceToggleFormat", !1, fmt);
        };
    }, addFormatChangedListener = function(editor, name, changed) {
        function handler(state) {
            changed(state, name);
        }
        editor.formatter ? editor.formatter.formatChanged(name, handler) : editor.on("init", function() {
            editor.formatter.formatChanged(name, handler);
        });
    }, Align_register = function(editor) {
        var alignFormats = [ "alignleft", "aligncenter", "alignright", "alignjustify" ], alignMenuItems = [ {
            text: "Left",
            icon: "alignleft",
            onclick: toggleFormat(editor, "alignleft")
        }, {
            text: "Center",
            icon: "aligncenter",
            onclick: toggleFormat(editor, "aligncenter")
        }, {
            text: "Right",
            icon: "alignright",
            onclick: toggleFormat(editor, "alignright")
        }, {
            text: "Justify",
            icon: "alignjustify",
            onclick: toggleFormat(editor, "alignjustify")
        } ];
        editor.theme.addMenuItem("align", {
            text: "Align",
            menu: alignMenuItems
        }), editor.theme.addButton("align", {
            type: "menubutton",
            icon: "alignleft",
            menu: alignMenuItems,
            onShowMenu: function(e) {
                var menu = e.control.menu;
                Tools$6.each(alignFormats, function(formatName, idx) {
                    menu.items().eq(idx).each(function(item) {
                        return item.active(editor.formatter.match(formatName));
                    });
                });
            },
            onPostRender: function(e) {
                var ctrl = e.control;
                Tools$6.each(alignFormats, function(formatName, idx) {
                    addFormatChangedListener(editor, formatName, function(state) {
                        ctrl.icon("alignleft"), state && ctrl.icon(formatName);
                    });
                });
            }
        }), Tools$6.each({
            alignleft: "Align left",
            aligncenter: "Align center",
            alignright: "Align right",
            alignjustify: "Justify"
        }, function(label, name) {
            editor.theme.addButton(name, {
                active: !1,
                tooltip: label,
                onclick: function(e) {},
                onPostRender: postRenderFormatToggle(editor, name)
            });
        });
    }, createFontNameListBoxChangeHandler = function(editor, items) {
        return function() {
            var self = this;
            self.state.set("value", null), editor.on("init nodeChange", function(e) {
                var fontFamily = editor.queryCommandValue("FontName"), fontFamily = function(items, fontFamily) {
                    var value, font = fontFamily ? fontFamily.toLowerCase() : "";
                    return Tools$6.each(items, function(item) {
                        item.value.toLowerCase() === font && (value = item.value);
                    }), Tools$6.each(items, function(item) {
                        value || getFirstFont(item.value).toLowerCase() !== getFirstFont(font).toLowerCase() || (value = item.value);
                    }), value;
                }(items, fontFamily);
                self.value(fontFamily || null);
            }), self.on("createmenu", function() {
                self.menu.classes.add("listbox-menu");
            });
        };
    }, getFontItems = function(editor) {
        editor = function(formats) {
            for (var i = (formats = formats.replace(/;$/, "").split(";")).length; i--; ) formats[i] = formats[i].split("=");
            return formats;
        }(editor.settings.font_formats || "Andale Mono=andale mono,monospace;Arial=arial,helvetica,sans-serif;Arial Black=arial black,sans-serif;Book Antiqua=book antiqua,palatino,serif;Comic Sans MS=comic sans ms,sans-serif;Courier New=courier new,courier,monospace;Georgia=georgia,palatino,serif;Helvetica=helvetica,arial,sans-serif;Impact=impact,sans-serif;Symbol=symbol;Tahoma=tahoma,arial,helvetica,sans-serif;Terminal=terminal,monaco,monospace;Times New Roman=times new roman,times,serif;Trebuchet MS=trebuchet ms,geneva,sans-serif;Verdana=verdana,geneva,sans-serif;Webdings=webdings;Wingdings=wingdings,zapf dingbats");
        return Tools$6.map(editor, function(font) {
            return {
                text: {
                    raw: font[0]
                },
                value: font[1],
                textStyle: -1 === font[1].indexOf("dings") ? "font-family:" + font[1] : ""
            };
        });
    }, FontSelect_register = function(editor) {
        !function(editor) {
            editor.theme.addButton("fontselect", function() {
                var items = getFontItems(editor);
                return {
                    type: "listbox",
                    text: "Font Family",
                    tooltip: "Font Family",
                    values: items,
                    fixedWidth: !0,
                    onPostRender: createFontNameListBoxChangeHandler(editor, items),
                    onselect: function(e) {
                        e.control.settings.value && editor.execCommand("FontName", !1, e.control.settings.value);
                    }
                };
            });
        }(editor);
    }, createFontSizeListBoxChangeHandler = function(editor, items) {
        return function() {
            var self = this;
            editor.on("init nodeChange", function(e) {
                var pt, precision, match, px = editor.queryCommandValue("FontSize");
                if (px) for (precision = 3; !match && 0 <= precision; precision--) pt = toPt(px, precision), 
                match = function(items, pt, px) {
                    var value;
                    return Tools$6.each(items, function(item) {
                        item.value === px ? value = px : item.value === pt && (value = pt);
                    }), value;
                }(items, pt, px);
                self.value(match || null), match || self.text(pt);
            }), self.on("createmenu", function() {
                self.menu.classes.add("listbox-menu");
            });
        };
    }, getFontSizeItems = function(editor) {
        editor = editor.settings.fontsize_formats || "8pt 10pt 12pt 14pt 18pt 24pt 36pt";
        return Tools$6.map(editor.split(" "), function(item) {
            var text = item, value = item, item = item.split("=");
            return 1 < item.length && (text = item[0], value = item[1]), {
                text: text,
                value: value
            };
        });
    }, FontSizeSelect_register = function(editor) {
        !function(editor) {
            editor.theme.addButton("fontsizeselect", function() {
                var items = getFontSizeItems(editor);
                return {
                    type: "listbox",
                    text: "Font Sizes",
                    tooltip: "Font Sizes",
                    values: items,
                    fixedWidth: !0,
                    onPostRender: createFontSizeListBoxChangeHandler(editor, items),
                    onclick: function(e) {
                        e.control.settings.value && editor.execCommand("FontSize", !1, e.control.settings.value);
                    }
                };
            });
        }(editor);
    }, hideFormatMenuItems = function(editor, menu) {
        var count = menu.items().length;
        return menu.items().each(function(item) {
            item.menu && item.visible(0 < hideFormatMenuItems(editor, item.menu)), 
            !item.menu && item.settings.menu && item.visible(0 < hideMenuObjects(editor, item.settings.menu));
            var formatName = item.settings.format;
            formatName && item.visible(editor.formatter.canApply(formatName)), item.visible() || count--;
        }), count;
    }, Formats_register = function(editor) {
        var formatMenu = function(editor) {
            var count = 0, newFormats = [], defaultStyleFormats = [ {
                title: "Headings",
                items: [ {
                    title: "Heading 1",
                    format: "h1"
                }, {
                    title: "Heading 2",
                    format: "h2"
                }, {
                    title: "Heading 3",
                    format: "h3"
                }, {
                    title: "Heading 4",
                    format: "h4"
                }, {
                    title: "Heading 5",
                    format: "h5"
                }, {
                    title: "Heading 6",
                    format: "h6"
                } ]
            }, {
                title: "Inline",
                items: [ {
                    title: "Bold",
                    icon: "bold",
                    format: "bold"
                }, {
                    title: "Italic",
                    icon: "italic",
                    format: "italic"
                }, {
                    title: "Underline",
                    icon: "underline",
                    format: "underline"
                }, {
                    title: "Strikethrough",
                    icon: "strikethrough",
                    format: "strikethrough"
                }, {
                    title: "Superscript",
                    icon: "superscript",
                    format: "superscript"
                }, {
                    title: "Subscript",
                    icon: "subscript",
                    format: "subscript"
                }, {
                    title: "Code",
                    icon: "code",
                    format: "code"
                } ]
            }, {
                title: "Blocks",
                items: [ {
                    title: "Paragraph",
                    format: "p"
                }, {
                    title: "Blockquote",
                    format: "blockquote"
                }, {
                    title: "Div",
                    format: "div"
                }, {
                    title: "Pre",
                    format: "pre"
                } ]
            }, {
                title: "Alignment",
                items: [ {
                    title: "Left",
                    icon: "alignleft",
                    format: "alignleft"
                }, {
                    title: "Center",
                    icon: "aligncenter",
                    format: "aligncenter"
                }, {
                    title: "Right",
                    icon: "alignright",
                    format: "alignright"
                }, {
                    title: "Justify",
                    icon: "alignjustify",
                    format: "alignjustify"
                } ]
            } ], createMenu = function(formats) {
                var menu = [];
                if (formats) return Tools$6.each(formats, function(format) {
                    var formatName, menuItem = {
                        text: format.title,
                        icon: format.icon
                    };
                    format.items ? menuItem.menu = createMenu(format.items) : (formatName = format.format || "custom" + count++, 
                    format.format || (format.name = formatName, newFormats.push(format)), 
                    menuItem.format = formatName, menuItem.cmd = format.cmd), menu.push(menuItem);
                }), menu;
            };
            return editor.on("init", function() {
                Tools$6.each(newFormats, function(format) {
                    editor.formatter.register(format.name, format);
                });
            }), {
                type: "menu",
                items: editor.settings.style_formats_merge ? editor.settings.style_formats ? createMenu(defaultStyleFormats.concat(editor.settings.style_formats)) : createMenu(defaultStyleFormats) : createMenu(editor.settings.style_formats || defaultStyleFormats),
                onPostRender: function(e) {
                    editor.dispatch("renderFormatsMenu", {
                        control: e.control
                    });
                },
                itemDefaults: {
                    preview: !0,
                    textStyle: function() {
                        if (this.settings.format) return editor.formatter.getCssText(this.settings.format);
                    },
                    onPostRender: function() {
                        var self = this;
                        self.parent().on("show", function() {
                            var formatName = self.settings.format;
                            formatName && (self.disabled(!editor.formatter.canApply(formatName)), 
                            self.active(editor.formatter.match(formatName))), (formatName = self.settings.cmd) && self.active(editor.queryCommandState(formatName));
                        });
                    },
                    onclick: function() {
                        this.settings.format && toggleFormat(editor, this.settings.format)(), 
                        this.settings.cmd && editor.execCommand(this.settings.cmd);
                    }
                }
            };
        }(editor);
        !function(editor, formatMenu) {
            editor.theme.addMenuItem("formats", {
                text: "Formats",
                menu: formatMenu
            });
        }(editor, formatMenu), function(editor, formatMenu) {
            editor.theme.addButton("styleselect", {
                type: "menubutton",
                text: "Formats",
                menu: formatMenu,
                onShowMenu: function() {
                    editor.settings.style_formats_autohide && hideFormatMenuItems(editor, this.menu);
                }
            });
        }(editor, formatMenu);
    }, createListBoxChangeHandler = function(editor, items, formatName) {
        return function() {
            var self = this;
            editor.on("nodeChange", function(e) {
                var formatter = editor.formatter, value = null;
                Tools$6.each(e.parents, function(node) {
                    if (Tools$6.each(items, function(item) {
                        if (value = formatter.matchNode(node, item.value) ? item.value : value) return !1;
                    }), value) return !1;
                }), self.value(value);
            });
        };
    }, FormatSelect_register = function(editor) {
        var blocks = function(formats) {
            for (var i = (formats = formats.replace(/;$/, "").split(";")).length; i--; ) formats[i] = formats[i].split("=");
            return formats;
        }(editor.settings.block_formats || "Paragraph=p;Heading 1=h1;Heading 2=h2;Heading 3=h3;Heading 4=h4;Heading 5=h5;Heading 6=h6;Preformatted=pre");
        editor.theme.addMenuItem("blockformats", {
            text: "Blocks",
            menu: function(editor, blocks) {
                return Tools$6.map(blocks, function(block) {
                    return {
                        text: block[0],
                        onclick: toggleFormat(editor, block[1]),
                        textStyle: function() {
                            return editor.formatter.getCssText(block[1]);
                        }
                    };
                });
            }(editor, blocks)
        }), editor.theme.addButton("formatselect", function(editor, blocks) {
            return function() {
                var items = [];
                return Tools$6.each(blocks, function(block) {
                    items.push({
                        text: block[0],
                        value: block[1],
                        textStyle: function() {
                            return editor.formatter.getCssText(block[1]);
                        }
                    });
                }), {
                    type: "listbox",
                    text: blocks[0][0],
                    values: items,
                    fixedWidth: !0,
                    onselect: function(e) {
                        e.control && (e = e.control.value(), toggleFormat(editor, e)());
                    },
                    onPostRender: createListBoxChangeHandler(editor, items)
                };
            };
        }(editor, blocks));
    }, createInsertMenu = function(editor) {
        var insertButtonItems = editor.settings.insert_button_items;
        return trimMenuItems(insertButtonItems ? createCustomMenuItems(editor, insertButtonItems) : function(editor, context) {
            var outputMenuItems = [ {
                text: "-"
            } ], editor = Tools$6.grep(editor.theme.getMenuItems(), function(menuItem) {
                return menuItem.context === context;
            });
            return Tools$6.each(editor, function(menuItem) {
                "before" === menuItem.separator && outputMenuItems.push({
                    text: "|"
                }), menuItem.prependToContext ? outputMenuItems.unshift(menuItem) : outputMenuItems.push(menuItem), 
                "after" === menuItem.separator && outputMenuItems.push({
                    text: "|"
                });
            }), outputMenuItems;
        }(editor, "insert"));
    }, InsertButton_register = function(editor) {
        !function(editor) {
            editor.theme.addButton("insert", {
                type: "menubutton",
                icon: "insert",
                menu: [],
                oncreatemenu: function() {
                    this.menu.add(createInsertMenu(editor)), this.menu.renderNew();
                }
            });
        }(editor);
    }, registerFormatButtons = function(editor) {
        Tools$6.each({
            bold: "Bold",
            italic: "Italic",
            underline: "Underline",
            strikethrough: "Strikethrough",
            subscript: "Subscript",
            superscript: "Superscript",
            alignjustify: "Align Full",
            aligncenter: "Align Center",
            alignleft: "Align Left",
            alignright: "Align Right"
        }, function(text, name) {
            editor.theme.addButton(name, {
                active: !1,
                tooltip: text,
                onPostRender: postRenderFormatToggle(editor, name),
                onclick: function(e) {}
            });
        });
    }, registerCommandButtons = function(editor) {
        Tools$6.each({
            outdent: [ "Decrease indent", "Outdent" ],
            indent: [ "Increase indent", "Indent" ],
            cut: [ "Cut", "Cut" ],
            copy: [ "Copy", "Copy" ],
            paste: [ "Paste", "Paste" ],
            help: [ "Help", "mceHelp" ],
            selectall: [ "Select all", "SelectAll" ],
            visualaid: [ "Visual aids", "mceToggleVisualAid" ],
            newdocument: [ "New document", "mceNewDocument" ],
            removeformat: [ "Clear formatting", "RemoveFormat" ],
            remove: [ "Remove", "Delete" ]
        }, function(item, name) {
            editor.theme.addButton(name, {
                tooltip: item[0],
                onclick: function() {
                    editor.execCommand(item[1]);
                }
            });
        });
    }, registerCommandToggleButtons = function(editor) {
        Tools$6.each({
            blockquote: [ "Blockquote", "mceBlockQuote" ],
            subscript: [ "Subscript", "Subscript" ],
            superscript: [ "Superscript", "Superscript" ]
        }, function(item, name) {
            editor.theme.addButton(name, {
                active: !1,
                tooltip: item[0],
                onclick: function() {
                    editor.execCommand(item[1]);
                },
                onPostRender: postRenderFormatToggle(editor, name)
            });
        });
    }, SimpleControls_register = function(editor) {
        !function(editor) {
            registerFormatButtons(editor), registerCommandButtons(editor), registerCommandToggleButtons(editor);
        }(editor), function(editor) {
            Tools$6.each({
                bold: [ "Bold", "Bold", "Meta+B" ],
                italic: [ "Italic", "Italic", "Meta+I" ],
                underline: [ "Underline", "Underline", "Meta+U" ],
                strikethrough: [ "Strikethrough", "Strikethrough" ],
                subscript: [ "Subscript", "Subscript" ],
                superscript: [ "Superscript", "Superscript" ],
                removeformat: [ "Clear formatting", "RemoveFormat" ],
                newdocument: [ "New document", "mceNewDocument" ],
                cut: [ "Cut", "Cut", "Meta+X" ],
                copy: [ "Copy", "Copy", "Meta+C" ],
                paste: [ "Paste", "Paste", "Meta+V" ],
                selectall: [ "Select all", "SelectAll", "Meta+A" ]
            }, function(item, name) {
                editor.theme.addMenuItem(name, {
                    text: item[0],
                    icon: name,
                    shortcut: item[2],
                    onclick: function() {
                        editor.execCommand(item[1]);
                    }
                });
            }), editor.theme.addMenuItem("codeformat", {
                text: "Code",
                icon: "code",
                onclick: toggleFormat(editor, "code")
            });
        }(editor);
    }, toggleUndoRedoState = function(editor, type) {
        return function() {
            function checkState() {
                return !!editor.undoManager && editor.undoManager["redo" === type ? "hasRedo" : "hasUndo"]();
            }
            var self = this;
            self.disabled(!checkState()), editor.on("Undo Redo AddUndo TypingUndo ClearUndos SwitchMode", function() {
                self.disabled(editor.readonly || !checkState());
            });
        };
    }, UndoRedo_register = function(editor) {
        !function(editor) {
            editor.theme.addMenuItem("undo", {
                text: "Undo",
                icon: "undo",
                shortcut: "Meta+Z",
                onPostRender: toggleUndoRedoState(editor, "undo"),
                onclick: function() {
                    editor.execCommand("undo");
                }
            }), editor.theme.addMenuItem("redo", {
                text: "Redo",
                icon: "redo",
                shortcut: "Meta+Y",
                onPostRender: toggleUndoRedoState(editor, "redo"),
                onclick: function() {
                    editor.execCommand("redo");
                }
            });
        }(editor), function(editor) {
            editor.theme.addButton("undo", {
                tooltip: "Undo",
                onPostRender: toggleUndoRedoState(editor, "undo"),
                onclick: function(e) {
                    editor.execCommand("undo");
                }
            }), editor.theme.addButton("redo", {
                tooltip: "Redo",
                onPostRender: toggleUndoRedoState(editor, "redo"),
                onclick: function() {
                    editor.execCommand("redo");
                }
            });
        }(editor);
    }, toggleVisualAidState = function(editor) {
        return function() {
            var self = this;
            editor.on("VisualAid", function(e) {
                self.active(e.hasVisual);
            }), self.active(editor.hasVisual);
        };
    }, VisualAid_register = function(editor) {
        !function(editor) {
            editor.theme.addMenuItem("visualaid", {
                text: "Visual aids",
                selectable: !0,
                onPostRender: toggleVisualAidState(editor),
                cmd: "mceToggleVisualAid"
            });
        }(editor);
    }, EditorManager$1 = tinymce.EditorManager, FormatControls = {
        setup: function(editor) {
            !function(editor) {
                editor.rtl && (Control$1.rtl = !0);
            }(editor), function(editor) {
                editor.on("mousedown progressstate", function() {
                    FloatPanel.hideAll();
                });
            }(editor), function(editor) {
                editor.settings.ui_container && (Env$1.container = funcs.select(editor.settings.ui_container)[0]);
            }(editor), Widget.tooltips = !Env$1.ios, Control$1.translate = function(text) {
                return EditorManager$1.translate(text);
            }, FormatSelect_register(editor), Align_register(editor), SimpleControls_register(editor), 
            UndoRedo_register(editor), FontSizeSelect_register(editor), FontSelect_register(editor), 
            Formats_register(editor), VisualAid_register(editor), InsertButton_register(editor);
        }
    }, GridLayout = FlexLayout.extend({
        Defaults: {
            containerClass: "grid-layout",
            controlClass: "grid-layout-item"
        }
    }), Iframe$1 = Widget.extend({
        renderHtml: function() {
            return this.classes.add("iframe"), this.canFocus = !1, '<iframe id="' + this._id + '" class="' + this.classes + '" tabindex="-1" src="' + (this.settings.url || "javascript:''") + '" frameborder="0"></iframe>';
        },
        src: function(src) {
            this.getEl().src = src;
        },
        html: function(html, callback) {
            var self = this, body = this.getEl().contentWindow.document.body;
            return body ? (body.innerHTML = html, callback && callback()) : Delay$1.setTimeout(function() {
                self.html(html);
            }), this;
        }
    }), InfoBox = Widget.extend({
        init: function(settings) {
            this._super(settings), this.classes.add("widget").add("infobox"), this.canFocus = !1;
        },
        severity: function(level) {
            this.classes.remove("error"), this.classes.remove("warning"), this.classes.remove("success"), 
            this.classes.add(level);
        },
        help: function(state) {
            this.state.set("help", state);
        },
        renderHtml: function() {
            var prefix = this.classPrefix;
            return '<div id="' + this._id + '" class="' + this.classes + '"><div id="' + this._id + '-body">' + this.encode(this.state.get("text")) + '<button role="button" tabindex="-1"><span class="' + prefix + "ico " + prefix + 'i-help"></span></button></div></div>';
        },
        bindStates: function() {
            var self = this;
            return self.state.on("change:text", function(e) {
                self.getEl("body").firstChild.data = self.encode(e.value), self.state.get("rendered") && self.updateLayoutRect();
            }), self.state.on("change:help", function(e) {
                self.classes.toggle("has-help", e.value), self.state.get("rendered") && self.updateLayoutRect();
            }), self._super();
        }
    }), Label = Widget.extend({
        init: function(settings) {
            this._super(settings), this.classes.add("widget").add("label"), this.canFocus = !1, 
            settings.multiline && this.classes.add("autoscroll"), settings.strong && this.classes.add("strong"), 
            settings.heading && this.classes.add("heading");
        },
        severity: function(level) {
            this.classes.remove("error"), this.classes.remove("warning"), this.classes.remove("success"), 
            this.classes.add(level);
        },
        renderHtml: function() {
            var forName, forId = this.settings.forId, text = this.settings.html || this.encode(this.state.get("text"));
            return (forId = !forId && (forName = this.settings.forName) && (forName = this.getRoot().find("#" + forName)[0]) ? forName._id : forId) ? '<label id="' + this._id + '" class="' + this.classes + '"' + (forId ? ' for="' + forId + '"' : "") + ">" + text + "</label>" : '<span id="' + this._id + '" class="' + this.classes + '">' + text + "</span>";
        },
        bindStates: function() {
            var self = this;
            return self.state.on("change:text", function(e) {
                e = e.html ? e.value : self.encode(e.value);
                self.innerHtml(e), self.state.get("rendered") && self.updateLayoutRect();
            }), self._super();
        }
    }), Toolbar$1 = Container.extend({
        Defaults: {
            role: "toolbar",
            layout: "flow"
        },
        init: function(settings) {
            this._super(settings), this.classes.add("toolbar");
        },
        postRender: function() {
            return this.items().each(function(ctrl) {
                ctrl.classes.add("toolbar-item");
            }), this._super();
        }
    }), MenuBar = Toolbar$1.extend({
        Defaults: {
            role: "menubar",
            containerCls: "menubar",
            ariaRoot: !0,
            defaults: {
                type: "menubutton"
            }
        }
    });
    var MenuButton = Button.extend({
        init: function(settings) {
            this._renderOpen = !0, this._super(settings), settings = this.settings, 
            this.classes.add("menubtn"), settings.fixedWidth && this.classes.add("fixed-width"), 
            this.aria("haspopup", !0), this.state.set("menu", settings.menu || this.render());
        },
        showMenu: function(toggle) {
            var self = this;
            if (self.menu && self.menu.visible() && !1 !== toggle) return self.hideMenu();
            self.menu || ((toggle = self.state.get("menu") || []).length ? toggle = {
                type: "menu",
                items: toggle
            } : toggle.type = toggle.type || "menu", toggle.renderTo ? self.menu = toggle.parent(self).show().renderTo() : self.menu = Factory.create(toggle).parent(self).renderTo(), 
            self.dispatch("createmenu"), self.menu.on("cancel", function(e) {
                e.control.parent() === self.menu && (e.stopPropagation(), self.focus(), 
                self.hideMenu());
            }), self.menu.on("select", function() {
                self.focus();
            }), self.menu.on("show hide", function(e) {
                e.control === self.menu && self.activeMenu("show" == e.type), self.aria("expanded", "show" == e.type);
            }).dispatch("show")), self.menu.show();
            toggle = self.menu.testMoveRel(self.getEl(), self.isRtl() ? [ "br-tr", "tr-br" ] : [ "bl-tl", "tl-bl" ]);
            [ "br-tr", "tr-br", "bl-tl", "tl-bl" ].forEach(function(cls) {
                self.menu.classes.remove("pos-" + cls), self.classes.remove("pos-" + cls);
            }), self.menu.classes.add("pos-" + toggle), self.classes.add("pos-" + toggle), 
            self.menu.moveRel(self.getEl(), toggle), self.dispatch("showmenu");
        },
        hideMenu: function() {
            this.menu && (this.menu.items().each(function(item) {
                item.hideMenu && item.hideMenu();
            }), this.menu.hide());
        },
        activeMenu: function(state) {
            this.classes.toggle("active", state);
        },
        renderHtml: function() {
            var id = this._id, prefix = this.classPrefix, icon = this.settings.icon, text = this.state.get("text"), textHtml = "", image = this.settings.image;
            return image = image ? (icon = "none", " style=\"background-image: url('" + (image = "string" != typeof image ? window.getSelection ? image[0] : image[1] : image) + "')\"") : "", 
            text && (this.classes.add("btn-has-text"), textHtml = '<span class="' + prefix + 'txt">' + this.encode(text) + "</span>"), 
            icon = this.settings.icon ? prefix + "ico " + prefix + "i-" + icon : "", 
            this.aria("role", this.parent() instanceof MenuBar ? "menuitem" : "button"), 
            '<div id="' + id + '" class="' + this.classes + '" tabindex="-1" aria-labelledby="' + id + '" role="button"><button id="' + id + '-btn" type="button" tabindex="-1">' + (icon ? '<span class="' + icon + '"' + image + "></span>" : "") + textHtml + '<svg version="1.1" xmlns="http://www.w3.org/2000/svg" width="16" height="16" viewBox="0 0 512 512"><path d="M256 64l-96 160h192z"></path><path d="M256 448l-96-160h192z"></path></svg></button></div>';
        },
        postRender: function() {
            var self = this;
            return self.on("click", function(e) {
                e.control === self && function(node, parent) {
                    for (;node; ) {
                        if (parent === node) return 1;
                        node = node.parentNode;
                    }
                }(e.target, self.getEl()) && (self.focus(), self.showMenu(!e.aria), 
                e.aria) && self.menu.items().filter(":visible")[0].focus();
            }), self.on("mouseenter", function(e) {
                var hasVisibleSiblingMenu, overCtrl = e.control, e = self.parent();
                overCtrl && e && overCtrl instanceof MenuButton && overCtrl.parent() == e && (e.items().filter("MenuButton").each(function(ctrl) {
                    ctrl.hideMenu && ctrl != overCtrl && (ctrl.menu && ctrl.menu.visible() && (hasVisibleSiblingMenu = !0), 
                    ctrl.hideMenu());
                }), hasVisibleSiblingMenu) && (overCtrl.focus(), overCtrl.showMenu());
            }), self._super();
        },
        bindStates: function() {
            var self = this;
            return self.state.on("change:menu", function() {
                self.menu && self.menu.remove(), self.menu = null;
            }), self._super();
        },
        remove: function() {
            this._super(), this.menu && this.menu.remove();
        }
    }), $$4 = DomQuery;
    function Throbber(elm, inline) {
        var state, timer, self = this, classPrefix = Control$1.classPrefix;
        self.show = function(time, callback) {
            function render() {
                state && ($$4(elm).append('<div class="' + classPrefix + "throbber" + (inline ? " " + classPrefix + "throbber-inline" : "") + '"></div>'), 
                callback) && callback();
            }
            return self.hide(), state = !0, time ? timer = Delay$1.setTimeout(render, time) : render(), 
            self;
        }, self.hide = function() {
            var child = elm.lastChild;
            return Delay$1.clearTimeout(timer), child && -1 != child.className.indexOf("throbber") && child.parentNode.removeChild(child), 
            state = !1, self;
        };
    }
    var Menu = FloatPanel.extend({
        Defaults: {
            defaultType: "menuitem",
            layout: "stack",
            role: "application",
            bodyRole: "menu",
            ariaRoot: !0
        },
        init: function(settings) {
            if (settings.autohide = !0, settings.constrainToViewport = !0, "function" == typeof settings.items && (settings.itemsFactory = settings.items, 
            settings.items = []), settings.itemDefaults) for (var items = settings.items, i = items.length; i--; ) items[i] = Tools$6.extend({}, settings.itemDefaults, items[i]);
            this._super(settings), this.classes.add("menu");
        },
        cancel: function() {
            this.hideAll(), this.dispatch("select");
        },
        load: function() {
            var time, self = this;
            function hideThrobber() {
                self.throbber && (self.throbber.hide(), self.throbber = null);
            }
            self.settings.itemsFactory && (self.throbber || (self.throbber = new Throbber(self.getEl("body"), !0), 
            0 === self.items().length ? (self.throbber.show(), self.dispatch("loading")) : self.throbber.show(100, function() {
                self.items().remove(), self.dispatch("loading");
            }), self.on("hide close", hideThrobber)), self.requestTime = time = new Date().getTime(), 
            self.settings.itemsFactory(function(items) {
                0 === items.length ? self.hide() : self.requestTime === time && (self.getEl().style.width = "", 
                self.getEl("body").style.width = "", hideThrobber(), self.items().remove(), 
                self.getEl("body").innerHTML = "", self.add(items), self.renderNew(), 
                self.dispatch("loaded"));
            }));
        },
        hideAll: function() {
            return this.find("menuitem").exec("hideMenu"), this._super();
        },
        preRender: function() {
            var self = this;
            return self.items().each(function(ctrl) {
                ctrl = ctrl.settings;
                if (ctrl.icon || ctrl.image || ctrl.selectable) return !(self._hasIcons = !0);
            }), self.settings.itemsFactory && self.on("postrender", function() {
                self.settings.itemsFactory && self.load();
            }), self._super();
        }
    }), ListBox = MenuButton.extend({
        init: function(settings) {
            var values, selected, selectedText, lastItemCtrl, self = this;
            self._super(settings), settings = self.settings, self._values = values = settings.values, 
            values && (void 0 !== settings.value && function setSelected(menuValues) {
                for (var i = 0; i < menuValues.length; i++) {
                    if (selected = menuValues[i].selected || settings.value === menuValues[i].value) return selectedText = selectedText || menuValues[i].text, 
                    self.state.set("value", menuValues[i].value), 1;
                    if (menuValues[i].menu && setSelected(menuValues[i].menu)) return 1;
                }
            }(values), !selected && 0 < values.length && (selectedText = values[0].text, 
            self.state.set("value", values[0].value)), self.state.set("menu", values)), 
            self.state.set("text", settings.text || selectedText), self.classes.add("listbox"), 
            self.on("select", function(e) {
                var ctrl = e.control;
                lastItemCtrl && (e.lastControl = lastItemCtrl), settings.multiple ? ctrl.active(!ctrl.active()) : self.value(e.control.value()), 
                lastItemCtrl = ctrl;
            });
        },
        bindStates: function() {
            var self = this;
            return self.on("show", function(e) {
                var value;
                e = e.control, value = self.value(), e instanceof Menu && e.items().each(function(ctrl) {
                    ctrl.hasMenus() || ctrl.active(ctrl.value() === value);
                }), self.menu.layoutRect({
                    w: self.layoutRect().w
                }), self.menu.getEl().style.width = self.layoutRect().w + "px";
            }), self.state.on("change:value", function(e) {
                e = function getSelectedItem(menuValues, value) {
                    var selectedItem;
                    if (menuValues) for (var i = 0; i < menuValues.length; i++) {
                        if (menuValues[i].value === value) return menuValues[i];
                        if (menuValues[i].menu && (selectedItem = getSelectedItem(menuValues[i].menu, value))) return selectedItem;
                    }
                }(self.state.get("menu"), e.value);
                e ? self.text(e.text) : self.text(self.settings.text);
            }), self._super();
        }
    }), Tree = Container.extend({
        Defaults: {
            role: "tree"
        },
        init: function(settings) {
            if (settings.itemDefaults) for (var items = settings.items, i = items.length; i--; ) items[i] = Tools$6.extend({}, settings.itemDefaults, items[i]);
            this._super(settings), this.classes.add("tree");
        },
        renderHtml: function() {
            var id = this._id, layout = this._layout;
            return this.preRender(), layout.preRender(this), '<div id="' + id + '" class="' + this.classes + '" tabindex="-1" role="tree"> <ul id="' + this._id + '-body" class="' + this.bodyClasses + '" role="group">' + layout.renderHtml(this) + "</ul></div>";
        }
    }), TreeItem = Container.extend({
        Defaults: {
            role: "treeitem"
        },
        init: function(settings) {
            this._super(settings), settings = this.settings, this.classes.add("menu-item"), 
            this.classes.add("tree-item"), this.bodyClasses.add("tree-item-body"), 
            this.on("mousedown", function(e) {
                e.preventDefault();
            }), settings.items && this.classes.add("tree-item-parent");
        },
        hasList: function() {
            return !!this.settings.list;
        },
        showList: function() {
            var self = this, settings = self.settings;
            self.parent().items().each(function(ctrl) {
                ctrl !== self && ctrl.hideList();
            }), self.items().length || settings.items && (self.add(settings.items), 
            self.renderNew()), self.aria("expanded", !0), self.active(!0);
        },
        hideList: function() {
            return this.items().each(function(item) {
                item.hideList && item.hideList();
            }), this.aria("expanded", !1), this.active(!1), this;
        },
        showStatus: function(state) {
            state ? this.classes.add("loading") : this.classes.remove("loading");
        },
        renderHtml: function() {
            var id = this._id, settings = this.settings, prefix = this.classPrefix, text = this.state.get("text");
            var icon, text = this.encode(text), html = '<li id="' + id + '" class="' + this.classes + '" tabindex="-1" role="treeitem"> <div role="group" class="' + prefix + 'tree-item-row">';
            return settings.items && (html += '<span role="presentation" class="' + prefix + 'tree-item-toggle"><span class="' + prefix + "ico " + prefix + 'i-caret-right"></span><span class="' + prefix + "ico " + prefix + 'i-caret-down"></span></span>'), 
            html += '<a title="' + text + '" class="' + prefix + 'tree-item-link">' + (icon = settings.icon, 
            settings.items ? '<span class="' + prefix + "ico " + prefix + "i-" + (icon || "folder") + '"></span><span class="' + prefix + "ico " + prefix + "i-" + (icon || "folder") + '-open"></span>' : '<span class="' + prefix + "ico " + prefix + "i-" + (icon || "file") + '"></span>') + '     <span id="' + id + '-text" class="' + prefix + 'text">' + text + '</span>   </a></div> <ul id="' + this._id + '-body" class="' + this.bodyClasses + '" role="group"></ul></li>';
        },
        postRender: function() {
            var self = this;
            return self.on("click", function(e) {
                e.control === self && (e.metaKey = VK.metaKeyPressed(e), funcs.getParent(e.target, "a") && self.dispatch("select", e), 
                e.isDefaultPrevented() || self.showList());
            }), self._super(), self;
        },
        remove: function() {
            this._super(), this.list && this.list.remove();
        }
    }), MenuItem = Widget.extend({
        Defaults: {
            role: "menuitem"
        },
        init: function(settings) {
            var text;
            this._super(settings), settings = this.settings, this.classes.add("menu-item"), 
            settings.menu && this.classes.add("menu-item-expand"), settings.preview && this.classes.add("menu-item-preview"), 
            "-" !== (text = this.state.get("text")) && "|" !== text || (this.classes.add("menu-item-sep"), 
            this.aria("role", "separator"), this.state.set("text", "-")), settings.selectable && (this.aria("role", "menuitemcheckbox"), 
            this.classes.add("menu-item-checkbox"), settings.icon = "selected"), 
            settings.preview || settings.selectable || this.classes.add("menu-item-normal"), 
            this.on("mousedown", function(e) {
                e.preventDefault();
            }), settings.menu && !settings.ariaHideMenu && this.aria("haspopup", !0);
        },
        hasMenus: function() {
            return !!this.settings.menu;
        },
        showMenu: function() {
            var menu, self = this, settings = self.settings, parent = self.parent();
            parent.items().each(function(ctrl) {
                ctrl !== self && "menuitem" == ctrl.type && ctrl.hideMenu();
            }), settings.menu && ((menu = self.menu) ? menu.show() : ((menu = settings.menu).length ? menu = {
                type: "menu",
                items: menu
            } : menu.type = menu.type || "menu", parent.settings.itemDefaults && (menu.itemDefaults = parent.settings.itemDefaults), 
            (menu = self.menu = Factory.create(menu).parent(self).renderTo()).on("cancel", function(e) {
                e.stopPropagation(), self.focus(), menu.hide();
            }), menu.on("show hide", function(e) {
                e.control.items && e.control.items().each(function(ctrl) {
                    ctrl.active(ctrl.settings.selected);
                });
            }).dispatch("show"), menu.on("hide", function(e) {
                e.control === menu && self.classes.remove("selected");
            }), menu.submenu = !0), menu._parentMenu = parent, menu.classes.add("menu-sub"), 
            settings = menu.testMoveRel(self.getEl(), self.isRtl() ? [ "tl-tr", "bl-br", "tr-tl", "br-bl" ] : [ "tr-tl", "br-bl", "tl-tr", "bl-br" ]), 
            menu.moveRel(self.getEl(), settings), settings = "menu-sub-" + (menu.rel = settings), 
            menu.classes.remove(menu._lastRel).add(settings), menu._lastRel = settings, 
            self.classes.add("selected"), self.aria("expanded", !0));
        },
        hideMenu: function() {
            return this.menu && (this.menu.items().each(function(item) {
                item.hideMenu && item.hideMenu();
            }), this.menu.hide(), this.aria("expanded", !1)), this;
        },
        renderHtml: function() {
            var id = this._id, settings = this.settings, prefix = this.classPrefix, text = this.state.get("text"), icon = this.settings.icon, image = "", svg = "", shortcut = settings.shortcut, url = this.encode(settings.url), html = settings.html || "";
            function escapeRegExp(str) {
                return str.replace(/[.*+?^${}()|[\]\\]/g, "\\$&");
            }
            function markMatches(text) {
                var match = settings.match || "";
                return match ? text.replace(new RegExp(escapeRegExp(match), "gi"), function(match) {
                    return "!mce~match[" + match + "]mce~match!";
                }) : text;
            }
            function boldMatches(text) {
                return text.replace(new RegExp(escapeRegExp("!mce~match["), "g"), "<b>").replace(new RegExp(escapeRegExp("]mce~match!"), "g"), "</b>");
            }
            return html || (icon && this.parent().classes.add("menu-has-icons"), 
            settings.image && (image = " style=\"background-image: url('" + settings.image + "')\""), 
            settings.svg && (svg = "" + settings.svg, settings.icon = "svg"), shortcut = shortcut && function(shortcut) {
                var i, value, replace = {}, replace = Env$1.ios ? {
                    alt: "&#x2325;",
                    ctrl: "&#x2318;",
                    shift: "&#x21E7;",
                    meta: "&#x2318;"
                } : {
                    meta: "Ctrl"
                };
                for (shortcut = shortcut.split("+"), i = 0; i < shortcut.length; i++) (value = replace[shortcut[i].toLowerCase()]) && (shortcut[i] = value);
                return shortcut.join("+");
            }(shortcut), icon = prefix + "ico " + prefix + "i-" + (settings.icon || "none"), 
            html = ("-" !== text ? '<span class="' + icon + '"' + image + ">" + svg + "</span>" : "") + ("-" !== (text = boldMatches(this.encode(markMatches(text)))) ? '<span id="' + id + '-text" class="' + prefix + 'text">' + text + "</span>" : "") + (shortcut ? '<div id="' + id + '-shortcut" class="' + prefix + 'menu-shortcut">' + shortcut + "</div>" : "") + ((url = boldMatches(this.encode(markMatches(url)))) ? '<div class="' + prefix + 'menu-item-link">' + url + "</div>" : "")), 
            '<div id="' + id + '" class="' + this.classes + '" tabindex="-1">' + html + "</div>";
        },
        postRender: function() {
            var textElm, self = this, settings = self.settings, textStyle = settings.textStyle;
            return (textStyle = "function" == typeof textStyle ? textStyle.call(this) : textStyle) && (textElm = self.getEl("text")) && (textElm.setAttribute("style", textStyle), 
            self._textStyle = textStyle), self.on("mouseenter click", function(e) {
                e.control === self && (settings.menu || "click" !== e.type ? (self.showMenu(), 
                e.aria && self.menu.focus(!0)) : (self.dispatch("select", e), e.isDefaultPrevented() || Delay$1.requestAnimationFrame(function() {
                    self.parent().hideAll();
                })));
            }), self._super(), self;
        },
        hover: function() {
            return this.parent().items().each(function(ctrl) {
                ctrl.classes.remove("selected");
            }), this.classes.toggle("selected", !0), this;
        },
        active: function(state) {
            return function(ctrl, state) {
                var textStyle = ctrl._textStyle;
                textStyle && ((ctrl = ctrl.getEl("text")).setAttribute("style", textStyle), 
                state) && (ctrl.style.color = "", ctrl.style.backgroundColor = "");
            }(this, state), void 0 !== state && this.aria("checked", state), this._super(state);
        },
        remove: function() {
            this._super(), this.menu && this.menu.remove();
        }
    }), MediaItem = Widget.extend({
        init: function(settings) {
            this._super(settings), this.classes.add("media-item"), settings.selectable && this.classes.add("media-item-checkbox");
        },
        renderHtml: function() {
            var icon, id = this._id, settings = this.settings, prefix = this.classPrefix, text = this.state.get("text"), image = (this.settings.icon, 
            ""), url = this.encode(settings.url);
            return settings.image && (image = '<div class="' + prefix + 'avatar"><img src="' + settings.image + '" alt="" role="presentation" loading="lazy" /></div>'), 
            settings.svg && (image = '<div class="' + prefix + 'avatar">' + settings.svg + "</div>"), 
            icon = prefix + "ico " + prefix + "i-" + (this.settings.icon || "none"), 
            '<div id="' + id + '" class="' + this.classes + '" tabindex="-1"' + (settings.draggable ? ' draggable="true"' : "") + ">" + ('<div class="' + icon + '">' + image + "</div>") + (settings.title ? '<div id="' + id + '-title" class="' + prefix + 'text">' + this.encode(settings.title) + "</div>" : "") + '<div id="' + id + '-text" class="' + prefix + 'text">' + this.encode(text) + "</div>" + (url ? '<div class="' + prefix + 'media-item-link">' + url + "</div>" : "") + (settings.selectable ? '<div class="' + prefix + 'checkbox"><input type="checkbox" /></div>' : "") + "</div>";
        },
        postRender: function() {
            return this._super(), this;
        }
    }), windows = [], oldMetaValue = "";
    function toggleFullScreenState(state) {
        var contentValue, viewport = DomQuery("meta[name=viewport]")[0];
        !1 !== Env$1.overrideViewPort && (viewport || ((viewport = document.createElement("meta")).setAttribute("name", "viewport"), 
        document.getElementsByTagName("head")[0].appendChild(viewport)), (contentValue = viewport.getAttribute("content")) && void 0 !== oldMetaValue && (oldMetaValue = contentValue), 
        viewport.setAttribute("content", state ? "width=device-width,initial-scale=1.0,user-scalable=0,minimum-scale=1.0,maximum-scale=1.0" : oldMetaValue));
    }
    function toggleBodyFullScreenClasses(classPrefix, state) {
        !function() {
            for (var i = 0; i < windows.length; i++) if (windows[i]._fullscreen) return 1;
            return;
        }() || !1 !== state || DomQuery([ document.documentElement, document.body ]).removeClass(classPrefix + "fullscreen");
    }
    function updateLiveRegion(ctx, text) {
        ctx.getEl().lastChild.textContent = text + (ctx.progressBar ? " " + ctx.progressBar.value() + "%" : "");
    }
    var lastSize, Window = FloatPanel.extend({
        modal: !0,
        Defaults: {
            layout: "flex",
            containerCls: "panel",
            role: "dialog",
            position: "center",
            callbacks: {
                submit: function() {
                    this.dispatch("submit", {
                        data: this.toJSON()
                    });
                },
                close: function() {
                    this.close();
                }
            }
        },
        init: function(settings) {
            var self = this;
            settings.size && (settings.width = !1, settings.height = !1), self._super(settings), 
            self.isRtl() && self.classes.add("rtl"), self.classes.add("window"), 
            self.bodyClasses.add("window-body"), settings.size && self.classes.add("window-" + settings.size), 
            settings.url && self.classes.add("window-iframe"), settings.buttons && (self.statusbar = new Panel({
                layout: "flex",
                defaults: {
                    type: "button"
                },
                items: settings.buttons
            }), self.statusbar.classes.add("window-foot"), self.statusbar.parent(self)), 
            self.on("click", function(e) {
                var closeClass = self.classPrefix + "close";
                (funcs.hasClass(e.target, closeClass) || funcs.hasClass(e.target.parentNode, closeClass)) && self.close();
            }), self.on("cancel", function() {
                self.close();
            }), self.aria("describedby", self.describedBy || self._id + "-none"), 
            self.aria("label", settings.title), self._fullscreen = !1, self._hasBody = !1;
        },
        reflow: function() {
            return this.visible() && (this.recalc(), this.repaint()), this;
        },
        initLayoutRect: function() {
            var layoutRect = this._super(), deltaH = 0, headEl = (this.settings.title && !this._fullscreen && (headEl = this.getEl("head"), 
            headEl = funcs.getSize(headEl), layoutRect.headerW = headEl.width, layoutRect.headerH = headEl.height, 
            deltaH += layoutRect.headerH), this.statusbar && (deltaH += this.statusbar.layoutRect().h), 
            layoutRect.deltaH += deltaH, layoutRect.minH += deltaH, layoutRect.h += deltaH, 
            funcs.getWindowSize());
            return layoutRect.x = this.settings.x || Math.round(Math.max(headEl.x + 10, headEl.x + headEl.w / 2 - layoutRect.w / 2)), 
            layoutRect.y = this.settings.y || Math.round(Math.max(headEl.y + 10, headEl.y + headEl.h / 2 - layoutRect.h / 2)), 
            "right" == this.settings.position && (layoutRect.x = 20), "right" == this.settings.position && (layoutRect.x = Math.round(headEl.w - layoutRect.w - 20)), 
            layoutRect;
        },
        renderHtml: function() {
            var layout = this._layout, id = this._id, prefix = this.classPrefix, settings = this.settings, headerHtml = "", footerHtml = "", html = settings.html;
            return this.preRender(), layout.preRender(this), settings.title && (headerHtml = '<div id="' + id + '-head" class="' + prefix + 'window-head"><div id="' + id + '-title" class="' + prefix + 'title">' + this.encode(settings.title) + '</div><div id="' + id + '-dragh" class="' + prefix + 'dragh"></div><button type="button" class="' + prefix + 'close"><span class="wfe-ico wfe-i-remove"></span></button></div>'), 
            void 0 === (html = settings.url ? '<iframe src="' + settings.url + '" tabindex="-1" id="' + id + '-ifr"></iframe>' : html) && (html = layout.renderHtml(this)), 
            this.statusbar && (footerHtml = this.statusbar.renderHtml()), '<div id="' + id + '" class="' + this.classes + '" hidefocus="1" role="application">' + headerHtml + '<div id="' + id + '-body" class="' + this.bodyClasses + '">' + html + "</div>" + footerHtml + "</div>";
        },
        fullscreen: function(state) {
            var slowRendering, layoutRect, self = this, documentElement = document.documentElement, prefix = self.classPrefix;
            return state != self._fullscreen && (DomQuery(window).on("resize", function() {
                var time, rect;
                self._fullscreen && (slowRendering ? self._timer || (self._timer = Delay$1.setTimeout(function() {
                    var rect = funcs.getWindowSize();
                    self.moveTo(0, 0).resizeTo(rect.w, rect.h), self._timer = 0;
                }, 50)) : (time = new Date().getTime(), rect = funcs.getWindowSize(), 
                self.moveTo(0, 0).resizeTo(rect.w, rect.h), 50 < new Date().getTime() - time && (slowRendering = !0)));
            }), layoutRect = self.layoutRect(), (self._fullscreen = state) ? (self._initial = {
                x: layoutRect.x,
                y: layoutRect.y,
                w: layoutRect.w,
                h: layoutRect.h
            }, self.getEl("head").style.display = "none", layoutRect.deltaH -= layoutRect.headerH + 2, 
            DomQuery([ documentElement, document.body ]).addClass(prefix + "fullscreen"), 
            self.classes.add("fullscreen"), state = funcs.getWindowSize(), self.moveTo(0, 0).resizeTo(state.w, state.h)) : (self.getEl("head").style.display = "", 
            layoutRect.deltaH += layoutRect.headerH, DomQuery([ documentElement, document.body ]).removeClass(prefix + "fullscreen"), 
            self.classes.remove("fullscreen"), self.moveTo(self._initial.x, self._initial.y).resizeTo(self._initial.w, self._initial.h))), 
            self.reflow();
        },
        postRender: function() {
            var startPos, self = this;
            setTimeout(function() {
                self.classes.add("in"), self.dispatch("open");
            }, 0), self._super(), self.statusbar && self.statusbar.postRender(), 
            self.focus(), this.dragHelper = new DragHelper(self._id + "-dragh", {
                start: function() {
                    startPos = {
                        x: self.layoutRect().x,
                        y: self.layoutRect().y
                    };
                },
                drag: function(e) {
                    self.moveTo(startPos.x + e.deltaX, startPos.y + e.deltaY);
                }
            }), self.on("submit", function(e) {
                e.isDefaultPrevented() || self.close();
            }), self.on("keydown", function(e) {
                8 !== e.keyCode || !e.target || e.target && ("INPUT" === e.target.nodeName || "SELECT" === e.target.nodeName || "TEXTAREA" === e.target.nodeName) || (e.preventDefault(), 
                e.stopImmediatePropagation());
            }), windows.push(self), toggleFullScreenState(!0), this.reflow();
        },
        submit: function() {
            return this.dispatch("submit", {
                data: this.toJSON()
            });
        },
        remove: function() {
            var i;
            for (this.dragHelper.destroy(), this._super(), this.statusbar && this.statusbar.remove(), 
            toggleBodyFullScreenClasses(this.classPrefix, !1), i = windows.length; i--; ) windows[i] === this && windows.splice(i, 1);
            toggleFullScreenState(0 < windows.length);
        },
        getContentWindow: function() {
            var ifr = this.getEl().getElementsByTagName("iframe")[0];
            return ifr ? ifr.contentWindow : null;
        }
    }), MessageBox = (Env$1.desktop || (lastSize = {
        w: window.innerWidth,
        h: window.innerHeight
    }, Delay$1.setInterval(function() {
        var w = window.innerWidth, h = window.innerHeight;
        lastSize.w == w && lastSize.h == h || (lastSize = {
            w: w,
            h: h
        }, DomQuery(window).trigger("resize"));
    }, 100)), DomQuery(window).on("resize", function() {
        for (var layoutRect, rect = funcs.getWindowSize(), i = 0; i < windows.length; i++) layoutRect = windows[i].layoutRect(), 
        windows[i].moveTo(windows[i].settings.x || Math.max(0, rect.w / 2 - layoutRect.w / 2), windows[i].settings.y || Math.max(0, rect.h / 2 - layoutRect.h / 2));
    }), Window.extend({
        init: function(settings) {
            this._super({
                layout: "flex",
                containerCls: "panel",
                autoScroll: !0,
                buttons: {
                    type: "button",
                    text: "Ok",
                    action: "ok"
                },
                items: {
                    type: "label",
                    multiline: !0
                }
            });
        },
        Statics: {
            OK: 1,
            OK_CANCEL: 2,
            YES_NO: 3,
            YES_NO_CANCEL: 4,
            msgBox: function(settings) {
                var buttons, callback = settings.callback || function() {};
                function createButton(text, status, primary) {
                    return {
                        type: "button",
                        text: text,
                        subtype: primary ? "primary" : "",
                        onClick: function(e) {
                            e.control.parents()[1].close(), callback(status);
                        }
                    };
                }
                switch (settings.buttons) {
                  case MessageBox.OK_CANCEL:
                    buttons = [ createButton("Ok", !0, !0), createButton("Cancel", !1) ];
                    break;

                  case MessageBox.YES_NO:
                  case MessageBox.YES_NO_CANCEL:
                    buttons = [ createButton("Yes", 1, !0), createButton("No", 0) ], 
                    settings.buttons == MessageBox.YES_NO_CANCEL && buttons.push(createButton("Cancel", -1));
                    break;

                  default:
                    buttons = [ createButton("Ok", !0, !0) ];
                }
                return new Window({
                    x: settings.x,
                    y: settings.y,
                    minWidth: 300,
                    minHeight: 100,
                    layout: "flex",
                    buttons: buttons,
                    title: settings.title,
                    role: "alertdialog",
                    type: "form",
                    items: {
                        type: "label",
                        multiline: !0,
                        text: settings.text
                    },
                    onPostRender: function() {
                        this.aria("describedby", this.items()[0]._id);
                    },
                    onClose: settings.onClose,
                    onCancel: function() {
                        callback(!1);
                    }
                }).renderTo(document.body);
            },
            alert: function(settings, callback) {
                return (settings = "string" == typeof settings ? {
                    text: settings
                } : settings).callback = callback, MessageBox.msgBox(settings);
            },
            confirm: function(settings, callback) {
                return (settings = "string" == typeof settings ? {
                    text: settings
                } : settings).callback = callback, settings.buttons = MessageBox.OK_CANCEL, 
                MessageBox.msgBox(settings);
            }
        }
    })), Progress = Widget.extend({
        Defaults: {
            value: 0
        },
        init: function(settings) {
            this._super(settings), this.classes.add("progress"), this.settings.filter || (this.settings.filter = function(value) {
                return Math.round(value);
            });
        },
        renderHtml: function() {
            var id = this._id, prefix = this.classPrefix;
            return '<div id="' + id + '" class="' + this.classes + '"><div class="' + prefix + 'bar-container"><div class="' + prefix + 'bar"></div></div><div class="' + prefix + 'text">0%</div></div>';
        },
        postRender: function() {
            return this._super(), this.value(this.settings.value), this;
        },
        bindStates: function() {
            var self = this;
            function setValue(value) {
                value = self.settings.filter(value), self.getEl().lastChild.innerHTML = value + "%", 
                self.getEl().firstChild.firstChild.style.width = value + "%";
            }
            return self.state.on("change:value", function(e) {
                setValue(e.value);
            }), setValue(self.state.get("value")), self._super();
        }
    }), Notification = Control$1.extend({
        Mixins: [ Movable ],
        Defaults: {
            classes: "widget notification"
        },
        init: function(settings) {
            var self = this;
            self._super(settings), self.maxWidth = settings.maxWidth, settings.text && self.text(settings.text), 
            settings.icon && (self.icon = settings.icon), settings.color && (self.color = settings.color), 
            settings.type && self.classes.add("notification-" + settings.type), 
            settings.timeout && (settings.timeout < 0 || 0 < settings.timeout) && !settings.closeButton ? self.closeButton = !1 : (self.classes.add("has-close"), 
            self.closeButton = !0), settings.progressBar && (self.progressBar = new Progress()), 
            self.on("click", function(e) {
                -1 != e.target.className.indexOf(self.classPrefix + "close") && self.close();
            });
        },
        renderHtml: function() {
            var notificationStyle, prefix = this.classPrefix, icon = "", closeButton = "", progressBar = "";
            return this.icon && (icon = '<span class="' + prefix + "ico " + prefix + "i-" + this.icon + '"></span>'), 
            notificationStyle = ' style="max-width: ' + this.maxWidth + "px;" + (this.color ? "background-color: " + this.color + ';"' : '"'), 
            this.closeButton && (closeButton = '<button type="button" class="' + prefix + 'close" aria-hidden="true">\xd7</button>'), 
            this.progressBar && (progressBar = this.progressBar.renderHtml()), '<div id="' + this._id + '" class="' + this.classes + '"' + notificationStyle + ' role="presentation">' + icon + '<div class="' + prefix + 'notification-inner">' + this.state.get("text") + "</div>" + progressBar + closeButton + '<div style="clip: rect(1px, 1px, 1px, 1px);height: 1px;overflow: hidden;position: absolute;width: 1px;" aria-live="assertive" aria-relevant="additions" aria-atomic="true"></div></div>';
        },
        postRender: function() {
            var self = this;
            return Delay$1.setTimeout(function() {
                self.$el.addClass(self.classPrefix + "in"), updateLiveRegion(self, self.state.get("text"));
            }, 100), self._super();
        },
        bindStates: function() {
            var self = this;
            return self.state.on("change:text", function(e) {
                self.getEl().firstChild.innerHTML = e.value, updateLiveRegion(self, e.value);
            }), self.progressBar && (self.progressBar.bindStates(), self.progressBar.state.on("change:value", function(e) {
                updateLiveRegion(self, self.state.get("text"));
            })), self._super();
        },
        close: function() {
            return this.dispatch("close").isDefaultPrevented() || this.remove(), 
            this;
        },
        repaint: function() {
            var style = this.getEl().style, rect = this._layoutRect;
            style.left = rect.x + "px", style.top = rect.y + "px", style.zIndex = 65534;
        }
    }), Radio = Checkbox.extend({
        Defaults: {
            classes: "radio",
            role: "radio"
        }
    }), Repeatable = Form.extend({
        init: function(settings) {
            var items = (settings = settings || {}).items;
            settings.items = [ {
                type: "repeatableitem",
                items: items
            } ], Tools$6.each(settings.values, function(values, index) {
                settings.items[index] = {
                    type: "repeatableitem",
                    items: items,
                    values: values
                };
            }), this._super(settings), this.classes.add("repeatable");
        },
        addItem: function(settings) {
            var item = this._items[0];
            return this.append(Tools$6.extend(item.settings, settings || {})), this;
        },
        value: function(value) {
            var values, self = this;
            return arguments.length ? (this.state.get("rendered") && (values = [], 
            this.items().each(function(ctrl, i) {
                ctrl = ctrl.state.get("values");
                if (!ctrl) return !0;
                ctrl === value[0] && (ctrl = value[0], value = []), values.push(ctrl);
            }), value.length && (values = values.concat(value)), this.items().each(function(ctrl) {
                ctrl.value(values.shift());
            }), Tools$6.each(values, function(val) {
                self.addItem({
                    values: val
                });
            })), this) : (values = [], this.state.get("rendered") && this.items().each(function(ctrl) {
                (value = ctrl.value()) && (values = values.concat(value));
            }), values);
        }
    }), RepeatableItem = Form.extend({
        Defaults: {
            padding: 0,
            direction: "row",
            layout: "grid",
            spacing: 0
        },
        init: function(settings) {
            this._super(settings), this.classes.add("repeatable-item");
        },
        value: function(value) {
            var ctrl;
            return void 0 !== value ? (this.state.get("rendered") && (Tools$6.isArray(value) && (value = value.shift()), 
            this.state.set("values", value), this.items()[0].value(value)), this) : (this.state.get("rendered") && (value = (ctrl = "formitem" === (ctrl = this.items()[0]).type ? ctrl.items()[1] : ctrl).value()) && this.state.set("value", value), 
            this.state.get("value"));
        },
        postRender: function() {
            var self = this, settings = self.settings, index = (this._super(), this.value(settings.values), 
            this.parent().items().indexOf(this)), settings = Factory.create({
                type: "button",
                text: "",
                icon: "plus",
                maxWidth: 34,
                subtype: "repeatable-btn",
                onclick: function() {
                    0 === index ? self.parent().addItem({
                        values: ""
                    }) : self.remove().reflow();
                }
            });
            return this.append(settings).reflow(), DomQuery('<span class="wfe-ico wfe-i-trash" />').appendTo(settings.getEl()), 
            this.reflow(), this;
        }
    }), ResizeHandle = Widget.extend({
        renderHtml: function() {
            var prefix = this.classPrefix;
            return this.classes.add("resizehandle"), "both" == this.settings.direction && this.classes.add("resizehandle-both"), 
            this.canFocus = !1, '<div id="' + this._id + '" class="' + this.classes + '"><span class="' + prefix + "ico " + prefix + 'i-resize"></span></div>';
        },
        postRender: function() {
            var self = this;
            self._super(), self.resizeDragHelper = new DragHelper(this._id, {
                start: function() {
                    self.dispatch("ResizeStart");
                },
                drag: function(e) {
                    "both" != self.settings.direction && (e.deltaX = 0), self.dispatch("Resize", e);
                },
                stop: function() {
                    self.dispatch("ResizeEnd");
                }
            });
        },
        remove: function() {
            return this.resizeDragHelper && this.resizeDragHelper.destroy(), this._super();
        }
    });
    function createOptions(options) {
        var strOptions = "";
        if (options) for (var i = 0; i < options.length; i++) strOptions += '<option value="' + options[i] + '">' + options[i] + "</option>";
        return strOptions;
    }
    var SelectBox = Widget.extend({
        Defaults: {
            classes: "selectbox",
            role: "selectbox",
            options: []
        },
        init: function(settings) {
            var self = this;
            self._super(settings), self.settings.size && (self.size = self.settings.size), 
            self.settings.options && (self._options = self.settings.options), self.on("keydown", function(e) {
                var rootControl;
                13 == e.keyCode && (e.preventDefault(), self.parents().reverse().each(function(ctrl) {
                    if (ctrl.toJSON) return rootControl = ctrl, !1;
                }), self.dispatch("submit", {
                    data: rootControl.toJSON()
                }));
            });
        },
        options: function(state) {
            return arguments.length ? (this.state.set("options", state), this) : this.state.get("options");
        },
        renderHtml: function() {
            var size = "", options = createOptions(this._options);
            return this.size && (size = ' size = "' + this.size + '"'), '<select id="' + this._id + '" class="' + this.classes + '"' + size + ">" + options + "</select>";
        },
        bindStates: function() {
            var self = this;
            return self.state.on("change:options", function(e) {
                self.getEl().innerHTML = createOptions(e.value);
            }), self._super();
        }
    });
    function SideBar() {
        return {
            add: function(editor, name, settings) {
                var sidebars = editor.sidebars || [];
                sidebars.push({
                    name: name,
                    settings: settings
                }), editor.sidebars = sidebars;
            }
        };
    }
    var SizeInput = Container.extend({
        Defaults: {
            role: "group",
            layout: "flow"
        },
        updateSize: function(e, name, fromInput) {
            var other, tmp, temp, value = e.value();
            if (-1 === value.indexOf("%")) {
                this.active(!1);
                var values = this.value(), e = this.items().eq(3).checked();
                for (key in values) key === name ? (tmp = values[key], values[key] = value) : (other = this.items().filter("#" + this.state.get("name") + key)[0].value(), 
                values[key] = other);
                if (this.value(values), fromInput) {
                    if (tmp && value && other) {
                        if (-1 !== value.indexOf("%") || -1 !== other.indexOf("%")) return;
                        e && (temp = (value / tmp * other).toFixed(0));
                    }
                    for (var key in values) key === name ? values[key] = value : (values[key] = temp || other, 
                    temp && this.items().filter("#" + this.state.get("name") + key)[0].value(temp));
                    this.active(!0), this.value(values);
                }
            }
        },
        init: function(settings) {
            var self = this, name = (settings = settings || {}).name || "";
            settings.items = [ {
                name: name + "width",
                type: "textbox",
                size: 3,
                textAlign: "center",
                onchange: function(e) {
                    self.updateSize(this, "width", !!e.target.nodeType);
                }
            }, {
                type: "widget",
                classes: "txt ico i-close",
                text: ""
            }, {
                name: name + "height",
                type: "textbox",
                size: 3,
                textAlign: "center",
                onchange: function(e) {
                    self.updateSize(this, "height", !!e.target.nodeType);
                }
            }, {
                type: "checkbox",
                checked: !0,
                text: "Proportional"
            } ], settings.layout = "grid", delete settings.name, self._super(settings), 
            self.classes.add("dimension-container"), this.state.set("name", name), 
            this.value({
                width: "",
                height: ""
            });
        },
        value: function(value) {
            return arguments.length ? (this.state.set("value", value), this) : this.state.get("value");
        },
        active: function(state) {
            return arguments.length ? (this.classes.toggle("active", state), this.items().each(function(ctrl) {
                ctrl.active(state);
            }), this._super(state), this) : this._super();
        },
        postRender: function() {
            var self = this, name = this.state.get("name");
            this.getRoot().on("postRender", function(e) {
                var values = {
                    width: self.items().filter("#" + name + "width").value(),
                    height: self.items().filter("#" + name + "height").value()
                };
                (values.width || values.height) && self.active(!0), self.value(values);
            }), this._super();
        }
    });
    function constrain(value, minVal, maxVal) {
        return value = maxVal < (value = value < minVal ? minVal : value) ? maxVal : value;
    }
    function setAriaProp(el, name, value) {
        el.setAttribute("aria-" + name, value);
    }
    function updateSliderHandle(ctrl, value) {
        var sizeName, stylePosName, shortSizeName = "v" == ctrl.settings.orientation ? (stylePosName = "top", 
        sizeName = "height", "h") : (stylePosName = "left", sizeName = "width", 
        "w"), handleEl = ctrl.getEl("handle"), shortSizeName = ((ctrl.layoutRect()[shortSizeName] || 100) - funcs.getSize(handleEl)[sizeName]) * ((value - ctrl._minValue) / (ctrl._maxValue - ctrl._minValue)) + "px";
        handleEl.style[stylePosName] = shortSizeName, handleEl.style.height = ctrl.layoutRect().h + "px", 
        setAriaProp(handleEl, "valuenow", value), setAriaProp(handleEl, "valuetext", "" + ctrl.settings.previewFilter(value)), 
        setAriaProp(handleEl, "valuemin", ctrl._minValue), setAriaProp(handleEl, "valuemax", ctrl._maxValue);
    }
    var Slider = Widget.extend({
        init: function(settings) {
            settings.previewFilter || (settings.previewFilter = function(value) {
                return Math.round(100 * value) / 100;
            }), this._super(settings), this.classes.add("slider"), "v" == settings.orientation && this.classes.add("vertical"), 
            this._minValue = settings.minValue || 0, this._maxValue = settings.maxValue || 100, 
            this._initValue = this.state.get("value");
        },
        renderHtml: function() {
            var id = this._id, prefix = this.classPrefix;
            return '<div id="' + id + '" class="' + this.classes + '"><div id="' + id + '-handle" class="' + prefix + 'slider-handle" role="slider" tabindex="-1"></div></div>';
        },
        reset: function() {
            this.value(this._initValue).repaint();
        },
        postRender: function() {
            var minValue, maxValue, screenCordName, stylePosName, sizeName, shortSizeName, self = this;
            minValue = self._minValue, maxValue = self._maxValue, shortSizeName = "v" == self.settings.orientation ? (screenCordName = "screenY", 
            stylePosName = "top", sizeName = "height", "h") : (screenCordName = "screenX", 
            stylePosName = "left", sizeName = "width", "w"), self._super(), function(minValue, maxValue) {
                function alter(delta) {
                    var value = self.value();
                    value = constrain(function(min, max, val) {
                        return val * (max - min) - min;
                    }(minValue, maxValue, (value + minValue) / (maxValue - minValue) + .05 * delta), minValue, maxValue), 
                    self.value(value), self.dispatch("dragstart", {
                        value: value
                    }), self.dispatch("drag", {
                        value: value
                    }), self.dispatch("dragend", {
                        value: value
                    });
                }
                self.on("keydown", function(e) {
                    switch (e.keyCode) {
                      case 37:
                      case 38:
                        alter(-1);
                        break;

                      case 39:
                      case 40:
                        alter(1);
                    }
                });
            }(minValue, maxValue, self.getEl("handle")), function(minValue, maxValue, handleEl) {
                var startPos, startHandlePos, maxHandlePos, handlePos, value;
                self._dragHelper = new DragHelper(self._id, {
                    handle: self._id + "-handle",
                    start: function(e) {
                        startPos = e[screenCordName], startHandlePos = parseInt(self.getEl("handle").style[stylePosName], 10), 
                        maxHandlePos = (self.layoutRect()[shortSizeName] || 100) - funcs.getSize(handleEl)[sizeName], 
                        self.dispatch("dragstart", {
                            value: value
                        });
                    },
                    drag: function(e) {
                        e = e[screenCordName] - startPos;
                        handlePos = constrain(startHandlePos + e, 0, maxHandlePos), 
                        handleEl.style[stylePosName] = handlePos + "px", value = minValue + handlePos / maxHandlePos * (maxValue - minValue), 
                        self.value(value), self.tooltip().text("" + self.settings.previewFilter(value)).show().moveRel(handleEl, "bc tc"), 
                        self.dispatch("drag", {
                            value: value
                        });
                    },
                    stop: function() {
                        self.tooltip().hide(), self.dispatch("dragend", {
                            value: value
                        });
                    }
                });
            }(minValue, maxValue, self.getEl("handle"));
        },
        repaint: function() {
            this._super(), updateSliderHandle(this, this.value());
        },
        bindStates: function() {
            var self = this;
            return self.state.on("change:value", function(e) {
                updateSliderHandle(self, e.value);
            }), self._super();
        }
    }), SortableHandle = Control$1.extend({
        renderHtml: function() {
            var prefix = this.classPrefix;
            return this.classes.add("sortablehandle"), this.canFocus = !1, '<div id="' + this._id + '" class="' + this.classes + '"><span class="' + prefix + "ico " + prefix + 'i-drag"></span></div>';
        }
    }), Spacer = Widget.extend({
        renderHtml: function() {
            return this.classes.add("spacer"), this.canFocus = !1, '<div id="' + this._id + '" class="' + this.classes + '"></div>';
        }
    }), $$3 = DomQuery, SplitButton = MenuButton.extend({
        Defaults: {
            classes: "widget btn splitbtn",
            role: "button"
        },
        activeMenu: function(state) {
            $$3(this.getEl().lastChild).toggleClass(this.classPrefix + "active", state);
        },
        renderHtml: function() {
            var id = this._id, prefix = this.classPrefix, icon = this.state.get("icon"), text = this.state.get("text"), textHtml = "", image = this.settings.image;
            return image = image ? (icon = "none", " style=\"background-image: url('" + (image = "string" != typeof image ? window.getSelection ? image[0] : image[1] : image) + "')\"") : "", 
            icon = this.settings.icon ? prefix + "ico " + prefix + "i-" + icon : "", 
            text && (this.classes.add("btn-has-text"), textHtml = '<span class="' + prefix + 'txt">' + this.encode(text) + "</span>"), 
            '<div id="' + id + '" class="' + this.classes + '" role="button" tabindex="-1"><button type="button" hidefocus="1" tabindex="-1">' + (icon ? '<span class="' + icon + '"' + image + "></span>" : "") + textHtml + '</button><button type="button" class="' + prefix + 'open" hidefocus="1" tabindex="-1">' + (this._menuBtnText ? (icon ? "\xa0" : "") + this._menuBtnText : "") + '<svg width="16" height="16" viewBox="0 0 512 512" version="1.1" xmlns="http://www.w3.org/2000/svg"><path d="M256,336L160,176L352,176L256,336Z" /></svg></button></div>';
        },
        postRender: function() {
            var self = this, onClickHandler = self.settings.onclick;
            return self.on("click", function(e) {
                var node = e.target;
                if (e.control == this) for (;node; ) {
                    if (e.aria && "down" != e.aria.key || "BUTTON" == node.nodeName && -1 == node.className.indexOf("open")) return e.stopImmediatePropagation(), 
                    self.menu && self.menu.hide(), void (onClickHandler && onClickHandler.call(this, e));
                    node = node.parentNode;
                }
            }), delete self.settings.onclick, self._super();
        }
    }), StackLayout = FlowLayout.extend({
        Defaults: {
            containerClass: "stack-layout",
            controlClass: "stack-layout-item"
        },
        isNative: function() {
            return !0;
        }
    }), $$2 = DomQuery, TabPanel = Panel.extend({
        Defaults: {
            layout: "flex",
            defaults: {
                type: "panel"
            }
        },
        activateTab: function(idx) {
            var activeTabElm;
            this.activeTabId && (activeTabElm = this.getEl(this.activeTabId), $$2(activeTabElm).removeClass(this.classPrefix + "active"), 
            activeTabElm.setAttribute("aria-selected", "false")), this.activeTabId = "t" + idx, 
            (activeTabElm = this.getEl("t" + idx)).setAttribute("aria-selected", "true"), 
            $$2(activeTabElm).addClass(this.classPrefix + "active"), this.items()[idx].show().dispatch("showtab"), 
            this.items().each(function(item, i) {
                idx != i && item.hide();
            });
        },
        renderHtml: function() {
            var self = this, layout = self._layout, tabsHtml = "", prefix = self.classPrefix;
            return self.preRender(), layout.preRender(self), self.items().each(function(ctrl, i) {
                i = self._id + "-t" + i;
                ctrl.aria("role", "tabpanel"), ctrl.aria("labelledby", i), tabsHtml += '<div id="' + i + '" class="' + prefix + 'tab" unselectable="on" role="tab" aria-controls="' + ctrl._id + '" aria-selected="false" tabIndex="-1">' + self.encode(ctrl.settings.title) + "</div>";
            }), '<div id="' + self._id + '" class="' + self.classes + '" hidefocus="1" tabindex="-1"><div id="' + self._id + '-head" class="' + prefix + 'tabs" role="tablist">' + tabsHtml + '</div><div id="' + self._id + '-body" class="' + self.bodyClasses + '">' + layout.renderHtml(self) + "</div></div>";
        },
        postRender: function() {
            var self = this;
            self._super(), self.settings.activeTab = self.settings.activeTab || 0, 
            self.activateTab(self.settings.activeTab), this.on("click", function(e) {
                var targetParent = e.target.parentNode;
                if (targetParent && targetParent.id == self._id + "-head") for (var i = targetParent.childNodes.length; i--; ) targetParent.childNodes[i] == e.target && self.activateTab(i);
            });
        }
    }), TextBox = Widget.extend({
        init: function(settings) {
            var self = this;
            self._super(settings), self.classes.add("textbox"), settings.multiline ? self.classes.add("multiline") : (self.on("keydown", function(e) {
                var rootControl;
                13 == e.keyCode && (e.preventDefault(), self.parents().reverse().each(function(ctrl) {
                    if (ctrl.toJSON) return rootControl = ctrl, !1;
                }), self.dispatch("submit", {
                    data: rootControl.toJSON()
                }));
            }), self.on("keyup", function(e) {
                self.state.set("value", e.target.value);
            }));
        },
        renderHtml: function() {
            var elm, settings = this.settings, attrs = {
                id: this._id,
                hidefocus: "1"
            };
            return Tools$6.each([ "rows", "spellcheck", "maxLength", "size", "readonly", "min", "max", "step", "list", "pattern", "placeholder", "required", "multiple" ], function(name) {
                attrs[name] = settings[name];
            }), this.disabled() && (attrs.disabled = "disabled"), settings.multiline || (attrs.type = settings.subtype || "text"), 
            (elm = funcs.create(settings.multiline ? "textarea" : "input", attrs)).value = this.state.get("value"), 
            elm.className = this.classes, elm.outerHTML;
        },
        value: function(value) {
            return arguments.length ? (this.state.set("value", value), this) : (this.state.get("rendered") && this.state.set("value", this.getEl().value), 
            this.state.get("value"));
        },
        postRender: function() {
            var self = this;
            self.settings.autofocus && (self.getEl().focus({
                preventScroll: !0
            }), self.settings.autofocus = !1), self.getEl().value = self.state.get("value"), 
            self._super(), self.$el.on("change", function(e) {
                self.state.set("value", e.target.value), self.dispatch("change", e);
            });
        },
        bindStates: function() {
            var self = this;
            return self.state.on("change:value", function(e) {
                self.getEl().value != e.value && (self.getEl().value = e.value);
            }), self.state.on("change:disabled", function(e) {
                self.getEl().disabled = e.value;
            }), self._super();
        },
        remove: function() {
            this.$el.off(), this._super();
        }
    });
    var StringHelper = {
        sanitize: function(str) {
            for (var r = "", i = 0, ln = (str = str.replace(/[\+\\\?%&<>\'=\[\]\{\},;\^\(\)\xa3\u20ac$]/g, "")).length; i < ln; i++) {
                var ch = str[i];
                /[^\w\.\/\#@\-~\s ]/.test(ch) && function(str) {
                    for (var c = str.toString(16).toUpperCase(); c.length < 4; ) c = "0" + c;
                    return "\\u" + c;
                }(ch.charCodeAt(0)) < "\\u007F" || (r += ch);
            }
            return str = (str = (str = (str = r).replace(/(\.){2,}/g, "")).replace(/^[\.\/]/, "")).replace(/[\.\/]$/, "");
        }
    }, count$1 = 0, Uuid$1_uuid = function(prefix) {
        return prefix + count$1++ + ("s" + new Date().getTime().toString(36) + rnd() + rnd() + rnd());
        function rnd() {
            return Math.round(4294967295 * Math.random()).toString(36);
        }
    };
    var FetchData = {
        postJson: async function(url = "", params = {}) {
            if (params = {
                json: {
                    id: Uuid$1_uuid("wf_"),
                    method: "",
                    params: {},
                    ...params
                }
            }, (url = await fetch(url, {
                method: "POST",
                headers: {
                    "X-Requested-With": "XMLHttpRequest",
                    "Content-Type": "application/json;charset=utf-8"
                },
                body: JSON.stringify(params)
            })).ok) return url.json();
            throw new Error("An error has occurred: " + url.status);
        },
        getText: async function(url) {
            if ((url = await fetch(url, {
                headers: {
                    "X-Requested-With": "XMLHttpRequest"
                }
            })).ok) return url.text();
            throw new Error("An error has occurred: " + url.status);
        }
    };
    function Beagle(settings) {
        let queryString = "";
        var pre;
        function normalize(data) {
            return settings.normalize(data);
        }
        function filter(items, query) {
            return settings.filter(items, query);
        }
        function getData(args) {
            return new Promise(function(resolve, reject) {
                if ("" === (args = Tools$6.extend({
                    url: "",
                    data: {}
                }, args)).url) return !1;
                FetchData.postJson(args.url, args.data).then(function(o) {
                    (o = void 0 === o ? {
                        error: "The server returned invalid data."
                    } : o).error && reject(o.error), resolve(o.result);
                }).catch(function(x) {
                    reject(x);
                });
            });
        }
        function getCacheKey(key) {
            return "__" + document.location.pathname + "_" + key;
        }
        function setCache(key, data) {
            key = getCacheKey(key);
            "string" != typeof data && (data = JSON.stringify(data)), sessionStorage.setItem(key + "_data", data);
        }
        function getCache(key) {
            key = getCacheKey(key);
            let data = [];
            data = sessionStorage.getItem(key + "_data") || data;
            try {
                data = JSON.parse(data);
            } catch (ex) {}
            return data;
        }
        function addMatches(current, candidate) {
            return current.length && Tools$6.is(settings.addMatches, "function") ? settings.addMatches(current, candidate) : current.concat(candidate);
        }
        function queryRemote(query, matches) {
            return new Promise(function(resolve, reject) {
                !settings.remote || !query || !function(matches) {
                    return Tools$6.is(settings.limit, "function") ? settings.limit(matches) : matches.length < settings.limit;
                }(matches) || 0 == queryString.indexOf(query) ? resolve(matches) : (queryString = query, 
                Delay$1.debounce(function(query, matches, resolve) {
                    !function(query, matches) {
                        return new Promise(function(resolve, reject) {
                            var args = Tools$6.extend({}, settings.remote);
                            args.url = args.url.replace("%QUERY%", query), getData(args).then(function(r) {
                                query = query.replace(/^\?[^:]+:/, ""), Tools$6.isArray(r) || (r = [ r ]), 
                                Tools$6.each(r, function(obj) {
                                    obj = normalize(obj);
                                    obj = filter(obj, query), matches = addMatches(matches, obj), 
                                    obj.length && (0 === queryString.indexOf(query) && (obj = addMatches(getCache(settings.thumbprint), obj)), 
                                    !1 !== settings.cache) && setCache(settings.thumbprint, obj);
                                }), resolve(matches);
                            }).then(reject);
                        });
                    }(query, matches).then(function(found) {
                        matches = addMatches(matches, found), resolve(matches);
                    }).catch(reject);
                }, 300)(query, matches, resolve));
            });
        }
        return (settings = Tools$6.extend({
            thumbprint: "beagle-cache",
            cache: !0,
            ttl: 864e5,
            limit: 10,
            filter: function(array, query) {
                var matcher;
                return query ? (matcher = new RegExp(query.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, "\\$&"), "i"), 
                Tools$6.grep(array, function(value) {
                    return matcher.test(value.value || value);
                })) : array;
            },
            normalize: function(data) {
                return data;
            }
        }, settings || {})).prefetch && "string" === settings.prefetch && (settings.prefetch = {
            url: settings.prefetch
        }), settings.prefetch && Tools$6.is(settings.prefetch, "object") && (pre = settings.prefetch).url && getData(pre).then(function(data) {
            data = normalize(data), data = addMatches(getCache(settings.thumbprint), data), 
            setCache(settings.thumbprint, data);
        }), settings.remote && "string" === settings.remote && (settings.remote = {
            url: settings.remote
        }), {
            query: function(query) {
                return new Promise(function(resolve, reject) {
                    Delay$1.throttle(function() {
                        !function(query) {
                            var cache, matches = [];
                            return settings.local && settings.local.length && (matches = addMatches(matches, filter(settings.local, query))), 
                            !1 !== settings.cache && (cache = getCache(settings.thumbprint)) && cache.length && (matches = addMatches(matches, filter(cache, query))), 
                            new Promise(function(resolve) {
                                resolve(matches);
                            });
                        }(query).then(function(matches) {
                            return queryRemote(query, matches);
                        }).then(resolve).catch(reject);
                    }, 100)();
                });
            }
        };
    }
    var $$1 = DomQuery;
    function escapeRegExChars(str) {
        return str.replace(/[\-\[\]\/\{\}\(\)\*\+\?\.\\\^\$\|]/g, "\\$&");
    }
    var specialKeyCodeMap$1 = {
        9: "tab",
        17: "ctrl",
        18: "alt",
        27: "esc",
        37: "left",
        39: "right",
        13: "enter",
        38: "up",
        40: "down",
        91: "cmd"
    };
    function cleanQuery(query) {
        return query = (query = (query = (query = query.replace(/^\?[^:]+:/, "")).replace(/[\w]+:[^\s]+/, "")).replace(/\s+/g, " ")).trim();
    }
    var $ = DomQuery, specialKeyCodeMap = {
        Tab: "tab",
        Control: "ctrl",
        Alt: "alt",
        Esc: "esc",
        ArrowLeft: "left",
        ArrowRight: "right",
        Enter: "enter",
        ArrowUp: "up",
        ArrowDown: "down",
        Meta: "cmd"
    };
    function getApi() {
        return {
            Selector: Selector,
            Collection: Collection$1,
            Rect: Rect$1,
            Control: Control$1,
            Factory: Factory,
            KeyboardNavigation: KeyboardNavigation,
            Container: Container,
            DragHelper: DragHelper,
            Scrollable: Scrollable,
            Panel: Panel,
            Movable: Movable,
            Resizable: Resizable,
            RepeatableItem: RepeatableItem,
            Repeatable: Repeatable,
            FloatPanel: FloatPanel,
            Window: Window,
            MessageBox: MessageBox,
            Tooltip: Tooltip,
            Widget: Widget,
            Progress: Progress,
            Notification: Notification,
            Layout: Layout,
            AbsoluteLayout: AbsoluteLayout,
            Button: Button,
            ButtonGroup: ButtonGroup,
            Checkbox: Checkbox,
            ComboBox: ComboBox,
            DataList: DataList,
            ColorBox: ColorBox,
            PanelButton: PanelButton,
            ColorButton: ColorButton,
            ColorPicker: ColorPicker,
            Path: Path,
            ElementPath: ElementPath,
            FormItem: FormItem,
            Form: Form,
            FieldSet: FieldSet,
            FilePicker: FilePicker,
            FitLayout: FitLayout,
            FlexLayout: FlexLayout,
            FlowLayout: FlowLayout,
            FormatControls: FormatControls,
            GridLayout: GridLayout,
            Iframe: Iframe$1,
            InfoBox: InfoBox,
            Label: Label,
            Toolbar: Toolbar$1,
            MenuBar: MenuBar,
            MenuButton: MenuButton,
            MenuItem: MenuItem,
            Tree: Tree,
            TreeItem: TreeItem,
            MediaItem: MediaItem,
            Throbber: Throbber,
            Menu: Menu,
            ListBox: ListBox,
            Radio: Radio,
            ResizeHandle: ResizeHandle,
            SortableHandle: SortableHandle,
            SelectBox: SelectBox,
            SideBar: SideBar,
            Slider: Slider,
            Spacer: Spacer,
            SplitButton: SplitButton,
            StackLayout: StackLayout,
            TabPanel: TabPanel,
            TextBox: TextBox,
            DropZone: DropZone,
            BrowseButton: BrowseButton,
            CustomValue: CustomValue,
            FilterMenu: FilterMenu,
            SizeInput: SizeInput,
            UrlInput: UrlInput
        };
    }
    var UrlInput = Widget.extend({
        Mixins: [ {
            autocomplete: function(settings) {
                var self = this, elm = this.getEl("inp"), tmpValue = "", menuItems = (settings = Tools$6.extend({
                    url: "",
                    data: {
                        method: "autocomplete"
                    },
                    delay: 500,
                    minLength: 3,
                    maxLength: 50,
                    local: [],
                    adapters: []
                }, settings), {}), items = {}, oninput = ($$1(elm).attr({
                    autocomplete: "off",
                    spellcheck: "false",
                    placeholder: "Type to find content..."
                }), this.classes.add("autocomplete-input"), $$1(elm).css("background-image", Env$1.transparentSrc), 
                this.on("reset", function() {
                    close(), menuItems = {};
                }), Delay$1.debounce(function(e) {
                    var val = elm.value;
                    9 != e.keyCode && (e.keyCode && specialKeyCodeMap$1[e.keyCode] ? close() : Delay$1.defer(function() {
                        "" == val ? close() : (e.stopImmediatePropagation(), (val = function(str) {
                            if (("?" !== str.charAt(0) || /\?[^:]+:.+/.test(str)) && ('"' != str.charAt(0) || '"' == str.charAt(str.length - 1))) {
                                var value = cleanQuery(str), length = value.length;
                                if (length >= settings.minLength && length < settings.maxLength) {
                                    if (/:\/\//.test(value) || /^(http|ftp|mailto)/.test(value) || /^index\.php/.test(value) || /^www\./.test(value)) return !1;
                                    if ((value = StringHelper.sanitize(value)) !== tmpValue) return str;
                                }
                            }
                            return !1;
                        }(val)) && (tmpValue = val, /\s+$/.test(val) || function(query) {
                            let suggestions = [];
                            self.dispatch("search"), self.showStatus(!0);
                            var requests = [], value = query;
                            return settings.adapters.forEach(function(adapter) {
                                var deferred = new Promise(function(resolve) {
                                    if ("?" === query.charAt(0)) {
                                        if (query.indexOf("?" + adapter + ":") < 0) return !0;
                                    } else value = "?" + adapter + ":" + query;
                                    engine.query(value).then(function(data) {
                                        data && data.length && (suggestions = data), 
                                        function(query, result) {
                                            query = cleanQuery(query), self.showStatus(!1);
                                            var e = {
                                                query: query,
                                                result: result
                                            };
                                            self.dispatch("found", e), e.isDefaultPrevented() || function(query, suggestions) {
                                                function highlight(str) {
                                                    var re = new RegExp("(" + escapeRegExChars(query).replace(/\s/g, "|") + ")", "gi"), exact = query.match(/"([^"]+)"/i);
                                                    return exact && (exact = exact.pop(), 
                                                    re = new RegExp("(" + escapeRegExChars(exact) + ")", "gi")), 
                                                    str.replace(re, "<mark>$1</mark>");
                                                }
                                                Array.isArray(menuItems[query]) || (menuItems[query] = []);
                                                Tools$6.each(suggestions, function(item) {
                                                    items[item.type] = {}, item.data && item.data.length && (menutitle = Factory.create({
                                                        type: "menuitem",
                                                        classes: "autocomplete-title",
                                                        text: item.label
                                                    }).aria("role", "heading"), 
                                                    items[item.type][item.label] = menutitle, 
                                                    prefix = self.classPrefix, Tools$6.each(item.data, value => {
                                                        if (value.title) {
                                                            let html = `<div class="${prefix}menu-item-body">`, txt = (value.image && (html += `<div class="${prefix}avatar" title="${value.title}"><img src="${value.image}" /></div>`), 
                                                            html += `<div class="${prefix}width-expand">
                                        <div class="${prefix}menu-item-header">
                                            <h6 class="${prefix}menu-item-heading ${prefix}text" title="${value.title}">${highlight(value.title)}</h6>
                                        </div>`, "");
                                                            txt = Array.isArray(value.text) ? value.text.map(textItem => `<p>${textItem}</p>`).join("") : "object" == typeof value.text ? Object.entries(value.text).map(([ key, val ]) => `<p>${key}: ${val}</p>`).join("") : value.text, 
                                                            (txt = Tools$6.trim(txt)) && (html += `<div class="${prefix}text ${prefix}meta">${highlight(txt)}</div>`), 
                                                            html += "</div></div>", 
                                                            value.url && (html += `<div class="${prefix}text ${prefix}url">${highlight(value.url)}</div>`);
                                                            var data = {
                                                                url: value.url,
                                                                title: value.title,
                                                                ...value.data
                                                            }, data = Factory.create({
                                                                type: "menuitem",
                                                                html: html,
                                                                value: data
                                                            });
                                                            items[item.type][value.url] = data;
                                                        }
                                                    }));
                                                    var prefix, menutitle = Object.values(items[item.type]);
                                                    menuItems[query] = menuItems[query].concat(menutitle);
                                                }), self.showMenu(menuItems[query]), 
                                                self.focus();
                                            }(query, result);
                                        }(query, suggestions), resolve();
                                    }).catch(function(e) {
                                        resolve(), console.debug(e);
                                    });
                                });
                                requests.push(deferred);
                            }), Promise.all(requests);
                        }(val).then(function() {
                            tmpValue = "", items = {};
                        })));
                    }));
                }, settings.delay));
                $$1(elm).on("keyup paste cut", oninput);
                var engine = new Beagle({
                    cache: !1,
                    limit: function(matches) {
                        var count = 0;
                        return Tools$6.each(matches, function(o) {
                            count += o.data.length;
                        }), count < 5 * settings.adapters.length;
                    },
                    addMatches: function(current, candidate) {
                        var others = {};
                        return (current = Tools$6.grep(current, function(item) {
                            var type, matcher;
                            return !!item && (type = item.type, others[type] || (others[type] = []), 
                            candidate = Tools$6.grep(candidate, function(o) {
                                return o.type === type ? (others[type] = others[type].concat(o.data), 
                                !1) : o;
                            }), others[type].length && (matcher = Tools$6.map(item.data, function(k) {
                                return k.url;
                            })).length && Tools$6.each(others[type], function(k) {
                                -1 === Tools$6.inArray(matcher, k.url) && item.data.push(k);
                            }), item);
                        })).concat(candidate);
                    },
                    local: settings.local,
                    prefetch: {
                        url: settings.url,
                        data: settings.data
                    },
                    remote: {
                        url: settings.url + "&term=%QUERY%",
                        data: settings.data
                    },
                    thumbprint: "wf_search_cache",
                    normalize: function(o, query) {
                        return o;
                    },
                    filter: function(items, query) {
                        var adapter = "", tokens = ("?" === query.charAt(0) && (adapter = query.substring(1, query.indexOf(":"))), 
                        query = cleanQuery(query), []);
                        return items.length && Tools$6.each(items, function(item) {
                            var data = [];
                            if (adapter && item.type !== adapter) return !0;
                            item.data && item.data.length && ((data = Tools$6.grep(item.data, function(n) {
                                if (n.title && searchByQuery(query, n.title)) return n;
                                if (n.text && Tools$6.is(n.text, "string") && searchByQuery(query, n.text)) return n;
                                if (n.url) {
                                    var path = n.url.substring(0, n.url.indexOf("?") + 1);
                                    if (searchByQuery(query, path)) return n;
                                }
                                return !1;
                            })).sort(function(a, b) {
                                return a.title.indexOf(query) > b.title.indexOf(query);
                            }), data = Tools$6.extend({}, {
                                label: item.label || "",
                                data: data,
                                type: item.type
                            }), tokens.push(data));
                        }), tokens;
                        function searchByQuery(query, string) {
                            string = string.toLowerCase();
                            var matches, exact = query.match(/"([^"]+)"/i);
                            return exact ? (exact = exact.pop(), -1 !== string.indexOf(exact)) : (matches = 0, 
                            exact = query.split(" "), Tools$6.each(query.split(" "), function(keyword) {
                                keyword = keyword.toLowerCase(), -1 !== string.indexOf(keyword) && matches++;
                            }), matches === exact.length);
                        }
                    }
                });
                function close() {
                    self.dispatch("menuclose");
                }
            },
            init: function() {
                var self = this, settings = self.settings;
                settings.autocomplete && this.on("postrender", function() {
                    var config = Tools$6.is(settings.autocomplete, "boolean") ? {} : settings.autocomplete;
                    self.autocomplete(config);
                });
            }
        } ],
        getSize: function(elm) {
            var width, rect;
            return rect = elm.getBoundingClientRect ? (rect = elm.getBoundingClientRect(), 
            width = Math.max(rect.width || rect.right - rect.left, elm.offsetWidth), 
            Math.max(rect.height || rect.bottom - rect.bottom, elm.offsetHeight)) : (width = elm.offsetWidth, 
            elm.offsetHeight), {
                width: width,
                height: rect
            };
        },
        init: function(settings) {
            Tools$6.extend({
                spellcheck: !1,
                icon: "file",
                autocomplete: !1,
                uploader: !1,
                rpcURL: "",
                callback: function() {}
            }, settings), settings.autocomplete && (settings.autocomplete = Tools$6.extend({
                url: settings.rpcURL
            }, settings.autocomplete)), this._super(settings), this.classes.add("urlinput"), 
            this.subinput = !0, this.ariaTarget = "inp";
        },
        value: function(value) {
            return void 0 !== value ? (this.state.set("value", value), Tools$6.is(value, "array") && this.settings.multiple && this.disabled(1 < value.length), 
            this.state.get("rendered") && (this.getEl("inp").value = value), this) : (this.state.get("rendered") && !this.disabled() && this.state.set("value", this.getEl("inp").value), 
            this.state.get("value"));
        },
        repaint: function() {
            var self = this, elm = self.getEl(), rect = self.layoutRect(), x = 10, prefix = this.classPrefix;
            return $("." + prefix + "btn:not(." + prefix + "btn-inline)", elm).each(function(i, n) {
                x += parseInt(self.getSize(n).width, 10);
            }), rect = rect.w - x, $(elm.firstChild).css("width", rect), $("." + prefix + "btn-inline", elm).css("right", x), 
            self._super(), self;
        },
        showStatus: function(state) {
            state ? this.classes.add("loading") : this.classes.remove("loading");
        },
        postRender: function() {
            var self = this, el = this.getEl(), prefix = this.classPrefix, settings = self.settings;
            self.on("change", function() {
                self.classes.remove("active"), "" != self.getEl("inp").value && self.classes.add("active");
            }), $(self.getEl("clear")).on("click", function(e) {
                if (e.preventDefault, $(self.getEl()).hasClass(prefix + "loading")) return e.stopImmediatePropagation(), 
                !1;
                self.value(""), self.clearMenu(), self.dispatch("change"), self.disabled(!1), 
                self.dispatch("clear");
            }), $(self.getEl("filebrowser")).on("click", function(e) {
                self.dispatch("filepick"), e.preventDefault();
            }), $(self.getEl("linkbrowser")).on("click", function(e) {
                self.dispatch("linkpick"), e.preventDefault();
            }), !1 !== settings.uploader && (el = Tools$6.extend({
                drop_target: $(el).parents("." + prefix + "window"),
                browse_button: self.getEl("upload"),
                url: settings.rpcURL
            }, settings.uploader), self.Uploader = new tinymce.util.Uploader(el), 
            self.Uploader.on("dragover", function(e) {}), self.Uploader.on("drop", function(e) {
                self.getRoot().classes.remove("upload-drop");
            }), self.Uploader.on("dragoff", function(e) {
                self.getRoot().classes.remove("upload-drop");
            }), self.Uploader.on("Start", function() {
                self.showStatus(!0), self.disabled(!0);
            }), self.Uploader.on("Complete", function(res) {
                res.error ? MessageBox.alert(res.error) : Tools$6.is(self.settings.callback, "function") && self.settings.callback.call(self, res.properties), 
                self.dispatch("change"), self.showStatus(), self.disabled(!1);
            }), self.Uploader.init()), $(this.getEl("inp")).on("change", function(e) {
                !function(e) {
                    return specialKeyCodeMap[e.key];
                }(e) && self.dispatch("change");
            }), this._super(), window.setTimeout(function() {
                self.dispatch("change");
            }, 0);
        },
        showMenu: function(items) {
            var self = this;
            0 === items.length ? self.hideMenu() : (self.menu ? self.clearMenu() : (self.menu = Factory.create({
                type: "menu",
                items: [],
                classes: "autocomplete",
                autohide: !1,
                minHeight: 100
            }).parent(self).renderTo(), self.menu.keyboardNav || (self.menu.keyboardNav = new KeyboardNavigation({
                root: self.menu
            })), self.menu.on("cancel", function(e) {
                e.control.parent() === self.menu && (e.stopPropagation(), self.focus(), 
                self.hideMenu());
            }), self.menu.on("select", function(e) {
                self.focus(), self.settings.callback.apply(self, [ e.control.value() || "" ]), 
                self.dispatch("change");
            })), Tools$6.each(items, function(item) {
                self.menu.add(item);
            }), self.menu.renderNew(), self.hideMenu(), items = self.parent().layoutRect().w, 
            self.menu.layoutRect({
                w: items
            }), self.menu.show(), self.menu.getEl().style.width = items + "px", 
            self.menu.moveRel(self.getEl(), self.isRtl() ? [ "br-tr", "tr-br" ] : [ "bl-tl", "tl-bl" ]));
        },
        hideMenu: function() {
            this.menu && this.menu.hide();
        },
        clearMenu: function() {
            this.menu && (this.menu.items().remove(), this.menu.getEl("body").innerHTML = "");
        },
        renderHtml: function() {
            var id = this._id, settings = this.settings, prefix = this.classPrefix, value = this.state.get("value") || "", extraAttrs = "", inlineButtons = ("spellcheck" in settings && (extraAttrs += ' spellcheck="' + settings.spellcheck + '"'), 
            settings.maxLength && (extraAttrs += ' maxlength="' + settings.maxLength + '"'), 
            settings.size && (extraAttrs += ' size="' + settings.size + '"'), settings.subtype && (extraAttrs += ' type="' + settings.subtype + '"'), 
            this.disabled() && (extraAttrs += ' disabled="disabled"'), []), externalButtons = [], settings = (inlineButtons.push('<button type="button" id="' + id + '-clear" class="' + prefix + "btn " + prefix + "btn-inline " + prefix + 'btn-clear" tabIndex="-1" role="button"><span class="' + prefix + "ico " + prefix + 'i-close"></span></button>'), 
            settings.uploader && inlineButtons.push('<button type="button" id="' + id + '-upload" class="' + prefix + "btn " + prefix + "btn-inline " + prefix + 'btn-upload" tabIndex="-1" role="button">   <span class="' + prefix + "ico " + prefix + 'i-cloud-upload"></span></button>'), 
            settings.onlinkpick && (externalButtons.push('<button type="button" id="' + id + '-linkbrowser" class="' + prefix + "btn " + prefix + 'btn-linkbrowser" tabIndex="-1" role="button">   <span class="' + prefix + "ico " + prefix + 'i-file"></span></button>'), 
            this.classes.add("btn-group")), settings.onfilepick && (externalButtons.push('<button type="button" id="' + id + '-filebrowser" class="' + prefix + "btn " + prefix + 'btn-filebrowser" tabIndex="-1" role="button">   <span class="' + prefix + "ico " + prefix + 'i-image"></span></button>'), 
            this.classes.add("btn-group")), settings.placeholder || $(this.getEl()).attr("placeholder") || "");
            return '<div id="' + id + '" class="' + this.classes + '"><div class="' + prefix + 'textbox-container">' + inlineButtons.join("") + '<input type="text" id="' + id + '-inp" class="' + prefix + "textbox " + prefix + '" value="' + value + '" hidefocus="1"' + extraAttrs + ' placeholder="' + this.encode(settings) + '" /></div>' + externalButtons.join("") + "</div>";
        },
        focus: function() {
            this.settings.autofocus && this.getEl("inp").focus({
                preventScroll: !0
            });
        },
        bindStates: function() {
            function focusIdx(idx, menu) {
                menu && 0 < menu.items().length && (menu.show(), menu.items().each(function(item, i) {
                    return item.disabled() ? (idx++, !0) : i == idx ? (item.focus(), 
                    !1) : void 0;
                }));
            }
            var self = this;
            self.state.on("change:value", function(e) {
                self.getEl("inp").value = e.value;
            }), self.state.on("change:disabled", function(e) {
                self.getEl("inp").disabled = e.value, self.aria("disabled", e.value), 
                self.classes.toggle("disabled", e.value);
            });
            return self.on("keydown", function(e) {
                var keyCode = e.keyCode;
                keyCode === VK.HOME ? (self.getEl("inp").focus(), e.preventDefault()) : "INPUT" === e.target.nodeName && (keyCode === VK.DOWN ? (e.preventDefault(), 
                focusIdx(0, self.menu)) : keyCode === VK.UP && (e.preventDefault(), 
                focusIdx(-1, self.menu)), keyCode === VK.BACKSPACE) && "" == e.target.value && e.preventDefault();
            }), self._super();
        },
        remove: function() {
            $(this.getEl("inp")).off(), this.menu && this.menu.remove(), this._super();
        }
    }), gecko = function(target) {
        target.ui ? Tools$6.each(getApi(), function(ref, key) {
            target.ui[key] = ref;
        }) : target.ui = getApi();
    }, mac = function() {
        Tools$6.each(getApi(), function(ref, key) {
            Factory.add(key, ref);
        });
    };
    function getToolbarSize(editor) {
        return editor.getParam("toolbar_items_size");
    }
    function isSkinDisabled(editor) {
        return !1 === editor.settings.skin;
    }
    function getResize(editor) {
        return !1 === (editor = editor.getParam("resize", "vertical")) ? "none" : "both" === editor ? "both" : "vertical";
    }
    function focus(panel, type) {
        return function() {
            var item = panel.find(type)[0];
            item && item.focus(!0);
        };
    }
    var Init = {
        init: function(editor) {
            FormatControls.setup(editor);
        }
    }, EditorManager = tinymce.EditorManager, Tools$5 = tinymce.util.Tools, getMenubar = function(editor) {
        return editor.getParam("menubar");
    }, getIndexedToolbars = function(settings, defaultToolbar) {
        for (var toolbars = [], i = 1; i < 10; i++) {
            var toolbar = settings["toolbar" + i];
            if (!toolbar) break;
            toolbars.push(toolbar);
        }
        defaultToolbar = settings.toolbar ? [ settings.toolbar ] : [ defaultToolbar ];
        return 0 < toolbars.length ? toolbars : defaultToolbar;
    }, Events = {
        fireSkinLoaded: function(editor) {
            return editor.dispatch("SkinLoaded");
        },
        fireResizeEditor: function(editor) {
            return editor.dispatch("ResizeEditor");
        },
        fireBeforeRenderUI: function(editor) {
            return editor.dispatch("BeforeRenderUI");
        }
    }, A11y_addKeys = function(editor, panel) {
        editor.shortcuts.add("Alt+F9", "", focus(panel, "menubar")), editor.shortcuts.add("Alt+F10,F10", "", focus(panel, "toolbar")), 
        editor.shortcuts.add("Alt+F11", "", focus(panel, "elementpath")), panel.on("cancel", function() {
            editor.focus();
        });
    }, count = 0, Uuid_uuid = function(prefix) {
        return prefix + count++ + ("s" + Date.now().toString(36) + rnd() + rnd() + rnd());
        function rnd() {
            return Math.round(4294967295 * Math.random()).toString(36);
        }
    }, DOMUtils$5 = tinymce.dom.DOMUtils, buttons = {}, sidebars = [], contextToolbars = [], contextMenu = {}, menuItems = {};
    function createToolbar(editor, items, size) {
        var buttonGroup, buttons, toolbarItems = [];
        if (items) return buttons = Registry.getButtons(), "string" == typeof items && (items = items.split(/[ ,]/)), 
        Tools$4.each(items, function(item) {
            function bindSelectorChanged() {
                var selection = editor.selection;
                item.settings.stateSelector && selection.selectorChanged(item.settings.stateSelector, function(state) {
                    item.active(state);
                }, !0), item.settings.disabledStateSelector && selection.selectorChanged(item.settings.disabledStateSelector, function(state) {
                    item.disabled(state);
                });
            }
            "|" === item ? buttonGroup = null : (buttonGroup || (buttonGroup = {
                type: "buttongroup",
                items: []
            }, toolbarItems.push(buttonGroup)), buttons[item] && ((item = "function" == typeof (item = buttons[item]) ? item() : item).type = item.type || "button", 
            item.size = size, item = Factory.create(item), buttonGroup.items.push(item), 
            editor.initialized ? bindSelectorChanged() : editor.on("init", bindSelectorChanged)));
        }), {
            type: "toolbar",
            layout: "flow",
            items: toolbarItems
        };
    }
    function movePanelTo(panel, pos) {
        panel.moveTo(pos.left, pos.top);
    }
    function userConstrain(handler, x, y, elementRect, contentAreaRect, panelRect) {
        return panelRect = toClientRect({
            x: x,
            y: y,
            w: panelRect.w,
            h: panelRect.h
        }), panelRect = handler ? handler({
            elementRect: toClientRect(elementRect),
            contentAreaRect: toClientRect(contentAreaRect),
            panelRect: panelRect
        }) : panelRect;
    }
    var Registry = {
        getButtons: function() {
            return buttons;
        },
        getMenuItems: function() {
            return menuItems;
        },
        getSidebars: function() {
            return sidebars;
        },
        getContextToolbars: function() {
            return contextToolbars;
        },
        addButton: function(name, settings) {
            (settings = "function" == typeof settings ? settings() : settings).text || settings.icon || (settings.icon = name), 
            buttons = buttons || {}, settings.tooltip = settings.tooltip || settings.title, 
            buttons[name] = settings;
        },
        addMenuItem: function(name, settings) {
            "function" == typeof settings && (settings = settings()), (menuItems = menuItems || {})[name] = settings;
        },
        addContextToolbar: function(predicate, items) {
            var selector;
            "string" == typeof predicate && (selector = predicate, predicate = function(elm) {
                return DOMUtils$5.DOM.is(elm, selector);
            }), (contextToolbars = contextToolbars || []).push({
                id: Uuid_uuid("mcet"),
                predicate: predicate,
                items: items
            });
        },
        addSidebar: function(name, settings) {
            "function" == typeof settings && (settings = settings()), (sidebars = sidebars || []).push({
                name: name,
                settings: settings
            });
        },
        addContextMenu: function(name, predicate) {
            var selector;
            "string" == typeof predicate && (selector = predicate, predicate = function(elm) {
                return DOMUtils$5.DOM.is(elm, selector) ? name : "";
            }), contextMenu[name] = predicate;
        },
        getContextMenu: function() {
            return contextMenu;
        }
    }, Tools$4 = tinymce.util.Tools, Toolbar_createToolbar = createToolbar, Toolbar_createToolbars = function(editor, size) {
        var toolbars = [];
        if (Tools$4.each(function(editor) {
            var toolbar = editor.getParam("toolbar");
            return !1 === toolbar ? [] : Tools$5.isArray(toolbar) ? Tools$5.grep(toolbar, function(toolbar) {
                return 0 < toolbar.length;
            }) : getIndexedToolbars(editor.settings, "undo redo | bold italic | alignleft aligncenter alignright alignjustify | bullist numlist outdent indent | link image");
        }(editor), function(toolbar) {
            (toolbar = toolbar) && toolbars.push(createToolbar(editor, toolbar, size));
        }), toolbars.length) return {
            type: "panel",
            layout: "stack",
            classes: "toolbar-grp",
            ariaRoot: !0,
            ariaRemember: !0,
            items: toolbars
        };
    }, android = tinymce.dom.DOMUtils, Rect = tinymce.geom.Rect, Delay = tinymce.util.Delay, Tools$3 = tinymce.util.Tools, DOM$3 = android.DOM, toClientRect = function(geomRect) {
        return {
            left: geomRect.x,
            top: geomRect.y,
            width: geomRect.w,
            height: geomRect.h,
            right: geomRect.x + geomRect.w,
            bottom: geomRect.y + geomRect.h
        };
    }, getContextToolbars = function() {
        return Registry.getContextToolbars() || [];
    }, ContextToolbars_addContextualToolbars = function(editor) {
        function reposition(match, shouldShow) {
            var panel, relRect, testPositions, panelRect, contentAreaRect, delta, handler = editor.getParam("inline_toolbar_position_handler");
            editor.removed || (match && match.toolbar.panel ? (testPositions = [ "bc-tc", "tc-bc", "tl-bl", "bl-tl", "tr-br", "br-tr" ], 
            panel = match.toolbar.panel, shouldShow && panel.show(), shouldShow = getElementRect(match.element), 
            panelRect = DOM$3.getRect(panel.getEl()), contentAreaRect = DOM$3.getRect(editor.getContentAreaContainer() || editor.getBody()), 
            delta = UiContainer_getUiContainerDelta(panel) || {
                x: 0,
                y: 0
            }, shouldShow.x += delta.x, shouldShow.y += delta.y, panelRect.x += delta.x, 
            panelRect.y += delta.y, contentAreaRect.x += delta.x, contentAreaRect.y += delta.y, 
            "inline" !== DOM$3.getStyle(match.element, "display", !0) && (delta = match.element.getBoundingClientRect(), 
            shouldShow.w = delta.width, shouldShow.h = delta.height), editor.inline || (contentAreaRect.w = editor.getDoc().documentElement.offsetWidth), 
            editor.selection.controlSelection.isResizable(match.element) && shouldShow.w < 25 && (shouldShow = Rect.inflate(shouldShow, 0, 8)), 
            delta = Rect.findBestRelativePosition(panelRect, shouldShow, contentAreaRect, testPositions), 
            shouldShow = Rect.clamp(shouldShow, contentAreaRect), delta ? (relRect = Rect.relativePosition(panelRect, shouldShow, delta), 
            movePanelTo(panel, userConstrain(handler, relRect.x, relRect.y, shouldShow, contentAreaRect, panelRect))) : (contentAreaRect.h += panelRect.h, 
            (shouldShow = Rect.intersect(contentAreaRect, shouldShow)) ? (delta = Rect.findBestRelativePosition(panelRect, shouldShow, contentAreaRect, [ "bc-tc", "bl-tl", "br-tr" ])) ? (relRect = Rect.relativePosition(panelRect, shouldShow, delta), 
            movePanelTo(panel, userConstrain(handler, relRect.x, relRect.y, shouldShow, contentAreaRect, panelRect))) : movePanelTo(panel, userConstrain(handler, shouldShow.x, shouldShow.y, shouldShow, contentAreaRect, panelRect)) : panel.hide()), 
            function(panel, relPos, predicate) {
                relPos = relPos ? relPos.substr(0, 2) : "", Tools$3.each({
                    t: "down",
                    b: "up"
                }, function(cls, pos) {
                    panel.classes.toggle("arrow-" + cls, predicate(pos, relPos.substr(0, 1)));
                }), Tools$3.each({
                    l: "left",
                    r: "right"
                }, function(cls, pos) {
                    panel.classes.toggle("arrow-" + cls, predicate(pos, relPos.substr(1, 1)));
                });
            }(panel, delta, function(pos1, pos2) {
                return pos1 === pos2;
            })) : Tools$3.each(getContextToolbars(), function(toolbar) {
                toolbar.panel && toolbar.panel.hide();
            }));
        }
        function showContextToolbar(match) {
            var panel;
            match.toolbar.panel ? match.toolbar.panel.show() : (panel = Factory.create({
                type: "floatpanel",
                role: "dialog",
                classes: "tinymce tinymce-inline arrow",
                ariaLabel: "Inline toolbar",
                layout: "flex",
                autohide: !1,
                autofix: !0,
                fixed: !0,
                items: Toolbar_createToolbar(editor, match.toolbar.items),
                oncancel: function() {
                    editor.focus();
                }
            }), UiContainer_setUiContainer(editor, panel), function(panel) {
                var reposition_1, uiContainer_1;
                scrollContainer || (reposition_1 = repositionHandler(!0), uiContainer_1 = UiContainer_getUiContainer(panel), 
                scrollContainer = editor.selection.getScrollContainer() || editor.getWin(), 
                DOM$3.bind(scrollContainer, "scroll", reposition_1), DOM$3.bind(uiContainer_1, "scroll", reposition_1), 
                editor.on("remove", function() {
                    DOM$3.unbind(scrollContainer, "scroll", reposition_1), DOM$3.unbind(uiContainer_1, "scroll", reposition_1);
                }));
            }(panel), (match.toolbar.panel = panel).renderTo().reflow()), reposition(match);
        }
        function hideAllContextToolbars() {
            Tools$3.each(getContextToolbars(), function(toolbar) {
                toolbar.panel && toolbar.panel.hide();
            });
        }
        function findFrontMostMatch(targetElm) {
            for (var y, toolbars = getContextToolbars(), parentsAndSelf = editor.$(targetElm).parents().add(targetElm), i = parentsAndSelf.length - 1; 0 <= i; i--) for (y = toolbars.length - 1; 0 <= y; y--) if (toolbars[y].predicate(parentsAndSelf[i])) return {
                toolbar: toolbars[y],
                element: parentsAndSelf[i]
            };
            return null;
        }
        var scrollContainer, getElementRect = function(elm) {
            var pos = DOM$3.getPos(editor.getContentAreaContainer()), elm = editor.dom.getRect(elm), root = editor.dom.getRoot();
            return "BODY" === root.nodeName && (elm.x -= root.ownerDocument.documentElement.scrollLeft || root.scrollLeft, 
            elm.y -= root.ownerDocument.documentElement.scrollTop || root.scrollTop), 
            elm.x += pos.x, elm.y += pos.y, elm;
        }, repositionHandler = function(show) {
            return function() {
                Delay.requestAnimationFrame(function() {
                    editor.selection && reposition(findFrontMostMatch(editor.selection.getNode()), show);
                });
            };
        };
        editor.on("click keyup focus setContent ObjectResized", function(e) {
            "setcontent" === e.type && !e.selection || Delay.setEditorTimeout(editor, function() {
                var match = findFrontMostMatch(editor.selection.getNode());
                hideAllContextToolbars(), match && showContextToolbar(match);
            });
        }), editor.on("blur hide contextmenu", hideAllContextToolbars), editor.on("ObjectResizeStart", function() {
            var match = findFrontMostMatch(editor.selection.getNode());
            match && match.toolbar.panel && match.toolbar.panel.hide();
        }), editor.on("ResizeEditor ResizeWindow", repositionHandler(!0)), editor.on("nodeChange", repositionHandler(!1)), 
        editor.on("remove", function() {
            Tools$3.each(getContextToolbars(), function(toolbar) {
                toolbar.panel && toolbar.panel.remove();
            });
        }), editor.shortcuts.add("ctrl+F9", "", function() {
            var match = findFrontMostMatch(editor.selection.getNode());
            match && match.toolbar.panel && match.toolbar.panel.items()[0].focus();
        });
    };
    const Env = tinymce.Env, DOMUtils$3 = tinymce.dom.DOMUtils, Tools$2 = tinymce.util.Tools, DOM$2 = DOMUtils$3.DOM;
    function getSize(elm) {
        return {
            width: elm.clientWidth,
            height: elm.clientHeight
        };
    }
    function resizeTo(editor, width, height) {
        var containerElm = editor.getContainer(), iframeElm = editor.getContentAreaContainer().firstChild, containerSize = getSize(containerElm), iframeSize = getSize(iframeElm);
        null !== width && (width = Math.max(editor.getParam("min_width", 100, "number"), width), 
        width = Math.min(editor.getParam("max_width", 65535, "number"), width), 
        DOM$1.setStyle(containerElm, "width", width + (containerSize.width - iframeSize.width))), 
        height = Math.max(editor.getParam("min_height", 100, "number"), height), 
        height = Math.min(editor.getParam("max_height", 65535, "number"), height), 
        DOM$1.setStyle(iframeElm, "height", height), Events.fireResizeEditor(editor);
    }
    var ContextMenu_addContextMenu = function(editor) {
        var menu, visibleState, contextmenuNeverUseNative = editor.settings.contextmenu_never_use_native;
        return !Env.android && !Env.ios && (!1 !== editor.settings.contextmenu ? (editor.on("contextmenu", function(e) {
            if (!function(e) {
                return e.ctrlKey && !contextmenuNeverUseNative;
            }(e)) {
                if (editor.editorManager.setActive(editor), editor.selection.getBookmark(), 
                e.preventDefault(), menu) menu.show(); else {
                    const node = editor.selection.getNode(), contextMenuItems = Registry.getContextMenu(), menuItems = Registry.getMenuItems();
                    let items = [];
                    Tools$2.each(contextMenuItems, function(predicate, name) {
                        predicate = predicate(node);
                        if (!predicate) return !0;
                        "string" == typeof predicate && (predicate = predicate.split(/[ ,]/)), 
                        Tools$2.each(predicate, function(name) {
                            var item;
                            menuItems[name] && (item = menuItems[name], (item = "|" == name ? {
                                text: name
                            } : item).shortcut = "", items.push(item));
                        });
                    });
                    for (var i = 0; i < items.length; i++) "|" != items[i].text || 0 !== i && i != items.length - 1 || items.splice(i, 1);
                    (menu = Factory.create("menu", {
                        items: items,
                        context: "contextmenu",
                        classes: "contextmenu"
                    }).renderTo()).on("hide", function(e) {
                        e.control === this && (visibleState = !1);
                    }), editor.on("remove", function() {
                        menu.remove(), menu = null;
                    });
                }
                var pos = {
                    x: e.pageX,
                    y: e.pageY
                };
                editor.inline || ((pos = DOM$2.getPos(editor.getContentAreaContainer())).x += e.clientX, 
                pos.y += e.clientY), menu.moveTo(pos.x, pos.y), visibleState = !0;
            }
        }), {
            isContextMenuVisible: function() {
                return !0 === visibleState;
            }
        }) : void 0);
    }, Tools$1 = tinymce.util.Tools, defaultMenus = {
        file: {
            title: "File",
            items: "newdocument restoredraft | print"
        },
        edit: {
            title: "Edit",
            items: "undo redo | cut copy paste pastetext | selectall"
        },
        view: {
            title: "View",
            items: "visualaid visualchars visualblocks | preview fullscreen"
        },
        insert: {
            title: "Insert",
            items: "image link media template codesample inserttable | charmap hr | pagebreak nonbreaking anchor | insertdatetime"
        },
        format: {
            title: "Format",
            items: "bold italic underline strikethrough superscript subscript codeformat | removeformat"
        },
        tools: {
            title: "Tools",
            items: "spellchecker"
        },
        table: {
            title: "Table"
        },
        help: {
            title: "Help"
        }
    }, createMenuItem = function(menuItems, name) {
        return "|" == name ? {
            text: "|"
        } : menuItems[name];
    }, Menubar_createMenuButtons = function(editor) {
        var name, menuButtons = [], settings = editor.settings, defaultMenuBar = [];
        if (settings.menu) for (name in settings.menu) defaultMenuBar.push(name); else for (name in defaultMenus) defaultMenuBar.push(name);
        for (var enabledMenuNames = "string" == typeof settings.menubar ? settings.menubar.split(/[ ,]/) : defaultMenuBar, menuItems = editor.theme.getMenuItems(), i = 0; i < enabledMenuNames.length; i++) {
            var menu = enabledMenuNames[i];
            (menu = function(editorMenuItems, settings, context) {
                var menuButton, menu, menuItems, isUserDefined, removedMenuItems = Tools$1.makeMap((settings.removed_menuitems || "").split(/[ ,]/));
                if (settings.menu ? (menu = settings.menu[context], isUserDefined = !0) : menu = defaultMenus[context], 
                menu) {
                    menuButton = {
                        text: menu.title
                    }, menuItems = [], Tools$1.each((menu.items || "").split(/[ ,]/), function(item) {
                        createMenuItem(editorMenuItems, item) && !removedMenuItems[item] && (menuItems.push(createMenuItem(editorMenuItems, item)), 
                        removedMenuItems[item] = {});
                    }), isUserDefined || Tools$1.each(editorMenuItems, function(menuItem, name) {
                        if (removedMenuItems[name]) return !0;
                        menuItem.context == context && ("before" == menuItem.separator && menuItems.push({
                            text: "|"
                        }), menuItem.prependToContext ? menuItems.unshift(menuItem) : menuItems.push(menuItem), 
                        "after" == menuItem.separator) && menuItems.push({
                            text: "|"
                        });
                    });
                    for (var i = 0; i < menuItems.length; i++) "|" != menuItems[i].text || 0 !== i && i != menuItems.length - 1 || menuItems.splice(i, 1);
                    if (menuButton.menu = menuItems, !menuButton.menu.length) return null;
                }
                return menuButton;
            }(menuItems, editor.settings, menu)) && menuButtons.push(menu);
        }
        return menuButtons;
    }, DOM$1 = tinymce.dom.DOMUtils.DOM, Resize_resizeTo = resizeTo, Resize_resizeBy = function(editor, dw, dh) {
        var elm = editor.getContentAreaContainer();
        resizeTo(editor, elm.clientWidth + dw, elm.clientHeight + dh);
    }, Tools = tinymce.util.Tools, trigger = function(sidebar, panel, callbackName) {
        var elm, sidebar = sidebar.settings[callbackName];
        sidebar && sidebar((elm = panel.getEl("body"), {
            element: function() {
                return elm;
            }
        }));
    }, hidePanels = function(name, container, sidebars) {
        Tools.each(sidebars, function(sidebar) {
            var panel = container.items().filter("#" + sidebar.name)[0];
            panel && panel.visible() && sidebar.name !== name && (trigger(sidebar, panel, "onhide"), 
            panel.visible(!1));
        });
    }, deactivateButtons = function(toolbar) {
        toolbar.items().each(function(ctrl) {
            ctrl.active(!1);
        });
    }, findSidebar = function(sidebars, name) {
        return Tools.grep(sidebars, function(sidebar) {
            return sidebar.name === name;
        })[0];
    }, Sidebar = {
        hasSidebar: function(editor) {
            return !!editor.sidebars && 0 < editor.sidebars.length;
        },
        createSidebar: function(editor) {
            return {
                type: "panel",
                name: "sidebar",
                layout: "stack",
                classes: "sidebar",
                items: [ {
                    type: "toolbar",
                    layout: "stack",
                    classes: "sidebar-toolbar",
                    items: Tools.map(editor.sidebars, function(sidebar) {
                        var settings = sidebar.settings;
                        return {
                            type: "button",
                            icon: settings.icon,
                            image: settings.image,
                            tooltip: settings.tooltip,
                            onclick: function(editor, name, sidebars) {
                                return function(e) {
                                    var e = e.control, container = e.parents().filter("panel")[0], panel = container.find("#" + name)[0], sidebar = findSidebar(sidebars, name);
                                    hidePanels(name, container, sidebars), deactivateButtons(e.parent()), 
                                    panel && panel.visible() ? (trigger(sidebar, panel, "onhide"), 
                                    panel.hide(), e.active(!1)) : (panel ? panel.show() : (panel = Factory.create({
                                        type: "container",
                                        name: name,
                                        layout: "stack",
                                        classes: "sidebar-panel",
                                        html: ""
                                    }), container.prepend(panel), trigger(sidebar, panel, "onrender")), 
                                    trigger(sidebar, panel, "onshow"), e.active(!0)), 
                                    Events.fireResizeEditor(editor);
                                };
                            }(editor, sidebar.name, editor.sidebars)
                        };
                    })
                } ]
            };
        }
    }, SkinLoaded_fireSkinLoaded = function(editor) {
        function done() {
            editor._skinLoaded = !0, Events.fireSkinLoaded(editor);
        }
        return function() {
            editor.initialized ? done() : editor.on("init", done);
        };
    }, DOM = tinymce.dom.DOMUtils.DOM, editArea = function() {
        return {
            type: "panel",
            name: "iframe",
            layout: "stack",
            classes: "edit-area",
            html: ""
        };
    }, Iframe_render = function(editor, theme, args) {
        !1 === isSkinDisabled(editor) && args.skinUiCss ? DOM.styleSheetLoader.load(args.skinUiCss, SkinLoaded_fireSkinLoaded(editor)) : SkinLoaded_fireSkinLoaded(editor)(), 
        panel = theme.panel = Factory.create({
            type: "panel",
            role: "application",
            classes: "tinymce",
            style: "visibility: hidden",
            layout: "stack",
            items: [ {
                type: "container",
                classes: "top-part",
                items: [ !1 === function(editor) {
                    return !1 !== getMenubar(editor);
                }(editor) ? null : {
                    type: "menubar",
                    items: Menubar_createMenuButtons(editor)
                }, Toolbar_createToolbars(editor, getToolbarSize(editor)) ]
            }, Sidebar.hasSidebar(editor) ? function(editor) {
                return {
                    type: "panel",
                    layout: "stack",
                    classes: "edit-aria-container",
                    items: [ editArea(), Sidebar.createSidebar(editor) ]
                };
            }(editor) : editArea() ]
        }), UiContainer_setUiContainer(editor, panel), "none" !== getResize(editor) && (resizeHandleCtrl = {
            type: "resizehandle",
            direction: getResize(editor),
            onResizeStart: function() {
                var elm = editor.getContentAreaContainer().firstChild;
                startSize = {
                    width: elm.clientWidth,
                    height: elm.clientHeight
                };
            },
            onResize: function(e) {
                "both" === getResize(editor) ? Resize_resizeTo(editor, startSize.width + e.deltaX, startSize.height + e.deltaY) : Resize_resizeTo(editor, null, startSize.height + e.deltaY);
            }
        }), editor.getParam("statusbar", !0, "boolean") && panel.add({
            type: "panel",
            name: "statusbar",
            classes: "statusbar",
            layout: "flow",
            ariaRoot: !0,
            items: [ {
                type: "elementpath",
                editor: editor
            }, resizeHandleCtrl, null ]
        }), Events.fireBeforeRenderUI(editor), editor.on("SwitchMode", function(panel) {
            return function(e) {
                panel.find("*").disabled("readonly" === e.mode);
            };
        }(panel)), panel.renderBefore(args.targetNode).reflow();
        var panel, startSize, theme = panel.find("#iframe")[0].getEl(), resizeHandleCtrl = panel.getEl();
        return args.width && DOM.setStyle(resizeHandleCtrl, "width", args.width), 
        args.height && DOM.setStyle(theme, "height", args.height), editor.getParam("readonly", !1, "boolean") && editor.setMode("readonly"), 
        editor.on("remove", function() {
            panel.remove(), panel = null;
        }), A11y_addKeys(editor, panel), ContextToolbars_addContextualToolbars(editor), 
        ContextMenu_addContextMenu(editor), {
            iframeContainer: theme,
            editorContainer: resizeHandleCtrl
        };
    }, DOMUtils = tinymce.dom.DOMUtils, Inline_render = function(editor, theme, args) {
        function show() {
            panel && (panel.show(), reposition(), DOM.addClass(editor.getBody(), "mce-edit-focus"));
        }
        function hide() {
            panel && (panel.hide(), FloatPanel.hideAll(), DOM.removeClass(editor.getBody(), "mce-edit-focus"));
        }
        function render() {
            panel ? panel.visible() || show() : (panel = theme.panel = Factory.create({
                type: inlineToolbarContainer ? "panel" : "floatpanel",
                role: "application",
                classes: "tinymce tinywfe-inline",
                layout: "flex",
                autohide: !1,
                autofix: !0,
                fixed: function(inlineToolbarContainer, editor) {
                    return !(!inlineToolbarContainer || editor.settings.ui_container);
                }(inlineToolbarContainer, editor),
                border: 1,
                items: [ Toolbar_createToolbars(editor, getToolbarSize(editor)) ]
            }), UiContainer_setUiContainer(editor, panel), Events.fireBeforeRenderUI(editor), 
            (inlineToolbarContainer ? panel.renderTo(inlineToolbarContainer) : panel.renderTo()).reflow(), 
            A11y_addKeys(editor, panel), show(), ContextToolbars_addContextualToolbars(editor), 
            editor.on("nodeChange", reposition), editor.on("ResizeWindow", reposition), 
            editor.on("activate", show), editor.on("deactivate", hide), editor.nodeChanged());
        }
        var panel, inlineToolbarContainer, DOM = DOMUtils.DOM, fixedToolbarContainer = editor.getParam("fixed_toolbar_container"), reposition = (fixedToolbarContainer && (inlineToolbarContainer = DOM.select(fixedToolbarContainer)[0]), 
        function() {
            var body, bodyPos, scrollContainer, deltaX, deltaY;
            panel && panel.moveRel && panel.visible() && !panel._fixed && (scrollContainer = editor.selection.getScrollContainer(), 
            body = editor.getBody(), deltaY = deltaX = 0, scrollContainer && (bodyPos = DOM.getPos(body), 
            scrollContainer = DOM.getPos(scrollContainer), deltaX = Math.max(0, scrollContainer.x - bodyPos.x), 
            deltaY = Math.max(0, scrollContainer.y - bodyPos.y)), panel.fixed(!1).moveRel(body, editor.rtl ? [ "tr-br", "br-tr" ] : [ "tl-bl", "bl-tl", "tr-br" ]).moveBy(deltaX, deltaY));
        });
        return editor.settings.content_editable = !0, editor.on("focus", function() {
            !1 === isSkinDisabled(editor) && args.skinUiCss ? DOM.styleSheetLoader.load(args.skinUiCss, render, render) : render();
        }), editor.on("blur hide", hide), editor.on("remove", function() {
            panel && (panel.remove(), panel = null);
        }), !1 === isSkinDisabled(editor) && args.skinUiCss ? DOM.styleSheetLoader.load(args.skinUiCss, SkinLoaded_fireSkinLoaded(editor)) : SkinLoaded_fireSkinLoaded(editor)(), 
        {};
    }, ProgressState_setup = function(editor, theme) {
        var throbber;
        editor.on("ProgressState", function(e) {
            throbber = throbber || new Throbber(e.parent || theme.panel.getEl("body")), 
            e.state ? throbber.show(e.time) : throbber.hide();
        });
    }, Render_renderUI = function(editor, theme, args) {
        var elm = editor.getElement(), settings = editor.settings, w = settings.width || elm.style.width || "100%", h = settings.height || elm.style.height || elm.offsetHeight, settings = settings.min_height || 100, re = /^[0-9\.]+(|px)$/i, re = (re.test("" + w) && (w = Math.max(parseInt(w, 10), 100)), 
        re.test("" + h) && (h = Math.max(parseInt(h, 10), settings)), args = args || {
            targetNode: elm,
            width: w,
            height: h
        }, function(editor) {
            var settings = editor.settings, skin = settings.skin, settings = settings.skin_url;
            return !1 !== skin && (skin = skin || "modern", settings = settings ? editor.documentBaseURI.toAbsolute(settings) : EditorManager.baseURL + "/skins/" + skin), 
            settings;
        }(editor));
        return re && (args.skinUiCss = re + "/skin.min.css", editor.contentCSS.push(re + "/content" + (editor.inline ? ".inline" : "") + ".min.css")), 
        ProgressState_setup(editor, theme), (editor.getParam("inline", !1, "boolean") ? Inline_render : Iframe_render)(editor, theme, args);
    };
    function NotificationManagerImpl(editor) {
        var getEditorContainer = function(editor) {
            return editor.inline ? editor.getElement() : editor.getContentAreaContainer();
        };
        return {
            open: function(args, closeCallback) {
                var args = Tools$6.extend(args, {
                    maxWidth: (args = getEditorContainer(editor), funcs.getSize(args).width)
                }), notif = new Notification(args);
                return 0 < (notif.args = args).timeout && (notif.timer = setTimeout(function() {
                    notif.close(), closeCallback();
                }, args.timeout)), notif.on("close", function() {
                    closeCallback();
                }), notif.renderTo(), notif;
            },
            close: function(notification) {
                notification.close();
            },
            reposition: function(notifications) {
                !function(notifications) {
                    Tools$6.each(notifications, function(notification) {
                        notification.moveTo(0, 0);
                    });
                }(notifications), function(notifications) {
                    var firstItem, container;
                    0 < notifications.length && (firstItem = notifications.slice(0, 1)[0], 
                    container = getEditorContainer(editor), firstItem.moveRel(container, "tc-tc"), 
                    Tools$6.each(notifications, function(notification, index) {
                        0 < index && notification.moveRel(notifications[index - 1].getEl(), "bc-tc");
                    }));
                }(notifications);
            },
            getArgs: function(notification) {
                return notification.args;
            }
        };
    }
    var each = Tools$6.each, trim = Tools$6.trim, queryParts = "source protocol authority userInfo user password host port relative path directory file query anchor".split(" "), DEFAULT_PORTS = {
        ftp: 21,
        http: 80,
        https: 443,
        mailto: 25
    };
    function URI(url, settings) {
        var baseUri, baseUrl, isProtocolRelative, self = this;
        url = trim(url), baseUri = (settings = self.settings = settings || {}).base_uri, 
        /^([\w\-]+):([^\/]{2})/i.test(url) || /^\s*#/.test(url) ? self.source = url : (isProtocolRelative = 0 === url.indexOf("//"), 
        0 !== url.indexOf("/") || isProtocolRelative || (url = (baseUri && baseUri.protocol || "http") + "://mce_host" + url), 
        /^[\w\-]*:?\/\//.test(url) || (baseUrl = settings.base_uri ? settings.base_uri.path : new URI(document.location.href).directory, 
        url = "" === settings.base_uri.protocol ? "//mce_host" + self.toAbsPath(baseUrl, url) : (url = /([^#?]*)([#?]?.*)/.exec(url), 
        (baseUri && baseUri.protocol || "http") + "://mce_host" + self.toAbsPath(baseUrl, url[1]) + url[2])), 
        url = url.replace(/@@/g, "(mce_at)"), url = /^(?:(?![^:@]+:[^:@\/]*@)([^:\/?#.]+):)?(?:\/\/)?((?:(([^:@\/]*):?([^:@\/]*))?@)?([^:\/?#]*)(?::(\d*))?)(((\/(?:[^?#](?![^?#\/]*\.[^?#\/.]+(?:[?#]|$)))*\/?)?([^?#\/]*))(?:\?([^#]*))?(?:#(.*))?)/.exec(url), 
        each(queryParts, function(v, i) {
            i = (i = url[i]) && i.replace(/\(mce_at\)/g, "@@");
            self[v] = i;
        }), baseUri && (self.protocol || (self.protocol = baseUri.protocol), self.userInfo || (self.userInfo = baseUri.userInfo), 
        self.port || "mce_host" !== self.host || (self.port = baseUri.port), self.host && "mce_host" !== self.host || (self.host = baseUri.host), 
        self.source = ""), isProtocolRelative && (self.protocol = ""));
    }
    URI.prototype = {
        setPath: function(path) {
            path = /^(.*?)\/?(\w+)?$/.exec(path), this.path = path[0], this.directory = path[1], 
            this.file = path[2], this.source = "", this.getURI();
        },
        toRelative: function(uri) {
            var tu, uu;
            return "./" === uri ? uri : "mce_host" != (uri = new URI(uri, {
                base_uri: this
            })).host && this.host != uri.host && uri.host || this.port != uri.port || this.protocol != uri.protocol && "" !== uri.protocol ? uri.getURI() : (tu = this.getURI()) == (uu = uri.getURI()) || "/" == tu.charAt(tu.length - 1) && tu.substr(0, tu.length - 1) == uu ? tu : (uu = this.toRelPath(this.path, uri.path), 
            uri.query && (uu += "?" + uri.query), uri.anchor && (uu += "#" + uri.anchor), 
            uu);
        },
        toAbsolute: function(uri, noHost) {
            return (uri = new URI(uri, {
                base_uri: this
            })).getURI(noHost && this.isSameOrigin(uri));
        },
        isSameOrigin: function(uri) {
            if (this.host == uri.host && this.protocol == uri.protocol) {
                if (this.port == uri.port) return !0;
                var defaultPort = DEFAULT_PORTS[this.protocol];
                if (defaultPort && (this.port || defaultPort) == (uri.port || defaultPort)) return !0;
            }
            return !1;
        },
        toRelPath: function(base, path) {
            var items, i, l, breakPoint = 0, out = "";
            if (base = (base = base.substring(0, base.lastIndexOf("/"))).split("/"), 
            items = path.split("/"), base.length >= items.length) for (i = 0, l = base.length; i < l; i++) if (i >= items.length || base[i] != items[i]) {
                breakPoint = i + 1;
                break;
            }
            if (base.length < items.length) for (i = 0, l = items.length; i < l; i++) if (i >= base.length || base[i] != items[i]) {
                breakPoint = i + 1;
                break;
            }
            if (1 === breakPoint) return path;
            for (i = 0, l = base.length - (breakPoint - 1); i < l; i++) out += "../";
            for (i = breakPoint - 1, l = items.length; i < l; i++) out += i != breakPoint - 1 ? "/" + items[i] : items[i];
            return out;
        },
        toAbsPath: function(base, path) {
            var i, nb = 0, o = [], tr = /\/$/.test(path) ? "/" : "";
            for (base = base.split("/"), path = path.split("/"), each(base, function(k) {
                k && o.push(k);
            }), base = o, i = path.length - 1, o = []; 0 <= i; i--) 0 !== path[i].length && "." !== path[i] && (".." === path[i] ? nb++ : 0 < nb ? nb-- : o.push(path[i]));
            return 0 !== (base = (i = base.length - nb) <= 0 ? o.reverse().join("/") : base.slice(0, i).join("/") + "/" + o.reverse().join("/")).indexOf("/") && (base = "/" + base), 
            tr && base.lastIndexOf("/") !== base.length - 1 && (base += tr), base;
        },
        getURI: function(noProtoHost) {
            var s;
            return this.source && !noProtoHost || (s = "", noProtoHost || (this.protocol ? s += this.protocol + "://" : s += "//", 
            this.userInfo && (s += this.userInfo + "@"), this.host && (s += this.host), 
            this.port && (s += ":" + this.port)), this.path && (s += this.path), 
            this.query && (s += "?" + this.query), this.anchor && (s += "#" + this.anchor), 
            this.source = s), this.source;
        }
    }, URI.parseDataUri = function(uri) {
        var type, matches;
        return uri = decodeURIComponent(uri).split(","), {
            type: type = (matches = /data:([^;]+)/.exec(uri[0])) ? matches[1] : type,
            data: uri[1]
        };
    }, URI.getDocumentBaseUrl = function(loc) {
        loc = 0 !== loc.protocol.indexOf("http") && "file:" !== loc.protocol ? loc.href : loc.protocol + "//" + loc.host + loc.pathname;
        return /^[^:]+:\/\/\/?[^\/]+\//.test(loc) && (loc = loc.replace(/[\?#].*$/, "").replace(/[\/\\][^\/]+$/, ""), 
        /[\/\\]$/.test(loc) || (loc += "/")), loc;
    };
    var noop = function() {};
    function theme(editor) {
        function addButton(name, settings) {
            return Registry.addButton(name, settings);
        }
        return {
            renderUI: function(args) {
                return Render_renderUI(editor, theme, args);
            },
            resizeTo: function(w, h) {
                return Resize_resizeTo(editor, w, h);
            },
            resizeBy: function(dw, dh) {
                return Resize_resizeBy(editor, dw, dh);
            },
            getNotificationManagerImpl: function() {
                return NotificationManagerImpl(editor);
            },
            getWindowManagerImpl: function() {
                return function(editor) {
                    var messageEvent;
                    return {
                        open: function(args, params, closeCallback) {
                            var win, isSupportedMessage, isCustomMessage, handleMessage, iframeUri, iframeDomain;
                            return args.title = args.title || " ", args.url && (args.width = parseInt(args.width || 320, 10), 
                            args.height = parseInt(args.height || 240, 10)), args.body && (args.items = {
                                defaults: args.defaults,
                                type: args.bodyType || "form",
                                items: args.body,
                                data: args.data,
                                callbacks: args.commands
                            }), args.url || args.buttons || (args.buttons = [ {
                                text: "Ok",
                                subtype: "primary",
                                onclick: function() {
                                    win.find("form")[0].submit();
                                }
                            }, {
                                text: "Cancel",
                                onclick: function() {
                                    win.close();
                                }
                            } ]), (win = new Window(args)).on("close", function() {
                                window.removeEventListener("message", messageEvent), 
                                messageEvent = null, closeCallback(win);
                            }), args.data && !args.url && win.on("postRender", function() {
                                this.find("*").each(function(ctrl) {
                                    var name = ctrl.name();
                                    name in args.data && ctrl.value(args.data[name]);
                                });
                            }), args.url && (isSupportedMessage = function(data) {
                                return Tools$6.is(data, "object") && -1 !== [ "insertContent", "setContent", "execCommand", "close" ].indexOf(data.mceAction);
                            }, isCustomMessage = function(data) {
                                return !isSupportedMessage(data) && Tools$6.is(data, "object") && Tools$6.is(data.mceAction);
                            }, handleMessage = function(data) {
                                switch (data.mceAction) {
                                  case "insertContent":
                                    editor.insertContent(data.content);
                                    break;

                                  case "setContent":
                                    editor.setContent(data.content);
                                    break;

                                  case "execCommand":
                                    editor.execCommand(data.cmd, !1, data.value);
                                    break;

                                  case "close":
                                    win.close();
                                }
                            }, iframeUri = new URI(args.url, {
                                base_uri: new URI(window.location.href)
                            }), iframeDomain = iframeUri.protocol + "://" + iframeUri.host + (iframeUri.port ? ":" + iframeUri.port : ""), 
                            win.on("postRender", function() {
                                var ifr = this.getEl("ifr");
                                ifr.onload = function() {
                                    ifr.contentWindow.postMessage(params || {}, iframeDomain);
                                };
                            }), messageEvent || (messageEvent = function(e) {
                                iframeUri.isSameOrigin(new URI(e.origin)) && (e = e.data, 
                                isSupportedMessage(e) ? handleMessage(e) : isCustomMessage(e) && args.onMessage && args.onMessage(e));
                            }, window.addEventListener("message", messageEvent))), 
                            win = win.renderTo();
                        },
                        alert: function(message, choiceCallback, closeCallback) {
                            var win;
                            return choiceCallback = choiceCallback || noop, closeCallback = closeCallback || noop, 
                            (win = MessageBox.alert(message, function() {
                                choiceCallback();
                            })).on("close", function() {
                                closeCallback(win);
                            }), win;
                        },
                        confirm: function(message, choiceCallback, closeCallback) {
                            var win;
                            return choiceCallback = choiceCallback || noop, closeCallback = closeCallback || noop, 
                            (win = MessageBox.confirm(message, function(state) {
                                choiceCallback(state);
                            })).on("close", function() {
                                closeCallback(win);
                            }), win;
                        },
                        close: function(win) {
                            win.close();
                        },
                        getParams: function(win) {
                            return win.params;
                        },
                        setParams: function(win, params) {
                            win.params = params;
                        }
                    };
                }(editor);
            },
            addButton: addButton,
            addMenuButton: function(name, settings) {
                return settings.type = settings.type || "menubutton", addButton(name, settings);
            },
            addSplitButton: function(name, settings) {
                return settings.type = settings.type || "splitbutton", addButton(name, settings);
            },
            addMenuItem: function(name, settings) {
                return Registry.addMenuItem(name, settings);
            },
            addContextToolbar: function(predicate, items) {
                return Registry.addContextToolbar(predicate, items);
            },
            addContextMenu: function(name, predicate) {
                return Registry.addContextMenu(name, predicate);
            },
            getButtons: function() {
                return Registry.getButtons();
            },
            getMenuItems: function() {
                return Registry.getMenuItems();
            },
            getContextMenu: function() {
                return Registry.getContextMenu();
            },
            init: function(editor, url, $) {
                return Init.init(editor, url, $);
            },
            prefix: "wfe"
        };
    }
    var ThemeApi_get = theme;
    mac(), gecko(tinymce), tinymce.ThemeManager.add("modern", function(editor) {
        return editor.on("init", function() {
            editor.dispatch("SkinLoaded");
        }), ThemeApi_get(editor);
    });
}();