/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) 2017. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr - https://www.wp-pluginsck.com
 */

function TCK_WidgetAnimationsEnable() {
	$ck('.widgetrow[data-name="animations"]').attr('data-enabled', '1');
	$ck('#widgetsElements .widget[data-name="animations"]').attr('data-enabled', '1');
	$ck('.widgetrow[data-name="animations"] .widgetedit').trigger('click');
}

function TCK_WidgetAnimationsDisable() {
	$ck('.widgetrow[data-name="animations"]').attr('data-enabled', '0');
	$ck('#widgetsElements .widget[data-name="animations"]').attr('data-enabled', '0');
}

function TCK_WidgetAnimationsAddActions() {
	$ck('#widgetedition .datarow.widgetanimations').find('input,select').each(function() {
		$ck(this).change(function() {
			TCK_WidgetAnimationsSetOptions(this);
		});
	});
}

function TCK_WidgetAnimationsEdit(btn) {
	
	$ck('#widgetedition').empty();
	ckAfterWidgetEditionDisplay(); // needed for system actions, to add the back button

	var blocsList = new Array();
	$ck('#body .ckbloc').not('.logobloc').each(function() {
		var bloc = new Object();
		bloc['id'] = this.id;
		var prefix = this.className.indexOf('wrapper') !== -1 ? 'body' : 'bloc';
		var dataTarget = $ck('#widgetsElements').find('[data-name="animations"] [data-id="' + this.id + '"]');

		bloc['class'] = this.className;
		bloc['enabled'] = $ck(this).attr('data-class') && $ck(this).attr('data-class').indexOf('animations') !== -1 ? '1' : '0';
		bloc['animdur'] = dataTarget.attr('data-animdur') ? dataTarget.attr('data-animdur') : '';
		bloc['animdelay'] = dataTarget.attr('data-animdelay') ? dataTarget.attr('data-animdelay') : '';
		bloc['animfade'] = dataTarget.attr('data-animfade') ? dataTarget.attr('data-animfade') : '';
		bloc['animmove'] = dataTarget.attr('data-animmove') ? dataTarget.attr('data-animmove') : '';
		bloc['animmovedir'] = dataTarget.attr('data-animmovedir') ? dataTarget.attr('data-animmovedir') : '';
		bloc['animrot'] = dataTarget.attr('data-animrot') ? dataTarget.attr('data-animrot') : '';
		bloc['animrotrad'] = dataTarget.attr('data-animrotrad') ? dataTarget.attr('data-animrotrad') : '';
		bloc['animscale'] = dataTarget.attr('data-animscale') ? dataTarget.attr('data-animscale') : '';
		bloc['animmovedist'] = dataTarget.attr('data-animmovedist') ? dataTarget.attr('data-animmovedist') : '';
		bloc['animreplay'] = dataTarget.attr('data-animreplay') ? dataTarget.attr('data-animreplay') : '';
		blocsList.push(bloc);
	});
	var myurl = TEMPLATECREATORCK_ADMIN_URL + "&task=ajaxCallWidgetAction&" + CKTOKEN;
	$ck.ajax({
		type: "POST",
		url: myurl,
		data: {
			name: 'animations',
			func: 'listOptions',
			blocsList: JSON.stringify(blocsList)
		}
	}).done(function(code) {
		$ck('#widgetedition').append(code);
		ckInitModalPopup();
		TCK_WidgetAnimationsAddActions();
	}).fail(function() {
		alert(Joomla.JText._('CK_FAILED', 'Failed'));
	});
}

function TCK_WidgetAnimationsToggle(btn) {
	// set the parallax background option on the selected block
	var rowData = getRowDataFromBtn(btn);
	var bloc = $ck('#' + rowData.attr('data-id'));
	if ($ck(btn).hasClass('ckbutton-danger')) {
		$ck(btn).removeClass('ckbutton-danger').addClass('ckbutton-success').text('ON');
		dataClass = 'animations';
		if (bloc.attr('data-class') && bloc.attr('data-class').indexOf('animations') === -1) {
			if (bloc.attr('data-class')) {
				dataClass = bloc.attr('data-class') + ' animations';
			} else {
				dataClass = 'animations';
			}
		}
		rowData.attr('data-enabled', '1');
		bloc.attr('data-class', dataClass);
//		bloc.attr('data-class', dataClass).attr('data-animations', '1');
		TCK_WidgetAnimationsSetOptions(btn);
	} else {
		$ck(btn).removeClass('ckbutton-success').addClass('ckbutton-danger').text('OFF');
		if (bloc.attr('data-class')) {
			dataClass = bloc.attr('data-class').replace('animations', '').trim();
		} else {
			dataClass = '';
		}
		rowData.attr('data-enabled', '0');
		bloc.attr('data-class', dataClass).removeAttr('data-animations');
		$ck('#widgetsElements').find('[data-name="animations"] [data-id="' + rowData.attr('data-id') + '"]').remove();
	}
}

function TCK_WidgetAnimationsSetOptions(btn) {
	var rowData = getRowDataFromBtn(btn);
	var blocid = rowData.attr('data-id');
	var bloc = $ck('#' + blocid);
	var dataTarget = $ck('#widgetsElements').find('[data-name="animations"] .widgetdata [data-id="' + rowData.attr('data-id') + '"]');
	if (! dataTarget.length && rowData.attr('data-enabled') == '1') {
		$ck('#widgetsElements').find('[data-name="animations"] .widgetdata').append('<div data-id="' + rowData.attr('data-id') + '"></div>');
		dataTarget = $ck('#widgetsElements').find('[data-name="animations"] [data-id="' + rowData.attr('data-id') + '"]');
	}
	dataTarget.attr('data-animdur', rowData.find('.animdur').val());
	dataTarget.attr('data-animdelay', rowData.find('.animdelay').val());
	dataTarget.attr('data-animfade', rowData.find('.animfade').val());
	dataTarget.attr('data-animmove', rowData.find('.animmove').val());
	dataTarget.attr('data-animmovedir', rowData.find('.animmovedir').val());
	dataTarget.attr('data-animrot', rowData.find('.animrot').val());
	dataTarget.attr('data-animrotrad', rowData.find('.animrotrad').val());
	dataTarget.attr('data-animscale', rowData.find('.animscale').val());
	dataTarget.attr('data-animmovedist', rowData.find('.animmovedist').val());
	dataTarget.attr('data-animreplay', rowData.find('.animreplay').val());
	
	dataTarget.attr('data-direction', rowData.find('.parallaxdirection').val());
	if(! rowData.find('.parallaxspeed').val()) rowData.find('.parallaxspeed').val('5');
	dataTarget.attr('data-speed', rowData.find('.parallaxspeed').val());
}

function getRowDataFromBtn(btn) {
	var rowData = $ck($ck(btn).parents('.datarow')[0]);
	return rowData;
}

function TCK_WidgetAnimationsFilterByType(btn) {
	if (btn == 'search') return TCK_WidgetAnimationsFilterBySearch();

	var type = $ck(btn).attr('data-type');
	var filter;
	switch (type) {
		case 'wrapper' :
			filter = '[data-type~="wrapper"]';
			break;
		case 'row' :
			filter = '[data-type~="ckrow"]';
			break;
		case 'flexiblemodules' :
			filter = '[data-type~="flexiblemodules"]';
			break;
		case 'singlemodule' :
			filter = '[data-type~="singlemodule"]';
			break;
		case 'horiznav' :
			filter = '[data-type~="horiznav"]';
			break;
		case 'activeonly' :
			filter = '[data-enabled="1"]';
			break;
		case 'all' :
		default :
			filter = '';
			break;
	}
	$ck('#widgetedition .datarow').hide();
	if (filter) {
		$ck('#widgetedition .datarow' + filter).show();
	} else {
		$ck('#widgetedition .datarow').show();
		$ck('#widgettopbarfilter').val('');
	}
}

function TCK_WidgetAnimationsFilterBySearch() {
	var filter = $ck('#widgettopbarfilter').val();
	$ck('#widgetedition .datarow').hide();
	if (filter) {
		$ck('#widgetedition .datarow[data-id*="' + filter + '"]').show();
	} else {
		$ck('#widgetedition .datarow').show();
	}
}