<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');
?>
<div id="restoreModalck" style="display: none;">
	<div class="cktitle"><?php echo TCK_Text::_('CK_RESTORE') ?></div>
	<div class="">
		<?php
		if ($this->item->id) {
			$path = TEMPLATECREATORCK_PATH . '/backup/' . $this->item->id . '_bak';
			if (TCK_Folder::exists($path)) {
				$files = TCK_Folder::files($path, '.tck3', false, false);
				if (count($files)) {
					natsort($files);
					$i = 0;
					foreach ($files as $file) {
						if (stristr($file, 'locked_')) {
							$backupdate = str_replace('locked_' . $this->item->id . '_', '', TCK_File::stripExt($file));
							$isLocked = true;
						} else if (stristr($file, 'backup_' . $this->item->id)) {
							$backupdate = str_replace('backup_' . $this->item->id . '_', '', TCK_File::stripExt($file));
							$isLocked = false;
						} else {
							continue;
						}

						$date = DateTime::createFromFormat('d-m-Y-G-i-s', $backupdate);
						$formattedDate = $date->format('d-M-Y H:i:s');
						$lockedIcon = $isLocked ? '<span class="fack fack-lock"></span>' : '<span class="fack fack-unlock"></span>';

						echo '<div class="restoreline restoreline' . $i . ' clearfix">
									<div>
										<span class="label label-info">' . $formattedDate . '</span>
									</div>
									<div>
										<a class="btn" href="javascript:void(0)" onclick="ckDoRestoration(' . $this->item->id . ', \'' . $backupdate . '\', ' . $i . ')">
											<span class="fack fack-reply">&nbsp;</span>' . TCK_Text::_('CK_DO_RESTORATION') . '
										</a>
										<span class="processing" style="width:16px;margin:0 3px;display:inline-block;">&nbsp;</span>
									</div>
								</div>';
						$i++;
					}
				} else {
					echo '<div class="alert">' . TCK_Text::_('CK_NO_RESTORE_FILE_FOUND') . '</div>';
				}
			} else {
				echo '<div class="alert">' . TCK_Text::_('CK_NO_RESTORE_FILE_FOUND') . '</div>';
			}
		}
		?>
	</div>
</div>