<?php
/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) since 2011. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// no direct access
defined('TCK_LOADED') or die;

// remove header
header_remove('ETag');
header_remove('Pragma');
header_remove('Cache-Control');
header_remove('Last-Modified');
header_remove('Expires');

// set header
header('Expires: Thu, 1 Jan 1970 00:00:00 GMT');
header("Last-Modified: " . gmdate("D, d M Y H:i:s") . " GMT");
header('Cache-Control: no-store, no-cache, must-revalidate, max-age=0');
header('Cache-Control: post-check=0, pre-check=0',false);
header('Pragma: no-cache');

$doc = \Joomla\CMS\Factory::getDocument();
include_once TEMPLATECREATORCK_PATH . '/helpers/ckwidgets.php';
include_once TEMPLATECREATORCK_PATH . '/helpers/ckmodules.php';
include_once TEMPLATECREATORCK_PATH . '/helpers/ckframework.php';
?>
<!DOCTYPE html>
<html xmlns="https://www.w3.org/1999/xhtml" xml:lang="<?php echo $doc->language; ?>" lang="<?php echo $doc->language; ?>" dir="<?php echo $doc->direction; ?>">
<head>
<meta http-equiv="expires" content="Sun, 01 Jan 2014 00:00:00 GMT"/>
<meta http-equiv="pragma" content="no-cache" />
<?php include_once TEMPLATECREATORCK_PATH . '/helpers/defines.js.php'; ?>
<?php include('edit_head.php'); ?>
</head>
<body class="cktemplatecreatorinterface <?php echo ($this->item->htmlcode ? '' : 'ckfirststep') ?>">
<?php 
// manage the information messages
TemplateckHelper::displayMessages();
// BC compatibility
if (empty($this->item->modules)) $this->item->modules = '';
// loads the needed files for the widgets
// check first that the widgets are defined, because of retrocompatibility
// get the list of widgets
$widgets = CKWidgets::loadWidgets();
// get the widgets states from the template settings
if (empty($this->item->widgets)) {
	$this->item->widgets = '';
} else {
	$itemWidgets = ($this->item->widgets); // DO NOT use stripslashes here for joomla
	$itemWidgets = str_replace('|lt|', '<', $itemWidgets);
	$itemWidgets = str_replace('|gt|', '>', $itemWidgets);
	$itemWidgets = json_decode(str_replace('|qq|', '"', $itemWidgets));
}
?>
<div id="widgetsElements">
<?php 
if (count($widgets)) {
	foreach ($widgets as $widget) {
		$state = '0';
		$data = '';
		if (isset($itemWidgets->{$widget->name})) {
			$state = $widget->installed ? $itemWidgets->{$widget->name}->enabled : '0';
			$data = $itemWidgets->{$widget->name}->data;
		}
?>
		<div class="widget" data-name="<?php echo $widget->name ?>" data-enabled="<?php echo $state ?>">
			<div class="widgetdata"><?php echo $data ?></div>
		</div>
<?php
	}
}

?>
</div>
<div id="bootstrapload"><link rel="stylesheet" type="text/css" href="<?php echo TEMPLATECREATORCK_PLUGIN_URL ?>/default.css"></div>
<div id="googlefontscall"></div>
<form action="<?php echo \Joomla\CMS\Router\Route::_('index.php?option=com_templateck&view=template&task=template.edit&id=' . (int) $this->item->id); ?>" enctype="multipart/form-data" method="post" name="adminForm" id="adminForm" class="form-validate">
	<input type="hidden" name="htmlcode" id="htmlcode" value="" />
	<input type="hidden" name="stylecode" id="stylecode" value="" />
	<input type="hidden" name="htmlcode_responsive" id="htmlcode_responsive" value="<?php echo str_replace('"', '|qq|',  $this->item->htmlcode_responsive); ?>" />
	<input type="hidden" name="option" value="com_templateck" />
	<input type="hidden" name="widgets" id="widgets" value="<?php echo $this->item->widgets; ?>" />
	<input type="hidden" name="modules" id="modules" value="<?php echo $this->item->modules; ?>" />
	<input type="hidden" class="layoutfield" name="layouts[error404]" id="layouts_error404" data-type="error404" value="" />
	<input type="hidden" class="layoutfieldid" name="layoutsid[error404]" id="layoutsid_error404" data-type="error404" value="<?php echo $this->item->layouts['error404']->id; ?>" />
	<input type="hidden" name="id" value="<?php echo $this->item->id; ?>" />
	<input type="hidden" name="identifier" value="<?php echo $this->item->identifier; ?>" />
	<input type="hidden" name="task" value="" />
	<input type="hidden" name="controller" value="templateck" />
	<?php echo \Joomla\CMS\HTML\HTMLHelper::_('form.token'); ?>
	<?php include('edit_globalinfos.php'); ?>
</form>
<?php include('edit_favorites.php'); ?>
<div id="cktemplatecontainer">
	<div id="ckstylescontainer">
		<?php if (isset($this->item->stylecode)) { ?>
			<?php echo $this->item->stylecode; ?>
		<?php } ?>
	</div>
	<div id="ckhtmlcontainer" class="focusbar focus">
		<?php
		if ($this->item->htmlcode) {
			echo $this->item->htmlcode;
		} else {
			include('edit_modeles.php');
		}
		?>
	</div>
	<div class="clr"></div>
	<?php include('edit_stylescreator.php'); ?>
</div>
<div class="clr"></div>
<?php //include('edit_package.php'); ?>
<?php include('edit_restore.php'); ?>
<?php include('edit_replacecolors.php'); ?>
<?php include('edit_wizard.php'); ?>
<div id="ckheader" class="headerck">
	<div class="ckheaderlogo"><a href="https://www.template-creator.com" target="_blank"><img width="161" height="36" src="<?php echo TEMPLATECREATORCK_MEDIA_URI ?>/images/logo_templateck.png" /></a></div>
	<div class="ckheadername"><?php echo $this->item->name ?></div>
	<div class="ckheadermenu">
		<a href="javascript:void(0);" class="ckheadermenuitem ckcancel" onclick="ckSubmitButtonExit()">
			<span class="fack fack-times"></span>
			<span class="ckheadermenuitemtext"><?php echo TCK_Text::_('CK_EXIT') ?></span>
		</a>
		<a href="javascript:void(0);" class="ckheadermenuitem cksave" onclick="ckSubmitButtonSave()">
			<span class="fack fack-check"></span>
			<span class="ckheadermenuitemtext"><?php echo TCK_Text::_('CK_SAVE') ?></span>
		</a>
	</div>
</div>
<?php include('leftpanel.php'); ?>
<?php include('contextmenu.php'); ?>
<div class="" id="tab_customcode"></div>
<div class="" id="tab_customcss"></div>
<div id="layout_error404_html" class="ckbloc ckbloclayout">
	<?php echo ($this->item->layouts['error404']->htmlcode ? $this->item->layouts['error404']->htmlcode : '<div class="ckstyle"></div>'); ?>
</div>
<div id="ckpopup"></div>
</body>
</html>