<?php
/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');

$layout_search_options = isset($blocsbyname['ckcustomlayoutsearch']) ? $blocsbyname['ckcustomlayoutsearch'] : new stdClass();
$layout_search_options = new \Joomla\Registry\Registry($layout_search_options);

$layout_search_options_settingstext = "<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2018. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined('_JEXEC') or die;
if (! defined('TCK_SEARCH_SHOW_LABEL')) define('TCK_SEARCH_SHOW_LABEL', " . (int)$layout_search_options->get('showlabels', '1') . ");
if (! defined('TCK_SEARCH_SHOW_ICON')) define('TCK_SEARCH_SHOW_ICON', " . (int)$layout_search_options->get('showicon', '1') . ");
if (! defined('TCK_SEARCH_ICON')) define('TCK_SEARCH_ICON', '" . $layout_search_options->get('iconclass', 'icon-search') . "');
if (! defined('TCK_SEARCH_PLACEHOLDER')) define('TCK_SEARCH_PLACEHOLDER', " . (int)$layout_search_options->get('showplaceholder', '1') . ");
if (! defined('TCK_SEARCH_BUTTON_CLASS')) define('TCK_SEARCH_BUTTON_CLASS', '" . $layout_search_options->get('buttonclass', 'button btn btn-primary') . "');";

if ($joomlaversion == 'j3') {
	// copy the layouts files if not exists
	$success = array();
	$search_override_layouts_files = TCK_folder::files($additionalsPath . '/html/mod_search', '.', true, true);
	foreach ($search_override_layouts_files as $file) {
		$tfile = str_replace('\\', '/', $file);
		$tfile = str_replace(str_replace('\\', '/', $additionalsPath), '', $tfile);
		// check if the folder exists
		if (!file_exists(dirname($path . $tfile))) {
			$success['folder:' . $tfile] = TCK_Folder::create(dirname($path . $tfile));
		}
		
		// check if the file exists
		if (! file_exists($path . $tfile)) {
			$success[$tfile] = TCK_File::copy($file, $path . $tfile);
		}
	}
}

// create the settings file
$layout_search_options_settingsfile = $path . '/html/settings_search.php';
$success['settings_search.php'] = TCK_File::write($layout_search_options_settingsfile, $layout_search_options_settingstext);

if (in_array(false, $success)) {
	$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FOLDER') . ' /html/mod_search</p>';
} else {
	$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FOLDER') . ' /html/mod_search</p>';
}
$messages[] = $msg;