<?php
/**
 * @name		Template Creator CK
 * @copyright	Copyright (C) 2013. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */
// No direct access to this file
defined('TCK_LOADED') or die('Restricted access');

$layout_article_options = isset($blocsbyname['ckcustomlayoutarticle']) ? $blocsbyname['ckcustomlayoutarticle'] : new stdClass();
$layout_article_options = new \Joomla\Registry\Registry($layout_article_options);

$layout_article_options_showdetails = (int)$layout_article_options->get('showdetails', '1');
$layout_article_options_alignicons = (int)$layout_article_options->get('alignicons', '0');
$layout_article_options_showtitle = (int)$layout_article_options->get('showtitle', '1');
$layout_article_options_showicons = (int)$layout_article_options->get('showicons', '1');
$layout_article_options_showlabels = (int)$layout_article_options->get('showlabels', '1');
$layout_article_options_detailsiconhits = $layout_article_options->get('detailsiconhits', 'icon-eye-open');
$layout_article_options_detailsicondate = $layout_article_options->get('detailsicondate', 'icon-calendar');
$layout_article_options_detailsiconauthor = $layout_article_options->get('detailsiconauthor', 'icon-user');
$layout_article_options_detailsiconcategory = $layout_article_options->get('detailsiconcategory', 'icon-folder-open');
$layout_article_options_showtools = (int)$layout_article_options->get('showtools', '1');
$layout_article_options_dropdown = (int)$layout_article_options->get('dropdown', '1');
$layout_article_options_floatright = (int)$layout_article_options->get('floatright', '1');
$layout_article_options_showtoolsicons = (int)$layout_article_options->get('showtoolsicons', '1');
$layout_article_options_iconprint = $layout_article_options->get('iconprint', 'icon-print');
$layout_article_options_iconcreate = $layout_article_options->get('iconcreate', 'icon-plus');
$layout_article_options_iconemail = $layout_article_options->get('iconemail', 'icon-envelope');
$layout_article_options_titletag = $layout_article_options->get('titletag', 'h2');
$layout_article_options_imageposition = $layout_article_options->get('imageposition', 'under');


$templatecsstext .= '.tck-article-details-align-h > dd {
	display: inline-block;
	margin-right: 10px; 
}

.tck-article-tools-right {
	float: right;
}

.tck-article-tools ul:not(.dropdown-menu) li {
	display: inline-block;
}

.tck-article-pagination-prev {
	float: left;
}

.tck-article-pagination-next {
	float: right;
}
';

$layout_article_options_settingstext = "<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2018. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined('_JEXEC') or die;
if (! defined('TCK_ARTICLE_SHOW_DETAILS')) define('TCK_ARTICLE_SHOW_DETAILS', " . $layout_article_options_showdetails . ");
if (! defined('TCK_ARTICLE_DETAILS_ALIGN')) define('TCK_ARTICLE_DETAILS_ALIGN', " . $layout_article_options_alignicons . ");
if (! defined('TCK_ARTICLE_DETAILS_SHOW_TITLE')) define('TCK_ARTICLE_DETAILS_SHOW_TITLE', " . $layout_article_options_showtitle . ");
if (! defined('TCK_ARTICLE_DETAILS_SHOW_ICONS')) define('TCK_ARTICLE_DETAILS_SHOW_ICONS', " . $layout_article_options_showicons . ");
if (! defined('TCK_ARTICLE_DETAILS_SHOW_LABELS')) define('TCK_ARTICLE_DETAILS_SHOW_LABELS', " . $layout_article_options_showlabels . ");
if (! defined('TCK_ARTICLE_DETAILS_ICON_HITS')) define('TCK_ARTICLE_DETAILS_ICON_HITS', '" . $layout_article_options_detailsiconhits . "');
if (! defined('TCK_ARTICLE_DETAILS_ICON_DATE')) define('TCK_ARTICLE_DETAILS_ICON_DATE', '" . $layout_article_options_detailsicondate . "');
if (! defined('TCK_ARTICLE_DETAILS_ICON_AUTHOR')) define('TCK_ARTICLE_DETAILS_ICON_AUTHOR', '" . $layout_article_options_detailsiconauthor . "');
if (! defined('TCK_ARTICLE_DETAILS_ICON_CATEGORY')) define('TCK_ARTICLE_DETAILS_ICON_CATEGORY', '" . $layout_article_options_detailsiconcategory . "');
if (! defined('TCK_ARTICLE_DETAILS_ICON_CATEGORY_PARENT')) define('TCK_ARTICLE_DETAILS_ICON_CATEGORY_PARENT', '" . $layout_article_options_detailsiconcategory . "');
if (! defined('TCK_ARTICLE_TOOLS_DROPDOWN')) define('TCK_ARTICLE_TOOLS_DROPDOWN', " . $layout_article_options_dropdown . ");
if (! defined('TCK_ARTICLE_TOOLS_FLOAT_RIGHT')) define('TCK_ARTICLE_TOOLS_FLOAT_RIGHT', " . $layout_article_options_floatright . ");
if (! defined('TCK_ARTICLE_TOOLS_SHOW_ICONS')) define('TCK_ARTICLE_TOOLS_SHOW_ICONS', " . $layout_article_options_showtoolsicons . ");
if (! defined('TCK_ARTICLE_TOOLS_ICON_PRINT')) define('TCK_ARTICLE_TOOLS_ICON_PRINT', '" . $layout_article_options_iconprint . "');
if (! defined('TCK_ARTICLE_TOOLS_ICON_CREATE')) define('TCK_ARTICLE_TOOLS_ICON_CREATE', '" . $layout_article_options_iconcreate . "');
if (! defined('TCK_ARTICLE_TOOLS_ICON_EMAIL')) define('TCK_ARTICLE_TOOLS_ICON_EMAIL', '" . $layout_article_options_iconemail . "');
if (! defined('TCK_ARTICLE_TITLE_TAG')) define('TCK_ARTICLE_TITLE_TAG', '" . $layout_article_options_titletag . "');
if (! defined('TCK_ARTICLE_IMAGEPOSITION')) define('TCK_ARTICLE_IMAGEPOSITION', '" . $layout_article_options_imageposition . "');";

// copy the layouts files if not exists
$success = array();
$article_override_layouts_files = TCK_folder::files($additionalsPath . '/html/layouts', '.', true, true);
foreach ($article_override_layouts_files as $file) {
	$tfile = str_replace('\\', '/', $file);
	$tfile = str_replace(str_replace('\\', '/', $additionalsPath), '', $tfile);
	// check if the folder exists
	if (!file_exists(dirname($path . $tfile))) {
		$success['folder:' . $tfile] = TCK_Folder::create(dirname($path . $tfile));
	}

	// check if the file exists
//	if (! file_exists($path . $tfile)) {
		$success[$tfile] = TCK_File::copy($file, $path . $tfile);
//	}
}
// copy the article override if not exists
$article_override_content_article_file = $path . '/html/com_content/article/default.php';
// check if the folder exists
//if (!file_exists(dirname($article_override_content_article_file))) {
	$success['folder:article/default.php'] = TCK_Folder::create(dirname($article_override_content_article_file));
//}
// check if the file exists
//if (!file_exists($article_override_content_article_file)) {
	$success['article/default.php'] = TCK_file::copy($additionalsPath . '/html/com_content/article/default.php', $article_override_content_article_file);
//}

// create the settings file
$layout_article_options_settingsfile = $path . '/html/com_content/settings_article.php';
$success['settings_article.php'] = TCK_File::write($layout_article_options_settingsfile, $layout_article_options_settingstext);

if (in_array(false, $success)) {
	$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FOLDER') . ' /html/com_content</p>';
} else {
	$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FOLDER') . ' /html/com_content</p>';
}
$messages[] = $msg;


$layout_article_pagination_options_settingstext = "<?php
/**
 * @name		Template Creator CK
 * @package		com_templateck
 * @copyright	Copyright (C) 2018. All rights reserved.
 * @license		GNU General Public License version 2 or later; see LICENSE.txt
 * @author		Cedric Keiflin - https://www.template-creator.com - https://www.joomlack.fr
 */

defined('_JEXEC') or die;
if (! defined('TCK_ARTICLE_PAGINATION_SHOW_ICONS')) define('TCK_ARTICLE_PAGINATION_SHOW_ICONS', " . (int)$layout_article_options->get('iconpaginationshowicons', '1') . ");
if (! defined('TCK_ARTICLE_PAGINATION_ICON_LEFT')) define('TCK_ARTICLE_PAGINATION_ICON_LEFT', '" . $layout_article_options->get('iconpaginationleft', 'icon-chevron-left') . "');
if (! defined('TCK_ARTICLE_PAGINATION_ICON_RIGHT')) define('TCK_ARTICLE_PAGINATION_ICON_RIGHT', '" . $layout_article_options->get('iconpaginationright', 'icon-chevron-right') . "');";

if ($joomlaversion == 'j3') {
	// copy the article pagination override if not exists
	$article_override_content_pagination_file = $path . '/html/plg_content_pagenavigation/default.php';
	// check if the folder exists
	if (!file_exists(dirname($article_override_content_pagination_file))) {
		$success['folder:article/default.php'] = TCK_Folder::create(dirname($article_override_content_pagination_file));
	}
	// check if the file exists
	if (!file_exists($article_override_content_pagination_file)) {
		$success['pagination/default.php'] = TCK_file::copy($additionalsPath . '/html/plg_content_pagenavigation/default.php', $article_override_content_pagination_file);
	}
}
// create the settings file
$layout_article_pagination_options_settingsfile = $path . '/html/plg_content_pagenavigation/settings_pagination.php';
$success['settings_pagination.php'] = TCK_File::write($layout_article_pagination_options_settingsfile, $layout_article_pagination_options_settingstext);

if (in_array(false, $success)) {
	$msg = '<p class="errorck">' . TCK_Text::_('CK_ERROR_CREATING_FOLDER') . ' /html/plg_content_pagenavigation</p>';
} else {
	$msg = '<p class="successck">' . TCK_Text::_('CK_SUCCESS_CREATING_FOLDER') . ' /html/plg_content_pagenavigation</p>';
}
$messages[] = $msg;
